/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.comm;

import com.sun.javacard.debugproxy.Log;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public class EncodingUtils {
    static final byte[] JDWP_HANDSHAKE = "JDWP-Handshake".getBytes(StandardCharsets.UTF_8);
    public static final int METHOD_BASE_SHIFT = 15;
    public static final int METHOD_BASE_BITS = 98304;
    public static final int METHOD_BASE_ONE_FLAG = 2;
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 2;
    private static final EncodingUtils instance = new EncodingUtils();

    public static String readString(DataInputStream in) {
        String ret;
        try {
            int len = in.readInt();
            byte[] data = new byte[len];
            if (in.read(data) == -1) {
                throw new IOException("Read failed");
            }
            ret = new String(data, "UTF8");
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println(e);
            ret = "IndexOutOfBoundsExceptions";
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e);
            ret = "Conversion error!";
        }
        catch (IOException e) {
            System.err.println(e);
            ret = "IOExceptions";
        }
        return ret;
    }

    public static String readJDWPStringValue(DataInputStream in) {
        String ret;
        try {
            int len = in.readInt();
            byte[] data = new byte[len];
            in.readFully(data);
            char[] chars = new char[len / 2];
            int index = 0;
            for (int i = 0; i < len; i += 2) {
                short t1 = (short)(data[i] << 8);
                chars[index++] = (char)(t1 | data[i + 1] & 0xFF);
            }
            ret = new String(chars);
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println(e);
            ret = "IndexOutOfBoundsException";
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e);
            ret = "Conversion error!";
        }
        catch (IOException e) {
            System.err.println(e);
            ret = "IOException";
        }
        return ret;
    }

    public static void writeString(DataOutputStream out, String string) {
        try {
            byte[] stringBytes = string.getBytes("UTF8");
            out.writeInt(stringBytes.length);
            out.write(stringBytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot convert string to UTF8 bytes");
        }
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int copied = 0;
        while (in.available() > 0) {
            out.write(in.read());
            ++copied;
        }
        return copied;
    }

    public static byte copyByte(DataInputStream from, DataOutputStream to) throws IOException {
        byte val = from.readByte();
        to.writeByte(val);
        return val;
    }

    public static int copyIntAsByte(DataInputStream from, DataOutputStream to) throws IOException {
        int val = from.readInt();
        to.writeByte((byte)val);
        return val;
    }

    public static int copyInt(DataInputStream from, DataOutputStream to) throws IOException {
        int val = from.readInt();
        to.writeInt(val);
        return val;
    }

    public static int copyByteAsInt(DataInputStream from, DataOutputStream to) throws IOException {
        int val = from.readByte() & 0xFF;
        to.writeInt((byte)val);
        return val;
    }

    public static void copyTypeFromVmToIDE(byte expTag, DataInputStream from, DataOutputStream to) throws IOException {
        byte typeTag = from.readByte();
        if (typeTag != expTag) {
            Log.LOG(3, "Received tag [" + typeTag + "] is different from expected one [" + expTag + "]");
        }
        int value = from.readInt();
        Log.LOG(3, "copyTypeFromVmToIDE typeTag: " + typeTag + " value:" + value);
        to.writeByte(typeTag);
        switch (typeTag) {
            case 66: 
            case 90: {
                to.writeByte((byte)value);
                break;
            }
            case 83: {
                to.writeShort((short)value);
                break;
            }
            case 73: 
            case 76: 
            case 91: 
            case 115: {
                to.writeInt(value);
                break;
            }
            case 86: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + typeTag);
            }
        }
    }

    public static void copyTypeFromIDEtoVm(DataInputStream from, DataOutputStream to) throws IOException {
        int value = 0;
        byte typeTag = EncodingUtils.copyByte(from, to);
        switch (typeTag) {
            case 66: 
            case 90: {
                value = from.readByte() & 0xFFFF;
                break;
            }
            case 83: {
                value = from.readShort() & 0xFFFF;
                break;
            }
            case 73: 
            case 76: 
            case 91: {
                value = from.readInt();
                break;
            }
            case 86: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + typeTag);
            }
        }
        to.writeInt(value);
    }

    public EncodingUtils getInstance() {
        return instance;
    }

    public static int copy(InputStream in, OutputStream out, int length) throws IOException {
        int copied;
        for (copied = 0; in.available() > 0 && copied < length; ++copied) {
            out.write(in.read());
        }
        return copied;
    }
}

