/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.Apdu;
import com.sun.javacard.apduio.CadClientInterface;
import com.sun.javacard.apduio.CadT1;
import com.sun.javacard.apduio.CadTransportException;
import com.sun.javacard.apduio.ClientProtocol;
import com.sun.javacard.apduio.ClientT1Protocol;
import com.sun.javacard.apduio.T1Block;
import com.sun.javacard.apduio.T1Exception;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CadT1Client
extends CadT1
implements CadClientInterface {
    protected T1Block inBlock;
    protected T1Block outBlock;
    protected ClientProtocol protocol;

    public CadT1Client(InputStream in, OutputStream out) {
        super(in, out);
    }

    @Override
    public void exchangeApdu(Apdu apdu) throws IOException, CadTransportException {
        if (this.protocol == null) {
            throw new T1Exception(-127);
        }
        this.protocol.exchangeApdu(apdu);
    }

    @Override
    public void powerDown(boolean disconnect) throws IOException, CadTransportException {
        this.sendPowerDown();
        if (disconnect) {
            this.protocol = null;
        }
    }

    @Override
    public void powerDown() throws IOException, CadTransportException {
        this.powerDown(true);
    }

    @Override
    public byte[] powerUp() throws IOException, CadTransportException {
        this.sendPowerUp();
        byte[] atrBytes = this.retrieveATR();
        this.protocol = new ClientT1Protocol(this);
        return atrBytes;
    }
}

