/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.CadT0;
import com.sun.javacard.apduio.ServerT0Protocol;
import com.sun.javacard.apduio.T0ServerActive;
import com.sun.javacard.apduio.T0ServerClosed;
import com.sun.javacard.apduio.T0ServerState;
import com.sun.javacard.apduio.TLP224Exception;
import com.sun.javacard.apduio.TLP224Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class T0ServerOpen
extends T0ServerState {
    protected static T0ServerOpen _instance;

    private T0ServerOpen() {
    }

    static T0ServerOpen instance() {
        if (_instance == null) {
            _instance = new T0ServerOpen();
        }
        return _instance;
    }

    @Override
    int t0RcvCommand(ServerT0Protocol protocol, byte[] command) throws IOException, TLP224Exception {
        CadT0 cad = protocol.cad;
        TLP224Message tlp224Msg = protocol.tlp224Msg;
        block6: while (true) {
            tlp224Msg.dataIn = null;
            tlp224Msg.dataOut = null;
            cad.receiveTLP224Message(tlp224Msg);
            byte[] msgData = tlp224Msg.getData();
            switch (msgData[2] & 0xFF) {
                case 110: {
                    if (msgData[1] != 4) {
                        cad.statusResponse(3);
                        continue block6;
                    }
                    cad.statusResponse(0);
                    continue block6;
                }
                case 77: {
                    cad.statusResponse(0);
                    this.changeState(protocol, T0ServerClosed.instance());
                    return 1;
                }
                case 218: {
                    if ((msgData[4] & 0xF0) == 96 || (msgData[4] & 0xF0) == 144) {
                        cad.statusResponse(17);
                        continue block6;
                    }
                    if (msgData[7] != (byte)(tlp224Msg.getLength() - 9)) {
                        cad.statusResponse(26);
                        continue block6;
                    }
                    System.arraycopy(msgData, 3, command, 0, 5);
                    if (msgData[7] <= 0) break block6;
                    tlp224Msg.dataIn = new ByteArrayInputStream(msgData, 8, msgData[7]);
                    break block6;
                }
                case 219: {
                    if ((msgData[4] & 0xF0) == 96 || (msgData[4] & 0xF0) == 144) {
                        cad.statusResponse(17);
                        continue block6;
                    }
                    if (tlp224Msg.getLength() != 9) {
                        cad.statusResponse(3);
                        continue block6;
                    }
                    System.arraycopy(msgData, 3, command, 0, 5);
                    tlp224Msg.dataOut = new ByteArrayOutputStream(msgData[7]);
                    break block6;
                }
                default: {
                    cad.statusResponse(4);
                    continue block6;
                }
            }
            break;
        }
        this.changeState(protocol, T0ServerActive.instance());
        return 0;
    }

    public String toString() {
        return T0ServerState._messages.getString("state.open");
    }
}

