/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.ResourceBundle;

class T1BlockReader
implements Runnable {
    protected static ResourceBundle _messages = ResourceBundle.getBundle("com/sun/javacard/apduio/MessagesBundle");
    private static final int BLOCKPROTOCOL_OFFSET_OPCODE = 0;
    private static final int BLOCKPROTOCOL_OFFSET_LENGTH = 1;
    private static final int BLOCKPROTOCOL_OFFSET_MESSAGE = 3;
    private static final int BLOCKPROTOCOL_HEADER_SIZE = 3;
    private static final int BLOCKPROTOCOL_OVERHEAD_SIZE = 4;
    private InputStream in;
    private boolean ready = false;
    private Thread t;
    private byte[] recvBuffer = new byte[40];
    private int recvLen;
    private IOException exc;
    private boolean firstTime = true;
    private static final int FIRST_BYTE_OF_POWERUP_IN_T1 = 240;

    public T1BlockReader(Socket s) throws IOException {
        s.setTcpNoDelay(true);
        this.in = s.getInputStream();
        this.t = new Thread(this);
        this.t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                T1BlockReader t1BlockReader = this;
                synchronized (t1BlockReader) {
                    try {
                        while (this.ready) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException neverThrown) {
                        neverThrown.printStackTrace();
                    }
                    if (this.firstTime) {
                        this.recvLen = this.in.read(this.recvBuffer, 0, 1);
                        if (this.recvBuffer[0] != -16) {
                            String msg = _messages.getString("cad.3");
                            System.err.println(msg);
                            System.exit(1);
                        }
                        this.recvLen = this.in.read(this.recvBuffer, 1, 2);
                        ++this.recvLen;
                        this.firstTime = false;
                    } else {
                        this.recvLen = this.in.read(this.recvBuffer, 0, 3);
                    }
                    int maxLen = this.recvBuffer[1] << 8 | this.recvBuffer[2] & 0xFF;
                    this.recvLen += this.in.read(this.recvBuffer, 3, maxLen + 1);
                    this.ready = true;
                    this.notifyAll();
                }
            }
        }
        catch (IOException e) {
            this.exc = e;
            this.recvLen = -1;
            this.ready = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readT1Block(byte[] buffer, boolean nonBlocking) throws IOException {
        T1BlockReader t1BlockReader;
        if (!nonBlocking) {
            t1BlockReader = this;
            synchronized (t1BlockReader) {
                while (!this.ready) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ignore) {}
                }
            }
        }
        if (this.ready) {
            if (this.recvLen < 0) {
                throw this.exc;
            }
            t1BlockReader = this;
            synchronized (t1BlockReader) {
                System.arraycopy(this.recvBuffer, 0, buffer, 0, this.recvLen);
                int res = this.recvLen;
                this.ready = false;
                this.notifyAll();
                return res;
            }
        }
        return 0;
    }
}

