/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.classfile.JField;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.classfile.attributes.JAttribute;
import com.sun.javacard.classfile.attributes.JSourceFileAttr;
import com.sun.javacard.classfile.constants.JConstant;
import com.sun.javacard.classfile.constants.JConstantClass;
import com.sun.javacard.classfile.constants.JConstantPool;
import com.sun.javacard.converter.PrecheckException;
import com.sun.javacard.converter.util.Notifier;
import java.io.DataInputStream;
import java.io.IOException;

public class JClassFile
extends ClassDefinition {
    private static final int ACC_ENUM = 16384;
    private int magic;
    private int major_version;
    private int minor_version;
    private int this_class_index;
    private int super_class_index;
    private JConstantPool constant_pool;
    private int[] interface_indexes;
    private JField[] fields;
    private JMethod[] methods;
    private JAttribute[] attributes;
    private String[] interface_names;

    public int getMagic() {
        return this.magic;
    }

    public int getMajorVersion() {
        return this.major_version;
    }

    public int getMinorVersion() {
        return this.minor_version;
    }

    public String[] getInterfaceNames() {
        return this.interface_names;
    }

    public JField[] getFields() {
        return this.fields;
    }

    public JMethod[] getMethods() {
        return this.methods;
    }

    public JConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public JAttribute[] getAttributes() {
        return this.attributes;
    }

    public void resolve() throws PrecheckException {
        this.constant_pool.resolve();
        this.class_name = this.constant_pool.getConstantClass(this.this_class_index).getClassName();
        this.checkJDK50Features();
        this.super_class_name = this.super_class_index != 0 ? this.constant_pool.getConstantClass(this.super_class_index).getClassName() : null;
        this.interface_names = new String[this.interface_indexes.length];
        for (int i = 0; i < this.interface_names.length; ++i) {
            this.interface_names[i] = this.constant_pool.getConstantClass(this.interface_indexes[i]).getClassName();
        }
        for (JAttribute jAttribute : this.attributes) {
            jAttribute.resolve();
            if (!(jAttribute instanceof JSourceFileAttr)) continue;
            this.source_file_name = ((JSourceFileAttr)jAttribute).getFileName();
        }
        for (JField jField : this.fields) {
            jField.resolve();
        }
        for (JMethod jMethod : this.methods) {
            jMethod.resolve();
        }
    }

    private void checkJDK50Features() throws PrecheckException {
        for (int i = 0; i < this.constant_pool.getConstants().length; ++i) {
            String value;
            JConstant jcon = this.constant_pool.getAt(i);
            if (!(jcon instanceof JConstantClass) || !"java/lang/AssertionError".equals(value = ((JConstantClass)jcon).getClassName())) continue;
            Object[] args = new Object[]{this.class_name.replace('/', '.')};
            Notifier.error("subset.64", args);
            throw new PrecheckException();
        }
        if ((this.access_flags & 0x4000) != 0) {
            String name = this.class_name.replace('/', '.');
            int pos = name.lastIndexOf(36);
            if (pos > 0) {
                name = name.substring(0, pos);
            }
            Object[] args = new Object[]{name};
            Notifier.error("subset.65", args);
            throw new PrecheckException();
        }
    }

    public void parse(DataInputStream dis) throws IOException {
        int i;
        this.magic = dis.readInt();
        this.minor_version = dis.readUnsignedShort();
        this.major_version = dis.readUnsignedShort();
        this.constant_pool = new JConstantPool(dis.readUnsignedShort());
        this.constant_pool.parse(dis);
        this.access_flags = dis.readUnsignedShort();
        this.this_class_index = dis.readUnsignedShort();
        this.super_class_index = dis.readUnsignedShort();
        this.interface_indexes = new int[dis.readUnsignedShort()];
        for (i = 0; i < this.interface_indexes.length; ++i) {
            this.interface_indexes[i] = dis.readUnsignedShort();
        }
        this.fields = new JField[dis.readUnsignedShort()];
        for (i = 0; i < this.fields.length; ++i) {
            this.fields[i] = new JField(this.constant_pool);
            this.fields[i].parse(dis);
        }
        this.methods = new JMethod[dis.readUnsignedShort()];
        for (i = 0; i < this.methods.length; ++i) {
            this.methods[i] = new JMethod(this.constant_pool);
            this.methods[i].parse(dis);
        }
        this.attributes = new JAttribute[dis.readUnsignedShort()];
        for (i = 0; i < this.attributes.length; ++i) {
            int index = dis.readUnsignedShort();
            this.attributes[i] = JAttribute.create(this.constant_pool, index);
            this.attributes[i].parse(dis);
        }
    }

    public JField getField(String name, String descriptor) {
        for (JField element : this.fields) {
            if (!element.getFieldName().equals(name) || !element.getFieldDescriptor().equals(descriptor)) continue;
            return element;
        }
        return null;
    }

    public JMethod getMethod(String name, String descriptor) {
        for (JMethod element : this.methods) {
            if (!element.getMethodName().equals(name) || !element.getMethodDescriptor().equals(descriptor)) continue;
            return element;
        }
        return null;
    }

    public void addMethod(JMethod jm) {
        JMethod[] new_methods = new JMethod[this.methods.length + 1];
        System.arraycopy(this.methods, 0, new_methods, 0, this.methods.length);
        new_methods[this.methods.length] = jm;
        this.methods = new_methods;
    }
}

