/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cli;

import com.sun.javacard.cli.CommandOption;
import com.sun.javacard.cli.JcBasicParser;
import com.sun.javacard.tools.util.JCToolsLogger;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public abstract class SubCommand {
    public static final String SHORT_VERBOSE = "v";
    public static final String LONG_VERBOSE = "verbose";
    protected ResourceBundle resourceBundle;
    protected JCToolsLogger toolsLogger;
    protected String name;
    protected boolean verbose;
    protected CommandLine commandLine = null;
    protected Options options = new Options();
    protected String[] argumentsArray;
    protected Option[] optionsArray;

    public SubCommand(String name) {
        this.name = name;
        this.options.addOption((Option)new CommandOption(SHORT_VERBOSE, LONG_VERBOSE, false));
    }

    public void parse(String[] commandArgs) throws Exception {
        JcBasicParser parser = new JcBasicParser();
        this.commandLine = parser.parse(this.options, commandArgs);
        this.optionsArray = this.commandLine.getOptions();
        this.argumentsArray = this.commandLine.getArgs();
        for (Option option : this.optionsArray) {
            if (!option.getOpt().equals(SHORT_VERBOSE)) continue;
            this.verbose = true;
        }
    }

    public final void addOption(Option option) {
        this.options.addOption(option);
    }

    public final void addOptionGroup(OptionGroup optionGroup) {
        this.options.addOptionGroup(optionGroup);
    }

    public final void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public final void setLogger(JCToolsLogger toolsLogger) {
        this.toolsLogger = toolsLogger;
    }

    public final String getResourceString(String key) {
        return this.resourceBundle.getString(key);
    }

    public final String getFormattedResourceString(String key, Object ... values) {
        String str = this.resourceBundle.getString(key);
        return MessageFormat.format(str, values);
    }

    public final String getName() {
        return this.name;
    }

    public final void printLines(String propertyName) {
        try {
            String line = null;
            for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                try {
                    line = this.getResourceString(propertyName + "." + i);
                }
                catch (Exception e) {
                    break;
                }
                line = line.trim();
                if (line.startsWith("\"")) {
                    line = line.substring(1);
                }
                if (line.endsWith("\"")) {
                    line = line.substring(0, line.length() - 1);
                }
                System.out.println(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public final String[] getArgumentsArray() {
        return this.argumentsArray;
    }

    public final Option[] getOptionsArray() {
        return this.optionsArray;
    }

    public abstract void setup();

    public abstract int execute() throws Exception;
}

