/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.CAPUtil;
import com.sun.javacard.components.caputils.CPClassInfo;
import com.sun.javacard.components.caputils.CPClassMemberInfo;
import com.sun.javacard.components.caputils.CPInfo;
import com.sun.javacard.components.caputils.CPIntegerInfo;
import com.sun.javacard.components.caputils.CPNameAndTypeInfo;
import com.sun.javacard.components.caputils.CPUtf8Info;
import com.sun.javacard.components.caputils.CapProcessor;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.ConstantPoolComponent;
import com.sun.javacard.offcardverifier.ConstantPoolEntry;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfField;
import com.sun.javacard.offcardverifier.exportfile.EfMethod;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.util.Vector;

public class ClassConstantPool {
    public static final int CONSTANT_Class_tag = 7;
    public static final int CONSTANT_Fieldref_tag = 9;
    public static final int CONSTANT_Methodref_tag = 10;
    public static final int CONSTANT_InterfaceMethodref_tag = 11;
    public static final int CONSTANT_String_tag = 8;
    public static final int CONSTANT_Integer_tag = 3;
    public static final int CONSTANT_Float_tag = 4;
    public static final int CONSTANT_Long_tag = 5;
    public static final int CONSTANT_Double_tag = 6;
    public static final int CONSTANT_NameAndType_tag = 12;
    public static final int CONSTANT_Utf8_tag = 1;
    private EfClass exportedClass;
    private ClassDescriptor cdesc;
    private String className;
    private Vector<CPInfo> CPEntries;
    private Vector<Integer> interfaces;
    private int thisClassRefIndex;
    private int superClassRefIndex;

    public ClassConstantPool(ClassDescriptor cdesc, String clName, EfClass exportedClass) {
        this.cdesc = cdesc;
        this.className = clName;
        this.exportedClass = exportedClass;
        this.CPEntries = new Vector();
        this.interfaces = new Vector();
        this.buildConstantPool();
    }

    private int setConstantPoolEntry(CPInfo entry) {
        if (this.CPEntries.contains(entry)) {
            return this.CPEntries.indexOf(entry) + 1;
        }
        this.CPEntries.add(entry);
        return this.CPEntries.size();
    }

    private void buildConstantPool() {
        int i;
        int classRef = this.cdesc.thisClass();
        boolean isInterface = (this.cdesc.flags() & 0x40) == 64;
        this.thisClassRefIndex = this.setCPClassInfo(this.className);
        ClassInfo clInfo = Cap.getClassComponent().infoOfs(classRef);
        String superName = "java/lang/Object";
        if (!isInterface) {
            int superRef = clInfo.superclass();
            superName = CAPUtil.getRefName(superRef);
        }
        this.superClassRefIndex = this.setCPClassInfo(superName);
        int interfaceCount = isInterface ? clInfo.interfaceCount() : this.cdesc.interfaceCount();
        int fieldCount = this.cdesc.fieldCount();
        int methodCount = this.cdesc.methodCount();
        for (i = 0; i < interfaceCount; ++i) {
            int interfaceRef = isInterface ? clInfo.superinterface(i) : this.cdesc.interfaceRef(i);
            String interfaceName = CAPUtil.getRefName(interfaceRef);
            int interfaceIndex = this.setCPClassInfo(interfaceName);
            this.interfaces.add(new Integer(interfaceIndex));
        }
        for (i = 0; i < fieldCount; ++i) {
            FieldDescriptor fd = this.cdesc.fieldDescr(i);
            this.setCPEntryForField(fd);
        }
        for (i = 0; i < methodCount; ++i) {
            MethodDescriptor md = this.cdesc.methodDescr(i);
            int flags = md.flags();
            boolean isStatic = (flags & 8) != 0;
            boolean isInit = (flags & 0x80) != 0;
            this.setCPEntryForMethod(md, isStatic, isInit);
        }
    }

    private int setCPClassInfo(String clName) {
        short entryIndex = (short)this.addConstantUtf8Info(clName);
        return this.setConstantPoolEntry(new CPClassInfo(entryIndex));
    }

    private void setCPEntryForField(FieldDescriptor fd) {
        String fieldName = CAPUtil.getClassFieldName(fd, this.exportedClass);
        int numericFieldDesc = fd.type();
        String fieldDesc = CAPUtil.getFieldDescrStr((short)numericFieldDesc);
        int entryIndex = this.addClassMemberInfo(9, fieldName, fieldDesc);
    }

    private void setCPEntryForMethod(MethodDescriptor md, boolean isStatic, boolean isInit) {
        String methodName = CAPUtil.getClassMethodName(this.cdesc, md, isStatic, isInit, this.exportedClass);
        String methodDesc = CAPUtil.getMethodDescriptorString((short)md.type());
        int methodEntryIndex = this.addClassMemberInfo(10, methodName, methodDesc);
    }

    private int addClassMemberInfo(int tag, String name, String desc) {
        short descIndex;
        short nameIndex = (short)this.addConstantUtf8Info(name);
        CPNameAndTypeInfo nameAndTypeInfo = new CPNameAndTypeInfo(nameIndex, descIndex = (short)this.addConstantUtf8Info(desc));
        short nameAndTypeIndex = (short)this.setConstantPoolEntry(nameAndTypeInfo);
        CPClassMemberInfo entry = new CPClassMemberInfo(tag, (short)this.thisClassRefIndex, nameAndTypeIndex);
        int index = this.CPEntries.indexOf(entry) + 1;
        if (index <= 0) {
            index = this.setConstantPoolEntry(entry);
        }
        return index;
    }

    public int addInteger(int value) {
        CPIntegerInfo entry = new CPIntegerInfo(value);
        int index = this.CPEntries.indexOf(entry) + 1;
        if (index <= 0) {
            index = this.setConstantPoolEntry(entry);
        }
        return index;
    }

    public int addConstantUtf8Info(String value) {
        byte[] strBytes = value.getBytes();
        CPUtf8Info entry = new CPUtf8Info(strBytes, 0, (short)strBytes.length);
        int index = this.CPEntries.indexOf(entry) + 1;
        if (index <= 0) {
            index = this.setConstantPoolEntry(entry);
        }
        return index;
    }

    public int getThisClassIndex() {
        return this.thisClassRefIndex;
    }

    public int getSuperClassRefIndex() {
        return this.superClassRefIndex;
    }

    public Vector<Integer> getInterfaceRefs() {
        return this.interfaces;
    }

    public int getUtf8InfoIndex(String value) {
        byte[] strBytes = value.getBytes();
        CPUtf8Info utf8Info = new CPUtf8Info(strBytes, 0, (short)strBytes.length);
        int index = this.CPEntries.indexOf(utf8Info) + 1;
        if (index <= 0) {
            index = this.setConstantPoolEntry(utf8Info);
        }
        return index;
    }

    public short getClassRefIndex(String className) {
        short nameEntryIndex = (short)this.getUtf8InfoIndex(className);
        if (nameEntryIndex < 0) {
            return (short)this.setCPClassInfo(className);
        }
        CPClassInfo newClassInfo = new CPClassInfo(nameEntryIndex);
        int classInfoEntryIndex = this.CPEntries.indexOf(newClassInfo);
        if (classInfoEntryIndex < 0) {
            return (short)this.setConstantPoolEntry(newClassInfo);
        }
        return (short)(classInfoEntryIndex + 1);
    }

    public int getCPEntryIndexForClassMember(String className, String memberName, String memberDesc, int tag) {
        short classRefIndex = this.getClassRefIndex(className);
        int memberNameIndex = this.getUtf8InfoIndex(memberName);
        int memberDescIndex = this.getUtf8InfoIndex(memberDesc);
        int nameAndTypeIndex = this.setConstantPoolEntry(new CPNameAndTypeInfo((short)memberNameIndex, (short)memberDescIndex));
        return this.setConstantPoolEntry(new CPClassMemberInfo(tag, classRefIndex, (short)nameAndTypeIndex));
    }

    public CPInfo getConstantPoolEntryAt(int index) {
        return this.CPEntries.elementAt(index - 1);
    }

    public short getConstantPoolEntryCount() {
        return (short)this.CPEntries.size();
    }

    public int getFieldCPEntry(int capCPEntryIndex) {
        FieldDescriptor fd = null;
        String className = null;
        String fieldName = null;
        String fieldDesc = null;
        EfClass ec = null;
        EfField exportedField = null;
        ClassDescriptor cdesc = null;
        ConstantPoolEntry capCPEntry = Cap.getConstantPool().entry(capCPEntryIndex);
        boolean isStatic = capCPEntry.tag() == 5;
        boolean isExternal = false;
        if (isStatic) {
            if (!capCPEntry.isExternalStaticRef()) {
                int location;
                cdesc = Cap.getDescriptor().firstClassDescriptor();
                for (int classCount = Cap.getDescriptor().classCount(); classCount > 0 && (fd = cdesc.getFieldDescriptorForLocation(location = capCPEntry.internalStaticRef())) == null; --classCount) {
                    cdesc.next();
                }
            } else {
                isExternal = true;
                int pkgToken = capCPEntry.externalStaticRefPackageToken();
                int classToken = capCPEntry.externalStaticRefClassToken();
                int fieldToken = capCPEntry.tokenStaticRef();
                ExportFile ef = Cap.getImport().exportfileForPackageToken(pkgToken);
                ec = ef.findClassByToken((short)classToken);
                exportedField = ec.getFieldForTokenAndFlag(fieldToken, isStatic);
            }
        } else {
            int classRef = capCPEntry.classRefVirtualRef();
            int fieldToken = capCPEntry.tokenVirtualRef();
            if (Classref.isExternal(classRef)) {
                isExternal = true;
                int pkgToken = Classref.packageToken(classRef);
                ExportFile ef = Cap.getImport().exportfileForPackageToken(pkgToken);
                ec = Classref.checkExternal(classRef);
                exportedField = ec.getFieldForTokenAndFlag(fieldToken, isStatic);
            } else {
                cdesc = Classref.checkInternal(classRef);
                fd = cdesc.getFieldDescriptorForToken(fieldToken, isStatic);
            }
        }
        if (isExternal) {
            className = ec.thisName();
            fieldName = exportedField.name();
            fieldDesc = exportedField.sig();
        } else {
            className = CAPUtil.getRefName(cdesc.thisClass());
            ec = null;
            if (CapProcessor.ef != null) {
                ec = CapProcessor.ef.findClassByToken((short)cdesc.token());
            }
            fieldName = CAPUtil.getClassFieldName(fd, ec);
            fieldDesc = CAPUtil.getFieldDescrStr((short)fd.type());
        }
        return this.getCPEntryIndexForClassMember(className, fieldName, fieldDesc, 9);
    }

    public int getMethodCPEntry(int capCPEntryIndex) {
        MethodDescriptor md = null;
        String className = null;
        String methodName = null;
        String methodDesc = null;
        EfClass ec = null;
        EfMethod exportedMethod = null;
        ClassDescriptor cdesc = null;
        ConstantPoolEntry capCPEntry = Cap.getConstantPool().entry(capCPEntryIndex);
        int capCPEntryTag = capCPEntry.tag();
        boolean isStatic = capCPEntryTag == 6 || capCPEntryTag == 7;
        boolean isInit = capCPEntryTag == 4 || capCPEntryTag == 7 ? ConstantPoolComponent.methodIsInit(capCPEntryIndex) : false;
        boolean isExternal = false;
        if (isStatic) {
            if (!capCPEntry.isExternalStaticRef()) {
                int location;
                cdesc = Cap.getDescriptor().firstClassDescriptor();
                while (cdesc != null && (md = cdesc.getMethodDescriptorForLocation(location = capCPEntry.internalStaticRef())) == null) {
                    cdesc.next();
                }
            } else {
                isExternal = true;
                int pkgToken = capCPEntry.externalStaticRefPackageToken();
                int classToken = capCPEntry.externalStaticRefClassToken();
                int methodToken = capCPEntry.tokenStaticRef();
                ExportFile ef = Cap.getImport().exportfileForPackageToken(pkgToken);
                ec = ef.findClassByToken((short)classToken);
                exportedMethod = ec.getMethodForTokenAndFlag(methodToken, isStatic | isInit);
            }
        } else {
            int classRef = capCPEntry.classRefVirtualRef();
            int methodToken = capCPEntry.tokenVirtualRef();
            if (Classref.isExternal(classRef)) {
                isExternal = true;
                ec = Classref.checkExternal(classRef);
                exportedMethod = ec.getMethodForTokenAndFlag(methodToken, isStatic | isInit);
            } else if (capCPEntryTag == 4) {
                ClassInfo clInfo = Cap.getClassComponent().infoOfs(classRef);
                int superRef = clInfo.superclass();
                while (superRef != 65535) {
                    if (Classref.isExternal(superRef)) {
                        isExternal = true;
                        ec = Classref.checkExternal(superRef);
                        exportedMethod = ec.getMethodForTokenAndFlag(methodToken, false);
                        if (exportedMethod == null) {
                            exportedMethod = ec.getMethodFromSupers(methodToken, false);
                            ec = exportedMethod.getParentClass();
                        }
                    } else {
                        cdesc = Classref.checkInternal(superRef);
                        md = cdesc.getMethodDescriptorForToken(methodToken, isStatic, isInit);
                        if (md == null) {
                            clInfo = Cap.getClassComponent().infoOfs(superRef);
                            superRef = clInfo.superclass();
                            continue;
                        }
                    }
                    break;
                }
            } else {
                cdesc = Classref.checkInternal(classRef);
                md = cdesc.getMethodDescriptorForToken(methodToken, isStatic, isInit);
            }
        }
        if (isExternal) {
            className = ec.thisName();
            methodName = exportedMethod.name();
            methodDesc = exportedMethod.sig();
        } else {
            className = CAPUtil.getRefName(cdesc.thisClass());
            ec = null;
            if (CapProcessor.ef != null) {
                ec = CapProcessor.ef.findClassByToken((short)cdesc.token());
            }
            methodName = CAPUtil.getClassMethodName(cdesc, md, isStatic, isInit, ec);
            methodDesc = CAPUtil.getMethodDescriptorString((short)md.type());
        }
        return this.getCPEntryIndexForClassMember(className, methodName, methodDesc, 10);
    }

    public int getInterfaceMethodRef(int capCPIndex, int token) {
        ConstantPoolEntry capCPEntry = Cap.getConstantPool().entry(capCPIndex);
        int interfaceRef = capCPEntry.classRef();
        String interfaceName = CAPUtil.getRefName(interfaceRef);
        String methodName = null;
        String methodDesc = null;
        if (Classref.isExternal(interfaceRef)) {
            EfClass ec = Classref.checkExternal(interfaceRef);
            EfMethod[] methods = ec.methods;
            for (int i = 0; i < methods.length; ++i) {
                if (methods[i].token != token) continue;
                methodName = methods[i].name();
                methodDesc = methods[i].sig();
                break;
            }
        } else {
            ClassDescriptor cdesc = Classref.checkInternal(interfaceRef);
            EfClass ec = Classref.toExportClass(interfaceRef);
            MethodDescriptor md = Methodref.virtualMethodDescriptor(cdesc, token);
            methodName = CAPUtil.getClassMethodName(cdesc, md, false, false, ec);
            methodDesc = CAPUtil.getMethodDescriptorString(md.type());
        }
        short interfaceRefIndex = this.getClassRefIndex(interfaceName);
        int nameIndex = this.getUtf8InfoIndex(methodName);
        int descIndex = this.getUtf8InfoIndex(methodDesc);
        int nameAndTypeIndex = this.setConstantPoolEntry(new CPNameAndTypeInfo((short)nameIndex, (short)descIndex));
        return this.setConstantPoolEntry(new CPClassMemberInfo(11, interfaceRefIndex, (short)nameAndTypeIndex));
    }
}

