/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.Converter;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.OptionParser;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.cap.CapgenWrapper;
import com.sun.javacard.jcasm.cap.SIOProxyClassesGen;
import com.sun.javacard.packager.Main;
import com.sun.javacard.tools.util.JCToolsLogger;
import com.sun.javacard.util.FileUtils;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

public class ConverterHarness {
    private ConversionProfile conversion_profile;
    private boolean delateJCA = false;
    private Converter _converter = null;
    private boolean capGenError = false;
    private JCToolsLogger toolsLogger;
    private String msgFileName;

    ConverterHarness(String msgFileName) {
        this.toolsLogger = JCToolsLogger.getLogger("com.sun.javacard.converter", msgFileName);
        this.msgFileName = msgFileName;
    }

    public static void main(String[] args) {
        ConverterHarness converter_harness = new ConverterHarness("com.sun.javacard.converter.MessagesBundle");
        converter_harness.convert(args, null);
    }

    public static void startConversion(String[] args, Hashtable<String, File> exportFilesHS) {
        ConverterHarness converter_harness = new ConverterHarness("com/sun/javacard/converter/MessagesBundle");
        converter_harness.convert(args, exportFilesHS);
    }

    private void convert(String[] args, Hashtable<String, File> exportFilesHS) {
        try {
            this.conversion_profile = new ConversionProfile();
            OptionParser option_parser = new OptionParser(args, this.conversion_profile);
            option_parser.parse();
            this.toolsLogger.info(ToolsVersion.getToolName(1) + ToolsVersion.getVersion(1), new Object[0]);
            this.toolsLogger.info(ToolsVersion.getCopyrightBanner(), new Object[0]);
            this.generateJCA(exportFilesHS);
            try {
                this.generateCAP();
            }
            catch (Exception e) {
                this.capGenError = true;
            }
            this.cleanup();
            if (this.conversion_profile.sign) {
                String cap_file_name = Names.getCAPFileName(this.conversion_profile.package_profile.package_name);
                File output_file = new File(this.conversion_profile.getFullOutputPath(), cap_file_name);
                String[] argv = new String[]{"sign", "-K", this.conversion_profile.keystore, "-A", this.conversion_profile.alias, "-P", this.conversion_profile.passkey, "-S", this.conversion_profile.storepass, output_file.toString()};
                boolean b = Main.invokePackager(argv);
                if (!b) {
                    System.exit(1);
                }
            }
            Object[] arguments = new Object[]{String.valueOf(Notifier.getErrorCount() + Globals.errors), String.valueOf(Notifier.getWarningCount() + Globals.warnings)};
            this.toolsLogger = JCToolsLogger.getLogger("com.sun.javacard.converter", this.msgFileName);
            this.toolsLogger.info("out.1", arguments);
            if (this.capGenError) {
                System.exit(1);
            }
            File outFolder = new File(this.conversion_profile.output_dir);
            boolean outAndKeepAreSame = false;
            boolean classesAndOutAreSame = this.conversion_profile.class_root.equals(this.conversion_profile.output_dir);
            if (this.conversion_profile.keepDir != null) {
                File keepFolder = new File(this.conversion_profile.keepDir);
                keepFolder.mkdirs();
                if (outFolder.equals(keepFolder)) {
                    outAndKeepAreSame = true;
                } else {
                    this.copyJavaFiles(outFolder, keepFolder);
                }
            }
            this.cleanupTempFiles();
        }
        catch (Throwable t) {
            this.toolsLogger.severe("error.1", new Object[0]);
            t.printStackTrace();
            System.exit(1);
        }
    }

    private void copyJavaFiles(File dir1, File dir2) throws Exception {
        try {
            dir1 = dir1.getCanonicalFile().getAbsoluteFile();
            dir2 = dir2.getCanonicalFile().getAbsoluteFile();
            String dirPath = dir1.getAbsolutePath();
            String path = null;
            for (String fileName : SIOProxyClassesGen.sourceFilesToDelete) {
                File jf = new File(fileName);
                jf = jf.getCanonicalFile().getAbsoluteFile();
                path = jf.getAbsolutePath();
                if ((path = path.substring(dirPath.length())).startsWith(File.separator)) {
                    path = path.substring(1);
                }
                FileUtils.copyFile(jf, new File(dir2, path));
            }
        }
        catch (Exception ex) {
            throw new Exception("Unable to keep java files. Error: " + ex.getMessage());
        }
    }

    private void deleteTempFiles(Vector<String> filesToDelete) {
        block0: for (String fileName : filesToDelete) {
            File f = new File(fileName);
            if (!f.exists()) continue;
            f.delete();
            File parent = f.getParentFile();
            while (parent != null && parent.listFiles() != null && parent.listFiles().length == 0) {
                File grandParent = parent.getParentFile();
                if (grandParent == null) {
                    parent.delete();
                    continue block0;
                }
                parent.delete();
                parent = grandParent;
            }
        }
    }

    private void cleanupTempFiles() {
        this.deleteTempFiles(SIOProxyClassesGen.classFilesToDelete);
        File outFolder = new File(this.conversion_profile.output_dir);
        File keepFolder = null;
        if (this.conversion_profile.keepDir != null) {
            keepFolder = new File(this.conversion_profile.keepDir);
        }
        if (!outFolder.equals(keepFolder)) {
            this.deleteTempFiles(SIOProxyClassesGen.sourceFilesToDelete);
        }
    }

    private void generateJCA(Hashtable<String, File> exportFilesHS) {
        try {
            Converter converter = new Converter(this.conversion_profile, exportFilesHS);
            converter.convert();
            this._converter = converter;
        }
        catch (ConverterException ce) {
            Notifier.newLine();
            Object[] arguments = new Object[]{String.valueOf(Notifier.getErrorCount()), String.valueOf(Notifier.getWarningCount())};
            this.toolsLogger.info("out.1", arguments);
            System.exit(1);
        }
        catch (ConverterInternalError cie) {
            this.toolsLogger.severe("error.1", new Object[0]);
            cie.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            this.toolsLogger.severe("error.1", new Object[0]);
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void generateCAP() throws Exception {
        if ((this.conversion_profile.output & 1) != 0) {
            CapgenWrapper.generateCAPFile(this.conversion_profile, this._converter);
        }
    }

    private void cleanup() {
        if (this.capGenError) {
            File thisExpFile = new File(this.conversion_profile.getFullOutputPath(), Names.getExportFileName(this.conversion_profile.package_profile.package_name));
            thisExpFile.delete();
            this.conversion_profile.deleteJCA = true;
        }
        if (this.conversion_profile.deleteJCA) {
            String jca_file_name = Names.getJcaFileName(this.conversion_profile.package_profile.package_name);
            File jca_file = new File(this.conversion_profile.getFullOutputPath(), jca_file_name);
            jca_file.delete();
            if (this.conversion_profile.debug) {
                String debug_component_name = new String("debug.cap");
                File debug_component_file = new File(this.conversion_profile.getFullOutputPath(), debug_component_name);
                debug_component_file.delete();
            }
        }
    }
}

