/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.instructions.JInstruction;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.BCConversionTable;
import com.sun.javacard.converter.converters.InstrArithmeticConverter;
import com.sun.javacard.converter.converters.InstrArrayConverter;
import com.sun.javacard.converter.converters.InstrBranchConverter;
import com.sun.javacard.converter.converters.InstrClassRefConverter;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstrExceptionConverter;
import com.sun.javacard.converter.converters.InstrFieldRefConverter;
import com.sun.javacard.converter.converters.InstrIncrementConverter;
import com.sun.javacard.converter.converters.InstrLoadConstConverter;
import com.sun.javacard.converter.converters.InstrLoadConverter;
import com.sun.javacard.converter.converters.InstrMethodRefConverter;
import com.sun.javacard.converter.converters.InstrReturnConverter;
import com.sun.javacard.converter.converters.InstrStackConverter;
import com.sun.javacard.converter.converters.InstrStoreConverter;
import com.sun.javacard.converter.converters.InstrSwitchConverter;
import com.sun.javacard.converter.converters.InstrTypeConversionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.OperandStack;
import com.sun.javacard.jcfile.instructions.JcInstruction;

abstract class InstructionConverter {
    protected JInstruction java_instr;
    protected JcInstruction jc_instr;
    protected OperandStack operand_stack;
    protected MethodConverter method_converter;
    protected InstrContainer instr_container;

    public InstructionConverter(InstrContainer instr_container, MethodConverter method_converter) {
        this.instr_container = instr_container;
        this.java_instr = instr_container.getJInstr();
        this.operand_stack = instr_container.getOperandStack();
        this.method_converter = method_converter;
    }

    public abstract JcInstruction convert() throws Exception;

    public static final InstructionConverter create(InstrContainer instr_container, MethodConverter method_converter) {
        int java_opcode = instr_container.getJInstr().getOpcode();
        int converter_type = BCConversionTable.getConverterType(java_opcode);
        switch (converter_type) {
            case 0: {
                return new InstrArithmeticConverter(instr_container, method_converter);
            }
            case 1: {
                return new InstrArrayConverter(instr_container, method_converter);
            }
            case 2: {
                return new InstrClassRefConverter(instr_container, method_converter);
            }
            case 3: {
                return new InstrMethodRefConverter(instr_container, method_converter);
            }
            case 4: {
                return new InstrFieldRefConverter(instr_container, method_converter);
            }
            case 5: {
                return new InstrLoadConstConverter(instr_container, method_converter);
            }
            case 6: {
                return new InstrLoadConverter(instr_container, method_converter);
            }
            case 7: {
                return new InstrStoreConverter(instr_container, method_converter);
            }
            case 8: {
                return new InstrBranchConverter(instr_container, method_converter);
            }
            case 9: {
                return new InstrIncrementConverter(instr_container, method_converter);
            }
            case 10: {
                return new InstrReturnConverter(instr_container, method_converter);
            }
            case 11: {
                return new InstrStackConverter(instr_container, method_converter);
            }
            case 12: {
                return new InstrSwitchConverter(instr_container, method_converter);
            }
            case 13: {
                return new InstrTypeConversionConverter(instr_container, method_converter);
            }
            case 14: {
                return new InstrExceptionConverter(instr_container, method_converter);
            }
        }
        throw new ConverterInternalError();
    }
}

