/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.ClassIdentifier;
import com.sun.javacard.jcasm.ConstantPool;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.RemoteMethodInfo;
import com.sun.javacard.jcasm.SignaturePool;
import com.sun.javacard.jcasm.SortableVector;
import com.sun.javacard.jcasm.SymbolTable;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JCPackage {
    protected String inputSpec;
    protected PackageIdentifier packageIdentifier;
    protected String name;
    protected int line;
    protected Vector<PackageIdentifier> importVector;
    protected Vector<AppletDeclarator> appletVector;
    protected ConstantPool constantPool;
    protected SortableVector<JCClass> classVector;
    public Hashtable<Object, JCClass> symbolTable;
    protected boolean usesIntegers;
    protected Hashtable<String, Descriptor> descriptorTable;
    protected SignaturePool sigPool;
    protected boolean createdFrom22;
    public int packageStartAddress;
    public int packageEndAddress;

    public JCPackage(String name, PackageIdentifier packageId, int line) {
        assert (name != null) : "name != null";
        assert (packageId != null) : "packageId != null";
        this.name = name;
        this.packageIdentifier = packageId;
        this.line = line;
        this.classVector = new SortableVector();
        this.importVector = new Vector();
        this.appletVector = new Vector();
        this.constantPool = new ConstantPool(this);
        this.symbolTable = new Hashtable();
        this.descriptorTable = new Hashtable();
        this.sigPool = new SignaturePool(this);
    }

    public String getName() {
        return this.name;
    }

    public PackageIdentifier getIdentifier() {
        return this.packageIdentifier;
    }

    public PackageIdentifier getIdentifier(int token) {
        assert (token >= 0) : "token >= 0";
        if (token >= this.importVector.size()) {
            return null;
        }
        return this.importVector.elementAt(token);
    }

    public int getPackageToken(PackageIdentifier p) {
        int size = this.importVector.size();
        for (int i = 0; i < size; ++i) {
            PackageIdentifier match = this.importVector.elementAt(i);
            if (!p.equals(match)) continue;
            return i;
        }
        return -1;
    }

    public boolean usesIntegers() {
        return this.usesIntegers;
    }

    public boolean hasRemote() {
        for (int i = 0; i < this.classVector.size(); ++i) {
            if (!((JCClass)this.classVector.elementAt(i)).isRemote()) continue;
            return true;
        }
        return false;
    }

    protected void usesIntegers(boolean value) {
        if (!this.usesIntegers) {
            this.usesIntegers = value;
        }
    }

    public Enumeration<Info> constantPoolElements() {
        return this.constantPool.elements();
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public Info getConstantPoolEntry(int i) {
        return this.constantPool.getConstantPoolEntry(i);
    }

    public void addConstantPoolEntry(Info info) {
        this.constantPool.addConstantPoolEntry(info);
    }

    protected void addApplet(AppletDeclarator applet) {
        this.appletVector.addElement(applet);
    }

    public int appletCount() {
        return this.appletVector.size();
    }

    public Enumeration<AppletDeclarator> appletElements() {
        return this.appletVector.elements();
    }

    protected void addImport(PackageIdentifier importPackage) {
        this.importVector.addElement(importPackage);
    }

    public Enumeration<PackageIdentifier> importElements() {
        return this.importVector.elements();
    }

    public void addClass(JCClass jcClass) {
        assert (jcClass != null) : "jcClass != null";
        String name = jcClass.getName();
        if (this.symbolTable.containsKey(name)) {
            Object[] arguments = new Object[]{name, this.name};
            Msg.error("package.0", arguments);
            return;
        }
        ClassIdentifier cid = jcClass.getClassIdentifier();
        if (this.symbolTable.containsKey(cid)) {
            Object[] arguments = new Object[]{new Integer(cid.getClassToken()), this.name};
            Msg.error("package.1", arguments);
            return;
        }
        jcClass.sortFields();
        this.symbolTable.put(name, jcClass);
        this.symbolTable.put(cid, jcClass);
        this.classVector.addElement(jcClass);
        if (!jcClass.isInterface() && jcClass.isRemote()) {
            jcClass.processRemoteMethodInfo();
        }
    }

    public Enumeration<JCClass> classElements() {
        return this.classVector.elements();
    }

    public void addDescriptor(String name, int packageToken, int classToken) {
        this.descriptorTable.put(name, new Descriptor(name, packageToken, classToken));
    }

    public int getDescriptorPackageToken(String name) {
        Descriptor desc = this.descriptorTable.get(name);
        if (desc != null) {
            return desc.getPackageToken() | 0x80;
        }
        JCClass c = this.symbolTable.get(this.name + "/" + name);
        if (c == null) {
            c = this.symbolTable.get(name);
        }
        if (c != null) {
            int addr = c.getRelocAddr();
            return addr >> 8 & 0xFF;
        }
        Object[] arguments = new Object[]{name};
        Msg.error("package.3", arguments);
        return 0;
    }

    public int getDescriptorClassToken(String name) {
        Descriptor desc = this.descriptorTable.get(name);
        if (desc != null) {
            return desc.getClassToken();
        }
        JCClass c = this.symbolTable.get(this.name + "/" + name);
        if (c == null) {
            c = this.symbolTable.get(name);
        }
        if (c != null) {
            int addr = c.getRelocAddr();
            return addr & 0xFF;
        }
        Object[] arguments = new Object[]{name};
        Msg.error("package.4", arguments);
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(".package " + this.name + " {" + Msg.eol);
        sb.append(".version " + this.packageIdentifier.getMajorVersion() + "." + this.packageIdentifier.getMinorVersion() + " ;" + Msg.eol);
        sb.append(".aid " + this.packageIdentifier.getAid() + " ;" + Msg.eol);
        sb.append(".imports {" + Msg.eol);
        for (PackageIdentifier p : this.importVector) {
            sb.append(p + ";" + Msg.eol);
        }
        sb.append("}" + Msg.eol);
        sb.append(this.constantPool.toString() + Msg.eol);
        for (JCClass c : this.classVector) {
            sb.append(c);
        }
        sb.append("}" + Msg.eol);
        return sb.toString();
    }

    public void resolveAppletInstallAddrs(SymbolTable<Object, JCMethod> mst) {
        for (int i = 0; i < this.appletVector.size(); ++i) {
            AppletDeclarator ad = this.appletVector.elementAt(i);
            String instName = ad.getInstallMethodName();
            ad.setInstallMethodAddr((short)((JCMethod)mst.get(instName)).getRelocAddr());
        }
    }

    public byte[] getAppletTableByteArray(byte pkgSlot) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        for (int i = 0; i < this.appletVector.size(); ++i) {
            try {
                dos.writeByte(pkgSlot);
                AppletDeclarator ad = this.appletVector.elementAt(i);
                byte[] adByteArray = ad.toByteArray();
                if (adByteArray == null) {
                    return null;
                }
                dos.write(adByteArray);
                dos.flush();
                continue;
            }
            catch (IOException e) {
                return null;
            }
        }
        return bos.toByteArray();
    }

    public void setPackageStart(int address) {
        this.packageStartAddress = address;
    }

    public void setPackageEnd(int address) {
        this.packageEndAddress = address;
    }

    public int getPackageStart() {
        return this.packageStartAddress;
    }

    public int getPackageEnd() {
        return this.packageEndAddress;
    }

    public void createSignaturePool() {
        this.sigPool.methodSignaturePool = new Vector();
        for (int i = 0; i < this.classVector.size(); ++i) {
            JCClass c = (JCClass)this.classVector.elementAt(i);
            if (!c.isRemote()) continue;
            for (int j = 0; j < c.remoteMethods.size(); ++j) {
                RemoteMethodInfo rmi = c.remoteMethods.elementAt(j);
                short offset = this.sigPool.addMethodToSignaturePool(rmi.methodNameAndDesc, rmi.parentClass);
                rmi.setMethodSigOffset(offset);
            }
        }
    }

    public SignaturePool getSignaturePool() {
        if (this.sigPool.methodSignaturePool == null) {
            this.createSignaturePool();
        }
        return this.sigPool;
    }

    public void purgeSignaturePool() {
        this.sigPool.methodSignaturePool = null;
    }

    public void set22Flag() {
        this.createdFrom22 = true;
    }

    public boolean is22Package() {
        return this.createdFrom22;
    }

    static class Descriptor {
        private int packageToken;
        private int classToken;

        Descriptor(String name, int packageToken, int classToken) {
            this.packageToken = packageToken;
            this.classToken = classToken;
        }

        int getPackageToken() {
            return this.packageToken;
        }

        int getClassToken() {
            return this.classToken;
        }
    }
}

