/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Aid;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class HeaderComponent
extends Component {
    public static final int MAGIC = -557121555;
    public static final int MAJOR = 2;
    public static final int ACC_INT = 1;
    public static final int ACC_EXPORT = 2;
    public static final int ACC_APPLET = 4;
    protected int major;
    protected int minor;
    protected int flags;
    protected Aid aid;

    HeaderComponent(JCPackage p, Aid aid, int major, int minor, int flags) {
        super(p);
        if (aid == null || major < 0 || major > 255 || minor < 0 || minor > 255) {
            throw new IllegalArgumentException();
        }
        this.tag = 1;
        this.aid = aid;
        this.major = major;
        this.minor = minor;
        this.flags = flags;
    }

    @Override
    public int dataSize() {
        if (this.getParentPackage().is22Package()) {
            return 10 + this.aid.getSize() + 1 + this.getParentPackage().getName().getBytes().length;
        }
        return 10 + this.aid.getSize();
    }

    @Override
    protected byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            byte[] header = super.toByteArray();
            dos.write(header, 0, header.length);
            dos.writeInt(-557121555);
            dos.writeByte(this.getParentPackage().is22Package() ? 2 : 1);
            dos.writeByte(2);
            dos.writeByte(this.flags);
            dos.writeByte(this.minor);
            dos.writeByte(this.major);
            dos.writeByte(this.aid.getSize());
            dos.write(this.aid.toByteArray());
            if (this.getParentPackage().is22Package()) {
                byte[] utf8Bytes = this.getParentPackage().getName().getBytes();
                dos.writeByte(utf8Bytes.length);
                if (utf8Bytes.length > 0) {
                    dos.write(utf8Bytes);
                }
            }
            dos.flush();
        }
        catch (IOException e) {
            return null;
        }
        assert (this.size() == bos.size()) : "size() != bos.size()";
        return bos.toByteArray();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("Magic: " + Msg.toHexString(-557121555) + Msg.eol);
        sb.append("Minor: " + Msg.toHexString((byte)(this.getParentPackage().is22Package() ? 2 : 1)) + Msg.eol);
        sb.append("Major: " + Msg.toHexString((byte)2) + Msg.eol);
        sb.append("Flags: " + Msg.toHexString((byte)this.flags) + Msg.eol);
        sb.append("Package Minor: " + Msg.toHexString((byte)this.minor) + Msg.eol);
        sb.append("Package Major: " + Msg.toHexString((byte)this.major) + Msg.eol);
        sb.append("Package AID Length: " + this.aid.getSize() + Msg.eol);
        sb.append("Package AID: " + this.aid.toString() + Msg.eol);
        return sb.toString();
    }
}

