/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.cap.Xml;
import java.io.File;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavacardXml
extends Xml {
    static String javacard_app = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<javacard-app xmlns=\"http://java.sun.com/xml/ns/javacard\"\n       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n       xsi:schemaLocation=\"http://java.sun.com/xml/ns/javacard ../../../../docs/schemas/internal/applet-app_3_0.xsd\"\n       version=\"3.0\">\n";
    static String slash_javacard_app = "</javacard-app>\n";
    static String shareable_interfaces = "  <shareable-interface-classes>\n";
    static String slash_shareable_interfaces = "  </shareable-interface-classes>\n";
    static String description = "    <description>";
    static String slash_description = "</description>\n";
    static String display_name = "    <display-name>";
    static String slash_display_name = "</display-name>\n";
    static String class_name = "    <class name=\"";
    static String slash_class_name = "\"/>\n";
    static String dynamically_loaded_classes = "  <dynamically-loaded-classes>\n";
    static String slash_dynamically_loaded_classes = "  </dynamically-loaded-classes>\n";

    public JavacardXml(JCPackage p, File[] proxyClasses) {
        super(p);
        String packageName = p.getName();
        StringBuffer sb = new StringBuffer();
        sb.append(javacard_app);
        if (proxyClasses != null) {
            Pattern pattern = Pattern.compile("(.*)\\.class");
            sb.append(dynamically_loaded_classes);
            for (int i = 0; i < proxyClasses.length; ++i) {
                Matcher matcher = pattern.matcher(proxyClasses[i].getName());
                if (!matcher.matches()) continue;
                String className = packageName.replace('/', '.') + ".proxy." + matcher.group(1);
                sb.append(class_name);
                sb.append(className);
                sb.append(slash_class_name);
            }
            sb.append(slash_dynamically_loaded_classes);
        }
        Enumeration<JCClass> e = p.classElements();
        while (e.hasMoreElements()) {
            JCClass c = e.nextElement();
            if (!c.isShareable() || !c.isInterface()) continue;
            sb.append(shareable_interfaces);
            String fullPathClassName = c.getName().replace("/", ".");
            int lastIndex = fullPathClassName.lastIndexOf(".");
            String className = fullPathClassName.substring(lastIndex + 1);
            sb.append(description);
            sb.append(className);
            sb.append(slash_description);
            sb.append(display_name);
            sb.append(className);
            sb.append(slash_display_name);
            sb.append(class_name);
            sb.append(fullPathClassName);
            sb.append(slash_class_name);
            sb.append(slash_shareable_interfaces);
        }
        sb.append(slash_javacard_app);
        this.xmlFile = sb.toString();
    }

    static boolean hasShareableInterfacesToExpose(JCPackage p) {
        boolean flag = false;
        Enumeration<JCClass> e = p.classElements();
        while (e.hasMoreElements()) {
            JCClass c = e.nextElement();
            if (!(c.isShareable() & c.isInterface())) continue;
            flag = true;
            break;
        }
        return flag;
    }
}

