/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jpcsclite;

import com.sun.javacard.jpcsclite.APDU;
import com.sun.javacard.jpcsclite.PCSCException;
import com.sun.javacard.jpcsclite.PCSCLite;
import com.sun.javacard.jpcsclite.State;

public class Card {
    private long card;
    protected State state;
    private boolean t0getResponse = true;

    public static Card getInstance(String reader_name) {
        Card c = new Card();
        c.state = new State(reader_name);
        return c;
    }

    protected void setActiveProtocol(int protocol) {
        this.state.active_protocol = protocol;
    }

    public int getActiveProtocol() {
        return this.state.active_protocol;
    }

    public boolean getT0GetResponse() {
        return this.t0getResponse;
    }

    public void setT0GetResponse(boolean b) {
        this.t0getResponse = b;
    }

    public State getStatus() throws PCSCException {
        int check = this.NativeStatus(this.state);
        if (check != PCSCLite.SUCCESS) {
            throw new PCSCException("getStatus()", check);
        }
        return this.state;
    }

    public byte[] transmitAPDU(int proto_info, byte[] apdu, int apdu_len, int receive_len) {
        byte[] rxbuffer = new byte[133];
        return rxbuffer;
    }

    public byte[] Transmit(APDU apdu) {
        if (apdu == null) {
            throw new NullPointerException();
        }
        return this.Transmit(apdu.getBuffer(), 0, apdu.getLength());
    }

    public byte[] Transmit(byte[] in, int off, int len) {
        Card.checkArrayArgs(in, off, len);
        byte[] out = this.NativeTransmit(in, off, len);
        return out;
    }

    public void Reconnect(int dwSharedMode, int dwPreferredProtos, int dwInitialization) throws PCSCException {
        int ret = this.NativeReconnect(dwSharedMode, dwPreferredProtos, dwInitialization);
        if (ret != PCSCLite.SUCCESS) {
            throw new PCSCException("Reconnect()", ret);
        }
    }

    public void Disconnect(int dwDisposition) throws PCSCException {
        int ret = this.NativeDisconnect(dwDisposition);
        if (ret != PCSCLite.SUCCESS) {
            throw new PCSCException("Disconnect()", ret);
        }
    }

    public void beginTransaction() throws PCSCException {
        int ret = this.NativeBeginTransaction();
        if (ret != PCSCLite.SUCCESS) {
            throw new PCSCException("beginTransaction()", ret);
        }
    }

    public void endTransaction(int dwDisposition) throws PCSCException {
        int ret = this.NativeEndTransaction(dwDisposition);
        if (ret != PCSCLite.SUCCESS) {
            throw new PCSCException("endTransaction()", ret);
        }
    }

    static void checkArrayArgs(byte[] buf, int off, int len) {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > buf.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private native int NativeReconnect(int var1, int var2, int var3);

    private native int NativeDisconnect(int var1);

    private native byte[] NativeTransmit(byte[] var1, int var2, int var3);

    private native int NativeTransmit(byte[] var1, int var2, int var3, byte[] var4, int var5);

    private native int NativeStatus(State var1);

    private native int NativeBeginTransaction();

    private native int NativeEndTransaction(int var1);
}

