/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AID;
import com.sun.javacard.offcardverifier.AIDintf;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.PackageInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfNames;

public class HeaderComponent
extends Safeptr {
    static final int MAGIC_NUMBER = -557121555;
    static final int MINOR_VERSION = 2;
    static final int MIN_MINOR_VERSION = 1;
    static final int MAJOR_VERSION = 2;
    Safeptr packageNameInfo;
    boolean hasName;
    private boolean useInts = false;
    boolean supportInts;
    private static byte[] AID_java_lang = new byte[]{-96, 0, 0, 0, 98, 0, 1};

    HeaderComponent(byte[] data) {
        super(data, "Header");
    }

    int magic() {
        return this.s4(0);
    }

    int minorVersion() {
        return this.u1(4);
    }

    int majorVersion() {
        return this.u1(5);
    }

    int flags() {
        return this.u1(6);
    }

    public PackageInfo thisPackage() {
        return new PackageInfo(this.offset(7));
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("Header.100");
        }
        if (this.magic() != -557121555) {
            throw new VerifierError("HeaderComponent.1", this.magic());
        }
        if (this.majorVersion() != 2) {
            throw new VerifierError("HeaderComponent.2", this.majorVersion());
        }
        Cap.capMinorVersion = this.minorVersion();
        if (Cap.capMinorVersion > 2 || Cap.capMinorVersion < 1) {
            throw new VerifierError("HeaderComponent.3", this.minorVersion());
        }
        if ((this.flags() & 0xFFFFFFF8) != 0) {
            throw new VerifierError("HeaderComponent.4", this.flags());
        }
        if ((this.flags() & 2) == 0 != (Cap.Export == null)) {
            throw new VerifierError("HeaderComponent.5");
        }
        if ((this.flags() & 4) == 0 != (Cap.Applet == null)) {
            throw new VerifierError("HeaderComponent.6");
        }
        this.supportInts = (this.flags() & 1) != 0;
        PackageInfo hdr = this.thisPackage();
        if (!AID.same((AIDintf)hdr, AID_java_lang) && Cap.Import == null) {
            throw new VerifierError("HeaderComponent.7");
        }
        int aidLen = hdr.AID_length();
        if (aidLen < 5 || aidLen > 16) {
            throw new VerifierError("HeaderComponent.8", aidLen);
        }
        if (Cap.capMinorVersion == 2) {
            this.packageNameInfo = this.offset(7 + hdr.length());
            int nameLength = this.getPackageNameLength();
            if (nameLength > 0) {
                if (!EfNames.validPackageName(this.getPackageName())) {
                    throw new VerifierError("RemoteInfoError.1", this.getPackageName());
                }
                this.hasName = true;
            }
            if (!this.packageNameInfo.offset(this.nameDataSize()).atComponentEnd()) {
                throw new VerifierError("HeaderComponent.9");
            }
            return;
        }
        if (!hdr.offset(hdr.length()).atComponentEnd()) {
            throw new VerifierError("HeaderComponent.9");
        }
    }

    public int getPackageNameLength() {
        return this.packageNameInfo.u1(0);
    }

    public String getPackageName() {
        byte[] nameBytes = new byte[this.getPackageNameLength()];
        for (int i = 0; i < nameBytes.length; ++i) {
            nameBytes[i] = (byte)this.packageNameInfo.u1(1 + i);
        }
        return new String(nameBytes);
    }

    public int nameDataSize() {
        return this.getPackageNameLength() + 1;
    }

    void useInts() {
        this.useInts = true;
    }

    void checkIntFlag() {
        if (this.useInts != this.supportInts) {
            if (this.useInts) {
                throw new VerifierError("HeaderComponent.10");
            }
            VerifierError.warning("HeaderComponent.11");
        }
    }
}

