/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.Arrays;

public class Safeptr {
    byte[] componentData;
    String componentName;
    public int ofs;

    Safeptr(byte[] data, String name) {
        this.componentData = data;
        this.componentName = name;
        this.ofs = 0;
    }

    Safeptr(Safeptr p) {
        this.componentData = p.componentData;
        this.componentName = p.componentName;
        this.ofs = p.ofs;
    }

    Safeptr(Safeptr p, int o) {
        this.componentData = p.componentData;
        this.componentName = p.componentName;
        this.ofs = o;
        if (this.ofs < 0 || this.ofs > this.componentData.length) {
            this.overflow(0);
        }
    }

    public int u1(int o) {
        if (this.ofs + o >= this.componentData.length) {
            this.overflow(o);
        }
        return this.componentData[this.ofs + o] & 0xFF;
    }

    public int s1(int o) {
        if (this.ofs + o >= this.componentData.length) {
            this.overflow(o);
        }
        return this.componentData[this.ofs + o];
    }

    public int u2(int o) {
        if (this.ofs + o + 1 >= this.componentData.length) {
            this.overflow(o);
        }
        return (this.componentData[this.ofs + o] & 0xFF) << 8 | this.componentData[this.ofs + o + 1] & 0xFF;
    }

    public int s2(int o) {
        if (this.ofs + o + 1 >= this.componentData.length) {
            this.overflow(o);
        }
        return this.componentData[this.ofs + o] << 8 | this.componentData[this.ofs + o + 1] & 0xFF;
    }

    public int s4(int o) {
        if (this.ofs + o + 3 >= this.componentData.length) {
            this.overflow(o);
        }
        return this.componentData[this.ofs + o] << 24 | (this.componentData[this.ofs + o + 1] & 0xFF) << 16 | (this.componentData[this.ofs + o + 2] & 0xFF) << 8 | this.componentData[this.ofs + o + 3] & 0xFF;
    }

    public int nibble(int o) {
        if ((o & 1) == 0) {
            return this.u1(o >> 1) >> 4;
        }
        return this.u1(o >> 1) & 0xF;
    }

    public void advance(int o) {
        this.ofs += o;
        if (this.ofs < 0 || this.ofs > this.componentData.length) {
            this.overflow(0);
        }
    }

    public Safeptr offset(int o) {
        return new Safeptr(this, this.ofs + o);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Safeptr)) {
            return false;
        }
        Safeptr p = (Safeptr)obj;
        if (p.componentData.length != this.componentData.length) {
            return false;
        }
        for (int i = 0; i < this.componentData.length; ++i) {
            if (p.componentData[i] == this.componentData[i]) continue;
            return false;
        }
        return p.ofs == this.ofs;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Arrays.hashCode(this.componentData);
        hash = 31 * hash + this.ofs;
        return hash;
    }

    public String toString() {
        return Messages.format("Safeptr.2", (Object)this.componentName, this.ofs);
    }

    private void overflow(int o) {
        throw new VerifierError("Safeptr.1", (Object)this.toString(), o);
    }

    public int size() {
        return this.componentData.length;
    }

    public boolean atComponentEnd() {
        return this.ofs == this.componentData.length;
    }

    public void write1(int o, int v) {
        if (this.ofs + o >= this.componentData.length) {
            this.overflow(o);
        }
        this.componentData[this.ofs + o] = (byte)v;
    }

    public void write2(int o, int v) {
        if (this.ofs + o + 1 >= this.componentData.length) {
            this.overflow(o);
        }
        this.componentData[this.ofs + o] = (byte)(v >> 8);
        this.componentData[this.ofs + o + 1] = (byte)v;
    }
}

