/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier.exportfile;

import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Package;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;

public class CompareVersion {
    private static boolean sameVersion = false;
    private static ExportFile latest;
    private static ExportFile old;

    public static void compare(ExportFile ef1, ExportFile ef2) {
        CompareVersion.comparePackageNames(ef1, ef2);
        CompareVersion.findNewer(ef1, ef2);
        if (sameVersion) {
            VerifierError.generalMessage("MainRev.6");
            ef1.checkEquality(ef2);
        } else {
            old.compareTo(latest);
        }
    }

    public static void comparePackageNames(ExportFile ef1, ExportFile ef2) {
        if (!ef1.thisName().equals(ef2.thisName())) {
            throw new VerifierError("RevisionError.40", (Object)ef1.thisName(), (Object)ef2.thisName());
        }
    }

    private static void findNewer(ExportFile ef1, ExportFile ef2) {
        short major1 = 0;
        short major2 = 0;
        short minor1 = 0;
        short minor2 = 0;
        major1 = ((EfConstant_Package)ef1.constantPool[ef1.thisPackage]).majorVersion;
        major2 = ((EfConstant_Package)ef2.constantPool[ef2.thisPackage]).majorVersion;
        if (major1 != major2) {
            throw new VerifierError("MajorVersion.1");
        }
        minor1 = ((EfConstant_Package)ef1.constantPool[ef1.thisPackage]).minorVersion;
        minor2 = ((EfConstant_Package)ef2.constantPool[ef2.thisPackage]).minorVersion;
        int diff = minor1 - minor2;
        if (diff > 1 || diff < -1) {
            VerifierError.warning("RevisionWarning.1");
        }
        if (minor1 == minor2) {
            sameVersion = true;
        }
        if (minor1 >= minor2) {
            latest = ef1;
            old = ef2;
        } else {
            latest = ef2;
            old = ef1;
        }
    }
}

