/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.packager.model;

import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.packager.model.AppletInfo;
import com.sun.javacard.packager.model.PackageItem;
import com.sun.javacard.util.XMLNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

public class AppletXML
extends PackageItem {
    public static final String XSD_NAME = "applet-app_3_0.xsd";
    private String version;
    private File file;
    private XMLNode xmlNode;
    Vector<AppletInfo> applets = new Vector();

    public AppletXML(File file) {
        this.file = file;
    }

    @Override
    public String getItemDisplayName() {
        String str = "";
        if (this.getParent() != null) {
            str = this.getParent().getItemDisplayName() + "/";
        }
        str = str + "applet.xml";
        return str;
    }

    public Vector<String> getAppletInfo() {
        Vector<String> v = new Vector<String>();
        for (AppletInfo info : this.applets) {
            v.add(info.AID);
            v.add(info.className);
        }
        return v;
    }

    public String getPackageName() {
        String s = this.applets.elementAt((int)0).className;
        int lastIndex = s.lastIndexOf(".");
        if (lastIndex == -1) {
            return s;
        }
        return s.substring(0, lastIndex);
    }

    public void saveCanonicalizedTo(File dest) throws Exception {
        if (!this.isOk()) {
            return;
        }
        String str = this.xmlNode.toString();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(dest);
            fos.write(str.getBytes());
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public void initialize() {
        this.xmlNode = null;
        try {
            this.xmlNode = new XMLNode(this, this.file, XSD_NAME, "http://java.sun.com/xml/ns/javacard");
        }
        catch (Exception e) {
            this.addError(ErrorKey.XMLParsingError, this.file, e.getMessage());
            return;
        }
        ArrayList<XMLNode> appletInfos = this.xmlNode.getChildNodes("applet");
        for (XMLNode applet : appletInfos) {
            String appletClassName = applet.getChildNode("applet-class").getTextValue().trim();
            String appletAID = applet.getChildNode("applet-AID").getTextValue().trim();
            this.applets.add(new AppletInfo(appletClassName, appletAID));
        }
    }

    @Override
    public void processInternal() {
    }
}

