/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.packager.model;

import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.packager.Packager;
import com.sun.javacard.packager.model.PackageItem;
import com.sun.javacard.util.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;

public final class Signer
extends PackageItem {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private boolean required;
    private String keystore;
    private String storepass;
    private String passkey;
    private String alias;

    @Override
    public String getItemDisplayName() {
        return "Signing Tool";
    }

    @Override
    public void initialize() {
        if (!this.isRequired()) {
            return;
        }
        if (this.keystore == null) {
            this.addError(ErrorKey.MissingKeystore, new Object[0]);
        } else {
            File ksFile = new File(this.keystore);
            if (ksFile.isDirectory()) {
                this.addError(ErrorKey.IsNotAFile, ksFile.getAbsolutePath());
            } else if (!ksFile.exists()) {
                this.addError(ErrorKey.KeystoreFileDoesNotExists, ksFile);
            }
        }
        if (this.storepass == null) {
            this.addError(ErrorKey.MissingStorepass, new Object[0]);
        }
        if (this.passkey == null) {
            this.addError(ErrorKey.MissingPassword, new Object[0]);
        }
        if (this.alias == null) {
            this.addError(ErrorKey.MissingAlias, new Object[0]);
        }
    }

    @Override
    public void processInternal() {
        if (!this.isRequired()) {
            return;
        }
        File outFile = Packager.getPackager().getOut();
        String signatureFileName = outFile.getAbsolutePath();
        int lastIndex = signatureFileName.lastIndexOf(46);
        signatureFileName = lastIndex == -1 ? signatureFileName + ".signature" : signatureFileName.substring(0, lastIndex) + ".signature";
        this.createSignatureFile(new File(signatureFileName), outFile);
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public String getStorepass() {
        return this.storepass;
    }

    public void setStorepass(String storepass) {
        this.storepass = storepass;
    }

    public String getPasskey() {
        return this.passkey;
    }

    public void setPasskey(String passkey) {
        this.passkey = passkey;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void createSignatureFile(File signatureFile, File jcabFile) {
        FileInputStream jarinput;
        byte[] certbytes;
        Certificate cert;
        OutputStream outstream;
        FileInputStream ksstream;
        block120: {
            block121: {
                KeyStore keyStore = null;
                File ksfile = new File(this.keystore);
                ksstream = null;
                outstream = null;
                byte[] raw = null;
                cert = null;
                certbytes = null;
                jarinput = null;
                if (ksfile.exists() && ksfile.length() == 0L) {
                    this.addError(ErrorKey.EmptyKeystoreFile, new Object[0]);
                    return;
                }
                try {
                    ksstream = new FileInputStream(ksfile);
                }
                catch (FileNotFoundException e) {
                    this.addError(ErrorKey.KeystoreFileDoesNotExists, ksfile);
                    if (ksstream != null) {
                        try {
                            ksstream.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    if (outstream != null) {
                        try {
                            outstream.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    if (jarinput != null) {
                        try {
                            jarinput.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    return;
                }
                try {
                    keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    keyStore.load(ksstream, this.storepass.toCharArray());
                }
                catch (Exception e) {
                    this.addError(ErrorKey.ErrorReadingKeystoreFile, ksfile, e.getMessage());
                    if (ksstream != null) {
                        try {
                            ksstream.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    if (outstream != null) {
                        try {
                            outstream.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    if (jarinput != null) {
                        try {
                            jarinput.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    return;
                }
                int bytesRead = 0;
                byte[] buffer = new byte[10240];
                Signature signature = null;
                try {
                    signature = Signature.getInstance("MD5withRSA");
                }
                catch (Exception e) {
                    this.addError(ErrorKey.UnexpectedException, e.toString());
                    if (ksstream != null) {
                        try {
                            ksstream.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    if (outstream != null) {
                        try {
                            outstream.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    if (jarinput != null) {
                        try {
                            jarinput.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    return;
                }
                Key pk = null;
                try {
                    pk = keyStore.getKey(this.alias, this.passkey.toCharArray());
                }
                catch (Exception e) {
                    this.addError(ErrorKey.ErrorGettingPrivateKey, e.getMessage());
                    if (ksstream != null) {
                        try {
                            ksstream.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    if (outstream != null) {
                        try {
                            outstream.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    if (jarinput != null) {
                        try {
                            jarinput.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    return;
                }
                try {
                    signature.initSign((PrivateKey)pk);
                }
                catch (InvalidKeyException e) {
                    this.addError(ErrorKey.InvalidPrivateKey, new Object[0]);
                    if (ksstream != null) {
                        try {
                            ksstream.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    if (outstream != null) {
                        try {
                            outstream.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    if (jarinput != null) {
                        try {
                            jarinput.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    return;
                }
                jarinput = new FileInputStream(jcabFile);
                while ((bytesRead = jarinput.read(buffer)) != -1) {
                    signature.update(buffer, 0, bytesRead);
                }
                jarinput.close();
                raw = signature.sign();
                String encodedSig = Base64.encode(raw);
                outstream = new FileOutputStream(signatureFile);
                Signer.write("signature", encodedSig, outstream, "UTF-8");
                cert = keyStore.getCertificate(this.alias);
                if (cert != null) break block120;
                this.addError(ErrorKey.CertificateNotFound, new Object[0]);
                if (ksstream == null) break block121;
                try {
                    ksstream.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (outstream != null) {
                try {
                    outstream.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (jarinput != null) {
                try {
                    jarinput.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            return;
        }
        try {
            block123: {
                break block123;
                catch (Exception e) {
                    this.addError(ErrorKey.UnexpectedException, e.toString());
                    return;
                }
            }
            try {
                certbytes = cert.getEncoded();
            }
            catch (CertificateEncodingException e) {
                this.addError(ErrorKey.InvalidCertificateEncoding, new Object[0]);
                if (ksstream != null) {
                    try {
                        ksstream.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                if (outstream != null) {
                    try {
                        outstream.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                if (jarinput != null) {
                    try {
                        jarinput.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                return;
            }
            String certtoadd = Base64.encode(certbytes);
            try {
                Signer.write("certificate", certtoadd, outstream, "UTF-8");
                ksstream.close();
                outstream.close();
            }
            catch (Exception e) {
                this.addError(ErrorKey.UnexpectedException, e.toString());
                if (ksstream != null) {
                    try {
                        ksstream.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                if (outstream != null) {
                    try {
                        outstream.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                if (jarinput != null) {
                    try {
                        jarinput.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                return;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (ksstream != null) {
                try {
                    ksstream.close();
                }
                catch (IOException ex) {}
            }
            if (outstream != null) {
                try {
                    outstream.close();
                }
                catch (IOException ex) {}
            }
            if (jarinput != null) {
                try {
                    jarinput.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private static void write(String key, String value, OutputStream out, String enc) throws IOException {
        OutputStreamWriter awriter = new OutputStreamWriter(out, enc);
        if (enc.equals("ISO8859_1")) {
            key = Signer.saveConvert(key);
            value = Signer.saveConvert(value);
        }
        awriter.write(key + "=" + value);
        awriter.write("\n");
        awriter.flush();
    }

    private static String saveConvert(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar < ' ' || aChar > '~' || aChar == '\\') {
                outBuffer.append('\\');
                outBuffer.append('u');
                outBuffer.append(Signer.toHex(aChar >> 12 & 0xF));
                outBuffer.append(Signer.toHex(aChar >> 8 & 0xF));
                outBuffer.append(Signer.toHex(aChar >> 4 & 0xF));
                outBuffer.append(Signer.toHex(aChar & 0xF));
                continue;
            }
            outBuffer.append(aChar);
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return HEX_DIGITS[nibble & 0xF];
    }
}

