/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.tools.util;

import com.sun.javacard.tools.util.ConsoleFilter;
import com.sun.javacard.tools.util.JCConsoleHandler;
import com.sun.javacard.tools.util.JCToolsFormatter;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class JCToolsLogger {
    private static Logger toolsLogger = null;
    private boolean printCurrentClassAndMethod;

    public static void main(String[] args) {
        JCToolsLogger logger = new JCToolsLogger("test", "com.sun.javacard.tools.util.message");
        logger.info("msg1", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JCToolsLogger(String name, String msgFileName) {
        block10: {
            this.printCurrentClassAndMethod = false;
            try {
                toolsLogger = Logger.getLogger(name, msgFileName);
                LogManager mgr = LogManager.getLogManager();
                String jchome = System.getProperty("jc.home");
                if (jchome == null) break block10;
                FileInputStream fin = null;
                try {
                    if (System.getProperty("netbeans.home") == null && (fin = new FileInputStream(jchome + "/lib/logging.properties")) != null) {
                        mgr.readConfiguration(fin);
                        if (mgr.getProperty("printCurrentClassAndMethod").equalsIgnoreCase("true")) {
                            this.printCurrentClassAndMethod = true;
                        }
                    }
                }
                catch (IOException e) {
                }
                finally {
                    if (fin != null) {
                        fin.close();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JCToolsLogger(String name) {
        block10: {
            this.printCurrentClassAndMethod = false;
            try {
                toolsLogger = Logger.getLogger(name);
                LogManager mgr = LogManager.getLogManager();
                String jchome = System.getProperty("jc.home");
                if (jchome == null) break block10;
                FileInputStream fin = null;
                try {
                    if (System.getProperty("netbeans.home") == null && (fin = new FileInputStream(jchome + "/lib/logging.properties")) != null) {
                        mgr.readConfiguration(fin);
                        if (mgr.getProperty("printCurrentClassAndMethod").equalsIgnoreCase("true")) {
                            this.printCurrentClassAndMethod = true;
                        }
                    }
                }
                catch (IOException e) {
                }
                finally {
                    if (fin != null) {
                        fin.close();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addHandlers() {
        boolean alreadyAdded = false;
        try {
            toolsLogger.setUseParentHandlers(false);
            toolsLogger.setFilter(new JCFilter());
            JCConsoleHandler consolehandler = new JCConsoleHandler();
            consolehandler.setFormatter(new JCToolsFormatter());
            consolehandler.setFilter(new ConsoleFilter());
            for (Handler h : toolsLogger.getHandlers()) {
                if (!h.getClass().getName().equals(JCConsoleHandler.class.getName())) continue;
                alreadyAdded = true;
                break;
            }
            FileHandler fileHandler = new FileHandler("%h/java_tools%u.log", 100000, 1, true);
            fileHandler.setFormatter(new SimpleFormatter());
            toolsLogger.addHandler(fileHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static JCToolsLogger getLogger(String name, String msgFileName) {
        return new JCToolsLogger(name, msgFileName);
    }

    public static JCToolsLogger getLogger(String name) {
        return new JCToolsLogger(name);
    }

    public void info(String messageOrKey, Object ... args) {
        if (this.printCurrentClassAndMethod) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            toolsLogger.logp(Level.INFO, stack[1].getClassName(), stack[1].getMethodName(), messageOrKey, args);
        } else {
            toolsLogger.logp(Level.INFO, "", "", messageOrKey, args);
        }
    }

    public void severe(String messageOrKey, Object ... args) {
        if (this.printCurrentClassAndMethod) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            toolsLogger.logp(Level.SEVERE, stack[1].getClassName(), stack[1].getMethodName(), messageOrKey, args);
        } else {
            toolsLogger.logp(Level.SEVERE, "", "", messageOrKey, args);
        }
        this.sendToSystemErr(messageOrKey, args);
    }

    public void warning(String messageOrKey, Object ... args) {
        if (this.printCurrentClassAndMethod) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            toolsLogger.logp(Level.WARNING, stack[1].getClassName(), stack[1].getMethodName(), messageOrKey, args);
        } else {
            toolsLogger.logp(Level.WARNING, "", "", messageOrKey, args);
        }
    }

    public void log(Level level, String message) {
        toolsLogger.log(level, message);
    }

    public void setLevel(Level level) {
        toolsLogger.setLevel(level);
    }

    public ResourceBundle getResourceBundle() {
        return toolsLogger.getResourceBundle();
    }

    private void sendToSystemErr(String messageOrKey, Object ... args) {
        try {
            if (messageOrKey != null) {
                try {
                    String resourceName = toolsLogger.getResourceBundleName();
                    if (resourceName != null) {
                        messageOrKey = ResourceBundle.getBundle(resourceName).getString(messageOrKey);
                    }
                }
                catch (MissingResourceException e) {
                    // empty catch block
                }
            }
            MessageFormat msgFormat = new MessageFormat(messageOrKey);
            System.err.println(msgFormat.format(args));
        }
        catch (NullPointerException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    class JCFilter
    implements Filter {
        String msg = null;

        JCFilter() {
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            String newMsg = record.getMessage();
            if (this.msg != null && this.msg.equals(newMsg)) {
                return false;
            }
            this.msg = newMsg;
            return true;
        }
    }
}

