/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.util.FileUtils;
import com.sun.javacard.util.ZipUtils;
import com.sun.javacard.validator.AppletXML;
import com.sun.javacard.validator.Classes;
import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.Module;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashSet;
import java.util.Vector;

public class ClassicModule
extends Module {
    private Vector<File> exportFiles;
    private AppletXML appletXML = null;
    private static Vector<String> mandatoryCAPComponentsForModule = new Vector<String>(){
        {
            this.addElement("applet.cap");
            this.addElement("header.cap");
            this.addElement("directory.cap");
            this.addElement("import.cap");
            this.addElement("constantpool.cap");
            this.addElement("class.cap");
            this.addElement("method.cap");
            this.addElement("staticfield.cap");
            this.addElement("reflocation.cap");
            this.addElement("descriptor.cap");
        }
    };

    public ClassicModule(String path) {
        super(path);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.isOk()) {
            return;
        }
        String infFolder = "APPLET-INF";
        File appletXMLFile = new File(this.folder, "APPLET-INF/applet.xml");
        if (appletXMLFile.exists()) {
            this.appletXML = new AppletXML(appletXMLFile);
            this.addItem(this.appletXML);
            this.appletXML.initialize();
        } else {
            this.addError(ErrorKey.AppletXmlFileDoesNotExists, appletXMLFile.getName());
        }
        File classesFolder = new File(this.folder, infFolder + "/classes");
        if (!classesFolder.exists()) {
            classesFolder = null;
        }
        this.classes = new Classes(classesFolder);
        this.addItem(this.classes);
        this.classes.initialize();
    }

    @Override
    public void processInternal() {
        super.processInternal();
        if (!this.isOk()) {
            return;
        }
        Vector<File> vf = FileUtils.listAllFilesInFolder(this.folder, ".class");
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < vf.size(); ++i) {
            File f = vf.elementAt(i).getParentFile();
            if (f.getName().equals("proxy")) {
                f = f.getParentFile();
            }
            set.add(f.getAbsolutePath());
        }
        if (set.size() > 1) {
            this.addError(ErrorKey.OnlyOnePackageInClassicAppOrLib, new Object[0]);
            return;
        }
        vf = FileUtils.listAllFilesInFolder(this.folder, ".cap");
        for (File f : vf) {
            mandatoryCAPComponentsForModule.removeElement(f.getName().toLowerCase());
        }
        if (mandatoryCAPComponentsForModule.size() != 0) {
            this.addError(ErrorKey.missingCAPComponent, new Object[0]);
        }
        try {
            File tempCAPFile = File.createTempFile("abc", null);
            ZipUtils.zip(this.folder, tempCAPFile, false);
            FileInputStream fis = new FileInputStream(tempCAPFile);
            Verifier.verifyCap(fis, null, this.exportFiles);
        }
        catch (Exception e) {
            this.addError(ErrorKey.VerifierError, e.getMessage());
        }
        this.appletXML.process();
    }

    public AppletXML getAppletXML() {
        return this.appletXML;
    }

    public void setExportFiles(Vector<File> exportFiles) {
        this.exportFiles = exportFiles;
    }
}

