// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "Mutex.hh"

namespace Mutex {

/* Literal string constants */

extern const CHARSTRING cs_0(10, "Mutex.ttcn"),
cs_1(12, "MutexDispCT-"),
cs_2(12, "TestChildCT-");
const unsigned char module_checksum[] = { 0x28, 0xb5, 0x5f, 0xd6, 0x07, 0x46, 0x53, 0x7c, 0x2e, 0x5c, 0x10, 0x2b, 0xeb, 0x39, 0x18, 0x8f };

/* Global variable definitions */

const TTCN_Typedescriptor_t& MutexCT_descr_ = COMPONENT_descr_;
MutexPT MutexCT_component_LOCK("LOCK");
MutexPT MutexCT_component_UNLOCK("UNLOCK");
INTEGER MutexCT_component_g__mutex__ref;
const TTCN_Typedescriptor_t& MutexDispCT_descr_ = COMPONENT_descr_;
FLOAT const_f__Mutex__lock_Tval_defval;
const FLOAT& f__Mutex__lock_Tval_defval = const_f__Mutex__lock_Tval_defval;
const TTCN_Typedescriptor_t& TestCT_descr_ = COMPONENT_descr_;
const TTCN_Typedescriptor_t& TestChildCT_descr_ = COMPONENT_descr_;
TTCN_Module module_object("Mutex", __DATE__, __TIME__, module_checksum, pre_init_module, NULL, 0U, 4294967295U, 4294967295U, 4294967295U, NULL, 0LU, 0, post_init_module, NULL, NULL, NULL, init_comp_type, init_system_port, start_ptc_function, NULL);

const RuntimeVersionChecker ver_checker(  current_runtime_version.requires_major_version_11,
  current_runtime_version.requires_minor_version_1,
  current_runtime_version.requires_patch_level_0,  current_runtime_version.requires_runtime_1);

/* Member functions of C++ classes */

void MutexPT::append_to_proc_queue(proc_queue_item *new_item)
{
new_item->next_item = NULL;
if (proc_queue_tail != NULL) proc_queue_tail->next_item = new_item;
else proc_queue_head = new_item;
proc_queue_tail = new_item;
}

void MutexPT::remove_proc_queue_head()
{
switch (proc_queue_head->item_selection) {
case CALL_0:
delete proc_queue_head->call_0;
break;
case CALL_1:
delete proc_queue_head->call_1;
break;
case REPLY_0:
delete proc_queue_head->reply_0;
break;
default:
TTCN_error("Internal error: Invalid signature selector in the queue of port %s.", port_name);
}
proc_queue_item *next_item = proc_queue_head->next_item;
delete proc_queue_head;
proc_queue_head = next_item;
if (next_item == NULL) proc_queue_tail = NULL;
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::extract__op, port_name, 0, ++proc_head_count, CHARSTRING(0,NULL), CHARSTRING(0,NULL));}

void MutexPT::clear_queue()
{
while (proc_queue_head != NULL) remove_proc_queue_head();
}

MutexPT::MutexPT(const char *par_port_name)
 : PORT(par_port_name)
{
proc_queue_head = NULL;
proc_queue_tail = NULL;
}

MutexPT::~MutexPT()
{
clear_queue();
}

void MutexPT::call(const MUTEX__LOCK_template& call_template, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
if (!is_started) TTCN_error("Calling a signature on port %s, which is not started.", port_name);
if (!destination_component.is_bound()) TTCN_error("Unbound component reference in the to clause of call operation.");
const MUTEX__LOCK_call& call_tmp = call_template.create_call();
const TTCN_Logger::Severity log_sev = destination_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMOUT:TTCN_Logger::PORTEVENT_PCOUT;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_send(port_name,TitanLoggerApiSimple::Port__oper::call__op, destination_component,
CHARSTRING(0,NULL),(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PMOUT, TRUE), call_tmp.log(), TTCN_Logger::end_event_log2str()));
}
if (destination_component == SYSTEM_COMPREF) TTCN_error("Internal port %s cannot send call to system.", port_name);
else {
Text_Buf text_buf;
prepare_call(text_buf, "@Mutex.MUTEX_LOCK");
call_tmp.encode_text(text_buf);
send_data(text_buf, destination_component);
}
}

void MutexPT::call(const MUTEX__LOCK_template& call_template, size_t nof_components, const COMPONENT* destination_components, FLOAT* timestamp_redirect)
{
for (size_t i = 0; i < nof_components; ++i) call(call_template, destination_components[i], timestamp_redirect);
}

void MutexPT::call(const MUTEX__LOCK_template& call_template, boolean broadcast, FLOAT* timestamp_redirect)
{
if (broadcast) {
if (!is_started) TTCN_error("Calling a signature on port %s, which is not started.", port_name);
Text_Buf text_buf;
prepare_call(text_buf, "@Mutex.MUTEX_LOCK");
const MUTEX__LOCK_call& call_tmp = call_template.create_call();
call_tmp.encode_text(text_buf);
send_data_broadcast(text_buf, PORT::OMT_CALL, (TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PCOUT, TRUE), 
call_tmp.log(), TTCN_Logger::end_event_log2str()));
}
else call(call_template, COMPONENT(get_default_destination()), timestamp_redirect);
}

void MutexPT::call(const MUTEX__UNLOCK_template& call_template, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
if (!is_started) TTCN_error("Calling a signature on port %s, which is not started.", port_name);
if (!destination_component.is_bound()) TTCN_error("Unbound component reference in the to clause of call operation.");
const MUTEX__UNLOCK_call& call_tmp = call_template.create_call();
const TTCN_Logger::Severity log_sev = destination_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMOUT:TTCN_Logger::PORTEVENT_PCOUT;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_send(port_name,TitanLoggerApiSimple::Port__oper::call__op, destination_component,
CHARSTRING(0,NULL),(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PMOUT, TRUE), call_tmp.log(), TTCN_Logger::end_event_log2str()));
}
if (destination_component == SYSTEM_COMPREF) TTCN_error("Internal port %s cannot send call to system.", port_name);
else {
Text_Buf text_buf;
prepare_call(text_buf, "@Mutex.MUTEX_UNLOCK");
call_tmp.encode_text(text_buf);
send_data(text_buf, destination_component);
}
}

void MutexPT::call(const MUTEX__UNLOCK_template& call_template, size_t nof_components, const COMPONENT* destination_components, FLOAT* timestamp_redirect)
{
for (size_t i = 0; i < nof_components; ++i) call(call_template, destination_components[i], timestamp_redirect);
}

void MutexPT::call(const MUTEX__UNLOCK_template& call_template, boolean broadcast, FLOAT* timestamp_redirect)
{
if (broadcast) {
if (!is_started) TTCN_error("Calling a signature on port %s, which is not started.", port_name);
Text_Buf text_buf;
prepare_call(text_buf, "@Mutex.MUTEX_UNLOCK");
const MUTEX__UNLOCK_call& call_tmp = call_template.create_call();
call_tmp.encode_text(text_buf);
send_data_broadcast(text_buf, PORT::OMT_CALL, (TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PCOUT, TRUE), 
call_tmp.log(), TTCN_Logger::end_event_log2str()));
}
else call(call_template, COMPONENT(get_default_destination()), timestamp_redirect);
}

void MutexPT::reply(const MUTEX__LOCK_template& reply_template, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
if (!is_started) TTCN_error("Replying to a signature on port %s, which is not started.", port_name);
if (!destination_component.is_bound()) TTCN_error("Unbound component reference in the to clause of reply operation.");
const MUTEX__LOCK_reply& reply_tmp = reply_template.create_reply();
const TTCN_Logger::Severity log_sev = destination_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMOUT:TTCN_Logger::PORTEVENT_PCOUT;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_send(port_name, TitanLoggerApiSimple::Port__oper::reply__op, destination_component,
 CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PMOUT, TRUE), reply_tmp.log(), TTCN_Logger::end_event_log2str()));
}
if (destination_component == SYSTEM_COMPREF) TTCN_error("Internal port %s cannot send reply to system.", port_name);
else {
Text_Buf text_buf;
prepare_reply(text_buf, "@Mutex.MUTEX_LOCK");
reply_tmp.encode_text(text_buf);
send_data(text_buf, destination_component);
}
}

void MutexPT::reply(const MUTEX__LOCK_template& reply_template, size_t nof_components, const COMPONENT* destination_components, FLOAT* timestamp_redirect)
{
for (size_t i = 0; i < nof_components; ++i) reply(reply_template, destination_components[i], timestamp_redirect);
}

void MutexPT::reply(const MUTEX__LOCK_template& reply_template, boolean broadcast, FLOAT* timestamp_redirect)
{
if (broadcast) {
if (!is_started) TTCN_error("Replying to a call on port %s, which is not started.", port_name);
Text_Buf text_buf;
prepare_reply(text_buf, "@Mutex.MUTEX_LOCK");
const MUTEX__LOCK_reply& reply_tmp = reply_template.create_reply();
reply_tmp.encode_text(text_buf);
send_data_broadcast(text_buf, PORT::OMT_REPLY, (TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PCOUT, TRUE), 
reply_tmp.log(), TTCN_Logger::end_event_log2str()));
}
else reply(reply_template, COMPONENT(get_default_destination()), timestamp_redirect);
}

alt_status MutexPT::getcall(const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first entity in the queue does not match the from clause: ", port_name);
sender_template.log_match(proc_queue_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else switch (proc_queue_head->item_selection) {
case CALL_0:
case CALL_1:
{
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS, "Matching on port %s succeeded.", port_name);
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::call__op, proc_queue_head->sender_component,
FALSE, CHARSTRING(0, NULL), msg_head_count+1);
}
remove_proc_queue_head();
return ALT_YES;
}
default:
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: First entity in the queue is not a call.", port_name);
return ALT_NO;
}
}

alt_status MutexPT::check_getcall(const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first entity in the queue does not match the from clause: ", port_name);
sender_template.log_match(proc_queue_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else switch (proc_queue_head->item_selection) {
case CALL_0:
case CALL_1:
{
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS, "Matching on port %s succeeded.", port_name);
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::call__op, proc_queue_head->sender_component,
TRUE, CHARSTRING(0, NULL), msg_head_count+1);
}
return ALT_YES;
}
default:
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: First entity in the queue is not a call.", port_name);
return ALT_NO;
}
}

alt_status MutexPT::getcall(const MUTEX__LOCK_template& getcall_template, const COMPONENT_template& sender_template, const MUTEX__LOCK_call_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::sender__does__not__match__from__clause,
(TTCN_Logger::begin_event(log_sev, TRUE), sender_template.log_match(proc_queue_head->sender_component),  TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else if (proc_queue_head->item_selection != CALL_0) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a call for signature @Mutex.MUTEX_LOCK.", port_name);
return ALT_NO;
} else if (!getcall_template.match_call(*proc_queue_head->call_0)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__call__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getcall_template.log_match_call(*proc_queue_head->call_0), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->call_0);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getcall_template.log_match_call(*proc_queue_head->call_0);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::call__op, proc_queue_head->sender_component, FALSE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->call_0->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_proc_queue_head();
return ALT_YES;
}
}

alt_status MutexPT::check_getcall(const MUTEX__LOCK_template& getcall_template, const COMPONENT_template& sender_template, const MUTEX__LOCK_call_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::sender__does__not__match__from__clause,
(TTCN_Logger::begin_event(log_sev, TRUE), sender_template.log_match(proc_queue_head->sender_component),  TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else if (proc_queue_head->item_selection != CALL_0) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a call for signature @Mutex.MUTEX_LOCK.", port_name);
return ALT_NO;
} else if (!getcall_template.match_call(*proc_queue_head->call_0)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__call__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getcall_template.log_match_call(*proc_queue_head->call_0), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->call_0);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getcall_template.log_match_call(*proc_queue_head->call_0);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::call__op, proc_queue_head->sender_component, TRUE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->call_0->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
return ALT_YES;
}
}

alt_status MutexPT::getcall(const MUTEX__UNLOCK_template& getcall_template, const COMPONENT_template& sender_template, const MUTEX__UNLOCK_call_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::sender__does__not__match__from__clause,
(TTCN_Logger::begin_event(log_sev, TRUE), sender_template.log_match(proc_queue_head->sender_component),  TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else if (proc_queue_head->item_selection != CALL_1) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a call for signature @Mutex.MUTEX_UNLOCK.", port_name);
return ALT_NO;
} else if (!getcall_template.match_call(*proc_queue_head->call_1)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__call__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getcall_template.log_match_call(*proc_queue_head->call_1), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->call_1);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getcall_template.log_match_call(*proc_queue_head->call_1);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::call__op, proc_queue_head->sender_component, FALSE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->call_1->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_proc_queue_head();
return ALT_YES;
}
}

alt_status MutexPT::check_getcall(const MUTEX__UNLOCK_template& getcall_template, const COMPONENT_template& sender_template, const MUTEX__UNLOCK_call_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::sender__does__not__match__from__clause,
(TTCN_Logger::begin_event(log_sev, TRUE), sender_template.log_match(proc_queue_head->sender_component),  TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else if (proc_queue_head->item_selection != CALL_1) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a call for signature @Mutex.MUTEX_UNLOCK.", port_name);
return ALT_NO;
} else if (!getcall_template.match_call(*proc_queue_head->call_1)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__call__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getcall_template.log_match_call(*proc_queue_head->call_1), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->call_1);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getcall_template.log_match_call(*proc_queue_head->call_1);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::call__op, proc_queue_head->sender_component, TRUE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->call_1->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
return ALT_YES;
}
}

alt_status MutexPT::getreply(const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first entity in the queue does not match the from clause: ", port_name);
sender_template.log_match(proc_queue_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else switch (proc_queue_head->item_selection) {
case REPLY_0:
{
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS, "Matching on port %s succeeded.", port_name);
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::reply__op, proc_queue_head->sender_component,
FALSE, CHARSTRING(0, NULL), msg_head_count+1);
}
remove_proc_queue_head();
return ALT_YES;
}
default:
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: First entity in the queue is not a reply.", port_name);
return ALT_NO;
}
}

alt_status MutexPT::check_getreply(const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first entity in the queue does not match the from clause: ", port_name);
sender_template.log_match(proc_queue_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else switch (proc_queue_head->item_selection) {
case REPLY_0:
{
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS, "Matching on port %s succeeded.", port_name);
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::reply__op, proc_queue_head->sender_component,
TRUE, CHARSTRING(0, NULL), msg_head_count+1);
}
return ALT_YES;
}
default:
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: First entity in the queue is not a reply.", port_name);
return ALT_NO;
}
}

alt_status MutexPT::getreply(const MUTEX__LOCK_template& getreply_template, const COMPONENT_template& sender_template, const MUTEX__LOCK_reply_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first entity in the queue does not match the from clause: ", port_name);
sender_template.log_match(proc_queue_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (proc_queue_head->item_selection != REPLY_0) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a reply for signature @Mutex.MUTEX_LOCK.", port_name);
return ALT_NO;
} else if (!getreply_template.match_reply(*proc_queue_head->reply_0)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__reply__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getreply_template.log_match_reply(*proc_queue_head->reply_0), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->reply_0);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getreply_template.log_match_reply(*proc_queue_head->reply_0);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::reply__op, proc_queue_head->sender_component, FALSE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->reply_0->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_proc_queue_head();
return ALT_YES;
}
}

alt_status MutexPT::check_getreply(const MUTEX__LOCK_template& getreply_template, const COMPONENT_template& sender_template, const MUTEX__LOCK_reply_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first entity in the queue does not match the from clause: ", port_name);
sender_template.log_match(proc_queue_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (proc_queue_head->item_selection != REPLY_0) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a reply for signature @Mutex.MUTEX_LOCK.", port_name);
return ALT_NO;
} else if (!getreply_template.match_reply(*proc_queue_head->reply_0)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__reply__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getreply_template.log_match_reply(*proc_queue_head->reply_0), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->reply_0);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getreply_template.log_match_reply(*proc_queue_head->reply_0);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::reply__op, proc_queue_head->sender_component, TRUE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->reply_0->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
return ALT_YES;
}
}

void MutexPT::incoming_call(const MUTEX__LOCK_call& incoming_par, component sender_component)
{
if (!is_started) {
if (is_halted) {
TTCN_warning("A call that arrived on port %s has been discarded, because the port is not started.", port_name);
return;
}
else {
TTCN_error("Port %s is not started but a call has arrived on it.", port_name);
}
}
proc_tail_count++;
if (TTCN_Logger::log_this_event(TTCN_Logger::PORTEVENT_PQUEUE)) {
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::enqueue__call, port_name, sender_component, proc_tail_count,
CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PQUEUE, TRUE), TTCN_Logger::log_char(' '), incoming_par.log(), TTCN_Logger::end_event_log2str()));
}
proc_queue_item *new_item = new proc_queue_item;
new_item->item_selection = CALL_0;
new_item->call_0 = new MUTEX__LOCK_call(incoming_par);
new_item->sender_component = sender_component;
append_to_proc_queue(new_item);
}

void MutexPT::incoming_call(const MUTEX__UNLOCK_call& incoming_par, component sender_component)
{
if (!is_started) {
if (is_halted) {
TTCN_warning("A call that arrived on port %s has been discarded, because the port is not started.", port_name);
return;
}
else {
TTCN_error("Port %s is not started but a call has arrived on it.", port_name);
}
}
proc_tail_count++;
if (TTCN_Logger::log_this_event(TTCN_Logger::PORTEVENT_PQUEUE)) {
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::enqueue__call, port_name, sender_component, proc_tail_count,
CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PQUEUE, TRUE), TTCN_Logger::log_char(' '), incoming_par.log(), TTCN_Logger::end_event_log2str()));
}
proc_queue_item *new_item = new proc_queue_item;
new_item->item_selection = CALL_1;
new_item->call_1 = new MUTEX__UNLOCK_call(incoming_par);
new_item->sender_component = sender_component;
append_to_proc_queue(new_item);
}

void MutexPT::incoming_reply(const MUTEX__LOCK_reply& incoming_par, component sender_component)
{
if (!is_started) {
if (is_halted) {
TTCN_warning("A reply that arrived on port %s has been discarded, because the port is not started.", port_name);
return;
}
else {
TTCN_error("Port %s is not started but a reply has arrived on it.", port_name);
}
}
proc_tail_count++;
if (TTCN_Logger::log_this_event(TTCN_Logger::PORTEVENT_PQUEUE)) {
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::enqueue__reply, port_name, sender_component, proc_tail_count,
CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PQUEUE, TRUE), TTCN_Logger::log_char(' '), incoming_par.log(), TTCN_Logger::end_event_log2str()));
}
proc_queue_item *new_item = new proc_queue_item;
new_item->item_selection = REPLY_0;
new_item->reply_0 = new MUTEX__LOCK_reply(incoming_par);
new_item->sender_component = sender_component;
append_to_proc_queue(new_item);
}

boolean MutexPT::process_call(const char *signature_name, Text_Buf& incoming_buf, component sender_component)
{
if (!strcmp(signature_name, "@Mutex.MUTEX_LOCK")) {
MUTEX__LOCK_call incoming_par;
incoming_par.decode_text(incoming_buf);
incoming_call(incoming_par, sender_component);
return TRUE;
} else if (!strcmp(signature_name, "@Mutex.MUTEX_UNLOCK")) {
MUTEX__UNLOCK_call incoming_par;
incoming_par.decode_text(incoming_buf);
incoming_call(incoming_par, sender_component);
return TRUE;
} else return FALSE;
}

boolean MutexPT::process_reply(const char *signature_name, Text_Buf& incoming_buf, component sender_component)
{
if (!strcmp(signature_name, "@Mutex.MUTEX_LOCK")) {
MUTEX__LOCK_reply incoming_par;
incoming_par.decode_text(incoming_buf);
incoming_reply(incoming_par, sender_component);
return TRUE;
} else return FALSE;
}

void MUTEX__LOCK_call::log() const
{
TTCN_Logger::log_event_str("@Mutex.MUTEX_LOCK : { }");
}

void MUTEX__LOCK_reply::encode_text(Text_Buf& text_buf) const
{
param_ref.encode_text(text_buf);
}

void MUTEX__LOCK_reply::decode_text(Text_Buf& text_buf)
{
param_ref.decode_text(text_buf);
}

void MUTEX__LOCK_reply::log() const
{
TTCN_Logger::log_event_str("@Mutex.MUTEX_LOCK : { ");
TTCN_Logger::log_event_str("ref := ");
param_ref.log();
TTCN_Logger::log_event_str(" }");
}

void MUTEX__LOCK_reply_redirect::set_parameters(const MUTEX__LOCK_reply& reply_par) const
{
if (ptr_ref != NULL) *ptr_ref = reply_par.ref();
}

MUTEX__LOCK_template::MUTEX__LOCK_template()
 : param_ref(ANY_VALUE)
{
}

MUTEX__LOCK_reply MUTEX__LOCK_template::create_reply() const
{
MUTEX__LOCK_reply ret_val;
ret_val.ref() = param_ref.valueof();
return ret_val;
}

boolean MUTEX__LOCK_template::match_reply(const MUTEX__LOCK_reply& match_value, boolean legacy) const
{
return param_ref.match(match_value.ref(), legacy);
}

void MUTEX__LOCK_template::log() const
{
TTCN_Logger::log_event_str("{ ref := ");
param_ref.log();
TTCN_Logger::log_event_str(" }");
}

void MUTEX__LOCK_template::log_match_call(const MUTEX__LOCK_call& , boolean) const
{
TTCN_Logger::log_event_str("{ } with { } matched");
}

void MUTEX__LOCK_template::log_match_reply(const MUTEX__LOCK_reply& match_value, boolean legacy) const
{
TTCN_Logger::log_event_str("{ ref := ");
param_ref.log_match(match_value.ref(), legacy);
TTCN_Logger::log_event_str(" }");
}

void MUTEX__LOCK_template::encode_text(Text_Buf& text_buf) const
{
param_ref.encode_text(text_buf);
}

void MUTEX__LOCK_template::decode_text(Text_Buf& text_buf)
{
param_ref.decode_text(text_buf);
}

void MUTEX__UNLOCK_call::encode_text(Text_Buf& text_buf) const
{
param_ref.encode_text(text_buf);
}

void MUTEX__UNLOCK_call::decode_text(Text_Buf& text_buf)
{
param_ref.decode_text(text_buf);
}

void MUTEX__UNLOCK_call::log() const
{
TTCN_Logger::log_event_str("@Mutex.MUTEX_UNLOCK : { ");
TTCN_Logger::log_event_str("ref := ");
param_ref.log();
TTCN_Logger::log_event_str(" }");
}

void MUTEX__UNLOCK_call_redirect::set_parameters(const MUTEX__UNLOCK_call& call_par) const
{
if (ptr_ref != NULL) *ptr_ref = call_par.ref();
}

MUTEX__UNLOCK_template::MUTEX__UNLOCK_template()
 : param_ref(ANY_VALUE)
{
}

MUTEX__UNLOCK_call MUTEX__UNLOCK_template::create_call() const
{
MUTEX__UNLOCK_call ret_val;
ret_val.ref() = param_ref.valueof();
return ret_val;
}

boolean MUTEX__UNLOCK_template::match_call(const MUTEX__UNLOCK_call& match_value, boolean legacy) const
{
return param_ref.match(match_value.ref(), legacy);
}

void MUTEX__UNLOCK_template::log() const
{
TTCN_Logger::log_event_str("{ ref := ");
param_ref.log();
TTCN_Logger::log_event_str(" }");
}

void MUTEX__UNLOCK_template::log_match_call(const MUTEX__UNLOCK_call& match_value, boolean legacy) const
{
TTCN_Logger::log_event_str("{ ref := ");
param_ref.log_match(match_value.ref(), legacy);
TTCN_Logger::log_event_str(" }");
}

void MUTEX__UNLOCK_template::encode_text(Text_Buf& text_buf) const
{
param_ref.encode_text(text_buf);
}

void MUTEX__UNLOCK_template::decode_text(Text_Buf& text_buf)
{
param_ref.decode_text(text_buf);
}


/* Bodies of functions, altsteps and testcases */

void f__MutexDisp__main()
{
TTCN_Location current_location("Mutex.ttcn", 34, TTCN_Location::LOCATION_FUNCTION, "f_MutexDisp_main");
current_location.update_lineno(36);
/* Mutex.ttcn, line 36 */
BOOLEAN locked(FALSE);
current_location.update_lineno(37);
/* Mutex.ttcn, line 37 */
COMPONENT vc__conn;
current_location.update_lineno(39);
/* Mutex.ttcn, line 39 */
MutexCT_component_g__mutex__ref = 0;
current_location.update_lineno(41);
/* Mutex.ttcn, line 41 */
{
tmp_1:
alt_status tmp_1_alt_flag_0 = ALT_UNCHECKED;
alt_status tmp_1_alt_flag_1 = ALT_UNCHECKED;
alt_status tmp_1_alt_flag_2 = ALT_UNCHECKED;
alt_status tmp_1_alt_flag_3 = ALT_UNCHECKED;
alt_status tmp_1_default_flag = ALT_MAYBE;
boolean first_run = TRUE;
TTCN_Snapshot::take_new(FALSE);
for ( ; ; ) {
if (tmp_1_alt_flag_0 == ALT_UNCHECKED) {
current_location.update_lineno(42);
/* Mutex.ttcn, line 42 */
if ((!(locked))) tmp_1_alt_flag_0 = ALT_MAYBE;
else tmp_1_alt_flag_0 = ALT_NO;
}
if (tmp_1_alt_flag_0 == ALT_MAYBE) {
current_location.update_lineno(42);
/* Mutex.ttcn, line 42 */
{
MUTEX__LOCK_template tmp_2;
tmp_2.ref() = ANY_VALUE;
tmp_1_alt_flag_0 = MutexCT_component_LOCK.getcall(tmp_2, any_compref, MUTEX__LOCK_call_redirect(), &(vc__conn), NULL, NULL);
}
if (tmp_1_alt_flag_0 == ALT_YES) {
current_location.update_lineno(43);
/* Mutex.ttcn, line 43 */
{
MUTEX__LOCK_template tmp_3;
tmp_3.ref() = MutexCT_component_g__mutex__ref;
MutexCT_component_LOCK.reply(tmp_3, COMPONENT(vc__conn), NULL);
}
current_location.update_lineno(44);
/* Mutex.ttcn, line 44 */
locked = TRUE;
current_location.update_lineno(45);
/* Mutex.ttcn, line 45 */
goto tmp_1;
}
}
if (tmp_1_alt_flag_1 == ALT_UNCHECKED) {
current_location.update_lineno(47);
/* Mutex.ttcn, line 47 */
if (locked) tmp_1_alt_flag_1 = ALT_MAYBE;
else tmp_1_alt_flag_1 = ALT_NO;
}
if (tmp_1_alt_flag_1 == ALT_MAYBE) {
current_location.update_lineno(47);
/* Mutex.ttcn, line 47 */
{
MUTEX__UNLOCK_template tmp_5;
tmp_5.ref() = MutexCT_component_g__mutex__ref;
tmp_1_alt_flag_1 = MutexCT_component_UNLOCK.getcall(tmp_5, any_compref, MUTEX__UNLOCK_call_redirect(), NULL, NULL, NULL);
}
if (tmp_1_alt_flag_1 == ALT_YES) {
current_location.update_lineno(48);
/* Mutex.ttcn, line 48 */
{
INTEGER tmp_6;
++MutexCT_component_g__mutex__ref;
}
current_location.update_lineno(49);
/* Mutex.ttcn, line 49 */
locked = FALSE;
current_location.update_lineno(50);
/* Mutex.ttcn, line 50 */
goto tmp_1;
}
}
if (tmp_1_alt_flag_2 == ALT_UNCHECKED) {
current_location.update_lineno(52);
/* Mutex.ttcn, line 52 */
if ((!(locked))) tmp_1_alt_flag_2 = ALT_MAYBE;
else tmp_1_alt_flag_2 = ALT_NO;
}
if (tmp_1_alt_flag_2 == ALT_MAYBE) {
current_location.update_lineno(52);
/* Mutex.ttcn, line 52 */
tmp_1_alt_flag_2 = MutexCT_component_UNLOCK.getcall(any_compref, &(vc__conn), NULL, NULL);
if (tmp_1_alt_flag_2 == ALT_YES) {
current_location.update_lineno(53);
/* Mutex.ttcn, line 53 */
TTCN_Runtime::setverdict(FAIL,(TTCN_Logger::begin_event_log2str(),TTCN_Logger::log_event_str("f_MutexDisp_main(): mutex unlock without prior lock from "),vc__conn.log(),TTCN_Logger::end_event_log2str()));
current_location.update_lineno(55);
/* Mutex.ttcn, line 55 */
Misc__Helpers::f__shutdown(cs_0, 55, Misc__Helpers::f__shutdown_verdict_defval, Misc__Helpers::f__shutdown_text_defval);
break;
}
}
if (tmp_1_alt_flag_3 == ALT_UNCHECKED) {
current_location.update_lineno(57);
/* Mutex.ttcn, line 57 */
if (locked) tmp_1_alt_flag_3 = ALT_MAYBE;
else tmp_1_alt_flag_3 = ALT_NO;
}
if (tmp_1_alt_flag_3 == ALT_MAYBE) {
current_location.update_lineno(57);
/* Mutex.ttcn, line 57 */
{
MUTEX__UNLOCK_template tmp_8;
tmp_8.ref() = ANY_VALUE;
tmp_1_alt_flag_3 = MutexCT_component_UNLOCK.getcall(tmp_8, any_compref, MUTEX__UNLOCK_call_redirect(), &(vc__conn), NULL, NULL);
}
if (tmp_1_alt_flag_3 == ALT_YES) {
current_location.update_lineno(58);
/* Mutex.ttcn, line 58 */
TTCN_Runtime::setverdict(FAIL,(TTCN_Logger::begin_event_log2str(),TTCN_Logger::log_event_str("f_MutexDisp_main(): mutex unlock was not unexpected from "),vc__conn.log(),TTCN_Logger::end_event_log2str()));
current_location.update_lineno(60);
/* Mutex.ttcn, line 60 */
Misc__Helpers::f__shutdown(cs_0, 60, Misc__Helpers::f__shutdown_verdict_defval, Misc__Helpers::f__shutdown_text_defval);
break;
}
}
if (tmp_1_default_flag == ALT_MAYBE) {
tmp_1_default_flag = TTCN_Default::try_altsteps(first_run);
if (tmp_1_default_flag == ALT_YES || tmp_1_default_flag == ALT_BREAK) break;
else if (tmp_1_default_flag == ALT_REPEAT) goto tmp_1;
}
current_location.update_lineno(41);
/* Mutex.ttcn, line 41 */
if (tmp_1_alt_flag_0 == ALT_NO && tmp_1_alt_flag_1 == ALT_NO && tmp_1_alt_flag_2 == ALT_NO && tmp_1_alt_flag_3 == ALT_NO && tmp_1_default_flag == ALT_NO) TTCN_error("None of the branches can be chosen in the alt statement in file Mutex.ttcn between lines 41 and 62.");
TTCN_Snapshot::take_new(TRUE);
first_run = FALSE;
}
}
}

void start_f__MutexDisp__main(const COMPONENT& component_reference)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_MutexDisp_main(");
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "Mutex", "f_MutexDisp_main", text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

COMPONENT f__MutexDisp__start()
{
TTCN_Location current_location("Mutex.ttcn", 66, TTCN_Location::LOCATION_FUNCTION, "f_MutexDisp_start");
current_location.update_lineno(68);
/* Mutex.ttcn, line 68 */
COMPONENT vc__disp;
current_location.update_lineno(70);
/* Mutex.ttcn, line 70 */
vc__disp = TTCN_Runtime::create_component("Mutex", "MutexDispCT", (cs_1 + TTCN_Runtime::get_testcasename()), NULL, TRUE);
current_location.update_lineno(71);
/* Mutex.ttcn, line 71 */
start_f__MutexDisp__main(vc__disp);
current_location.update_lineno(73);
/* Mutex.ttcn, line 73 */
return vc__disp;
}

void f__MutexDisp__connect(const COMPONENT& vc__disp, const COMPONENT& vc__conn)
{
TTCN_Location current_location("Mutex.ttcn", 77, TTCN_Location::LOCATION_FUNCTION, "f_MutexDisp_connect");
current_location.update_lineno(79);
/* Mutex.ttcn, line 79 */
TTCN_Runtime::connect_port(vc__disp, MutexCT_component_LOCK.get_name(), vc__conn, MutexCT_component_LOCK.get_name());
current_location.update_lineno(80);
/* Mutex.ttcn, line 80 */
TTCN_Runtime::connect_port(vc__disp, MutexCT_component_UNLOCK.get_name(), vc__conn, MutexCT_component_UNLOCK.get_name());
}

void f__Mutex__lock(const CHARSTRING& file, const INTEGER& line, const FLOAT& Tval)
{
TTCN_Location current_location("Mutex.ttcn", 84, TTCN_Location::LOCATION_FUNCTION, "f_Mutex_lock");
current_location.update_lineno(87);
/* Mutex.ttcn, line 87 */
{
MUTEX__LOCK_template tmp_10;
MutexCT_component_LOCK.call(tmp_10, FALSE, NULL);
}
{
current_location.update_lineno(87);
/* Mutex.ttcn, line 87 */
TIMER call_timer;
call_timer.start(Tval);
alt_status tmp_11_alt_flag_0 = ALT_MAYBE;
alt_status tmp_11_alt_flag_1 = ALT_MAYBE;
current_location.update_lineno(87);
/* Mutex.ttcn, line 87 */
TTCN_Snapshot::take_new(FALSE);
for ( ; ; ) {
if (tmp_11_alt_flag_0 == ALT_MAYBE) {
current_location.update_lineno(88);
/* Mutex.ttcn, line 88 */
{
MUTEX__LOCK_template tmp_12;
tmp_12.ref() = ANY_VALUE;
tmp_11_alt_flag_0 = MutexCT_component_LOCK.getreply(tmp_12, any_compref, MUTEX__LOCK_reply_redirect(&(MutexCT_component_g__mutex__ref)), NULL, NULL, NULL);
}
if (tmp_11_alt_flag_0 == ALT_YES) {
current_location.update_lineno(89);
/* Mutex.ttcn, line 89 */
try {
TTCN_Logger::begin_event(TTCN_USER);
TTCN_Logger::log_event_str("f_Mutex_lock(): mutex acquired @ ");
file.log();
TTCN_Logger::log_char(':');
line.log();
TTCN_Logger::end_event();
} catch (...) {
TTCN_Logger::finish_event();
throw;
}
break;
}
}
if (tmp_11_alt_flag_1 == ALT_MAYBE) {
current_location.update_lineno(91);
/* Mutex.ttcn, line 91 */
tmp_11_alt_flag_1 = call_timer.timeout();
if (tmp_11_alt_flag_1 == ALT_YES) {
current_location.update_lineno(92);
/* Mutex.ttcn, line 92 */
TTCN_Runtime::setverdict(FAIL,(TTCN_Logger::begin_event_log2str(),TTCN_Logger::log_event_str("f_Mutex_lock(): timeout @ "),file.log(),TTCN_Logger::log_char(':'),line.log(),TTCN_Logger::end_event_log2str()));
current_location.update_lineno(93);
/* Mutex.ttcn, line 93 */
Misc__Helpers::f__shutdown(file, line, Misc__Helpers::f__shutdown_verdict_defval, Misc__Helpers::f__shutdown_text_defval);
break;
}
}
current_location.update_lineno(87);
/* Mutex.ttcn, line 87 */
if (tmp_11_alt_flag_0 == ALT_NO && tmp_11_alt_flag_1 == ALT_NO) TTCN_error("None of the branches can be chosen in the response and exception handling part of call statement in file Mutex.ttcn between lines 87 and 95.");
TTCN_Snapshot::take_new(TRUE);
}
}
}

void start_f__Mutex__lock(const COMPONENT& component_reference, const CHARSTRING& file, const INTEGER& line, const FLOAT& Tval)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_Mutex_lock(");
file.log();
TTCN_Logger::log_event_str(", ");
line.log();
TTCN_Logger::log_event_str(", ");
Tval.log();
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "Mutex", "f_Mutex_lock", text_buf);
file.encode_text(text_buf);
line.encode_text(text_buf);
Tval.encode_text(text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

void f__Mutex__unlock(const CHARSTRING& file, const INTEGER& line)
{
TTCN_Location current_location("Mutex.ttcn", 99, TTCN_Location::LOCATION_FUNCTION, "f_Mutex_unlock");
current_location.update_lineno(101);
/* Mutex.ttcn, line 101 */
{
MUTEX__UNLOCK_template tmp_13;
tmp_13.ref() = MutexCT_component_g__mutex__ref;
MutexCT_component_UNLOCK.call(tmp_13, FALSE, NULL);
}
current_location.update_lineno(102);
/* Mutex.ttcn, line 102 */
try {
TTCN_Logger::begin_event(TTCN_USER);
TTCN_Logger::log_event_str("f_Mutex_unlock(): mutex released @ ");
file.log();
TTCN_Logger::log_char(':');
line.log();
TTCN_Logger::end_event();
} catch (...) {
TTCN_Logger::finish_event();
throw;
}
}

void start_f__Mutex__unlock(const COMPONENT& component_reference, const CHARSTRING& file, const INTEGER& line)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_Mutex_unlock(");
file.log();
TTCN_Logger::log_event_str(", ");
line.log();
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "Mutex", "f_Mutex_unlock", text_buf);
file.encode_text(text_buf);
line.encode_text(text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

void f__TC__selftest()
{
TTCN_Location current_location("Mutex.ttcn", 110, TTCN_Location::LOCATION_FUNCTION, "f_TC_selftest");
current_location.update_lineno(112);
/* Mutex.ttcn, line 112 */
f__Mutex__lock(cs_0, 112, f__Mutex__lock_Tval_defval);
current_location.update_lineno(114);
/* Mutex.ttcn, line 114 */
f__Mutex__unlock(cs_0, 114);
current_location.update_lineno(115);
/* Mutex.ttcn, line 115 */
TTCN_Runtime::setverdict(PASS);
}

void start_f__TC__selftest(const COMPONENT& component_reference)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_TC_selftest(");
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "Mutex", "f_TC_selftest", text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

verdicttype testcase_TC__selftest(boolean has_timer, double timer_value)
{
TTCN_Runtime::check_begin_testcase(has_timer, timer_value);
TTCN_Location current_location("Mutex.ttcn", 118, TTCN_Location::LOCATION_TESTCASE, "TC_selftest");
try {
TTCN_Runtime::begin_testcase("Mutex", "TC_selftest", "Mutex", "TestCT", "Mutex", "TestCT", has_timer, timer_value);
current_location.update_lineno(119);
/* Mutex.ttcn, line 119 */
VALUE_ARRAY<COMPONENT, 42, 0> vc__conns;
current_location.update_lineno(120);
/* Mutex.ttcn, line 120 */
COMPONENT vc__disp;
current_location.update_lineno(122);
/* Mutex.ttcn, line 122 */
vc__disp = f__MutexDisp__start();
{
current_location.update_lineno(124);
/* Mutex.ttcn, line 124 */
INTEGER i(0);
current_location.update_lineno(124);
/* Mutex.ttcn, line 124 */
for ( ; ; ) {
current_location.update_lineno(124);
/* Mutex.ttcn, line 124 */
if (!(i < 42)) break;
current_location.update_lineno(125);
/* Mutex.ttcn, line 125 */
vc__conns[i] = TTCN_Runtime::create_component("Mutex", "TestChildCT", (cs_2 + int2str(i)), NULL, FALSE);
current_location.update_lineno(126);
/* Mutex.ttcn, line 126 */
f__MutexDisp__connect(vc__disp, const_cast< const VALUE_ARRAY<COMPONENT, 42, 0>&>(vc__conns)[i]);
current_location.update_lineno(127);
/* Mutex.ttcn, line 127 */
start_f__TC__selftest(const_cast< const VALUE_ARRAY<COMPONENT, 42, 0>&>(vc__conns)[i]);
current_location.update_lineno(124);
/* Mutex.ttcn, line 124 */
{
INTEGER tmp_16;
++i;
}
}
}
{
current_location.update_lineno(130);
/* Mutex.ttcn, line 130 */
INTEGER i(0);
current_location.update_lineno(130);
/* Mutex.ttcn, line 130 */
for ( ; ; ) {
current_location.update_lineno(130);
/* Mutex.ttcn, line 130 */
if (!(i < 42)) break;
current_location.update_lineno(131);
/* Mutex.ttcn, line 131 */
{
tmp_17:
alt_status alt_flag = ALT_UNCHECKED, default_flag = ALT_UNCHECKED;
boolean first_run = TRUE;
TTCN_Snapshot::take_new(FALSE);
for ( ; ; ) {
if (alt_flag != ALT_NO) {
alt_flag = const_cast< const VALUE_ARRAY<COMPONENT, 42, 0>&>(vc__conns)[i].done(NULL, NULL);
if (alt_flag == ALT_YES) break;
else if (alt_flag == ALT_REPEAT) goto tmp_17;
}
if (default_flag != ALT_NO) {
default_flag = TTCN_Default::try_altsteps(first_run);
if (default_flag == ALT_YES || default_flag == ALT_BREAK) break;
else if (default_flag == ALT_REPEAT) goto tmp_17;
}
current_location.update_lineno(131);
/* Mutex.ttcn, line 131 */
if (alt_flag == ALT_NO && default_flag == ALT_NO) TTCN_error("Stand-alone done statement failed in file Mutex.ttcn, line 131.");
TTCN_Snapshot::take_new(TRUE);
first_run = FALSE;
}
}
current_location.update_lineno(130);
/* Mutex.ttcn, line 130 */
{
INTEGER tmp_18;
++i;
}
}
}
} catch (const TC_Error& tc_error) {
} catch (const TC_End& tc_end) {
TTCN_Logger::log_str(TTCN_FUNCTION, "Test case TC_selftest was stopped.");
}
return TTCN_Runtime::end_testcase();
}


/* Bodies of static functions */

void pre_init_module()
{
TTCN_Location current_location("Mutex.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "Mutex");
Misc__Helpers::module_object.pre_init_module();
module_object.add_function("f_MutexDisp_main", (genericfunc_t)&f__MutexDisp__main, (genericfunc_t)&start_f__MutexDisp__main);
module_object.add_function("f_MutexDisp_start", (genericfunc_t)&f__MutexDisp__start, NULL);
module_object.add_function("f_MutexDisp_connect", (genericfunc_t)&f__MutexDisp__connect, NULL);
module_object.add_function("f_Mutex_lock", (genericfunc_t)&f__Mutex__lock, (genericfunc_t)&start_f__Mutex__lock);
module_object.add_function("f_Mutex_unlock", (genericfunc_t)&f__Mutex__unlock, (genericfunc_t)&start_f__Mutex__unlock);
module_object.add_function("f_TC_selftest", (genericfunc_t)&f__TC__selftest, (genericfunc_t)&start_f__TC__selftest);
module_object.add_testcase_nonpard("TC_selftest", testcase_TC__selftest);
}

void post_init_module()
{
TTCN_Location current_location("Mutex.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "Mutex");
Misc__Helpers::module_object.post_init_module();
current_location.update_lineno(85);
/* Mutex.ttcn, line 85 */
const_f__Mutex__lock_Tval_defval = 1.0e1;
}

boolean init_comp_type(const char *component_type, boolean init_base_comps)
{
(void)init_base_comps;
if (!strcmp(component_type, "MutexCT")) {
MutexCT_component_LOCK.activate_port();
MutexCT_component_UNLOCK.activate_port();
MutexCT_component_g__mutex__ref.clean_up();
return TRUE;
} else if (!strcmp(component_type, "MutexDispCT")) {
if (init_base_comps) {
init_comp_type("MutexCT", FALSE);
}
return TRUE;
} else if (!strcmp(component_type, "TestCT")) {
return TRUE;
} else if (!strcmp(component_type, "TestChildCT")) {
if (init_base_comps) {
init_comp_type("MutexCT", FALSE);
}
return TRUE;
} else return FALSE;
}

boolean init_system_port(const char* component_type, const char* port_name)
{
if (!strcmp(component_type, "MutexCT")) {
if (!strcmp(port_name, "LOCK")) {
MutexCT_component_LOCK.safe_start();
return TRUE;
}
if (!strcmp(port_name, "UNLOCK")) {
MutexCT_component_UNLOCK.safe_start();
return TRUE;
}
}
else if (!strcmp(component_type, "MutexDispCT")) {
if (!strcmp(port_name, "LOCK")) {
MutexCT_component_LOCK.safe_start();
return TRUE;
}
if (!strcmp(port_name, "UNLOCK")) {
MutexCT_component_UNLOCK.safe_start();
return TRUE;
}
}
else if (!strcmp(component_type, "TestChildCT")) {
if (!strcmp(port_name, "LOCK")) {
MutexCT_component_LOCK.safe_start();
return TRUE;
}
if (!strcmp(port_name, "UNLOCK")) {
MutexCT_component_UNLOCK.safe_start();
return TRUE;
}
}
return FALSE;
}

boolean start_ptc_function(const char *function_name, Text_Buf& function_arguments)
{
if (!strcmp(function_name, "f_MutexDisp_main")) {
TTCN_Logger::log_str(TTCN_Logger::PARALLEL_PTC, "Starting function f_MutexDisp_main().");
TTCN_Runtime::function_started(function_arguments);
f__MutexDisp__main();
TTCN_Runtime::function_finished("f_MutexDisp_main");
return TRUE;
} else if (!strcmp(function_name, "f_Mutex_lock")) {
CHARSTRING file;
INTEGER line;
FLOAT Tval;
file.decode_text(function_arguments);
line.decode_text(function_arguments);
Tval.decode_text(function_arguments);
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_Mutex_lock(");
file.log();
TTCN_Logger::log_event_str(", ");
line.log();
TTCN_Logger::log_event_str(", ");
Tval.log();
TTCN_Logger::log_event_str(").");
TTCN_Logger::end_event();
TTCN_Runtime::function_started(function_arguments);
f__Mutex__lock(file, line, Tval);
TTCN_Runtime::function_finished("f_Mutex_lock");
return TRUE;
} else if (!strcmp(function_name, "f_Mutex_unlock")) {
CHARSTRING file;
INTEGER line;
file.decode_text(function_arguments);
line.decode_text(function_arguments);
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_Mutex_unlock(");
file.log();
TTCN_Logger::log_event_str(", ");
line.log();
TTCN_Logger::log_event_str(").");
TTCN_Logger::end_event();
TTCN_Runtime::function_started(function_arguments);
f__Mutex__unlock(file, line);
TTCN_Runtime::function_finished("f_Mutex_unlock");
return TRUE;
} else if (!strcmp(function_name, "f_TC_selftest")) {
TTCN_Logger::log_str(TTCN_Logger::PARALLEL_PTC, "Starting function f_TC_selftest().");
TTCN_Runtime::function_started(function_arguments);
f__TC__selftest();
TTCN_Runtime::function_finished("f_TC_selftest");
return TRUE;
} else return FALSE;
}


} /* end of namespace */
