<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>
<tagfile doxygen_version="1.9.4">
  <compound kind="file">
    <name>cfile.h</name>
    <path>/build/coverity/source-Osmocom/libosmo-dsp/include/osmocom/dsp/</path>
    <filename>cfile_8h.html</filename>
    <class kind="struct">cfile</class>
    <member kind="function">
      <type>struct cfile *</type>
      <name>cfile_load</name>
      <anchorfile>group__cfile.html</anchorfile>
      <anchor>gacb0304d89096222df64f3f9a10f22167</anchor>
      <arglist>(const char *filename)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cfile_release</name>
      <anchorfile>group__cfile.html</anchorfile>
      <anchor>ga7728a89f370281e5da16ff27d8657b3d</anchor>
      <arglist>(struct cfile *cf)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>cxvec.h</name>
    <path>/build/coverity/source-Osmocom/libosmo-dsp/include/osmocom/dsp/</path>
    <filename>cxvec_8h.html</filename>
    <class kind="struct">osmo_cxvec</class>
    <member kind="function">
      <type>void</type>
      <name>osmo_cxvec_init_from_data</name>
      <anchorfile>group__cxvec.html</anchorfile>
      <anchor>gaa03ae6bbc24d094b8955d905832f0c36</anchor>
      <arglist>(struct osmo_cxvec *cv, float complex *data, int len)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_alloc_from_data</name>
      <anchorfile>group__cxvec.html</anchorfile>
      <anchor>ga4edecda809e91f11cf88b53a1db8d62a</anchor>
      <arglist>(float complex *data, int len)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_alloc</name>
      <anchorfile>group__cxvec.html</anchorfile>
      <anchor>ga9461ac13f1d77ca832b140461e599caa</anchor>
      <arglist>(int max_len)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_cxvec_free</name>
      <anchorfile>group__cxvec.html</anchorfile>
      <anchor>gaa57240ff2299122f9375e901b9700e7d</anchor>
      <arglist>(struct osmo_cxvec *cv)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_cxvec_dbg_dump</name>
      <anchorfile>group__cxvec.html</anchorfile>
      <anchor>ga69e6d1ea3d468954cedf7d6f8d44f825</anchor>
      <arglist>(struct osmo_cxvec *cv, const char *fname)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>cxvec_math.h</name>
    <path>/build/coverity/source-Osmocom/libosmo-dsp/include/osmocom/dsp/</path>
    <filename>cxvec__math_8h.html</filename>
    <member kind="enumeration">
      <type></type>
      <name>osmo_cxvec_conv_type</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga2e183a0f24afa2e16199d1514629bf08</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONV_FULL_SPAN</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>gga2e183a0f24afa2e16199d1514629bf08ae758172bda42f9b44aa9015c0e142717</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONV_OVERLAP_ONLY</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>gga2e183a0f24afa2e16199d1514629bf08a47fb2e6e9d274d4512601828023ac1d2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONV_NO_DELAY</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>gga2e183a0f24afa2e16199d1514629bf08a03ece74c3bcd50aeb9fb42329b9a59a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>osmo_cxvec_peak_alg</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga7942b58b341e440c0e8796d395460b78</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PEAK_WEIGH_WIN</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>gga7942b58b341e440c0e8796d395460b78abb4b91d1bfa5bd51ff0e48633d9b9891</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PEAK_WEIGH_WIN_CENTER</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>gga7942b58b341e440c0e8796d395460b78ab0fb6b29112253cc5d51fb119b5d812a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PEAK_EARLY_LATE</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>gga7942b58b341e440c0e8796d395460b78aa8df843abc147bca5860fee1ddff1378</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static float</type>
      <name>osmo_sinc</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga4e7a7183dc4e5ce77d72d2986495f348</anchor>
      <arglist>(float x)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static float</type>
      <name>osmo_normsqf</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga1b169ec31cb01111c0def0c12d65f3a2</anchor>
      <arglist>(float complex c)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_scale</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga5ac0adb49726087258381582582ef654</anchor>
      <arglist>(const struct osmo_cxvec *in, float complex scale, struct osmo_cxvec *out)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_rotate</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga49125f3c259da9d7eec7fa4d98d609d4</anchor>
      <arglist>(const struct osmo_cxvec *in, float rps, struct osmo_cxvec *out)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_delay</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga9fa20d926f9d313a4751cef1eff740ba</anchor>
      <arglist>(const struct osmo_cxvec *in, float delay, struct osmo_cxvec *out)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_convolve</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga2ebadb16e25768896013420a98ec666f</anchor>
      <arglist>(const struct osmo_cxvec *f, const struct osmo_cxvec *g, enum osmo_cxvec_conv_type type, struct osmo_cxvec *out)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_correlate</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga99ff6e3baec3253f4e431b156f042a0f</anchor>
      <arglist>(const struct osmo_cxvec *f, const struct osmo_cxvec *g, int g_corr_step, struct osmo_cxvec *out)</arglist>
    </member>
    <member kind="function">
      <type>float complex</type>
      <name>osmo_cxvec_interpolate_point</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>gacb1c646e03a09b51b617467501639763</anchor>
      <arglist>(const struct osmo_cxvec *cv, float pos)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_cxvec_peaks_scan</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>gad25b04feb1cd30b24fe7de8f76e56c23</anchor>
      <arglist>(const struct osmo_cxvec *cv, int *peaks_idx, int N)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>osmo_cxvec_peak_energy_find</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga495219ee953336e15cd68c9b22d3850c</anchor>
      <arglist>(const struct osmo_cxvec *cv, int win_size, enum osmo_cxvec_peak_alg alg, float complex *peak_val_p)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_sig_normalize</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga4579583a658fc33afd24a1d8508b212f</anchor>
      <arglist>(const struct osmo_cxvec *sig, int decim, float freq_shift, struct osmo_cxvec *out)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>iqbal.h</name>
    <path>/build/coverity/source-Osmocom/libosmo-dsp/include/osmocom/dsp/</path>
    <filename>iqbal_8h.html</filename>
    <class kind="struct">osmo_iqbal_opts</class>
    <member kind="function">
      <type>void</type>
      <name>osmo_iqbal_fix</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>gaaca46bab25fe24148c3cb3c4d2158c79</anchor>
      <arglist>(float complex *out, float complex *in, unsigned int len, float mag, float phase)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_iqbal_cxvec_fix</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga978fbf1c9f01694852c561c95d5ceb9d</anchor>
      <arglist>(const struct osmo_cxvec *in, float mag, float phase, struct osmo_cxvec *out)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>osmo_iqbal_estimate</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga23c6972ae206b4a60dbe49d954fc9caa</anchor>
      <arglist>(const float complex *data, int fft_size, int fft_count)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>osmo_iqbal_cxvec_estimate</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga19298f48b07828c19bc54038d5abe5ad</anchor>
      <arglist>(const struct osmo_cxvec *sig, int fft_size, int fft_count)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_iqbal_cxvec_optimize</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>gac74f9d37e2153fdf954e592b36f7c7c0</anchor>
      <arglist>(const struct osmo_cxvec *sig, float *mag, float *phase, const struct osmo_iqbal_opts *opts)</arglist>
    </member>
    <member kind="variable">
      <type>const struct osmo_iqbal_opts</type>
      <name>osmo_iqbal_default_opts</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga2f0587c233b021d72a98a11312ff5e9f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>cfile.c</name>
    <path>/build/coverity/source-Osmocom/libosmo-dsp/src/</path>
    <filename>cfile_8c.html</filename>
    <member kind="function">
      <type>struct cfile *</type>
      <name>cfile_load</name>
      <anchorfile>group__cfile.html</anchorfile>
      <anchor>gacb0304d89096222df64f3f9a10f22167</anchor>
      <arglist>(const char *filename)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cfile_release</name>
      <anchorfile>group__cfile.html</anchorfile>
      <anchor>ga7728a89f370281e5da16ff27d8657b3d</anchor>
      <arglist>(struct cfile *cf)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>cxvec.c</name>
    <path>/build/coverity/source-Osmocom/libosmo-dsp/src/</path>
    <filename>cxvec_8c.html</filename>
    <member kind="function">
      <type>void</type>
      <name>osmo_cxvec_init_from_data</name>
      <anchorfile>group__cxvec.html</anchorfile>
      <anchor>gaa03ae6bbc24d094b8955d905832f0c36</anchor>
      <arglist>(struct osmo_cxvec *cv, float complex *data, int len)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_alloc_from_data</name>
      <anchorfile>group__cxvec.html</anchorfile>
      <anchor>ga4edecda809e91f11cf88b53a1db8d62a</anchor>
      <arglist>(float complex *data, int len)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_alloc</name>
      <anchorfile>group__cxvec.html</anchorfile>
      <anchor>ga9461ac13f1d77ca832b140461e599caa</anchor>
      <arglist>(int max_len)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_cxvec_free</name>
      <anchorfile>group__cxvec.html</anchorfile>
      <anchor>gaa57240ff2299122f9375e901b9700e7d</anchor>
      <arglist>(struct osmo_cxvec *cv)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_cxvec_dbg_dump</name>
      <anchorfile>group__cxvec.html</anchorfile>
      <anchor>ga69e6d1ea3d468954cedf7d6f8d44f825</anchor>
      <arglist>(struct osmo_cxvec *cv, const char *fname)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>cxvec_math.c</name>
    <path>/build/coverity/source-Osmocom/libosmo-dsp/src/</path>
    <filename>cxvec__math_8c.html</filename>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_scale</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga5ac0adb49726087258381582582ef654</anchor>
      <arglist>(const struct osmo_cxvec *in, float complex scale, struct osmo_cxvec *out)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_rotate</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga49125f3c259da9d7eec7fa4d98d609d4</anchor>
      <arglist>(const struct osmo_cxvec *in, float rps, struct osmo_cxvec *out)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_delay</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga9fa20d926f9d313a4751cef1eff740ba</anchor>
      <arglist>(const struct osmo_cxvec *in, float delay, struct osmo_cxvec *out)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_convolve</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga2ebadb16e25768896013420a98ec666f</anchor>
      <arglist>(const struct osmo_cxvec *f, const struct osmo_cxvec *g, enum osmo_cxvec_conv_type type, struct osmo_cxvec *out)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_correlate</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga99ff6e3baec3253f4e431b156f042a0f</anchor>
      <arglist>(const struct osmo_cxvec *f, const struct osmo_cxvec *g, int g_corr_step, struct osmo_cxvec *out)</arglist>
    </member>
    <member kind="function">
      <type>float complex</type>
      <name>osmo_cxvec_interpolate_point</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>gacb1c646e03a09b51b617467501639763</anchor>
      <arglist>(const struct osmo_cxvec *cv, float pos)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_cxvec_peaks_scan</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>gad25b04feb1cd30b24fe7de8f76e56c23</anchor>
      <arglist>(const struct osmo_cxvec *cv, int *peaks_idx, int N)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>osmo_cxvec_peak_energy_find</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga495219ee953336e15cd68c9b22d3850c</anchor>
      <arglist>(const struct osmo_cxvec *cv, int win_size, enum osmo_cxvec_peak_alg alg, float complex *peak_val_p)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_sig_normalize</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga4579583a658fc33afd24a1d8508b212f</anchor>
      <arglist>(const struct osmo_cxvec *sig, int decim, float freq_shift, struct osmo_cxvec *out)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>iqbal.c</name>
    <path>/build/coverity/source-Osmocom/libosmo-dsp/src/</path>
    <filename>iqbal_8c.html</filename>
    <class kind="struct">_iqbal_estimate_state</class>
    <class kind="struct">_iqbal_state</class>
    <member kind="function">
      <type>void</type>
      <name>osmo_iqbal_fix</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>gaaca46bab25fe24148c3cb3c4d2158c79</anchor>
      <arglist>(float complex *out, float complex *in, unsigned int len, float mag, float phase)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_iqbal_cxvec_fix</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga978fbf1c9f01694852c561c95d5ceb9d</anchor>
      <arglist>(const struct osmo_cxvec *in, float mag, float phase, struct osmo_cxvec *out)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>_osmo_iqbal_estimate_release</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga5ece20030938ef8e8f9e1c3f2d91482a</anchor>
      <arglist>(struct _iqbal_estimate_state *state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static float</type>
      <name>_osmo_iqbal_estimate</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga129881cae54362d61dd2b4460f8af248</anchor>
      <arglist>(const float complex *data, int fft_size, int fft_count, struct _iqbal_estimate_state **state_p)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>osmo_iqbal_estimate</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga23c6972ae206b4a60dbe49d954fc9caa</anchor>
      <arglist>(const float complex *data, int fft_size, int fft_count)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>osmo_iqbal_cxvec_estimate</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga19298f48b07828c19bc54038d5abe5ad</anchor>
      <arglist>(const struct osmo_cxvec *sig, int fft_size, int fft_count)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static float</type>
      <name>_iqbal_objfn_value</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga743af26acca4fa90afcf1e67dda95dba</anchor>
      <arglist>(struct _iqbal_state *state, float x[2])</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>_iqbal_objfn_gradient</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga169a1a71bbe3ff22192dca26f4d9ef8d</anchor>
      <arglist>(struct _iqbal_state *state, float x[2], float v, float grad[2])</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static float</type>
      <name>_iqbal_objfn_val_gradient</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga62f9a247afbb52d576a1763ccd47397f</anchor>
      <arglist>(struct _iqbal_state *state, float x[2], float grad[2])</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_iqbal_cxvec_optimize</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>gac74f9d37e2153fdf954e592b36f7c7c0</anchor>
      <arglist>(const struct osmo_cxvec *sig, float *mag, float *phase, const struct osmo_iqbal_opts *opts)</arglist>
    </member>
    <member kind="variable">
      <type>const struct osmo_iqbal_opts</type>
      <name>osmo_iqbal_default_opts</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga2f0587c233b021d72a98a11312ff5e9f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>_iqbal_estimate_state</name>
    <filename>struct__iqbal__estimate__state.html</filename>
    <member kind="variable">
      <type>float complex *</type>
      <name>fft</name>
      <anchorfile>struct__iqbal__estimate__state.html</anchorfile>
      <anchor>aa44240271f4835c080793da0b816bc1c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>fftwf_plan</type>
      <name>fft_plan</name>
      <anchorfile>struct__iqbal__estimate__state.html</anchorfile>
      <anchor>a0a1a4f9083a6228f38e78702b8f710e9</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>_iqbal_state</name>
    <filename>struct__iqbal__state.html</filename>
    <member kind="variable">
      <type>const struct osmo_iqbal_opts *</type>
      <name>opts</name>
      <anchorfile>struct__iqbal__state.html</anchorfile>
      <anchor>a96f58c4debc176d484eb20b5e19b4209</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const struct osmo_cxvec *</type>
      <name>org</name>
      <anchorfile>struct__iqbal__state.html</anchorfile>
      <anchor>ab463e6d3cfc9d2f70e530dbe4f76458f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>struct osmo_cxvec *</type>
      <name>tmp</name>
      <anchorfile>struct__iqbal__state.html</anchorfile>
      <anchor>a03100dde8b80dacdd0a4936511c5ab10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>feval</name>
      <anchorfile>struct__iqbal__state.html</anchorfile>
      <anchor>ad82cbcec2dc9e52f4816cbe9a0af757f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>struct _iqbal_estimate_state *</type>
      <name>cache</name>
      <anchorfile>struct__iqbal__state.html</anchorfile>
      <anchor>a9663b19ceb3a2ab337c5ad74699e4c23</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>cfile</name>
    <filename>structcfile.html</filename>
    <member kind="variable">
      <type>float complex *</type>
      <name>data</name>
      <anchorfile>structcfile.html</anchorfile>
      <anchor>aeeb1105659968baae5df24026bf1d281</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned int</type>
      <name>len</name>
      <anchorfile>structcfile.html</anchorfile>
      <anchor>a2c856227c89a929b863da15951fcaef4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>size_t</type>
      <name>_blen</name>
      <anchorfile>structcfile.html</anchorfile>
      <anchor>ad3d6965e1039aa1f648361b2f83b034a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>osmo_cxvec</name>
    <filename>structosmo__cxvec.html</filename>
    <member kind="variable">
      <type>int</type>
      <name>len</name>
      <anchorfile>structosmo__cxvec.html</anchorfile>
      <anchor>a03722af5764b41c9151a7542546e3739</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>max_len</name>
      <anchorfile>structosmo__cxvec.html</anchorfile>
      <anchor>a42469c5c904c26c45af3ff557ccd203f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>flags</name>
      <anchorfile>structosmo__cxvec.html</anchorfile>
      <anchor>ab3bd5fac3c3a84df65bc82d1cae223ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>float complex *</type>
      <name>data</name>
      <anchorfile>structosmo__cxvec.html</anchorfile>
      <anchor>aec620e4391a60de801eb23dec73e4d12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>float complex</type>
      <name>_data</name>
      <anchorfile>structosmo__cxvec.html</anchorfile>
      <anchor>aa8a9de0ef88d44caa1c07bc91b99bffd</anchor>
      <arglist>[0]</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>osmo_iqbal_opts</name>
    <filename>structosmo__iqbal__opts.html</filename>
    <member kind="variable">
      <type>int</type>
      <name>fft_size</name>
      <anchorfile>structosmo__iqbal__opts.html</anchorfile>
      <anchor>a76e529e63af98a524caa8cf61c4de828</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>fft_count</name>
      <anchorfile>structosmo__iqbal__opts.html</anchorfile>
      <anchor>abb7854c9f674bf12022ce0b5485fd2a7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>max_iter</name>
      <anchorfile>structosmo__iqbal__opts.html</anchorfile>
      <anchor>ac6dc907d8a810172970426cac913f2b0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>start_at_prev</name>
      <anchorfile>structosmo__iqbal__opts.html</anchorfile>
      <anchor>ad36e80298fe63cb9f985401e30f768fc</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>cfile</name>
    <title>.cfile helpers</title>
    <filename>group__cfile.html</filename>
    <file>cfile.h</file>
    <file>cfile.c</file>
    <class kind="struct">cfile</class>
    <member kind="function">
      <type>struct cfile *</type>
      <name>cfile_load</name>
      <anchorfile>group__cfile.html</anchorfile>
      <anchor>gacb0304d89096222df64f3f9a10f22167</anchor>
      <arglist>(const char *filename)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cfile_release</name>
      <anchorfile>group__cfile.html</anchorfile>
      <anchor>ga7728a89f370281e5da16ff27d8657b3d</anchor>
      <arglist>(struct cfile *cf)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>cxvec</name>
    <title>Complex vectors</title>
    <filename>group__cxvec.html</filename>
    <subgroup>cxvec_math</subgroup>
    <file>cxvec.h</file>
    <file>cxvec.c</file>
    <class kind="struct">osmo_cxvec</class>
    <member kind="function">
      <type>void</type>
      <name>osmo_cxvec_init_from_data</name>
      <anchorfile>group__cxvec.html</anchorfile>
      <anchor>gaa03ae6bbc24d094b8955d905832f0c36</anchor>
      <arglist>(struct osmo_cxvec *cv, float complex *data, int len)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_alloc_from_data</name>
      <anchorfile>group__cxvec.html</anchorfile>
      <anchor>ga4edecda809e91f11cf88b53a1db8d62a</anchor>
      <arglist>(float complex *data, int len)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_alloc</name>
      <anchorfile>group__cxvec.html</anchorfile>
      <anchor>ga9461ac13f1d77ca832b140461e599caa</anchor>
      <arglist>(int max_len)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_cxvec_free</name>
      <anchorfile>group__cxvec.html</anchorfile>
      <anchor>gaa57240ff2299122f9375e901b9700e7d</anchor>
      <arglist>(struct osmo_cxvec *cv)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>osmo_cxvec_dbg_dump</name>
      <anchorfile>group__cxvec.html</anchorfile>
      <anchor>ga69e6d1ea3d468954cedf7d6f8d44f825</anchor>
      <arglist>(struct osmo_cxvec *cv, const char *fname)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>cxvec_math</name>
    <title>Complex vectors math and signal processing</title>
    <filename>group__cxvec__math.html</filename>
    <file>cxvec_math.h</file>
    <file>cxvec_math.c</file>
    <member kind="enumeration">
      <type></type>
      <name>osmo_cxvec_conv_type</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga2e183a0f24afa2e16199d1514629bf08</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONV_FULL_SPAN</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>gga2e183a0f24afa2e16199d1514629bf08ae758172bda42f9b44aa9015c0e142717</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONV_OVERLAP_ONLY</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>gga2e183a0f24afa2e16199d1514629bf08a47fb2e6e9d274d4512601828023ac1d2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONV_NO_DELAY</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>gga2e183a0f24afa2e16199d1514629bf08a03ece74c3bcd50aeb9fb42329b9a59a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>osmo_cxvec_peak_alg</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga7942b58b341e440c0e8796d395460b78</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PEAK_WEIGH_WIN</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>gga7942b58b341e440c0e8796d395460b78abb4b91d1bfa5bd51ff0e48633d9b9891</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PEAK_WEIGH_WIN_CENTER</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>gga7942b58b341e440c0e8796d395460b78ab0fb6b29112253cc5d51fb119b5d812a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PEAK_EARLY_LATE</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>gga7942b58b341e440c0e8796d395460b78aa8df843abc147bca5860fee1ddff1378</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static float</type>
      <name>osmo_sinc</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga4e7a7183dc4e5ce77d72d2986495f348</anchor>
      <arglist>(float x)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static float</type>
      <name>osmo_normsqf</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga1b169ec31cb01111c0def0c12d65f3a2</anchor>
      <arglist>(float complex c)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_scale</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga5ac0adb49726087258381582582ef654</anchor>
      <arglist>(const struct osmo_cxvec *in, float complex scale, struct osmo_cxvec *out)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_rotate</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga49125f3c259da9d7eec7fa4d98d609d4</anchor>
      <arglist>(const struct osmo_cxvec *in, float rps, struct osmo_cxvec *out)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_delay</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga9fa20d926f9d313a4751cef1eff740ba</anchor>
      <arglist>(const struct osmo_cxvec *in, float delay, struct osmo_cxvec *out)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_convolve</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga2ebadb16e25768896013420a98ec666f</anchor>
      <arglist>(const struct osmo_cxvec *f, const struct osmo_cxvec *g, enum osmo_cxvec_conv_type type, struct osmo_cxvec *out)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_correlate</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga99ff6e3baec3253f4e431b156f042a0f</anchor>
      <arglist>(const struct osmo_cxvec *f, const struct osmo_cxvec *g, int g_corr_step, struct osmo_cxvec *out)</arglist>
    </member>
    <member kind="function">
      <type>float complex</type>
      <name>osmo_cxvec_interpolate_point</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>gacb1c646e03a09b51b617467501639763</anchor>
      <arglist>(const struct osmo_cxvec *cv, float pos)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_cxvec_peaks_scan</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>gad25b04feb1cd30b24fe7de8f76e56c23</anchor>
      <arglist>(const struct osmo_cxvec *cv, int *peaks_idx, int N)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>osmo_cxvec_peak_energy_find</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga495219ee953336e15cd68c9b22d3850c</anchor>
      <arglist>(const struct osmo_cxvec *cv, int win_size, enum osmo_cxvec_peak_alg alg, float complex *peak_val_p)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_cxvec_sig_normalize</name>
      <anchorfile>group__cxvec__math.html</anchorfile>
      <anchor>ga4579583a658fc33afd24a1d8508b212f</anchor>
      <arglist>(const struct osmo_cxvec *sig, int decim, float freq_shift, struct osmo_cxvec *out)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>iqbal</name>
    <title>IQ balance utilities</title>
    <filename>group__iqbal.html</filename>
    <file>iqbal.h</file>
    <file>iqbal.c</file>
    <class kind="struct">osmo_iqbal_opts</class>
    <class kind="struct">_iqbal_estimate_state</class>
    <class kind="struct">_iqbal_state</class>
    <member kind="function">
      <type>void</type>
      <name>osmo_iqbal_fix</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>gaaca46bab25fe24148c3cb3c4d2158c79</anchor>
      <arglist>(float complex *out, float complex *in, unsigned int len, float mag, float phase)</arglist>
    </member>
    <member kind="function">
      <type>struct osmo_cxvec *</type>
      <name>osmo_iqbal_cxvec_fix</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga978fbf1c9f01694852c561c95d5ceb9d</anchor>
      <arglist>(const struct osmo_cxvec *in, float mag, float phase, struct osmo_cxvec *out)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>osmo_iqbal_estimate</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga23c6972ae206b4a60dbe49d954fc9caa</anchor>
      <arglist>(const float complex *data, int fft_size, int fft_count)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>osmo_iqbal_cxvec_estimate</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga19298f48b07828c19bc54038d5abe5ad</anchor>
      <arglist>(const struct osmo_cxvec *sig, int fft_size, int fft_count)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>osmo_iqbal_cxvec_optimize</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>gac74f9d37e2153fdf954e592b36f7c7c0</anchor>
      <arglist>(const struct osmo_cxvec *sig, float *mag, float *phase, const struct osmo_iqbal_opts *opts)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>_osmo_iqbal_estimate_release</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga5ece20030938ef8e8f9e1c3f2d91482a</anchor>
      <arglist>(struct _iqbal_estimate_state *state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static float</type>
      <name>_osmo_iqbal_estimate</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga129881cae54362d61dd2b4460f8af248</anchor>
      <arglist>(const float complex *data, int fft_size, int fft_count, struct _iqbal_estimate_state **state_p)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static float</type>
      <name>_iqbal_objfn_value</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga743af26acca4fa90afcf1e67dda95dba</anchor>
      <arglist>(struct _iqbal_state *state, float x[2])</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>_iqbal_objfn_gradient</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga169a1a71bbe3ff22192dca26f4d9ef8d</anchor>
      <arglist>(struct _iqbal_state *state, float x[2], float v, float grad[2])</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static float</type>
      <name>_iqbal_objfn_val_gradient</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga62f9a247afbb52d576a1763ccd47397f</anchor>
      <arglist>(struct _iqbal_state *state, float x[2], float grad[2])</arglist>
    </member>
    <member kind="variable">
      <type>const struct osmo_iqbal_opts</type>
      <name>osmo_iqbal_default_opts</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga2f0587c233b021d72a98a11312ff5e9f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const struct osmo_iqbal_opts</type>
      <name>osmo_iqbal_default_opts</name>
      <anchorfile>group__iqbal.html</anchorfile>
      <anchor>ga2f0587c233b021d72a98a11312ff5e9f</anchor>
      <arglist></arglist>
    </member>
  </compound>
</tagfile>
