#
# spec file for package libosmo-netif
#
# Copyright (c) 2018 SUSE LINUX GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

Name:           libosmo-netif
Version:        1.7.0.3-5c44-dirty
Release:        0
Summary:        Osmocom library for muxed audio
License:        GPL-2.0-or-later
Group:          Productivity/Telephony/Utilities
URL:            https://osmocom.org/projects/libosmo-netif
Source:         %{name}-%{version}.tar.xz
BuildRequires:  automake
BuildRequires:  libtool >= 2
BuildRequires:  lksctp-tools-devel
BuildRequires:  pkgconfig >= 0.20
BuildRequires:  pkgconfig(libosmocore) >= 1.12.0
BuildRequires:  pkgconfig(libosmogsm) >= 1.12.0
BuildRequires:  pkgconfig(libosmocodec) >= 1.12.0
BuildRequires:  pkgconfig(libosmovty) >= 1.12.0

%description
Network interface demuxer library for OsmoCom projects.

%package -n libosmonetif11
Summary:        Osmocom library for muxed audio
License:        AGPL-3.0-or-later
Group:          System/Libraries

%description -n libosmonetif11
Network interface demuxer library for OsmoCom projects.

%package -n libosmonetif-devel
Summary:        Development files for the Osmocom muxed audio library
License:        AGPL-3.0-or-later
Group:          Development/Libraries/C and C++
Requires:       libosmonetif11 = %{version}

%description -n libosmonetif-devel
Network interface demuxer library for OsmoCom projects.

This subpackage contains libraries and header files for developing
applications that want to make use of libosmo-netif.

%prep
%setup -q

%build
echo "%{version}" >.tarball-version
autoreconf -fiv
%configure --enable-shared --disable-static --includedir="%{_includedir}/%{name}"
make %{?_smp_mflags}

%install
%make_install
find %{buildroot} -type f -name "*.la" -delete -print

%check
make %{?_smp_mflags} check || (find . -name testsuite.log -exec cat {} +)

%post   -n libosmonetif11 -p /sbin/ldconfig
%postun -n libosmonetif11 -p /sbin/ldconfig

%files -n libosmonetif11
%{_libdir}/libosmonetif.so.11*

%files -n libosmonetif-devel
%license COPYING
%dir %{_includedir}/%{name}
%dir %{_includedir}/%{name}/osmocom
%{_includedir}/%{name}/osmocom/netif/
%{_libdir}/libosmonetif.so
%{_libdir}/pkgconfig/libosmo-netif.pc

%changelog
