/* THIS FILE IS GENERATED FROM gtlv_gen.c */
#include <stdint.h>
#include <osmocom/gtlv/gtlv_dec_enc.h>

#include <osmocom/pfcp/pfcp_ies_custom.h>

/* 3GPP TS 29.244 7.5.2.2-2 */
struct osmo_pfcp_ie_pdi {
	enum osmo_pfcp_source_iface source_iface;
	bool local_f_teid_present;
	struct osmo_pfcp_ie_f_teid local_f_teid;
	bool network_inst_present;
	struct osmo_pfcp_ie_network_inst network_inst;
	bool ue_ip_address_present;
	struct osmo_pfcp_ie_ue_ip_address ue_ip_address;
	bool traffic_endpoint_id_present;
	uint8_t traffic_endpoint_id;
	bool source_iface_type_present;
	enum osmo_pfcp_3gpp_iface_type source_iface_type;
};

/* 3GPP TS 29.244 7.5.2.2 */
struct osmo_pfcp_ie_create_pdr {
	uint16_t pdr_id;
	uint32_t precedence;
	struct osmo_pfcp_ie_pdi pdi;
	bool outer_header_removal_present;
	struct osmo_pfcp_ie_outer_header_removal outer_header_removal;
	bool far_id_present;
	uint32_t far_id;
	bool activate_predefined_rules_present;
	struct osmo_pfcp_ie_activate_predefined_rules activate_predefined_rules;
};

/* 3GPP TS 29.244 7.5.2.3-2 */
struct osmo_pfcp_ie_forw_params {
	enum osmo_pfcp_dest_iface destination_iface;
	bool network_inst_present;
	struct osmo_pfcp_ie_network_inst network_inst;
	bool outer_header_creation_present;
	struct osmo_pfcp_ie_outer_header_creation outer_header_creation;
	bool linked_te_id_present;
	uint8_t linked_te_id;
	bool destination_iface_type_present;
	enum osmo_pfcp_3gpp_iface_type destination_iface_type;
};

/* 3GPP TS 29.244 7.5.2.3 */
struct osmo_pfcp_ie_create_far {
	uint32_t far_id;
	struct osmo_pfcp_ie_apply_action apply_action;
	bool forw_params_present;
	struct osmo_pfcp_ie_forw_params forw_params;
};

/* 3GPP TS 29.244 7.5.3.2 */
struct osmo_pfcp_ie_created_pdr {
	uint16_t pdr_id;
	bool local_f_teid_present;
	struct osmo_pfcp_ie_f_teid local_f_teid;
};

/* 3GPP TS 29.244 7.5.4.6 */
struct osmo_pfcp_ie_remove_pdr {
	uint16_t pdr_id;
};

/* 3GPP TS 29.244 7.5.4.6 */
struct osmo_pfcp_ie_remove_far {
	uint32_t far_id;
};

/* 3GPP TS 29.244 7.5.4.2 */
struct osmo_pfcp_ie_upd_pdr {
	uint16_t pdr_id;
	bool outer_header_removal_present;
	struct osmo_pfcp_ie_outer_header_removal outer_header_removal;
	bool pdi_present;
	struct osmo_pfcp_ie_pdi pdi;
	bool far_id_present;
	uint32_t far_id;
	bool activate_predefined_rules_present;
	struct osmo_pfcp_ie_activate_predefined_rules activate_predefined_rules;
};

/* 3GPP TS 29.244 7.5.4.3-2 */
struct osmo_pfcp_ie_upd_forw_params {
	bool destination_iface_present;
	enum osmo_pfcp_dest_iface destination_iface;
	bool network_inst_present;
	struct osmo_pfcp_ie_network_inst network_inst;
	bool outer_header_creation_present;
	struct osmo_pfcp_ie_outer_header_creation outer_header_creation;
	bool linked_te_id_present;
	uint8_t linked_te_id;
	bool destination_iface_type_present;
	enum osmo_pfcp_3gpp_iface_type destination_iface_type;
};

/* 3GPP TS 29.244 7.5.4.3 */
struct osmo_pfcp_ie_upd_far {
	uint32_t far_id;
	bool apply_action_present;
	struct osmo_pfcp_ie_apply_action apply_action;
	bool upd_forw_params_present;
	struct osmo_pfcp_ie_upd_forw_params upd_forw_params;
};

/* 3GPP TS 29.244 7.5.9.3 */
struct osmo_pfcp_ie_updated_pdr {
	uint16_t pdr_id;
	bool local_f_teid_present;
	struct osmo_pfcp_ie_f_teid local_f_teid;
};

struct osmo_pfcp_msg_heartbeat_req {
	uint32_t recovery_time_stamp;
};

struct osmo_pfcp_msg_heartbeat_resp {
	uint32_t recovery_time_stamp;
};

struct osmo_pfcp_msg_assoc_setup_req {
	struct osmo_pfcp_ie_node_id node_id;
	uint32_t recovery_time_stamp;
	bool up_function_features_present;
	struct osmo_pfcp_ie_up_function_features up_function_features;
	bool cp_function_features_present;
	struct osmo_pfcp_ie_cp_function_features cp_function_features;
};

struct osmo_pfcp_msg_assoc_setup_resp {
	struct osmo_pfcp_ie_node_id node_id;
	enum osmo_pfcp_cause cause;
	uint32_t recovery_time_stamp;
	bool up_function_features_present;
	struct osmo_pfcp_ie_up_function_features up_function_features;
	bool cp_function_features_present;
	struct osmo_pfcp_ie_cp_function_features cp_function_features;
};

struct osmo_pfcp_msg_assoc_release_req {
	struct osmo_pfcp_ie_node_id node_id;
};

struct osmo_pfcp_msg_assoc_release_resp {
	struct osmo_pfcp_ie_node_id node_id;
	enum osmo_pfcp_cause cause;
};

struct osmo_pfcp_msg_session_est_req {
	struct osmo_pfcp_ie_node_id node_id;
	bool cp_f_seid_present;
	struct osmo_pfcp_ie_f_seid cp_f_seid;
	struct osmo_pfcp_ie_create_pdr create_pdr[32];
	unsigned int create_pdr_count;
	struct osmo_pfcp_ie_create_far create_far[32];
	unsigned int create_far_count;
};

struct osmo_pfcp_msg_session_est_resp {
	struct osmo_pfcp_ie_node_id node_id;
	enum osmo_pfcp_cause cause;
	bool offending_ie_present;
	enum osmo_pfcp_iei offending_ie;
	bool up_f_seid_present;
	struct osmo_pfcp_ie_f_seid up_f_seid;
	struct osmo_pfcp_ie_created_pdr created_pdr[32];
	unsigned int created_pdr_count;
};

struct osmo_pfcp_msg_session_mod_req {
	bool cp_f_seid_present;
	struct osmo_pfcp_ie_f_seid cp_f_seid;
	struct osmo_pfcp_ie_remove_pdr remove_pdr[32];
	unsigned int remove_pdr_count;
	struct osmo_pfcp_ie_remove_far remove_far[32];
	unsigned int remove_far_count;
	struct osmo_pfcp_ie_create_pdr create_pdr[32];
	unsigned int create_pdr_count;
	struct osmo_pfcp_ie_create_far create_far[32];
	unsigned int create_far_count;
	struct osmo_pfcp_ie_upd_pdr upd_pdr[32];
	unsigned int upd_pdr_count;
	struct osmo_pfcp_ie_upd_far upd_far[32];
	unsigned int upd_far_count;
};

struct osmo_pfcp_msg_session_mod_resp {
	enum osmo_pfcp_cause cause;
	bool offending_ie_present;
	enum osmo_pfcp_iei offending_ie;
	struct osmo_pfcp_ie_created_pdr created_pdr[32];
	unsigned int created_pdr_count;
	struct osmo_pfcp_ie_updated_pdr updated_pdr[32];
	unsigned int updated_pdr_count;
};

struct osmo_pfcp_msg_session_del_req {
};

struct osmo_pfcp_msg_session_del_resp {
	enum osmo_pfcp_cause cause;
};

union osmo_pfcp_ies {
	struct osmo_pfcp_msg_heartbeat_req heartbeat_req;
	struct osmo_pfcp_msg_heartbeat_resp heartbeat_resp;
	struct osmo_pfcp_msg_assoc_setup_req assoc_setup_req;
	struct osmo_pfcp_msg_assoc_setup_resp assoc_setup_resp;
	struct osmo_pfcp_msg_assoc_release_req assoc_release_req;
	struct osmo_pfcp_msg_assoc_release_resp assoc_release_resp;
	struct osmo_pfcp_msg_session_est_req session_est_req;
	struct osmo_pfcp_msg_session_est_resp session_est_resp;
	struct osmo_pfcp_msg_session_mod_req session_mod_req;
	struct osmo_pfcp_msg_session_mod_resp session_mod_resp;
	struct osmo_pfcp_msg_session_del_req session_del_req;
	struct osmo_pfcp_msg_session_del_resp session_del_resp;
};

const struct osmo_gtlv_coding *osmo_pfcp_get_msg_coding(enum osmo_pfcp_message_type message_type);

int osmo_pfcp_ies_decode(union osmo_pfcp_ies *dst, struct osmo_gtlv_load *gtlv, bool tlv_ordered,
	enum osmo_pfcp_message_type message_type, osmo_gtlv_err_cb err_cb, void *err_cb_data, const struct value_string *iei_strs);

int osmo_pfcp_ies_encode(struct osmo_gtlv_put *gtlv, const union osmo_pfcp_ies *src,
	enum osmo_pfcp_message_type message_type, osmo_gtlv_err_cb err_cb, void *err_cb_data, const struct value_string *iei_strs);

int osmo_pfcp_ies_encode_to_str(char *buf, size_t buflen, const union osmo_pfcp_ies *src,
	enum osmo_pfcp_message_type message_type, const struct value_string *iei_strs);
