;
; Copyright 2003 Free Software Foundation, Inc.
;
; This file is part of GNU Radio
;
; GNU Radio is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 3, or (at your option)
; any later version.
;
; GNU Radio is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with GNU Radio; see the file COPYING.  If not, write to
; the Free Software Foundation, Inc., 51 Franklin Street,
; Boston, MA 02110-1301, USA.
;

; Requirements: Inno Setup (http://www.jrsoftware.org/isdl.php)
;
; To compile this script do the following:
; - copy libusb's driver (libusb0.sys, libusb0.dll) to this folder
; - copy the USRP filter .inf file to this folder
; - copy the USRP .exe and .dll files to this folder
; - open this scipt with Inno Setup
; - compile and run

[Setup]
AppName=USRP
AppVerName=USRP 3.4.11
AppPublisher=GNU Radio folks
AppPublisherURL=http://www.gnu.org/software/gnuradio/
AppVersion=3.4.11
DefaultDirName={pf}\Usrp
DefaultGroupName=Usrp
Compression=lzma
SolidCompression=yes
; Win98 or higher
MinVersion=4,5
PrivilegesRequired=admin
LicenseFile="COPYING_GPL.txt"

[Files]
; copy the file to the App folder
Source: "*.sys"; DestDir: "{app}\driver"
;Source: "*.cat"; DestDir: "{app}\driver"
Source: "*.dll"; DestDir: "{app}\driver"
Source: "usrp.inf"; DestDir: "{app}\driver"

; also copy the DLL to the system folders so that rundll32.exe will find it
Source: "*.dll"; DestDir: "{win}\system32"; FLags: replacesameversion restartreplace

Source: "COPYING_GPL.txt"; DestDir: "{app}"
Source: "README.txt"; DestDir: "{app}"; Flags: isreadme

Source: "*.exe"; DestDir: "{app}"
Source: "*.ihx"; DestDir: "{app}\rev2"
Source: "*.rbf"; DestDir: "{app}\rev2"

[Icons]
Name: "{group}\Uninstall TestDrivers"; Filename: "{uninstallexe}"

[Run]
; invoke libusb's DLL to install the .inf file
Filename: "rundll32"; Parameters: "libusb0.dll,usb_install_driver_np_rundll {app}\driver\usrp.inf"; StatusMsg: "Installing driver (this may take a few seconds) ..."

