// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "MobileL3_SS_Types.hh"

namespace MobileL3__SS__Types {

/* Literal string constants */

const unsigned char bs_2_bits[] = { 21 },
bs_0_bits[] = { 23 },
bs_1_bits[] = { 55 };
extern const BITSTRING bs_2(6, bs_2_bits),
bs_0(6, bs_0_bits),
bs_1(6, bs_1_bits);
const unsigned char os_1_octets[] = { 8 },
os_2_octets[] = { 28 },
os_0_octets[] = { 127 };
extern const OCTETSTRING os_1(1, os_1_octets),
os_2(1, os_2_octets),
os_0(1, os_0_octets);
const unsigned char module_checksum[] = { 0x12, 0x76, 0x7b, 0x64, 0xa0, 0xd3, 0xb7, 0x0a, 0x1e, 0x6e, 0x0a, 0x5a, 0x10, 0xec, 0x9d, 0xcc };

/* Global variable definitions */

const XERdescriptor_t       PDU__ML3__SS__Facility_messageType_xer_ = { {"messageType>\n", "messageType>\n"}, {13, 13}, 0 |FORM_UNQUALIFIED, WHITESPACE_PRESERVE,  NULL, &module_object, -1, 0, NULL, NULL, -1, XSD_NONE };
const TTCN_OERdescriptor_t PDU__ML3__SS__Facility_messageType_oer_ = { -1, FALSE, -1, FALSE, 0, 0, NULL, 0, NULL };
const TTCN_Typedescriptor_t PDU__ML3__SS__Facility_messageType_descr_ = { "@MobileL3_SS_Types.PDU_ML3_SS_Facility.messageType", &BITSTRING_ber_, &General__Types::BIT6_raw_, NULL, &PDU__ML3__SS__Facility_messageType_xer_, &BITSTRING_json_, &PDU__ML3__SS__Facility_messageType_oer_, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
UNIVERSAL_CHARSTRING PDU__ML3__SS__Facility_messageType_default_coding("RAW");
const XERdescriptor_t       PDU__ML3__SS__Facility_nsd_xer_ = { {"nsd>\n", "nsd>\n"}, {5, 5}, 0 |FORM_UNQUALIFIED, WHITESPACE_PRESERVE,  NULL, &module_object, -1, 0, NULL, NULL, -1, XSD_NONE };
const TTCN_OERdescriptor_t PDU__ML3__SS__Facility_nsd_oer_ = { -1, FALSE, -1, FALSE, 0, 0, NULL, 0, NULL };
const TTCN_Typedescriptor_t PDU__ML3__SS__Facility_nsd_descr_ = { "@MobileL3_SS_Types.PDU_ML3_SS_Facility.nsd", &BITSTRING_ber_, &General__Types::BIT2_raw_, NULL, &PDU__ML3__SS__Facility_nsd_xer_, &BITSTRING_json_, &PDU__ML3__SS__Facility_nsd_oer_, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
UNIVERSAL_CHARSTRING PDU__ML3__SS__Facility_nsd_default_coding("RAW");
UNIVERSAL_CHARSTRING PDU__ML3__SS__Facility_facility_default_coding("RAW");
const TTCN_RAWdescriptor_t PDU__ML3__SS__Facility_raw_ = {0,SG_NO,ORDER_LSB,ORDER_LSB,ORDER_LSB,ORDER_LSB,EXT_BIT_NO,ORDER_LSB,ORDER_LSB,TOP_BIT_INHERITED,0,0,0,8,0,NULL,-1,CharCoding::UNKNOWN_CHAR_CODING,NULL,false};
// No XER for PDU__ML3__SS__Facility
const TTCN_Typedescriptor_t PDU__ML3__SS__Facility_descr_ = { "@MobileL3_SS_Types.PDU_ML3_SS_Facility", NULL, &PDU__ML3__SS__Facility_raw_, NULL, NULL, NULL, NULL, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
UNIVERSAL_CHARSTRING PDU__ML3__SS__Facility_default_coding("RAW");
const XERdescriptor_t       PDU__ML3__SS__Register__NW__MS_messageType_xer_ = { {"messageType>\n", "messageType>\n"}, {13, 13}, 0 |FORM_UNQUALIFIED, WHITESPACE_PRESERVE,  NULL, &module_object, -1, 0, NULL, NULL, -1, XSD_NONE };
const TTCN_OERdescriptor_t PDU__ML3__SS__Register__NW__MS_messageType_oer_ = { -1, FALSE, -1, FALSE, 0, 0, NULL, 0, NULL };
const TTCN_Typedescriptor_t PDU__ML3__SS__Register__NW__MS_messageType_descr_ = { "@MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS.messageType", &BITSTRING_ber_, &General__Types::BIT6_raw_, NULL, &PDU__ML3__SS__Register__NW__MS_messageType_xer_, &BITSTRING_json_, &PDU__ML3__SS__Register__NW__MS_messageType_oer_, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
UNIVERSAL_CHARSTRING PDU__ML3__SS__Register__NW__MS_messageType_default_coding("RAW");
const XERdescriptor_t       PDU__ML3__SS__Register__NW__MS_nsd_xer_ = { {"nsd>\n", "nsd>\n"}, {5, 5}, 0 |FORM_UNQUALIFIED, WHITESPACE_PRESERVE,  NULL, &module_object, -1, 0, NULL, NULL, -1, XSD_NONE };
const TTCN_OERdescriptor_t PDU__ML3__SS__Register__NW__MS_nsd_oer_ = { -1, FALSE, -1, FALSE, 0, 0, NULL, 0, NULL };
const TTCN_Typedescriptor_t PDU__ML3__SS__Register__NW__MS_nsd_descr_ = { "@MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS.nsd", &BITSTRING_ber_, &General__Types::BIT2_raw_, NULL, &PDU__ML3__SS__Register__NW__MS_nsd_xer_, &BITSTRING_json_, &PDU__ML3__SS__Register__NW__MS_nsd_oer_, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
UNIVERSAL_CHARSTRING PDU__ML3__SS__Register__NW__MS_nsd_default_coding("RAW");
UNIVERSAL_CHARSTRING PDU__ML3__SS__Register__NW__MS_facility_default_coding("RAW");
const TTCN_RAWdescriptor_t PDU__ML3__SS__Register__NW__MS_raw_ = {0,SG_NO,ORDER_LSB,ORDER_LSB,ORDER_LSB,ORDER_LSB,EXT_BIT_NO,ORDER_LSB,ORDER_LSB,TOP_BIT_INHERITED,0,0,0,8,0,NULL,-1,CharCoding::UNKNOWN_CHAR_CODING,NULL,false};
// No XER for PDU__ML3__SS__Register__NW__MS
const TTCN_Typedescriptor_t PDU__ML3__SS__Register__NW__MS_descr_ = { "@MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS", NULL, &PDU__ML3__SS__Register__NW__MS_raw_, NULL, NULL, NULL, NULL, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
UNIVERSAL_CHARSTRING PDU__ML3__SS__Register__NW__MS_default_coding("RAW");
const XERdescriptor_t       PDU__ML3__SS__Register__MS__NW_messageType_xer_ = { {"messageType>\n", "messageType>\n"}, {13, 13}, 0 |FORM_UNQUALIFIED, WHITESPACE_PRESERVE,  NULL, &module_object, -1, 0, NULL, NULL, -1, XSD_NONE };
const TTCN_OERdescriptor_t PDU__ML3__SS__Register__MS__NW_messageType_oer_ = { -1, FALSE, -1, FALSE, 0, 0, NULL, 0, NULL };
const TTCN_Typedescriptor_t PDU__ML3__SS__Register__MS__NW_messageType_descr_ = { "@MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW.messageType", &BITSTRING_ber_, &General__Types::BIT6_raw_, NULL, &PDU__ML3__SS__Register__MS__NW_messageType_xer_, &BITSTRING_json_, &PDU__ML3__SS__Register__MS__NW_messageType_oer_, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
UNIVERSAL_CHARSTRING PDU__ML3__SS__Register__MS__NW_messageType_default_coding("RAW");
const XERdescriptor_t       PDU__ML3__SS__Register__MS__NW_nsd_xer_ = { {"nsd>\n", "nsd>\n"}, {5, 5}, 0 |FORM_UNQUALIFIED, WHITESPACE_PRESERVE,  NULL, &module_object, -1, 0, NULL, NULL, -1, XSD_NONE };
const TTCN_OERdescriptor_t PDU__ML3__SS__Register__MS__NW_nsd_oer_ = { -1, FALSE, -1, FALSE, 0, 0, NULL, 0, NULL };
const TTCN_Typedescriptor_t PDU__ML3__SS__Register__MS__NW_nsd_descr_ = { "@MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW.nsd", &BITSTRING_ber_, &General__Types::BIT2_raw_, NULL, &PDU__ML3__SS__Register__MS__NW_nsd_xer_, &BITSTRING_json_, &PDU__ML3__SS__Register__MS__NW_nsd_oer_, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
UNIVERSAL_CHARSTRING PDU__ML3__SS__Register__MS__NW_nsd_default_coding("RAW");
UNIVERSAL_CHARSTRING PDU__ML3__SS__Register__MS__NW_facility_default_coding("RAW");
const TTCN_RAWdescriptor_t PDU__ML3__SS__Register__MS__NW_raw_ = {0,SG_NO,ORDER_LSB,ORDER_LSB,ORDER_LSB,ORDER_LSB,EXT_BIT_NO,ORDER_LSB,ORDER_LSB,TOP_BIT_INHERITED,0,0,0,8,0,NULL,-1,CharCoding::UNKNOWN_CHAR_CODING,NULL,false};
// No XER for PDU__ML3__SS__Register__MS__NW
const TTCN_Typedescriptor_t PDU__ML3__SS__Register__MS__NW_descr_ = { "@MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW", NULL, &PDU__ML3__SS__Register__MS__NW_raw_, NULL, NULL, NULL, NULL, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
UNIVERSAL_CHARSTRING PDU__ML3__SS__Register__MS__NW_ss__version_default_coding("RAW");
UNIVERSAL_CHARSTRING PDU__ML3__SS__Register__MS__NW_default_coding("RAW");
const XERdescriptor_t       PDU__ML3__SS__ReleaseComplete_messageType_xer_ = { {"messageType>\n", "messageType>\n"}, {13, 13}, 0 |FORM_UNQUALIFIED, WHITESPACE_PRESERVE,  NULL, &module_object, -1, 0, NULL, NULL, -1, XSD_NONE };
const TTCN_OERdescriptor_t PDU__ML3__SS__ReleaseComplete_messageType_oer_ = { -1, FALSE, -1, FALSE, 0, 0, NULL, 0, NULL };
const TTCN_Typedescriptor_t PDU__ML3__SS__ReleaseComplete_messageType_descr_ = { "@MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete.messageType", &BITSTRING_ber_, &General__Types::BIT6_raw_, NULL, &PDU__ML3__SS__ReleaseComplete_messageType_xer_, &BITSTRING_json_, &PDU__ML3__SS__ReleaseComplete_messageType_oer_, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
UNIVERSAL_CHARSTRING PDU__ML3__SS__ReleaseComplete_messageType_default_coding("RAW");
const XERdescriptor_t       PDU__ML3__SS__ReleaseComplete_nsd_xer_ = { {"nsd>\n", "nsd>\n"}, {5, 5}, 0 |FORM_UNQUALIFIED, WHITESPACE_PRESERVE,  NULL, &module_object, -1, 0, NULL, NULL, -1, XSD_NONE };
const TTCN_OERdescriptor_t PDU__ML3__SS__ReleaseComplete_nsd_oer_ = { -1, FALSE, -1, FALSE, 0, 0, NULL, 0, NULL };
const TTCN_Typedescriptor_t PDU__ML3__SS__ReleaseComplete_nsd_descr_ = { "@MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete.nsd", &BITSTRING_ber_, &General__Types::BIT2_raw_, NULL, &PDU__ML3__SS__ReleaseComplete_nsd_xer_, &BITSTRING_json_, &PDU__ML3__SS__ReleaseComplete_nsd_oer_, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
UNIVERSAL_CHARSTRING PDU__ML3__SS__ReleaseComplete_nsd_default_coding("RAW");
const TTCN_RAWdescriptor_t PDU__ML3__SS__ReleaseComplete_raw_ = {0,SG_NO,ORDER_LSB,ORDER_LSB,ORDER_LSB,ORDER_LSB,EXT_BIT_NO,ORDER_LSB,ORDER_LSB,TOP_BIT_INHERITED,0,0,0,8,0,NULL,-1,CharCoding::UNKNOWN_CHAR_CODING,NULL,false};
// No XER for PDU__ML3__SS__ReleaseComplete
const TTCN_Typedescriptor_t PDU__ML3__SS__ReleaseComplete_descr_ = { "@MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete", NULL, &PDU__ML3__SS__ReleaseComplete_raw_, NULL, NULL, NULL, NULL, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
UNIVERSAL_CHARSTRING PDU__ML3__SS__ReleaseComplete_cause_default_coding("RAW");
UNIVERSAL_CHARSTRING PDU__ML3__SS__ReleaseComplete_facility_default_coding("RAW");
UNIVERSAL_CHARSTRING PDU__ML3__SS__ReleaseComplete_default_coding("RAW");
const TTCN_RAWdescriptor_t PDU__ML3__SS__MS__NW_raw_ = {0,SG_NO,ORDER_LSB,ORDER_LSB,ORDER_LSB,ORDER_LSB,EXT_BIT_NO,ORDER_LSB,ORDER_LSB,TOP_BIT_INHERITED,0,0,0,8,0,NULL,-1,CharCoding::UNKNOWN_CHAR_CODING,NULL,false};
// No XER for PDU__ML3__SS__MS__NW
const TTCN_Typedescriptor_t PDU__ML3__SS__MS__NW_descr_ = { "@MobileL3_SS_Types.PDU_ML3_SS_MS_NW", NULL, &PDU__ML3__SS__MS__NW_raw_, NULL, NULL, NULL, NULL, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
UNIVERSAL_CHARSTRING PDU__ML3__SS__MS__NW_facility_default_coding("RAW");
UNIVERSAL_CHARSTRING PDU__ML3__SS__MS__NW_register__default_coding("RAW");
UNIVERSAL_CHARSTRING PDU__ML3__SS__MS__NW_releaseComplete__MS__NW_default_coding("RAW");
UNIVERSAL_CHARSTRING PDU__ML3__SS__MS__NW_default_coding("RAW");
const TTCN_RAWdescriptor_t PDU__ML3__SS__NW__MS_raw_ = {0,SG_NO,ORDER_LSB,ORDER_LSB,ORDER_LSB,ORDER_LSB,EXT_BIT_NO,ORDER_LSB,ORDER_LSB,TOP_BIT_INHERITED,0,0,0,8,0,NULL,-1,CharCoding::UNKNOWN_CHAR_CODING,NULL,false};
// No XER for PDU__ML3__SS__NW__MS
const TTCN_Typedescriptor_t PDU__ML3__SS__NW__MS_descr_ = { "@MobileL3_SS_Types.PDU_ML3_SS_NW_MS", NULL, &PDU__ML3__SS__NW__MS_raw_, NULL, NULL, NULL, NULL, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
UNIVERSAL_CHARSTRING PDU__ML3__SS__NW__MS_facility_default_coding("RAW");
UNIVERSAL_CHARSTRING PDU__ML3__SS__NW__MS_register__default_coding("RAW");
UNIVERSAL_CHARSTRING PDU__ML3__SS__NW__MS_releaseComplete__NW__MS_default_coding("RAW");
UNIVERSAL_CHARSTRING PDU__ML3__SS__NW__MS_default_coding("RAW");
TTCN_Module module_object("MobileL3_SS_Types", __DATE__, __TIME__, module_checksum, pre_init_module, "", 0U, 2U, 0U, 99U, "", 0LU, 0, post_init_module, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

const RuntimeVersionChecker ver_checker(  current_runtime_version.requires_major_version_11,
  current_runtime_version.requires_minor_version_1,
  current_runtime_version.requires_patch_level_0,  current_runtime_version.requires_runtime_1);

/* Member functions of C++ classes */

PDU__ML3__SS__Facility::PDU__ML3__SS__Facility()
{
}

PDU__ML3__SS__Facility::PDU__ML3__SS__Facility(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd,
    const MobileL3__CommonIE__Types::Facility__LV& par_facility)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd),
  field_facility(par_facility)
{
}

PDU__ML3__SS__Facility::PDU__ML3__SS__Facility(const PDU__ML3__SS__Facility& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_SS_Types.PDU_ML3_SS_Facility.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
if (other_value.facility().is_bound()) field_facility = other_value.facility();
else field_facility.clean_up();
}

void PDU__ML3__SS__Facility::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
field_facility.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__SS__Facility::get_descriptor() const { return &PDU__ML3__SS__Facility_descr_; }
PDU__ML3__SS__Facility& PDU__ML3__SS__Facility::operator=(const PDU__ML3__SS__Facility& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_SS_Types.PDU_ML3_SS_Facility.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
  if (other_value.facility().is_bound()) field_facility = other_value.facility();
  else field_facility.clean_up();
}
return *this;
}

boolean PDU__ML3__SS__Facility::operator==(const PDU__ML3__SS__Facility& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd
  && field_facility==other_value.field_facility;
}

boolean PDU__ML3__SS__Facility::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound())
  || (field_facility.is_bound());
}
boolean PDU__ML3__SS__Facility::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value()
  && field_facility.is_value();
}
void PDU__ML3__SS__Facility::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(", facility := ");
field_facility.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__SS__Facility::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (facility().is_bound()) facility().set_implicit_omit();
}

void PDU__ML3__SS__Facility::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MobileL3_SS_Types.PDU_ML3_SS_Facility has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) facility().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_SS_Types.PDU_ML3_SS_Facility: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_SS_Types.PDU_ML3_SS_Facility");
  }
}

void PDU__ML3__SS__Facility::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
field_facility.encode_text(text_buf);
}

void PDU__ML3__SS__Facility::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
field_facility.decode_text(text_buf);
}

void PDU__ML3__SS__Facility::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__SS__Facility::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__SS__Facility::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, MobileL3__CommonIE__Types::Facility__LV_descr_.raw->forceomit);
  decoded_field_length = field_facility.RAW_decode(MobileL3__CommonIE__Types::Facility__LV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__SS__Facility::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, MobileL3__CommonIE__Types::Facility__LV_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_facility.RAW_encode(MobileL3__CommonIE__Types::Facility__LV_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct PDU__ML3__SS__Facility_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
MobileL3__CommonIE__Types::Facility__LV_template field_facility;
};

void PDU__ML3__SS__Facility_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
single_value->field_facility = ANY_VALUE;
}
}
}

void PDU__ML3__SS__Facility_template::copy_value(const PDU__ML3__SS__Facility& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
if (other_value.facility().is_bound()) {
  single_value->field_facility = other_value.facility();
} else {
  single_value->field_facility.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__SS__Facility_template::copy_template(const PDU__ML3__SS__Facility_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.facility().get_selection()) {
single_value->field_facility = other_value.facility();
} else {
single_value->field_facility.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__SS__Facility_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__SS__Facility_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__SS__Facility_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility.");
break;
}
set_selection(other_value);
}

PDU__ML3__SS__Facility_template::PDU__ML3__SS__Facility_template()
{
}

PDU__ML3__SS__Facility_template::PDU__ML3__SS__Facility_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__SS__Facility_template::PDU__ML3__SS__Facility_template(const PDU__ML3__SS__Facility& other_value)
{
copy_value(other_value);
}

PDU__ML3__SS__Facility_template::PDU__ML3__SS__Facility_template(const OPTIONAL<PDU__ML3__SS__Facility>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__SS__Facility&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility from an unbound optional field.");
}
}

PDU__ML3__SS__Facility_template::PDU__ML3__SS__Facility_template(PDU__ML3__SS__Facility_template* p_precondition, PDU__ML3__SS__Facility_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__SS__Facility_template::PDU__ML3__SS__Facility_template(Dynamic_Match_Interface<PDU__ML3__SS__Facility>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__SS__Facility>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__SS__Facility_template::PDU__ML3__SS__Facility_template(const PDU__ML3__SS__Facility_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__SS__Facility_template::~PDU__ML3__SS__Facility_template()
{
clean_up();
}

PDU__ML3__SS__Facility_template& PDU__ML3__SS__Facility_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__SS__Facility_template& PDU__ML3__SS__Facility_template::operator=(const PDU__ML3__SS__Facility& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__SS__Facility_template& PDU__ML3__SS__Facility_template::operator=(const OPTIONAL<PDU__ML3__SS__Facility>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__SS__Facility&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility.");
}
return *this;
}

PDU__ML3__SS__Facility_template& PDU__ML3__SS__Facility_template::operator=(const PDU__ML3__SS__Facility_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__SS__Facility_template::match(const PDU__ML3__SS__Facility& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
if(!other_value.facility().is_bound()) return FALSE;
if(!single_value->field_facility.match(other_value.facility(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility.");
}
return FALSE;
}

boolean PDU__ML3__SS__Facility_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound()
 || single_value->field_facility.is_bound();
}

boolean PDU__ML3__SS__Facility_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value()
 && single_value->field_facility.is_value();
}

void PDU__ML3__SS__Facility_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__SS__Facility PDU__ML3__SS__Facility_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility.");
PDU__ML3__SS__Facility ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
if (single_value->field_facility.is_bound()) {
ret_val.facility() = single_value->field_facility.valueof();
}
return ret_val;
}

void PDU__ML3__SS__Facility_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__SS__Facility_template[list_length];
}

PDU__ML3__SS__Facility_template& PDU__ML3__SS__Facility_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__SS__Facility_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__SS__Facility_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__SS__Facility_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__SS__Facility_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility.");
return single_value->field_nsd;
}

MobileL3__CommonIE__Types::Facility__LV_template& PDU__ML3__SS__Facility_template::facility()
{
set_specific();
return single_value->field_facility;
}

const MobileL3__CommonIE__Types::Facility__LV_template& PDU__ML3__SS__Facility_template::facility() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field facility of a non-specific template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility.");
return single_value->field_facility;
}

int PDU__ML3__SS__Facility_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility.");
  }
  return 0;
}

void PDU__ML3__SS__Facility_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(", facility := ");
single_value->field_facility.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__SS__Facility_template::log_match(const PDU__ML3__SS__Facility& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_facility.match(match_value.facility(), legacy)){
TTCN_Logger::log_logmatch_info(".facility");
single_value->field_facility.log_match(match_value.facility(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(", facility := ");
single_value->field_facility.log_match(match_value.facility(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__SS__Facility_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (facility().is_bound()) facility().set_implicit_omit();
}

void PDU__ML3__SS__Facility_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
single_value->field_facility.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility.");
}
}

void PDU__ML3__SS__Facility_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
single_value->field_facility.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__SS__Facility_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility.");
}
}

void PDU__ML3__SS__Facility_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__SS__Facility_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MobileL3_SS_Types.PDU_ML3_SS_Facility has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) facility().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_SS_Types.PDU_ML3_SS_Facility: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__SS__Facility_template* precondition = new PDU__ML3__SS__Facility_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__SS__Facility_template* implied_template = new PDU__ML3__SS__Facility_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__SS__Facility_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_SS_Types.PDU_ML3_SS_Facility");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__SS__Facility_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_Facility");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_Facility");
single_value->field_facility.check_restriction(t_res, t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_Facility");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_Facility");
}

boolean PDU__ML3__SS__Facility_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__SS__Facility_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__ML3__SS__Register__NW__MS::PDU__ML3__SS__Register__NW__MS()
{
}

PDU__ML3__SS__Register__NW__MS::PDU__ML3__SS__Register__NW__MS(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd,
    const MobileL3__CommonIE__Types::Facility__TLV& par_facility)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd),
  field_facility(par_facility)
{
}

PDU__ML3__SS__Register__NW__MS::PDU__ML3__SS__Register__NW__MS(const PDU__ML3__SS__Register__NW__MS& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
if (other_value.facility().is_bound()) field_facility = other_value.facility();
else field_facility.clean_up();
}

void PDU__ML3__SS__Register__NW__MS::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
field_facility.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__SS__Register__NW__MS::get_descriptor() const { return &PDU__ML3__SS__Register__NW__MS_descr_; }
PDU__ML3__SS__Register__NW__MS& PDU__ML3__SS__Register__NW__MS::operator=(const PDU__ML3__SS__Register__NW__MS& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
  if (other_value.facility().is_bound()) field_facility = other_value.facility();
  else field_facility.clean_up();
}
return *this;
}

boolean PDU__ML3__SS__Register__NW__MS::operator==(const PDU__ML3__SS__Register__NW__MS& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd
  && field_facility==other_value.field_facility;
}

boolean PDU__ML3__SS__Register__NW__MS::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound())
  || (field_facility.is_bound());
}
boolean PDU__ML3__SS__Register__NW__MS::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value()
  && field_facility.is_value();
}
void PDU__ML3__SS__Register__NW__MS::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(", facility := ");
field_facility.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__SS__Register__NW__MS::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (facility().is_bound()) facility().set_implicit_omit();
}

void PDU__ML3__SS__Register__NW__MS::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) facility().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS");
  }
}

void PDU__ML3__SS__Register__NW__MS::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
field_facility.encode_text(text_buf);
}

void PDU__ML3__SS__Register__NW__MS::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
field_facility.decode_text(text_buf);
}

void PDU__ML3__SS__Register__NW__MS::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__SS__Register__NW__MS::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__SS__Register__NW__MS::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, MobileL3__CommonIE__Types::Facility__TLV_descr_.raw->forceomit);
  decoded_field_length = field_facility.RAW_decode(MobileL3__CommonIE__Types::Facility__TLV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__SS__Register__NW__MS::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, MobileL3__CommonIE__Types::Facility__TLV_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_facility.RAW_encode(MobileL3__CommonIE__Types::Facility__TLV_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct PDU__ML3__SS__Register__NW__MS_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
MobileL3__CommonIE__Types::Facility__TLV_template field_facility;
};

void PDU__ML3__SS__Register__NW__MS_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
single_value->field_facility = ANY_VALUE;
}
}
}

void PDU__ML3__SS__Register__NW__MS_template::copy_value(const PDU__ML3__SS__Register__NW__MS& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
if (other_value.facility().is_bound()) {
  single_value->field_facility = other_value.facility();
} else {
  single_value->field_facility.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__SS__Register__NW__MS_template::copy_template(const PDU__ML3__SS__Register__NW__MS_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.facility().get_selection()) {
single_value->field_facility = other_value.facility();
} else {
single_value->field_facility.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__SS__Register__NW__MS_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__SS__Register__NW__MS_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__SS__Register__NW__MS_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS.");
break;
}
set_selection(other_value);
}

PDU__ML3__SS__Register__NW__MS_template::PDU__ML3__SS__Register__NW__MS_template()
{
}

PDU__ML3__SS__Register__NW__MS_template::PDU__ML3__SS__Register__NW__MS_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__SS__Register__NW__MS_template::PDU__ML3__SS__Register__NW__MS_template(const PDU__ML3__SS__Register__NW__MS& other_value)
{
copy_value(other_value);
}

PDU__ML3__SS__Register__NW__MS_template::PDU__ML3__SS__Register__NW__MS_template(const OPTIONAL<PDU__ML3__SS__Register__NW__MS>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__SS__Register__NW__MS&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS from an unbound optional field.");
}
}

PDU__ML3__SS__Register__NW__MS_template::PDU__ML3__SS__Register__NW__MS_template(PDU__ML3__SS__Register__NW__MS_template* p_precondition, PDU__ML3__SS__Register__NW__MS_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__SS__Register__NW__MS_template::PDU__ML3__SS__Register__NW__MS_template(Dynamic_Match_Interface<PDU__ML3__SS__Register__NW__MS>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__SS__Register__NW__MS>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__SS__Register__NW__MS_template::PDU__ML3__SS__Register__NW__MS_template(const PDU__ML3__SS__Register__NW__MS_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__SS__Register__NW__MS_template::~PDU__ML3__SS__Register__NW__MS_template()
{
clean_up();
}

PDU__ML3__SS__Register__NW__MS_template& PDU__ML3__SS__Register__NW__MS_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__SS__Register__NW__MS_template& PDU__ML3__SS__Register__NW__MS_template::operator=(const PDU__ML3__SS__Register__NW__MS& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__SS__Register__NW__MS_template& PDU__ML3__SS__Register__NW__MS_template::operator=(const OPTIONAL<PDU__ML3__SS__Register__NW__MS>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__SS__Register__NW__MS&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS.");
}
return *this;
}

PDU__ML3__SS__Register__NW__MS_template& PDU__ML3__SS__Register__NW__MS_template::operator=(const PDU__ML3__SS__Register__NW__MS_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__SS__Register__NW__MS_template::match(const PDU__ML3__SS__Register__NW__MS& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
if(!other_value.facility().is_bound()) return FALSE;
if(!single_value->field_facility.match(other_value.facility(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS.");
}
return FALSE;
}

boolean PDU__ML3__SS__Register__NW__MS_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound()
 || single_value->field_facility.is_bound();
}

boolean PDU__ML3__SS__Register__NW__MS_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value()
 && single_value->field_facility.is_value();
}

void PDU__ML3__SS__Register__NW__MS_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__SS__Register__NW__MS PDU__ML3__SS__Register__NW__MS_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS.");
PDU__ML3__SS__Register__NW__MS ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
if (single_value->field_facility.is_bound()) {
ret_val.facility() = single_value->field_facility.valueof();
}
return ret_val;
}

void PDU__ML3__SS__Register__NW__MS_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__SS__Register__NW__MS_template[list_length];
}

PDU__ML3__SS__Register__NW__MS_template& PDU__ML3__SS__Register__NW__MS_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__SS__Register__NW__MS_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__SS__Register__NW__MS_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__SS__Register__NW__MS_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__SS__Register__NW__MS_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS.");
return single_value->field_nsd;
}

MobileL3__CommonIE__Types::Facility__TLV_template& PDU__ML3__SS__Register__NW__MS_template::facility()
{
set_specific();
return single_value->field_facility;
}

const MobileL3__CommonIE__Types::Facility__TLV_template& PDU__ML3__SS__Register__NW__MS_template::facility() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field facility of a non-specific template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS.");
return single_value->field_facility;
}

int PDU__ML3__SS__Register__NW__MS_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS.");
  }
  return 0;
}

void PDU__ML3__SS__Register__NW__MS_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(", facility := ");
single_value->field_facility.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__SS__Register__NW__MS_template::log_match(const PDU__ML3__SS__Register__NW__MS& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_facility.match(match_value.facility(), legacy)){
TTCN_Logger::log_logmatch_info(".facility");
single_value->field_facility.log_match(match_value.facility(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(", facility := ");
single_value->field_facility.log_match(match_value.facility(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__SS__Register__NW__MS_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (facility().is_bound()) facility().set_implicit_omit();
}

void PDU__ML3__SS__Register__NW__MS_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
single_value->field_facility.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS.");
}
}

void PDU__ML3__SS__Register__NW__MS_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
single_value->field_facility.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__SS__Register__NW__MS_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS.");
}
}

void PDU__ML3__SS__Register__NW__MS_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__SS__Register__NW__MS_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) facility().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__SS__Register__NW__MS_template* precondition = new PDU__ML3__SS__Register__NW__MS_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__SS__Register__NW__MS_template* implied_template = new PDU__ML3__SS__Register__NW__MS_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__SS__Register__NW__MS_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__SS__Register__NW__MS_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS");
single_value->field_facility.check_restriction(t_res, t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS");
}

boolean PDU__ML3__SS__Register__NW__MS_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__SS__Register__NW__MS_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__ML3__SS__Register__MS__NW::PDU__ML3__SS__Register__MS__NW()
{
}

PDU__ML3__SS__Register__MS__NW::PDU__ML3__SS__Register__MS__NW(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd,
    const MobileL3__CommonIE__Types::Facility__TLV& par_facility,
    const OPTIONAL< MobileL3__CommonIE__Types::SS__VersionIndicator >& par_ss__version)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd),
  field_facility(par_facility),
  field_ss__version(par_ss__version)
{
}

PDU__ML3__SS__Register__MS__NW::PDU__ML3__SS__Register__MS__NW(const PDU__ML3__SS__Register__MS__NW& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
if (other_value.facility().is_bound()) field_facility = other_value.facility();
else field_facility.clean_up();
if (other_value.ss__version().is_bound()) field_ss__version = other_value.ss__version();
else field_ss__version.clean_up();
}

void PDU__ML3__SS__Register__MS__NW::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
field_facility.clean_up();
field_ss__version.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__SS__Register__MS__NW::get_descriptor() const { return &PDU__ML3__SS__Register__MS__NW_descr_; }
PDU__ML3__SS__Register__MS__NW& PDU__ML3__SS__Register__MS__NW::operator=(const PDU__ML3__SS__Register__MS__NW& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
  if (other_value.facility().is_bound()) field_facility = other_value.facility();
  else field_facility.clean_up();
  if (other_value.ss__version().is_bound()) field_ss__version = other_value.ss__version();
  else field_ss__version.clean_up();
}
return *this;
}

boolean PDU__ML3__SS__Register__MS__NW::operator==(const PDU__ML3__SS__Register__MS__NW& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd
  && field_facility==other_value.field_facility
  && field_ss__version==other_value.field_ss__version;
}

boolean PDU__ML3__SS__Register__MS__NW::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound())
  || (field_facility.is_bound())
  || (OPTIONAL_OMIT == field_ss__version.get_selection() || field_ss__version.is_bound());
}
boolean PDU__ML3__SS__Register__MS__NW::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value()
  && field_facility.is_value()
  && (OPTIONAL_OMIT == field_ss__version.get_selection() || field_ss__version.is_value());
}
int PDU__ML3__SS__Register__MS__NW::size_of() const
{
  int ret_val = 3;
  if (field_ss__version.ispresent()) ret_val++;
  return ret_val;
}

void PDU__ML3__SS__Register__MS__NW::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(", facility := ");
field_facility.log();
TTCN_Logger::log_event_str(", ss_version := ");
field_ss__version.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__SS__Register__MS__NW::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (facility().is_bound()) facility().set_implicit_omit();
if (!ss__version().is_bound()) ss__version() = OMIT_VALUE;
else ss__version().set_implicit_omit();
}

void PDU__ML3__SS__Register__MS__NW::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) facility().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) ss__version().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_version")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__version().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW");
  }
}

void PDU__ML3__SS__Register__MS__NW::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
field_facility.encode_text(text_buf);
field_ss__version.encode_text(text_buf);
}

void PDU__ML3__SS__Register__MS__NW::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
field_facility.decode_text(text_buf);
field_ss__version.decode_text(text_buf);
}

void PDU__ML3__SS__Register__MS__NW::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__SS__Register__MS__NW::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__SS__Register__MS__NW::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, MobileL3__CommonIE__Types::Facility__TLV_descr_.raw->forceomit);
  decoded_field_length = field_facility.RAW_decode(MobileL3__CommonIE__Types::Facility__TLV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_ss__version = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, MobileL3__CommonIE__Types::SS__VersionIndicator_descr_.raw->forceomit);
  decoded_field_length = field_ss__version().RAW_decode(MobileL3__CommonIE__Types::SS__VersionIndicator_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_ss__version = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_ss__version.ispresent() || field_ss__version().elementIdentifier() !=  os_0){
  field_ss__version=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_ss__version=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__SS__Register__MS__NW::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, MobileL3__CommonIE__Types::Facility__TLV_descr_.raw);
  if (field_ss__version.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, MobileL3__CommonIE__Types::SS__VersionIndicator_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_facility.RAW_encode(MobileL3__CommonIE__Types::Facility__TLV_descr_, *myleaf.body.node.nodes[2]);
  if (field_ss__version.ispresent()) {
  encoded_length += field_ss__version().RAW_encode(MobileL3__CommonIE__Types::SS__VersionIndicator_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_ss__version.ispresent() && (!field_ss__version.ispresent() || field_ss__version().elementIdentifier() !=  os_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={3,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_0.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__ML3__SS__Register__MS__NW_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
MobileL3__CommonIE__Types::Facility__TLV_template field_facility;
MobileL3__CommonIE__Types::SS__VersionIndicator_template field_ss__version;
};

void PDU__ML3__SS__Register__MS__NW_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
single_value->field_facility = ANY_VALUE;
single_value->field_ss__version = ANY_OR_OMIT;
}
}
}

void PDU__ML3__SS__Register__MS__NW_template::copy_value(const PDU__ML3__SS__Register__MS__NW& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
if (other_value.facility().is_bound()) {
  single_value->field_facility = other_value.facility();
} else {
  single_value->field_facility.clean_up();
}
if (other_value.ss__version().is_bound()) {
  if (other_value.ss__version().ispresent()) single_value->field_ss__version = other_value.ss__version()();
  else single_value->field_ss__version = OMIT_VALUE;
} else {
  single_value->field_ss__version.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__SS__Register__MS__NW_template::copy_template(const PDU__ML3__SS__Register__MS__NW_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.facility().get_selection()) {
single_value->field_facility = other_value.facility();
} else {
single_value->field_facility.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ss__version().get_selection()) {
single_value->field_ss__version = other_value.ss__version();
} else {
single_value->field_ss__version.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__SS__Register__MS__NW_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__SS__Register__MS__NW_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__SS__Register__MS__NW_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW.");
break;
}
set_selection(other_value);
}

PDU__ML3__SS__Register__MS__NW_template::PDU__ML3__SS__Register__MS__NW_template()
{
}

PDU__ML3__SS__Register__MS__NW_template::PDU__ML3__SS__Register__MS__NW_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__SS__Register__MS__NW_template::PDU__ML3__SS__Register__MS__NW_template(const PDU__ML3__SS__Register__MS__NW& other_value)
{
copy_value(other_value);
}

PDU__ML3__SS__Register__MS__NW_template::PDU__ML3__SS__Register__MS__NW_template(const OPTIONAL<PDU__ML3__SS__Register__MS__NW>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__SS__Register__MS__NW&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW from an unbound optional field.");
}
}

PDU__ML3__SS__Register__MS__NW_template::PDU__ML3__SS__Register__MS__NW_template(PDU__ML3__SS__Register__MS__NW_template* p_precondition, PDU__ML3__SS__Register__MS__NW_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__SS__Register__MS__NW_template::PDU__ML3__SS__Register__MS__NW_template(Dynamic_Match_Interface<PDU__ML3__SS__Register__MS__NW>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__SS__Register__MS__NW>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__SS__Register__MS__NW_template::PDU__ML3__SS__Register__MS__NW_template(const PDU__ML3__SS__Register__MS__NW_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__SS__Register__MS__NW_template::~PDU__ML3__SS__Register__MS__NW_template()
{
clean_up();
}

PDU__ML3__SS__Register__MS__NW_template& PDU__ML3__SS__Register__MS__NW_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__SS__Register__MS__NW_template& PDU__ML3__SS__Register__MS__NW_template::operator=(const PDU__ML3__SS__Register__MS__NW& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__SS__Register__MS__NW_template& PDU__ML3__SS__Register__MS__NW_template::operator=(const OPTIONAL<PDU__ML3__SS__Register__MS__NW>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__SS__Register__MS__NW&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW.");
}
return *this;
}

PDU__ML3__SS__Register__MS__NW_template& PDU__ML3__SS__Register__MS__NW_template::operator=(const PDU__ML3__SS__Register__MS__NW_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__SS__Register__MS__NW_template::match(const PDU__ML3__SS__Register__MS__NW& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
if(!other_value.facility().is_bound()) return FALSE;
if(!single_value->field_facility.match(other_value.facility(), legacy))return FALSE;
if(!other_value.ss__version().is_bound()) return FALSE;
if((other_value.ss__version().ispresent() ? !single_value->field_ss__version.match((const MobileL3__CommonIE__Types::SS__VersionIndicator&)other_value.ss__version(), legacy) : !single_value->field_ss__version.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW.");
}
return FALSE;
}

boolean PDU__ML3__SS__Register__MS__NW_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound()
 || single_value->field_facility.is_bound()
 || (single_value->field_ss__version.is_omit() || single_value->field_ss__version.is_bound());
}

boolean PDU__ML3__SS__Register__MS__NW_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value()
 && single_value->field_facility.is_value()
 && (single_value->field_ss__version.is_omit() || single_value->field_ss__version.is_value());
}

void PDU__ML3__SS__Register__MS__NW_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__SS__Register__MS__NW PDU__ML3__SS__Register__MS__NW_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW.");
PDU__ML3__SS__Register__MS__NW ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
if (single_value->field_facility.is_bound()) {
ret_val.facility() = single_value->field_facility.valueof();
}
if (single_value->field_ss__version.is_omit()) ret_val.ss__version() = OMIT_VALUE;
else if (single_value->field_ss__version.is_bound()) {
ret_val.ss__version() = single_value->field_ss__version.valueof();
}
return ret_val;
}

void PDU__ML3__SS__Register__MS__NW_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__SS__Register__MS__NW_template[list_length];
}

PDU__ML3__SS__Register__MS__NW_template& PDU__ML3__SS__Register__MS__NW_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__SS__Register__MS__NW_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__SS__Register__MS__NW_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__SS__Register__MS__NW_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__SS__Register__MS__NW_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW.");
return single_value->field_nsd;
}

MobileL3__CommonIE__Types::Facility__TLV_template& PDU__ML3__SS__Register__MS__NW_template::facility()
{
set_specific();
return single_value->field_facility;
}

const MobileL3__CommonIE__Types::Facility__TLV_template& PDU__ML3__SS__Register__MS__NW_template::facility() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field facility of a non-specific template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW.");
return single_value->field_facility;
}

MobileL3__CommonIE__Types::SS__VersionIndicator_template& PDU__ML3__SS__Register__MS__NW_template::ss__version()
{
set_specific();
return single_value->field_ss__version;
}

const MobileL3__CommonIE__Types::SS__VersionIndicator_template& PDU__ML3__SS__Register__MS__NW_template::ss__version() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ss_version of a non-specific template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW.");
return single_value->field_ss__version;
}

int PDU__ML3__SS__Register__MS__NW_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 3;
      if (single_value->field_ss__version.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW.");
  }
  return 0;
}

void PDU__ML3__SS__Register__MS__NW_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(", facility := ");
single_value->field_facility.log();
TTCN_Logger::log_event_str(", ss_version := ");
single_value->field_ss__version.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__SS__Register__MS__NW_template::log_match(const PDU__ML3__SS__Register__MS__NW& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_facility.match(match_value.facility(), legacy)){
TTCN_Logger::log_logmatch_info(".facility");
single_value->field_facility.log_match(match_value.facility(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.ss__version().ispresent()){
if(!single_value->field_ss__version.match(match_value.ss__version(), legacy)){
TTCN_Logger::log_logmatch_info(".ss_version");
single_value->field_ss__version.log_match(match_value.ss__version(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ss__version.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ss_version := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ss__version.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(", facility := ");
single_value->field_facility.log_match(match_value.facility(), legacy);
TTCN_Logger::log_event_str(", ss_version := ");
if (match_value.ss__version().ispresent()) {
single_value->field_ss__version.log_match(match_value.ss__version(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ss__version.log();
if (single_value->field_ss__version.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__SS__Register__MS__NW_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (facility().is_bound()) facility().set_implicit_omit();
if (!ss__version().is_bound()) ss__version() = OMIT_VALUE;
else ss__version().set_implicit_omit();
}

void PDU__ML3__SS__Register__MS__NW_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
single_value->field_facility.encode_text(text_buf);
single_value->field_ss__version.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW.");
}
}

void PDU__ML3__SS__Register__MS__NW_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
single_value->field_facility.decode_text(text_buf);
single_value->field_ss__version.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__SS__Register__MS__NW_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW.");
}
}

void PDU__ML3__SS__Register__MS__NW_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__SS__Register__MS__NW_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) facility().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) ss__version().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_version")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__version().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__SS__Register__MS__NW_template* precondition = new PDU__ML3__SS__Register__MS__NW_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__SS__Register__MS__NW_template* implied_template = new PDU__ML3__SS__Register__MS__NW_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__SS__Register__MS__NW_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__SS__Register__MS__NW_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW");
single_value->field_facility.check_restriction(t_res, t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW");
single_value->field_ss__version.check_restriction(t_res, t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW");
}

boolean PDU__ML3__SS__Register__MS__NW_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__SS__Register__MS__NW_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__ML3__SS__ReleaseComplete::PDU__ML3__SS__ReleaseComplete()
{
}

PDU__ML3__SS__ReleaseComplete::PDU__ML3__SS__ReleaseComplete(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd,
    const OPTIONAL< MobileL3__CommonIE__Types::ML3__Cause__TLV >& par_cause,
    const OPTIONAL< MobileL3__CommonIE__Types::Facility__TLV >& par_facility)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd),
  field_cause(par_cause),
  field_facility(par_facility)
{
}

PDU__ML3__SS__ReleaseComplete::PDU__ML3__SS__ReleaseComplete(const PDU__ML3__SS__ReleaseComplete& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
if (other_value.cause().is_bound()) field_cause = other_value.cause();
else field_cause.clean_up();
if (other_value.facility().is_bound()) field_facility = other_value.facility();
else field_facility.clean_up();
}

void PDU__ML3__SS__ReleaseComplete::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
field_cause.clean_up();
field_facility.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__SS__ReleaseComplete::get_descriptor() const { return &PDU__ML3__SS__ReleaseComplete_descr_; }
PDU__ML3__SS__ReleaseComplete& PDU__ML3__SS__ReleaseComplete::operator=(const PDU__ML3__SS__ReleaseComplete& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
  if (other_value.cause().is_bound()) field_cause = other_value.cause();
  else field_cause.clean_up();
  if (other_value.facility().is_bound()) field_facility = other_value.facility();
  else field_facility.clean_up();
}
return *this;
}

boolean PDU__ML3__SS__ReleaseComplete::operator==(const PDU__ML3__SS__ReleaseComplete& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd
  && field_cause==other_value.field_cause
  && field_facility==other_value.field_facility;
}

boolean PDU__ML3__SS__ReleaseComplete::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound())
  || (OPTIONAL_OMIT == field_cause.get_selection() || field_cause.is_bound())
  || (OPTIONAL_OMIT == field_facility.get_selection() || field_facility.is_bound());
}
boolean PDU__ML3__SS__ReleaseComplete::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value()
  && (OPTIONAL_OMIT == field_cause.get_selection() || field_cause.is_value())
  && (OPTIONAL_OMIT == field_facility.get_selection() || field_facility.is_value());
}
int PDU__ML3__SS__ReleaseComplete::size_of() const
{
  int ret_val = 2;
  if (field_cause.ispresent()) ret_val++;
  if (field_facility.ispresent()) ret_val++;
  return ret_val;
}

void PDU__ML3__SS__ReleaseComplete::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(", cause := ");
field_cause.log();
TTCN_Logger::log_event_str(", facility := ");
field_facility.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__SS__ReleaseComplete::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (!cause().is_bound()) cause() = OMIT_VALUE;
else cause().set_implicit_omit();
if (!facility().is_bound()) facility() = OMIT_VALUE;
else facility().set_implicit_omit();
}

void PDU__ML3__SS__ReleaseComplete::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) facility().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete");
  }
}

void PDU__ML3__SS__ReleaseComplete::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
field_cause.encode_text(text_buf);
field_facility.encode_text(text_buf);
}

void PDU__ML3__SS__ReleaseComplete::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
field_cause.decode_text(text_buf);
field_facility.decode_text(text_buf);
}

void PDU__ML3__SS__ReleaseComplete::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__SS__ReleaseComplete::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__SS__ReleaseComplete::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_cause = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, MobileL3__CommonIE__Types::ML3__Cause__TLV_descr_.raw->forceomit);
  decoded_field_length = field_cause().RAW_decode(MobileL3__CommonIE__Types::ML3__Cause__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_cause = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_cause.ispresent() || field_cause().elementIdentifier() !=  os_1){
  field_cause=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_cause=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_facility = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, MobileL3__CommonIE__Types::Facility__TLV_descr_.raw->forceomit);
  decoded_field_length = field_facility().RAW_decode(MobileL3__CommonIE__Types::Facility__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_facility = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_facility.ispresent() || field_facility().elementIdentifier() !=  os_2){
  field_facility=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_facility=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__SS__ReleaseComplete::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  if (field_cause.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, MobileL3__CommonIE__Types::ML3__Cause__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_facility.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, MobileL3__CommonIE__Types::Facility__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  if (field_cause.ispresent()) {
  encoded_length += field_cause().RAW_encode(MobileL3__CommonIE__Types::ML3__Cause__TLV_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_facility.ispresent()) {
  encoded_length += field_facility().RAW_encode(MobileL3__CommonIE__Types::Facility__TLV_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_cause.ispresent() && (!field_cause.ispresent() || field_cause().elementIdentifier() !=  os_1)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={2,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_1.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_facility.ispresent() && (!field_facility.ispresent() || field_facility().elementIdentifier() !=  os_2)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={3,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_2.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__ML3__SS__ReleaseComplete_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
MobileL3__CommonIE__Types::ML3__Cause__TLV_template field_cause;
MobileL3__CommonIE__Types::Facility__TLV_template field_facility;
};

void PDU__ML3__SS__ReleaseComplete_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
single_value->field_cause = ANY_OR_OMIT;
single_value->field_facility = ANY_OR_OMIT;
}
}
}

void PDU__ML3__SS__ReleaseComplete_template::copy_value(const PDU__ML3__SS__ReleaseComplete& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
if (other_value.cause().is_bound()) {
  if (other_value.cause().ispresent()) single_value->field_cause = other_value.cause()();
  else single_value->field_cause = OMIT_VALUE;
} else {
  single_value->field_cause.clean_up();
}
if (other_value.facility().is_bound()) {
  if (other_value.facility().ispresent()) single_value->field_facility = other_value.facility()();
  else single_value->field_facility = OMIT_VALUE;
} else {
  single_value->field_facility.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__SS__ReleaseComplete_template::copy_template(const PDU__ML3__SS__ReleaseComplete_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cause().get_selection()) {
single_value->field_cause = other_value.cause();
} else {
single_value->field_cause.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.facility().get_selection()) {
single_value->field_facility = other_value.facility();
} else {
single_value->field_facility.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__SS__ReleaseComplete_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__SS__ReleaseComplete_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__SS__ReleaseComplete_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete.");
break;
}
set_selection(other_value);
}

PDU__ML3__SS__ReleaseComplete_template::PDU__ML3__SS__ReleaseComplete_template()
{
}

PDU__ML3__SS__ReleaseComplete_template::PDU__ML3__SS__ReleaseComplete_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__SS__ReleaseComplete_template::PDU__ML3__SS__ReleaseComplete_template(const PDU__ML3__SS__ReleaseComplete& other_value)
{
copy_value(other_value);
}

PDU__ML3__SS__ReleaseComplete_template::PDU__ML3__SS__ReleaseComplete_template(const OPTIONAL<PDU__ML3__SS__ReleaseComplete>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__SS__ReleaseComplete&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete from an unbound optional field.");
}
}

PDU__ML3__SS__ReleaseComplete_template::PDU__ML3__SS__ReleaseComplete_template(PDU__ML3__SS__ReleaseComplete_template* p_precondition, PDU__ML3__SS__ReleaseComplete_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__SS__ReleaseComplete_template::PDU__ML3__SS__ReleaseComplete_template(Dynamic_Match_Interface<PDU__ML3__SS__ReleaseComplete>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__SS__ReleaseComplete>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__SS__ReleaseComplete_template::PDU__ML3__SS__ReleaseComplete_template(const PDU__ML3__SS__ReleaseComplete_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__SS__ReleaseComplete_template::~PDU__ML3__SS__ReleaseComplete_template()
{
clean_up();
}

PDU__ML3__SS__ReleaseComplete_template& PDU__ML3__SS__ReleaseComplete_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__SS__ReleaseComplete_template& PDU__ML3__SS__ReleaseComplete_template::operator=(const PDU__ML3__SS__ReleaseComplete& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__SS__ReleaseComplete_template& PDU__ML3__SS__ReleaseComplete_template::operator=(const OPTIONAL<PDU__ML3__SS__ReleaseComplete>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__SS__ReleaseComplete&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete.");
}
return *this;
}

PDU__ML3__SS__ReleaseComplete_template& PDU__ML3__SS__ReleaseComplete_template::operator=(const PDU__ML3__SS__ReleaseComplete_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__SS__ReleaseComplete_template::match(const PDU__ML3__SS__ReleaseComplete& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
if(!other_value.cause().is_bound()) return FALSE;
if((other_value.cause().ispresent() ? !single_value->field_cause.match((const MobileL3__CommonIE__Types::ML3__Cause__TLV&)other_value.cause(), legacy) : !single_value->field_cause.match_omit(legacy)))return FALSE;
if(!other_value.facility().is_bound()) return FALSE;
if((other_value.facility().ispresent() ? !single_value->field_facility.match((const MobileL3__CommonIE__Types::Facility__TLV&)other_value.facility(), legacy) : !single_value->field_facility.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete.");
}
return FALSE;
}

boolean PDU__ML3__SS__ReleaseComplete_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound()
 || (single_value->field_cause.is_omit() || single_value->field_cause.is_bound())
 || (single_value->field_facility.is_omit() || single_value->field_facility.is_bound());
}

boolean PDU__ML3__SS__ReleaseComplete_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value()
 && (single_value->field_cause.is_omit() || single_value->field_cause.is_value())
 && (single_value->field_facility.is_omit() || single_value->field_facility.is_value());
}

void PDU__ML3__SS__ReleaseComplete_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__SS__ReleaseComplete PDU__ML3__SS__ReleaseComplete_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete.");
PDU__ML3__SS__ReleaseComplete ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
if (single_value->field_cause.is_omit()) ret_val.cause() = OMIT_VALUE;
else if (single_value->field_cause.is_bound()) {
ret_val.cause() = single_value->field_cause.valueof();
}
if (single_value->field_facility.is_omit()) ret_val.facility() = OMIT_VALUE;
else if (single_value->field_facility.is_bound()) {
ret_val.facility() = single_value->field_facility.valueof();
}
return ret_val;
}

void PDU__ML3__SS__ReleaseComplete_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__SS__ReleaseComplete_template[list_length];
}

PDU__ML3__SS__ReleaseComplete_template& PDU__ML3__SS__ReleaseComplete_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__SS__ReleaseComplete_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__SS__ReleaseComplete_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__SS__ReleaseComplete_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__SS__ReleaseComplete_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete.");
return single_value->field_nsd;
}

MobileL3__CommonIE__Types::ML3__Cause__TLV_template& PDU__ML3__SS__ReleaseComplete_template::cause()
{
set_specific();
return single_value->field_cause;
}

const MobileL3__CommonIE__Types::ML3__Cause__TLV_template& PDU__ML3__SS__ReleaseComplete_template::cause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cause of a non-specific template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete.");
return single_value->field_cause;
}

MobileL3__CommonIE__Types::Facility__TLV_template& PDU__ML3__SS__ReleaseComplete_template::facility()
{
set_specific();
return single_value->field_facility;
}

const MobileL3__CommonIE__Types::Facility__TLV_template& PDU__ML3__SS__ReleaseComplete_template::facility() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field facility of a non-specific template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete.");
return single_value->field_facility;
}

int PDU__ML3__SS__ReleaseComplete_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_cause.is_present()) ret_val++;
      if (single_value->field_facility.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete.");
  }
  return 0;
}

void PDU__ML3__SS__ReleaseComplete_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log();
TTCN_Logger::log_event_str(", facility := ");
single_value->field_facility.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__SS__ReleaseComplete_template::log_match(const PDU__ML3__SS__ReleaseComplete& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.cause().ispresent()){
if(!single_value->field_cause.match(match_value.cause(), legacy)){
TTCN_Logger::log_logmatch_info(".cause");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_cause.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".cause := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_cause.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.facility().ispresent()){
if(!single_value->field_facility.match(match_value.facility(), legacy)){
TTCN_Logger::log_logmatch_info(".facility");
single_value->field_facility.log_match(match_value.facility(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_facility.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".facility := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_facility.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(", cause := ");
if (match_value.cause().ispresent()) {
single_value->field_cause.log_match(match_value.cause(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_cause.log();
if (single_value->field_cause.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", facility := ");
if (match_value.facility().ispresent()) {
single_value->field_facility.log_match(match_value.facility(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_facility.log();
if (single_value->field_facility.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__SS__ReleaseComplete_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (!cause().is_bound()) cause() = OMIT_VALUE;
else cause().set_implicit_omit();
if (!facility().is_bound()) facility() = OMIT_VALUE;
else facility().set_implicit_omit();
}

void PDU__ML3__SS__ReleaseComplete_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
single_value->field_cause.encode_text(text_buf);
single_value->field_facility.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete.");
}
}

void PDU__ML3__SS__ReleaseComplete_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
single_value->field_cause.decode_text(text_buf);
single_value->field_facility.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__SS__ReleaseComplete_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete.");
}
}

void PDU__ML3__SS__ReleaseComplete_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__SS__ReleaseComplete_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) facility().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__SS__ReleaseComplete_template* precondition = new PDU__ML3__SS__ReleaseComplete_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__SS__ReleaseComplete_template* implied_template = new PDU__ML3__SS__ReleaseComplete_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__SS__ReleaseComplete_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__SS__ReleaseComplete_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete");
single_value->field_cause.check_restriction(t_res, t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete");
single_value->field_facility.check_restriction(t_res, t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete");
}

boolean PDU__ML3__SS__ReleaseComplete_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__SS__ReleaseComplete_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PDU__ML3__SS__MS__NW::copy_value(const PDU__ML3__SS__MS__NW& other_value)
{
switch (other_value.union_selection) {
case ALT_facility:
field_facility = new PDU__ML3__SS__Facility(*other_value.field_facility);
break;
case ALT_register_:
field_register_ = new PDU__ML3__SS__Register__MS__NW(*other_value.field_register_);
break;
case ALT_releaseComplete__MS__NW:
field_releaseComplete__MS__NW = new PDU__ML3__SS__ReleaseComplete(*other_value.field_releaseComplete__MS__NW);
break;
default:
TTCN_error("Assignment of an unbound union value of type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
}
union_selection = other_value.union_selection;
}

PDU__ML3__SS__MS__NW::PDU__ML3__SS__MS__NW()
{
union_selection = UNBOUND_VALUE;
}

PDU__ML3__SS__MS__NW::PDU__ML3__SS__MS__NW(const PDU__ML3__SS__MS__NW& other_value)
: Base_Type(){
copy_value(other_value);
}

PDU__ML3__SS__MS__NW::~PDU__ML3__SS__MS__NW()
{
clean_up();
}

PDU__ML3__SS__MS__NW& PDU__ML3__SS__MS__NW::operator=(const PDU__ML3__SS__MS__NW& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean PDU__ML3__SS__MS__NW::operator==(const PDU__ML3__SS__MS__NW& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_facility:
return *field_facility == *other_value.field_facility;
case ALT_register_:
return *field_register_ == *other_value.field_register_;
case ALT_releaseComplete__MS__NW:
return *field_releaseComplete__MS__NW == *other_value.field_releaseComplete__MS__NW;
default:
return FALSE;
}
}

PDU__ML3__SS__Facility& PDU__ML3__SS__MS__NW::facility()
{
if (union_selection != ALT_facility) {
clean_up();
field_facility = new PDU__ML3__SS__Facility;
union_selection = ALT_facility;
}
return *field_facility;
}

const PDU__ML3__SS__Facility& PDU__ML3__SS__MS__NW::facility() const
{
if (union_selection != ALT_facility) TTCN_error("Using non-selected field facility in a value of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
return *field_facility;
}

PDU__ML3__SS__Register__MS__NW& PDU__ML3__SS__MS__NW::register_()
{
if (union_selection != ALT_register_) {
clean_up();
field_register_ = new PDU__ML3__SS__Register__MS__NW;
union_selection = ALT_register_;
}
return *field_register_;
}

const PDU__ML3__SS__Register__MS__NW& PDU__ML3__SS__MS__NW::register_() const
{
if (union_selection != ALT_register_) TTCN_error("Using non-selected field register in a value of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
return *field_register_;
}

PDU__ML3__SS__ReleaseComplete& PDU__ML3__SS__MS__NW::releaseComplete__MS__NW()
{
if (union_selection != ALT_releaseComplete__MS__NW) {
clean_up();
field_releaseComplete__MS__NW = new PDU__ML3__SS__ReleaseComplete;
union_selection = ALT_releaseComplete__MS__NW;
}
return *field_releaseComplete__MS__NW;
}

const PDU__ML3__SS__ReleaseComplete& PDU__ML3__SS__MS__NW::releaseComplete__MS__NW() const
{
if (union_selection != ALT_releaseComplete__MS__NW) TTCN_error("Using non-selected field releaseComplete_MS_NW in a value of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
return *field_releaseComplete__MS__NW;
}

boolean PDU__ML3__SS__MS__NW::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
return union_selection == checked_selection;
}

boolean PDU__ML3__SS__MS__NW::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean PDU__ML3__SS__MS__NW::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_facility: return field_facility->is_value();
case ALT_register_: return field_register_->is_value();
case ALT_releaseComplete__MS__NW: return field_releaseComplete__MS__NW->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void PDU__ML3__SS__MS__NW::clean_up()
{
switch (union_selection) {
case ALT_facility:
  delete field_facility;
  break;
case ALT_register_:
  delete field_register_;
  break;
case ALT_releaseComplete__MS__NW:
  delete field_releaseComplete__MS__NW;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void PDU__ML3__SS__MS__NW::log() const
{
switch (union_selection) {
case ALT_facility:
TTCN_Logger::log_event_str("{ facility := ");
field_facility->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_register_:
TTCN_Logger::log_event_str("{ register := ");
field_register_->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_releaseComplete__MS__NW:
TTCN_Logger::log_event_str("{ releaseComplete_MS_NW := ");
field_releaseComplete__MS__NW->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void PDU__ML3__SS__MS__NW::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "facility")) {
    facility().set_param(*mp_last);
    if (!facility().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "register")) {
    register_().set_param(*mp_last);
    if (!register_().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "releaseComplete_MS_NW")) {
    releaseComplete__MS__NW().set_param(*mp_last);
    if (!releaseComplete__MS__NW().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.", last_name);
}

void PDU__ML3__SS__MS__NW::set_implicit_omit()
{
switch (union_selection) {
case ALT_facility:
field_facility->set_implicit_omit(); break;
case ALT_register_:
field_register_->set_implicit_omit(); break;
case ALT_releaseComplete__MS__NW:
field_releaseComplete__MS__NW->set_implicit_omit(); break;
default: break;
}
}

void PDU__ML3__SS__MS__NW::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_facility:
field_facility->encode_text(text_buf);
break;
case ALT_register_:
field_register_->encode_text(text_buf);
break;
case ALT_releaseComplete__MS__NW:
field_releaseComplete__MS__NW->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
}
}

void PDU__ML3__SS__MS__NW::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_facility:
facility().decode_text(text_buf);
break;
case ALT_register_:
register_().decode_text(text_buf);
break;
case ALT_releaseComplete__MS__NW:
releaseComplete__MS__NW().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
}
}

void PDU__ML3__SS__MS__NW::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__SS__MS__NW::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__SS__MS__NW::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, PDU__ML3__SS__Facility_descr_.raw->forceomit);
      decoded_length = facility().RAW_decode(PDU__ML3__SS__Facility_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, PDU__ML3__SS__Register__MS__NW_descr_.raw->forceomit);
      decoded_length = register_().RAW_decode(PDU__ML3__SS__Register__MS__NW_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 2: {
      RAW_Force_Omit field_force_omit(2, force_omit, PDU__ML3__SS__ReleaseComplete_descr_.raw->forceomit);
      decoded_length = releaseComplete__MS__NW().RAW_decode(PDU__ML3__SS__ReleaseComplete_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
    boolean already_failed = FALSE;
    BITSTRING temporal_0;
    int decoded_0_length;
    already_failed = FALSE;
    if (!already_failed) {
      p_buf.set_pos_bit(starting_pos + 0);
      decoded_0_length = temporal_0.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, top_bit_ord, TRUE);
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_0) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(0, force_omit, PDU__ML3__SS__Facility_descr_.raw->forceomit);
          decoded_length = facility().RAW_decode(PDU__ML3__SS__Facility_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_facility).messageType() ==  bs_0) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_1) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(1, force_omit, PDU__ML3__SS__Register__MS__NW_descr_.raw->forceomit);
          decoded_length = register_().RAW_decode(PDU__ML3__SS__Register__MS__NW_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_register_).messageType() ==  bs_1) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_2) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(2, force_omit, PDU__ML3__SS__ReleaseComplete_descr_.raw->forceomit);
          decoded_length = releaseComplete__MS__NW().RAW_decode(PDU__ML3__SS__ReleaseComplete_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_releaseComplete__MS__NW).messageType() ==  bs_2) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
 }
 clean_up();
 return -1;
}

int PDU__ML3__SS__MS__NW::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  memset(myleaf.body.node.nodes, 0, 3 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_facility:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, PDU__ML3__SS__Facility_descr_.raw);
    encoded_length = field_facility->RAW_encode(PDU__ML3__SS__Facility_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &PDU__ML3__SS__Facility_descr_;
    if ((*field_facility).messageType() !=  bs_0) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={0,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_register_:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, PDU__ML3__SS__Register__MS__NW_descr_.raw);
    encoded_length = field_register_->RAW_encode(PDU__ML3__SS__Register__MS__NW_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &PDU__ML3__SS__Register__MS__NW_descr_;
    if ((*field_register_).messageType() !=  bs_1) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={1,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_1.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_releaseComplete__MS__NW:
    myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 2, PDU__ML3__SS__ReleaseComplete_descr_.raw);
    encoded_length = field_releaseComplete__MS__NW->RAW_encode(PDU__ML3__SS__ReleaseComplete_descr_, *myleaf.body.node.nodes[2]);
    myleaf.body.node.nodes[2]->coding_descr = &PDU__ML3__SS__ReleaseComplete_descr_;
    if ((*field_releaseComplete__MS__NW).messageType() !=  bs_2) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={2,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_2.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void PDU__ML3__SS__MS__NW_template::copy_value(const PDU__ML3__SS__MS__NW& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case PDU__ML3__SS__MS__NW::ALT_facility:
single_value.field_facility = new PDU__ML3__SS__Facility_template(other_value.facility());
break;
case PDU__ML3__SS__MS__NW::ALT_register_:
single_value.field_register_ = new PDU__ML3__SS__Register__MS__NW_template(other_value.register_());
break;
case PDU__ML3__SS__MS__NW::ALT_releaseComplete__MS__NW:
single_value.field_releaseComplete__MS__NW = new PDU__ML3__SS__ReleaseComplete_template(other_value.releaseComplete__MS__NW());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__SS__MS__NW_template::copy_template(const PDU__ML3__SS__MS__NW_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case PDU__ML3__SS__MS__NW::ALT_facility:
single_value.field_facility = new PDU__ML3__SS__Facility_template(*other_value.single_value.field_facility);
break;
case PDU__ML3__SS__MS__NW::ALT_register_:
single_value.field_register_ = new PDU__ML3__SS__Register__MS__NW_template(*other_value.single_value.field_register_);
break;
case PDU__ML3__SS__MS__NW::ALT_releaseComplete__MS__NW:
single_value.field_releaseComplete__MS__NW = new PDU__ML3__SS__ReleaseComplete_template(*other_value.single_value.field_releaseComplete__MS__NW);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__SS__MS__NW_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__SS__MS__NW_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__SS__MS__NW_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
}
set_selection(other_value);
}

PDU__ML3__SS__MS__NW_template::PDU__ML3__SS__MS__NW_template()
{
}

PDU__ML3__SS__MS__NW_template::PDU__ML3__SS__MS__NW_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__SS__MS__NW_template::PDU__ML3__SS__MS__NW_template(const PDU__ML3__SS__MS__NW& other_value)
{
copy_value(other_value);
}

PDU__ML3__SS__MS__NW_template::PDU__ML3__SS__MS__NW_template(const OPTIONAL<PDU__ML3__SS__MS__NW>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__SS__MS__NW&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW from an unbound optional field.");
}
}

PDU__ML3__SS__MS__NW_template::PDU__ML3__SS__MS__NW_template(PDU__ML3__SS__MS__NW_template* p_precondition, PDU__ML3__SS__MS__NW_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__SS__MS__NW_template::PDU__ML3__SS__MS__NW_template(Dynamic_Match_Interface<PDU__ML3__SS__MS__NW>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__SS__MS__NW>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__SS__MS__NW_template::PDU__ML3__SS__MS__NW_template(const PDU__ML3__SS__MS__NW_template& other_value)
: Base_Template(){
copy_template(other_value);
}

PDU__ML3__SS__MS__NW_template::~PDU__ML3__SS__MS__NW_template()
{
clean_up();
}

void PDU__ML3__SS__MS__NW_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case PDU__ML3__SS__MS__NW::ALT_facility:
delete single_value.field_facility;
break;
case PDU__ML3__SS__MS__NW::ALT_register_:
delete single_value.field_register_;
break;
case PDU__ML3__SS__MS__NW::ALT_releaseComplete__MS__NW:
delete single_value.field_releaseComplete__MS__NW;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__SS__MS__NW_template& PDU__ML3__SS__MS__NW_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__SS__MS__NW_template& PDU__ML3__SS__MS__NW_template::operator=(const PDU__ML3__SS__MS__NW& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__SS__MS__NW_template& PDU__ML3__SS__MS__NW_template::operator=(const OPTIONAL<PDU__ML3__SS__MS__NW>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__SS__MS__NW&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
}
return *this;
}

PDU__ML3__SS__MS__NW_template& PDU__ML3__SS__MS__NW_template::operator=(const PDU__ML3__SS__MS__NW_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__SS__MS__NW_template::match(const PDU__ML3__SS__MS__NW& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
PDU__ML3__SS__MS__NW::union_selection_type value_selection = other_value.get_selection();
if (value_selection == PDU__ML3__SS__MS__NW::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case PDU__ML3__SS__MS__NW::ALT_facility:
return single_value.field_facility->match(other_value.facility(), legacy);
case PDU__ML3__SS__MS__NW::ALT_register_:
return single_value.field_register_->match(other_value.register_(), legacy);
case PDU__ML3__SS__MS__NW::ALT_releaseComplete__MS__NW:
return single_value.field_releaseComplete__MS__NW->match(other_value.releaseComplete__MS__NW(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
}
return FALSE;
}

boolean PDU__ML3__SS__MS__NW_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case PDU__ML3__SS__MS__NW::ALT_facility:
return single_value.field_facility->is_value();
case PDU__ML3__SS__MS__NW::ALT_register_:
return single_value.field_register_->is_value();
case PDU__ML3__SS__MS__NW::ALT_releaseComplete__MS__NW:
return single_value.field_releaseComplete__MS__NW->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
}
}

PDU__ML3__SS__MS__NW PDU__ML3__SS__MS__NW_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
PDU__ML3__SS__MS__NW ret_val;
switch (single_value.union_selection) {
case PDU__ML3__SS__MS__NW::ALT_facility:
ret_val.facility() = single_value.field_facility->valueof();
break;
case PDU__ML3__SS__MS__NW::ALT_register_:
ret_val.register_() = single_value.field_register_->valueof();
break;
case PDU__ML3__SS__MS__NW::ALT_releaseComplete__MS__NW:
ret_val.releaseComplete__MS__NW() = single_value.field_releaseComplete__MS__NW->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
}
return ret_val;
}

PDU__ML3__SS__MS__NW_template& PDU__ML3__SS__MS__NW_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
return value_list.list_value[list_index];
}
void PDU__ML3__SS__MS__NW_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__SS__MS__NW_template[list_length];
}

PDU__ML3__SS__Facility_template& PDU__ML3__SS__MS__NW_template::facility()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__SS__MS__NW::ALT_facility) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_facility = new PDU__ML3__SS__Facility_template(ANY_VALUE);
else single_value.field_facility = new PDU__ML3__SS__Facility_template;
single_value.union_selection = PDU__ML3__SS__MS__NW::ALT_facility;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_facility;
}

const PDU__ML3__SS__Facility_template& PDU__ML3__SS__MS__NW_template::facility() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field facility in a non-specific template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
if (single_value.union_selection != PDU__ML3__SS__MS__NW::ALT_facility) TTCN_error("Accessing non-selected field facility in a template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
return *single_value.field_facility;
}

PDU__ML3__SS__Register__MS__NW_template& PDU__ML3__SS__MS__NW_template::register_()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__SS__MS__NW::ALT_register_) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_register_ = new PDU__ML3__SS__Register__MS__NW_template(ANY_VALUE);
else single_value.field_register_ = new PDU__ML3__SS__Register__MS__NW_template;
single_value.union_selection = PDU__ML3__SS__MS__NW::ALT_register_;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_register_;
}

const PDU__ML3__SS__Register__MS__NW_template& PDU__ML3__SS__MS__NW_template::register_() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field register in a non-specific template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
if (single_value.union_selection != PDU__ML3__SS__MS__NW::ALT_register_) TTCN_error("Accessing non-selected field register in a template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
return *single_value.field_register_;
}

PDU__ML3__SS__ReleaseComplete_template& PDU__ML3__SS__MS__NW_template::releaseComplete__MS__NW()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__SS__MS__NW::ALT_releaseComplete__MS__NW) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_releaseComplete__MS__NW = new PDU__ML3__SS__ReleaseComplete_template(ANY_VALUE);
else single_value.field_releaseComplete__MS__NW = new PDU__ML3__SS__ReleaseComplete_template;
single_value.union_selection = PDU__ML3__SS__MS__NW::ALT_releaseComplete__MS__NW;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_releaseComplete__MS__NW;
}

const PDU__ML3__SS__ReleaseComplete_template& PDU__ML3__SS__MS__NW_template::releaseComplete__MS__NW() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field releaseComplete_MS_NW in a non-specific template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
if (single_value.union_selection != PDU__ML3__SS__MS__NW::ALT_releaseComplete__MS__NW) TTCN_error("Accessing non-selected field releaseComplete_MS_NW in a template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
return *single_value.field_releaseComplete__MS__NW;
}

boolean PDU__ML3__SS__MS__NW_template::ischosen(PDU__ML3__SS__MS__NW::union_selection_type checked_selection) const
{
if (checked_selection == PDU__ML3__SS__MS__NW::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == PDU__ML3__SS__MS__NW::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void PDU__ML3__SS__MS__NW_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case PDU__ML3__SS__MS__NW::ALT_facility:
TTCN_Logger::log_event_str("{ facility := ");
single_value.field_facility->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__SS__MS__NW::ALT_register_:
TTCN_Logger::log_event_str("{ register := ");
single_value.field_register_->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__SS__MS__NW::ALT_releaseComplete__MS__NW:
TTCN_Logger::log_event_str("{ releaseComplete_MS_NW := ");
single_value.field_releaseComplete__MS__NW->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__SS__MS__NW_template::log_match(const PDU__ML3__SS__MS__NW& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case PDU__ML3__SS__MS__NW::ALT_facility:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".facility");
single_value.field_facility->log_match(match_value.facility(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ facility := ");
single_value.field_facility->log_match(match_value.facility(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__SS__MS__NW::ALT_register_:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".register");
single_value.field_register_->log_match(match_value.register_(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ register := ");
single_value.field_register_->log_match(match_value.register_(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__SS__MS__NW::ALT_releaseComplete__MS__NW:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".releaseComplete_MS_NW");
single_value.field_releaseComplete__MS__NW->log_match(match_value.releaseComplete__MS__NW(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ releaseComplete_MS_NW := ");
single_value.field_releaseComplete__MS__NW->log_match(match_value.releaseComplete__MS__NW(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__SS__MS__NW_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case PDU__ML3__SS__MS__NW::ALT_facility:
single_value.field_facility->set_implicit_omit(); break;
case PDU__ML3__SS__MS__NW::ALT_register_:
single_value.field_register_->set_implicit_omit(); break;
case PDU__ML3__SS__MS__NW::ALT_releaseComplete__MS__NW:
single_value.field_releaseComplete__MS__NW->set_implicit_omit(); break;
default: break;
}
}

void PDU__ML3__SS__MS__NW_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case PDU__ML3__SS__MS__NW::ALT_facility:
single_value.field_facility->encode_text(text_buf);
break;
case PDU__ML3__SS__MS__NW::ALT_register_:
single_value.field_register_->encode_text(text_buf);
break;
case PDU__ML3__SS__MS__NW::ALT_releaseComplete__MS__NW:
single_value.field_releaseComplete__MS__NW->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
}
}

void PDU__ML3__SS__MS__NW_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = PDU__ML3__SS__MS__NW::UNBOUND_VALUE;
PDU__ML3__SS__MS__NW::union_selection_type new_selection = (PDU__ML3__SS__MS__NW::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case PDU__ML3__SS__MS__NW::ALT_facility:
single_value.field_facility = new PDU__ML3__SS__Facility_template;
single_value.field_facility->decode_text(text_buf);
break;
case PDU__ML3__SS__MS__NW::ALT_register_:
single_value.field_register_ = new PDU__ML3__SS__Register__MS__NW_template;
single_value.field_register_->decode_text(text_buf);
break;
case PDU__ML3__SS__MS__NW::ALT_releaseComplete__MS__NW:
single_value.field_releaseComplete__MS__NW = new PDU__ML3__SS__ReleaseComplete_template;
single_value.field_releaseComplete__MS__NW->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__SS__MS__NW_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
}
}

boolean PDU__ML3__SS__MS__NW_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__SS__MS__NW_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PDU__ML3__SS__MS__NW_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@MobileL3_SS_Types.PDU_ML3_SS_MS_NW'");
    }
    if (strcmp("facility", param_field) == 0) {
      facility().set_param(param);
      return;
    } else if (strcmp("register", param_field) == 0) {
      register_().set_param(param);
      return;
    } else if (strcmp("releaseComplete_MS_NW", param_field) == 0) {
      releaseComplete__MS__NW().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@MobileL3_SS_Types.PDU_ML3_SS_MS_NW'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__SS__MS__NW_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@MobileL3_SS_Types.PDU_ML3_SS_MS_NW");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "facility")) {
      facility().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "register")) {
      register_().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "releaseComplete_MS_NW")) {
      releaseComplete__MS__NW().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__SS__MS__NW_template* precondition = new PDU__ML3__SS__MS__NW_template;
    precondition->set_param(*m_p->get_elem(0));
    PDU__ML3__SS__MS__NW_template* implied_template = new PDU__ML3__SS__MS__NW_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = PDU__ML3__SS__MS__NW_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@MobileL3_SS_Types.PDU_ML3_SS_MS_NW");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__SS__MS__NW_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case PDU__ML3__SS__MS__NW::ALT_facility:
single_value.field_facility->check_restriction(t_res, t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_MS_NW");
return;
case PDU__ML3__SS__MS__NW::ALT_register_:
single_value.field_register_->check_restriction(t_res, t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_MS_NW");
return;
case PDU__ML3__SS__MS__NW::ALT_releaseComplete__MS__NW:
single_value.field_releaseComplete__MS__NW->check_restriction(t_res, t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_MS_NW");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @MobileL3_SS_Types.PDU_ML3_SS_MS_NW.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_MS_NW");
}

void PDU__ML3__SS__NW__MS::copy_value(const PDU__ML3__SS__NW__MS& other_value)
{
switch (other_value.union_selection) {
case ALT_facility:
field_facility = new PDU__ML3__SS__Facility(*other_value.field_facility);
break;
case ALT_register_:
field_register_ = new PDU__ML3__SS__Register__NW__MS(*other_value.field_register_);
break;
case ALT_releaseComplete__NW__MS:
field_releaseComplete__NW__MS = new PDU__ML3__SS__ReleaseComplete(*other_value.field_releaseComplete__NW__MS);
break;
default:
TTCN_error("Assignment of an unbound union value of type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
}
union_selection = other_value.union_selection;
}

PDU__ML3__SS__NW__MS::PDU__ML3__SS__NW__MS()
{
union_selection = UNBOUND_VALUE;
}

PDU__ML3__SS__NW__MS::PDU__ML3__SS__NW__MS(const PDU__ML3__SS__NW__MS& other_value)
: Base_Type(){
copy_value(other_value);
}

PDU__ML3__SS__NW__MS::~PDU__ML3__SS__NW__MS()
{
clean_up();
}

PDU__ML3__SS__NW__MS& PDU__ML3__SS__NW__MS::operator=(const PDU__ML3__SS__NW__MS& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean PDU__ML3__SS__NW__MS::operator==(const PDU__ML3__SS__NW__MS& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_facility:
return *field_facility == *other_value.field_facility;
case ALT_register_:
return *field_register_ == *other_value.field_register_;
case ALT_releaseComplete__NW__MS:
return *field_releaseComplete__NW__MS == *other_value.field_releaseComplete__NW__MS;
default:
return FALSE;
}
}

PDU__ML3__SS__Facility& PDU__ML3__SS__NW__MS::facility()
{
if (union_selection != ALT_facility) {
clean_up();
field_facility = new PDU__ML3__SS__Facility;
union_selection = ALT_facility;
}
return *field_facility;
}

const PDU__ML3__SS__Facility& PDU__ML3__SS__NW__MS::facility() const
{
if (union_selection != ALT_facility) TTCN_error("Using non-selected field facility in a value of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
return *field_facility;
}

PDU__ML3__SS__Register__NW__MS& PDU__ML3__SS__NW__MS::register_()
{
if (union_selection != ALT_register_) {
clean_up();
field_register_ = new PDU__ML3__SS__Register__NW__MS;
union_selection = ALT_register_;
}
return *field_register_;
}

const PDU__ML3__SS__Register__NW__MS& PDU__ML3__SS__NW__MS::register_() const
{
if (union_selection != ALT_register_) TTCN_error("Using non-selected field register in a value of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
return *field_register_;
}

PDU__ML3__SS__ReleaseComplete& PDU__ML3__SS__NW__MS::releaseComplete__NW__MS()
{
if (union_selection != ALT_releaseComplete__NW__MS) {
clean_up();
field_releaseComplete__NW__MS = new PDU__ML3__SS__ReleaseComplete;
union_selection = ALT_releaseComplete__NW__MS;
}
return *field_releaseComplete__NW__MS;
}

const PDU__ML3__SS__ReleaseComplete& PDU__ML3__SS__NW__MS::releaseComplete__NW__MS() const
{
if (union_selection != ALT_releaseComplete__NW__MS) TTCN_error("Using non-selected field releaseComplete_NW_MS in a value of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
return *field_releaseComplete__NW__MS;
}

boolean PDU__ML3__SS__NW__MS::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
return union_selection == checked_selection;
}

boolean PDU__ML3__SS__NW__MS::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean PDU__ML3__SS__NW__MS::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_facility: return field_facility->is_value();
case ALT_register_: return field_register_->is_value();
case ALT_releaseComplete__NW__MS: return field_releaseComplete__NW__MS->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void PDU__ML3__SS__NW__MS::clean_up()
{
switch (union_selection) {
case ALT_facility:
  delete field_facility;
  break;
case ALT_register_:
  delete field_register_;
  break;
case ALT_releaseComplete__NW__MS:
  delete field_releaseComplete__NW__MS;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void PDU__ML3__SS__NW__MS::log() const
{
switch (union_selection) {
case ALT_facility:
TTCN_Logger::log_event_str("{ facility := ");
field_facility->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_register_:
TTCN_Logger::log_event_str("{ register := ");
field_register_->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_releaseComplete__NW__MS:
TTCN_Logger::log_event_str("{ releaseComplete_NW_MS := ");
field_releaseComplete__NW__MS->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void PDU__ML3__SS__NW__MS::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "facility")) {
    facility().set_param(*mp_last);
    if (!facility().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "register")) {
    register_().set_param(*mp_last);
    if (!register_().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "releaseComplete_NW_MS")) {
    releaseComplete__NW__MS().set_param(*mp_last);
    if (!releaseComplete__NW__MS().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.", last_name);
}

void PDU__ML3__SS__NW__MS::set_implicit_omit()
{
switch (union_selection) {
case ALT_facility:
field_facility->set_implicit_omit(); break;
case ALT_register_:
field_register_->set_implicit_omit(); break;
case ALT_releaseComplete__NW__MS:
field_releaseComplete__NW__MS->set_implicit_omit(); break;
default: break;
}
}

void PDU__ML3__SS__NW__MS::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_facility:
field_facility->encode_text(text_buf);
break;
case ALT_register_:
field_register_->encode_text(text_buf);
break;
case ALT_releaseComplete__NW__MS:
field_releaseComplete__NW__MS->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
}
}

void PDU__ML3__SS__NW__MS::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_facility:
facility().decode_text(text_buf);
break;
case ALT_register_:
register_().decode_text(text_buf);
break;
case ALT_releaseComplete__NW__MS:
releaseComplete__NW__MS().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
}
}

void PDU__ML3__SS__NW__MS::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__SS__NW__MS::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__SS__NW__MS::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, PDU__ML3__SS__Facility_descr_.raw->forceomit);
      decoded_length = facility().RAW_decode(PDU__ML3__SS__Facility_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, PDU__ML3__SS__Register__NW__MS_descr_.raw->forceomit);
      decoded_length = register_().RAW_decode(PDU__ML3__SS__Register__NW__MS_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 2: {
      RAW_Force_Omit field_force_omit(2, force_omit, PDU__ML3__SS__ReleaseComplete_descr_.raw->forceomit);
      decoded_length = releaseComplete__NW__MS().RAW_decode(PDU__ML3__SS__ReleaseComplete_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
    boolean already_failed = FALSE;
    BITSTRING temporal_0;
    int decoded_0_length;
    already_failed = FALSE;
    if (!already_failed) {
      p_buf.set_pos_bit(starting_pos + 0);
      decoded_0_length = temporal_0.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, top_bit_ord, TRUE);
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_0) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(0, force_omit, PDU__ML3__SS__Facility_descr_.raw->forceomit);
          decoded_length = facility().RAW_decode(PDU__ML3__SS__Facility_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_facility).messageType() ==  bs_0) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_1) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(1, force_omit, PDU__ML3__SS__Register__NW__MS_descr_.raw->forceomit);
          decoded_length = register_().RAW_decode(PDU__ML3__SS__Register__NW__MS_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_register_).messageType() ==  bs_1) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
    already_failed = FALSE;
    if (!already_failed) {
      if (decoded_0_length > 0) {
        if (temporal_0 ==  bs_2) {
          p_buf.set_pos_bit(starting_pos);
          RAW_Force_Omit field_force_omit(2, force_omit, PDU__ML3__SS__ReleaseComplete_descr_.raw->forceomit);
          decoded_length = releaseComplete__NW__MS().RAW_decode(PDU__ML3__SS__ReleaseComplete_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_force_omit);
          if (decoded_length > 0) {
             if ((*field_releaseComplete__NW__MS).messageType() ==  bs_2) {
               return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
             }else already_failed = TRUE;
          }
        }
      }
    }
 }
 clean_up();
 return -1;
}

int PDU__ML3__SS__NW__MS::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  memset(myleaf.body.node.nodes, 0, 3 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_facility:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, PDU__ML3__SS__Facility_descr_.raw);
    encoded_length = field_facility->RAW_encode(PDU__ML3__SS__Facility_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &PDU__ML3__SS__Facility_descr_;
    if ((*field_facility).messageType() !=  bs_0) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={0,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_register_:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, PDU__ML3__SS__Register__NW__MS_descr_.raw);
    encoded_length = field_register_->RAW_encode(PDU__ML3__SS__Register__NW__MS_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &PDU__ML3__SS__Register__NW__MS_descr_;
    if ((*field_register_).messageType() !=  bs_1) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={1,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_1.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  case ALT_releaseComplete__NW__MS:
    myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 2, PDU__ML3__SS__ReleaseComplete_descr_.raw);
    encoded_length = field_releaseComplete__NW__MS->RAW_encode(PDU__ML3__SS__ReleaseComplete_descr_, *myleaf.body.node.nodes[2]);
    myleaf.body.node.nodes[2]->coding_descr = &PDU__ML3__SS__ReleaseComplete_descr_;
    if ((*field_releaseComplete__NW__MS).messageType() !=  bs_2) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={2,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_2.RAW_encode(General__Types::BIT6_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
    }
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void PDU__ML3__SS__NW__MS_template::copy_value(const PDU__ML3__SS__NW__MS& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case PDU__ML3__SS__NW__MS::ALT_facility:
single_value.field_facility = new PDU__ML3__SS__Facility_template(other_value.facility());
break;
case PDU__ML3__SS__NW__MS::ALT_register_:
single_value.field_register_ = new PDU__ML3__SS__Register__NW__MS_template(other_value.register_());
break;
case PDU__ML3__SS__NW__MS::ALT_releaseComplete__NW__MS:
single_value.field_releaseComplete__NW__MS = new PDU__ML3__SS__ReleaseComplete_template(other_value.releaseComplete__NW__MS());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__SS__NW__MS_template::copy_template(const PDU__ML3__SS__NW__MS_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case PDU__ML3__SS__NW__MS::ALT_facility:
single_value.field_facility = new PDU__ML3__SS__Facility_template(*other_value.single_value.field_facility);
break;
case PDU__ML3__SS__NW__MS::ALT_register_:
single_value.field_register_ = new PDU__ML3__SS__Register__NW__MS_template(*other_value.single_value.field_register_);
break;
case PDU__ML3__SS__NW__MS::ALT_releaseComplete__NW__MS:
single_value.field_releaseComplete__NW__MS = new PDU__ML3__SS__ReleaseComplete_template(*other_value.single_value.field_releaseComplete__NW__MS);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__SS__NW__MS_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__SS__NW__MS_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__SS__NW__MS_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
}
set_selection(other_value);
}

PDU__ML3__SS__NW__MS_template::PDU__ML3__SS__NW__MS_template()
{
}

PDU__ML3__SS__NW__MS_template::PDU__ML3__SS__NW__MS_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__SS__NW__MS_template::PDU__ML3__SS__NW__MS_template(const PDU__ML3__SS__NW__MS& other_value)
{
copy_value(other_value);
}

PDU__ML3__SS__NW__MS_template::PDU__ML3__SS__NW__MS_template(const OPTIONAL<PDU__ML3__SS__NW__MS>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__SS__NW__MS&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS from an unbound optional field.");
}
}

PDU__ML3__SS__NW__MS_template::PDU__ML3__SS__NW__MS_template(PDU__ML3__SS__NW__MS_template* p_precondition, PDU__ML3__SS__NW__MS_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__SS__NW__MS_template::PDU__ML3__SS__NW__MS_template(Dynamic_Match_Interface<PDU__ML3__SS__NW__MS>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__SS__NW__MS>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__SS__NW__MS_template::PDU__ML3__SS__NW__MS_template(const PDU__ML3__SS__NW__MS_template& other_value)
: Base_Template(){
copy_template(other_value);
}

PDU__ML3__SS__NW__MS_template::~PDU__ML3__SS__NW__MS_template()
{
clean_up();
}

void PDU__ML3__SS__NW__MS_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case PDU__ML3__SS__NW__MS::ALT_facility:
delete single_value.field_facility;
break;
case PDU__ML3__SS__NW__MS::ALT_register_:
delete single_value.field_register_;
break;
case PDU__ML3__SS__NW__MS::ALT_releaseComplete__NW__MS:
delete single_value.field_releaseComplete__NW__MS;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__SS__NW__MS_template& PDU__ML3__SS__NW__MS_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__SS__NW__MS_template& PDU__ML3__SS__NW__MS_template::operator=(const PDU__ML3__SS__NW__MS& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__SS__NW__MS_template& PDU__ML3__SS__NW__MS_template::operator=(const OPTIONAL<PDU__ML3__SS__NW__MS>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__SS__NW__MS&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
}
return *this;
}

PDU__ML3__SS__NW__MS_template& PDU__ML3__SS__NW__MS_template::operator=(const PDU__ML3__SS__NW__MS_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__SS__NW__MS_template::match(const PDU__ML3__SS__NW__MS& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
PDU__ML3__SS__NW__MS::union_selection_type value_selection = other_value.get_selection();
if (value_selection == PDU__ML3__SS__NW__MS::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case PDU__ML3__SS__NW__MS::ALT_facility:
return single_value.field_facility->match(other_value.facility(), legacy);
case PDU__ML3__SS__NW__MS::ALT_register_:
return single_value.field_register_->match(other_value.register_(), legacy);
case PDU__ML3__SS__NW__MS::ALT_releaseComplete__NW__MS:
return single_value.field_releaseComplete__NW__MS->match(other_value.releaseComplete__NW__MS(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
}
return FALSE;
}

boolean PDU__ML3__SS__NW__MS_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case PDU__ML3__SS__NW__MS::ALT_facility:
return single_value.field_facility->is_value();
case PDU__ML3__SS__NW__MS::ALT_register_:
return single_value.field_register_->is_value();
case PDU__ML3__SS__NW__MS::ALT_releaseComplete__NW__MS:
return single_value.field_releaseComplete__NW__MS->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
}
}

PDU__ML3__SS__NW__MS PDU__ML3__SS__NW__MS_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
PDU__ML3__SS__NW__MS ret_val;
switch (single_value.union_selection) {
case PDU__ML3__SS__NW__MS::ALT_facility:
ret_val.facility() = single_value.field_facility->valueof();
break;
case PDU__ML3__SS__NW__MS::ALT_register_:
ret_val.register_() = single_value.field_register_->valueof();
break;
case PDU__ML3__SS__NW__MS::ALT_releaseComplete__NW__MS:
ret_val.releaseComplete__NW__MS() = single_value.field_releaseComplete__NW__MS->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
}
return ret_val;
}

PDU__ML3__SS__NW__MS_template& PDU__ML3__SS__NW__MS_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
return value_list.list_value[list_index];
}
void PDU__ML3__SS__NW__MS_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__SS__NW__MS_template[list_length];
}

PDU__ML3__SS__Facility_template& PDU__ML3__SS__NW__MS_template::facility()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__SS__NW__MS::ALT_facility) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_facility = new PDU__ML3__SS__Facility_template(ANY_VALUE);
else single_value.field_facility = new PDU__ML3__SS__Facility_template;
single_value.union_selection = PDU__ML3__SS__NW__MS::ALT_facility;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_facility;
}

const PDU__ML3__SS__Facility_template& PDU__ML3__SS__NW__MS_template::facility() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field facility in a non-specific template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
if (single_value.union_selection != PDU__ML3__SS__NW__MS::ALT_facility) TTCN_error("Accessing non-selected field facility in a template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
return *single_value.field_facility;
}

PDU__ML3__SS__Register__NW__MS_template& PDU__ML3__SS__NW__MS_template::register_()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__SS__NW__MS::ALT_register_) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_register_ = new PDU__ML3__SS__Register__NW__MS_template(ANY_VALUE);
else single_value.field_register_ = new PDU__ML3__SS__Register__NW__MS_template;
single_value.union_selection = PDU__ML3__SS__NW__MS::ALT_register_;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_register_;
}

const PDU__ML3__SS__Register__NW__MS_template& PDU__ML3__SS__NW__MS_template::register_() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field register in a non-specific template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
if (single_value.union_selection != PDU__ML3__SS__NW__MS::ALT_register_) TTCN_error("Accessing non-selected field register in a template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
return *single_value.field_register_;
}

PDU__ML3__SS__ReleaseComplete_template& PDU__ML3__SS__NW__MS_template::releaseComplete__NW__MS()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__ML3__SS__NW__MS::ALT_releaseComplete__NW__MS) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_releaseComplete__NW__MS = new PDU__ML3__SS__ReleaseComplete_template(ANY_VALUE);
else single_value.field_releaseComplete__NW__MS = new PDU__ML3__SS__ReleaseComplete_template;
single_value.union_selection = PDU__ML3__SS__NW__MS::ALT_releaseComplete__NW__MS;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_releaseComplete__NW__MS;
}

const PDU__ML3__SS__ReleaseComplete_template& PDU__ML3__SS__NW__MS_template::releaseComplete__NW__MS() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field releaseComplete_NW_MS in a non-specific template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
if (single_value.union_selection != PDU__ML3__SS__NW__MS::ALT_releaseComplete__NW__MS) TTCN_error("Accessing non-selected field releaseComplete_NW_MS in a template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
return *single_value.field_releaseComplete__NW__MS;
}

boolean PDU__ML3__SS__NW__MS_template::ischosen(PDU__ML3__SS__NW__MS::union_selection_type checked_selection) const
{
if (checked_selection == PDU__ML3__SS__NW__MS::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == PDU__ML3__SS__NW__MS::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void PDU__ML3__SS__NW__MS_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case PDU__ML3__SS__NW__MS::ALT_facility:
TTCN_Logger::log_event_str("{ facility := ");
single_value.field_facility->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__SS__NW__MS::ALT_register_:
TTCN_Logger::log_event_str("{ register := ");
single_value.field_register_->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__ML3__SS__NW__MS::ALT_releaseComplete__NW__MS:
TTCN_Logger::log_event_str("{ releaseComplete_NW_MS := ");
single_value.field_releaseComplete__NW__MS->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__SS__NW__MS_template::log_match(const PDU__ML3__SS__NW__MS& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case PDU__ML3__SS__NW__MS::ALT_facility:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".facility");
single_value.field_facility->log_match(match_value.facility(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ facility := ");
single_value.field_facility->log_match(match_value.facility(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__SS__NW__MS::ALT_register_:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".register");
single_value.field_register_->log_match(match_value.register_(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ register := ");
single_value.field_register_->log_match(match_value.register_(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__ML3__SS__NW__MS::ALT_releaseComplete__NW__MS:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".releaseComplete_NW_MS");
single_value.field_releaseComplete__NW__MS->log_match(match_value.releaseComplete__NW__MS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ releaseComplete_NW_MS := ");
single_value.field_releaseComplete__NW__MS->log_match(match_value.releaseComplete__NW__MS(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__SS__NW__MS_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case PDU__ML3__SS__NW__MS::ALT_facility:
single_value.field_facility->set_implicit_omit(); break;
case PDU__ML3__SS__NW__MS::ALT_register_:
single_value.field_register_->set_implicit_omit(); break;
case PDU__ML3__SS__NW__MS::ALT_releaseComplete__NW__MS:
single_value.field_releaseComplete__NW__MS->set_implicit_omit(); break;
default: break;
}
}

void PDU__ML3__SS__NW__MS_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case PDU__ML3__SS__NW__MS::ALT_facility:
single_value.field_facility->encode_text(text_buf);
break;
case PDU__ML3__SS__NW__MS::ALT_register_:
single_value.field_register_->encode_text(text_buf);
break;
case PDU__ML3__SS__NW__MS::ALT_releaseComplete__NW__MS:
single_value.field_releaseComplete__NW__MS->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
}
}

void PDU__ML3__SS__NW__MS_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = PDU__ML3__SS__NW__MS::UNBOUND_VALUE;
PDU__ML3__SS__NW__MS::union_selection_type new_selection = (PDU__ML3__SS__NW__MS::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case PDU__ML3__SS__NW__MS::ALT_facility:
single_value.field_facility = new PDU__ML3__SS__Facility_template;
single_value.field_facility->decode_text(text_buf);
break;
case PDU__ML3__SS__NW__MS::ALT_register_:
single_value.field_register_ = new PDU__ML3__SS__Register__NW__MS_template;
single_value.field_register_->decode_text(text_buf);
break;
case PDU__ML3__SS__NW__MS::ALT_releaseComplete__NW__MS:
single_value.field_releaseComplete__NW__MS = new PDU__ML3__SS__ReleaseComplete_template;
single_value.field_releaseComplete__NW__MS->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__SS__NW__MS_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
}
}

boolean PDU__ML3__SS__NW__MS_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__SS__NW__MS_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PDU__ML3__SS__NW__MS_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@MobileL3_SS_Types.PDU_ML3_SS_NW_MS'");
    }
    if (strcmp("facility", param_field) == 0) {
      facility().set_param(param);
      return;
    } else if (strcmp("register", param_field) == 0) {
      register_().set_param(param);
      return;
    } else if (strcmp("releaseComplete_NW_MS", param_field) == 0) {
      releaseComplete__NW__MS().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@MobileL3_SS_Types.PDU_ML3_SS_NW_MS'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__SS__NW__MS_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@MobileL3_SS_Types.PDU_ML3_SS_NW_MS");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "facility")) {
      facility().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "register")) {
      register_().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "releaseComplete_NW_MS")) {
      releaseComplete__NW__MS().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__SS__NW__MS_template* precondition = new PDU__ML3__SS__NW__MS_template;
    precondition->set_param(*m_p->get_elem(0));
    PDU__ML3__SS__NW__MS_template* implied_template = new PDU__ML3__SS__NW__MS_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = PDU__ML3__SS__NW__MS_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@MobileL3_SS_Types.PDU_ML3_SS_NW_MS");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__SS__NW__MS_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case PDU__ML3__SS__NW__MS::ALT_facility:
single_value.field_facility->check_restriction(t_res, t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_NW_MS");
return;
case PDU__ML3__SS__NW__MS::ALT_register_:
single_value.field_register_->check_restriction(t_res, t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_NW_MS");
return;
case PDU__ML3__SS__NW__MS::ALT_releaseComplete__NW__MS:
single_value.field_releaseComplete__NW__MS->check_restriction(t_res, t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_NW_MS");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @MobileL3_SS_Types.PDU_ML3_SS_NW_MS.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_SS_Types.PDU_ML3_SS_NW_MS");
}


/* Bodies of functions, altsteps and testcases */

void PDU__ML3__SS__Facility_encoder(const PDU__ML3__SS__Facility& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_SS_Types.PDU_ML3_SS_Facility' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__SS__Facility_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__SS__Facility_decoder(OCTETSTRING& input_stream, PDU__ML3__SS__Facility& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_SS_Types.PDU_ML3_SS_Facility' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__SS__Facility_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__SS__Register__NW__MS_encoder(const PDU__ML3__SS__Register__NW__MS& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__SS__Register__NW__MS_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__SS__Register__NW__MS_decoder(OCTETSTRING& input_stream, PDU__ML3__SS__Register__NW__MS& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_SS_Types.PDU_ML3_SS_Register_NW_MS' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__SS__Register__NW__MS_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__SS__Register__MS__NW_encoder(const PDU__ML3__SS__Register__MS__NW& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__SS__Register__MS__NW_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__SS__Register__MS__NW_decoder(OCTETSTRING& input_stream, PDU__ML3__SS__Register__MS__NW& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_SS_Types.PDU_ML3_SS_Register_MS_NW' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__SS__Register__MS__NW_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__SS__ReleaseComplete_encoder(const PDU__ML3__SS__ReleaseComplete& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__SS__ReleaseComplete_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__SS__ReleaseComplete_decoder(OCTETSTRING& input_stream, PDU__ML3__SS__ReleaseComplete& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_SS_Types.PDU_ML3_SS_ReleaseComplete' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__SS__ReleaseComplete_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__SS__MS__NW_encoder(const PDU__ML3__SS__MS__NW& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_SS_Types.PDU_ML3_SS_MS_NW' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__SS__MS__NW_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__SS__MS__NW_decoder(OCTETSTRING& input_stream, PDU__ML3__SS__MS__NW& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_SS_Types.PDU_ML3_SS_MS_NW' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__SS__MS__NW_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PDU__ML3__SS__NW__MS_encoder(const PDU__ML3__SS__NW__MS& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_SS_Types.PDU_ML3_SS_NW_MS' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PDU__ML3__SS__NW__MS_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PDU__ML3__SS__NW__MS_decoder(OCTETSTRING& input_stream, PDU__ML3__SS__NW__MS& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MobileL3_SS_Types.PDU_ML3_SS_NW_MS' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PDU__ML3__SS__NW__MS_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}


/* Bodies of static functions */

void pre_init_module()
{
TTCN_Location current_location("MobileL3_SS_Types.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "MobileL3_SS_Types");
MobileL3__CommonIE__Types::module_object.pre_init_module();
}

void post_init_module()
{
TTCN_Location current_location("MobileL3_SS_Types.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "MobileL3_SS_Types");
MobileL3__CommonIE__Types::module_object.post_init_module();
}


} /* end of namespace */
