// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "RLCMAC_CSN1_Types.hh"

namespace RLCMAC__CSN1__Types {

/* Member functions of C++ classes */

NCMeasurementReport::NCMeasurementReport()
{
}

NCMeasurementReport::NCMeasurementReport(const BITSTRING& par_nc__mode,
    const INTEGER& par_rxlev__serving__cell,
    const BITSTRING& par_zero,
    const INTEGER& par_num__nc__measurements,
    const NCMeasurementList& par_nm__measurements)
  :   field_nc__mode(par_nc__mode),
  field_rxlev__serving__cell(par_rxlev__serving__cell),
  field_zero(par_zero),
  field_num__nc__measurements(par_num__nc__measurements),
  field_nm__measurements(par_nm__measurements)
{
}

NCMeasurementReport::NCMeasurementReport(const NCMeasurementReport& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
if (other_value.nc__mode().is_bound()) field_nc__mode = other_value.nc__mode();
else field_nc__mode.clean_up();
if (other_value.rxlev__serving__cell().is_bound()) field_rxlev__serving__cell = other_value.rxlev__serving__cell();
else field_rxlev__serving__cell.clean_up();
if (other_value.zero().is_bound()) field_zero = other_value.zero();
else field_zero.clean_up();
if (other_value.num__nc__measurements().is_bound()) field_num__nc__measurements = other_value.num__nc__measurements();
else field_num__nc__measurements.clean_up();
if (other_value.nm__measurements().is_bound()) field_nm__measurements = other_value.nm__measurements();
else field_nm__measurements.clean_up();
}

void NCMeasurementReport::clean_up()
{
field_nc__mode.clean_up();
field_rxlev__serving__cell.clean_up();
field_zero.clean_up();
field_num__nc__measurements.clean_up();
field_nm__measurements.clean_up();
}

const TTCN_Typedescriptor_t* NCMeasurementReport::get_descriptor() const { return &NCMeasurementReport_descr_; }
NCMeasurementReport& NCMeasurementReport::operator=(const NCMeasurementReport& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
  if (other_value.nc__mode().is_bound()) field_nc__mode = other_value.nc__mode();
  else field_nc__mode.clean_up();
  if (other_value.rxlev__serving__cell().is_bound()) field_rxlev__serving__cell = other_value.rxlev__serving__cell();
  else field_rxlev__serving__cell.clean_up();
  if (other_value.zero().is_bound()) field_zero = other_value.zero();
  else field_zero.clean_up();
  if (other_value.num__nc__measurements().is_bound()) field_num__nc__measurements = other_value.num__nc__measurements();
  else field_num__nc__measurements.clean_up();
  if (other_value.nm__measurements().is_bound()) field_nm__measurements = other_value.nm__measurements();
  else field_nm__measurements.clean_up();
}
return *this;
}

boolean NCMeasurementReport::operator==(const NCMeasurementReport& other_value) const
{
return field_nc__mode==other_value.field_nc__mode
  && field_rxlev__serving__cell==other_value.field_rxlev__serving__cell
  && field_zero==other_value.field_zero
  && field_num__nc__measurements==other_value.field_num__nc__measurements
  && field_nm__measurements==other_value.field_nm__measurements;
}

boolean NCMeasurementReport::is_bound() const
{
return (field_nc__mode.is_bound())
  || (field_rxlev__serving__cell.is_bound())
  || (field_zero.is_bound())
  || (field_num__nc__measurements.is_bound())
  || (field_nm__measurements.is_bound());
}
boolean NCMeasurementReport::is_value() const
{
return field_nc__mode.is_value()
  && field_rxlev__serving__cell.is_value()
  && field_zero.is_value()
  && field_num__nc__measurements.is_value()
  && field_nm__measurements.is_value();
}
void NCMeasurementReport::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ nc_mode := ");
field_nc__mode.log();
TTCN_Logger::log_event_str(", rxlev_serving_cell := ");
field_rxlev__serving__cell.log();
TTCN_Logger::log_event_str(", zero := ");
field_zero.log();
TTCN_Logger::log_event_str(", num_nc_measurements := ");
field_num__nc__measurements.log();
TTCN_Logger::log_event_str(", nm_measurements := ");
field_nm__measurements.log();
TTCN_Logger::log_event_str(" }");
}

void NCMeasurementReport::set_implicit_omit()
{
if (nc__mode().is_bound()) nc__mode().set_implicit_omit();
if (rxlev__serving__cell().is_bound()) rxlev__serving__cell().set_implicit_omit();
if (zero().is_bound()) zero().set_implicit_omit();
if (num__nc__measurements().is_bound()) num__nc__measurements().set_implicit_omit();
if (nm__measurements().is_bound()) nm__measurements().set_implicit_omit();
}

void NCMeasurementReport::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.NCMeasurementReport has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) nc__mode().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) rxlev__serving__cell().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) zero().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) num__nc__measurements().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) nm__measurements().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nc_mode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nc__mode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rxlev_serving_cell")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rxlev__serving__cell().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "zero")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          zero().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "num_nc_measurements")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          num__nc__measurements().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nm_measurements")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nm__measurements().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.NCMeasurementReport: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.NCMeasurementReport");
  }
}

void NCMeasurementReport::encode_text(Text_Buf& text_buf) const
{
field_nc__mode.encode_text(text_buf);
field_rxlev__serving__cell.encode_text(text_buf);
field_zero.encode_text(text_buf);
field_num__nc__measurements.encode_text(text_buf);
field_nm__measurements.encode_text(text_buf);
}

void NCMeasurementReport::decode_text(Text_Buf& text_buf)
{
field_nc__mode.decode_text(text_buf);
field_rxlev__serving__cell.decode_text(text_buf);
field_zero.decode_text(text_buf);
field_num__nc__measurements.decode_text(text_buf);
field_nm__measurements.decode_text(text_buf);
}

void NCMeasurementReport::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void NCMeasurementReport::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int NCMeasurementReport::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field3 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, NCMeasurementReport_nc__mode_descr_.raw->forceomit);
  decoded_field_length = field_nc__mode.RAW_decode(NCMeasurementReport_nc__mode_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, NCMeasurementReport_rxlev__serving__cell_descr_.raw->forceomit);
  decoded_field_length = field_rxlev__serving__cell.RAW_decode(NCMeasurementReport_rxlev__serving__cell_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, NCMeasurementReport_zero_descr_.raw->forceomit);
  decoded_field_length = field_zero.RAW_decode(NCMeasurementReport_zero_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, NCMeasurementReport_num__nc__measurements_descr_.raw->forceomit);
  decoded_field_length = field_num__nc__measurements.RAW_decode(NCMeasurementReport_num__nc__measurements_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp3 = field_num__nc__measurements.convert_to_Integer(NCMeasurementReport_num__nc__measurements_descr_);
  field_num__nc__measurements = tmp3;
  value_of_length_field3 += tmp3.get_long_long_val() * 1;
  RAW_Force_Omit field_4_force_omit(4, force_omit, NCMeasurementReport_nm__measurements_descr_.raw->forceomit);
  decoded_field_length = field_nm__measurements.RAW_decode(NCMeasurementReport_nm__measurements_descr_, p_buf, limit, local_top_order, no_err, value_of_length_field3, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field3 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int NCMeasurementReport::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, NCMeasurementReport_nc__mode_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, NCMeasurementReport_rxlev__serving__cell_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, NCMeasurementReport_zero_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, NCMeasurementReport_num__nc__measurements_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, NCMeasurementReport_nm__measurements_descr_.raw);
  encoded_length += field_nc__mode.RAW_encode(NCMeasurementReport_nc__mode_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_rxlev__serving__cell.RAW_encode(NCMeasurementReport_rxlev__serving__cell_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_zero.RAW_encode(NCMeasurementReport_zero_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += 3;
  myleaf.body.node.nodes[3]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[3]->coding_descr = &NCMeasurementReport_num__nc__measurements_descr_;
  myleaf.body.node.nodes[3]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[3]->calcof.lengthto.unit = -1;
  myleaf.body.node.nodes[3]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[3]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[3]->length = 3;
  myleaf.body.node.nodes[3]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[3]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  encoded_length += field_nm__measurements.RAW_encode(NCMeasurementReport_nm__measurements_descr_, *myleaf.body.node.nodes[4]);
  return myleaf.length = encoded_length;
}

struct NCMeasurementReport_template::single_value_struct {
BITSTRING_template field_nc__mode;
INTEGER_template field_rxlev__serving__cell;
BITSTRING_template field_zero;
INTEGER_template field_num__nc__measurements;
NCMeasurementList_template field_nm__measurements;
};

void NCMeasurementReport_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_nc__mode = ANY_VALUE;
single_value->field_rxlev__serving__cell = ANY_VALUE;
single_value->field_zero = ANY_VALUE;
single_value->field_num__nc__measurements = ANY_VALUE;
single_value->field_nm__measurements = ANY_VALUE;
}
}
}

void NCMeasurementReport_template::copy_value(const NCMeasurementReport& other_value)
{
single_value = new single_value_struct;
if (other_value.nc__mode().is_bound()) {
  single_value->field_nc__mode = other_value.nc__mode();
} else {
  single_value->field_nc__mode.clean_up();
}
if (other_value.rxlev__serving__cell().is_bound()) {
  single_value->field_rxlev__serving__cell = other_value.rxlev__serving__cell();
} else {
  single_value->field_rxlev__serving__cell.clean_up();
}
if (other_value.zero().is_bound()) {
  single_value->field_zero = other_value.zero();
} else {
  single_value->field_zero.clean_up();
}
if (other_value.num__nc__measurements().is_bound()) {
  single_value->field_num__nc__measurements = other_value.num__nc__measurements();
} else {
  single_value->field_num__nc__measurements.clean_up();
}
if (other_value.nm__measurements().is_bound()) {
  single_value->field_nm__measurements = other_value.nm__measurements();
} else {
  single_value->field_nm__measurements.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void NCMeasurementReport_template::copy_template(const NCMeasurementReport_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.nc__mode().get_selection()) {
single_value->field_nc__mode = other_value.nc__mode();
} else {
single_value->field_nc__mode.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rxlev__serving__cell().get_selection()) {
single_value->field_rxlev__serving__cell = other_value.rxlev__serving__cell();
} else {
single_value->field_rxlev__serving__cell.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.zero().get_selection()) {
single_value->field_zero = other_value.zero();
} else {
single_value->field_zero.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.num__nc__measurements().get_selection()) {
single_value->field_num__nc__measurements = other_value.num__nc__measurements();
} else {
single_value->field_num__nc__measurements.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nm__measurements().get_selection()) {
single_value->field_nm__measurements = other_value.nm__measurements();
} else {
single_value->field_nm__measurements.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new NCMeasurementReport_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new NCMeasurementReport_template(*other_value.implication_.precondition);
implication_.implied_template = new NCMeasurementReport_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
break;
}
set_selection(other_value);
}

NCMeasurementReport_template::NCMeasurementReport_template()
{
}

NCMeasurementReport_template::NCMeasurementReport_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

NCMeasurementReport_template::NCMeasurementReport_template(const NCMeasurementReport& other_value)
{
copy_value(other_value);
}

NCMeasurementReport_template::NCMeasurementReport_template(const OPTIONAL<NCMeasurementReport>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NCMeasurementReport&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.NCMeasurementReport from an unbound optional field.");
}
}

NCMeasurementReport_template::NCMeasurementReport_template(NCMeasurementReport_template* p_precondition, NCMeasurementReport_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

NCMeasurementReport_template::NCMeasurementReport_template(Dynamic_Match_Interface<NCMeasurementReport>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<NCMeasurementReport>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

NCMeasurementReport_template::NCMeasurementReport_template(const NCMeasurementReport_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

NCMeasurementReport_template::~NCMeasurementReport_template()
{
clean_up();
}

NCMeasurementReport_template& NCMeasurementReport_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

NCMeasurementReport_template& NCMeasurementReport_template::operator=(const NCMeasurementReport& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

NCMeasurementReport_template& NCMeasurementReport_template::operator=(const OPTIONAL<NCMeasurementReport>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NCMeasurementReport&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
}
return *this;
}

NCMeasurementReport_template& NCMeasurementReport_template::operator=(const NCMeasurementReport_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean NCMeasurementReport_template::match(const NCMeasurementReport& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.nc__mode().is_bound()) return FALSE;
if(!single_value->field_nc__mode.match(other_value.nc__mode(), legacy))return FALSE;
if(!other_value.rxlev__serving__cell().is_bound()) return FALSE;
if(!single_value->field_rxlev__serving__cell.match(other_value.rxlev__serving__cell(), legacy))return FALSE;
if(!other_value.zero().is_bound()) return FALSE;
if(!single_value->field_zero.match(other_value.zero(), legacy))return FALSE;
if(!other_value.num__nc__measurements().is_bound()) return FALSE;
if(!single_value->field_num__nc__measurements.match(other_value.num__nc__measurements(), legacy))return FALSE;
if(!other_value.nm__measurements().is_bound()) return FALSE;
if(!single_value->field_nm__measurements.match(other_value.nm__measurements(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
}
return FALSE;
}

boolean NCMeasurementReport_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_nc__mode.is_bound()
 || single_value->field_rxlev__serving__cell.is_bound()
 || single_value->field_zero.is_bound()
 || single_value->field_num__nc__measurements.is_bound()
 || single_value->field_nm__measurements.is_bound();
}

boolean NCMeasurementReport_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_nc__mode.is_value()
 && single_value->field_rxlev__serving__cell.is_value()
 && single_value->field_zero.is_value()
 && single_value->field_num__nc__measurements.is_value()
 && single_value->field_nm__measurements.is_value();
}

void NCMeasurementReport_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

NCMeasurementReport NCMeasurementReport_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
NCMeasurementReport ret_val;
if (single_value->field_nc__mode.is_bound()) {
ret_val.nc__mode() = single_value->field_nc__mode.valueof();
}
if (single_value->field_rxlev__serving__cell.is_bound()) {
ret_val.rxlev__serving__cell() = single_value->field_rxlev__serving__cell.valueof();
}
if (single_value->field_zero.is_bound()) {
ret_val.zero() = single_value->field_zero.valueof();
}
if (single_value->field_num__nc__measurements.is_bound()) {
ret_val.num__nc__measurements() = single_value->field_num__nc__measurements.valueof();
}
if (single_value->field_nm__measurements.is_bound()) {
ret_val.nm__measurements() = single_value->field_nm__measurements.valueof();
}
return ret_val;
}

void NCMeasurementReport_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new NCMeasurementReport_template[list_length];
}

NCMeasurementReport_template& NCMeasurementReport_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
return value_list.list_value[list_index];
}

BITSTRING_template& NCMeasurementReport_template::nc__mode()
{
set_specific();
return single_value->field_nc__mode;
}

const BITSTRING_template& NCMeasurementReport_template::nc__mode() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nc_mode of a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
return single_value->field_nc__mode;
}

INTEGER_template& NCMeasurementReport_template::rxlev__serving__cell()
{
set_specific();
return single_value->field_rxlev__serving__cell;
}

const INTEGER_template& NCMeasurementReport_template::rxlev__serving__cell() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rxlev_serving_cell of a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
return single_value->field_rxlev__serving__cell;
}

BITSTRING_template& NCMeasurementReport_template::zero()
{
set_specific();
return single_value->field_zero;
}

const BITSTRING_template& NCMeasurementReport_template::zero() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field zero of a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
return single_value->field_zero;
}

INTEGER_template& NCMeasurementReport_template::num__nc__measurements()
{
set_specific();
return single_value->field_num__nc__measurements;
}

const INTEGER_template& NCMeasurementReport_template::num__nc__measurements() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field num_nc_measurements of a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
return single_value->field_num__nc__measurements;
}

NCMeasurementList_template& NCMeasurementReport_template::nm__measurements()
{
set_specific();
return single_value->field_nm__measurements;
}

const NCMeasurementList_template& NCMeasurementReport_template::nm__measurements() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nm_measurements of a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
return single_value->field_nm__measurements;
}

int NCMeasurementReport_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementReport which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementReport containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementReport containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementReport containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementReport containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementReport containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementReport containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementReport containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementReport containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
  }
  return 0;
}

void NCMeasurementReport_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ nc_mode := ");
single_value->field_nc__mode.log();
TTCN_Logger::log_event_str(", rxlev_serving_cell := ");
single_value->field_rxlev__serving__cell.log();
TTCN_Logger::log_event_str(", zero := ");
single_value->field_zero.log();
TTCN_Logger::log_event_str(", num_nc_measurements := ");
single_value->field_num__nc__measurements.log();
TTCN_Logger::log_event_str(", nm_measurements := ");
single_value->field_nm__measurements.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void NCMeasurementReport_template::log_match(const NCMeasurementReport& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_nc__mode.match(match_value.nc__mode(), legacy)){
TTCN_Logger::log_logmatch_info(".nc_mode");
single_value->field_nc__mode.log_match(match_value.nc__mode(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rxlev__serving__cell.match(match_value.rxlev__serving__cell(), legacy)){
TTCN_Logger::log_logmatch_info(".rxlev_serving_cell");
single_value->field_rxlev__serving__cell.log_match(match_value.rxlev__serving__cell(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_zero.match(match_value.zero(), legacy)){
TTCN_Logger::log_logmatch_info(".zero");
single_value->field_zero.log_match(match_value.zero(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_num__nc__measurements.match(match_value.num__nc__measurements(), legacy)){
TTCN_Logger::log_logmatch_info(".num_nc_measurements");
single_value->field_num__nc__measurements.log_match(match_value.num__nc__measurements(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nm__measurements.match(match_value.nm__measurements(), legacy)){
TTCN_Logger::log_logmatch_info(".nm_measurements");
single_value->field_nm__measurements.log_match(match_value.nm__measurements(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ nc_mode := ");
single_value->field_nc__mode.log_match(match_value.nc__mode(), legacy);
TTCN_Logger::log_event_str(", rxlev_serving_cell := ");
single_value->field_rxlev__serving__cell.log_match(match_value.rxlev__serving__cell(), legacy);
TTCN_Logger::log_event_str(", zero := ");
single_value->field_zero.log_match(match_value.zero(), legacy);
TTCN_Logger::log_event_str(", num_nc_measurements := ");
single_value->field_num__nc__measurements.log_match(match_value.num__nc__measurements(), legacy);
TTCN_Logger::log_event_str(", nm_measurements := ");
single_value->field_nm__measurements.log_match(match_value.nm__measurements(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void NCMeasurementReport_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (nc__mode().is_bound()) nc__mode().set_implicit_omit();
if (rxlev__serving__cell().is_bound()) rxlev__serving__cell().set_implicit_omit();
if (zero().is_bound()) zero().set_implicit_omit();
if (num__nc__measurements().is_bound()) num__nc__measurements().set_implicit_omit();
if (nm__measurements().is_bound()) nm__measurements().set_implicit_omit();
}

void NCMeasurementReport_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_nc__mode.encode_text(text_buf);
single_value->field_rxlev__serving__cell.encode_text(text_buf);
single_value->field_zero.encode_text(text_buf);
single_value->field_num__nc__measurements.encode_text(text_buf);
single_value->field_nm__measurements.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
}
}

void NCMeasurementReport_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_nc__mode.decode_text(text_buf);
single_value->field_rxlev__serving__cell.decode_text(text_buf);
single_value->field_zero.decode_text(text_buf);
single_value->field_num__nc__measurements.decode_text(text_buf);
single_value->field_nm__measurements.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new NCMeasurementReport_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.NCMeasurementReport.");
}
}

void NCMeasurementReport_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    NCMeasurementReport_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.NCMeasurementReport has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) nc__mode().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) rxlev__serving__cell().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) zero().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) num__nc__measurements().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) nm__measurements().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nc_mode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nc__mode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rxlev_serving_cell")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rxlev__serving__cell().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "zero")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          zero().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "num_nc_measurements")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          num__nc__measurements().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nm_measurements")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nm__measurements().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.NCMeasurementReport: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    NCMeasurementReport_template* precondition = new NCMeasurementReport_template;
    precondition->set_param(*param.get_elem(0));
    NCMeasurementReport_template* implied_template = new NCMeasurementReport_template;
    implied_template->set_param(*param.get_elem(1));
    *this = NCMeasurementReport_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.NCMeasurementReport");
  }
  is_ifpresent = param.get_ifpresent();
}

void NCMeasurementReport_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_nc__mode.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurementReport");
single_value->field_rxlev__serving__cell.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurementReport");
single_value->field_zero.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurementReport");
single_value->field_num__nc__measurements.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurementReport");
single_value->field_nm__measurements.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurementReport");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurementReport");
}

boolean NCMeasurementReport_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean NCMeasurementReport_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PacketMeasReport::PacketMeasReport()
{
}

PacketMeasReport::PacketMeasReport(const OCTETSTRING& par_tlli,
    const BITSTRING& par_psi5__change__mark__presence,
    const OPTIONAL< BITSTRING >& par_psi5__change__mark,
    const BITSTRING& par_additions__99,
    const OPTIONAL< NCMeasurementReport >& par_nc__meas__report)
  :   field_tlli(par_tlli),
  field_psi5__change__mark__presence(par_psi5__change__mark__presence),
  field_psi5__change__mark(par_psi5__change__mark),
  field_additions__99(par_additions__99),
  field_nc__meas__report(par_nc__meas__report)
{
}

PacketMeasReport::PacketMeasReport(const PacketMeasReport& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.PacketMeasReport.");
if (other_value.tlli().is_bound()) field_tlli = other_value.tlli();
else field_tlli.clean_up();
if (other_value.psi5__change__mark__presence().is_bound()) field_psi5__change__mark__presence = other_value.psi5__change__mark__presence();
else field_psi5__change__mark__presence.clean_up();
if (other_value.psi5__change__mark().is_bound()) field_psi5__change__mark = other_value.psi5__change__mark();
else field_psi5__change__mark.clean_up();
if (other_value.additions__99().is_bound()) field_additions__99 = other_value.additions__99();
else field_additions__99.clean_up();
if (other_value.nc__meas__report().is_bound()) field_nc__meas__report = other_value.nc__meas__report();
else field_nc__meas__report.clean_up();
}

void PacketMeasReport::clean_up()
{
field_tlli.clean_up();
field_psi5__change__mark__presence.clean_up();
field_psi5__change__mark.clean_up();
field_additions__99.clean_up();
field_nc__meas__report.clean_up();
}

const TTCN_Typedescriptor_t* PacketMeasReport::get_descriptor() const { return &PacketMeasReport_descr_; }
PacketMeasReport& PacketMeasReport::operator=(const PacketMeasReport& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.PacketMeasReport.");
  if (other_value.tlli().is_bound()) field_tlli = other_value.tlli();
  else field_tlli.clean_up();
  if (other_value.psi5__change__mark__presence().is_bound()) field_psi5__change__mark__presence = other_value.psi5__change__mark__presence();
  else field_psi5__change__mark__presence.clean_up();
  if (other_value.psi5__change__mark().is_bound()) field_psi5__change__mark = other_value.psi5__change__mark();
  else field_psi5__change__mark.clean_up();
  if (other_value.additions__99().is_bound()) field_additions__99 = other_value.additions__99();
  else field_additions__99.clean_up();
  if (other_value.nc__meas__report().is_bound()) field_nc__meas__report = other_value.nc__meas__report();
  else field_nc__meas__report.clean_up();
}
return *this;
}

boolean PacketMeasReport::operator==(const PacketMeasReport& other_value) const
{
return field_tlli==other_value.field_tlli
  && field_psi5__change__mark__presence==other_value.field_psi5__change__mark__presence
  && field_psi5__change__mark==other_value.field_psi5__change__mark
  && field_additions__99==other_value.field_additions__99
  && field_nc__meas__report==other_value.field_nc__meas__report;
}

boolean PacketMeasReport::is_bound() const
{
return (field_tlli.is_bound())
  || (field_psi5__change__mark__presence.is_bound())
  || (OPTIONAL_OMIT == field_psi5__change__mark.get_selection() || field_psi5__change__mark.is_bound())
  || (field_additions__99.is_bound())
  || (OPTIONAL_OMIT == field_nc__meas__report.get_selection() || field_nc__meas__report.is_bound());
}
boolean PacketMeasReport::is_value() const
{
return field_tlli.is_value()
  && field_psi5__change__mark__presence.is_value()
  && (OPTIONAL_OMIT == field_psi5__change__mark.get_selection() || field_psi5__change__mark.is_value())
  && field_additions__99.is_value()
  && (OPTIONAL_OMIT == field_nc__meas__report.get_selection() || field_nc__meas__report.is_value());
}
int PacketMeasReport::size_of() const
{
  int ret_val = 3;
  if (field_psi5__change__mark.ispresent()) ret_val++;
  if (field_nc__meas__report.ispresent()) ret_val++;
  return ret_val;
}

void PacketMeasReport::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tlli := ");
field_tlli.log();
TTCN_Logger::log_event_str(", psi5_change_mark_presence := ");
field_psi5__change__mark__presence.log();
TTCN_Logger::log_event_str(", psi5_change_mark := ");
field_psi5__change__mark.log();
TTCN_Logger::log_event_str(", additions_99 := ");
field_additions__99.log();
TTCN_Logger::log_event_str(", nc_meas_report := ");
field_nc__meas__report.log();
TTCN_Logger::log_event_str(" }");
}

void PacketMeasReport::set_implicit_omit()
{
if (tlli().is_bound()) tlli().set_implicit_omit();
if (psi5__change__mark__presence().is_bound()) psi5__change__mark__presence().set_implicit_omit();
if (!psi5__change__mark().is_bound()) psi5__change__mark() = OMIT_VALUE;
else psi5__change__mark().set_implicit_omit();
if (additions__99().is_bound()) additions__99().set_implicit_omit();
if (!nc__meas__report().is_bound()) nc__meas__report() = OMIT_VALUE;
else nc__meas__report().set_implicit_omit();
}

void PacketMeasReport::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.PacketMeasReport has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tlli().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) psi5__change__mark__presence().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) psi5__change__mark().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) additions__99().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) nc__meas__report().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tlli")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tlli().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "psi5_change_mark_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          psi5__change__mark__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "psi5_change_mark")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          psi5__change__mark().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "additions_99")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          additions__99().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nc_meas_report")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nc__meas__report().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.PacketMeasReport: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.PacketMeasReport");
  }
}

void PacketMeasReport::encode_text(Text_Buf& text_buf) const
{
field_tlli.encode_text(text_buf);
field_psi5__change__mark__presence.encode_text(text_buf);
field_psi5__change__mark.encode_text(text_buf);
field_additions__99.encode_text(text_buf);
field_nc__meas__report.encode_text(text_buf);
}

void PacketMeasReport::decode_text(Text_Buf& text_buf)
{
field_tlli.decode_text(text_buf);
field_psi5__change__mark__presence.decode_text(text_buf);
field_psi5__change__mark.decode_text(text_buf);
field_additions__99.decode_text(text_buf);
field_nc__meas__report.decode_text(text_buf);
}

void PacketMeasReport::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PacketMeasReport::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PacketMeasReport::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, PacketMeasReport_tlli_descr_.raw->forceomit);
  decoded_field_length = field_tlli.RAW_decode(PacketMeasReport_tlli_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, PacketMeasReport_psi5__change__mark__presence_descr_.raw->forceomit);
  decoded_field_length = field_psi5__change__mark__presence.RAW_decode(PacketMeasReport_psi5__change__mark__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_psi5__change__mark__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_psi5__change__mark = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, PacketMeasReport_psi5__change__mark_descr_.raw->forceomit);
  decoded_field_length = field_psi5__change__mark().RAW_decode(PacketMeasReport_psi5__change__mark_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_psi5__change__mark = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_psi5__change__mark=OMIT_VALUE;
  RAW_Force_Omit field_3_force_omit(3, force_omit, PacketMeasReport_additions__99_descr_.raw->forceomit);
  decoded_field_length = field_additions__99.RAW_decode(PacketMeasReport_additions__99_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_additions__99 ==  bs_1){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_nc__meas__report = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, PacketMeasReport_nc__meas__report_descr_.raw->forceomit);
  decoded_field_length = field_nc__meas__report().RAW_decode(PacketMeasReport_nc__meas__report_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_nc__meas__report = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_nc__meas__report=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PacketMeasReport::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, PacketMeasReport_tlli_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, PacketMeasReport_psi5__change__mark__presence_descr_.raw);
  if (field_psi5__change__mark.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, PacketMeasReport_psi5__change__mark_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, PacketMeasReport_additions__99_descr_.raw);
  if (field_nc__meas__report.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, PacketMeasReport_nc__meas__report_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  encoded_length += field_tlli.RAW_encode(PacketMeasReport_tlli_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_psi5__change__mark__presence.RAW_encode(PacketMeasReport_psi5__change__mark__presence_descr_, *myleaf.body.node.nodes[1]);
  if (field_psi5__change__mark.ispresent()) {
  encoded_length += field_psi5__change__mark().RAW_encode(PacketMeasReport_psi5__change__mark_descr_, *myleaf.body.node.nodes[2]);
  }
  encoded_length += field_additions__99.RAW_encode(PacketMeasReport_additions__99_descr_, *myleaf.body.node.nodes[3]);
  if (field_nc__meas__report.ispresent()) {
  encoded_length += field_nc__meas__report().RAW_encode(PacketMeasReport_nc__meas__report_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_psi5__change__mark.ispresent() && (field_psi5__change__mark__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={1};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(PacketMeasReport_psi5__change__mark__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_nc__meas__report.ispresent() && (field_additions__99 !=  bs_1)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={3};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_1.RAW_encode(PacketMeasReport_additions__99_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PacketMeasReport_template::single_value_struct {
OCTETSTRING_template field_tlli;
BITSTRING_template field_psi5__change__mark__presence;
BITSTRING_template field_psi5__change__mark;
BITSTRING_template field_additions__99;
NCMeasurementReport_template field_nc__meas__report;
};

void PacketMeasReport_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tlli = ANY_VALUE;
single_value->field_psi5__change__mark__presence = ANY_VALUE;
single_value->field_psi5__change__mark = ANY_OR_OMIT;
single_value->field_additions__99 = ANY_VALUE;
single_value->field_nc__meas__report = ANY_OR_OMIT;
}
}
}

void PacketMeasReport_template::copy_value(const PacketMeasReport& other_value)
{
single_value = new single_value_struct;
if (other_value.tlli().is_bound()) {
  single_value->field_tlli = other_value.tlli();
} else {
  single_value->field_tlli.clean_up();
}
if (other_value.psi5__change__mark__presence().is_bound()) {
  single_value->field_psi5__change__mark__presence = other_value.psi5__change__mark__presence();
} else {
  single_value->field_psi5__change__mark__presence.clean_up();
}
if (other_value.psi5__change__mark().is_bound()) {
  if (other_value.psi5__change__mark().ispresent()) single_value->field_psi5__change__mark = other_value.psi5__change__mark()();
  else single_value->field_psi5__change__mark = OMIT_VALUE;
} else {
  single_value->field_psi5__change__mark.clean_up();
}
if (other_value.additions__99().is_bound()) {
  single_value->field_additions__99 = other_value.additions__99();
} else {
  single_value->field_additions__99.clean_up();
}
if (other_value.nc__meas__report().is_bound()) {
  if (other_value.nc__meas__report().ispresent()) single_value->field_nc__meas__report = other_value.nc__meas__report()();
  else single_value->field_nc__meas__report = OMIT_VALUE;
} else {
  single_value->field_nc__meas__report.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PacketMeasReport_template::copy_template(const PacketMeasReport_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tlli().get_selection()) {
single_value->field_tlli = other_value.tlli();
} else {
single_value->field_tlli.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.psi5__change__mark__presence().get_selection()) {
single_value->field_psi5__change__mark__presence = other_value.psi5__change__mark__presence();
} else {
single_value->field_psi5__change__mark__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.psi5__change__mark().get_selection()) {
single_value->field_psi5__change__mark = other_value.psi5__change__mark();
} else {
single_value->field_psi5__change__mark.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.additions__99().get_selection()) {
single_value->field_additions__99 = other_value.additions__99();
} else {
single_value->field_additions__99.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nc__meas__report().get_selection()) {
single_value->field_nc__meas__report = other_value.nc__meas__report();
} else {
single_value->field_nc__meas__report.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PacketMeasReport_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PacketMeasReport_template(*other_value.implication_.precondition);
implication_.implied_template = new PacketMeasReport_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
break;
}
set_selection(other_value);
}

PacketMeasReport_template::PacketMeasReport_template()
{
}

PacketMeasReport_template::PacketMeasReport_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PacketMeasReport_template::PacketMeasReport_template(const PacketMeasReport& other_value)
{
copy_value(other_value);
}

PacketMeasReport_template::PacketMeasReport_template(const OPTIONAL<PacketMeasReport>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketMeasReport&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.PacketMeasReport from an unbound optional field.");
}
}

PacketMeasReport_template::PacketMeasReport_template(PacketMeasReport_template* p_precondition, PacketMeasReport_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PacketMeasReport_template::PacketMeasReport_template(Dynamic_Match_Interface<PacketMeasReport>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PacketMeasReport>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PacketMeasReport_template::PacketMeasReport_template(const PacketMeasReport_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PacketMeasReport_template::~PacketMeasReport_template()
{
clean_up();
}

PacketMeasReport_template& PacketMeasReport_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PacketMeasReport_template& PacketMeasReport_template::operator=(const PacketMeasReport& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PacketMeasReport_template& PacketMeasReport_template::operator=(const OPTIONAL<PacketMeasReport>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketMeasReport&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
}
return *this;
}

PacketMeasReport_template& PacketMeasReport_template::operator=(const PacketMeasReport_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PacketMeasReport_template::match(const PacketMeasReport& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tlli().is_bound()) return FALSE;
if(!single_value->field_tlli.match(other_value.tlli(), legacy))return FALSE;
if(!other_value.psi5__change__mark__presence().is_bound()) return FALSE;
if(!single_value->field_psi5__change__mark__presence.match(other_value.psi5__change__mark__presence(), legacy))return FALSE;
if(!other_value.psi5__change__mark().is_bound()) return FALSE;
if((other_value.psi5__change__mark().ispresent() ? !single_value->field_psi5__change__mark.match((const BITSTRING&)other_value.psi5__change__mark(), legacy) : !single_value->field_psi5__change__mark.match_omit(legacy)))return FALSE;
if(!other_value.additions__99().is_bound()) return FALSE;
if(!single_value->field_additions__99.match(other_value.additions__99(), legacy))return FALSE;
if(!other_value.nc__meas__report().is_bound()) return FALSE;
if((other_value.nc__meas__report().ispresent() ? !single_value->field_nc__meas__report.match((const NCMeasurementReport&)other_value.nc__meas__report(), legacy) : !single_value->field_nc__meas__report.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
}
return FALSE;
}

boolean PacketMeasReport_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tlli.is_bound()
 || single_value->field_psi5__change__mark__presence.is_bound()
 || (single_value->field_psi5__change__mark.is_omit() || single_value->field_psi5__change__mark.is_bound())
 || single_value->field_additions__99.is_bound()
 || (single_value->field_nc__meas__report.is_omit() || single_value->field_nc__meas__report.is_bound());
}

boolean PacketMeasReport_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tlli.is_value()
 && single_value->field_psi5__change__mark__presence.is_value()
 && (single_value->field_psi5__change__mark.is_omit() || single_value->field_psi5__change__mark.is_value())
 && single_value->field_additions__99.is_value()
 && (single_value->field_nc__meas__report.is_omit() || single_value->field_nc__meas__report.is_value());
}

void PacketMeasReport_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PacketMeasReport PacketMeasReport_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
PacketMeasReport ret_val;
if (single_value->field_tlli.is_bound()) {
ret_val.tlli() = single_value->field_tlli.valueof();
}
if (single_value->field_psi5__change__mark__presence.is_bound()) {
ret_val.psi5__change__mark__presence() = single_value->field_psi5__change__mark__presence.valueof();
}
if (single_value->field_psi5__change__mark.is_omit()) ret_val.psi5__change__mark() = OMIT_VALUE;
else if (single_value->field_psi5__change__mark.is_bound()) {
ret_val.psi5__change__mark() = single_value->field_psi5__change__mark.valueof();
}
if (single_value->field_additions__99.is_bound()) {
ret_val.additions__99() = single_value->field_additions__99.valueof();
}
if (single_value->field_nc__meas__report.is_omit()) ret_val.nc__meas__report() = OMIT_VALUE;
else if (single_value->field_nc__meas__report.is_bound()) {
ret_val.nc__meas__report() = single_value->field_nc__meas__report.valueof();
}
return ret_val;
}

void PacketMeasReport_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PacketMeasReport_template[list_length];
}

PacketMeasReport_template& PacketMeasReport_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PacketMeasReport_template::tlli()
{
set_specific();
return single_value->field_tlli;
}

const OCTETSTRING_template& PacketMeasReport_template::tlli() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tlli of a non-specific template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
return single_value->field_tlli;
}

BITSTRING_template& PacketMeasReport_template::psi5__change__mark__presence()
{
set_specific();
return single_value->field_psi5__change__mark__presence;
}

const BITSTRING_template& PacketMeasReport_template::psi5__change__mark__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field psi5_change_mark_presence of a non-specific template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
return single_value->field_psi5__change__mark__presence;
}

BITSTRING_template& PacketMeasReport_template::psi5__change__mark()
{
set_specific();
return single_value->field_psi5__change__mark;
}

const BITSTRING_template& PacketMeasReport_template::psi5__change__mark() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field psi5_change_mark of a non-specific template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
return single_value->field_psi5__change__mark;
}

BITSTRING_template& PacketMeasReport_template::additions__99()
{
set_specific();
return single_value->field_additions__99;
}

const BITSTRING_template& PacketMeasReport_template::additions__99() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field additions_99 of a non-specific template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
return single_value->field_additions__99;
}

NCMeasurementReport_template& PacketMeasReport_template::nc__meas__report()
{
set_specific();
return single_value->field_nc__meas__report;
}

const NCMeasurementReport_template& PacketMeasReport_template::nc__meas__report() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nc_meas_report of a non-specific template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
return single_value->field_nc__meas__report;
}

int PacketMeasReport_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketMeasReport which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 3;
      if (single_value->field_psi5__change__mark.is_present()) ret_val++;
      if (single_value->field_nc__meas__report.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketMeasReport containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketMeasReport containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketMeasReport containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketMeasReport containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketMeasReport containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketMeasReport containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketMeasReport containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketMeasReport containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
  }
  return 0;
}

void PacketMeasReport_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tlli := ");
single_value->field_tlli.log();
TTCN_Logger::log_event_str(", psi5_change_mark_presence := ");
single_value->field_psi5__change__mark__presence.log();
TTCN_Logger::log_event_str(", psi5_change_mark := ");
single_value->field_psi5__change__mark.log();
TTCN_Logger::log_event_str(", additions_99 := ");
single_value->field_additions__99.log();
TTCN_Logger::log_event_str(", nc_meas_report := ");
single_value->field_nc__meas__report.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PacketMeasReport_template::log_match(const PacketMeasReport& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tlli.match(match_value.tlli(), legacy)){
TTCN_Logger::log_logmatch_info(".tlli");
single_value->field_tlli.log_match(match_value.tlli(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_psi5__change__mark__presence.match(match_value.psi5__change__mark__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".psi5_change_mark_presence");
single_value->field_psi5__change__mark__presence.log_match(match_value.psi5__change__mark__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.psi5__change__mark().ispresent()){
if(!single_value->field_psi5__change__mark.match(match_value.psi5__change__mark(), legacy)){
TTCN_Logger::log_logmatch_info(".psi5_change_mark");
single_value->field_psi5__change__mark.log_match(match_value.psi5__change__mark(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_psi5__change__mark.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".psi5_change_mark := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_psi5__change__mark.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_additions__99.match(match_value.additions__99(), legacy)){
TTCN_Logger::log_logmatch_info(".additions_99");
single_value->field_additions__99.log_match(match_value.additions__99(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.nc__meas__report().ispresent()){
if(!single_value->field_nc__meas__report.match(match_value.nc__meas__report(), legacy)){
TTCN_Logger::log_logmatch_info(".nc_meas_report");
single_value->field_nc__meas__report.log_match(match_value.nc__meas__report(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_nc__meas__report.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".nc_meas_report := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_nc__meas__report.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tlli := ");
single_value->field_tlli.log_match(match_value.tlli(), legacy);
TTCN_Logger::log_event_str(", psi5_change_mark_presence := ");
single_value->field_psi5__change__mark__presence.log_match(match_value.psi5__change__mark__presence(), legacy);
TTCN_Logger::log_event_str(", psi5_change_mark := ");
if (match_value.psi5__change__mark().ispresent()) {
single_value->field_psi5__change__mark.log_match(match_value.psi5__change__mark(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_psi5__change__mark.log();
if (single_value->field_psi5__change__mark.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", additions_99 := ");
single_value->field_additions__99.log_match(match_value.additions__99(), legacy);
TTCN_Logger::log_event_str(", nc_meas_report := ");
if (match_value.nc__meas__report().ispresent()) {
single_value->field_nc__meas__report.log_match(match_value.nc__meas__report(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_nc__meas__report.log();
if (single_value->field_nc__meas__report.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PacketMeasReport_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (tlli().is_bound()) tlli().set_implicit_omit();
if (psi5__change__mark__presence().is_bound()) psi5__change__mark__presence().set_implicit_omit();
if (!psi5__change__mark().is_bound()) psi5__change__mark() = OMIT_VALUE;
else psi5__change__mark().set_implicit_omit();
if (additions__99().is_bound()) additions__99().set_implicit_omit();
if (!nc__meas__report().is_bound()) nc__meas__report() = OMIT_VALUE;
else nc__meas__report().set_implicit_omit();
}

void PacketMeasReport_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tlli.encode_text(text_buf);
single_value->field_psi5__change__mark__presence.encode_text(text_buf);
single_value->field_psi5__change__mark.encode_text(text_buf);
single_value->field_additions__99.encode_text(text_buf);
single_value->field_nc__meas__report.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
}
}

void PacketMeasReport_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tlli.decode_text(text_buf);
single_value->field_psi5__change__mark__presence.decode_text(text_buf);
single_value->field_psi5__change__mark.decode_text(text_buf);
single_value->field_additions__99.decode_text(text_buf);
single_value->field_nc__meas__report.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PacketMeasReport_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.PacketMeasReport.");
}
}

void PacketMeasReport_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PacketMeasReport_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.PacketMeasReport has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tlli().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) psi5__change__mark__presence().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) psi5__change__mark().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) additions__99().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) nc__meas__report().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tlli")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tlli().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "psi5_change_mark_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          psi5__change__mark__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "psi5_change_mark")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          psi5__change__mark().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "additions_99")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          additions__99().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nc_meas_report")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nc__meas__report().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.PacketMeasReport: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PacketMeasReport_template* precondition = new PacketMeasReport_template;
    precondition->set_param(*param.get_elem(0));
    PacketMeasReport_template* implied_template = new PacketMeasReport_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PacketMeasReport_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.PacketMeasReport");
  }
  is_ifpresent = param.get_ifpresent();
}

void PacketMeasReport_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tlli.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketMeasReport");
single_value->field_psi5__change__mark__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketMeasReport");
single_value->field_psi5__change__mark.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketMeasReport");
single_value->field_additions__99.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketMeasReport");
single_value->field_nc__meas__report.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketMeasReport");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.PacketMeasReport");
}

boolean PacketMeasReport_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PacketMeasReport_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void MSRadioAccCap2::copy_value(const MSRadioAccCap2& other_value)
{
switch (other_value.union_selection) {
case ALT_msRadioAccessCapabilityV:
field_msRadioAccessCapabilityV = new MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV(*other_value.field_msRadioAccessCapabilityV);
break;
default:
TTCN_error("Assignment of an unbound union value of type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
union_selection = other_value.union_selection;
}

MSRadioAccCap2::MSRadioAccCap2()
{
union_selection = UNBOUND_VALUE;
}

MSRadioAccCap2::MSRadioAccCap2(const MSRadioAccCap2& other_value)
: Base_Type(){
copy_value(other_value);
}

MSRadioAccCap2::~MSRadioAccCap2()
{
clean_up();
}

MSRadioAccCap2& MSRadioAccCap2::operator=(const MSRadioAccCap2& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean MSRadioAccCap2::operator==(const MSRadioAccCap2& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_msRadioAccessCapabilityV:
return *field_msRadioAccessCapabilityV == *other_value.field_msRadioAccessCapabilityV;
default:
return FALSE;
}
}

MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV& MSRadioAccCap2::msRadioAccessCapabilityV()
{
if (union_selection != ALT_msRadioAccessCapabilityV) {
clean_up();
field_msRadioAccessCapabilityV = new MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV;
union_selection = ALT_msRadioAccessCapabilityV;
}
return *field_msRadioAccessCapabilityV;
}

const MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV& MSRadioAccCap2::msRadioAccessCapabilityV() const
{
if (union_selection != ALT_msRadioAccessCapabilityV) TTCN_error("Using non-selected field msRadioAccessCapabilityV in a value of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
return *field_msRadioAccessCapabilityV;
}

boolean MSRadioAccCap2::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
return union_selection == checked_selection;
}

boolean MSRadioAccCap2::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean MSRadioAccCap2::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_msRadioAccessCapabilityV: return field_msRadioAccessCapabilityV->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void MSRadioAccCap2::clean_up()
{
switch (union_selection) {
case ALT_msRadioAccessCapabilityV:
  delete field_msRadioAccessCapabilityV;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void MSRadioAccCap2::log() const
{
switch (union_selection) {
case ALT_msRadioAccessCapabilityV:
TTCN_Logger::log_event_str("{ msRadioAccessCapabilityV := ");
field_msRadioAccessCapabilityV->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void MSRadioAccCap2::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "msRadioAccessCapabilityV")) {
    msRadioAccessCapabilityV().set_param(*mp_last);
    if (!msRadioAccessCapabilityV().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @RLCMAC_CSN1_Types.MSRadioAccCap2.", last_name);
}

void MSRadioAccCap2::set_implicit_omit()
{
switch (union_selection) {
case ALT_msRadioAccessCapabilityV:
field_msRadioAccessCapabilityV->set_implicit_omit(); break;
default: break;
}
}

void MSRadioAccCap2::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_msRadioAccessCapabilityV:
field_msRadioAccessCapabilityV->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
}

void MSRadioAccCap2::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_msRadioAccessCapabilityV:
msRadioAccessCapabilityV().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
}

void MSRadioAccCap2::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void MSRadioAccCap2::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int MSRadioAccCap2::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, MSRadioAccCap2_msRadioAccessCapabilityV_descr_.raw->forceomit);
      decoded_length = msRadioAccessCapabilityV().RAW_decode(MSRadioAccCap2_msRadioAccessCapabilityV_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, MSRadioAccCap2_msRadioAccessCapabilityV_descr_.raw->forceomit);
      decoded_length = msRadioAccessCapabilityV().RAW_decode(MSRadioAccCap2_msRadioAccessCapabilityV_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int MSRadioAccCap2::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 1;  myleaf.body.node.nodes = init_nodes_of_enc_tree(1);
  memset(myleaf.body.node.nodes, 0, 1 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_msRadioAccessCapabilityV:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, MSRadioAccCap2_msRadioAccessCapabilityV_descr_.raw);
    encoded_length = field_msRadioAccessCapabilityV->RAW_encode(MSRadioAccCap2_msRadioAccessCapabilityV_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &MSRadioAccCap2_msRadioAccessCapabilityV_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void MSRadioAccCap2_template::copy_value(const MSRadioAccCap2& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
single_value.field_msRadioAccessCapabilityV = new MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV_template(other_value.msRadioAccessCapabilityV());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
set_selection(SPECIFIC_VALUE);
}

void MSRadioAccCap2_template::copy_template(const MSRadioAccCap2_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
single_value.field_msRadioAccessCapabilityV = new MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV_template(*other_value.single_value.field_msRadioAccessCapabilityV);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new MSRadioAccCap2_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new MSRadioAccCap2_template(*other_value.implication_.precondition);
implication_.implied_template = new MSRadioAccCap2_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
set_selection(other_value);
}

MSRadioAccCap2_template::MSRadioAccCap2_template()
{
}

MSRadioAccCap2_template::MSRadioAccCap2_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

MSRadioAccCap2_template::MSRadioAccCap2_template(const MSRadioAccCap2& other_value)
{
copy_value(other_value);
}

MSRadioAccCap2_template::MSRadioAccCap2_template(const OPTIONAL<MSRadioAccCap2>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MSRadioAccCap2&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2 from an unbound optional field.");
}
}

MSRadioAccCap2_template::MSRadioAccCap2_template(MSRadioAccCap2_template* p_precondition, MSRadioAccCap2_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

MSRadioAccCap2_template::MSRadioAccCap2_template(Dynamic_Match_Interface<MSRadioAccCap2>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<MSRadioAccCap2>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

MSRadioAccCap2_template::MSRadioAccCap2_template(const MSRadioAccCap2_template& other_value)
: Base_Template(){
copy_template(other_value);
}

MSRadioAccCap2_template::~MSRadioAccCap2_template()
{
clean_up();
}

void MSRadioAccCap2_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
delete single_value.field_msRadioAccessCapabilityV;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

MSRadioAccCap2_template& MSRadioAccCap2_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

MSRadioAccCap2_template& MSRadioAccCap2_template::operator=(const MSRadioAccCap2& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

MSRadioAccCap2_template& MSRadioAccCap2_template::operator=(const OPTIONAL<MSRadioAccCap2>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MSRadioAccCap2&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
return *this;
}

MSRadioAccCap2_template& MSRadioAccCap2_template::operator=(const MSRadioAccCap2_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean MSRadioAccCap2_template::match(const MSRadioAccCap2& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
MSRadioAccCap2::union_selection_type value_selection = other_value.get_selection();
if (value_selection == MSRadioAccCap2::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
return single_value.field_msRadioAccessCapabilityV->match(other_value.msRadioAccessCapabilityV(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
return FALSE;
}

boolean MSRadioAccCap2_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
return single_value.field_msRadioAccessCapabilityV->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
}

MSRadioAccCap2 MSRadioAccCap2_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
MSRadioAccCap2 ret_val;
switch (single_value.union_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
ret_val.msRadioAccessCapabilityV() = single_value.field_msRadioAccessCapabilityV->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
return ret_val;
}

MSRadioAccCap2_template& MSRadioAccCap2_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
return value_list.list_value[list_index];
}
void MSRadioAccCap2_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new MSRadioAccCap2_template[list_length];
}

MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV_template& MSRadioAccCap2_template::msRadioAccessCapabilityV()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != MSRadioAccCap2::ALT_msRadioAccessCapabilityV) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_msRadioAccessCapabilityV = new MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV_template(ANY_VALUE);
else single_value.field_msRadioAccessCapabilityV = new MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV_template;
single_value.union_selection = MSRadioAccCap2::ALT_msRadioAccessCapabilityV;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_msRadioAccessCapabilityV;
}

const MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV_template& MSRadioAccCap2_template::msRadioAccessCapabilityV() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field msRadioAccessCapabilityV in a non-specific template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
if (single_value.union_selection != MSRadioAccCap2::ALT_msRadioAccessCapabilityV) TTCN_error("Accessing non-selected field msRadioAccessCapabilityV in a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
return *single_value.field_msRadioAccessCapabilityV;
}

boolean MSRadioAccCap2_template::ischosen(MSRadioAccCap2::union_selection_type checked_selection) const
{
if (checked_selection == MSRadioAccCap2::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == MSRadioAccCap2::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2 containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void MSRadioAccCap2_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
TTCN_Logger::log_event_str("{ msRadioAccessCapabilityV := ");
single_value.field_msRadioAccessCapabilityV->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void MSRadioAccCap2_template::log_match(const MSRadioAccCap2& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".msRadioAccessCapabilityV");
single_value.field_msRadioAccessCapabilityV->log_match(match_value.msRadioAccessCapabilityV(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ msRadioAccessCapabilityV := ");
single_value.field_msRadioAccessCapabilityV->log_match(match_value.msRadioAccessCapabilityV(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void MSRadioAccCap2_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
single_value.field_msRadioAccessCapabilityV->set_implicit_omit(); break;
default: break;
}
}

void MSRadioAccCap2_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
single_value.field_msRadioAccessCapabilityV->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
}

void MSRadioAccCap2_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = MSRadioAccCap2::UNBOUND_VALUE;
MSRadioAccCap2::union_selection_type new_selection = (MSRadioAccCap2::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
single_value.field_msRadioAccessCapabilityV = new MobileL3__GMM__SM__Types::MSRadioAccessCapabilityV_template;
single_value.field_msRadioAccessCapabilityV->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new MSRadioAccCap2_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
}

boolean MSRadioAccCap2_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean MSRadioAccCap2_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void MSRadioAccCap2_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@RLCMAC_CSN1_Types.MSRadioAccCap2'");
    }
    if (strcmp("msRadioAccessCapabilityV", param_field) == 0) {
      msRadioAccessCapabilityV().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@RLCMAC_CSN1_Types.MSRadioAccCap2'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    MSRadioAccCap2_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@RLCMAC_CSN1_Types.MSRadioAccCap2");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "msRadioAccessCapabilityV")) {
      msRadioAccessCapabilityV().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @RLCMAC_CSN1_Types.MSRadioAccCap2.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    MSRadioAccCap2_template* precondition = new MSRadioAccCap2_template;
    precondition->set_param(*m_p->get_elem(0));
    MSRadioAccCap2_template* implied_template = new MSRadioAccCap2_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = MSRadioAccCap2_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@RLCMAC_CSN1_Types.MSRadioAccCap2");
  }
  is_ifpresent = param.get_ifpresent();
}

void MSRadioAccCap2_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case MSRadioAccCap2::ALT_msRadioAccessCapabilityV:
single_value.field_msRadioAccessCapabilityV->check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.MSRadioAccCap2");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @RLCMAC_CSN1_Types.MSRadioAccCap2.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.MSRadioAccCap2");
}

RlcAccessType::RlcAccessType()
{
enum_value = UNBOUND_VALUE;
}

RlcAccessType::RlcAccessType(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @RLCMAC_CSN1_Types.RlcAccessType with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

RlcAccessType::RlcAccessType(enum_type other_value)
{
enum_value = other_value;
}

RlcAccessType::RlcAccessType(const RlcAccessType& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
enum_value = other_value.enum_value;
}

RlcAccessType& RlcAccessType::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

RlcAccessType& RlcAccessType::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

RlcAccessType& RlcAccessType::operator=(const RlcAccessType& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
enum_value = other_value.enum_value;
return *this;
}

boolean RlcAccessType::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RLCMAC_CSN1_Types.RlcAccessType comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean RlcAccessType::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
return enum_value == other_value;
}

boolean RlcAccessType::operator==(const RlcAccessType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
return enum_value == other_value.enum_value;
}

boolean RlcAccessType::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RLCMAC_CSN1_Types.RlcAccessType comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean RlcAccessType::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
return enum_value < other_value;
}

boolean RlcAccessType::operator<(const RlcAccessType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
return enum_value < other_value.enum_value;
}

boolean RlcAccessType::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RLCMAC_CSN1_Types.RlcAccessType comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean RlcAccessType::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
return enum_value > other_value;
}

boolean RlcAccessType::operator>(const RlcAccessType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
return enum_value > other_value.enum_value;
}

const char *RlcAccessType::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case RLC__ACC__TYPE__TWO__PHASE: return "RLC_ACC_TYPE_TWO_PHASE";
case RLC__ACC__TYPE__PAG__RESPONSE: return "RLC_ACC_TYPE_PAG_RESPONSE";
case RLC__ACC__TYPE__CELL__UPDATE: return "RLC_ACC_TYPE_CELL_UPDATE";
case RLC__ACC__TYPE__MM: return "RLC_ACC_TYPE_MM";
default:
return "<unknown>";
}
}

RlcAccessType::enum_type RlcAccessType::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "RLC_ACC_TYPE_TWO_PHASE")) return RLC__ACC__TYPE__TWO__PHASE;
if (!strcmp(str_par, "RLC_ACC_TYPE_PAG_RESPONSE")) return RLC__ACC__TYPE__PAG__RESPONSE;
if (!strcmp(str_par, "RLC_ACC_TYPE_CELL_UPDATE")) return RLC__ACC__TYPE__CELL__UPDATE;
if (!strcmp(str_par, "RLC_ACC_TYPE_MM")) return RLC__ACC__TYPE__MM;
}
return UNKNOWN_VALUE;
}

boolean RlcAccessType::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
return TRUE;
default:
return FALSE;
}
}

int RlcAccessType::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int RlcAccessType::enum2int(const RlcAccessType& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void RlcAccessType::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.", int_val);
enum_value = (enum_type)int_val;
}

RlcAccessType::operator RlcAccessType::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
return enum_value;
}

void RlcAccessType::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void RlcAccessType::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@RLCMAC_CSN1_Types.RlcAccessType");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @RLCMAC_CSN1_Types.RlcAccessType.");
  }
}

void RlcAccessType::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
text_buf.push_int(enum_value);
}

void RlcAccessType::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @RLCMAC_CSN1_Types.RlcAccessType.", enum_value);
}

void RlcAccessType::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RlcAccessType::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RlcAccessType::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 3, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int RlcAccessType::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 3);
}

void RlcAccessType_template::copy_template(const RlcAccessType_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RlcAccessType_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RlcAccessType_template(*other_value.implication_.precondition);
implication_.implied_template = new RlcAccessType_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
}
}

RlcAccessType_template::RlcAccessType_template()
{
}

RlcAccessType_template::RlcAccessType_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RlcAccessType_template::RlcAccessType_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!RlcAccessType::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType with unknown numeric value %d.", other_value);
single_value = (RlcAccessType::enum_type)other_value;
}

RlcAccessType_template::RlcAccessType_template(RlcAccessType::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

RlcAccessType_template::RlcAccessType_template(const RlcAccessType& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == RlcAccessType::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
single_value = other_value.enum_value;
}

RlcAccessType_template::RlcAccessType_template(const OPTIONAL<RlcAccessType>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RlcAccessType::enum_type)(const RlcAccessType&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType from an unbound optional field.");
}
}

RlcAccessType_template::RlcAccessType_template(RlcAccessType_template* p_precondition, RlcAccessType_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RlcAccessType_template::RlcAccessType_template(Dynamic_Match_Interface<RlcAccessType>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RlcAccessType>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RlcAccessType_template::RlcAccessType_template(const RlcAccessType_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

RlcAccessType_template::~RlcAccessType_template()
{
clean_up();
}

boolean RlcAccessType_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean RlcAccessType_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != RlcAccessType::UNBOUND_VALUE;
}

void RlcAccessType_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RlcAccessType_template& RlcAccessType_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RlcAccessType_template& RlcAccessType_template::operator=(int other_value)
{
if (!RlcAccessType::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (RlcAccessType::enum_type)other_value;
return *this;
}

RlcAccessType_template& RlcAccessType_template::operator=(RlcAccessType::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

RlcAccessType_template& RlcAccessType_template::operator=(const RlcAccessType& other_value)
{
if (other_value.enum_value == RlcAccessType::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RLCMAC_CSN1_Types.RlcAccessType to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

RlcAccessType_template& RlcAccessType_template::operator=(const OPTIONAL<RlcAccessType>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RlcAccessType::enum_type)(const RlcAccessType&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
}
return *this;
}

RlcAccessType_template& RlcAccessType_template::operator=(const RlcAccessType_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RlcAccessType_template::match(RlcAccessType::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
}
return FALSE;
}

boolean RlcAccessType_template::match(const RlcAccessType& other_value, boolean) const
{
if (other_value.enum_value == RlcAccessType::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType with an unbound value.");
return match(other_value.enum_value);
}

RlcAccessType::enum_type RlcAccessType_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
return single_value;
}

void RlcAccessType_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RlcAccessType_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
}
}

RlcAccessType_template& RlcAccessType_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
return value_list.list_value[list_index];
}

void RlcAccessType_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(RlcAccessType::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RlcAccessType_template::log_match(const RlcAccessType& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void RlcAccessType_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
}
}

void RlcAccessType_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (RlcAccessType::enum_type)text_buf.pull_int().get_val();
if (!RlcAccessType::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RlcAccessType_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @RLCMAC_CSN1_Types.RlcAccessType.");
}
}

boolean RlcAccessType_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RlcAccessType_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RlcAccessType_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RlcAccessType_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    RlcAccessType::enum_type enum_val = RlcAccessType::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!RlcAccessType::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @RLCMAC_CSN1_Types.RlcAccessType.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    RlcAccessType_template* precondition = new RlcAccessType_template;
    precondition->set_param(*m_p->get_elem(0));
    RlcAccessType_template* implied_template = new RlcAccessType_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RlcAccessType_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@RLCMAC_CSN1_Types.RlcAccessType");
  }
  is_ifpresent = param.get_ifpresent();
}

void RlcAccessType_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.RlcAccessType");
}

void PacketResourceReqID::copy_value(const PacketResourceReqID& other_value)
{
switch (other_value.union_selection) {
case ALT_gtfi:
field_gtfi = new GlobalTfi(*other_value.field_gtfi);
break;
case ALT_tlli:
field_tlli = new OCTETSTRING(*other_value.field_tlli);
break;
default:
TTCN_error("Assignment of an unbound union value of type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
union_selection = other_value.union_selection;
}

PacketResourceReqID::PacketResourceReqID()
{
union_selection = UNBOUND_VALUE;
}

PacketResourceReqID::PacketResourceReqID(const PacketResourceReqID& other_value)
: Base_Type(){
copy_value(other_value);
}

PacketResourceReqID::~PacketResourceReqID()
{
clean_up();
}

PacketResourceReqID& PacketResourceReqID::operator=(const PacketResourceReqID& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean PacketResourceReqID::operator==(const PacketResourceReqID& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_gtfi:
return *field_gtfi == *other_value.field_gtfi;
case ALT_tlli:
return *field_tlli == *other_value.field_tlli;
default:
return FALSE;
}
}

GlobalTfi& PacketResourceReqID::gtfi()
{
if (union_selection != ALT_gtfi) {
clean_up();
field_gtfi = new GlobalTfi;
union_selection = ALT_gtfi;
}
return *field_gtfi;
}

const GlobalTfi& PacketResourceReqID::gtfi() const
{
if (union_selection != ALT_gtfi) TTCN_error("Using non-selected field gtfi in a value of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
return *field_gtfi;
}

OCTETSTRING& PacketResourceReqID::tlli()
{
if (union_selection != ALT_tlli) {
clean_up();
field_tlli = new OCTETSTRING;
union_selection = ALT_tlli;
}
return *field_tlli;
}

const OCTETSTRING& PacketResourceReqID::tlli() const
{
if (union_selection != ALT_tlli) TTCN_error("Using non-selected field tlli in a value of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
return *field_tlli;
}

boolean PacketResourceReqID::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
return union_selection == checked_selection;
}

boolean PacketResourceReqID::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean PacketResourceReqID::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_gtfi: return field_gtfi->is_value();
case ALT_tlli: return field_tlli->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void PacketResourceReqID::clean_up()
{
switch (union_selection) {
case ALT_gtfi:
  delete field_gtfi;
  break;
case ALT_tlli:
  delete field_tlli;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void PacketResourceReqID::log() const
{
switch (union_selection) {
case ALT_gtfi:
TTCN_Logger::log_event_str("{ gtfi := ");
field_gtfi->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_tlli:
TTCN_Logger::log_event_str("{ tlli := ");
field_tlli->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void PacketResourceReqID::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "gtfi")) {
    gtfi().set_param(*mp_last);
    if (!gtfi().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "tlli")) {
    tlli().set_param(*mp_last);
    if (!tlli().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @RLCMAC_CSN1_Types.PacketResourceReqID.", last_name);
}

void PacketResourceReqID::set_implicit_omit()
{
switch (union_selection) {
case ALT_gtfi:
field_gtfi->set_implicit_omit(); break;
case ALT_tlli:
field_tlli->set_implicit_omit(); break;
default: break;
}
}

void PacketResourceReqID::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_gtfi:
field_gtfi->encode_text(text_buf);
break;
case ALT_tlli:
field_tlli->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
}

void PacketResourceReqID::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_gtfi:
gtfi().decode_text(text_buf);
break;
case ALT_tlli:
tlli().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
}

void PacketResourceReqID::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PacketResourceReqID::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PacketResourceReqID::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, PacketResourceReqID_gtfi_descr_.raw->forceomit);
      decoded_length = gtfi().RAW_decode(PacketResourceReqID_gtfi_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, PacketResourceReqID_tlli_descr_.raw->forceomit);
      decoded_length = tlli().RAW_decode(PacketResourceReqID_tlli_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, PacketResourceReqID_gtfi_descr_.raw->forceomit);
      decoded_length = gtfi().RAW_decode(PacketResourceReqID_gtfi_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_1_force_omit(1, force_omit, PacketResourceReqID_tlli_descr_.raw->forceomit);
      decoded_length = tlli().RAW_decode(PacketResourceReqID_tlli_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_1_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int PacketResourceReqID::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  memset(myleaf.body.node.nodes, 0, 2 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_gtfi:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, PacketResourceReqID_gtfi_descr_.raw);
    encoded_length = field_gtfi->RAW_encode(PacketResourceReqID_gtfi_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &PacketResourceReqID_gtfi_descr_;
    break;
  case ALT_tlli:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, PacketResourceReqID_tlli_descr_.raw);
    encoded_length = field_tlli->RAW_encode(PacketResourceReqID_tlli_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &PacketResourceReqID_tlli_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void PacketResourceReqID_template::copy_value(const PacketResourceReqID& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case PacketResourceReqID::ALT_gtfi:
single_value.field_gtfi = new GlobalTfi_template(other_value.gtfi());
break;
case PacketResourceReqID::ALT_tlli:
single_value.field_tlli = new OCTETSTRING_template(other_value.tlli());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
set_selection(SPECIFIC_VALUE);
}

void PacketResourceReqID_template::copy_template(const PacketResourceReqID_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case PacketResourceReqID::ALT_gtfi:
single_value.field_gtfi = new GlobalTfi_template(*other_value.single_value.field_gtfi);
break;
case PacketResourceReqID::ALT_tlli:
single_value.field_tlli = new OCTETSTRING_template(*other_value.single_value.field_tlli);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PacketResourceReqID_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PacketResourceReqID_template(*other_value.implication_.precondition);
implication_.implied_template = new PacketResourceReqID_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
set_selection(other_value);
}

PacketResourceReqID_template::PacketResourceReqID_template()
{
}

PacketResourceReqID_template::PacketResourceReqID_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PacketResourceReqID_template::PacketResourceReqID_template(const PacketResourceReqID& other_value)
{
copy_value(other_value);
}

PacketResourceReqID_template::PacketResourceReqID_template(const OPTIONAL<PacketResourceReqID>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketResourceReqID&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID from an unbound optional field.");
}
}

PacketResourceReqID_template::PacketResourceReqID_template(PacketResourceReqID_template* p_precondition, PacketResourceReqID_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PacketResourceReqID_template::PacketResourceReqID_template(Dynamic_Match_Interface<PacketResourceReqID>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PacketResourceReqID>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PacketResourceReqID_template::PacketResourceReqID_template(const PacketResourceReqID_template& other_value)
: Base_Template(){
copy_template(other_value);
}

PacketResourceReqID_template::~PacketResourceReqID_template()
{
clean_up();
}

void PacketResourceReqID_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case PacketResourceReqID::ALT_gtfi:
delete single_value.field_gtfi;
break;
case PacketResourceReqID::ALT_tlli:
delete single_value.field_tlli;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PacketResourceReqID_template& PacketResourceReqID_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PacketResourceReqID_template& PacketResourceReqID_template::operator=(const PacketResourceReqID& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PacketResourceReqID_template& PacketResourceReqID_template::operator=(const OPTIONAL<PacketResourceReqID>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketResourceReqID&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
return *this;
}

PacketResourceReqID_template& PacketResourceReqID_template::operator=(const PacketResourceReqID_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PacketResourceReqID_template::match(const PacketResourceReqID& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
PacketResourceReqID::union_selection_type value_selection = other_value.get_selection();
if (value_selection == PacketResourceReqID::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case PacketResourceReqID::ALT_gtfi:
return single_value.field_gtfi->match(other_value.gtfi(), legacy);
case PacketResourceReqID::ALT_tlli:
return single_value.field_tlli->match(other_value.tlli(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
return FALSE;
}

boolean PacketResourceReqID_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case PacketResourceReqID::ALT_gtfi:
return single_value.field_gtfi->is_value();
case PacketResourceReqID::ALT_tlli:
return single_value.field_tlli->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
}

PacketResourceReqID PacketResourceReqID_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
PacketResourceReqID ret_val;
switch (single_value.union_selection) {
case PacketResourceReqID::ALT_gtfi:
ret_val.gtfi() = single_value.field_gtfi->valueof();
break;
case PacketResourceReqID::ALT_tlli:
ret_val.tlli() = single_value.field_tlli->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
return ret_val;
}

PacketResourceReqID_template& PacketResourceReqID_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
return value_list.list_value[list_index];
}
void PacketResourceReqID_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PacketResourceReqID_template[list_length];
}

GlobalTfi_template& PacketResourceReqID_template::gtfi()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PacketResourceReqID::ALT_gtfi) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_gtfi = new GlobalTfi_template(ANY_VALUE);
else single_value.field_gtfi = new GlobalTfi_template;
single_value.union_selection = PacketResourceReqID::ALT_gtfi;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_gtfi;
}

const GlobalTfi_template& PacketResourceReqID_template::gtfi() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field gtfi in a non-specific template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
if (single_value.union_selection != PacketResourceReqID::ALT_gtfi) TTCN_error("Accessing non-selected field gtfi in a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
return *single_value.field_gtfi;
}

OCTETSTRING_template& PacketResourceReqID_template::tlli()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PacketResourceReqID::ALT_tlli) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_tlli = new OCTETSTRING_template(ANY_VALUE);
else single_value.field_tlli = new OCTETSTRING_template;
single_value.union_selection = PacketResourceReqID::ALT_tlli;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_tlli;
}

const OCTETSTRING_template& PacketResourceReqID_template::tlli() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field tlli in a non-specific template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
if (single_value.union_selection != PacketResourceReqID::ALT_tlli) TTCN_error("Accessing non-selected field tlli in a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
return *single_value.field_tlli;
}

boolean PacketResourceReqID_template::ischosen(PacketResourceReqID::union_selection_type checked_selection) const
{
if (checked_selection == PacketResourceReqID::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == PacketResourceReqID::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void PacketResourceReqID_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case PacketResourceReqID::ALT_gtfi:
TTCN_Logger::log_event_str("{ gtfi := ");
single_value.field_gtfi->log();
TTCN_Logger::log_event_str(" }");
break;
case PacketResourceReqID::ALT_tlli:
TTCN_Logger::log_event_str("{ tlli := ");
single_value.field_tlli->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PacketResourceReqID_template::log_match(const PacketResourceReqID& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case PacketResourceReqID::ALT_gtfi:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".gtfi");
single_value.field_gtfi->log_match(match_value.gtfi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ gtfi := ");
single_value.field_gtfi->log_match(match_value.gtfi(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PacketResourceReqID::ALT_tlli:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".tlli");
single_value.field_tlli->log_match(match_value.tlli(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ tlli := ");
single_value.field_tlli->log_match(match_value.tlli(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PacketResourceReqID_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case PacketResourceReqID::ALT_gtfi:
single_value.field_gtfi->set_implicit_omit(); break;
case PacketResourceReqID::ALT_tlli:
single_value.field_tlli->set_implicit_omit(); break;
default: break;
}
}

void PacketResourceReqID_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case PacketResourceReqID::ALT_gtfi:
single_value.field_gtfi->encode_text(text_buf);
break;
case PacketResourceReqID::ALT_tlli:
single_value.field_tlli->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
}

void PacketResourceReqID_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = PacketResourceReqID::UNBOUND_VALUE;
PacketResourceReqID::union_selection_type new_selection = (PacketResourceReqID::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case PacketResourceReqID::ALT_gtfi:
single_value.field_gtfi = new GlobalTfi_template;
single_value.field_gtfi->decode_text(text_buf);
break;
case PacketResourceReqID::ALT_tlli:
single_value.field_tlli = new OCTETSTRING_template;
single_value.field_tlli->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PacketResourceReqID_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
}

boolean PacketResourceReqID_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PacketResourceReqID_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PacketResourceReqID_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@RLCMAC_CSN1_Types.PacketResourceReqID'");
    }
    if (strcmp("gtfi", param_field) == 0) {
      gtfi().set_param(param);
      return;
    } else if (strcmp("tlli", param_field) == 0) {
      tlli().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@RLCMAC_CSN1_Types.PacketResourceReqID'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PacketResourceReqID_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@RLCMAC_CSN1_Types.PacketResourceReqID");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "gtfi")) {
      gtfi().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "tlli")) {
      tlli().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @RLCMAC_CSN1_Types.PacketResourceReqID.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    PacketResourceReqID_template* precondition = new PacketResourceReqID_template;
    precondition->set_param(*m_p->get_elem(0));
    PacketResourceReqID_template* implied_template = new PacketResourceReqID_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = PacketResourceReqID_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@RLCMAC_CSN1_Types.PacketResourceReqID");
  }
  is_ifpresent = param.get_ifpresent();
}

void PacketResourceReqID_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case PacketResourceReqID::ALT_gtfi:
single_value.field_gtfi->check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketResourceReqID");
return;
case PacketResourceReqID::ALT_tlli:
single_value.field_tlli->check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketResourceReqID");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @RLCMAC_CSN1_Types.PacketResourceReqID.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.PacketResourceReqID");
}

PacketResourceReq::PacketResourceReq()
{
}

PacketResourceReq::PacketResourceReq(const BITSTRING& par_acc__type__presence,
    const OPTIONAL< RlcAccessType >& par_acc__type,
    const BITSTRING& par_id__type,
    const PacketResourceReqID& par_id,
    const BITSTRING& par_ms__rac2__presence,
    const OPTIONAL< MSRadioAccCap2 >& par_ms__rac2,
    const ChannelReqDescription& par_ch__req__desc,
    const BITSTRING& par_change__mark__presence,
    const OPTIONAL< BITSTRING >& par_change__mark,
    const BITSTRING& par_C__val,
    const BITSTRING& par_sign__var__presence,
    const OPTIONAL< BITSTRING >& par_sign__var,
    const ILevels& par_I__levels)
  :   field_acc__type__presence(par_acc__type__presence),
  field_acc__type(par_acc__type),
  field_id__type(par_id__type),
  field_id(par_id),
  field_ms__rac2__presence(par_ms__rac2__presence),
  field_ms__rac2(par_ms__rac2),
  field_ch__req__desc(par_ch__req__desc),
  field_change__mark__presence(par_change__mark__presence),
  field_change__mark(par_change__mark),
  field_C__val(par_C__val),
  field_sign__var__presence(par_sign__var__presence),
  field_sign__var(par_sign__var),
  field_I__levels(par_I__levels)
{
}

PacketResourceReq::PacketResourceReq(const PacketResourceReq& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.PacketResourceReq.");
if (other_value.acc__type__presence().is_bound()) field_acc__type__presence = other_value.acc__type__presence();
else field_acc__type__presence.clean_up();
if (other_value.acc__type().is_bound()) field_acc__type = other_value.acc__type();
else field_acc__type.clean_up();
if (other_value.id__type().is_bound()) field_id__type = other_value.id__type();
else field_id__type.clean_up();
if (other_value.id().is_bound()) field_id = other_value.id();
else field_id.clean_up();
if (other_value.ms__rac2__presence().is_bound()) field_ms__rac2__presence = other_value.ms__rac2__presence();
else field_ms__rac2__presence.clean_up();
if (other_value.ms__rac2().is_bound()) field_ms__rac2 = other_value.ms__rac2();
else field_ms__rac2.clean_up();
if (other_value.ch__req__desc().is_bound()) field_ch__req__desc = other_value.ch__req__desc();
else field_ch__req__desc.clean_up();
if (other_value.change__mark__presence().is_bound()) field_change__mark__presence = other_value.change__mark__presence();
else field_change__mark__presence.clean_up();
if (other_value.change__mark().is_bound()) field_change__mark = other_value.change__mark();
else field_change__mark.clean_up();
if (other_value.C__val().is_bound()) field_C__val = other_value.C__val();
else field_C__val.clean_up();
if (other_value.sign__var__presence().is_bound()) field_sign__var__presence = other_value.sign__var__presence();
else field_sign__var__presence.clean_up();
if (other_value.sign__var().is_bound()) field_sign__var = other_value.sign__var();
else field_sign__var.clean_up();
if (other_value.I__levels().is_bound()) field_I__levels = other_value.I__levels();
else field_I__levels.clean_up();
}

void PacketResourceReq::clean_up()
{
field_acc__type__presence.clean_up();
field_acc__type.clean_up();
field_id__type.clean_up();
field_id.clean_up();
field_ms__rac2__presence.clean_up();
field_ms__rac2.clean_up();
field_ch__req__desc.clean_up();
field_change__mark__presence.clean_up();
field_change__mark.clean_up();
field_C__val.clean_up();
field_sign__var__presence.clean_up();
field_sign__var.clean_up();
field_I__levels.clean_up();
}

const TTCN_Typedescriptor_t* PacketResourceReq::get_descriptor() const { return &PacketResourceReq_descr_; }
PacketResourceReq& PacketResourceReq::operator=(const PacketResourceReq& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.PacketResourceReq.");
  if (other_value.acc__type__presence().is_bound()) field_acc__type__presence = other_value.acc__type__presence();
  else field_acc__type__presence.clean_up();
  if (other_value.acc__type().is_bound()) field_acc__type = other_value.acc__type();
  else field_acc__type.clean_up();
  if (other_value.id__type().is_bound()) field_id__type = other_value.id__type();
  else field_id__type.clean_up();
  if (other_value.id().is_bound()) field_id = other_value.id();
  else field_id.clean_up();
  if (other_value.ms__rac2__presence().is_bound()) field_ms__rac2__presence = other_value.ms__rac2__presence();
  else field_ms__rac2__presence.clean_up();
  if (other_value.ms__rac2().is_bound()) field_ms__rac2 = other_value.ms__rac2();
  else field_ms__rac2.clean_up();
  if (other_value.ch__req__desc().is_bound()) field_ch__req__desc = other_value.ch__req__desc();
  else field_ch__req__desc.clean_up();
  if (other_value.change__mark__presence().is_bound()) field_change__mark__presence = other_value.change__mark__presence();
  else field_change__mark__presence.clean_up();
  if (other_value.change__mark().is_bound()) field_change__mark = other_value.change__mark();
  else field_change__mark.clean_up();
  if (other_value.C__val().is_bound()) field_C__val = other_value.C__val();
  else field_C__val.clean_up();
  if (other_value.sign__var__presence().is_bound()) field_sign__var__presence = other_value.sign__var__presence();
  else field_sign__var__presence.clean_up();
  if (other_value.sign__var().is_bound()) field_sign__var = other_value.sign__var();
  else field_sign__var.clean_up();
  if (other_value.I__levels().is_bound()) field_I__levels = other_value.I__levels();
  else field_I__levels.clean_up();
}
return *this;
}

boolean PacketResourceReq::operator==(const PacketResourceReq& other_value) const
{
return field_acc__type__presence==other_value.field_acc__type__presence
  && field_acc__type==other_value.field_acc__type
  && field_id__type==other_value.field_id__type
  && field_id==other_value.field_id
  && field_ms__rac2__presence==other_value.field_ms__rac2__presence
  && field_ms__rac2==other_value.field_ms__rac2
  && field_ch__req__desc==other_value.field_ch__req__desc
  && field_change__mark__presence==other_value.field_change__mark__presence
  && field_change__mark==other_value.field_change__mark
  && field_C__val==other_value.field_C__val
  && field_sign__var__presence==other_value.field_sign__var__presence
  && field_sign__var==other_value.field_sign__var
  && field_I__levels==other_value.field_I__levels;
}

boolean PacketResourceReq::is_bound() const
{
return (field_acc__type__presence.is_bound())
  || (OPTIONAL_OMIT == field_acc__type.get_selection() || field_acc__type.is_bound())
  || (field_id__type.is_bound())
  || (field_id.is_bound())
  || (field_ms__rac2__presence.is_bound())
  || (OPTIONAL_OMIT == field_ms__rac2.get_selection() || field_ms__rac2.is_bound())
  || (field_ch__req__desc.is_bound())
  || (field_change__mark__presence.is_bound())
  || (OPTIONAL_OMIT == field_change__mark.get_selection() || field_change__mark.is_bound())
  || (field_C__val.is_bound())
  || (field_sign__var__presence.is_bound())
  || (OPTIONAL_OMIT == field_sign__var.get_selection() || field_sign__var.is_bound())
  || (field_I__levels.is_bound());
}
boolean PacketResourceReq::is_value() const
{
return field_acc__type__presence.is_value()
  && (OPTIONAL_OMIT == field_acc__type.get_selection() || field_acc__type.is_value())
  && field_id__type.is_value()
  && field_id.is_value()
  && field_ms__rac2__presence.is_value()
  && (OPTIONAL_OMIT == field_ms__rac2.get_selection() || field_ms__rac2.is_value())
  && field_ch__req__desc.is_value()
  && field_change__mark__presence.is_value()
  && (OPTIONAL_OMIT == field_change__mark.get_selection() || field_change__mark.is_value())
  && field_C__val.is_value()
  && field_sign__var__presence.is_value()
  && (OPTIONAL_OMIT == field_sign__var.get_selection() || field_sign__var.is_value())
  && field_I__levels.is_value();
}
int PacketResourceReq::size_of() const
{
  int ret_val = 9;
  if (field_acc__type.ispresent()) ret_val++;
  if (field_ms__rac2.ispresent()) ret_val++;
  if (field_change__mark.ispresent()) ret_val++;
  if (field_sign__var.ispresent()) ret_val++;
  return ret_val;
}

void PacketResourceReq::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ acc_type_presence := ");
field_acc__type__presence.log();
TTCN_Logger::log_event_str(", acc_type := ");
field_acc__type.log();
TTCN_Logger::log_event_str(", id_type := ");
field_id__type.log();
TTCN_Logger::log_event_str(", id := ");
field_id.log();
TTCN_Logger::log_event_str(", ms_rac2_presence := ");
field_ms__rac2__presence.log();
TTCN_Logger::log_event_str(", ms_rac2 := ");
field_ms__rac2.log();
TTCN_Logger::log_event_str(", ch_req_desc := ");
field_ch__req__desc.log();
TTCN_Logger::log_event_str(", change_mark_presence := ");
field_change__mark__presence.log();
TTCN_Logger::log_event_str(", change_mark := ");
field_change__mark.log();
TTCN_Logger::log_event_str(", C_val := ");
field_C__val.log();
TTCN_Logger::log_event_str(", sign_var_presence := ");
field_sign__var__presence.log();
TTCN_Logger::log_event_str(", sign_var := ");
field_sign__var.log();
TTCN_Logger::log_event_str(", I_levels := ");
field_I__levels.log();
TTCN_Logger::log_event_str(" }");
}

void PacketResourceReq::set_implicit_omit()
{
if (acc__type__presence().is_bound()) acc__type__presence().set_implicit_omit();
if (!acc__type().is_bound()) acc__type() = OMIT_VALUE;
else acc__type().set_implicit_omit();
if (id__type().is_bound()) id__type().set_implicit_omit();
if (id().is_bound()) id().set_implicit_omit();
if (ms__rac2__presence().is_bound()) ms__rac2__presence().set_implicit_omit();
if (!ms__rac2().is_bound()) ms__rac2() = OMIT_VALUE;
else ms__rac2().set_implicit_omit();
if (ch__req__desc().is_bound()) ch__req__desc().set_implicit_omit();
if (change__mark__presence().is_bound()) change__mark__presence().set_implicit_omit();
if (!change__mark().is_bound()) change__mark() = OMIT_VALUE;
else change__mark().set_implicit_omit();
if (C__val().is_bound()) C__val().set_implicit_omit();
if (sign__var__presence().is_bound()) sign__var__presence().set_implicit_omit();
if (!sign__var().is_bound()) sign__var() = OMIT_VALUE;
else sign__var().set_implicit_omit();
if (I__levels().is_bound()) I__levels().set_implicit_omit();
}

void PacketResourceReq::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (13<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.PacketResourceReq has 13 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) acc__type__presence().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) acc__type().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) id__type().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) id().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) ms__rac2__presence().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) ms__rac2().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) ch__req__desc().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) change__mark__presence().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) change__mark().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) C__val().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) sign__var__presence().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) sign__var().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) I__levels().set_param(*param.get_elem(12));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "acc_type_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          acc__type__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "acc_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          acc__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "id_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          id__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ms_rac2_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ms__rac2__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ms_rac2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ms__rac2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ch_req_desc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ch__req__desc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "change_mark_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          change__mark__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "change_mark")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          change__mark().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "C_val")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          C__val().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sign_var_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sign__var__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sign_var")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sign__var().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "I_levels")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          I__levels().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.PacketResourceReq: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.PacketResourceReq");
  }
}

void PacketResourceReq::encode_text(Text_Buf& text_buf) const
{
field_acc__type__presence.encode_text(text_buf);
field_acc__type.encode_text(text_buf);
field_id__type.encode_text(text_buf);
field_id.encode_text(text_buf);
field_ms__rac2__presence.encode_text(text_buf);
field_ms__rac2.encode_text(text_buf);
field_ch__req__desc.encode_text(text_buf);
field_change__mark__presence.encode_text(text_buf);
field_change__mark.encode_text(text_buf);
field_C__val.encode_text(text_buf);
field_sign__var__presence.encode_text(text_buf);
field_sign__var.encode_text(text_buf);
field_I__levels.encode_text(text_buf);
}

void PacketResourceReq::decode_text(Text_Buf& text_buf)
{
field_acc__type__presence.decode_text(text_buf);
field_acc__type.decode_text(text_buf);
field_id__type.decode_text(text_buf);
field_id.decode_text(text_buf);
field_ms__rac2__presence.decode_text(text_buf);
field_ms__rac2.decode_text(text_buf);
field_ch__req__desc.decode_text(text_buf);
field_change__mark__presence.decode_text(text_buf);
field_change__mark.decode_text(text_buf);
field_C__val.decode_text(text_buf);
field_sign__var__presence.decode_text(text_buf);
field_sign__var.decode_text(text_buf);
field_I__levels.decode_text(text_buf);
}

void PacketResourceReq::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PacketResourceReq::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PacketResourceReq::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, PacketResourceReq_acc__type__presence_descr_.raw->forceomit);
  decoded_field_length = field_acc__type__presence.RAW_decode(PacketResourceReq_acc__type__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_acc__type__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_acc__type = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, PacketResourceReq_acc__type_descr_.raw->forceomit);
  decoded_field_length = field_acc__type().RAW_decode(PacketResourceReq_acc__type_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_acc__type = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_acc__type=OMIT_VALUE;
  RAW_Force_Omit field_2_force_omit(2, force_omit, PacketResourceReq_id__type_descr_.raw->forceomit);
  decoded_field_length = field_id__type.RAW_decode(PacketResourceReq_id__type_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_id__type ==  bs_1) selected_field = 0;
  else if (field_id__type ==  bs_0) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_3_force_omit(3, force_omit, PacketResourceReq_id_descr_.raw->forceomit);
  decoded_field_length = field_id.RAW_decode(PacketResourceReq_id_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, PacketResourceReq_ms__rac2__presence_descr_.raw->forceomit);
  decoded_field_length = field_ms__rac2__presence.RAW_decode(PacketResourceReq_ms__rac2__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_ms__rac2__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_ms__rac2 = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, PacketResourceReq_ms__rac2_descr_.raw->forceomit);
  decoded_field_length = field_ms__rac2().RAW_decode(PacketResourceReq_ms__rac2_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_ms__rac2 = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_ms__rac2=OMIT_VALUE;
  RAW_Force_Omit field_6_force_omit(6, force_omit, PacketResourceReq_ch__req__desc_descr_.raw->forceomit);
  decoded_field_length = field_ch__req__desc.RAW_decode(PacketResourceReq_ch__req__desc_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_7_force_omit(7, force_omit, PacketResourceReq_change__mark__presence_descr_.raw->forceomit);
  decoded_field_length = field_change__mark__presence.RAW_decode(PacketResourceReq_change__mark__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_change__mark__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(8)) {
    field_change__mark = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_8_force_omit(8, force_omit, PacketResourceReq_change__mark_descr_.raw->forceomit);
  decoded_field_length = field_change__mark().RAW_decode(PacketResourceReq_change__mark_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 1) {
  field_change__mark = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_change__mark=OMIT_VALUE;
  RAW_Force_Omit field_9_force_omit(9, force_omit, PacketResourceReq_C__val_descr_.raw->forceomit);
  decoded_field_length = field_C__val.RAW_decode(PacketResourceReq_C__val_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_9_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_10_force_omit(10, force_omit, PacketResourceReq_sign__var__presence_descr_.raw->forceomit);
  decoded_field_length = field_sign__var__presence.RAW_decode(PacketResourceReq_sign__var__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_10_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_sign__var__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(11)) {
    field_sign__var = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_11_force_omit(11, force_omit, PacketResourceReq_sign__var_descr_.raw->forceomit);
  decoded_field_length = field_sign__var().RAW_decode(PacketResourceReq_sign__var_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_11_force_omit);
  if (decoded_field_length < 1) {
  field_sign__var = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_sign__var=OMIT_VALUE;
  RAW_Force_Omit field_12_force_omit(12, force_omit, PacketResourceReq_I__levels_descr_.raw->forceomit);
  decoded_field_length = field_I__levels.RAW_decode(PacketResourceReq_I__levels_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_12_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PacketResourceReq::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 13;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(13);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, PacketResourceReq_acc__type__presence_descr_.raw);
  if (field_acc__type.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, PacketResourceReq_acc__type_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, PacketResourceReq_id__type_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, PacketResourceReq_id_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, PacketResourceReq_ms__rac2__presence_descr_.raw);
  if (field_ms__rac2.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, PacketResourceReq_ms__rac2_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, PacketResourceReq_ch__req__desc_descr_.raw);
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, PacketResourceReq_change__mark__presence_descr_.raw);
  if (field_change__mark.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, PacketResourceReq_change__mark_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 9, PacketResourceReq_C__val_descr_.raw);
  myleaf.body.node.nodes[10] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 10, PacketResourceReq_sign__var__presence_descr_.raw);
  if (field_sign__var.ispresent()) {
  myleaf.body.node.nodes[11] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 11, PacketResourceReq_sign__var_descr_.raw);
  }
  else myleaf.body.node.nodes[11] = NULL;
  myleaf.body.node.nodes[12] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 12, PacketResourceReq_I__levels_descr_.raw);
  encoded_length += field_acc__type__presence.RAW_encode(PacketResourceReq_acc__type__presence_descr_, *myleaf.body.node.nodes[0]);
  if (field_acc__type.ispresent()) {
  encoded_length += field_acc__type().RAW_encode(PacketResourceReq_acc__type_descr_, *myleaf.body.node.nodes[1]);
  }
  encoded_length += field_id__type.RAW_encode(PacketResourceReq_id__type_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_id.RAW_encode(PacketResourceReq_id_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_ms__rac2__presence.RAW_encode(PacketResourceReq_ms__rac2__presence_descr_, *myleaf.body.node.nodes[4]);
  if (field_ms__rac2.ispresent()) {
  encoded_length += field_ms__rac2().RAW_encode(PacketResourceReq_ms__rac2_descr_, *myleaf.body.node.nodes[5]);
  }
  encoded_length += field_ch__req__desc.RAW_encode(PacketResourceReq_ch__req__desc_descr_, *myleaf.body.node.nodes[6]);
  encoded_length += field_change__mark__presence.RAW_encode(PacketResourceReq_change__mark__presence_descr_, *myleaf.body.node.nodes[7]);
  if (field_change__mark.ispresent()) {
  encoded_length += field_change__mark().RAW_encode(PacketResourceReq_change__mark_descr_, *myleaf.body.node.nodes[8]);
  }
  encoded_length += field_C__val.RAW_encode(PacketResourceReq_C__val_descr_, *myleaf.body.node.nodes[9]);
  encoded_length += field_sign__var__presence.RAW_encode(PacketResourceReq_sign__var__presence_descr_, *myleaf.body.node.nodes[10]);
  if (field_sign__var.ispresent()) {
  encoded_length += field_sign__var().RAW_encode(PacketResourceReq_sign__var_descr_, *myleaf.body.node.nodes[11]);
  }
  encoded_length += field_I__levels.RAW_encode(PacketResourceReq_I__levels_descr_, *myleaf.body.node.nodes[12]);
  if (field_acc__type.ispresent() && (field_acc__type__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(PacketResourceReq_acc__type__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  switch (field_id.get_selection()) {
  case PacketResourceReqID::ALT_gtfi:
  if (field_id__type !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(PacketResourceReq_id__type_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case PacketResourceReqID::ALT_tlli:
  if (field_id__type !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 2 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(PacketResourceReq_id__type_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_ms__rac2.ispresent() && (field_ms__rac2__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={4};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(PacketResourceReq_ms__rac2__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_change__mark.ispresent() && (field_change__mark__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={7};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(PacketResourceReq_change__mark__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_sign__var.ispresent() && (field_sign__var__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={10};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(PacketResourceReq_sign__var__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PacketResourceReq_template::single_value_struct {
BITSTRING_template field_acc__type__presence;
RlcAccessType_template field_acc__type;
BITSTRING_template field_id__type;
PacketResourceReqID_template field_id;
BITSTRING_template field_ms__rac2__presence;
MSRadioAccCap2_template field_ms__rac2;
ChannelReqDescription_template field_ch__req__desc;
BITSTRING_template field_change__mark__presence;
BITSTRING_template field_change__mark;
BITSTRING_template field_C__val;
BITSTRING_template field_sign__var__presence;
BITSTRING_template field_sign__var;
ILevels_template field_I__levels;
};

void PacketResourceReq_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_acc__type__presence = ANY_VALUE;
single_value->field_acc__type = ANY_OR_OMIT;
single_value->field_id__type = ANY_VALUE;
single_value->field_id = ANY_VALUE;
single_value->field_ms__rac2__presence = ANY_VALUE;
single_value->field_ms__rac2 = ANY_OR_OMIT;
single_value->field_ch__req__desc = ANY_VALUE;
single_value->field_change__mark__presence = ANY_VALUE;
single_value->field_change__mark = ANY_OR_OMIT;
single_value->field_C__val = ANY_VALUE;
single_value->field_sign__var__presence = ANY_VALUE;
single_value->field_sign__var = ANY_OR_OMIT;
single_value->field_I__levels = ANY_VALUE;
}
}
}

void PacketResourceReq_template::copy_value(const PacketResourceReq& other_value)
{
single_value = new single_value_struct;
if (other_value.acc__type__presence().is_bound()) {
  single_value->field_acc__type__presence = other_value.acc__type__presence();
} else {
  single_value->field_acc__type__presence.clean_up();
}
if (other_value.acc__type().is_bound()) {
  if (other_value.acc__type().ispresent()) single_value->field_acc__type = other_value.acc__type()();
  else single_value->field_acc__type = OMIT_VALUE;
} else {
  single_value->field_acc__type.clean_up();
}
if (other_value.id__type().is_bound()) {
  single_value->field_id__type = other_value.id__type();
} else {
  single_value->field_id__type.clean_up();
}
if (other_value.id().is_bound()) {
  single_value->field_id = other_value.id();
} else {
  single_value->field_id.clean_up();
}
if (other_value.ms__rac2__presence().is_bound()) {
  single_value->field_ms__rac2__presence = other_value.ms__rac2__presence();
} else {
  single_value->field_ms__rac2__presence.clean_up();
}
if (other_value.ms__rac2().is_bound()) {
  if (other_value.ms__rac2().ispresent()) single_value->field_ms__rac2 = other_value.ms__rac2()();
  else single_value->field_ms__rac2 = OMIT_VALUE;
} else {
  single_value->field_ms__rac2.clean_up();
}
if (other_value.ch__req__desc().is_bound()) {
  single_value->field_ch__req__desc = other_value.ch__req__desc();
} else {
  single_value->field_ch__req__desc.clean_up();
}
if (other_value.change__mark__presence().is_bound()) {
  single_value->field_change__mark__presence = other_value.change__mark__presence();
} else {
  single_value->field_change__mark__presence.clean_up();
}
if (other_value.change__mark().is_bound()) {
  if (other_value.change__mark().ispresent()) single_value->field_change__mark = other_value.change__mark()();
  else single_value->field_change__mark = OMIT_VALUE;
} else {
  single_value->field_change__mark.clean_up();
}
if (other_value.C__val().is_bound()) {
  single_value->field_C__val = other_value.C__val();
} else {
  single_value->field_C__val.clean_up();
}
if (other_value.sign__var__presence().is_bound()) {
  single_value->field_sign__var__presence = other_value.sign__var__presence();
} else {
  single_value->field_sign__var__presence.clean_up();
}
if (other_value.sign__var().is_bound()) {
  if (other_value.sign__var().ispresent()) single_value->field_sign__var = other_value.sign__var()();
  else single_value->field_sign__var = OMIT_VALUE;
} else {
  single_value->field_sign__var.clean_up();
}
if (other_value.I__levels().is_bound()) {
  single_value->field_I__levels = other_value.I__levels();
} else {
  single_value->field_I__levels.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PacketResourceReq_template::copy_template(const PacketResourceReq_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.acc__type__presence().get_selection()) {
single_value->field_acc__type__presence = other_value.acc__type__presence();
} else {
single_value->field_acc__type__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.acc__type().get_selection()) {
single_value->field_acc__type = other_value.acc__type();
} else {
single_value->field_acc__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.id__type().get_selection()) {
single_value->field_id__type = other_value.id__type();
} else {
single_value->field_id__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.id().get_selection()) {
single_value->field_id = other_value.id();
} else {
single_value->field_id.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ms__rac2__presence().get_selection()) {
single_value->field_ms__rac2__presence = other_value.ms__rac2__presence();
} else {
single_value->field_ms__rac2__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ms__rac2().get_selection()) {
single_value->field_ms__rac2 = other_value.ms__rac2();
} else {
single_value->field_ms__rac2.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ch__req__desc().get_selection()) {
single_value->field_ch__req__desc = other_value.ch__req__desc();
} else {
single_value->field_ch__req__desc.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.change__mark__presence().get_selection()) {
single_value->field_change__mark__presence = other_value.change__mark__presence();
} else {
single_value->field_change__mark__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.change__mark().get_selection()) {
single_value->field_change__mark = other_value.change__mark();
} else {
single_value->field_change__mark.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.C__val().get_selection()) {
single_value->field_C__val = other_value.C__val();
} else {
single_value->field_C__val.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sign__var__presence().get_selection()) {
single_value->field_sign__var__presence = other_value.sign__var__presence();
} else {
single_value->field_sign__var__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sign__var().get_selection()) {
single_value->field_sign__var = other_value.sign__var();
} else {
single_value->field_sign__var.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.I__levels().get_selection()) {
single_value->field_I__levels = other_value.I__levels();
} else {
single_value->field_I__levels.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PacketResourceReq_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PacketResourceReq_template(*other_value.implication_.precondition);
implication_.implied_template = new PacketResourceReq_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
break;
}
set_selection(other_value);
}

PacketResourceReq_template::PacketResourceReq_template()
{
}

PacketResourceReq_template::PacketResourceReq_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PacketResourceReq_template::PacketResourceReq_template(const PacketResourceReq& other_value)
{
copy_value(other_value);
}

PacketResourceReq_template::PacketResourceReq_template(const OPTIONAL<PacketResourceReq>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketResourceReq&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.PacketResourceReq from an unbound optional field.");
}
}

PacketResourceReq_template::PacketResourceReq_template(PacketResourceReq_template* p_precondition, PacketResourceReq_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PacketResourceReq_template::PacketResourceReq_template(Dynamic_Match_Interface<PacketResourceReq>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PacketResourceReq>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PacketResourceReq_template::PacketResourceReq_template(const PacketResourceReq_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PacketResourceReq_template::~PacketResourceReq_template()
{
clean_up();
}

PacketResourceReq_template& PacketResourceReq_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PacketResourceReq_template& PacketResourceReq_template::operator=(const PacketResourceReq& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PacketResourceReq_template& PacketResourceReq_template::operator=(const OPTIONAL<PacketResourceReq>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PacketResourceReq&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
}
return *this;
}

PacketResourceReq_template& PacketResourceReq_template::operator=(const PacketResourceReq_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PacketResourceReq_template::match(const PacketResourceReq& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.acc__type__presence().is_bound()) return FALSE;
if(!single_value->field_acc__type__presence.match(other_value.acc__type__presence(), legacy))return FALSE;
if(!other_value.acc__type().is_bound()) return FALSE;
if((other_value.acc__type().ispresent() ? !single_value->field_acc__type.match((const RlcAccessType&)other_value.acc__type(), legacy) : !single_value->field_acc__type.match_omit(legacy)))return FALSE;
if(!other_value.id__type().is_bound()) return FALSE;
if(!single_value->field_id__type.match(other_value.id__type(), legacy))return FALSE;
if(!other_value.id().is_bound()) return FALSE;
if(!single_value->field_id.match(other_value.id(), legacy))return FALSE;
if(!other_value.ms__rac2__presence().is_bound()) return FALSE;
if(!single_value->field_ms__rac2__presence.match(other_value.ms__rac2__presence(), legacy))return FALSE;
if(!other_value.ms__rac2().is_bound()) return FALSE;
if((other_value.ms__rac2().ispresent() ? !single_value->field_ms__rac2.match((const MSRadioAccCap2&)other_value.ms__rac2(), legacy) : !single_value->field_ms__rac2.match_omit(legacy)))return FALSE;
if(!other_value.ch__req__desc().is_bound()) return FALSE;
if(!single_value->field_ch__req__desc.match(other_value.ch__req__desc(), legacy))return FALSE;
if(!other_value.change__mark__presence().is_bound()) return FALSE;
if(!single_value->field_change__mark__presence.match(other_value.change__mark__presence(), legacy))return FALSE;
if(!other_value.change__mark().is_bound()) return FALSE;
if((other_value.change__mark().ispresent() ? !single_value->field_change__mark.match((const BITSTRING&)other_value.change__mark(), legacy) : !single_value->field_change__mark.match_omit(legacy)))return FALSE;
if(!other_value.C__val().is_bound()) return FALSE;
if(!single_value->field_C__val.match(other_value.C__val(), legacy))return FALSE;
if(!other_value.sign__var__presence().is_bound()) return FALSE;
if(!single_value->field_sign__var__presence.match(other_value.sign__var__presence(), legacy))return FALSE;
if(!other_value.sign__var().is_bound()) return FALSE;
if((other_value.sign__var().ispresent() ? !single_value->field_sign__var.match((const BITSTRING&)other_value.sign__var(), legacy) : !single_value->field_sign__var.match_omit(legacy)))return FALSE;
if(!other_value.I__levels().is_bound()) return FALSE;
if(!single_value->field_I__levels.match(other_value.I__levels(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
}
return FALSE;
}

boolean PacketResourceReq_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_acc__type__presence.is_bound()
 || (single_value->field_acc__type.is_omit() || single_value->field_acc__type.is_bound())
 || single_value->field_id__type.is_bound()
 || single_value->field_id.is_bound()
 || single_value->field_ms__rac2__presence.is_bound()
 || (single_value->field_ms__rac2.is_omit() || single_value->field_ms__rac2.is_bound())
 || single_value->field_ch__req__desc.is_bound()
 || single_value->field_change__mark__presence.is_bound()
 || (single_value->field_change__mark.is_omit() || single_value->field_change__mark.is_bound())
 || single_value->field_C__val.is_bound()
 || single_value->field_sign__var__presence.is_bound()
 || (single_value->field_sign__var.is_omit() || single_value->field_sign__var.is_bound())
 || single_value->field_I__levels.is_bound();
}

boolean PacketResourceReq_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_acc__type__presence.is_value()
 && (single_value->field_acc__type.is_omit() || single_value->field_acc__type.is_value())
 && single_value->field_id__type.is_value()
 && single_value->field_id.is_value()
 && single_value->field_ms__rac2__presence.is_value()
 && (single_value->field_ms__rac2.is_omit() || single_value->field_ms__rac2.is_value())
 && single_value->field_ch__req__desc.is_value()
 && single_value->field_change__mark__presence.is_value()
 && (single_value->field_change__mark.is_omit() || single_value->field_change__mark.is_value())
 && single_value->field_C__val.is_value()
 && single_value->field_sign__var__presence.is_value()
 && (single_value->field_sign__var.is_omit() || single_value->field_sign__var.is_value())
 && single_value->field_I__levels.is_value();
}

void PacketResourceReq_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PacketResourceReq PacketResourceReq_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
PacketResourceReq ret_val;
if (single_value->field_acc__type__presence.is_bound()) {
ret_val.acc__type__presence() = single_value->field_acc__type__presence.valueof();
}
if (single_value->field_acc__type.is_omit()) ret_val.acc__type() = OMIT_VALUE;
else if (single_value->field_acc__type.is_bound()) {
ret_val.acc__type() = single_value->field_acc__type.valueof();
}
if (single_value->field_id__type.is_bound()) {
ret_val.id__type() = single_value->field_id__type.valueof();
}
if (single_value->field_id.is_bound()) {
ret_val.id() = single_value->field_id.valueof();
}
if (single_value->field_ms__rac2__presence.is_bound()) {
ret_val.ms__rac2__presence() = single_value->field_ms__rac2__presence.valueof();
}
if (single_value->field_ms__rac2.is_omit()) ret_val.ms__rac2() = OMIT_VALUE;
else if (single_value->field_ms__rac2.is_bound()) {
ret_val.ms__rac2() = single_value->field_ms__rac2.valueof();
}
if (single_value->field_ch__req__desc.is_bound()) {
ret_val.ch__req__desc() = single_value->field_ch__req__desc.valueof();
}
if (single_value->field_change__mark__presence.is_bound()) {
ret_val.change__mark__presence() = single_value->field_change__mark__presence.valueof();
}
if (single_value->field_change__mark.is_omit()) ret_val.change__mark() = OMIT_VALUE;
else if (single_value->field_change__mark.is_bound()) {
ret_val.change__mark() = single_value->field_change__mark.valueof();
}
if (single_value->field_C__val.is_bound()) {
ret_val.C__val() = single_value->field_C__val.valueof();
}
if (single_value->field_sign__var__presence.is_bound()) {
ret_val.sign__var__presence() = single_value->field_sign__var__presence.valueof();
}
if (single_value->field_sign__var.is_omit()) ret_val.sign__var() = OMIT_VALUE;
else if (single_value->field_sign__var.is_bound()) {
ret_val.sign__var() = single_value->field_sign__var.valueof();
}
if (single_value->field_I__levels.is_bound()) {
ret_val.I__levels() = single_value->field_I__levels.valueof();
}
return ret_val;
}

void PacketResourceReq_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PacketResourceReq_template[list_length];
}

PacketResourceReq_template& PacketResourceReq_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return value_list.list_value[list_index];
}

BITSTRING_template& PacketResourceReq_template::acc__type__presence()
{
set_specific();
return single_value->field_acc__type__presence;
}

const BITSTRING_template& PacketResourceReq_template::acc__type__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field acc_type_presence of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_acc__type__presence;
}

RlcAccessType_template& PacketResourceReq_template::acc__type()
{
set_specific();
return single_value->field_acc__type;
}

const RlcAccessType_template& PacketResourceReq_template::acc__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field acc_type of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_acc__type;
}

BITSTRING_template& PacketResourceReq_template::id__type()
{
set_specific();
return single_value->field_id__type;
}

const BITSTRING_template& PacketResourceReq_template::id__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field id_type of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_id__type;
}

PacketResourceReqID_template& PacketResourceReq_template::id()
{
set_specific();
return single_value->field_id;
}

const PacketResourceReqID_template& PacketResourceReq_template::id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field id of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_id;
}

BITSTRING_template& PacketResourceReq_template::ms__rac2__presence()
{
set_specific();
return single_value->field_ms__rac2__presence;
}

const BITSTRING_template& PacketResourceReq_template::ms__rac2__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ms_rac2_presence of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_ms__rac2__presence;
}

MSRadioAccCap2_template& PacketResourceReq_template::ms__rac2()
{
set_specific();
return single_value->field_ms__rac2;
}

const MSRadioAccCap2_template& PacketResourceReq_template::ms__rac2() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ms_rac2 of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_ms__rac2;
}

ChannelReqDescription_template& PacketResourceReq_template::ch__req__desc()
{
set_specific();
return single_value->field_ch__req__desc;
}

const ChannelReqDescription_template& PacketResourceReq_template::ch__req__desc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ch_req_desc of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_ch__req__desc;
}

BITSTRING_template& PacketResourceReq_template::change__mark__presence()
{
set_specific();
return single_value->field_change__mark__presence;
}

const BITSTRING_template& PacketResourceReq_template::change__mark__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field change_mark_presence of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_change__mark__presence;
}

BITSTRING_template& PacketResourceReq_template::change__mark()
{
set_specific();
return single_value->field_change__mark;
}

const BITSTRING_template& PacketResourceReq_template::change__mark() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field change_mark of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_change__mark;
}

BITSTRING_template& PacketResourceReq_template::C__val()
{
set_specific();
return single_value->field_C__val;
}

const BITSTRING_template& PacketResourceReq_template::C__val() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field C_val of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_C__val;
}

BITSTRING_template& PacketResourceReq_template::sign__var__presence()
{
set_specific();
return single_value->field_sign__var__presence;
}

const BITSTRING_template& PacketResourceReq_template::sign__var__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sign_var_presence of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_sign__var__presence;
}

BITSTRING_template& PacketResourceReq_template::sign__var()
{
set_specific();
return single_value->field_sign__var;
}

const BITSTRING_template& PacketResourceReq_template::sign__var() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sign_var of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_sign__var;
}

ILevels_template& PacketResourceReq_template::I__levels()
{
set_specific();
return single_value->field_I__levels;
}

const ILevels_template& PacketResourceReq_template::I__levels() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field I_levels of a non-specific template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
return single_value->field_I__levels;
}

int PacketResourceReq_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketResourceReq which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 9;
      if (single_value->field_acc__type.is_present()) ret_val++;
      if (single_value->field_ms__rac2.is_present()) ret_val++;
      if (single_value->field_change__mark.is_present()) ret_val++;
      if (single_value->field_sign__var.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketResourceReq containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketResourceReq containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketResourceReq containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketResourceReq containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketResourceReq containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketResourceReq containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketResourceReq containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PacketResourceReq containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
  }
  return 0;
}

void PacketResourceReq_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ acc_type_presence := ");
single_value->field_acc__type__presence.log();
TTCN_Logger::log_event_str(", acc_type := ");
single_value->field_acc__type.log();
TTCN_Logger::log_event_str(", id_type := ");
single_value->field_id__type.log();
TTCN_Logger::log_event_str(", id := ");
single_value->field_id.log();
TTCN_Logger::log_event_str(", ms_rac2_presence := ");
single_value->field_ms__rac2__presence.log();
TTCN_Logger::log_event_str(", ms_rac2 := ");
single_value->field_ms__rac2.log();
TTCN_Logger::log_event_str(", ch_req_desc := ");
single_value->field_ch__req__desc.log();
TTCN_Logger::log_event_str(", change_mark_presence := ");
single_value->field_change__mark__presence.log();
TTCN_Logger::log_event_str(", change_mark := ");
single_value->field_change__mark.log();
TTCN_Logger::log_event_str(", C_val := ");
single_value->field_C__val.log();
TTCN_Logger::log_event_str(", sign_var_presence := ");
single_value->field_sign__var__presence.log();
TTCN_Logger::log_event_str(", sign_var := ");
single_value->field_sign__var.log();
TTCN_Logger::log_event_str(", I_levels := ");
single_value->field_I__levels.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PacketResourceReq_template::log_match(const PacketResourceReq& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_acc__type__presence.match(match_value.acc__type__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".acc_type_presence");
single_value->field_acc__type__presence.log_match(match_value.acc__type__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.acc__type().ispresent()){
if(!single_value->field_acc__type.match(match_value.acc__type(), legacy)){
TTCN_Logger::log_logmatch_info(".acc_type");
single_value->field_acc__type.log_match(match_value.acc__type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_acc__type.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".acc_type := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_acc__type.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_id__type.match(match_value.id__type(), legacy)){
TTCN_Logger::log_logmatch_info(".id_type");
single_value->field_id__type.log_match(match_value.id__type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_id.match(match_value.id(), legacy)){
TTCN_Logger::log_logmatch_info(".id");
single_value->field_id.log_match(match_value.id(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ms__rac2__presence.match(match_value.ms__rac2__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".ms_rac2_presence");
single_value->field_ms__rac2__presence.log_match(match_value.ms__rac2__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.ms__rac2().ispresent()){
if(!single_value->field_ms__rac2.match(match_value.ms__rac2(), legacy)){
TTCN_Logger::log_logmatch_info(".ms_rac2");
single_value->field_ms__rac2.log_match(match_value.ms__rac2(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ms__rac2.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ms_rac2 := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ms__rac2.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_ch__req__desc.match(match_value.ch__req__desc(), legacy)){
TTCN_Logger::log_logmatch_info(".ch_req_desc");
single_value->field_ch__req__desc.log_match(match_value.ch__req__desc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_change__mark__presence.match(match_value.change__mark__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".change_mark_presence");
single_value->field_change__mark__presence.log_match(match_value.change__mark__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.change__mark().ispresent()){
if(!single_value->field_change__mark.match(match_value.change__mark(), legacy)){
TTCN_Logger::log_logmatch_info(".change_mark");
single_value->field_change__mark.log_match(match_value.change__mark(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_change__mark.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".change_mark := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_change__mark.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_C__val.match(match_value.C__val(), legacy)){
TTCN_Logger::log_logmatch_info(".C_val");
single_value->field_C__val.log_match(match_value.C__val(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sign__var__presence.match(match_value.sign__var__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".sign_var_presence");
single_value->field_sign__var__presence.log_match(match_value.sign__var__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.sign__var().ispresent()){
if(!single_value->field_sign__var.match(match_value.sign__var(), legacy)){
TTCN_Logger::log_logmatch_info(".sign_var");
single_value->field_sign__var.log_match(match_value.sign__var(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_sign__var.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".sign_var := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_sign__var.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_I__levels.match(match_value.I__levels(), legacy)){
TTCN_Logger::log_logmatch_info(".I_levels");
single_value->field_I__levels.log_match(match_value.I__levels(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ acc_type_presence := ");
single_value->field_acc__type__presence.log_match(match_value.acc__type__presence(), legacy);
TTCN_Logger::log_event_str(", acc_type := ");
if (match_value.acc__type().ispresent()) {
single_value->field_acc__type.log_match(match_value.acc__type(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_acc__type.log();
if (single_value->field_acc__type.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", id_type := ");
single_value->field_id__type.log_match(match_value.id__type(), legacy);
TTCN_Logger::log_event_str(", id := ");
single_value->field_id.log_match(match_value.id(), legacy);
TTCN_Logger::log_event_str(", ms_rac2_presence := ");
single_value->field_ms__rac2__presence.log_match(match_value.ms__rac2__presence(), legacy);
TTCN_Logger::log_event_str(", ms_rac2 := ");
if (match_value.ms__rac2().ispresent()) {
single_value->field_ms__rac2.log_match(match_value.ms__rac2(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ms__rac2.log();
if (single_value->field_ms__rac2.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", ch_req_desc := ");
single_value->field_ch__req__desc.log_match(match_value.ch__req__desc(), legacy);
TTCN_Logger::log_event_str(", change_mark_presence := ");
single_value->field_change__mark__presence.log_match(match_value.change__mark__presence(), legacy);
TTCN_Logger::log_event_str(", change_mark := ");
if (match_value.change__mark().ispresent()) {
single_value->field_change__mark.log_match(match_value.change__mark(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_change__mark.log();
if (single_value->field_change__mark.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", C_val := ");
single_value->field_C__val.log_match(match_value.C__val(), legacy);
TTCN_Logger::log_event_str(", sign_var_presence := ");
single_value->field_sign__var__presence.log_match(match_value.sign__var__presence(), legacy);
TTCN_Logger::log_event_str(", sign_var := ");
if (match_value.sign__var().ispresent()) {
single_value->field_sign__var.log_match(match_value.sign__var(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_sign__var.log();
if (single_value->field_sign__var.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", I_levels := ");
single_value->field_I__levels.log_match(match_value.I__levels(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PacketResourceReq_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (acc__type__presence().is_bound()) acc__type__presence().set_implicit_omit();
if (!acc__type().is_bound()) acc__type() = OMIT_VALUE;
else acc__type().set_implicit_omit();
if (id__type().is_bound()) id__type().set_implicit_omit();
if (id().is_bound()) id().set_implicit_omit();
if (ms__rac2__presence().is_bound()) ms__rac2__presence().set_implicit_omit();
if (!ms__rac2().is_bound()) ms__rac2() = OMIT_VALUE;
else ms__rac2().set_implicit_omit();
if (ch__req__desc().is_bound()) ch__req__desc().set_implicit_omit();
if (change__mark__presence().is_bound()) change__mark__presence().set_implicit_omit();
if (!change__mark().is_bound()) change__mark() = OMIT_VALUE;
else change__mark().set_implicit_omit();
if (C__val().is_bound()) C__val().set_implicit_omit();
if (sign__var__presence().is_bound()) sign__var__presence().set_implicit_omit();
if (!sign__var().is_bound()) sign__var() = OMIT_VALUE;
else sign__var().set_implicit_omit();
if (I__levels().is_bound()) I__levels().set_implicit_omit();
}

void PacketResourceReq_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_acc__type__presence.encode_text(text_buf);
single_value->field_acc__type.encode_text(text_buf);
single_value->field_id__type.encode_text(text_buf);
single_value->field_id.encode_text(text_buf);
single_value->field_ms__rac2__presence.encode_text(text_buf);
single_value->field_ms__rac2.encode_text(text_buf);
single_value->field_ch__req__desc.encode_text(text_buf);
single_value->field_change__mark__presence.encode_text(text_buf);
single_value->field_change__mark.encode_text(text_buf);
single_value->field_C__val.encode_text(text_buf);
single_value->field_sign__var__presence.encode_text(text_buf);
single_value->field_sign__var.encode_text(text_buf);
single_value->field_I__levels.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
}
}

void PacketResourceReq_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_acc__type__presence.decode_text(text_buf);
single_value->field_acc__type.decode_text(text_buf);
single_value->field_id__type.decode_text(text_buf);
single_value->field_id.decode_text(text_buf);
single_value->field_ms__rac2__presence.decode_text(text_buf);
single_value->field_ms__rac2.decode_text(text_buf);
single_value->field_ch__req__desc.decode_text(text_buf);
single_value->field_change__mark__presence.decode_text(text_buf);
single_value->field_change__mark.decode_text(text_buf);
single_value->field_C__val.decode_text(text_buf);
single_value->field_sign__var__presence.decode_text(text_buf);
single_value->field_sign__var.decode_text(text_buf);
single_value->field_I__levels.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PacketResourceReq_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.PacketResourceReq.");
}
}

void PacketResourceReq_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PacketResourceReq_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (13<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.PacketResourceReq has 13 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) acc__type__presence().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) acc__type().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) id__type().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) id().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) ms__rac2__presence().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) ms__rac2().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) ch__req__desc().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) change__mark__presence().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) change__mark().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) C__val().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) sign__var__presence().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) sign__var().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) I__levels().set_param(*param.get_elem(12));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "acc_type_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          acc__type__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "acc_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          acc__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "id_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          id__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ms_rac2_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ms__rac2__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ms_rac2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ms__rac2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ch_req_desc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ch__req__desc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "change_mark_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          change__mark__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "change_mark")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          change__mark().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "C_val")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          C__val().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sign_var_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sign__var__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sign_var")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sign__var().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "I_levels")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          I__levels().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.PacketResourceReq: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PacketResourceReq_template* precondition = new PacketResourceReq_template;
    precondition->set_param(*param.get_elem(0));
    PacketResourceReq_template* implied_template = new PacketResourceReq_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PacketResourceReq_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.PacketResourceReq");
  }
  is_ifpresent = param.get_ifpresent();
}

void PacketResourceReq_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_acc__type__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketResourceReq");
single_value->field_acc__type.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketResourceReq");
single_value->field_id__type.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketResourceReq");
single_value->field_id.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketResourceReq");
single_value->field_ms__rac2__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketResourceReq");
single_value->field_ms__rac2.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketResourceReq");
single_value->field_ch__req__desc.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketResourceReq");
single_value->field_change__mark__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketResourceReq");
single_value->field_change__mark.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketResourceReq");
single_value->field_C__val.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketResourceReq");
single_value->field_sign__var__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketResourceReq");
single_value->field_sign__var.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketResourceReq");
single_value->field_I__levels.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PacketResourceReq");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.PacketResourceReq");
}

boolean PacketResourceReq_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PacketResourceReq_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

UtranTargetCellFdd::UtranTargetCellFdd()
{
}

UtranTargetCellFdd::UtranTargetCellFdd(const INTEGER& par_arfcn,
    const BITSTRING& par_bandwidth__presence,
    const OPTIONAL< INTEGER >& par_bandwidth,
    const INTEGER& par_scrambling__code)
  :   field_arfcn(par_arfcn),
  field_bandwidth__presence(par_bandwidth__presence),
  field_bandwidth(par_bandwidth),
  field_scrambling__code(par_scrambling__code)
{
}

UtranTargetCellFdd::UtranTargetCellFdd(const UtranTargetCellFdd& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.UtranTargetCellFdd.");
if (other_value.arfcn().is_bound()) field_arfcn = other_value.arfcn();
else field_arfcn.clean_up();
if (other_value.bandwidth__presence().is_bound()) field_bandwidth__presence = other_value.bandwidth__presence();
else field_bandwidth__presence.clean_up();
if (other_value.bandwidth().is_bound()) field_bandwidth = other_value.bandwidth();
else field_bandwidth.clean_up();
if (other_value.scrambling__code().is_bound()) field_scrambling__code = other_value.scrambling__code();
else field_scrambling__code.clean_up();
}

void UtranTargetCellFdd::clean_up()
{
field_arfcn.clean_up();
field_bandwidth__presence.clean_up();
field_bandwidth.clean_up();
field_scrambling__code.clean_up();
}

const TTCN_Typedescriptor_t* UtranTargetCellFdd::get_descriptor() const { return &UtranTargetCellFdd_descr_; }
UtranTargetCellFdd& UtranTargetCellFdd::operator=(const UtranTargetCellFdd& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.UtranTargetCellFdd.");
  if (other_value.arfcn().is_bound()) field_arfcn = other_value.arfcn();
  else field_arfcn.clean_up();
  if (other_value.bandwidth__presence().is_bound()) field_bandwidth__presence = other_value.bandwidth__presence();
  else field_bandwidth__presence.clean_up();
  if (other_value.bandwidth().is_bound()) field_bandwidth = other_value.bandwidth();
  else field_bandwidth.clean_up();
  if (other_value.scrambling__code().is_bound()) field_scrambling__code = other_value.scrambling__code();
  else field_scrambling__code.clean_up();
}
return *this;
}

boolean UtranTargetCellFdd::operator==(const UtranTargetCellFdd& other_value) const
{
return field_arfcn==other_value.field_arfcn
  && field_bandwidth__presence==other_value.field_bandwidth__presence
  && field_bandwidth==other_value.field_bandwidth
  && field_scrambling__code==other_value.field_scrambling__code;
}

boolean UtranTargetCellFdd::is_bound() const
{
return (field_arfcn.is_bound())
  || (field_bandwidth__presence.is_bound())
  || (OPTIONAL_OMIT == field_bandwidth.get_selection() || field_bandwidth.is_bound())
  || (field_scrambling__code.is_bound());
}
boolean UtranTargetCellFdd::is_value() const
{
return field_arfcn.is_value()
  && field_bandwidth__presence.is_value()
  && (OPTIONAL_OMIT == field_bandwidth.get_selection() || field_bandwidth.is_value())
  && field_scrambling__code.is_value();
}
int UtranTargetCellFdd::size_of() const
{
  int ret_val = 3;
  if (field_bandwidth.ispresent()) ret_val++;
  return ret_val;
}

void UtranTargetCellFdd::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ arfcn := ");
field_arfcn.log();
TTCN_Logger::log_event_str(", bandwidth_presence := ");
field_bandwidth__presence.log();
TTCN_Logger::log_event_str(", bandwidth := ");
field_bandwidth.log();
TTCN_Logger::log_event_str(", scrambling_code := ");
field_scrambling__code.log();
TTCN_Logger::log_event_str(" }");
}

void UtranTargetCellFdd::set_implicit_omit()
{
if (arfcn().is_bound()) arfcn().set_implicit_omit();
if (bandwidth__presence().is_bound()) bandwidth__presence().set_implicit_omit();
if (!bandwidth().is_bound()) bandwidth() = OMIT_VALUE;
else bandwidth().set_implicit_omit();
if (scrambling__code().is_bound()) scrambling__code().set_implicit_omit();
}

void UtranTargetCellFdd::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.UtranTargetCellFdd has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) arfcn().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) bandwidth__presence().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) bandwidth().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) scrambling__code().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "arfcn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          arfcn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bandwidth_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bandwidth__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bandwidth")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bandwidth().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "scrambling_code")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          scrambling__code().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.UtranTargetCellFdd: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.UtranTargetCellFdd");
  }
}

void UtranTargetCellFdd::encode_text(Text_Buf& text_buf) const
{
field_arfcn.encode_text(text_buf);
field_bandwidth__presence.encode_text(text_buf);
field_bandwidth.encode_text(text_buf);
field_scrambling__code.encode_text(text_buf);
}

void UtranTargetCellFdd::decode_text(Text_Buf& text_buf)
{
field_arfcn.decode_text(text_buf);
field_bandwidth__presence.decode_text(text_buf);
field_bandwidth.decode_text(text_buf);
field_scrambling__code.decode_text(text_buf);
}

void UtranTargetCellFdd::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void UtranTargetCellFdd::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int UtranTargetCellFdd::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, UtranTargetCellFdd_arfcn_descr_.raw->forceomit);
  decoded_field_length = field_arfcn.RAW_decode(UtranTargetCellFdd_arfcn_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, UtranTargetCellFdd_bandwidth__presence_descr_.raw->forceomit);
  decoded_field_length = field_bandwidth__presence.RAW_decode(UtranTargetCellFdd_bandwidth__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_bandwidth__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_bandwidth = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, UtranTargetCellFdd_bandwidth_descr_.raw->forceomit);
  decoded_field_length = field_bandwidth().RAW_decode(UtranTargetCellFdd_bandwidth_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_bandwidth = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_bandwidth=OMIT_VALUE;
  RAW_Force_Omit field_3_force_omit(3, force_omit, UtranTargetCellFdd_scrambling__code_descr_.raw->forceomit);
  decoded_field_length = field_scrambling__code.RAW_decode(UtranTargetCellFdd_scrambling__code_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int UtranTargetCellFdd::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, UtranTargetCellFdd_arfcn_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, UtranTargetCellFdd_bandwidth__presence_descr_.raw);
  if (field_bandwidth.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, UtranTargetCellFdd_bandwidth_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, UtranTargetCellFdd_scrambling__code_descr_.raw);
  encoded_length += field_arfcn.RAW_encode(UtranTargetCellFdd_arfcn_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_bandwidth__presence.RAW_encode(UtranTargetCellFdd_bandwidth__presence_descr_, *myleaf.body.node.nodes[1]);
  if (field_bandwidth.ispresent()) {
  encoded_length += field_bandwidth().RAW_encode(UtranTargetCellFdd_bandwidth_descr_, *myleaf.body.node.nodes[2]);
  }
  encoded_length += field_scrambling__code.RAW_encode(UtranTargetCellFdd_scrambling__code_descr_, *myleaf.body.node.nodes[3]);
  if (field_bandwidth.ispresent() && (field_bandwidth__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={1};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(UtranTargetCellFdd_bandwidth__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct UtranTargetCellFdd_template::single_value_struct {
INTEGER_template field_arfcn;
BITSTRING_template field_bandwidth__presence;
INTEGER_template field_bandwidth;
INTEGER_template field_scrambling__code;
};

void UtranTargetCellFdd_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_arfcn = ANY_VALUE;
single_value->field_bandwidth__presence = ANY_VALUE;
single_value->field_bandwidth = ANY_OR_OMIT;
single_value->field_scrambling__code = ANY_VALUE;
}
}
}

void UtranTargetCellFdd_template::copy_value(const UtranTargetCellFdd& other_value)
{
single_value = new single_value_struct;
if (other_value.arfcn().is_bound()) {
  single_value->field_arfcn = other_value.arfcn();
} else {
  single_value->field_arfcn.clean_up();
}
if (other_value.bandwidth__presence().is_bound()) {
  single_value->field_bandwidth__presence = other_value.bandwidth__presence();
} else {
  single_value->field_bandwidth__presence.clean_up();
}
if (other_value.bandwidth().is_bound()) {
  if (other_value.bandwidth().ispresent()) single_value->field_bandwidth = other_value.bandwidth()();
  else single_value->field_bandwidth = OMIT_VALUE;
} else {
  single_value->field_bandwidth.clean_up();
}
if (other_value.scrambling__code().is_bound()) {
  single_value->field_scrambling__code = other_value.scrambling__code();
} else {
  single_value->field_scrambling__code.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void UtranTargetCellFdd_template::copy_template(const UtranTargetCellFdd_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.arfcn().get_selection()) {
single_value->field_arfcn = other_value.arfcn();
} else {
single_value->field_arfcn.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bandwidth__presence().get_selection()) {
single_value->field_bandwidth__presence = other_value.bandwidth__presence();
} else {
single_value->field_bandwidth__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bandwidth().get_selection()) {
single_value->field_bandwidth = other_value.bandwidth();
} else {
single_value->field_bandwidth.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.scrambling__code().get_selection()) {
single_value->field_scrambling__code = other_value.scrambling__code();
} else {
single_value->field_scrambling__code.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new UtranTargetCellFdd_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new UtranTargetCellFdd_template(*other_value.implication_.precondition);
implication_.implied_template = new UtranTargetCellFdd_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd.");
break;
}
set_selection(other_value);
}

UtranTargetCellFdd_template::UtranTargetCellFdd_template()
{
}

UtranTargetCellFdd_template::UtranTargetCellFdd_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

UtranTargetCellFdd_template::UtranTargetCellFdd_template(const UtranTargetCellFdd& other_value)
{
copy_value(other_value);
}

UtranTargetCellFdd_template::UtranTargetCellFdd_template(const OPTIONAL<UtranTargetCellFdd>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UtranTargetCellFdd&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd from an unbound optional field.");
}
}

UtranTargetCellFdd_template::UtranTargetCellFdd_template(UtranTargetCellFdd_template* p_precondition, UtranTargetCellFdd_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

UtranTargetCellFdd_template::UtranTargetCellFdd_template(Dynamic_Match_Interface<UtranTargetCellFdd>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<UtranTargetCellFdd>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

UtranTargetCellFdd_template::UtranTargetCellFdd_template(const UtranTargetCellFdd_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

UtranTargetCellFdd_template::~UtranTargetCellFdd_template()
{
clean_up();
}

UtranTargetCellFdd_template& UtranTargetCellFdd_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

UtranTargetCellFdd_template& UtranTargetCellFdd_template::operator=(const UtranTargetCellFdd& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

UtranTargetCellFdd_template& UtranTargetCellFdd_template::operator=(const OPTIONAL<UtranTargetCellFdd>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UtranTargetCellFdd&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd.");
}
return *this;
}

UtranTargetCellFdd_template& UtranTargetCellFdd_template::operator=(const UtranTargetCellFdd_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean UtranTargetCellFdd_template::match(const UtranTargetCellFdd& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.arfcn().is_bound()) return FALSE;
if(!single_value->field_arfcn.match(other_value.arfcn(), legacy))return FALSE;
if(!other_value.bandwidth__presence().is_bound()) return FALSE;
if(!single_value->field_bandwidth__presence.match(other_value.bandwidth__presence(), legacy))return FALSE;
if(!other_value.bandwidth().is_bound()) return FALSE;
if((other_value.bandwidth().ispresent() ? !single_value->field_bandwidth.match((const INTEGER&)other_value.bandwidth(), legacy) : !single_value->field_bandwidth.match_omit(legacy)))return FALSE;
if(!other_value.scrambling__code().is_bound()) return FALSE;
if(!single_value->field_scrambling__code.match(other_value.scrambling__code(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd.");
}
return FALSE;
}

boolean UtranTargetCellFdd_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_arfcn.is_bound()
 || single_value->field_bandwidth__presence.is_bound()
 || (single_value->field_bandwidth.is_omit() || single_value->field_bandwidth.is_bound())
 || single_value->field_scrambling__code.is_bound();
}

boolean UtranTargetCellFdd_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_arfcn.is_value()
 && single_value->field_bandwidth__presence.is_value()
 && (single_value->field_bandwidth.is_omit() || single_value->field_bandwidth.is_value())
 && single_value->field_scrambling__code.is_value();
}

void UtranTargetCellFdd_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

UtranTargetCellFdd UtranTargetCellFdd_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd.");
UtranTargetCellFdd ret_val;
if (single_value->field_arfcn.is_bound()) {
ret_val.arfcn() = single_value->field_arfcn.valueof();
}
if (single_value->field_bandwidth__presence.is_bound()) {
ret_val.bandwidth__presence() = single_value->field_bandwidth__presence.valueof();
}
if (single_value->field_bandwidth.is_omit()) ret_val.bandwidth() = OMIT_VALUE;
else if (single_value->field_bandwidth.is_bound()) {
ret_val.bandwidth() = single_value->field_bandwidth.valueof();
}
if (single_value->field_scrambling__code.is_bound()) {
ret_val.scrambling__code() = single_value->field_scrambling__code.valueof();
}
return ret_val;
}

void UtranTargetCellFdd_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new UtranTargetCellFdd_template[list_length];
}

UtranTargetCellFdd_template& UtranTargetCellFdd_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd.");
return value_list.list_value[list_index];
}

INTEGER_template& UtranTargetCellFdd_template::arfcn()
{
set_specific();
return single_value->field_arfcn;
}

const INTEGER_template& UtranTargetCellFdd_template::arfcn() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field arfcn of a non-specific template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd.");
return single_value->field_arfcn;
}

BITSTRING_template& UtranTargetCellFdd_template::bandwidth__presence()
{
set_specific();
return single_value->field_bandwidth__presence;
}

const BITSTRING_template& UtranTargetCellFdd_template::bandwidth__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bandwidth_presence of a non-specific template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd.");
return single_value->field_bandwidth__presence;
}

INTEGER_template& UtranTargetCellFdd_template::bandwidth()
{
set_specific();
return single_value->field_bandwidth;
}

const INTEGER_template& UtranTargetCellFdd_template::bandwidth() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bandwidth of a non-specific template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd.");
return single_value->field_bandwidth;
}

INTEGER_template& UtranTargetCellFdd_template::scrambling__code()
{
set_specific();
return single_value->field_scrambling__code;
}

const INTEGER_template& UtranTargetCellFdd_template::scrambling__code() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field scrambling_code of a non-specific template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd.");
return single_value->field_scrambling__code;
}

int UtranTargetCellFdd_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 3;
      if (single_value->field_bandwidth.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd.");
  }
  return 0;
}

void UtranTargetCellFdd_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ arfcn := ");
single_value->field_arfcn.log();
TTCN_Logger::log_event_str(", bandwidth_presence := ");
single_value->field_bandwidth__presence.log();
TTCN_Logger::log_event_str(", bandwidth := ");
single_value->field_bandwidth.log();
TTCN_Logger::log_event_str(", scrambling_code := ");
single_value->field_scrambling__code.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void UtranTargetCellFdd_template::log_match(const UtranTargetCellFdd& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_arfcn.match(match_value.arfcn(), legacy)){
TTCN_Logger::log_logmatch_info(".arfcn");
single_value->field_arfcn.log_match(match_value.arfcn(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_bandwidth__presence.match(match_value.bandwidth__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".bandwidth_presence");
single_value->field_bandwidth__presence.log_match(match_value.bandwidth__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.bandwidth().ispresent()){
if(!single_value->field_bandwidth.match(match_value.bandwidth(), legacy)){
TTCN_Logger::log_logmatch_info(".bandwidth");
single_value->field_bandwidth.log_match(match_value.bandwidth(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_bandwidth.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".bandwidth := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_bandwidth.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_scrambling__code.match(match_value.scrambling__code(), legacy)){
TTCN_Logger::log_logmatch_info(".scrambling_code");
single_value->field_scrambling__code.log_match(match_value.scrambling__code(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ arfcn := ");
single_value->field_arfcn.log_match(match_value.arfcn(), legacy);
TTCN_Logger::log_event_str(", bandwidth_presence := ");
single_value->field_bandwidth__presence.log_match(match_value.bandwidth__presence(), legacy);
TTCN_Logger::log_event_str(", bandwidth := ");
if (match_value.bandwidth().ispresent()) {
single_value->field_bandwidth.log_match(match_value.bandwidth(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_bandwidth.log();
if (single_value->field_bandwidth.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", scrambling_code := ");
single_value->field_scrambling__code.log_match(match_value.scrambling__code(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void UtranTargetCellFdd_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (arfcn().is_bound()) arfcn().set_implicit_omit();
if (bandwidth__presence().is_bound()) bandwidth__presence().set_implicit_omit();
if (!bandwidth().is_bound()) bandwidth() = OMIT_VALUE;
else bandwidth().set_implicit_omit();
if (scrambling__code().is_bound()) scrambling__code().set_implicit_omit();
}

void UtranTargetCellFdd_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_arfcn.encode_text(text_buf);
single_value->field_bandwidth__presence.encode_text(text_buf);
single_value->field_bandwidth.encode_text(text_buf);
single_value->field_scrambling__code.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd.");
}
}

void UtranTargetCellFdd_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_arfcn.decode_text(text_buf);
single_value->field_bandwidth__presence.decode_text(text_buf);
single_value->field_bandwidth.decode_text(text_buf);
single_value->field_scrambling__code.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new UtranTargetCellFdd_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd.");
}
}

void UtranTargetCellFdd_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    UtranTargetCellFdd_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.UtranTargetCellFdd has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) arfcn().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) bandwidth__presence().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) bandwidth().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) scrambling__code().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "arfcn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          arfcn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bandwidth_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bandwidth__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bandwidth")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bandwidth().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "scrambling_code")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          scrambling__code().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.UtranTargetCellFdd: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    UtranTargetCellFdd_template* precondition = new UtranTargetCellFdd_template;
    precondition->set_param(*param.get_elem(0));
    UtranTargetCellFdd_template* implied_template = new UtranTargetCellFdd_template;
    implied_template->set_param(*param.get_elem(1));
    *this = UtranTargetCellFdd_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.UtranTargetCellFdd");
  }
  is_ifpresent = param.get_ifpresent();
}

void UtranTargetCellFdd_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_arfcn.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.UtranTargetCellFdd");
single_value->field_bandwidth__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.UtranTargetCellFdd");
single_value->field_bandwidth.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.UtranTargetCellFdd");
single_value->field_scrambling__code.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.UtranTargetCellFdd");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.UtranTargetCellFdd");
}

boolean UtranTargetCellFdd_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean UtranTargetCellFdd_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

UtranTargetCellTdd::UtranTargetCellTdd()
{
}

UtranTargetCellTdd::UtranTargetCellTdd(const INTEGER& par_arfcn,
    const BITSTRING& par_bandwidth__presence,
    const OPTIONAL< INTEGER >& par_bandwidth,
    const INTEGER& par_cell__parameter,
    const BITSTRING& par_sync__case)
  :   field_arfcn(par_arfcn),
  field_bandwidth__presence(par_bandwidth__presence),
  field_bandwidth(par_bandwidth),
  field_cell__parameter(par_cell__parameter),
  field_sync__case(par_sync__case)
{
}

UtranTargetCellTdd::UtranTargetCellTdd(const UtranTargetCellTdd& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.UtranTargetCellTdd.");
if (other_value.arfcn().is_bound()) field_arfcn = other_value.arfcn();
else field_arfcn.clean_up();
if (other_value.bandwidth__presence().is_bound()) field_bandwidth__presence = other_value.bandwidth__presence();
else field_bandwidth__presence.clean_up();
if (other_value.bandwidth().is_bound()) field_bandwidth = other_value.bandwidth();
else field_bandwidth.clean_up();
if (other_value.cell__parameter().is_bound()) field_cell__parameter = other_value.cell__parameter();
else field_cell__parameter.clean_up();
if (other_value.sync__case().is_bound()) field_sync__case = other_value.sync__case();
else field_sync__case.clean_up();
}

void UtranTargetCellTdd::clean_up()
{
field_arfcn.clean_up();
field_bandwidth__presence.clean_up();
field_bandwidth.clean_up();
field_cell__parameter.clean_up();
field_sync__case.clean_up();
}

const TTCN_Typedescriptor_t* UtranTargetCellTdd::get_descriptor() const { return &UtranTargetCellTdd_descr_; }
UtranTargetCellTdd& UtranTargetCellTdd::operator=(const UtranTargetCellTdd& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.UtranTargetCellTdd.");
  if (other_value.arfcn().is_bound()) field_arfcn = other_value.arfcn();
  else field_arfcn.clean_up();
  if (other_value.bandwidth__presence().is_bound()) field_bandwidth__presence = other_value.bandwidth__presence();
  else field_bandwidth__presence.clean_up();
  if (other_value.bandwidth().is_bound()) field_bandwidth = other_value.bandwidth();
  else field_bandwidth.clean_up();
  if (other_value.cell__parameter().is_bound()) field_cell__parameter = other_value.cell__parameter();
  else field_cell__parameter.clean_up();
  if (other_value.sync__case().is_bound()) field_sync__case = other_value.sync__case();
  else field_sync__case.clean_up();
}
return *this;
}

boolean UtranTargetCellTdd::operator==(const UtranTargetCellTdd& other_value) const
{
return field_arfcn==other_value.field_arfcn
  && field_bandwidth__presence==other_value.field_bandwidth__presence
  && field_bandwidth==other_value.field_bandwidth
  && field_cell__parameter==other_value.field_cell__parameter
  && field_sync__case==other_value.field_sync__case;
}

boolean UtranTargetCellTdd::is_bound() const
{
return (field_arfcn.is_bound())
  || (field_bandwidth__presence.is_bound())
  || (OPTIONAL_OMIT == field_bandwidth.get_selection() || field_bandwidth.is_bound())
  || (field_cell__parameter.is_bound())
  || (field_sync__case.is_bound());
}
boolean UtranTargetCellTdd::is_value() const
{
return field_arfcn.is_value()
  && field_bandwidth__presence.is_value()
  && (OPTIONAL_OMIT == field_bandwidth.get_selection() || field_bandwidth.is_value())
  && field_cell__parameter.is_value()
  && field_sync__case.is_value();
}
int UtranTargetCellTdd::size_of() const
{
  int ret_val = 4;
  if (field_bandwidth.ispresent()) ret_val++;
  return ret_val;
}

void UtranTargetCellTdd::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ arfcn := ");
field_arfcn.log();
TTCN_Logger::log_event_str(", bandwidth_presence := ");
field_bandwidth__presence.log();
TTCN_Logger::log_event_str(", bandwidth := ");
field_bandwidth.log();
TTCN_Logger::log_event_str(", cell_parameter := ");
field_cell__parameter.log();
TTCN_Logger::log_event_str(", sync_case := ");
field_sync__case.log();
TTCN_Logger::log_event_str(" }");
}

void UtranTargetCellTdd::set_implicit_omit()
{
if (arfcn().is_bound()) arfcn().set_implicit_omit();
if (bandwidth__presence().is_bound()) bandwidth__presence().set_implicit_omit();
if (!bandwidth().is_bound()) bandwidth() = OMIT_VALUE;
else bandwidth().set_implicit_omit();
if (cell__parameter().is_bound()) cell__parameter().set_implicit_omit();
if (sync__case().is_bound()) sync__case().set_implicit_omit();
}

void UtranTargetCellTdd::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.UtranTargetCellTdd has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) arfcn().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) bandwidth__presence().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) bandwidth().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) cell__parameter().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) sync__case().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "arfcn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          arfcn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bandwidth_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bandwidth__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bandwidth")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bandwidth().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cell_parameter")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cell__parameter().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sync_case")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sync__case().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.UtranTargetCellTdd: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.UtranTargetCellTdd");
  }
}

void UtranTargetCellTdd::encode_text(Text_Buf& text_buf) const
{
field_arfcn.encode_text(text_buf);
field_bandwidth__presence.encode_text(text_buf);
field_bandwidth.encode_text(text_buf);
field_cell__parameter.encode_text(text_buf);
field_sync__case.encode_text(text_buf);
}

void UtranTargetCellTdd::decode_text(Text_Buf& text_buf)
{
field_arfcn.decode_text(text_buf);
field_bandwidth__presence.decode_text(text_buf);
field_bandwidth.decode_text(text_buf);
field_cell__parameter.decode_text(text_buf);
field_sync__case.decode_text(text_buf);
}

void UtranTargetCellTdd::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void UtranTargetCellTdd::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int UtranTargetCellTdd::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, UtranTargetCellTdd_arfcn_descr_.raw->forceomit);
  decoded_field_length = field_arfcn.RAW_decode(UtranTargetCellTdd_arfcn_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, UtranTargetCellTdd_bandwidth__presence_descr_.raw->forceomit);
  decoded_field_length = field_bandwidth__presence.RAW_decode(UtranTargetCellTdd_bandwidth__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_bandwidth__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_bandwidth = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, UtranTargetCellTdd_bandwidth_descr_.raw->forceomit);
  decoded_field_length = field_bandwidth().RAW_decode(UtranTargetCellTdd_bandwidth_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_bandwidth = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_bandwidth=OMIT_VALUE;
  RAW_Force_Omit field_3_force_omit(3, force_omit, UtranTargetCellTdd_cell__parameter_descr_.raw->forceomit);
  decoded_field_length = field_cell__parameter.RAW_decode(UtranTargetCellTdd_cell__parameter_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, UtranTargetCellTdd_sync__case_descr_.raw->forceomit);
  decoded_field_length = field_sync__case.RAW_decode(UtranTargetCellTdd_sync__case_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int UtranTargetCellTdd::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, UtranTargetCellTdd_arfcn_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, UtranTargetCellTdd_bandwidth__presence_descr_.raw);
  if (field_bandwidth.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, UtranTargetCellTdd_bandwidth_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, UtranTargetCellTdd_cell__parameter_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, UtranTargetCellTdd_sync__case_descr_.raw);
  encoded_length += field_arfcn.RAW_encode(UtranTargetCellTdd_arfcn_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_bandwidth__presence.RAW_encode(UtranTargetCellTdd_bandwidth__presence_descr_, *myleaf.body.node.nodes[1]);
  if (field_bandwidth.ispresent()) {
  encoded_length += field_bandwidth().RAW_encode(UtranTargetCellTdd_bandwidth_descr_, *myleaf.body.node.nodes[2]);
  }
  encoded_length += field_cell__parameter.RAW_encode(UtranTargetCellTdd_cell__parameter_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_sync__case.RAW_encode(UtranTargetCellTdd_sync__case_descr_, *myleaf.body.node.nodes[4]);
  if (field_bandwidth.ispresent() && (field_bandwidth__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={1};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(UtranTargetCellTdd_bandwidth__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct UtranTargetCellTdd_template::single_value_struct {
INTEGER_template field_arfcn;
BITSTRING_template field_bandwidth__presence;
INTEGER_template field_bandwidth;
INTEGER_template field_cell__parameter;
BITSTRING_template field_sync__case;
};

void UtranTargetCellTdd_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_arfcn = ANY_VALUE;
single_value->field_bandwidth__presence = ANY_VALUE;
single_value->field_bandwidth = ANY_OR_OMIT;
single_value->field_cell__parameter = ANY_VALUE;
single_value->field_sync__case = ANY_VALUE;
}
}
}

void UtranTargetCellTdd_template::copy_value(const UtranTargetCellTdd& other_value)
{
single_value = new single_value_struct;
if (other_value.arfcn().is_bound()) {
  single_value->field_arfcn = other_value.arfcn();
} else {
  single_value->field_arfcn.clean_up();
}
if (other_value.bandwidth__presence().is_bound()) {
  single_value->field_bandwidth__presence = other_value.bandwidth__presence();
} else {
  single_value->field_bandwidth__presence.clean_up();
}
if (other_value.bandwidth().is_bound()) {
  if (other_value.bandwidth().ispresent()) single_value->field_bandwidth = other_value.bandwidth()();
  else single_value->field_bandwidth = OMIT_VALUE;
} else {
  single_value->field_bandwidth.clean_up();
}
if (other_value.cell__parameter().is_bound()) {
  single_value->field_cell__parameter = other_value.cell__parameter();
} else {
  single_value->field_cell__parameter.clean_up();
}
if (other_value.sync__case().is_bound()) {
  single_value->field_sync__case = other_value.sync__case();
} else {
  single_value->field_sync__case.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void UtranTargetCellTdd_template::copy_template(const UtranTargetCellTdd_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.arfcn().get_selection()) {
single_value->field_arfcn = other_value.arfcn();
} else {
single_value->field_arfcn.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bandwidth__presence().get_selection()) {
single_value->field_bandwidth__presence = other_value.bandwidth__presence();
} else {
single_value->field_bandwidth__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bandwidth().get_selection()) {
single_value->field_bandwidth = other_value.bandwidth();
} else {
single_value->field_bandwidth.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cell__parameter().get_selection()) {
single_value->field_cell__parameter = other_value.cell__parameter();
} else {
single_value->field_cell__parameter.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sync__case().get_selection()) {
single_value->field_sync__case = other_value.sync__case();
} else {
single_value->field_sync__case.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new UtranTargetCellTdd_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new UtranTargetCellTdd_template(*other_value.implication_.precondition);
implication_.implied_template = new UtranTargetCellTdd_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd.");
break;
}
set_selection(other_value);
}

UtranTargetCellTdd_template::UtranTargetCellTdd_template()
{
}

UtranTargetCellTdd_template::UtranTargetCellTdd_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

UtranTargetCellTdd_template::UtranTargetCellTdd_template(const UtranTargetCellTdd& other_value)
{
copy_value(other_value);
}

UtranTargetCellTdd_template::UtranTargetCellTdd_template(const OPTIONAL<UtranTargetCellTdd>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UtranTargetCellTdd&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd from an unbound optional field.");
}
}

UtranTargetCellTdd_template::UtranTargetCellTdd_template(UtranTargetCellTdd_template* p_precondition, UtranTargetCellTdd_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

UtranTargetCellTdd_template::UtranTargetCellTdd_template(Dynamic_Match_Interface<UtranTargetCellTdd>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<UtranTargetCellTdd>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

UtranTargetCellTdd_template::UtranTargetCellTdd_template(const UtranTargetCellTdd_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

UtranTargetCellTdd_template::~UtranTargetCellTdd_template()
{
clean_up();
}

UtranTargetCellTdd_template& UtranTargetCellTdd_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

UtranTargetCellTdd_template& UtranTargetCellTdd_template::operator=(const UtranTargetCellTdd& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

UtranTargetCellTdd_template& UtranTargetCellTdd_template::operator=(const OPTIONAL<UtranTargetCellTdd>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UtranTargetCellTdd&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd.");
}
return *this;
}

UtranTargetCellTdd_template& UtranTargetCellTdd_template::operator=(const UtranTargetCellTdd_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean UtranTargetCellTdd_template::match(const UtranTargetCellTdd& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.arfcn().is_bound()) return FALSE;
if(!single_value->field_arfcn.match(other_value.arfcn(), legacy))return FALSE;
if(!other_value.bandwidth__presence().is_bound()) return FALSE;
if(!single_value->field_bandwidth__presence.match(other_value.bandwidth__presence(), legacy))return FALSE;
if(!other_value.bandwidth().is_bound()) return FALSE;
if((other_value.bandwidth().ispresent() ? !single_value->field_bandwidth.match((const INTEGER&)other_value.bandwidth(), legacy) : !single_value->field_bandwidth.match_omit(legacy)))return FALSE;
if(!other_value.cell__parameter().is_bound()) return FALSE;
if(!single_value->field_cell__parameter.match(other_value.cell__parameter(), legacy))return FALSE;
if(!other_value.sync__case().is_bound()) return FALSE;
if(!single_value->field_sync__case.match(other_value.sync__case(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd.");
}
return FALSE;
}

boolean UtranTargetCellTdd_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_arfcn.is_bound()
 || single_value->field_bandwidth__presence.is_bound()
 || (single_value->field_bandwidth.is_omit() || single_value->field_bandwidth.is_bound())
 || single_value->field_cell__parameter.is_bound()
 || single_value->field_sync__case.is_bound();
}

boolean UtranTargetCellTdd_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_arfcn.is_value()
 && single_value->field_bandwidth__presence.is_value()
 && (single_value->field_bandwidth.is_omit() || single_value->field_bandwidth.is_value())
 && single_value->field_cell__parameter.is_value()
 && single_value->field_sync__case.is_value();
}

void UtranTargetCellTdd_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

UtranTargetCellTdd UtranTargetCellTdd_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd.");
UtranTargetCellTdd ret_val;
if (single_value->field_arfcn.is_bound()) {
ret_val.arfcn() = single_value->field_arfcn.valueof();
}
if (single_value->field_bandwidth__presence.is_bound()) {
ret_val.bandwidth__presence() = single_value->field_bandwidth__presence.valueof();
}
if (single_value->field_bandwidth.is_omit()) ret_val.bandwidth() = OMIT_VALUE;
else if (single_value->field_bandwidth.is_bound()) {
ret_val.bandwidth() = single_value->field_bandwidth.valueof();
}
if (single_value->field_cell__parameter.is_bound()) {
ret_val.cell__parameter() = single_value->field_cell__parameter.valueof();
}
if (single_value->field_sync__case.is_bound()) {
ret_val.sync__case() = single_value->field_sync__case.valueof();
}
return ret_val;
}

void UtranTargetCellTdd_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new UtranTargetCellTdd_template[list_length];
}

UtranTargetCellTdd_template& UtranTargetCellTdd_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd.");
return value_list.list_value[list_index];
}

INTEGER_template& UtranTargetCellTdd_template::arfcn()
{
set_specific();
return single_value->field_arfcn;
}

const INTEGER_template& UtranTargetCellTdd_template::arfcn() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field arfcn of a non-specific template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd.");
return single_value->field_arfcn;
}

BITSTRING_template& UtranTargetCellTdd_template::bandwidth__presence()
{
set_specific();
return single_value->field_bandwidth__presence;
}

const BITSTRING_template& UtranTargetCellTdd_template::bandwidth__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bandwidth_presence of a non-specific template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd.");
return single_value->field_bandwidth__presence;
}

INTEGER_template& UtranTargetCellTdd_template::bandwidth()
{
set_specific();
return single_value->field_bandwidth;
}

const INTEGER_template& UtranTargetCellTdd_template::bandwidth() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bandwidth of a non-specific template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd.");
return single_value->field_bandwidth;
}

INTEGER_template& UtranTargetCellTdd_template::cell__parameter()
{
set_specific();
return single_value->field_cell__parameter;
}

const INTEGER_template& UtranTargetCellTdd_template::cell__parameter() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cell_parameter of a non-specific template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd.");
return single_value->field_cell__parameter;
}

BITSTRING_template& UtranTargetCellTdd_template::sync__case()
{
set_specific();
return single_value->field_sync__case;
}

const BITSTRING_template& UtranTargetCellTdd_template::sync__case() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sync_case of a non-specific template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd.");
return single_value->field_sync__case;
}

int UtranTargetCellTdd_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 4;
      if (single_value->field_bandwidth.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd.");
  }
  return 0;
}

void UtranTargetCellTdd_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ arfcn := ");
single_value->field_arfcn.log();
TTCN_Logger::log_event_str(", bandwidth_presence := ");
single_value->field_bandwidth__presence.log();
TTCN_Logger::log_event_str(", bandwidth := ");
single_value->field_bandwidth.log();
TTCN_Logger::log_event_str(", cell_parameter := ");
single_value->field_cell__parameter.log();
TTCN_Logger::log_event_str(", sync_case := ");
single_value->field_sync__case.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void UtranTargetCellTdd_template::log_match(const UtranTargetCellTdd& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_arfcn.match(match_value.arfcn(), legacy)){
TTCN_Logger::log_logmatch_info(".arfcn");
single_value->field_arfcn.log_match(match_value.arfcn(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_bandwidth__presence.match(match_value.bandwidth__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".bandwidth_presence");
single_value->field_bandwidth__presence.log_match(match_value.bandwidth__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.bandwidth().ispresent()){
if(!single_value->field_bandwidth.match(match_value.bandwidth(), legacy)){
TTCN_Logger::log_logmatch_info(".bandwidth");
single_value->field_bandwidth.log_match(match_value.bandwidth(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_bandwidth.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".bandwidth := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_bandwidth.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_cell__parameter.match(match_value.cell__parameter(), legacy)){
TTCN_Logger::log_logmatch_info(".cell_parameter");
single_value->field_cell__parameter.log_match(match_value.cell__parameter(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sync__case.match(match_value.sync__case(), legacy)){
TTCN_Logger::log_logmatch_info(".sync_case");
single_value->field_sync__case.log_match(match_value.sync__case(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ arfcn := ");
single_value->field_arfcn.log_match(match_value.arfcn(), legacy);
TTCN_Logger::log_event_str(", bandwidth_presence := ");
single_value->field_bandwidth__presence.log_match(match_value.bandwidth__presence(), legacy);
TTCN_Logger::log_event_str(", bandwidth := ");
if (match_value.bandwidth().ispresent()) {
single_value->field_bandwidth.log_match(match_value.bandwidth(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_bandwidth.log();
if (single_value->field_bandwidth.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", cell_parameter := ");
single_value->field_cell__parameter.log_match(match_value.cell__parameter(), legacy);
TTCN_Logger::log_event_str(", sync_case := ");
single_value->field_sync__case.log_match(match_value.sync__case(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void UtranTargetCellTdd_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (arfcn().is_bound()) arfcn().set_implicit_omit();
if (bandwidth__presence().is_bound()) bandwidth__presence().set_implicit_omit();
if (!bandwidth().is_bound()) bandwidth() = OMIT_VALUE;
else bandwidth().set_implicit_omit();
if (cell__parameter().is_bound()) cell__parameter().set_implicit_omit();
if (sync__case().is_bound()) sync__case().set_implicit_omit();
}

void UtranTargetCellTdd_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_arfcn.encode_text(text_buf);
single_value->field_bandwidth__presence.encode_text(text_buf);
single_value->field_bandwidth.encode_text(text_buf);
single_value->field_cell__parameter.encode_text(text_buf);
single_value->field_sync__case.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd.");
}
}

void UtranTargetCellTdd_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_arfcn.decode_text(text_buf);
single_value->field_bandwidth__presence.decode_text(text_buf);
single_value->field_bandwidth.decode_text(text_buf);
single_value->field_cell__parameter.decode_text(text_buf);
single_value->field_sync__case.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new UtranTargetCellTdd_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd.");
}
}

void UtranTargetCellTdd_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    UtranTargetCellTdd_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.UtranTargetCellTdd has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) arfcn().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) bandwidth__presence().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) bandwidth().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) cell__parameter().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) sync__case().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "arfcn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          arfcn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bandwidth_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bandwidth__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bandwidth")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bandwidth().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cell_parameter")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cell__parameter().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sync_case")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sync__case().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.UtranTargetCellTdd: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    UtranTargetCellTdd_template* precondition = new UtranTargetCellTdd_template;
    precondition->set_param(*param.get_elem(0));
    UtranTargetCellTdd_template* implied_template = new UtranTargetCellTdd_template;
    implied_template->set_param(*param.get_elem(1));
    *this = UtranTargetCellTdd_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.UtranTargetCellTdd");
  }
  is_ifpresent = param.get_ifpresent();
}

void UtranTargetCellTdd_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_arfcn.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.UtranTargetCellTdd");
single_value->field_bandwidth__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.UtranTargetCellTdd");
single_value->field_bandwidth.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.UtranTargetCellTdd");
single_value->field_cell__parameter.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.UtranTargetCellTdd");
single_value->field_sync__case.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.UtranTargetCellTdd");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.UtranTargetCellTdd");
}

boolean UtranTargetCellTdd_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean UtranTargetCellTdd_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

UtranTargetCell::UtranTargetCell()
{
}

UtranTargetCell::UtranTargetCell(const BITSTRING& par_fdd__presence,
    const OPTIONAL< UtranTargetCellFdd >& par_fdd,
    const BITSTRING& par_tdd__presence,
    const OPTIONAL< UtranTargetCellTdd >& par_tdd,
    const INTEGER& par_reporting__quantity)
  :   field_fdd__presence(par_fdd__presence),
  field_fdd(par_fdd),
  field_tdd__presence(par_tdd__presence),
  field_tdd(par_tdd),
  field_reporting__quantity(par_reporting__quantity)
{
}

UtranTargetCell::UtranTargetCell(const UtranTargetCell& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.UtranTargetCell.");
if (other_value.fdd__presence().is_bound()) field_fdd__presence = other_value.fdd__presence();
else field_fdd__presence.clean_up();
if (other_value.fdd().is_bound()) field_fdd = other_value.fdd();
else field_fdd.clean_up();
if (other_value.tdd__presence().is_bound()) field_tdd__presence = other_value.tdd__presence();
else field_tdd__presence.clean_up();
if (other_value.tdd().is_bound()) field_tdd = other_value.tdd();
else field_tdd.clean_up();
if (other_value.reporting__quantity().is_bound()) field_reporting__quantity = other_value.reporting__quantity();
else field_reporting__quantity.clean_up();
}

void UtranTargetCell::clean_up()
{
field_fdd__presence.clean_up();
field_fdd.clean_up();
field_tdd__presence.clean_up();
field_tdd.clean_up();
field_reporting__quantity.clean_up();
}

const TTCN_Typedescriptor_t* UtranTargetCell::get_descriptor() const { return &UtranTargetCell_descr_; }
UtranTargetCell& UtranTargetCell::operator=(const UtranTargetCell& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.UtranTargetCell.");
  if (other_value.fdd__presence().is_bound()) field_fdd__presence = other_value.fdd__presence();
  else field_fdd__presence.clean_up();
  if (other_value.fdd().is_bound()) field_fdd = other_value.fdd();
  else field_fdd.clean_up();
  if (other_value.tdd__presence().is_bound()) field_tdd__presence = other_value.tdd__presence();
  else field_tdd__presence.clean_up();
  if (other_value.tdd().is_bound()) field_tdd = other_value.tdd();
  else field_tdd.clean_up();
  if (other_value.reporting__quantity().is_bound()) field_reporting__quantity = other_value.reporting__quantity();
  else field_reporting__quantity.clean_up();
}
return *this;
}

boolean UtranTargetCell::operator==(const UtranTargetCell& other_value) const
{
return field_fdd__presence==other_value.field_fdd__presence
  && field_fdd==other_value.field_fdd
  && field_tdd__presence==other_value.field_tdd__presence
  && field_tdd==other_value.field_tdd
  && field_reporting__quantity==other_value.field_reporting__quantity;
}

boolean UtranTargetCell::is_bound() const
{
return (field_fdd__presence.is_bound())
  || (OPTIONAL_OMIT == field_fdd.get_selection() || field_fdd.is_bound())
  || (field_tdd__presence.is_bound())
  || (OPTIONAL_OMIT == field_tdd.get_selection() || field_tdd.is_bound())
  || (field_reporting__quantity.is_bound());
}
boolean UtranTargetCell::is_value() const
{
return field_fdd__presence.is_value()
  && (OPTIONAL_OMIT == field_fdd.get_selection() || field_fdd.is_value())
  && field_tdd__presence.is_value()
  && (OPTIONAL_OMIT == field_tdd.get_selection() || field_tdd.is_value())
  && field_reporting__quantity.is_value();
}
int UtranTargetCell::size_of() const
{
  int ret_val = 3;
  if (field_fdd.ispresent()) ret_val++;
  if (field_tdd.ispresent()) ret_val++;
  return ret_val;
}

void UtranTargetCell::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ fdd_presence := ");
field_fdd__presence.log();
TTCN_Logger::log_event_str(", fdd := ");
field_fdd.log();
TTCN_Logger::log_event_str(", tdd_presence := ");
field_tdd__presence.log();
TTCN_Logger::log_event_str(", tdd := ");
field_tdd.log();
TTCN_Logger::log_event_str(", reporting_quantity := ");
field_reporting__quantity.log();
TTCN_Logger::log_event_str(" }");
}

void UtranTargetCell::set_implicit_omit()
{
if (fdd__presence().is_bound()) fdd__presence().set_implicit_omit();
if (!fdd().is_bound()) fdd() = OMIT_VALUE;
else fdd().set_implicit_omit();
if (tdd__presence().is_bound()) tdd__presence().set_implicit_omit();
if (!tdd().is_bound()) tdd() = OMIT_VALUE;
else tdd().set_implicit_omit();
if (reporting__quantity().is_bound()) reporting__quantity().set_implicit_omit();
}

void UtranTargetCell::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.UtranTargetCell has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) fdd__presence().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) fdd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) tdd__presence().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) tdd().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) reporting__quantity().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "fdd_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          fdd__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "fdd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          fdd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tdd_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tdd__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tdd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tdd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_quantity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__quantity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.UtranTargetCell: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.UtranTargetCell");
  }
}

void UtranTargetCell::encode_text(Text_Buf& text_buf) const
{
field_fdd__presence.encode_text(text_buf);
field_fdd.encode_text(text_buf);
field_tdd__presence.encode_text(text_buf);
field_tdd.encode_text(text_buf);
field_reporting__quantity.encode_text(text_buf);
}

void UtranTargetCell::decode_text(Text_Buf& text_buf)
{
field_fdd__presence.decode_text(text_buf);
field_fdd.decode_text(text_buf);
field_tdd__presence.decode_text(text_buf);
field_tdd.decode_text(text_buf);
field_reporting__quantity.decode_text(text_buf);
}

void UtranTargetCell::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void UtranTargetCell::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int UtranTargetCell::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, UtranTargetCell_fdd__presence_descr_.raw->forceomit);
  decoded_field_length = field_fdd__presence.RAW_decode(UtranTargetCell_fdd__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_fdd__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_fdd = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, UtranTargetCell_fdd_descr_.raw->forceomit);
  decoded_field_length = field_fdd().RAW_decode(UtranTargetCell_fdd_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_fdd = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_fdd=OMIT_VALUE;
  RAW_Force_Omit field_2_force_omit(2, force_omit, UtranTargetCell_tdd__presence_descr_.raw->forceomit);
  decoded_field_length = field_tdd__presence.RAW_decode(UtranTargetCell_tdd__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_tdd__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_tdd = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, UtranTargetCell_tdd_descr_.raw->forceomit);
  decoded_field_length = field_tdd().RAW_decode(UtranTargetCell_tdd_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_tdd = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_tdd=OMIT_VALUE;
  RAW_Force_Omit field_4_force_omit(4, force_omit, UtranTargetCell_reporting__quantity_descr_.raw->forceomit);
  decoded_field_length = field_reporting__quantity.RAW_decode(UtranTargetCell_reporting__quantity_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int UtranTargetCell::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, UtranTargetCell_fdd__presence_descr_.raw);
  if (field_fdd.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, UtranTargetCell_fdd_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, UtranTargetCell_tdd__presence_descr_.raw);
  if (field_tdd.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, UtranTargetCell_tdd_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, UtranTargetCell_reporting__quantity_descr_.raw);
  encoded_length += field_fdd__presence.RAW_encode(UtranTargetCell_fdd__presence_descr_, *myleaf.body.node.nodes[0]);
  if (field_fdd.ispresent()) {
  encoded_length += field_fdd().RAW_encode(UtranTargetCell_fdd_descr_, *myleaf.body.node.nodes[1]);
  }
  encoded_length += field_tdd__presence.RAW_encode(UtranTargetCell_tdd__presence_descr_, *myleaf.body.node.nodes[2]);
  if (field_tdd.ispresent()) {
  encoded_length += field_tdd().RAW_encode(UtranTargetCell_tdd_descr_, *myleaf.body.node.nodes[3]);
  }
  encoded_length += field_reporting__quantity.RAW_encode(UtranTargetCell_reporting__quantity_descr_, *myleaf.body.node.nodes[4]);
  if (field_fdd.ispresent() && (field_fdd__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(UtranTargetCell_fdd__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_tdd.ispresent() && (field_tdd__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={2};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(UtranTargetCell_tdd__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct UtranTargetCell_template::single_value_struct {
BITSTRING_template field_fdd__presence;
UtranTargetCellFdd_template field_fdd;
BITSTRING_template field_tdd__presence;
UtranTargetCellTdd_template field_tdd;
INTEGER_template field_reporting__quantity;
};

void UtranTargetCell_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_fdd__presence = ANY_VALUE;
single_value->field_fdd = ANY_OR_OMIT;
single_value->field_tdd__presence = ANY_VALUE;
single_value->field_tdd = ANY_OR_OMIT;
single_value->field_reporting__quantity = ANY_VALUE;
}
}
}

void UtranTargetCell_template::copy_value(const UtranTargetCell& other_value)
{
single_value = new single_value_struct;
if (other_value.fdd__presence().is_bound()) {
  single_value->field_fdd__presence = other_value.fdd__presence();
} else {
  single_value->field_fdd__presence.clean_up();
}
if (other_value.fdd().is_bound()) {
  if (other_value.fdd().ispresent()) single_value->field_fdd = other_value.fdd()();
  else single_value->field_fdd = OMIT_VALUE;
} else {
  single_value->field_fdd.clean_up();
}
if (other_value.tdd__presence().is_bound()) {
  single_value->field_tdd__presence = other_value.tdd__presence();
} else {
  single_value->field_tdd__presence.clean_up();
}
if (other_value.tdd().is_bound()) {
  if (other_value.tdd().ispresent()) single_value->field_tdd = other_value.tdd()();
  else single_value->field_tdd = OMIT_VALUE;
} else {
  single_value->field_tdd.clean_up();
}
if (other_value.reporting__quantity().is_bound()) {
  single_value->field_reporting__quantity = other_value.reporting__quantity();
} else {
  single_value->field_reporting__quantity.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void UtranTargetCell_template::copy_template(const UtranTargetCell_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.fdd__presence().get_selection()) {
single_value->field_fdd__presence = other_value.fdd__presence();
} else {
single_value->field_fdd__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.fdd().get_selection()) {
single_value->field_fdd = other_value.fdd();
} else {
single_value->field_fdd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tdd__presence().get_selection()) {
single_value->field_tdd__presence = other_value.tdd__presence();
} else {
single_value->field_tdd__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tdd().get_selection()) {
single_value->field_tdd = other_value.tdd();
} else {
single_value->field_tdd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reporting__quantity().get_selection()) {
single_value->field_reporting__quantity = other_value.reporting__quantity();
} else {
single_value->field_reporting__quantity.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new UtranTargetCell_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new UtranTargetCell_template(*other_value.implication_.precondition);
implication_.implied_template = new UtranTargetCell_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranTargetCell.");
break;
}
set_selection(other_value);
}

UtranTargetCell_template::UtranTargetCell_template()
{
}

UtranTargetCell_template::UtranTargetCell_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

UtranTargetCell_template::UtranTargetCell_template(const UtranTargetCell& other_value)
{
copy_value(other_value);
}

UtranTargetCell_template::UtranTargetCell_template(const OPTIONAL<UtranTargetCell>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UtranTargetCell&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.UtranTargetCell from an unbound optional field.");
}
}

UtranTargetCell_template::UtranTargetCell_template(UtranTargetCell_template* p_precondition, UtranTargetCell_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

UtranTargetCell_template::UtranTargetCell_template(Dynamic_Match_Interface<UtranTargetCell>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<UtranTargetCell>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

UtranTargetCell_template::UtranTargetCell_template(const UtranTargetCell_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

UtranTargetCell_template::~UtranTargetCell_template()
{
clean_up();
}

UtranTargetCell_template& UtranTargetCell_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

UtranTargetCell_template& UtranTargetCell_template::operator=(const UtranTargetCell& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

UtranTargetCell_template& UtranTargetCell_template::operator=(const OPTIONAL<UtranTargetCell>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UtranTargetCell&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.UtranTargetCell.");
}
return *this;
}

UtranTargetCell_template& UtranTargetCell_template::operator=(const UtranTargetCell_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean UtranTargetCell_template::match(const UtranTargetCell& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.fdd__presence().is_bound()) return FALSE;
if(!single_value->field_fdd__presence.match(other_value.fdd__presence(), legacy))return FALSE;
if(!other_value.fdd().is_bound()) return FALSE;
if((other_value.fdd().ispresent() ? !single_value->field_fdd.match((const UtranTargetCellFdd&)other_value.fdd(), legacy) : !single_value->field_fdd.match_omit(legacy)))return FALSE;
if(!other_value.tdd__presence().is_bound()) return FALSE;
if(!single_value->field_tdd__presence.match(other_value.tdd__presence(), legacy))return FALSE;
if(!other_value.tdd().is_bound()) return FALSE;
if((other_value.tdd().ispresent() ? !single_value->field_tdd.match((const UtranTargetCellTdd&)other_value.tdd(), legacy) : !single_value->field_tdd.match_omit(legacy)))return FALSE;
if(!other_value.reporting__quantity().is_bound()) return FALSE;
if(!single_value->field_reporting__quantity.match(other_value.reporting__quantity(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranTargetCell.");
}
return FALSE;
}

boolean UtranTargetCell_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_fdd__presence.is_bound()
 || (single_value->field_fdd.is_omit() || single_value->field_fdd.is_bound())
 || single_value->field_tdd__presence.is_bound()
 || (single_value->field_tdd.is_omit() || single_value->field_tdd.is_bound())
 || single_value->field_reporting__quantity.is_bound();
}

boolean UtranTargetCell_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_fdd__presence.is_value()
 && (single_value->field_fdd.is_omit() || single_value->field_fdd.is_value())
 && single_value->field_tdd__presence.is_value()
 && (single_value->field_tdd.is_omit() || single_value->field_tdd.is_value())
 && single_value->field_reporting__quantity.is_value();
}

void UtranTargetCell_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

UtranTargetCell UtranTargetCell_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.UtranTargetCell.");
UtranTargetCell ret_val;
if (single_value->field_fdd__presence.is_bound()) {
ret_val.fdd__presence() = single_value->field_fdd__presence.valueof();
}
if (single_value->field_fdd.is_omit()) ret_val.fdd() = OMIT_VALUE;
else if (single_value->field_fdd.is_bound()) {
ret_val.fdd() = single_value->field_fdd.valueof();
}
if (single_value->field_tdd__presence.is_bound()) {
ret_val.tdd__presence() = single_value->field_tdd__presence.valueof();
}
if (single_value->field_tdd.is_omit()) ret_val.tdd() = OMIT_VALUE;
else if (single_value->field_tdd.is_bound()) {
ret_val.tdd() = single_value->field_tdd.valueof();
}
if (single_value->field_reporting__quantity.is_bound()) {
ret_val.reporting__quantity() = single_value->field_reporting__quantity.valueof();
}
return ret_val;
}

void UtranTargetCell_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.UtranTargetCell.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new UtranTargetCell_template[list_length];
}

UtranTargetCell_template& UtranTargetCell_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.UtranTargetCell.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.UtranTargetCell.");
return value_list.list_value[list_index];
}

BITSTRING_template& UtranTargetCell_template::fdd__presence()
{
set_specific();
return single_value->field_fdd__presence;
}

const BITSTRING_template& UtranTargetCell_template::fdd__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field fdd_presence of a non-specific template of type @RLCMAC_CSN1_Types.UtranTargetCell.");
return single_value->field_fdd__presence;
}

UtranTargetCellFdd_template& UtranTargetCell_template::fdd()
{
set_specific();
return single_value->field_fdd;
}

const UtranTargetCellFdd_template& UtranTargetCell_template::fdd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field fdd of a non-specific template of type @RLCMAC_CSN1_Types.UtranTargetCell.");
return single_value->field_fdd;
}

BITSTRING_template& UtranTargetCell_template::tdd__presence()
{
set_specific();
return single_value->field_tdd__presence;
}

const BITSTRING_template& UtranTargetCell_template::tdd__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tdd_presence of a non-specific template of type @RLCMAC_CSN1_Types.UtranTargetCell.");
return single_value->field_tdd__presence;
}

UtranTargetCellTdd_template& UtranTargetCell_template::tdd()
{
set_specific();
return single_value->field_tdd;
}

const UtranTargetCellTdd_template& UtranTargetCell_template::tdd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tdd of a non-specific template of type @RLCMAC_CSN1_Types.UtranTargetCell.");
return single_value->field_tdd;
}

INTEGER_template& UtranTargetCell_template::reporting__quantity()
{
set_specific();
return single_value->field_reporting__quantity;
}

const INTEGER_template& UtranTargetCell_template::reporting__quantity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reporting_quantity of a non-specific template of type @RLCMAC_CSN1_Types.UtranTargetCell.");
return single_value->field_reporting__quantity;
}

int UtranTargetCell_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCell which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 3;
      if (single_value->field_fdd.is_present()) ret_val++;
      if (single_value->field_tdd.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCell containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCell containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCell containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCell containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCell containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCell containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCell containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranTargetCell containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranTargetCell.");
  }
  return 0;
}

void UtranTargetCell_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ fdd_presence := ");
single_value->field_fdd__presence.log();
TTCN_Logger::log_event_str(", fdd := ");
single_value->field_fdd.log();
TTCN_Logger::log_event_str(", tdd_presence := ");
single_value->field_tdd__presence.log();
TTCN_Logger::log_event_str(", tdd := ");
single_value->field_tdd.log();
TTCN_Logger::log_event_str(", reporting_quantity := ");
single_value->field_reporting__quantity.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void UtranTargetCell_template::log_match(const UtranTargetCell& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_fdd__presence.match(match_value.fdd__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".fdd_presence");
single_value->field_fdd__presence.log_match(match_value.fdd__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.fdd().ispresent()){
if(!single_value->field_fdd.match(match_value.fdd(), legacy)){
TTCN_Logger::log_logmatch_info(".fdd");
single_value->field_fdd.log_match(match_value.fdd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_fdd.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".fdd := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_fdd.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_tdd__presence.match(match_value.tdd__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".tdd_presence");
single_value->field_tdd__presence.log_match(match_value.tdd__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.tdd().ispresent()){
if(!single_value->field_tdd.match(match_value.tdd(), legacy)){
TTCN_Logger::log_logmatch_info(".tdd");
single_value->field_tdd.log_match(match_value.tdd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_tdd.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".tdd := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_tdd.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_reporting__quantity.match(match_value.reporting__quantity(), legacy)){
TTCN_Logger::log_logmatch_info(".reporting_quantity");
single_value->field_reporting__quantity.log_match(match_value.reporting__quantity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ fdd_presence := ");
single_value->field_fdd__presence.log_match(match_value.fdd__presence(), legacy);
TTCN_Logger::log_event_str(", fdd := ");
if (match_value.fdd().ispresent()) {
single_value->field_fdd.log_match(match_value.fdd(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_fdd.log();
if (single_value->field_fdd.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", tdd_presence := ");
single_value->field_tdd__presence.log_match(match_value.tdd__presence(), legacy);
TTCN_Logger::log_event_str(", tdd := ");
if (match_value.tdd().ispresent()) {
single_value->field_tdd.log_match(match_value.tdd(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_tdd.log();
if (single_value->field_tdd.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", reporting_quantity := ");
single_value->field_reporting__quantity.log_match(match_value.reporting__quantity(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void UtranTargetCell_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (fdd__presence().is_bound()) fdd__presence().set_implicit_omit();
if (!fdd().is_bound()) fdd() = OMIT_VALUE;
else fdd().set_implicit_omit();
if (tdd__presence().is_bound()) tdd__presence().set_implicit_omit();
if (!tdd().is_bound()) tdd() = OMIT_VALUE;
else tdd().set_implicit_omit();
if (reporting__quantity().is_bound()) reporting__quantity().set_implicit_omit();
}

void UtranTargetCell_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_fdd__presence.encode_text(text_buf);
single_value->field_fdd.encode_text(text_buf);
single_value->field_tdd__presence.encode_text(text_buf);
single_value->field_tdd.encode_text(text_buf);
single_value->field_reporting__quantity.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranTargetCell.");
}
}

void UtranTargetCell_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_fdd__presence.decode_text(text_buf);
single_value->field_fdd.decode_text(text_buf);
single_value->field_tdd__presence.decode_text(text_buf);
single_value->field_tdd.decode_text(text_buf);
single_value->field_reporting__quantity.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new UtranTargetCell_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.UtranTargetCell.");
}
}

void UtranTargetCell_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    UtranTargetCell_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.UtranTargetCell has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) fdd__presence().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) fdd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) tdd__presence().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) tdd().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) reporting__quantity().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "fdd_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          fdd__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "fdd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          fdd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tdd_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tdd__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tdd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tdd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_quantity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__quantity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.UtranTargetCell: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    UtranTargetCell_template* precondition = new UtranTargetCell_template;
    precondition->set_param(*param.get_elem(0));
    UtranTargetCell_template* implied_template = new UtranTargetCell_template;
    implied_template->set_param(*param.get_elem(1));
    *this = UtranTargetCell_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.UtranTargetCell");
  }
  is_ifpresent = param.get_ifpresent();
}

void UtranTargetCell_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_fdd__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.UtranTargetCell");
single_value->field_fdd.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.UtranTargetCell");
single_value->field_tdd__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.UtranTargetCell");
single_value->field_tdd.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.UtranTargetCell");
single_value->field_reporting__quantity.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.UtranTargetCell");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.UtranTargetCell");
}

boolean UtranTargetCell_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean UtranTargetCell_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

EutranTargetCell::EutranTargetCell()
{
}

EutranTargetCell::EutranTargetCell(const INTEGER& par_earfcn,
    const BITSTRING& par_meas__bandwidth__presence,
    const OPTIONAL< INTEGER >& par_meas__bandwidth,
    const INTEGER& par_phys__layer__cell__id,
    const INTEGER& par_reporting__quantity)
  :   field_earfcn(par_earfcn),
  field_meas__bandwidth__presence(par_meas__bandwidth__presence),
  field_meas__bandwidth(par_meas__bandwidth),
  field_phys__layer__cell__id(par_phys__layer__cell__id),
  field_reporting__quantity(par_reporting__quantity)
{
}

EutranTargetCell::EutranTargetCell(const EutranTargetCell& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.EutranTargetCell.");
if (other_value.earfcn().is_bound()) field_earfcn = other_value.earfcn();
else field_earfcn.clean_up();
if (other_value.meas__bandwidth__presence().is_bound()) field_meas__bandwidth__presence = other_value.meas__bandwidth__presence();
else field_meas__bandwidth__presence.clean_up();
if (other_value.meas__bandwidth().is_bound()) field_meas__bandwidth = other_value.meas__bandwidth();
else field_meas__bandwidth.clean_up();
if (other_value.phys__layer__cell__id().is_bound()) field_phys__layer__cell__id = other_value.phys__layer__cell__id();
else field_phys__layer__cell__id.clean_up();
if (other_value.reporting__quantity().is_bound()) field_reporting__quantity = other_value.reporting__quantity();
else field_reporting__quantity.clean_up();
}

void EutranTargetCell::clean_up()
{
field_earfcn.clean_up();
field_meas__bandwidth__presence.clean_up();
field_meas__bandwidth.clean_up();
field_phys__layer__cell__id.clean_up();
field_reporting__quantity.clean_up();
}

const TTCN_Typedescriptor_t* EutranTargetCell::get_descriptor() const { return &EutranTargetCell_descr_; }
EutranTargetCell& EutranTargetCell::operator=(const EutranTargetCell& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.EutranTargetCell.");
  if (other_value.earfcn().is_bound()) field_earfcn = other_value.earfcn();
  else field_earfcn.clean_up();
  if (other_value.meas__bandwidth__presence().is_bound()) field_meas__bandwidth__presence = other_value.meas__bandwidth__presence();
  else field_meas__bandwidth__presence.clean_up();
  if (other_value.meas__bandwidth().is_bound()) field_meas__bandwidth = other_value.meas__bandwidth();
  else field_meas__bandwidth.clean_up();
  if (other_value.phys__layer__cell__id().is_bound()) field_phys__layer__cell__id = other_value.phys__layer__cell__id();
  else field_phys__layer__cell__id.clean_up();
  if (other_value.reporting__quantity().is_bound()) field_reporting__quantity = other_value.reporting__quantity();
  else field_reporting__quantity.clean_up();
}
return *this;
}

boolean EutranTargetCell::operator==(const EutranTargetCell& other_value) const
{
return field_earfcn==other_value.field_earfcn
  && field_meas__bandwidth__presence==other_value.field_meas__bandwidth__presence
  && field_meas__bandwidth==other_value.field_meas__bandwidth
  && field_phys__layer__cell__id==other_value.field_phys__layer__cell__id
  && field_reporting__quantity==other_value.field_reporting__quantity;
}

boolean EutranTargetCell::is_bound() const
{
return (field_earfcn.is_bound())
  || (field_meas__bandwidth__presence.is_bound())
  || (OPTIONAL_OMIT == field_meas__bandwidth.get_selection() || field_meas__bandwidth.is_bound())
  || (field_phys__layer__cell__id.is_bound())
  || (field_reporting__quantity.is_bound());
}
boolean EutranTargetCell::is_value() const
{
return field_earfcn.is_value()
  && field_meas__bandwidth__presence.is_value()
  && (OPTIONAL_OMIT == field_meas__bandwidth.get_selection() || field_meas__bandwidth.is_value())
  && field_phys__layer__cell__id.is_value()
  && field_reporting__quantity.is_value();
}
int EutranTargetCell::size_of() const
{
  int ret_val = 4;
  if (field_meas__bandwidth.ispresent()) ret_val++;
  return ret_val;
}

void EutranTargetCell::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ earfcn := ");
field_earfcn.log();
TTCN_Logger::log_event_str(", meas_bandwidth_presence := ");
field_meas__bandwidth__presence.log();
TTCN_Logger::log_event_str(", meas_bandwidth := ");
field_meas__bandwidth.log();
TTCN_Logger::log_event_str(", phys_layer_cell_id := ");
field_phys__layer__cell__id.log();
TTCN_Logger::log_event_str(", reporting_quantity := ");
field_reporting__quantity.log();
TTCN_Logger::log_event_str(" }");
}

void EutranTargetCell::set_implicit_omit()
{
if (earfcn().is_bound()) earfcn().set_implicit_omit();
if (meas__bandwidth__presence().is_bound()) meas__bandwidth__presence().set_implicit_omit();
if (!meas__bandwidth().is_bound()) meas__bandwidth() = OMIT_VALUE;
else meas__bandwidth().set_implicit_omit();
if (phys__layer__cell__id().is_bound()) phys__layer__cell__id().set_implicit_omit();
if (reporting__quantity().is_bound()) reporting__quantity().set_implicit_omit();
}

void EutranTargetCell::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.EutranTargetCell has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) earfcn().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) meas__bandwidth__presence().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) meas__bandwidth().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) phys__layer__cell__id().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) reporting__quantity().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "earfcn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          earfcn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "meas_bandwidth_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          meas__bandwidth__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "meas_bandwidth")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          meas__bandwidth().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "phys_layer_cell_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          phys__layer__cell__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_quantity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__quantity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.EutranTargetCell: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.EutranTargetCell");
  }
}

void EutranTargetCell::encode_text(Text_Buf& text_buf) const
{
field_earfcn.encode_text(text_buf);
field_meas__bandwidth__presence.encode_text(text_buf);
field_meas__bandwidth.encode_text(text_buf);
field_phys__layer__cell__id.encode_text(text_buf);
field_reporting__quantity.encode_text(text_buf);
}

void EutranTargetCell::decode_text(Text_Buf& text_buf)
{
field_earfcn.decode_text(text_buf);
field_meas__bandwidth__presence.decode_text(text_buf);
field_meas__bandwidth.decode_text(text_buf);
field_phys__layer__cell__id.decode_text(text_buf);
field_reporting__quantity.decode_text(text_buf);
}

void EutranTargetCell::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void EutranTargetCell::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int EutranTargetCell::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, EutranTargetCell_earfcn_descr_.raw->forceomit);
  decoded_field_length = field_earfcn.RAW_decode(EutranTargetCell_earfcn_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, EutranTargetCell_meas__bandwidth__presence_descr_.raw->forceomit);
  decoded_field_length = field_meas__bandwidth__presence.RAW_decode(EutranTargetCell_meas__bandwidth__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_meas__bandwidth__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_meas__bandwidth = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, EutranTargetCell_meas__bandwidth_descr_.raw->forceomit);
  decoded_field_length = field_meas__bandwidth().RAW_decode(EutranTargetCell_meas__bandwidth_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_meas__bandwidth = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_meas__bandwidth=OMIT_VALUE;
  RAW_Force_Omit field_3_force_omit(3, force_omit, EutranTargetCell_phys__layer__cell__id_descr_.raw->forceomit);
  decoded_field_length = field_phys__layer__cell__id.RAW_decode(EutranTargetCell_phys__layer__cell__id_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, EutranTargetCell_reporting__quantity_descr_.raw->forceomit);
  decoded_field_length = field_reporting__quantity.RAW_decode(EutranTargetCell_reporting__quantity_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int EutranTargetCell::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, EutranTargetCell_earfcn_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, EutranTargetCell_meas__bandwidth__presence_descr_.raw);
  if (field_meas__bandwidth.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, EutranTargetCell_meas__bandwidth_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, EutranTargetCell_phys__layer__cell__id_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, EutranTargetCell_reporting__quantity_descr_.raw);
  encoded_length += field_earfcn.RAW_encode(EutranTargetCell_earfcn_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_meas__bandwidth__presence.RAW_encode(EutranTargetCell_meas__bandwidth__presence_descr_, *myleaf.body.node.nodes[1]);
  if (field_meas__bandwidth.ispresent()) {
  encoded_length += field_meas__bandwidth().RAW_encode(EutranTargetCell_meas__bandwidth_descr_, *myleaf.body.node.nodes[2]);
  }
  encoded_length += field_phys__layer__cell__id.RAW_encode(EutranTargetCell_phys__layer__cell__id_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_reporting__quantity.RAW_encode(EutranTargetCell_reporting__quantity_descr_, *myleaf.body.node.nodes[4]);
  if (field_meas__bandwidth.ispresent() && (field_meas__bandwidth__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={1};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(EutranTargetCell_meas__bandwidth__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct EutranTargetCell_template::single_value_struct {
INTEGER_template field_earfcn;
BITSTRING_template field_meas__bandwidth__presence;
INTEGER_template field_meas__bandwidth;
INTEGER_template field_phys__layer__cell__id;
INTEGER_template field_reporting__quantity;
};

void EutranTargetCell_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_earfcn = ANY_VALUE;
single_value->field_meas__bandwidth__presence = ANY_VALUE;
single_value->field_meas__bandwidth = ANY_OR_OMIT;
single_value->field_phys__layer__cell__id = ANY_VALUE;
single_value->field_reporting__quantity = ANY_VALUE;
}
}
}

void EutranTargetCell_template::copy_value(const EutranTargetCell& other_value)
{
single_value = new single_value_struct;
if (other_value.earfcn().is_bound()) {
  single_value->field_earfcn = other_value.earfcn();
} else {
  single_value->field_earfcn.clean_up();
}
if (other_value.meas__bandwidth__presence().is_bound()) {
  single_value->field_meas__bandwidth__presence = other_value.meas__bandwidth__presence();
} else {
  single_value->field_meas__bandwidth__presence.clean_up();
}
if (other_value.meas__bandwidth().is_bound()) {
  if (other_value.meas__bandwidth().ispresent()) single_value->field_meas__bandwidth = other_value.meas__bandwidth()();
  else single_value->field_meas__bandwidth = OMIT_VALUE;
} else {
  single_value->field_meas__bandwidth.clean_up();
}
if (other_value.phys__layer__cell__id().is_bound()) {
  single_value->field_phys__layer__cell__id = other_value.phys__layer__cell__id();
} else {
  single_value->field_phys__layer__cell__id.clean_up();
}
if (other_value.reporting__quantity().is_bound()) {
  single_value->field_reporting__quantity = other_value.reporting__quantity();
} else {
  single_value->field_reporting__quantity.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void EutranTargetCell_template::copy_template(const EutranTargetCell_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.earfcn().get_selection()) {
single_value->field_earfcn = other_value.earfcn();
} else {
single_value->field_earfcn.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.meas__bandwidth__presence().get_selection()) {
single_value->field_meas__bandwidth__presence = other_value.meas__bandwidth__presence();
} else {
single_value->field_meas__bandwidth__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.meas__bandwidth().get_selection()) {
single_value->field_meas__bandwidth = other_value.meas__bandwidth();
} else {
single_value->field_meas__bandwidth.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.phys__layer__cell__id().get_selection()) {
single_value->field_phys__layer__cell__id = other_value.phys__layer__cell__id();
} else {
single_value->field_phys__layer__cell__id.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reporting__quantity().get_selection()) {
single_value->field_reporting__quantity = other_value.reporting__quantity();
} else {
single_value->field_reporting__quantity.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new EutranTargetCell_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new EutranTargetCell_template(*other_value.implication_.precondition);
implication_.implied_template = new EutranTargetCell_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EutranTargetCell.");
break;
}
set_selection(other_value);
}

EutranTargetCell_template::EutranTargetCell_template()
{
}

EutranTargetCell_template::EutranTargetCell_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

EutranTargetCell_template::EutranTargetCell_template(const EutranTargetCell& other_value)
{
copy_value(other_value);
}

EutranTargetCell_template::EutranTargetCell_template(const OPTIONAL<EutranTargetCell>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EutranTargetCell&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.EutranTargetCell from an unbound optional field.");
}
}

EutranTargetCell_template::EutranTargetCell_template(EutranTargetCell_template* p_precondition, EutranTargetCell_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

EutranTargetCell_template::EutranTargetCell_template(Dynamic_Match_Interface<EutranTargetCell>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<EutranTargetCell>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

EutranTargetCell_template::EutranTargetCell_template(const EutranTargetCell_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

EutranTargetCell_template::~EutranTargetCell_template()
{
clean_up();
}

EutranTargetCell_template& EutranTargetCell_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

EutranTargetCell_template& EutranTargetCell_template::operator=(const EutranTargetCell& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

EutranTargetCell_template& EutranTargetCell_template::operator=(const OPTIONAL<EutranTargetCell>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EutranTargetCell&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.EutranTargetCell.");
}
return *this;
}

EutranTargetCell_template& EutranTargetCell_template::operator=(const EutranTargetCell_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean EutranTargetCell_template::match(const EutranTargetCell& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.earfcn().is_bound()) return FALSE;
if(!single_value->field_earfcn.match(other_value.earfcn(), legacy))return FALSE;
if(!other_value.meas__bandwidth__presence().is_bound()) return FALSE;
if(!single_value->field_meas__bandwidth__presence.match(other_value.meas__bandwidth__presence(), legacy))return FALSE;
if(!other_value.meas__bandwidth().is_bound()) return FALSE;
if((other_value.meas__bandwidth().ispresent() ? !single_value->field_meas__bandwidth.match((const INTEGER&)other_value.meas__bandwidth(), legacy) : !single_value->field_meas__bandwidth.match_omit(legacy)))return FALSE;
if(!other_value.phys__layer__cell__id().is_bound()) return FALSE;
if(!single_value->field_phys__layer__cell__id.match(other_value.phys__layer__cell__id(), legacy))return FALSE;
if(!other_value.reporting__quantity().is_bound()) return FALSE;
if(!single_value->field_reporting__quantity.match(other_value.reporting__quantity(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EutranTargetCell.");
}
return FALSE;
}

boolean EutranTargetCell_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_earfcn.is_bound()
 || single_value->field_meas__bandwidth__presence.is_bound()
 || (single_value->field_meas__bandwidth.is_omit() || single_value->field_meas__bandwidth.is_bound())
 || single_value->field_phys__layer__cell__id.is_bound()
 || single_value->field_reporting__quantity.is_bound();
}

boolean EutranTargetCell_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_earfcn.is_value()
 && single_value->field_meas__bandwidth__presence.is_value()
 && (single_value->field_meas__bandwidth.is_omit() || single_value->field_meas__bandwidth.is_value())
 && single_value->field_phys__layer__cell__id.is_value()
 && single_value->field_reporting__quantity.is_value();
}

void EutranTargetCell_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

EutranTargetCell EutranTargetCell_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.EutranTargetCell.");
EutranTargetCell ret_val;
if (single_value->field_earfcn.is_bound()) {
ret_val.earfcn() = single_value->field_earfcn.valueof();
}
if (single_value->field_meas__bandwidth__presence.is_bound()) {
ret_val.meas__bandwidth__presence() = single_value->field_meas__bandwidth__presence.valueof();
}
if (single_value->field_meas__bandwidth.is_omit()) ret_val.meas__bandwidth() = OMIT_VALUE;
else if (single_value->field_meas__bandwidth.is_bound()) {
ret_val.meas__bandwidth() = single_value->field_meas__bandwidth.valueof();
}
if (single_value->field_phys__layer__cell__id.is_bound()) {
ret_val.phys__layer__cell__id() = single_value->field_phys__layer__cell__id.valueof();
}
if (single_value->field_reporting__quantity.is_bound()) {
ret_val.reporting__quantity() = single_value->field_reporting__quantity.valueof();
}
return ret_val;
}

void EutranTargetCell_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.EutranTargetCell.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new EutranTargetCell_template[list_length];
}

EutranTargetCell_template& EutranTargetCell_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.EutranTargetCell.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.EutranTargetCell.");
return value_list.list_value[list_index];
}

INTEGER_template& EutranTargetCell_template::earfcn()
{
set_specific();
return single_value->field_earfcn;
}

const INTEGER_template& EutranTargetCell_template::earfcn() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field earfcn of a non-specific template of type @RLCMAC_CSN1_Types.EutranTargetCell.");
return single_value->field_earfcn;
}

BITSTRING_template& EutranTargetCell_template::meas__bandwidth__presence()
{
set_specific();
return single_value->field_meas__bandwidth__presence;
}

const BITSTRING_template& EutranTargetCell_template::meas__bandwidth__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field meas_bandwidth_presence of a non-specific template of type @RLCMAC_CSN1_Types.EutranTargetCell.");
return single_value->field_meas__bandwidth__presence;
}

INTEGER_template& EutranTargetCell_template::meas__bandwidth()
{
set_specific();
return single_value->field_meas__bandwidth;
}

const INTEGER_template& EutranTargetCell_template::meas__bandwidth() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field meas_bandwidth of a non-specific template of type @RLCMAC_CSN1_Types.EutranTargetCell.");
return single_value->field_meas__bandwidth;
}

INTEGER_template& EutranTargetCell_template::phys__layer__cell__id()
{
set_specific();
return single_value->field_phys__layer__cell__id;
}

const INTEGER_template& EutranTargetCell_template::phys__layer__cell__id() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field phys_layer_cell_id of a non-specific template of type @RLCMAC_CSN1_Types.EutranTargetCell.");
return single_value->field_phys__layer__cell__id;
}

INTEGER_template& EutranTargetCell_template::reporting__quantity()
{
set_specific();
return single_value->field_reporting__quantity;
}

const INTEGER_template& EutranTargetCell_template::reporting__quantity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reporting_quantity of a non-specific template of type @RLCMAC_CSN1_Types.EutranTargetCell.");
return single_value->field_reporting__quantity;
}

int EutranTargetCell_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranTargetCell which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 4;
      if (single_value->field_meas__bandwidth.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranTargetCell containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranTargetCell containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranTargetCell containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranTargetCell containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranTargetCell containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranTargetCell containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranTargetCell containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranTargetCell containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EutranTargetCell.");
  }
  return 0;
}

void EutranTargetCell_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ earfcn := ");
single_value->field_earfcn.log();
TTCN_Logger::log_event_str(", meas_bandwidth_presence := ");
single_value->field_meas__bandwidth__presence.log();
TTCN_Logger::log_event_str(", meas_bandwidth := ");
single_value->field_meas__bandwidth.log();
TTCN_Logger::log_event_str(", phys_layer_cell_id := ");
single_value->field_phys__layer__cell__id.log();
TTCN_Logger::log_event_str(", reporting_quantity := ");
single_value->field_reporting__quantity.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void EutranTargetCell_template::log_match(const EutranTargetCell& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_earfcn.match(match_value.earfcn(), legacy)){
TTCN_Logger::log_logmatch_info(".earfcn");
single_value->field_earfcn.log_match(match_value.earfcn(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_meas__bandwidth__presence.match(match_value.meas__bandwidth__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".meas_bandwidth_presence");
single_value->field_meas__bandwidth__presence.log_match(match_value.meas__bandwidth__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.meas__bandwidth().ispresent()){
if(!single_value->field_meas__bandwidth.match(match_value.meas__bandwidth(), legacy)){
TTCN_Logger::log_logmatch_info(".meas_bandwidth");
single_value->field_meas__bandwidth.log_match(match_value.meas__bandwidth(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_meas__bandwidth.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".meas_bandwidth := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_meas__bandwidth.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_phys__layer__cell__id.match(match_value.phys__layer__cell__id(), legacy)){
TTCN_Logger::log_logmatch_info(".phys_layer_cell_id");
single_value->field_phys__layer__cell__id.log_match(match_value.phys__layer__cell__id(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reporting__quantity.match(match_value.reporting__quantity(), legacy)){
TTCN_Logger::log_logmatch_info(".reporting_quantity");
single_value->field_reporting__quantity.log_match(match_value.reporting__quantity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ earfcn := ");
single_value->field_earfcn.log_match(match_value.earfcn(), legacy);
TTCN_Logger::log_event_str(", meas_bandwidth_presence := ");
single_value->field_meas__bandwidth__presence.log_match(match_value.meas__bandwidth__presence(), legacy);
TTCN_Logger::log_event_str(", meas_bandwidth := ");
if (match_value.meas__bandwidth().ispresent()) {
single_value->field_meas__bandwidth.log_match(match_value.meas__bandwidth(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_meas__bandwidth.log();
if (single_value->field_meas__bandwidth.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", phys_layer_cell_id := ");
single_value->field_phys__layer__cell__id.log_match(match_value.phys__layer__cell__id(), legacy);
TTCN_Logger::log_event_str(", reporting_quantity := ");
single_value->field_reporting__quantity.log_match(match_value.reporting__quantity(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void EutranTargetCell_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (earfcn().is_bound()) earfcn().set_implicit_omit();
if (meas__bandwidth__presence().is_bound()) meas__bandwidth__presence().set_implicit_omit();
if (!meas__bandwidth().is_bound()) meas__bandwidth() = OMIT_VALUE;
else meas__bandwidth().set_implicit_omit();
if (phys__layer__cell__id().is_bound()) phys__layer__cell__id().set_implicit_omit();
if (reporting__quantity().is_bound()) reporting__quantity().set_implicit_omit();
}

void EutranTargetCell_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_earfcn.encode_text(text_buf);
single_value->field_meas__bandwidth__presence.encode_text(text_buf);
single_value->field_meas__bandwidth.encode_text(text_buf);
single_value->field_phys__layer__cell__id.encode_text(text_buf);
single_value->field_reporting__quantity.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EutranTargetCell.");
}
}

void EutranTargetCell_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_earfcn.decode_text(text_buf);
single_value->field_meas__bandwidth__presence.decode_text(text_buf);
single_value->field_meas__bandwidth.decode_text(text_buf);
single_value->field_phys__layer__cell__id.decode_text(text_buf);
single_value->field_reporting__quantity.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new EutranTargetCell_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.EutranTargetCell.");
}
}

void EutranTargetCell_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    EutranTargetCell_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.EutranTargetCell has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) earfcn().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) meas__bandwidth__presence().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) meas__bandwidth().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) phys__layer__cell__id().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) reporting__quantity().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "earfcn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          earfcn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "meas_bandwidth_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          meas__bandwidth__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "meas_bandwidth")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          meas__bandwidth().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "phys_layer_cell_id")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          phys__layer__cell__id().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_quantity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__quantity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.EutranTargetCell: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    EutranTargetCell_template* precondition = new EutranTargetCell_template;
    precondition->set_param(*param.get_elem(0));
    EutranTargetCell_template* implied_template = new EutranTargetCell_template;
    implied_template->set_param(*param.get_elem(1));
    *this = EutranTargetCell_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.EutranTargetCell");
  }
  is_ifpresent = param.get_ifpresent();
}

void EutranTargetCell_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_earfcn.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EutranTargetCell");
single_value->field_meas__bandwidth__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EutranTargetCell");
single_value->field_meas__bandwidth.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EutranTargetCell");
single_value->field_phys__layer__cell__id.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EutranTargetCell");
single_value->field_reporting__quantity.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EutranTargetCell");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.EutranTargetCell");
}

boolean EutranTargetCell_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean EutranTargetCell_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const UtranCCNMeasReportItem UtranReportingQuantityList::UNBOUND_ELEM;
UtranReportingQuantityList::UtranReportingQuantityList()
{
val_ptr = NULL;
}

UtranReportingQuantityList::UtranReportingQuantityList(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

UtranReportingQuantityList::UtranReportingQuantityList(const UtranReportingQuantityList& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

UtranReportingQuantityList::~UtranReportingQuantityList()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void UtranReportingQuantityList::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

UtranReportingQuantityList& UtranReportingQuantityList::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

UtranReportingQuantityList& UtranReportingQuantityList::operator=(const UtranReportingQuantityList& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean UtranReportingQuantityList::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
return val_ptr->n_elements == 0 ;
}

boolean UtranReportingQuantityList::operator==(const UtranReportingQuantityList& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

UtranCCNMeasReportItem& UtranReportingQuantityList::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @RLCMAC_CSN1_Types.UtranReportingQuantityList using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (UtranCCNMeasReportItem**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new UtranCCNMeasReportItem(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new UtranCCNMeasReportItem;
}
return *val_ptr->value_elements[index_value];
}

UtranCCNMeasReportItem& UtranReportingQuantityList::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
return (*this)[(int)index_value];
}

const UtranCCNMeasReportItem& UtranReportingQuantityList::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
if (index_value < 0) TTCN_error("Accessing an element of type @RLCMAC_CSN1_Types.UtranReportingQuantityList using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @RLCMAC_CSN1_Types.UtranReportingQuantityList: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const UtranCCNMeasReportItem& UtranReportingQuantityList::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
return (*this)[(int)index_value];
}

UtranReportingQuantityList UtranReportingQuantityList::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

UtranReportingQuantityList UtranReportingQuantityList::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

UtranReportingQuantityList UtranReportingQuantityList::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

UtranReportingQuantityList UtranReportingQuantityList::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
UtranReportingQuantityList ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new UtranCCNMeasReportItem(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

UtranReportingQuantityList UtranReportingQuantityList::operator+(const UtranReportingQuantityList& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @RLCMAC_CSN1_Types.UtranReportingQuantityList concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
UtranReportingQuantityList ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new UtranCCNMeasReportItem(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new UtranCCNMeasReportItem(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

UtranReportingQuantityList UtranReportingQuantityList::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@RLCMAC_CSN1_Types.UtranReportingQuantityList","element");
UtranReportingQuantityList ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new UtranCCNMeasReportItem(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

UtranReportingQuantityList UtranReportingQuantityList::replace(int index, int len, const UtranReportingQuantityList& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
check_replace_arguments(val_ptr->n_elements, index, len, "@RLCMAC_CSN1_Types.UtranReportingQuantityList","element");
UtranReportingQuantityList ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new UtranCCNMeasReportItem(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new UtranCCNMeasReportItem(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new UtranCCNMeasReportItem(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

UtranReportingQuantityList UtranReportingQuantityList::replace(int index, int len, const UtranReportingQuantityList_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void UtranReportingQuantityList::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (UtranCCNMeasReportItem**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new UtranCCNMeasReportItem(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (UtranCCNMeasReportItem**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @RLCMAC_CSN1_Types.UtranReportingQuantityList: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (UtranCCNMeasReportItem**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean UtranReportingQuantityList::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int UtranReportingQuantityList::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
return val_ptr->n_elements;
}

int UtranReportingQuantityList::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void UtranReportingQuantityList::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void UtranReportingQuantityList::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void UtranReportingQuantityList::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@RLCMAC_CSN1_Types.UtranReportingQuantityList");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@RLCMAC_CSN1_Types.UtranReportingQuantityList");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void UtranReportingQuantityList::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void UtranReportingQuantityList::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
val_ptr->value_elements = (UtranCCNMeasReportItem**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new UtranCCNMeasReportItem;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void UtranReportingQuantityList::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void UtranReportingQuantityList::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int UtranReportingQuantityList::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int UtranReportingQuantityList::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void UtranReportingQuantityList_template::copy_value(const UtranReportingQuantityList& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (UtranCCNMeasReportItem_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new UtranCCNMeasReportItem_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new UtranCCNMeasReportItem_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void UtranReportingQuantityList_template::copy_template(const UtranReportingQuantityList_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (UtranCCNMeasReportItem_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new UtranCCNMeasReportItem_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new UtranCCNMeasReportItem_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new UtranReportingQuantityList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new UtranReportingQuantityList_template(*other_value.implication_.precondition);
implication_.implied_template = new UtranReportingQuantityList_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
break;
}
set_selection(other_value);
}

boolean UtranReportingQuantityList_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const UtranReportingQuantityList_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const UtranReportingQuantityList*)value_ptr)[value_index], legacy);
else return ((const UtranReportingQuantityList_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

UtranReportingQuantityList_template::UtranReportingQuantityList_template()
{
}

UtranReportingQuantityList_template::UtranReportingQuantityList_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

UtranReportingQuantityList_template::UtranReportingQuantityList_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

UtranReportingQuantityList_template::UtranReportingQuantityList_template(const UtranReportingQuantityList& other_value)
{
copy_value(other_value);
}

UtranReportingQuantityList_template::UtranReportingQuantityList_template(const OPTIONAL<UtranReportingQuantityList>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UtranReportingQuantityList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList from an unbound optional field.");
}
}

UtranReportingQuantityList_template::UtranReportingQuantityList_template(UtranReportingQuantityList_template* p_precondition, UtranReportingQuantityList_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

UtranReportingQuantityList_template::UtranReportingQuantityList_template(Dynamic_Match_Interface<UtranReportingQuantityList>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<UtranReportingQuantityList>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

UtranReportingQuantityList_template::UtranReportingQuantityList_template(const UtranReportingQuantityList_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

UtranReportingQuantityList_template::~UtranReportingQuantityList_template()
{
clean_up();
}

void UtranReportingQuantityList_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

UtranReportingQuantityList_template& UtranReportingQuantityList_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

UtranReportingQuantityList_template& UtranReportingQuantityList_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

UtranReportingQuantityList_template& UtranReportingQuantityList_template::operator=(const UtranReportingQuantityList& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

UtranReportingQuantityList_template& UtranReportingQuantityList_template::operator=(const OPTIONAL<UtranReportingQuantityList>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UtranReportingQuantityList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
}
return *this;
}

UtranReportingQuantityList_template& UtranReportingQuantityList_template::operator=(const UtranReportingQuantityList_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

UtranCCNMeasReportItem_template& UtranReportingQuantityList_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RLCMAC_CSN1_Types.UtranReportingQuantityList using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
    break;
}
return *single_value.value_elements[index_value];
}

UtranCCNMeasReportItem_template& UtranReportingQuantityList_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
return (*this)[(int)index_value];
}

const UtranCCNMeasReportItem_template& UtranReportingQuantityList_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RLCMAC_CSN1_Types.UtranReportingQuantityList using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const UtranCCNMeasReportItem_template& UtranReportingQuantityList_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
return (*this)[(int)index_value];
}

void UtranReportingQuantityList_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (UtranCCNMeasReportItem_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new UtranCCNMeasReportItem_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new UtranCCNMeasReportItem_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (UtranCCNMeasReportItem_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int UtranReportingQuantityList_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int UtranReportingQuantityList_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList");
}

boolean UtranReportingQuantityList_template::match(const UtranReportingQuantityList& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
}
return FALSE;
}

boolean UtranReportingQuantityList_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

UtranReportingQuantityList UtranReportingQuantityList_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
UtranReportingQuantityList ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

UtranReportingQuantityList UtranReportingQuantityList_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

UtranReportingQuantityList UtranReportingQuantityList_template::replace(int index, int len, const UtranReportingQuantityList_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

UtranReportingQuantityList UtranReportingQuantityList_template::replace(int index, int len, const UtranReportingQuantityList& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void UtranReportingQuantityList_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new UtranReportingQuantityList_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
}
set_selection(template_type);
}

UtranReportingQuantityList_template& UtranReportingQuantityList_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
return value_list.list_value[list_index];
}

void UtranReportingQuantityList_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void UtranReportingQuantityList_template::log_match(const UtranReportingQuantityList& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void UtranReportingQuantityList_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
}
}

void UtranReportingQuantityList_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
single_value.value_elements = (UtranCCNMeasReportItem_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new UtranCCNMeasReportItem_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new UtranReportingQuantityList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @RLCMAC_CSN1_Types.UtranReportingQuantityList.");
}
}

boolean UtranReportingQuantityList_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean UtranReportingQuantityList_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void UtranReportingQuantityList_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void UtranReportingQuantityList_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    UtranReportingQuantityList_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    UtranReportingQuantityList_template* precondition = new UtranReportingQuantityList_template;
    precondition->set_param(*param.get_elem(0));
    UtranReportingQuantityList_template* implied_template = new UtranReportingQuantityList_template;
    implied_template->set_param(*param.get_elem(1));
    *this = UtranReportingQuantityList_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@RLCMAC_CSN1_Types.UtranReportingQuantityList");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void UtranReportingQuantityList_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.UtranReportingQuantityList");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.UtranReportingQuantityList");
}

boolean UtranReportingQuantityList_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
UtranCCNMeasReportItem::UtranCCNMeasReportItem()
{
}

UtranCCNMeasReportItem::UtranCCNMeasReportItem(const INTEGER& par_cell__list__index,
    const INTEGER& par_reporting__quantity)
  :   field_cell__list__index(par_cell__list__index),
  field_reporting__quantity(par_reporting__quantity)
{
}

UtranCCNMeasReportItem::UtranCCNMeasReportItem(const UtranCCNMeasReportItem& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem.");
if (other_value.cell__list__index().is_bound()) field_cell__list__index = other_value.cell__list__index();
else field_cell__list__index.clean_up();
if (other_value.reporting__quantity().is_bound()) field_reporting__quantity = other_value.reporting__quantity();
else field_reporting__quantity.clean_up();
}

void UtranCCNMeasReportItem::clean_up()
{
field_cell__list__index.clean_up();
field_reporting__quantity.clean_up();
}

const TTCN_Typedescriptor_t* UtranCCNMeasReportItem::get_descriptor() const { return &UtranCCNMeasReportItem_descr_; }
UtranCCNMeasReportItem& UtranCCNMeasReportItem::operator=(const UtranCCNMeasReportItem& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem.");
  if (other_value.cell__list__index().is_bound()) field_cell__list__index = other_value.cell__list__index();
  else field_cell__list__index.clean_up();
  if (other_value.reporting__quantity().is_bound()) field_reporting__quantity = other_value.reporting__quantity();
  else field_reporting__quantity.clean_up();
}
return *this;
}

boolean UtranCCNMeasReportItem::operator==(const UtranCCNMeasReportItem& other_value) const
{
return field_cell__list__index==other_value.field_cell__list__index
  && field_reporting__quantity==other_value.field_reporting__quantity;
}

boolean UtranCCNMeasReportItem::is_bound() const
{
return (field_cell__list__index.is_bound())
  || (field_reporting__quantity.is_bound());
}
boolean UtranCCNMeasReportItem::is_value() const
{
return field_cell__list__index.is_value()
  && field_reporting__quantity.is_value();
}
void UtranCCNMeasReportItem::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ cell_list_index := ");
field_cell__list__index.log();
TTCN_Logger::log_event_str(", reporting_quantity := ");
field_reporting__quantity.log();
TTCN_Logger::log_event_str(" }");
}

void UtranCCNMeasReportItem::set_implicit_omit()
{
if (cell__list__index().is_bound()) cell__list__index().set_implicit_omit();
if (reporting__quantity().is_bound()) reporting__quantity().set_implicit_omit();
}

void UtranCCNMeasReportItem::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) cell__list__index().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reporting__quantity().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cell_list_index")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cell__list__index().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_quantity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__quantity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.UtranCCNMeasReportItem");
  }
}

void UtranCCNMeasReportItem::encode_text(Text_Buf& text_buf) const
{
field_cell__list__index.encode_text(text_buf);
field_reporting__quantity.encode_text(text_buf);
}

void UtranCCNMeasReportItem::decode_text(Text_Buf& text_buf)
{
field_cell__list__index.decode_text(text_buf);
field_reporting__quantity.decode_text(text_buf);
}

void UtranCCNMeasReportItem::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void UtranCCNMeasReportItem::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int UtranCCNMeasReportItem::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, UtranCCNMeasReportItem_cell__list__index_descr_.raw->forceomit);
  decoded_field_length = field_cell__list__index.RAW_decode(UtranCCNMeasReportItem_cell__list__index_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, UtranCCNMeasReportItem_reporting__quantity_descr_.raw->forceomit);
  decoded_field_length = field_reporting__quantity.RAW_decode(UtranCCNMeasReportItem_reporting__quantity_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int UtranCCNMeasReportItem::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, UtranCCNMeasReportItem_cell__list__index_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, UtranCCNMeasReportItem_reporting__quantity_descr_.raw);
  encoded_length += field_cell__list__index.RAW_encode(UtranCCNMeasReportItem_cell__list__index_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_reporting__quantity.RAW_encode(UtranCCNMeasReportItem_reporting__quantity_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct UtranCCNMeasReportItem_template::single_value_struct {
INTEGER_template field_cell__list__index;
INTEGER_template field_reporting__quantity;
};

void UtranCCNMeasReportItem_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_cell__list__index = ANY_VALUE;
single_value->field_reporting__quantity = ANY_VALUE;
}
}
}

void UtranCCNMeasReportItem_template::copy_value(const UtranCCNMeasReportItem& other_value)
{
single_value = new single_value_struct;
if (other_value.cell__list__index().is_bound()) {
  single_value->field_cell__list__index = other_value.cell__list__index();
} else {
  single_value->field_cell__list__index.clean_up();
}
if (other_value.reporting__quantity().is_bound()) {
  single_value->field_reporting__quantity = other_value.reporting__quantity();
} else {
  single_value->field_reporting__quantity.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void UtranCCNMeasReportItem_template::copy_template(const UtranCCNMeasReportItem_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.cell__list__index().get_selection()) {
single_value->field_cell__list__index = other_value.cell__list__index();
} else {
single_value->field_cell__list__index.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reporting__quantity().get_selection()) {
single_value->field_reporting__quantity = other_value.reporting__quantity();
} else {
single_value->field_reporting__quantity.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new UtranCCNMeasReportItem_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new UtranCCNMeasReportItem_template(*other_value.implication_.precondition);
implication_.implied_template = new UtranCCNMeasReportItem_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem.");
break;
}
set_selection(other_value);
}

UtranCCNMeasReportItem_template::UtranCCNMeasReportItem_template()
{
}

UtranCCNMeasReportItem_template::UtranCCNMeasReportItem_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

UtranCCNMeasReportItem_template::UtranCCNMeasReportItem_template(const UtranCCNMeasReportItem& other_value)
{
copy_value(other_value);
}

UtranCCNMeasReportItem_template::UtranCCNMeasReportItem_template(const OPTIONAL<UtranCCNMeasReportItem>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UtranCCNMeasReportItem&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem from an unbound optional field.");
}
}

UtranCCNMeasReportItem_template::UtranCCNMeasReportItem_template(UtranCCNMeasReportItem_template* p_precondition, UtranCCNMeasReportItem_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

UtranCCNMeasReportItem_template::UtranCCNMeasReportItem_template(Dynamic_Match_Interface<UtranCCNMeasReportItem>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<UtranCCNMeasReportItem>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

UtranCCNMeasReportItem_template::UtranCCNMeasReportItem_template(const UtranCCNMeasReportItem_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

UtranCCNMeasReportItem_template::~UtranCCNMeasReportItem_template()
{
clean_up();
}

UtranCCNMeasReportItem_template& UtranCCNMeasReportItem_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

UtranCCNMeasReportItem_template& UtranCCNMeasReportItem_template::operator=(const UtranCCNMeasReportItem& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

UtranCCNMeasReportItem_template& UtranCCNMeasReportItem_template::operator=(const OPTIONAL<UtranCCNMeasReportItem>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UtranCCNMeasReportItem&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem.");
}
return *this;
}

UtranCCNMeasReportItem_template& UtranCCNMeasReportItem_template::operator=(const UtranCCNMeasReportItem_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean UtranCCNMeasReportItem_template::match(const UtranCCNMeasReportItem& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.cell__list__index().is_bound()) return FALSE;
if(!single_value->field_cell__list__index.match(other_value.cell__list__index(), legacy))return FALSE;
if(!other_value.reporting__quantity().is_bound()) return FALSE;
if(!single_value->field_reporting__quantity.match(other_value.reporting__quantity(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem.");
}
return FALSE;
}

boolean UtranCCNMeasReportItem_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_cell__list__index.is_bound()
 || single_value->field_reporting__quantity.is_bound();
}

boolean UtranCCNMeasReportItem_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_cell__list__index.is_value()
 && single_value->field_reporting__quantity.is_value();
}

void UtranCCNMeasReportItem_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

UtranCCNMeasReportItem UtranCCNMeasReportItem_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem.");
UtranCCNMeasReportItem ret_val;
if (single_value->field_cell__list__index.is_bound()) {
ret_val.cell__list__index() = single_value->field_cell__list__index.valueof();
}
if (single_value->field_reporting__quantity.is_bound()) {
ret_val.reporting__quantity() = single_value->field_reporting__quantity.valueof();
}
return ret_val;
}

void UtranCCNMeasReportItem_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new UtranCCNMeasReportItem_template[list_length];
}

UtranCCNMeasReportItem_template& UtranCCNMeasReportItem_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem.");
return value_list.list_value[list_index];
}

INTEGER_template& UtranCCNMeasReportItem_template::cell__list__index()
{
set_specific();
return single_value->field_cell__list__index;
}

const INTEGER_template& UtranCCNMeasReportItem_template::cell__list__index() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cell_list_index of a non-specific template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem.");
return single_value->field_cell__list__index;
}

INTEGER_template& UtranCCNMeasReportItem_template::reporting__quantity()
{
set_specific();
return single_value->field_reporting__quantity;
}

const INTEGER_template& UtranCCNMeasReportItem_template::reporting__quantity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reporting_quantity of a non-specific template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem.");
return single_value->field_reporting__quantity;
}

int UtranCCNMeasReportItem_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem.");
  }
  return 0;
}

void UtranCCNMeasReportItem_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ cell_list_index := ");
single_value->field_cell__list__index.log();
TTCN_Logger::log_event_str(", reporting_quantity := ");
single_value->field_reporting__quantity.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void UtranCCNMeasReportItem_template::log_match(const UtranCCNMeasReportItem& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_cell__list__index.match(match_value.cell__list__index(), legacy)){
TTCN_Logger::log_logmatch_info(".cell_list_index");
single_value->field_cell__list__index.log_match(match_value.cell__list__index(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reporting__quantity.match(match_value.reporting__quantity(), legacy)){
TTCN_Logger::log_logmatch_info(".reporting_quantity");
single_value->field_reporting__quantity.log_match(match_value.reporting__quantity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ cell_list_index := ");
single_value->field_cell__list__index.log_match(match_value.cell__list__index(), legacy);
TTCN_Logger::log_event_str(", reporting_quantity := ");
single_value->field_reporting__quantity.log_match(match_value.reporting__quantity(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void UtranCCNMeasReportItem_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (cell__list__index().is_bound()) cell__list__index().set_implicit_omit();
if (reporting__quantity().is_bound()) reporting__quantity().set_implicit_omit();
}

void UtranCCNMeasReportItem_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_cell__list__index.encode_text(text_buf);
single_value->field_reporting__quantity.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem.");
}
}

void UtranCCNMeasReportItem_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_cell__list__index.decode_text(text_buf);
single_value->field_reporting__quantity.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new UtranCCNMeasReportItem_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem.");
}
}

void UtranCCNMeasReportItem_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    UtranCCNMeasReportItem_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) cell__list__index().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reporting__quantity().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cell_list_index")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cell__list__index().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_quantity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__quantity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.UtranCCNMeasReportItem: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    UtranCCNMeasReportItem_template* precondition = new UtranCCNMeasReportItem_template;
    precondition->set_param(*param.get_elem(0));
    UtranCCNMeasReportItem_template* implied_template = new UtranCCNMeasReportItem_template;
    implied_template->set_param(*param.get_elem(1));
    *this = UtranCCNMeasReportItem_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.UtranCCNMeasReportItem");
  }
  is_ifpresent = param.get_ifpresent();
}

void UtranCCNMeasReportItem_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_cell__list__index.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.UtranCCNMeasReportItem");
single_value->field_reporting__quantity.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.UtranCCNMeasReportItem");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.UtranCCNMeasReportItem");
}

boolean UtranCCNMeasReportItem_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean UtranCCNMeasReportItem_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

UtranCCNMeasReport::UtranCCNMeasReport()
{
}

UtranCCNMeasReport::UtranCCNMeasReport(const INTEGER& par_n__3g,
    const UtranReportingQuantityList& par_cells)
  :   field_n__3g(par_n__3g),
  field_cells(par_cells)
{
}

UtranCCNMeasReport::UtranCCNMeasReport(const UtranCCNMeasReport& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.UtranCCNMeasReport.");
if (other_value.n__3g().is_bound()) field_n__3g = other_value.n__3g();
else field_n__3g.clean_up();
if (other_value.cells().is_bound()) field_cells = other_value.cells();
else field_cells.clean_up();
}

void UtranCCNMeasReport::clean_up()
{
field_n__3g.clean_up();
field_cells.clean_up();
}

const TTCN_Typedescriptor_t* UtranCCNMeasReport::get_descriptor() const { return &UtranCCNMeasReport_descr_; }
UtranCCNMeasReport& UtranCCNMeasReport::operator=(const UtranCCNMeasReport& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.UtranCCNMeasReport.");
  if (other_value.n__3g().is_bound()) field_n__3g = other_value.n__3g();
  else field_n__3g.clean_up();
  if (other_value.cells().is_bound()) field_cells = other_value.cells();
  else field_cells.clean_up();
}
return *this;
}

boolean UtranCCNMeasReport::operator==(const UtranCCNMeasReport& other_value) const
{
return field_n__3g==other_value.field_n__3g
  && field_cells==other_value.field_cells;
}

boolean UtranCCNMeasReport::is_bound() const
{
return (field_n__3g.is_bound())
  || (field_cells.is_bound());
}
boolean UtranCCNMeasReport::is_value() const
{
return field_n__3g.is_value()
  && field_cells.is_value();
}
void UtranCCNMeasReport::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ n_3g := ");
field_n__3g.log();
TTCN_Logger::log_event_str(", cells := ");
field_cells.log();
TTCN_Logger::log_event_str(" }");
}

void UtranCCNMeasReport::set_implicit_omit()
{
if (n__3g().is_bound()) n__3g().set_implicit_omit();
if (cells().is_bound()) cells().set_implicit_omit();
}

void UtranCCNMeasReport::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.UtranCCNMeasReport has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) n__3g().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cells().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "n_3g")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          n__3g().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cells")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cells().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.UtranCCNMeasReport: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.UtranCCNMeasReport");
  }
}

void UtranCCNMeasReport::encode_text(Text_Buf& text_buf) const
{
field_n__3g.encode_text(text_buf);
field_cells.encode_text(text_buf);
}

void UtranCCNMeasReport::decode_text(Text_Buf& text_buf)
{
field_n__3g.decode_text(text_buf);
field_cells.decode_text(text_buf);
}

void UtranCCNMeasReport::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void UtranCCNMeasReport::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int UtranCCNMeasReport::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, UtranCCNMeasReport_n__3g_descr_.raw->forceomit);
  decoded_field_length = field_n__3g.RAW_decode(UtranCCNMeasReport_n__3g_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_n__3g.convert_to_Integer(UtranCCNMeasReport_n__3g_descr_);
  tmp0 = tmp0 - -1;
  field_n__3g = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 1;
  RAW_Force_Omit field_1_force_omit(1, force_omit, UtranCCNMeasReport_cells_descr_.raw->forceomit);
  decoded_field_length = field_cells.RAW_decode(UtranCCNMeasReport_cells_descr_, p_buf, limit, local_top_order, no_err, value_of_length_field0, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int UtranCCNMeasReport::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, UtranCCNMeasReport_n__3g_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, UtranCCNMeasReport_cells_descr_.raw);
  encoded_length += 3;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &UtranCCNMeasReport_n__3g_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = -1;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = -1;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 3;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_cells.RAW_encode(UtranCCNMeasReport_cells_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct UtranCCNMeasReport_template::single_value_struct {
INTEGER_template field_n__3g;
UtranReportingQuantityList_template field_cells;
};

void UtranCCNMeasReport_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_n__3g = ANY_VALUE;
single_value->field_cells = ANY_VALUE;
}
}
}

void UtranCCNMeasReport_template::copy_value(const UtranCCNMeasReport& other_value)
{
single_value = new single_value_struct;
if (other_value.n__3g().is_bound()) {
  single_value->field_n__3g = other_value.n__3g();
} else {
  single_value->field_n__3g.clean_up();
}
if (other_value.cells().is_bound()) {
  single_value->field_cells = other_value.cells();
} else {
  single_value->field_cells.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void UtranCCNMeasReport_template::copy_template(const UtranCCNMeasReport_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.n__3g().get_selection()) {
single_value->field_n__3g = other_value.n__3g();
} else {
single_value->field_n__3g.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cells().get_selection()) {
single_value->field_cells = other_value.cells();
} else {
single_value->field_cells.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new UtranCCNMeasReport_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new UtranCCNMeasReport_template(*other_value.implication_.precondition);
implication_.implied_template = new UtranCCNMeasReport_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport.");
break;
}
set_selection(other_value);
}

UtranCCNMeasReport_template::UtranCCNMeasReport_template()
{
}

UtranCCNMeasReport_template::UtranCCNMeasReport_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

UtranCCNMeasReport_template::UtranCCNMeasReport_template(const UtranCCNMeasReport& other_value)
{
copy_value(other_value);
}

UtranCCNMeasReport_template::UtranCCNMeasReport_template(const OPTIONAL<UtranCCNMeasReport>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UtranCCNMeasReport&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport from an unbound optional field.");
}
}

UtranCCNMeasReport_template::UtranCCNMeasReport_template(UtranCCNMeasReport_template* p_precondition, UtranCCNMeasReport_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

UtranCCNMeasReport_template::UtranCCNMeasReport_template(Dynamic_Match_Interface<UtranCCNMeasReport>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<UtranCCNMeasReport>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

UtranCCNMeasReport_template::UtranCCNMeasReport_template(const UtranCCNMeasReport_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

UtranCCNMeasReport_template::~UtranCCNMeasReport_template()
{
clean_up();
}

UtranCCNMeasReport_template& UtranCCNMeasReport_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

UtranCCNMeasReport_template& UtranCCNMeasReport_template::operator=(const UtranCCNMeasReport& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

UtranCCNMeasReport_template& UtranCCNMeasReport_template::operator=(const OPTIONAL<UtranCCNMeasReport>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UtranCCNMeasReport&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport.");
}
return *this;
}

UtranCCNMeasReport_template& UtranCCNMeasReport_template::operator=(const UtranCCNMeasReport_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean UtranCCNMeasReport_template::match(const UtranCCNMeasReport& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.n__3g().is_bound()) return FALSE;
if(!single_value->field_n__3g.match(other_value.n__3g(), legacy))return FALSE;
if(!other_value.cells().is_bound()) return FALSE;
if(!single_value->field_cells.match(other_value.cells(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport.");
}
return FALSE;
}

boolean UtranCCNMeasReport_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_n__3g.is_bound()
 || single_value->field_cells.is_bound();
}

boolean UtranCCNMeasReport_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_n__3g.is_value()
 && single_value->field_cells.is_value();
}

void UtranCCNMeasReport_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

UtranCCNMeasReport UtranCCNMeasReport_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport.");
UtranCCNMeasReport ret_val;
if (single_value->field_n__3g.is_bound()) {
ret_val.n__3g() = single_value->field_n__3g.valueof();
}
if (single_value->field_cells.is_bound()) {
ret_val.cells() = single_value->field_cells.valueof();
}
return ret_val;
}

void UtranCCNMeasReport_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new UtranCCNMeasReport_template[list_length];
}

UtranCCNMeasReport_template& UtranCCNMeasReport_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport.");
return value_list.list_value[list_index];
}

INTEGER_template& UtranCCNMeasReport_template::n__3g()
{
set_specific();
return single_value->field_n__3g;
}

const INTEGER_template& UtranCCNMeasReport_template::n__3g() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field n_3g of a non-specific template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport.");
return single_value->field_n__3g;
}

UtranReportingQuantityList_template& UtranCCNMeasReport_template::cells()
{
set_specific();
return single_value->field_cells;
}

const UtranReportingQuantityList_template& UtranCCNMeasReport_template::cells() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cells of a non-specific template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport.");
return single_value->field_cells;
}

int UtranCCNMeasReport_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport.");
  }
  return 0;
}

void UtranCCNMeasReport_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ n_3g := ");
single_value->field_n__3g.log();
TTCN_Logger::log_event_str(", cells := ");
single_value->field_cells.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void UtranCCNMeasReport_template::log_match(const UtranCCNMeasReport& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_n__3g.match(match_value.n__3g(), legacy)){
TTCN_Logger::log_logmatch_info(".n_3g");
single_value->field_n__3g.log_match(match_value.n__3g(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cells.match(match_value.cells(), legacy)){
TTCN_Logger::log_logmatch_info(".cells");
single_value->field_cells.log_match(match_value.cells(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ n_3g := ");
single_value->field_n__3g.log_match(match_value.n__3g(), legacy);
TTCN_Logger::log_event_str(", cells := ");
single_value->field_cells.log_match(match_value.cells(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void UtranCCNMeasReport_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (n__3g().is_bound()) n__3g().set_implicit_omit();
if (cells().is_bound()) cells().set_implicit_omit();
}

void UtranCCNMeasReport_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_n__3g.encode_text(text_buf);
single_value->field_cells.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport.");
}
}

void UtranCCNMeasReport_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_n__3g.decode_text(text_buf);
single_value->field_cells.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new UtranCCNMeasReport_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport.");
}
}

void UtranCCNMeasReport_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    UtranCCNMeasReport_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.UtranCCNMeasReport has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) n__3g().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cells().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "n_3g")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          n__3g().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cells")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cells().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.UtranCCNMeasReport: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    UtranCCNMeasReport_template* precondition = new UtranCCNMeasReport_template;
    precondition->set_param(*param.get_elem(0));
    UtranCCNMeasReport_template* implied_template = new UtranCCNMeasReport_template;
    implied_template->set_param(*param.get_elem(1));
    *this = UtranCCNMeasReport_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.UtranCCNMeasReport");
  }
  is_ifpresent = param.get_ifpresent();
}

void UtranCCNMeasReport_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_n__3g.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.UtranCCNMeasReport");
single_value->field_cells.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.UtranCCNMeasReport");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.UtranCCNMeasReport");
}

boolean UtranCCNMeasReport_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean UtranCCNMeasReport_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const EutranCCNMeasReportItem EutranReportingQuantityList::UNBOUND_ELEM;
EutranReportingQuantityList::EutranReportingQuantityList()
{
val_ptr = NULL;
}

EutranReportingQuantityList::EutranReportingQuantityList(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

EutranReportingQuantityList::EutranReportingQuantityList(const EutranReportingQuantityList& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

EutranReportingQuantityList::~EutranReportingQuantityList()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void EutranReportingQuantityList::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

EutranReportingQuantityList& EutranReportingQuantityList::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

EutranReportingQuantityList& EutranReportingQuantityList::operator=(const EutranReportingQuantityList& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean EutranReportingQuantityList::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
return val_ptr->n_elements == 0 ;
}

boolean EutranReportingQuantityList::operator==(const EutranReportingQuantityList& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

EutranCCNMeasReportItem& EutranReportingQuantityList::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @RLCMAC_CSN1_Types.EutranReportingQuantityList using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (EutranCCNMeasReportItem**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new EutranCCNMeasReportItem(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new EutranCCNMeasReportItem;
}
return *val_ptr->value_elements[index_value];
}

EutranCCNMeasReportItem& EutranReportingQuantityList::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
return (*this)[(int)index_value];
}

const EutranCCNMeasReportItem& EutranReportingQuantityList::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
if (index_value < 0) TTCN_error("Accessing an element of type @RLCMAC_CSN1_Types.EutranReportingQuantityList using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @RLCMAC_CSN1_Types.EutranReportingQuantityList: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const EutranCCNMeasReportItem& EutranReportingQuantityList::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
return (*this)[(int)index_value];
}

EutranReportingQuantityList EutranReportingQuantityList::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

EutranReportingQuantityList EutranReportingQuantityList::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

EutranReportingQuantityList EutranReportingQuantityList::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

EutranReportingQuantityList EutranReportingQuantityList::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
EutranReportingQuantityList ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new EutranCCNMeasReportItem(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

EutranReportingQuantityList EutranReportingQuantityList::operator+(const EutranReportingQuantityList& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @RLCMAC_CSN1_Types.EutranReportingQuantityList concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
EutranReportingQuantityList ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new EutranCCNMeasReportItem(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new EutranCCNMeasReportItem(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

EutranReportingQuantityList EutranReportingQuantityList::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@RLCMAC_CSN1_Types.EutranReportingQuantityList","element");
EutranReportingQuantityList ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new EutranCCNMeasReportItem(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

EutranReportingQuantityList EutranReportingQuantityList::replace(int index, int len, const EutranReportingQuantityList& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
check_replace_arguments(val_ptr->n_elements, index, len, "@RLCMAC_CSN1_Types.EutranReportingQuantityList","element");
EutranReportingQuantityList ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new EutranCCNMeasReportItem(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new EutranCCNMeasReportItem(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new EutranCCNMeasReportItem(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

EutranReportingQuantityList EutranReportingQuantityList::replace(int index, int len, const EutranReportingQuantityList_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void EutranReportingQuantityList::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (EutranCCNMeasReportItem**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new EutranCCNMeasReportItem(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (EutranCCNMeasReportItem**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @RLCMAC_CSN1_Types.EutranReportingQuantityList: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (EutranCCNMeasReportItem**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean EutranReportingQuantityList::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int EutranReportingQuantityList::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
return val_ptr->n_elements;
}

int EutranReportingQuantityList::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void EutranReportingQuantityList::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void EutranReportingQuantityList::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void EutranReportingQuantityList::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@RLCMAC_CSN1_Types.EutranReportingQuantityList");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@RLCMAC_CSN1_Types.EutranReportingQuantityList");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void EutranReportingQuantityList::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void EutranReportingQuantityList::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
val_ptr->value_elements = (EutranCCNMeasReportItem**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new EutranCCNMeasReportItem;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void EutranReportingQuantityList::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void EutranReportingQuantityList::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int EutranReportingQuantityList::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int EutranReportingQuantityList::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void EutranReportingQuantityList_template::copy_value(const EutranReportingQuantityList& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (EutranCCNMeasReportItem_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new EutranCCNMeasReportItem_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new EutranCCNMeasReportItem_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void EutranReportingQuantityList_template::copy_template(const EutranReportingQuantityList_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (EutranCCNMeasReportItem_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new EutranCCNMeasReportItem_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new EutranCCNMeasReportItem_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new EutranReportingQuantityList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new EutranReportingQuantityList_template(*other_value.implication_.precondition);
implication_.implied_template = new EutranReportingQuantityList_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
break;
}
set_selection(other_value);
}

boolean EutranReportingQuantityList_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const EutranReportingQuantityList_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const EutranReportingQuantityList*)value_ptr)[value_index], legacy);
else return ((const EutranReportingQuantityList_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

EutranReportingQuantityList_template::EutranReportingQuantityList_template()
{
}

EutranReportingQuantityList_template::EutranReportingQuantityList_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

EutranReportingQuantityList_template::EutranReportingQuantityList_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

EutranReportingQuantityList_template::EutranReportingQuantityList_template(const EutranReportingQuantityList& other_value)
{
copy_value(other_value);
}

EutranReportingQuantityList_template::EutranReportingQuantityList_template(const OPTIONAL<EutranReportingQuantityList>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EutranReportingQuantityList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList from an unbound optional field.");
}
}

EutranReportingQuantityList_template::EutranReportingQuantityList_template(EutranReportingQuantityList_template* p_precondition, EutranReportingQuantityList_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

EutranReportingQuantityList_template::EutranReportingQuantityList_template(Dynamic_Match_Interface<EutranReportingQuantityList>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<EutranReportingQuantityList>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

EutranReportingQuantityList_template::EutranReportingQuantityList_template(const EutranReportingQuantityList_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

EutranReportingQuantityList_template::~EutranReportingQuantityList_template()
{
clean_up();
}

void EutranReportingQuantityList_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

EutranReportingQuantityList_template& EutranReportingQuantityList_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

EutranReportingQuantityList_template& EutranReportingQuantityList_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

EutranReportingQuantityList_template& EutranReportingQuantityList_template::operator=(const EutranReportingQuantityList& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

EutranReportingQuantityList_template& EutranReportingQuantityList_template::operator=(const OPTIONAL<EutranReportingQuantityList>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EutranReportingQuantityList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
}
return *this;
}

EutranReportingQuantityList_template& EutranReportingQuantityList_template::operator=(const EutranReportingQuantityList_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

EutranCCNMeasReportItem_template& EutranReportingQuantityList_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RLCMAC_CSN1_Types.EutranReportingQuantityList using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
    break;
}
return *single_value.value_elements[index_value];
}

EutranCCNMeasReportItem_template& EutranReportingQuantityList_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
return (*this)[(int)index_value];
}

const EutranCCNMeasReportItem_template& EutranReportingQuantityList_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RLCMAC_CSN1_Types.EutranReportingQuantityList using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const EutranCCNMeasReportItem_template& EutranReportingQuantityList_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
return (*this)[(int)index_value];
}

void EutranReportingQuantityList_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (EutranCCNMeasReportItem_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new EutranCCNMeasReportItem_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new EutranCCNMeasReportItem_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (EutranCCNMeasReportItem_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int EutranReportingQuantityList_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int EutranReportingQuantityList_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList");
}

boolean EutranReportingQuantityList_template::match(const EutranReportingQuantityList& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
}
return FALSE;
}

boolean EutranReportingQuantityList_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

EutranReportingQuantityList EutranReportingQuantityList_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
EutranReportingQuantityList ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

EutranReportingQuantityList EutranReportingQuantityList_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

EutranReportingQuantityList EutranReportingQuantityList_template::replace(int index, int len, const EutranReportingQuantityList_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

EutranReportingQuantityList EutranReportingQuantityList_template::replace(int index, int len, const EutranReportingQuantityList& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void EutranReportingQuantityList_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new EutranReportingQuantityList_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
}
set_selection(template_type);
}

EutranReportingQuantityList_template& EutranReportingQuantityList_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
return value_list.list_value[list_index];
}

void EutranReportingQuantityList_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void EutranReportingQuantityList_template::log_match(const EutranReportingQuantityList& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void EutranReportingQuantityList_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
}
}

void EutranReportingQuantityList_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
single_value.value_elements = (EutranCCNMeasReportItem_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new EutranCCNMeasReportItem_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new EutranReportingQuantityList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @RLCMAC_CSN1_Types.EutranReportingQuantityList.");
}
}

boolean EutranReportingQuantityList_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean EutranReportingQuantityList_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void EutranReportingQuantityList_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void EutranReportingQuantityList_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    EutranReportingQuantityList_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    EutranReportingQuantityList_template* precondition = new EutranReportingQuantityList_template;
    precondition->set_param(*param.get_elem(0));
    EutranReportingQuantityList_template* implied_template = new EutranReportingQuantityList_template;
    implied_template->set_param(*param.get_elem(1));
    *this = EutranReportingQuantityList_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@RLCMAC_CSN1_Types.EutranReportingQuantityList");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void EutranReportingQuantityList_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EutranReportingQuantityList");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.EutranReportingQuantityList");
}

boolean EutranReportingQuantityList_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
EutranCCNMeasReportItem::EutranCCNMeasReportItem()
{
}

EutranCCNMeasReportItem::EutranCCNMeasReportItem(const INTEGER& par_frequency__list__index,
    const INTEGER& par_cell__identity,
    const INTEGER& par_reporting__quantity)
  :   field_frequency__list__index(par_frequency__list__index),
  field_cell__identity(par_cell__identity),
  field_reporting__quantity(par_reporting__quantity)
{
}

EutranCCNMeasReportItem::EutranCCNMeasReportItem(const EutranCCNMeasReportItem& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem.");
if (other_value.frequency__list__index().is_bound()) field_frequency__list__index = other_value.frequency__list__index();
else field_frequency__list__index.clean_up();
if (other_value.cell__identity().is_bound()) field_cell__identity = other_value.cell__identity();
else field_cell__identity.clean_up();
if (other_value.reporting__quantity().is_bound()) field_reporting__quantity = other_value.reporting__quantity();
else field_reporting__quantity.clean_up();
}

void EutranCCNMeasReportItem::clean_up()
{
field_frequency__list__index.clean_up();
field_cell__identity.clean_up();
field_reporting__quantity.clean_up();
}

const TTCN_Typedescriptor_t* EutranCCNMeasReportItem::get_descriptor() const { return &EutranCCNMeasReportItem_descr_; }
EutranCCNMeasReportItem& EutranCCNMeasReportItem::operator=(const EutranCCNMeasReportItem& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem.");
  if (other_value.frequency__list__index().is_bound()) field_frequency__list__index = other_value.frequency__list__index();
  else field_frequency__list__index.clean_up();
  if (other_value.cell__identity().is_bound()) field_cell__identity = other_value.cell__identity();
  else field_cell__identity.clean_up();
  if (other_value.reporting__quantity().is_bound()) field_reporting__quantity = other_value.reporting__quantity();
  else field_reporting__quantity.clean_up();
}
return *this;
}

boolean EutranCCNMeasReportItem::operator==(const EutranCCNMeasReportItem& other_value) const
{
return field_frequency__list__index==other_value.field_frequency__list__index
  && field_cell__identity==other_value.field_cell__identity
  && field_reporting__quantity==other_value.field_reporting__quantity;
}

boolean EutranCCNMeasReportItem::is_bound() const
{
return (field_frequency__list__index.is_bound())
  || (field_cell__identity.is_bound())
  || (field_reporting__quantity.is_bound());
}
boolean EutranCCNMeasReportItem::is_value() const
{
return field_frequency__list__index.is_value()
  && field_cell__identity.is_value()
  && field_reporting__quantity.is_value();
}
void EutranCCNMeasReportItem::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ frequency_list_index := ");
field_frequency__list__index.log();
TTCN_Logger::log_event_str(", cell_identity := ");
field_cell__identity.log();
TTCN_Logger::log_event_str(", reporting_quantity := ");
field_reporting__quantity.log();
TTCN_Logger::log_event_str(" }");
}

void EutranCCNMeasReportItem::set_implicit_omit()
{
if (frequency__list__index().is_bound()) frequency__list__index().set_implicit_omit();
if (cell__identity().is_bound()) cell__identity().set_implicit_omit();
if (reporting__quantity().is_bound()) reporting__quantity().set_implicit_omit();
}

void EutranCCNMeasReportItem::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) frequency__list__index().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cell__identity().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) reporting__quantity().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "frequency_list_index")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          frequency__list__index().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cell_identity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cell__identity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_quantity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__quantity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.EutranCCNMeasReportItem");
  }
}

void EutranCCNMeasReportItem::encode_text(Text_Buf& text_buf) const
{
field_frequency__list__index.encode_text(text_buf);
field_cell__identity.encode_text(text_buf);
field_reporting__quantity.encode_text(text_buf);
}

void EutranCCNMeasReportItem::decode_text(Text_Buf& text_buf)
{
field_frequency__list__index.decode_text(text_buf);
field_cell__identity.decode_text(text_buf);
field_reporting__quantity.decode_text(text_buf);
}

void EutranCCNMeasReportItem::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void EutranCCNMeasReportItem::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int EutranCCNMeasReportItem::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, EutranCCNMeasReportItem_frequency__list__index_descr_.raw->forceomit);
  decoded_field_length = field_frequency__list__index.RAW_decode(EutranCCNMeasReportItem_frequency__list__index_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, EutranCCNMeasReportItem_cell__identity_descr_.raw->forceomit);
  decoded_field_length = field_cell__identity.RAW_decode(EutranCCNMeasReportItem_cell__identity_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, EutranCCNMeasReportItem_reporting__quantity_descr_.raw->forceomit);
  decoded_field_length = field_reporting__quantity.RAW_decode(EutranCCNMeasReportItem_reporting__quantity_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int EutranCCNMeasReportItem::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, EutranCCNMeasReportItem_frequency__list__index_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, EutranCCNMeasReportItem_cell__identity_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, EutranCCNMeasReportItem_reporting__quantity_descr_.raw);
  encoded_length += field_frequency__list__index.RAW_encode(EutranCCNMeasReportItem_frequency__list__index_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_cell__identity.RAW_encode(EutranCCNMeasReportItem_cell__identity_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_reporting__quantity.RAW_encode(EutranCCNMeasReportItem_reporting__quantity_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct EutranCCNMeasReportItem_template::single_value_struct {
INTEGER_template field_frequency__list__index;
INTEGER_template field_cell__identity;
INTEGER_template field_reporting__quantity;
};

void EutranCCNMeasReportItem_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_frequency__list__index = ANY_VALUE;
single_value->field_cell__identity = ANY_VALUE;
single_value->field_reporting__quantity = ANY_VALUE;
}
}
}

void EutranCCNMeasReportItem_template::copy_value(const EutranCCNMeasReportItem& other_value)
{
single_value = new single_value_struct;
if (other_value.frequency__list__index().is_bound()) {
  single_value->field_frequency__list__index = other_value.frequency__list__index();
} else {
  single_value->field_frequency__list__index.clean_up();
}
if (other_value.cell__identity().is_bound()) {
  single_value->field_cell__identity = other_value.cell__identity();
} else {
  single_value->field_cell__identity.clean_up();
}
if (other_value.reporting__quantity().is_bound()) {
  single_value->field_reporting__quantity = other_value.reporting__quantity();
} else {
  single_value->field_reporting__quantity.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void EutranCCNMeasReportItem_template::copy_template(const EutranCCNMeasReportItem_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.frequency__list__index().get_selection()) {
single_value->field_frequency__list__index = other_value.frequency__list__index();
} else {
single_value->field_frequency__list__index.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cell__identity().get_selection()) {
single_value->field_cell__identity = other_value.cell__identity();
} else {
single_value->field_cell__identity.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reporting__quantity().get_selection()) {
single_value->field_reporting__quantity = other_value.reporting__quantity();
} else {
single_value->field_reporting__quantity.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new EutranCCNMeasReportItem_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new EutranCCNMeasReportItem_template(*other_value.implication_.precondition);
implication_.implied_template = new EutranCCNMeasReportItem_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem.");
break;
}
set_selection(other_value);
}

EutranCCNMeasReportItem_template::EutranCCNMeasReportItem_template()
{
}

EutranCCNMeasReportItem_template::EutranCCNMeasReportItem_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

EutranCCNMeasReportItem_template::EutranCCNMeasReportItem_template(const EutranCCNMeasReportItem& other_value)
{
copy_value(other_value);
}

EutranCCNMeasReportItem_template::EutranCCNMeasReportItem_template(const OPTIONAL<EutranCCNMeasReportItem>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EutranCCNMeasReportItem&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem from an unbound optional field.");
}
}

EutranCCNMeasReportItem_template::EutranCCNMeasReportItem_template(EutranCCNMeasReportItem_template* p_precondition, EutranCCNMeasReportItem_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

EutranCCNMeasReportItem_template::EutranCCNMeasReportItem_template(Dynamic_Match_Interface<EutranCCNMeasReportItem>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<EutranCCNMeasReportItem>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

EutranCCNMeasReportItem_template::EutranCCNMeasReportItem_template(const EutranCCNMeasReportItem_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

EutranCCNMeasReportItem_template::~EutranCCNMeasReportItem_template()
{
clean_up();
}

EutranCCNMeasReportItem_template& EutranCCNMeasReportItem_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

EutranCCNMeasReportItem_template& EutranCCNMeasReportItem_template::operator=(const EutranCCNMeasReportItem& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

EutranCCNMeasReportItem_template& EutranCCNMeasReportItem_template::operator=(const OPTIONAL<EutranCCNMeasReportItem>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EutranCCNMeasReportItem&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem.");
}
return *this;
}

EutranCCNMeasReportItem_template& EutranCCNMeasReportItem_template::operator=(const EutranCCNMeasReportItem_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean EutranCCNMeasReportItem_template::match(const EutranCCNMeasReportItem& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.frequency__list__index().is_bound()) return FALSE;
if(!single_value->field_frequency__list__index.match(other_value.frequency__list__index(), legacy))return FALSE;
if(!other_value.cell__identity().is_bound()) return FALSE;
if(!single_value->field_cell__identity.match(other_value.cell__identity(), legacy))return FALSE;
if(!other_value.reporting__quantity().is_bound()) return FALSE;
if(!single_value->field_reporting__quantity.match(other_value.reporting__quantity(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem.");
}
return FALSE;
}

boolean EutranCCNMeasReportItem_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_frequency__list__index.is_bound()
 || single_value->field_cell__identity.is_bound()
 || single_value->field_reporting__quantity.is_bound();
}

boolean EutranCCNMeasReportItem_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_frequency__list__index.is_value()
 && single_value->field_cell__identity.is_value()
 && single_value->field_reporting__quantity.is_value();
}

void EutranCCNMeasReportItem_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

EutranCCNMeasReportItem EutranCCNMeasReportItem_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem.");
EutranCCNMeasReportItem ret_val;
if (single_value->field_frequency__list__index.is_bound()) {
ret_val.frequency__list__index() = single_value->field_frequency__list__index.valueof();
}
if (single_value->field_cell__identity.is_bound()) {
ret_val.cell__identity() = single_value->field_cell__identity.valueof();
}
if (single_value->field_reporting__quantity.is_bound()) {
ret_val.reporting__quantity() = single_value->field_reporting__quantity.valueof();
}
return ret_val;
}

void EutranCCNMeasReportItem_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new EutranCCNMeasReportItem_template[list_length];
}

EutranCCNMeasReportItem_template& EutranCCNMeasReportItem_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem.");
return value_list.list_value[list_index];
}

INTEGER_template& EutranCCNMeasReportItem_template::frequency__list__index()
{
set_specific();
return single_value->field_frequency__list__index;
}

const INTEGER_template& EutranCCNMeasReportItem_template::frequency__list__index() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field frequency_list_index of a non-specific template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem.");
return single_value->field_frequency__list__index;
}

INTEGER_template& EutranCCNMeasReportItem_template::cell__identity()
{
set_specific();
return single_value->field_cell__identity;
}

const INTEGER_template& EutranCCNMeasReportItem_template::cell__identity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cell_identity of a non-specific template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem.");
return single_value->field_cell__identity;
}

INTEGER_template& EutranCCNMeasReportItem_template::reporting__quantity()
{
set_specific();
return single_value->field_reporting__quantity;
}

const INTEGER_template& EutranCCNMeasReportItem_template::reporting__quantity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reporting_quantity of a non-specific template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem.");
return single_value->field_reporting__quantity;
}

int EutranCCNMeasReportItem_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem.");
  }
  return 0;
}

void EutranCCNMeasReportItem_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ frequency_list_index := ");
single_value->field_frequency__list__index.log();
TTCN_Logger::log_event_str(", cell_identity := ");
single_value->field_cell__identity.log();
TTCN_Logger::log_event_str(", reporting_quantity := ");
single_value->field_reporting__quantity.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void EutranCCNMeasReportItem_template::log_match(const EutranCCNMeasReportItem& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_frequency__list__index.match(match_value.frequency__list__index(), legacy)){
TTCN_Logger::log_logmatch_info(".frequency_list_index");
single_value->field_frequency__list__index.log_match(match_value.frequency__list__index(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cell__identity.match(match_value.cell__identity(), legacy)){
TTCN_Logger::log_logmatch_info(".cell_identity");
single_value->field_cell__identity.log_match(match_value.cell__identity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reporting__quantity.match(match_value.reporting__quantity(), legacy)){
TTCN_Logger::log_logmatch_info(".reporting_quantity");
single_value->field_reporting__quantity.log_match(match_value.reporting__quantity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ frequency_list_index := ");
single_value->field_frequency__list__index.log_match(match_value.frequency__list__index(), legacy);
TTCN_Logger::log_event_str(", cell_identity := ");
single_value->field_cell__identity.log_match(match_value.cell__identity(), legacy);
TTCN_Logger::log_event_str(", reporting_quantity := ");
single_value->field_reporting__quantity.log_match(match_value.reporting__quantity(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void EutranCCNMeasReportItem_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (frequency__list__index().is_bound()) frequency__list__index().set_implicit_omit();
if (cell__identity().is_bound()) cell__identity().set_implicit_omit();
if (reporting__quantity().is_bound()) reporting__quantity().set_implicit_omit();
}

void EutranCCNMeasReportItem_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_frequency__list__index.encode_text(text_buf);
single_value->field_cell__identity.encode_text(text_buf);
single_value->field_reporting__quantity.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem.");
}
}

void EutranCCNMeasReportItem_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_frequency__list__index.decode_text(text_buf);
single_value->field_cell__identity.decode_text(text_buf);
single_value->field_reporting__quantity.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new EutranCCNMeasReportItem_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem.");
}
}

void EutranCCNMeasReportItem_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    EutranCCNMeasReportItem_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) frequency__list__index().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cell__identity().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) reporting__quantity().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "frequency_list_index")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          frequency__list__index().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cell_identity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cell__identity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reporting_quantity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reporting__quantity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.EutranCCNMeasReportItem: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    EutranCCNMeasReportItem_template* precondition = new EutranCCNMeasReportItem_template;
    precondition->set_param(*param.get_elem(0));
    EutranCCNMeasReportItem_template* implied_template = new EutranCCNMeasReportItem_template;
    implied_template->set_param(*param.get_elem(1));
    *this = EutranCCNMeasReportItem_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.EutranCCNMeasReportItem");
  }
  is_ifpresent = param.get_ifpresent();
}

void EutranCCNMeasReportItem_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_frequency__list__index.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EutranCCNMeasReportItem");
single_value->field_cell__identity.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EutranCCNMeasReportItem");
single_value->field_reporting__quantity.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EutranCCNMeasReportItem");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.EutranCCNMeasReportItem");
}

boolean EutranCCNMeasReportItem_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean EutranCCNMeasReportItem_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

EutranCCNMeasReport::EutranCCNMeasReport()
{
}

EutranCCNMeasReport::EutranCCNMeasReport(const INTEGER& par_utran__ba__used,
    const INTEGER& par_n__eutran,
    const EutranReportingQuantityList& par_cells)
  :   field_utran__ba__used(par_utran__ba__used),
  field_n__eutran(par_n__eutran),
  field_cells(par_cells)
{
}

EutranCCNMeasReport::EutranCCNMeasReport(const EutranCCNMeasReport& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.EutranCCNMeasReport.");
if (other_value.utran__ba__used().is_bound()) field_utran__ba__used = other_value.utran__ba__used();
else field_utran__ba__used.clean_up();
if (other_value.n__eutran().is_bound()) field_n__eutran = other_value.n__eutran();
else field_n__eutran.clean_up();
if (other_value.cells().is_bound()) field_cells = other_value.cells();
else field_cells.clean_up();
}

void EutranCCNMeasReport::clean_up()
{
field_utran__ba__used.clean_up();
field_n__eutran.clean_up();
field_cells.clean_up();
}

const TTCN_Typedescriptor_t* EutranCCNMeasReport::get_descriptor() const { return &EutranCCNMeasReport_descr_; }
EutranCCNMeasReport& EutranCCNMeasReport::operator=(const EutranCCNMeasReport& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.EutranCCNMeasReport.");
  if (other_value.utran__ba__used().is_bound()) field_utran__ba__used = other_value.utran__ba__used();
  else field_utran__ba__used.clean_up();
  if (other_value.n__eutran().is_bound()) field_n__eutran = other_value.n__eutran();
  else field_n__eutran.clean_up();
  if (other_value.cells().is_bound()) field_cells = other_value.cells();
  else field_cells.clean_up();
}
return *this;
}

boolean EutranCCNMeasReport::operator==(const EutranCCNMeasReport& other_value) const
{
return field_utran__ba__used==other_value.field_utran__ba__used
  && field_n__eutran==other_value.field_n__eutran
  && field_cells==other_value.field_cells;
}

boolean EutranCCNMeasReport::is_bound() const
{
return (field_utran__ba__used.is_bound())
  || (field_n__eutran.is_bound())
  || (field_cells.is_bound());
}
boolean EutranCCNMeasReport::is_value() const
{
return field_utran__ba__used.is_value()
  && field_n__eutran.is_value()
  && field_cells.is_value();
}
void EutranCCNMeasReport::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ utran_ba_used := ");
field_utran__ba__used.log();
TTCN_Logger::log_event_str(", n_eutran := ");
field_n__eutran.log();
TTCN_Logger::log_event_str(", cells := ");
field_cells.log();
TTCN_Logger::log_event_str(" }");
}

void EutranCCNMeasReport::set_implicit_omit()
{
if (utran__ba__used().is_bound()) utran__ba__used().set_implicit_omit();
if (n__eutran().is_bound()) n__eutran().set_implicit_omit();
if (cells().is_bound()) cells().set_implicit_omit();
}

void EutranCCNMeasReport::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.EutranCCNMeasReport has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) utran__ba__used().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) n__eutran().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cells().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "utran_ba_used")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          utran__ba__used().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "n_eutran")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          n__eutran().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cells")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cells().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.EutranCCNMeasReport: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.EutranCCNMeasReport");
  }
}

void EutranCCNMeasReport::encode_text(Text_Buf& text_buf) const
{
field_utran__ba__used.encode_text(text_buf);
field_n__eutran.encode_text(text_buf);
field_cells.encode_text(text_buf);
}

void EutranCCNMeasReport::decode_text(Text_Buf& text_buf)
{
field_utran__ba__used.decode_text(text_buf);
field_n__eutran.decode_text(text_buf);
field_cells.decode_text(text_buf);
}

void EutranCCNMeasReport::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void EutranCCNMeasReport::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int EutranCCNMeasReport::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, EutranCCNMeasReport_utran__ba__used_descr_.raw->forceomit);
  decoded_field_length = field_utran__ba__used.RAW_decode(EutranCCNMeasReport_utran__ba__used_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, EutranCCNMeasReport_n__eutran_descr_.raw->forceomit);
  decoded_field_length = field_n__eutran.RAW_decode(EutranCCNMeasReport_n__eutran_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_n__eutran.convert_to_Integer(EutranCCNMeasReport_n__eutran_descr_);
  tmp1 = tmp1 - -1;
  field_n__eutran = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, EutranCCNMeasReport_cells_descr_.raw->forceomit);
  decoded_field_length = field_cells.RAW_decode(EutranCCNMeasReport_cells_descr_, p_buf, limit, local_top_order, no_err, value_of_length_field1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int EutranCCNMeasReport::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, EutranCCNMeasReport_utran__ba__used_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, EutranCCNMeasReport_n__eutran_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, EutranCCNMeasReport_cells_descr_.raw);
  encoded_length += field_utran__ba__used.RAW_encode(EutranCCNMeasReport_utran__ba__used_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 2;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &EutranCCNMeasReport_n__eutran_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = -1;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = -1;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 2;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_cells.RAW_encode(EutranCCNMeasReport_cells_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct EutranCCNMeasReport_template::single_value_struct {
INTEGER_template field_utran__ba__used;
INTEGER_template field_n__eutran;
EutranReportingQuantityList_template field_cells;
};

void EutranCCNMeasReport_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_utran__ba__used = ANY_VALUE;
single_value->field_n__eutran = ANY_VALUE;
single_value->field_cells = ANY_VALUE;
}
}
}

void EutranCCNMeasReport_template::copy_value(const EutranCCNMeasReport& other_value)
{
single_value = new single_value_struct;
if (other_value.utran__ba__used().is_bound()) {
  single_value->field_utran__ba__used = other_value.utran__ba__used();
} else {
  single_value->field_utran__ba__used.clean_up();
}
if (other_value.n__eutran().is_bound()) {
  single_value->field_n__eutran = other_value.n__eutran();
} else {
  single_value->field_n__eutran.clean_up();
}
if (other_value.cells().is_bound()) {
  single_value->field_cells = other_value.cells();
} else {
  single_value->field_cells.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void EutranCCNMeasReport_template::copy_template(const EutranCCNMeasReport_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.utran__ba__used().get_selection()) {
single_value->field_utran__ba__used = other_value.utran__ba__used();
} else {
single_value->field_utran__ba__used.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.n__eutran().get_selection()) {
single_value->field_n__eutran = other_value.n__eutran();
} else {
single_value->field_n__eutran.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cells().get_selection()) {
single_value->field_cells = other_value.cells();
} else {
single_value->field_cells.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new EutranCCNMeasReport_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new EutranCCNMeasReport_template(*other_value.implication_.precondition);
implication_.implied_template = new EutranCCNMeasReport_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport.");
break;
}
set_selection(other_value);
}

EutranCCNMeasReport_template::EutranCCNMeasReport_template()
{
}

EutranCCNMeasReport_template::EutranCCNMeasReport_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

EutranCCNMeasReport_template::EutranCCNMeasReport_template(const EutranCCNMeasReport& other_value)
{
copy_value(other_value);
}

EutranCCNMeasReport_template::EutranCCNMeasReport_template(const OPTIONAL<EutranCCNMeasReport>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EutranCCNMeasReport&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport from an unbound optional field.");
}
}

EutranCCNMeasReport_template::EutranCCNMeasReport_template(EutranCCNMeasReport_template* p_precondition, EutranCCNMeasReport_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

EutranCCNMeasReport_template::EutranCCNMeasReport_template(Dynamic_Match_Interface<EutranCCNMeasReport>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<EutranCCNMeasReport>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

EutranCCNMeasReport_template::EutranCCNMeasReport_template(const EutranCCNMeasReport_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

EutranCCNMeasReport_template::~EutranCCNMeasReport_template()
{
clean_up();
}

EutranCCNMeasReport_template& EutranCCNMeasReport_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

EutranCCNMeasReport_template& EutranCCNMeasReport_template::operator=(const EutranCCNMeasReport& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

EutranCCNMeasReport_template& EutranCCNMeasReport_template::operator=(const OPTIONAL<EutranCCNMeasReport>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EutranCCNMeasReport&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport.");
}
return *this;
}

EutranCCNMeasReport_template& EutranCCNMeasReport_template::operator=(const EutranCCNMeasReport_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean EutranCCNMeasReport_template::match(const EutranCCNMeasReport& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.utran__ba__used().is_bound()) return FALSE;
if(!single_value->field_utran__ba__used.match(other_value.utran__ba__used(), legacy))return FALSE;
if(!other_value.n__eutran().is_bound()) return FALSE;
if(!single_value->field_n__eutran.match(other_value.n__eutran(), legacy))return FALSE;
if(!other_value.cells().is_bound()) return FALSE;
if(!single_value->field_cells.match(other_value.cells(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport.");
}
return FALSE;
}

boolean EutranCCNMeasReport_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_utran__ba__used.is_bound()
 || single_value->field_n__eutran.is_bound()
 || single_value->field_cells.is_bound();
}

boolean EutranCCNMeasReport_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_utran__ba__used.is_value()
 && single_value->field_n__eutran.is_value()
 && single_value->field_cells.is_value();
}

void EutranCCNMeasReport_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

EutranCCNMeasReport EutranCCNMeasReport_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport.");
EutranCCNMeasReport ret_val;
if (single_value->field_utran__ba__used.is_bound()) {
ret_val.utran__ba__used() = single_value->field_utran__ba__used.valueof();
}
if (single_value->field_n__eutran.is_bound()) {
ret_val.n__eutran() = single_value->field_n__eutran.valueof();
}
if (single_value->field_cells.is_bound()) {
ret_val.cells() = single_value->field_cells.valueof();
}
return ret_val;
}

void EutranCCNMeasReport_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new EutranCCNMeasReport_template[list_length];
}

EutranCCNMeasReport_template& EutranCCNMeasReport_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport.");
return value_list.list_value[list_index];
}

INTEGER_template& EutranCCNMeasReport_template::utran__ba__used()
{
set_specific();
return single_value->field_utran__ba__used;
}

const INTEGER_template& EutranCCNMeasReport_template::utran__ba__used() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field utran_ba_used of a non-specific template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport.");
return single_value->field_utran__ba__used;
}

INTEGER_template& EutranCCNMeasReport_template::n__eutran()
{
set_specific();
return single_value->field_n__eutran;
}

const INTEGER_template& EutranCCNMeasReport_template::n__eutran() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field n_eutran of a non-specific template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport.");
return single_value->field_n__eutran;
}

EutranReportingQuantityList_template& EutranCCNMeasReport_template::cells()
{
set_specific();
return single_value->field_cells;
}

const EutranReportingQuantityList_template& EutranCCNMeasReport_template::cells() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cells of a non-specific template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport.");
return single_value->field_cells;
}

int EutranCCNMeasReport_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport.");
  }
  return 0;
}

void EutranCCNMeasReport_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ utran_ba_used := ");
single_value->field_utran__ba__used.log();
TTCN_Logger::log_event_str(", n_eutran := ");
single_value->field_n__eutran.log();
TTCN_Logger::log_event_str(", cells := ");
single_value->field_cells.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void EutranCCNMeasReport_template::log_match(const EutranCCNMeasReport& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_utran__ba__used.match(match_value.utran__ba__used(), legacy)){
TTCN_Logger::log_logmatch_info(".utran_ba_used");
single_value->field_utran__ba__used.log_match(match_value.utran__ba__used(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_n__eutran.match(match_value.n__eutran(), legacy)){
TTCN_Logger::log_logmatch_info(".n_eutran");
single_value->field_n__eutran.log_match(match_value.n__eutran(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cells.match(match_value.cells(), legacy)){
TTCN_Logger::log_logmatch_info(".cells");
single_value->field_cells.log_match(match_value.cells(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ utran_ba_used := ");
single_value->field_utran__ba__used.log_match(match_value.utran__ba__used(), legacy);
TTCN_Logger::log_event_str(", n_eutran := ");
single_value->field_n__eutran.log_match(match_value.n__eutran(), legacy);
TTCN_Logger::log_event_str(", cells := ");
single_value->field_cells.log_match(match_value.cells(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void EutranCCNMeasReport_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (utran__ba__used().is_bound()) utran__ba__used().set_implicit_omit();
if (n__eutran().is_bound()) n__eutran().set_implicit_omit();
if (cells().is_bound()) cells().set_implicit_omit();
}

void EutranCCNMeasReport_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_utran__ba__used.encode_text(text_buf);
single_value->field_n__eutran.encode_text(text_buf);
single_value->field_cells.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport.");
}
}

void EutranCCNMeasReport_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_utran__ba__used.decode_text(text_buf);
single_value->field_n__eutran.decode_text(text_buf);
single_value->field_cells.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new EutranCCNMeasReport_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport.");
}
}

void EutranCCNMeasReport_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    EutranCCNMeasReport_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.EutranCCNMeasReport has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) utran__ba__used().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) n__eutran().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cells().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "utran_ba_used")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          utran__ba__used().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "n_eutran")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          n__eutran().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cells")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cells().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.EutranCCNMeasReport: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    EutranCCNMeasReport_template* precondition = new EutranCCNMeasReport_template;
    precondition->set_param(*param.get_elem(0));
    EutranCCNMeasReport_template* implied_template = new EutranCCNMeasReport_template;
    implied_template->set_param(*param.get_elem(1));
    *this = EutranCCNMeasReport_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.EutranCCNMeasReport");
  }
  is_ifpresent = param.get_ifpresent();
}

void EutranCCNMeasReport_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_utran__ba__used.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EutranCCNMeasReport");
single_value->field_n__eutran.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EutranCCNMeasReport");
single_value->field_cells.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.EutranCCNMeasReport");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.EutranCCNMeasReport");
}

boolean EutranCCNMeasReport_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean EutranCCNMeasReport_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

NCMeasurementItem::NCMeasurementItem()
{
}

NCMeasurementItem::NCMeasurementItem(const INTEGER& par_freq,
    const BITSTRING& par_bsic__presence,
    const OPTIONAL< INTEGER >& par_bsic,
    const INTEGER& par_rxlev)
  :   field_freq(par_freq),
  field_bsic__presence(par_bsic__presence),
  field_bsic(par_bsic),
  field_rxlev(par_rxlev)
{
}

NCMeasurementItem::NCMeasurementItem(const NCMeasurementItem& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.NCMeasurementItem.");
if (other_value.freq().is_bound()) field_freq = other_value.freq();
else field_freq.clean_up();
if (other_value.bsic__presence().is_bound()) field_bsic__presence = other_value.bsic__presence();
else field_bsic__presence.clean_up();
if (other_value.bsic().is_bound()) field_bsic = other_value.bsic();
else field_bsic.clean_up();
if (other_value.rxlev().is_bound()) field_rxlev = other_value.rxlev();
else field_rxlev.clean_up();
}

void NCMeasurementItem::clean_up()
{
field_freq.clean_up();
field_bsic__presence.clean_up();
field_bsic.clean_up();
field_rxlev.clean_up();
}

const TTCN_Typedescriptor_t* NCMeasurementItem::get_descriptor() const { return &NCMeasurementItem_descr_; }
NCMeasurementItem& NCMeasurementItem::operator=(const NCMeasurementItem& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.NCMeasurementItem.");
  if (other_value.freq().is_bound()) field_freq = other_value.freq();
  else field_freq.clean_up();
  if (other_value.bsic__presence().is_bound()) field_bsic__presence = other_value.bsic__presence();
  else field_bsic__presence.clean_up();
  if (other_value.bsic().is_bound()) field_bsic = other_value.bsic();
  else field_bsic.clean_up();
  if (other_value.rxlev().is_bound()) field_rxlev = other_value.rxlev();
  else field_rxlev.clean_up();
}
return *this;
}

boolean NCMeasurementItem::operator==(const NCMeasurementItem& other_value) const
{
return field_freq==other_value.field_freq
  && field_bsic__presence==other_value.field_bsic__presence
  && field_bsic==other_value.field_bsic
  && field_rxlev==other_value.field_rxlev;
}

boolean NCMeasurementItem::is_bound() const
{
return (field_freq.is_bound())
  || (field_bsic__presence.is_bound())
  || (OPTIONAL_OMIT == field_bsic.get_selection() || field_bsic.is_bound())
  || (field_rxlev.is_bound());
}
boolean NCMeasurementItem::is_value() const
{
return field_freq.is_value()
  && field_bsic__presence.is_value()
  && (OPTIONAL_OMIT == field_bsic.get_selection() || field_bsic.is_value())
  && field_rxlev.is_value();
}
int NCMeasurementItem::size_of() const
{
  int ret_val = 3;
  if (field_bsic.ispresent()) ret_val++;
  return ret_val;
}

void NCMeasurementItem::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ freq := ");
field_freq.log();
TTCN_Logger::log_event_str(", bsic_presence := ");
field_bsic__presence.log();
TTCN_Logger::log_event_str(", bsic := ");
field_bsic.log();
TTCN_Logger::log_event_str(", rxlev := ");
field_rxlev.log();
TTCN_Logger::log_event_str(" }");
}

void NCMeasurementItem::set_implicit_omit()
{
if (freq().is_bound()) freq().set_implicit_omit();
if (bsic__presence().is_bound()) bsic__presence().set_implicit_omit();
if (!bsic().is_bound()) bsic() = OMIT_VALUE;
else bsic().set_implicit_omit();
if (rxlev().is_bound()) rxlev().set_implicit_omit();
}

void NCMeasurementItem::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.NCMeasurementItem has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) freq().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) bsic__presence().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) bsic().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rxlev().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "freq")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          freq().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bsic_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bsic__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bsic")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bsic().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rxlev")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rxlev().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.NCMeasurementItem: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.NCMeasurementItem");
  }
}

void NCMeasurementItem::encode_text(Text_Buf& text_buf) const
{
field_freq.encode_text(text_buf);
field_bsic__presence.encode_text(text_buf);
field_bsic.encode_text(text_buf);
field_rxlev.encode_text(text_buf);
}

void NCMeasurementItem::decode_text(Text_Buf& text_buf)
{
field_freq.decode_text(text_buf);
field_bsic__presence.decode_text(text_buf);
field_bsic.decode_text(text_buf);
field_rxlev.decode_text(text_buf);
}

void NCMeasurementItem::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void NCMeasurementItem::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int NCMeasurementItem::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, NCMeasurementItem_freq_descr_.raw->forceomit);
  decoded_field_length = field_freq.RAW_decode(NCMeasurementItem_freq_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, NCMeasurementItem_bsic__presence_descr_.raw->forceomit);
  decoded_field_length = field_bsic__presence.RAW_decode(NCMeasurementItem_bsic__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_bsic__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_bsic = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, NCMeasurementItem_bsic_descr_.raw->forceomit);
  decoded_field_length = field_bsic().RAW_decode(NCMeasurementItem_bsic_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_bsic = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_bsic=OMIT_VALUE;
  RAW_Force_Omit field_3_force_omit(3, force_omit, NCMeasurementItem_rxlev_descr_.raw->forceomit);
  decoded_field_length = field_rxlev.RAW_decode(NCMeasurementItem_rxlev_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int NCMeasurementItem::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, NCMeasurementItem_freq_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, NCMeasurementItem_bsic__presence_descr_.raw);
  if (field_bsic.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, NCMeasurementItem_bsic_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, NCMeasurementItem_rxlev_descr_.raw);
  encoded_length += field_freq.RAW_encode(NCMeasurementItem_freq_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_bsic__presence.RAW_encode(NCMeasurementItem_bsic__presence_descr_, *myleaf.body.node.nodes[1]);
  if (field_bsic.ispresent()) {
  encoded_length += field_bsic().RAW_encode(NCMeasurementItem_bsic_descr_, *myleaf.body.node.nodes[2]);
  }
  encoded_length += field_rxlev.RAW_encode(NCMeasurementItem_rxlev_descr_, *myleaf.body.node.nodes[3]);
  if (field_bsic.ispresent() && (field_bsic__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={1};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(NCMeasurementItem_bsic__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct NCMeasurementItem_template::single_value_struct {
INTEGER_template field_freq;
BITSTRING_template field_bsic__presence;
INTEGER_template field_bsic;
INTEGER_template field_rxlev;
};

void NCMeasurementItem_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_freq = ANY_VALUE;
single_value->field_bsic__presence = ANY_VALUE;
single_value->field_bsic = ANY_OR_OMIT;
single_value->field_rxlev = ANY_VALUE;
}
}
}

void NCMeasurementItem_template::copy_value(const NCMeasurementItem& other_value)
{
single_value = new single_value_struct;
if (other_value.freq().is_bound()) {
  single_value->field_freq = other_value.freq();
} else {
  single_value->field_freq.clean_up();
}
if (other_value.bsic__presence().is_bound()) {
  single_value->field_bsic__presence = other_value.bsic__presence();
} else {
  single_value->field_bsic__presence.clean_up();
}
if (other_value.bsic().is_bound()) {
  if (other_value.bsic().ispresent()) single_value->field_bsic = other_value.bsic()();
  else single_value->field_bsic = OMIT_VALUE;
} else {
  single_value->field_bsic.clean_up();
}
if (other_value.rxlev().is_bound()) {
  single_value->field_rxlev = other_value.rxlev();
} else {
  single_value->field_rxlev.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void NCMeasurementItem_template::copy_template(const NCMeasurementItem_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.freq().get_selection()) {
single_value->field_freq = other_value.freq();
} else {
single_value->field_freq.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bsic__presence().get_selection()) {
single_value->field_bsic__presence = other_value.bsic__presence();
} else {
single_value->field_bsic__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bsic().get_selection()) {
single_value->field_bsic = other_value.bsic();
} else {
single_value->field_bsic.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rxlev().get_selection()) {
single_value->field_rxlev = other_value.rxlev();
} else {
single_value->field_rxlev.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new NCMeasurementItem_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new NCMeasurementItem_template(*other_value.implication_.precondition);
implication_.implied_template = new NCMeasurementItem_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurementItem.");
break;
}
set_selection(other_value);
}

NCMeasurementItem_template::NCMeasurementItem_template()
{
}

NCMeasurementItem_template::NCMeasurementItem_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

NCMeasurementItem_template::NCMeasurementItem_template(const NCMeasurementItem& other_value)
{
copy_value(other_value);
}

NCMeasurementItem_template::NCMeasurementItem_template(const OPTIONAL<NCMeasurementItem>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NCMeasurementItem&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.NCMeasurementItem from an unbound optional field.");
}
}

NCMeasurementItem_template::NCMeasurementItem_template(NCMeasurementItem_template* p_precondition, NCMeasurementItem_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

NCMeasurementItem_template::NCMeasurementItem_template(Dynamic_Match_Interface<NCMeasurementItem>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<NCMeasurementItem>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

NCMeasurementItem_template::NCMeasurementItem_template(const NCMeasurementItem_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

NCMeasurementItem_template::~NCMeasurementItem_template()
{
clean_up();
}

NCMeasurementItem_template& NCMeasurementItem_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

NCMeasurementItem_template& NCMeasurementItem_template::operator=(const NCMeasurementItem& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

NCMeasurementItem_template& NCMeasurementItem_template::operator=(const OPTIONAL<NCMeasurementItem>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NCMeasurementItem&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.NCMeasurementItem.");
}
return *this;
}

NCMeasurementItem_template& NCMeasurementItem_template::operator=(const NCMeasurementItem_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean NCMeasurementItem_template::match(const NCMeasurementItem& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.freq().is_bound()) return FALSE;
if(!single_value->field_freq.match(other_value.freq(), legacy))return FALSE;
if(!other_value.bsic__presence().is_bound()) return FALSE;
if(!single_value->field_bsic__presence.match(other_value.bsic__presence(), legacy))return FALSE;
if(!other_value.bsic().is_bound()) return FALSE;
if((other_value.bsic().ispresent() ? !single_value->field_bsic.match((const INTEGER&)other_value.bsic(), legacy) : !single_value->field_bsic.match_omit(legacy)))return FALSE;
if(!other_value.rxlev().is_bound()) return FALSE;
if(!single_value->field_rxlev.match(other_value.rxlev(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurementItem.");
}
return FALSE;
}

boolean NCMeasurementItem_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_freq.is_bound()
 || single_value->field_bsic__presence.is_bound()
 || (single_value->field_bsic.is_omit() || single_value->field_bsic.is_bound())
 || single_value->field_rxlev.is_bound();
}

boolean NCMeasurementItem_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_freq.is_value()
 && single_value->field_bsic__presence.is_value()
 && (single_value->field_bsic.is_omit() || single_value->field_bsic.is_value())
 && single_value->field_rxlev.is_value();
}

void NCMeasurementItem_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

NCMeasurementItem NCMeasurementItem_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurementItem.");
NCMeasurementItem ret_val;
if (single_value->field_freq.is_bound()) {
ret_val.freq() = single_value->field_freq.valueof();
}
if (single_value->field_bsic__presence.is_bound()) {
ret_val.bsic__presence() = single_value->field_bsic__presence.valueof();
}
if (single_value->field_bsic.is_omit()) ret_val.bsic() = OMIT_VALUE;
else if (single_value->field_bsic.is_bound()) {
ret_val.bsic() = single_value->field_bsic.valueof();
}
if (single_value->field_rxlev.is_bound()) {
ret_val.rxlev() = single_value->field_rxlev.valueof();
}
return ret_val;
}

void NCMeasurementItem_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.NCMeasurementItem.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new NCMeasurementItem_template[list_length];
}

NCMeasurementItem_template& NCMeasurementItem_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.NCMeasurementItem.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.NCMeasurementItem.");
return value_list.list_value[list_index];
}

INTEGER_template& NCMeasurementItem_template::freq()
{
set_specific();
return single_value->field_freq;
}

const INTEGER_template& NCMeasurementItem_template::freq() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field freq of a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurementItem.");
return single_value->field_freq;
}

BITSTRING_template& NCMeasurementItem_template::bsic__presence()
{
set_specific();
return single_value->field_bsic__presence;
}

const BITSTRING_template& NCMeasurementItem_template::bsic__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bsic_presence of a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurementItem.");
return single_value->field_bsic__presence;
}

INTEGER_template& NCMeasurementItem_template::bsic()
{
set_specific();
return single_value->field_bsic;
}

const INTEGER_template& NCMeasurementItem_template::bsic() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bsic of a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurementItem.");
return single_value->field_bsic;
}

INTEGER_template& NCMeasurementItem_template::rxlev()
{
set_specific();
return single_value->field_rxlev;
}

const INTEGER_template& NCMeasurementItem_template::rxlev() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rxlev of a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurementItem.");
return single_value->field_rxlev;
}

int NCMeasurementItem_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementItem which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 3;
      if (single_value->field_bsic.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementItem containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementItem containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementItem containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementItem containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementItem containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementItem containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementItem containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurementItem containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurementItem.");
  }
  return 0;
}

void NCMeasurementItem_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ freq := ");
single_value->field_freq.log();
TTCN_Logger::log_event_str(", bsic_presence := ");
single_value->field_bsic__presence.log();
TTCN_Logger::log_event_str(", bsic := ");
single_value->field_bsic.log();
TTCN_Logger::log_event_str(", rxlev := ");
single_value->field_rxlev.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void NCMeasurementItem_template::log_match(const NCMeasurementItem& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_freq.match(match_value.freq(), legacy)){
TTCN_Logger::log_logmatch_info(".freq");
single_value->field_freq.log_match(match_value.freq(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_bsic__presence.match(match_value.bsic__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".bsic_presence");
single_value->field_bsic__presence.log_match(match_value.bsic__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.bsic().ispresent()){
if(!single_value->field_bsic.match(match_value.bsic(), legacy)){
TTCN_Logger::log_logmatch_info(".bsic");
single_value->field_bsic.log_match(match_value.bsic(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_bsic.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".bsic := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_bsic.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_rxlev.match(match_value.rxlev(), legacy)){
TTCN_Logger::log_logmatch_info(".rxlev");
single_value->field_rxlev.log_match(match_value.rxlev(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ freq := ");
single_value->field_freq.log_match(match_value.freq(), legacy);
TTCN_Logger::log_event_str(", bsic_presence := ");
single_value->field_bsic__presence.log_match(match_value.bsic__presence(), legacy);
TTCN_Logger::log_event_str(", bsic := ");
if (match_value.bsic().ispresent()) {
single_value->field_bsic.log_match(match_value.bsic(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_bsic.log();
if (single_value->field_bsic.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", rxlev := ");
single_value->field_rxlev.log_match(match_value.rxlev(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void NCMeasurementItem_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (freq().is_bound()) freq().set_implicit_omit();
if (bsic__presence().is_bound()) bsic__presence().set_implicit_omit();
if (!bsic().is_bound()) bsic() = OMIT_VALUE;
else bsic().set_implicit_omit();
if (rxlev().is_bound()) rxlev().set_implicit_omit();
}

void NCMeasurementItem_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_freq.encode_text(text_buf);
single_value->field_bsic__presence.encode_text(text_buf);
single_value->field_bsic.encode_text(text_buf);
single_value->field_rxlev.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurementItem.");
}
}

void NCMeasurementItem_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_freq.decode_text(text_buf);
single_value->field_bsic__presence.decode_text(text_buf);
single_value->field_bsic.decode_text(text_buf);
single_value->field_rxlev.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new NCMeasurementItem_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.NCMeasurementItem.");
}
}

void NCMeasurementItem_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    NCMeasurementItem_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.NCMeasurementItem has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) freq().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) bsic__presence().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) bsic().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rxlev().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "freq")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          freq().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bsic_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bsic__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bsic")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bsic().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rxlev")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rxlev().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.NCMeasurementItem: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    NCMeasurementItem_template* precondition = new NCMeasurementItem_template;
    precondition->set_param(*param.get_elem(0));
    NCMeasurementItem_template* implied_template = new NCMeasurementItem_template;
    implied_template->set_param(*param.get_elem(1));
    *this = NCMeasurementItem_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.NCMeasurementItem");
  }
  is_ifpresent = param.get_ifpresent();
}

void NCMeasurementItem_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_freq.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurementItem");
single_value->field_bsic__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurementItem");
single_value->field_bsic.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurementItem");
single_value->field_rxlev.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurementItem");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurementItem");
}

boolean NCMeasurementItem_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean NCMeasurementItem_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const NCMeasurementItem NCMeasurements::UNBOUND_ELEM;
NCMeasurements::NCMeasurements()
{
val_ptr = NULL;
}

NCMeasurements::NCMeasurements(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

NCMeasurements::NCMeasurements(const NCMeasurements& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.NCMeasurements.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

NCMeasurements::~NCMeasurements()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void NCMeasurements::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

NCMeasurements& NCMeasurements::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

NCMeasurements& NCMeasurements::operator=(const NCMeasurements& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @RLCMAC_CSN1_Types.NCMeasurements.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean NCMeasurements::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @RLCMAC_CSN1_Types.NCMeasurements.");
return val_ptr->n_elements == 0 ;
}

boolean NCMeasurements::operator==(const NCMeasurements& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @RLCMAC_CSN1_Types.NCMeasurements.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @RLCMAC_CSN1_Types.NCMeasurements.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

NCMeasurementItem& NCMeasurements::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @RLCMAC_CSN1_Types.NCMeasurements using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (NCMeasurementItem**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new NCMeasurementItem(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new NCMeasurementItem;
}
return *val_ptr->value_elements[index_value];
}

NCMeasurementItem& NCMeasurements::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RLCMAC_CSN1_Types.NCMeasurements.");
return (*this)[(int)index_value];
}

const NCMeasurementItem& NCMeasurements::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @RLCMAC_CSN1_Types.NCMeasurements.");
if (index_value < 0) TTCN_error("Accessing an element of type @RLCMAC_CSN1_Types.NCMeasurements using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @RLCMAC_CSN1_Types.NCMeasurements: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const NCMeasurementItem& NCMeasurements::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @RLCMAC_CSN1_Types.NCMeasurements.");
return (*this)[(int)index_value];
}

NCMeasurements NCMeasurements::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

NCMeasurements NCMeasurements::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

NCMeasurements NCMeasurements::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

NCMeasurements NCMeasurements::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @RLCMAC_CSN1_Types.NCMeasurements.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
NCMeasurements ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new NCMeasurementItem(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

NCMeasurements NCMeasurements::operator+(const NCMeasurements& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @RLCMAC_CSN1_Types.NCMeasurements concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
NCMeasurements ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new NCMeasurementItem(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new NCMeasurementItem(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

NCMeasurements NCMeasurements::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @RLCMAC_CSN1_Types.NCMeasurements.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@RLCMAC_CSN1_Types.NCMeasurements","element");
NCMeasurements ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new NCMeasurementItem(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

NCMeasurements NCMeasurements::replace(int index, int len, const NCMeasurements& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @RLCMAC_CSN1_Types.NCMeasurements.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @RLCMAC_CSN1_Types.NCMeasurements.");
check_replace_arguments(val_ptr->n_elements, index, len, "@RLCMAC_CSN1_Types.NCMeasurements","element");
NCMeasurements ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new NCMeasurementItem(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new NCMeasurementItem(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new NCMeasurementItem(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

NCMeasurements NCMeasurements::replace(int index, int len, const NCMeasurements_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void NCMeasurements::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @RLCMAC_CSN1_Types.NCMeasurements.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (NCMeasurementItem**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new NCMeasurementItem(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (NCMeasurementItem**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @RLCMAC_CSN1_Types.NCMeasurements: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (NCMeasurementItem**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean NCMeasurements::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int NCMeasurements::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @RLCMAC_CSN1_Types.NCMeasurements.");
return val_ptr->n_elements;
}

int NCMeasurements::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @RLCMAC_CSN1_Types.NCMeasurements.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void NCMeasurements::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void NCMeasurements::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void NCMeasurements::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@RLCMAC_CSN1_Types.NCMeasurements");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@RLCMAC_CSN1_Types.NCMeasurements");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void NCMeasurements::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @RLCMAC_CSN1_Types.NCMeasurements.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void NCMeasurements::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @RLCMAC_CSN1_Types.NCMeasurements.");
val_ptr->value_elements = (NCMeasurementItem**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new NCMeasurementItem;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void NCMeasurements::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void NCMeasurements::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int NCMeasurements::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int NCMeasurements::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void NCMeasurements_template::copy_value(const NCMeasurements& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @RLCMAC_CSN1_Types.NCMeasurements with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (NCMeasurementItem_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new NCMeasurementItem_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new NCMeasurementItem_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void NCMeasurements_template::copy_template(const NCMeasurements_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (NCMeasurementItem_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new NCMeasurementItem_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new NCMeasurementItem_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new NCMeasurements_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new NCMeasurements_template(*other_value.implication_.precondition);
implication_.implied_template = new NCMeasurements_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurements.");
break;
}
set_selection(other_value);
}

boolean NCMeasurements_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const NCMeasurements_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const NCMeasurements*)value_ptr)[value_index], legacy);
else return ((const NCMeasurements_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

NCMeasurements_template::NCMeasurements_template()
{
}

NCMeasurements_template::NCMeasurements_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

NCMeasurements_template::NCMeasurements_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

NCMeasurements_template::NCMeasurements_template(const NCMeasurements& other_value)
{
copy_value(other_value);
}

NCMeasurements_template::NCMeasurements_template(const OPTIONAL<NCMeasurements>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NCMeasurements&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.NCMeasurements from an unbound optional field.");
}
}

NCMeasurements_template::NCMeasurements_template(NCMeasurements_template* p_precondition, NCMeasurements_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

NCMeasurements_template::NCMeasurements_template(Dynamic_Match_Interface<NCMeasurements>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<NCMeasurements>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

NCMeasurements_template::NCMeasurements_template(const NCMeasurements_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

NCMeasurements_template::~NCMeasurements_template()
{
clean_up();
}

void NCMeasurements_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

NCMeasurements_template& NCMeasurements_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

NCMeasurements_template& NCMeasurements_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

NCMeasurements_template& NCMeasurements_template::operator=(const NCMeasurements& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

NCMeasurements_template& NCMeasurements_template::operator=(const OPTIONAL<NCMeasurements>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NCMeasurements&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.NCMeasurements.");
}
return *this;
}

NCMeasurements_template& NCMeasurements_template::operator=(const NCMeasurements_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

NCMeasurementItem_template& NCMeasurements_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RLCMAC_CSN1_Types.NCMeasurements using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @RLCMAC_CSN1_Types.NCMeasurements.");
    break;
}
return *single_value.value_elements[index_value];
}

NCMeasurementItem_template& NCMeasurements_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RLCMAC_CSN1_Types.NCMeasurements.");
return (*this)[(int)index_value];
}

const NCMeasurementItem_template& NCMeasurements_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @RLCMAC_CSN1_Types.NCMeasurements using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @RLCMAC_CSN1_Types.NCMeasurements.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @RLCMAC_CSN1_Types.NCMeasurements: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const NCMeasurementItem_template& NCMeasurements_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @RLCMAC_CSN1_Types.NCMeasurements.");
return (*this)[(int)index_value];
}

void NCMeasurements_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @RLCMAC_CSN1_Types.NCMeasurements.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (NCMeasurementItem_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new NCMeasurementItem_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new NCMeasurementItem_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (NCMeasurementItem_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int NCMeasurements_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int NCMeasurements_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurements which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurements containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurements containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurements containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurements containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @RLCMAC_CSN1_Types.NCMeasurements containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurements.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @RLCMAC_CSN1_Types.NCMeasurements");
}

boolean NCMeasurements_template::match(const NCMeasurements& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurements.");
}
return FALSE;
}

boolean NCMeasurements_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

NCMeasurements NCMeasurements_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.NCMeasurements.");
NCMeasurements ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

NCMeasurements NCMeasurements_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

NCMeasurements NCMeasurements_template::replace(int index, int len, const NCMeasurements_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

NCMeasurements NCMeasurements_template::replace(int index, int len, const NCMeasurements& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void NCMeasurements_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new NCMeasurements_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @RLCMAC_CSN1_Types.NCMeasurements.");
}
set_selection(template_type);
}

NCMeasurements_template& NCMeasurements_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.NCMeasurements.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @RLCMAC_CSN1_Types.NCMeasurements.");
return value_list.list_value[list_index];
}

void NCMeasurements_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void NCMeasurements_template::log_match(const NCMeasurements& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void NCMeasurements_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.NCMeasurements.");
}
}

void NCMeasurements_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @RLCMAC_CSN1_Types.NCMeasurements.");
single_value.value_elements = (NCMeasurementItem_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new NCMeasurementItem_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new NCMeasurements_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @RLCMAC_CSN1_Types.NCMeasurements.");
}
}

boolean NCMeasurements_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean NCMeasurements_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void NCMeasurements_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void NCMeasurements_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    NCMeasurements_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    NCMeasurements_template* precondition = new NCMeasurements_template;
    precondition->set_param(*param.get_elem(0));
    NCMeasurements_template* implied_template = new NCMeasurements_template;
    implied_template->set_param(*param.get_elem(1));
    *this = NCMeasurements_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@RLCMAC_CSN1_Types.NCMeasurements");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void NCMeasurements_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurements");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.NCMeasurements");
}

boolean NCMeasurements_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
CCNMeasReport::CCNMeasReport()
{
}

CCNMeasReport::CCNMeasReport(const INTEGER& par_rxlev__servig__cell,
    const BITSTRING& par_zero,
    const INTEGER& par_num__meas,
    const NCMeasurements& par_meas)
  :   field_rxlev__servig__cell(par_rxlev__servig__cell),
  field_zero(par_zero),
  field_num__meas(par_num__meas),
  field_meas(par_meas)
{
}

CCNMeasReport::CCNMeasReport(const CCNMeasReport& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.CCNMeasReport.");
if (other_value.rxlev__servig__cell().is_bound()) field_rxlev__servig__cell = other_value.rxlev__servig__cell();
else field_rxlev__servig__cell.clean_up();
if (other_value.zero().is_bound()) field_zero = other_value.zero();
else field_zero.clean_up();
if (other_value.num__meas().is_bound()) field_num__meas = other_value.num__meas();
else field_num__meas.clean_up();
if (other_value.meas().is_bound()) field_meas = other_value.meas();
else field_meas.clean_up();
}

void CCNMeasReport::clean_up()
{
field_rxlev__servig__cell.clean_up();
field_zero.clean_up();
field_num__meas.clean_up();
field_meas.clean_up();
}

const TTCN_Typedescriptor_t* CCNMeasReport::get_descriptor() const { return &CCNMeasReport_descr_; }
CCNMeasReport& CCNMeasReport::operator=(const CCNMeasReport& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.CCNMeasReport.");
  if (other_value.rxlev__servig__cell().is_bound()) field_rxlev__servig__cell = other_value.rxlev__servig__cell();
  else field_rxlev__servig__cell.clean_up();
  if (other_value.zero().is_bound()) field_zero = other_value.zero();
  else field_zero.clean_up();
  if (other_value.num__meas().is_bound()) field_num__meas = other_value.num__meas();
  else field_num__meas.clean_up();
  if (other_value.meas().is_bound()) field_meas = other_value.meas();
  else field_meas.clean_up();
}
return *this;
}

boolean CCNMeasReport::operator==(const CCNMeasReport& other_value) const
{
return field_rxlev__servig__cell==other_value.field_rxlev__servig__cell
  && field_zero==other_value.field_zero
  && field_num__meas==other_value.field_num__meas
  && field_meas==other_value.field_meas;
}

boolean CCNMeasReport::is_bound() const
{
return (field_rxlev__servig__cell.is_bound())
  || (field_zero.is_bound())
  || (field_num__meas.is_bound())
  || (field_meas.is_bound());
}
boolean CCNMeasReport::is_value() const
{
return field_rxlev__servig__cell.is_value()
  && field_zero.is_value()
  && field_num__meas.is_value()
  && field_meas.is_value();
}
void CCNMeasReport::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ rxlev_servig_cell := ");
field_rxlev__servig__cell.log();
TTCN_Logger::log_event_str(", zero := ");
field_zero.log();
TTCN_Logger::log_event_str(", num_meas := ");
field_num__meas.log();
TTCN_Logger::log_event_str(", meas := ");
field_meas.log();
TTCN_Logger::log_event_str(" }");
}

void CCNMeasReport::set_implicit_omit()
{
if (rxlev__servig__cell().is_bound()) rxlev__servig__cell().set_implicit_omit();
if (zero().is_bound()) zero().set_implicit_omit();
if (num__meas().is_bound()) num__meas().set_implicit_omit();
if (meas().is_bound()) meas().set_implicit_omit();
}

void CCNMeasReport::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.CCNMeasReport has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) rxlev__servig__cell().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) zero().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) num__meas().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) meas().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rxlev_servig_cell")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rxlev__servig__cell().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "zero")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          zero().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "num_meas")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          num__meas().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "meas")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          meas().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.CCNMeasReport: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.CCNMeasReport");
  }
}

void CCNMeasReport::encode_text(Text_Buf& text_buf) const
{
field_rxlev__servig__cell.encode_text(text_buf);
field_zero.encode_text(text_buf);
field_num__meas.encode_text(text_buf);
field_meas.encode_text(text_buf);
}

void CCNMeasReport::decode_text(Text_Buf& text_buf)
{
field_rxlev__servig__cell.decode_text(text_buf);
field_zero.decode_text(text_buf);
field_num__meas.decode_text(text_buf);
field_meas.decode_text(text_buf);
}

void CCNMeasReport::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void CCNMeasReport::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int CCNMeasReport::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, CCNMeasReport_rxlev__servig__cell_descr_.raw->forceomit);
  decoded_field_length = field_rxlev__servig__cell.RAW_decode(CCNMeasReport_rxlev__servig__cell_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, CCNMeasReport_zero_descr_.raw->forceomit);
  decoded_field_length = field_zero.RAW_decode(CCNMeasReport_zero_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, CCNMeasReport_num__meas_descr_.raw->forceomit);
  decoded_field_length = field_num__meas.RAW_decode(CCNMeasReport_num__meas_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, CCNMeasReport_meas_descr_.raw->forceomit);
  decoded_field_length = field_meas.RAW_decode(CCNMeasReport_meas_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int CCNMeasReport::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, CCNMeasReport_rxlev__servig__cell_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, CCNMeasReport_zero_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, CCNMeasReport_num__meas_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, CCNMeasReport_meas_descr_.raw);
  encoded_length += field_rxlev__servig__cell.RAW_encode(CCNMeasReport_rxlev__servig__cell_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_zero.RAW_encode(CCNMeasReport_zero_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_num__meas.RAW_encode(CCNMeasReport_num__meas_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_meas.RAW_encode(CCNMeasReport_meas_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct CCNMeasReport_template::single_value_struct {
INTEGER_template field_rxlev__servig__cell;
BITSTRING_template field_zero;
INTEGER_template field_num__meas;
NCMeasurements_template field_meas;
};

void CCNMeasReport_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_rxlev__servig__cell = ANY_VALUE;
single_value->field_zero = ANY_VALUE;
single_value->field_num__meas = ANY_VALUE;
single_value->field_meas = ANY_VALUE;
}
}
}

void CCNMeasReport_template::copy_value(const CCNMeasReport& other_value)
{
single_value = new single_value_struct;
if (other_value.rxlev__servig__cell().is_bound()) {
  single_value->field_rxlev__servig__cell = other_value.rxlev__servig__cell();
} else {
  single_value->field_rxlev__servig__cell.clean_up();
}
if (other_value.zero().is_bound()) {
  single_value->field_zero = other_value.zero();
} else {
  single_value->field_zero.clean_up();
}
if (other_value.num__meas().is_bound()) {
  single_value->field_num__meas = other_value.num__meas();
} else {
  single_value->field_num__meas.clean_up();
}
if (other_value.meas().is_bound()) {
  single_value->field_meas = other_value.meas();
} else {
  single_value->field_meas.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void CCNMeasReport_template::copy_template(const CCNMeasReport_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.rxlev__servig__cell().get_selection()) {
single_value->field_rxlev__servig__cell = other_value.rxlev__servig__cell();
} else {
single_value->field_rxlev__servig__cell.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.zero().get_selection()) {
single_value->field_zero = other_value.zero();
} else {
single_value->field_zero.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.num__meas().get_selection()) {
single_value->field_num__meas = other_value.num__meas();
} else {
single_value->field_num__meas.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.meas().get_selection()) {
single_value->field_meas = other_value.meas();
} else {
single_value->field_meas.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new CCNMeasReport_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new CCNMeasReport_template(*other_value.implication_.precondition);
implication_.implied_template = new CCNMeasReport_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.CCNMeasReport.");
break;
}
set_selection(other_value);
}

CCNMeasReport_template::CCNMeasReport_template()
{
}

CCNMeasReport_template::CCNMeasReport_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

CCNMeasReport_template::CCNMeasReport_template(const CCNMeasReport& other_value)
{
copy_value(other_value);
}

CCNMeasReport_template::CCNMeasReport_template(const OPTIONAL<CCNMeasReport>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CCNMeasReport&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.CCNMeasReport from an unbound optional field.");
}
}

CCNMeasReport_template::CCNMeasReport_template(CCNMeasReport_template* p_precondition, CCNMeasReport_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

CCNMeasReport_template::CCNMeasReport_template(Dynamic_Match_Interface<CCNMeasReport>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<CCNMeasReport>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

CCNMeasReport_template::CCNMeasReport_template(const CCNMeasReport_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

CCNMeasReport_template::~CCNMeasReport_template()
{
clean_up();
}

CCNMeasReport_template& CCNMeasReport_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

CCNMeasReport_template& CCNMeasReport_template::operator=(const CCNMeasReport& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

CCNMeasReport_template& CCNMeasReport_template::operator=(const OPTIONAL<CCNMeasReport>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CCNMeasReport&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.CCNMeasReport.");
}
return *this;
}

CCNMeasReport_template& CCNMeasReport_template::operator=(const CCNMeasReport_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean CCNMeasReport_template::match(const CCNMeasReport& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.rxlev__servig__cell().is_bound()) return FALSE;
if(!single_value->field_rxlev__servig__cell.match(other_value.rxlev__servig__cell(), legacy))return FALSE;
if(!other_value.zero().is_bound()) return FALSE;
if(!single_value->field_zero.match(other_value.zero(), legacy))return FALSE;
if(!other_value.num__meas().is_bound()) return FALSE;
if(!single_value->field_num__meas.match(other_value.num__meas(), legacy))return FALSE;
if(!other_value.meas().is_bound()) return FALSE;
if(!single_value->field_meas.match(other_value.meas(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.CCNMeasReport.");
}
return FALSE;
}

boolean CCNMeasReport_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_rxlev__servig__cell.is_bound()
 || single_value->field_zero.is_bound()
 || single_value->field_num__meas.is_bound()
 || single_value->field_meas.is_bound();
}

boolean CCNMeasReport_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_rxlev__servig__cell.is_value()
 && single_value->field_zero.is_value()
 && single_value->field_num__meas.is_value()
 && single_value->field_meas.is_value();
}

void CCNMeasReport_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

CCNMeasReport CCNMeasReport_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.CCNMeasReport.");
CCNMeasReport ret_val;
if (single_value->field_rxlev__servig__cell.is_bound()) {
ret_val.rxlev__servig__cell() = single_value->field_rxlev__servig__cell.valueof();
}
if (single_value->field_zero.is_bound()) {
ret_val.zero() = single_value->field_zero.valueof();
}
if (single_value->field_num__meas.is_bound()) {
ret_val.num__meas() = single_value->field_num__meas.valueof();
}
if (single_value->field_meas.is_bound()) {
ret_val.meas() = single_value->field_meas.valueof();
}
return ret_val;
}

void CCNMeasReport_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.CCNMeasReport.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new CCNMeasReport_template[list_length];
}

CCNMeasReport_template& CCNMeasReport_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.CCNMeasReport.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.CCNMeasReport.");
return value_list.list_value[list_index];
}

INTEGER_template& CCNMeasReport_template::rxlev__servig__cell()
{
set_specific();
return single_value->field_rxlev__servig__cell;
}

const INTEGER_template& CCNMeasReport_template::rxlev__servig__cell() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rxlev_servig_cell of a non-specific template of type @RLCMAC_CSN1_Types.CCNMeasReport.");
return single_value->field_rxlev__servig__cell;
}

BITSTRING_template& CCNMeasReport_template::zero()
{
set_specific();
return single_value->field_zero;
}

const BITSTRING_template& CCNMeasReport_template::zero() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field zero of a non-specific template of type @RLCMAC_CSN1_Types.CCNMeasReport.");
return single_value->field_zero;
}

INTEGER_template& CCNMeasReport_template::num__meas()
{
set_specific();
return single_value->field_num__meas;
}

const INTEGER_template& CCNMeasReport_template::num__meas() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field num_meas of a non-specific template of type @RLCMAC_CSN1_Types.CCNMeasReport.");
return single_value->field_num__meas;
}

NCMeasurements_template& CCNMeasReport_template::meas()
{
set_specific();
return single_value->field_meas;
}

const NCMeasurements_template& CCNMeasReport_template::meas() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field meas of a non-specific template of type @RLCMAC_CSN1_Types.CCNMeasReport.");
return single_value->field_meas;
}

int CCNMeasReport_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.CCNMeasReport which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.CCNMeasReport containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.CCNMeasReport containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.CCNMeasReport containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.CCNMeasReport containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.CCNMeasReport containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.CCNMeasReport containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.CCNMeasReport containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.CCNMeasReport containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.CCNMeasReport.");
  }
  return 0;
}

void CCNMeasReport_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ rxlev_servig_cell := ");
single_value->field_rxlev__servig__cell.log();
TTCN_Logger::log_event_str(", zero := ");
single_value->field_zero.log();
TTCN_Logger::log_event_str(", num_meas := ");
single_value->field_num__meas.log();
TTCN_Logger::log_event_str(", meas := ");
single_value->field_meas.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void CCNMeasReport_template::log_match(const CCNMeasReport& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_rxlev__servig__cell.match(match_value.rxlev__servig__cell(), legacy)){
TTCN_Logger::log_logmatch_info(".rxlev_servig_cell");
single_value->field_rxlev__servig__cell.log_match(match_value.rxlev__servig__cell(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_zero.match(match_value.zero(), legacy)){
TTCN_Logger::log_logmatch_info(".zero");
single_value->field_zero.log_match(match_value.zero(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_num__meas.match(match_value.num__meas(), legacy)){
TTCN_Logger::log_logmatch_info(".num_meas");
single_value->field_num__meas.log_match(match_value.num__meas(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_meas.match(match_value.meas(), legacy)){
TTCN_Logger::log_logmatch_info(".meas");
single_value->field_meas.log_match(match_value.meas(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ rxlev_servig_cell := ");
single_value->field_rxlev__servig__cell.log_match(match_value.rxlev__servig__cell(), legacy);
TTCN_Logger::log_event_str(", zero := ");
single_value->field_zero.log_match(match_value.zero(), legacy);
TTCN_Logger::log_event_str(", num_meas := ");
single_value->field_num__meas.log_match(match_value.num__meas(), legacy);
TTCN_Logger::log_event_str(", meas := ");
single_value->field_meas.log_match(match_value.meas(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void CCNMeasReport_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (rxlev__servig__cell().is_bound()) rxlev__servig__cell().set_implicit_omit();
if (zero().is_bound()) zero().set_implicit_omit();
if (num__meas().is_bound()) num__meas().set_implicit_omit();
if (meas().is_bound()) meas().set_implicit_omit();
}

void CCNMeasReport_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_rxlev__servig__cell.encode_text(text_buf);
single_value->field_zero.encode_text(text_buf);
single_value->field_num__meas.encode_text(text_buf);
single_value->field_meas.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.CCNMeasReport.");
}
}

void CCNMeasReport_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_rxlev__servig__cell.decode_text(text_buf);
single_value->field_zero.decode_text(text_buf);
single_value->field_num__meas.decode_text(text_buf);
single_value->field_meas.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new CCNMeasReport_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.CCNMeasReport.");
}
}

void CCNMeasReport_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    CCNMeasReport_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.CCNMeasReport has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) rxlev__servig__cell().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) zero().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) num__meas().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) meas().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rxlev_servig_cell")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rxlev__servig__cell().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "zero")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          zero().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "num_meas")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          num__meas().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "meas")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          meas().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.CCNMeasReport: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    CCNMeasReport_template* precondition = new CCNMeasReport_template;
    precondition->set_param(*param.get_elem(0));
    CCNMeasReport_template* implied_template = new CCNMeasReport_template;
    implied_template->set_param(*param.get_elem(1));
    *this = CCNMeasReport_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.CCNMeasReport");
  }
  is_ifpresent = param.get_ifpresent();
}

void CCNMeasReport_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_rxlev__servig__cell.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.CCNMeasReport");
single_value->field_zero.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.CCNMeasReport");
single_value->field_num__meas.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.CCNMeasReport");
single_value->field_meas.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.CCNMeasReport");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.CCNMeasReport");
}

boolean CCNMeasReport_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean CCNMeasReport_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PktCellChgNotifAdditions::PktCellChgNotifAdditions()
{
}

PktCellChgNotifAdditions::PktCellChgNotifAdditions(const BITSTRING& par_rel6__presence,
    const OPTIONAL< PktCellChgNotifR6Additions >& par_rel6)
  :   field_rel6__presence(par_rel6__presence),
  field_rel6(par_rel6)
{
}

PktCellChgNotifAdditions::PktCellChgNotifAdditions(const PktCellChgNotifAdditions& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions.");
if (other_value.rel6__presence().is_bound()) field_rel6__presence = other_value.rel6__presence();
else field_rel6__presence.clean_up();
if (other_value.rel6().is_bound()) field_rel6 = other_value.rel6();
else field_rel6.clean_up();
}

void PktCellChgNotifAdditions::clean_up()
{
field_rel6__presence.clean_up();
field_rel6.clean_up();
}

const TTCN_Typedescriptor_t* PktCellChgNotifAdditions::get_descriptor() const { return &PktCellChgNotifAdditions_descr_; }
PktCellChgNotifAdditions& PktCellChgNotifAdditions::operator=(const PktCellChgNotifAdditions& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions.");
  if (other_value.rel6__presence().is_bound()) field_rel6__presence = other_value.rel6__presence();
  else field_rel6__presence.clean_up();
  if (other_value.rel6().is_bound()) field_rel6 = other_value.rel6();
  else field_rel6.clean_up();
}
return *this;
}

boolean PktCellChgNotifAdditions::operator==(const PktCellChgNotifAdditions& other_value) const
{
return field_rel6__presence==other_value.field_rel6__presence
  && field_rel6==other_value.field_rel6;
}

boolean PktCellChgNotifAdditions::is_bound() const
{
return (field_rel6__presence.is_bound())
  || (OPTIONAL_OMIT == field_rel6.get_selection() || field_rel6.is_bound());
}
boolean PktCellChgNotifAdditions::is_value() const
{
return field_rel6__presence.is_value()
  && (OPTIONAL_OMIT == field_rel6.get_selection() || field_rel6.is_value());
}
int PktCellChgNotifAdditions::size_of() const
{
  int ret_val = 1;
  if (field_rel6.ispresent()) ret_val++;
  return ret_val;
}

void PktCellChgNotifAdditions::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ rel6_presence := ");
field_rel6__presence.log();
TTCN_Logger::log_event_str(", rel6 := ");
field_rel6.log();
TTCN_Logger::log_event_str(" }");
}

void PktCellChgNotifAdditions::set_implicit_omit()
{
if (rel6__presence().is_bound()) rel6__presence().set_implicit_omit();
if (!rel6().is_bound()) rel6() = OMIT_VALUE;
else rel6().set_implicit_omit();
}

void PktCellChgNotifAdditions::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) rel6__presence().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) rel6().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rel6_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rel6__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rel6")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rel6().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.PktCellChgNotifAdditions");
  }
}

void PktCellChgNotifAdditions::encode_text(Text_Buf& text_buf) const
{
field_rel6__presence.encode_text(text_buf);
field_rel6.encode_text(text_buf);
}

void PktCellChgNotifAdditions::decode_text(Text_Buf& text_buf)
{
field_rel6__presence.decode_text(text_buf);
field_rel6.decode_text(text_buf);
}

void PktCellChgNotifAdditions::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PktCellChgNotifAdditions::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PktCellChgNotifAdditions::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, PktCellChgNotifAdditions_rel6__presence_descr_.raw->forceomit);
  decoded_field_length = field_rel6__presence.RAW_decode(PktCellChgNotifAdditions_rel6__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_rel6__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_rel6 = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, PktCellChgNotifAdditions_rel6_descr_.raw->forceomit);
  decoded_field_length = field_rel6().RAW_decode(PktCellChgNotifAdditions_rel6_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_rel6 = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_rel6=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PktCellChgNotifAdditions::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, PktCellChgNotifAdditions_rel6__presence_descr_.raw);
  if (field_rel6.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, PktCellChgNotifAdditions_rel6_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  encoded_length += field_rel6__presence.RAW_encode(PktCellChgNotifAdditions_rel6__presence_descr_, *myleaf.body.node.nodes[0]);
  if (field_rel6.ispresent()) {
  encoded_length += field_rel6().RAW_encode(PktCellChgNotifAdditions_rel6_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_rel6.ispresent() && (field_rel6__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(PktCellChgNotifAdditions_rel6__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PktCellChgNotifAdditions_template::single_value_struct {
BITSTRING_template field_rel6__presence;
PktCellChgNotifR6Additions_template field_rel6;
};

void PktCellChgNotifAdditions_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_rel6__presence = ANY_VALUE;
single_value->field_rel6 = ANY_OR_OMIT;
}
}
}

void PktCellChgNotifAdditions_template::copy_value(const PktCellChgNotifAdditions& other_value)
{
single_value = new single_value_struct;
if (other_value.rel6__presence().is_bound()) {
  single_value->field_rel6__presence = other_value.rel6__presence();
} else {
  single_value->field_rel6__presence.clean_up();
}
if (other_value.rel6().is_bound()) {
  if (other_value.rel6().ispresent()) single_value->field_rel6 = other_value.rel6()();
  else single_value->field_rel6 = OMIT_VALUE;
} else {
  single_value->field_rel6.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PktCellChgNotifAdditions_template::copy_template(const PktCellChgNotifAdditions_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.rel6__presence().get_selection()) {
single_value->field_rel6__presence = other_value.rel6__presence();
} else {
single_value->field_rel6__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rel6().get_selection()) {
single_value->field_rel6 = other_value.rel6();
} else {
single_value->field_rel6.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PktCellChgNotifAdditions_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PktCellChgNotifAdditions_template(*other_value.implication_.precondition);
implication_.implied_template = new PktCellChgNotifAdditions_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions.");
break;
}
set_selection(other_value);
}

PktCellChgNotifAdditions_template::PktCellChgNotifAdditions_template()
{
}

PktCellChgNotifAdditions_template::PktCellChgNotifAdditions_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PktCellChgNotifAdditions_template::PktCellChgNotifAdditions_template(const PktCellChgNotifAdditions& other_value)
{
copy_value(other_value);
}

PktCellChgNotifAdditions_template::PktCellChgNotifAdditions_template(const OPTIONAL<PktCellChgNotifAdditions>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PktCellChgNotifAdditions&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions from an unbound optional field.");
}
}

PktCellChgNotifAdditions_template::PktCellChgNotifAdditions_template(PktCellChgNotifAdditions_template* p_precondition, PktCellChgNotifAdditions_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PktCellChgNotifAdditions_template::PktCellChgNotifAdditions_template(Dynamic_Match_Interface<PktCellChgNotifAdditions>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PktCellChgNotifAdditions>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PktCellChgNotifAdditions_template::PktCellChgNotifAdditions_template(const PktCellChgNotifAdditions_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PktCellChgNotifAdditions_template::~PktCellChgNotifAdditions_template()
{
clean_up();
}

PktCellChgNotifAdditions_template& PktCellChgNotifAdditions_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PktCellChgNotifAdditions_template& PktCellChgNotifAdditions_template::operator=(const PktCellChgNotifAdditions& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PktCellChgNotifAdditions_template& PktCellChgNotifAdditions_template::operator=(const OPTIONAL<PktCellChgNotifAdditions>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PktCellChgNotifAdditions&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions.");
}
return *this;
}

PktCellChgNotifAdditions_template& PktCellChgNotifAdditions_template::operator=(const PktCellChgNotifAdditions_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PktCellChgNotifAdditions_template::match(const PktCellChgNotifAdditions& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.rel6__presence().is_bound()) return FALSE;
if(!single_value->field_rel6__presence.match(other_value.rel6__presence(), legacy))return FALSE;
if(!other_value.rel6().is_bound()) return FALSE;
if((other_value.rel6().ispresent() ? !single_value->field_rel6.match((const PktCellChgNotifR6Additions&)other_value.rel6(), legacy) : !single_value->field_rel6.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions.");
}
return FALSE;
}

boolean PktCellChgNotifAdditions_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_rel6__presence.is_bound()
 || (single_value->field_rel6.is_omit() || single_value->field_rel6.is_bound());
}

boolean PktCellChgNotifAdditions_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_rel6__presence.is_value()
 && (single_value->field_rel6.is_omit() || single_value->field_rel6.is_value());
}

void PktCellChgNotifAdditions_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PktCellChgNotifAdditions PktCellChgNotifAdditions_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions.");
PktCellChgNotifAdditions ret_val;
if (single_value->field_rel6__presence.is_bound()) {
ret_val.rel6__presence() = single_value->field_rel6__presence.valueof();
}
if (single_value->field_rel6.is_omit()) ret_val.rel6() = OMIT_VALUE;
else if (single_value->field_rel6.is_bound()) {
ret_val.rel6() = single_value->field_rel6.valueof();
}
return ret_val;
}

void PktCellChgNotifAdditions_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PktCellChgNotifAdditions_template[list_length];
}

PktCellChgNotifAdditions_template& PktCellChgNotifAdditions_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions.");
return value_list.list_value[list_index];
}

BITSTRING_template& PktCellChgNotifAdditions_template::rel6__presence()
{
set_specific();
return single_value->field_rel6__presence;
}

const BITSTRING_template& PktCellChgNotifAdditions_template::rel6__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rel6_presence of a non-specific template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions.");
return single_value->field_rel6__presence;
}

PktCellChgNotifR6Additions_template& PktCellChgNotifAdditions_template::rel6()
{
set_specific();
return single_value->field_rel6;
}

const PktCellChgNotifR6Additions_template& PktCellChgNotifAdditions_template::rel6() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rel6 of a non-specific template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions.");
return single_value->field_rel6;
}

int PktCellChgNotifAdditions_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_rel6.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions.");
  }
  return 0;
}

void PktCellChgNotifAdditions_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ rel6_presence := ");
single_value->field_rel6__presence.log();
TTCN_Logger::log_event_str(", rel6 := ");
single_value->field_rel6.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PktCellChgNotifAdditions_template::log_match(const PktCellChgNotifAdditions& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_rel6__presence.match(match_value.rel6__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".rel6_presence");
single_value->field_rel6__presence.log_match(match_value.rel6__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.rel6().ispresent()){
if(!single_value->field_rel6.match(match_value.rel6(), legacy)){
TTCN_Logger::log_logmatch_info(".rel6");
single_value->field_rel6.log_match(match_value.rel6(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_rel6.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".rel6 := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_rel6.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ rel6_presence := ");
single_value->field_rel6__presence.log_match(match_value.rel6__presence(), legacy);
TTCN_Logger::log_event_str(", rel6 := ");
if (match_value.rel6().ispresent()) {
single_value->field_rel6.log_match(match_value.rel6(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_rel6.log();
if (single_value->field_rel6.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PktCellChgNotifAdditions_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (rel6__presence().is_bound()) rel6__presence().set_implicit_omit();
if (!rel6().is_bound()) rel6() = OMIT_VALUE;
else rel6().set_implicit_omit();
}

void PktCellChgNotifAdditions_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_rel6__presence.encode_text(text_buf);
single_value->field_rel6.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions.");
}
}

void PktCellChgNotifAdditions_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_rel6__presence.decode_text(text_buf);
single_value->field_rel6.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PktCellChgNotifAdditions_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions.");
}
}

void PktCellChgNotifAdditions_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PktCellChgNotifAdditions_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) rel6__presence().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) rel6().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rel6_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rel6__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rel6")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rel6().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.PktCellChgNotifAdditions: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PktCellChgNotifAdditions_template* precondition = new PktCellChgNotifAdditions_template;
    precondition->set_param(*param.get_elem(0));
    PktCellChgNotifAdditions_template* implied_template = new PktCellChgNotifAdditions_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PktCellChgNotifAdditions_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.PktCellChgNotifAdditions");
  }
  is_ifpresent = param.get_ifpresent();
}

void PktCellChgNotifAdditions_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_rel6__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PktCellChgNotifAdditions");
single_value->field_rel6.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PktCellChgNotifAdditions");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.PktCellChgNotifAdditions");
}

boolean PktCellChgNotifAdditions_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PktCellChgNotifAdditions_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PktCellChgNotifR6Additions::PktCellChgNotifR6Additions()
{
}

PktCellChgNotifR6Additions::PktCellChgNotifR6Additions(const BITSTRING& par_utran__ba__used__presence,
    const OPTIONAL< INTEGER >& par_utran__ba__used,
    const UtranCCNMeasReport& par_utran__ccn__meas__rep)
  :   field_utran__ba__used__presence(par_utran__ba__used__presence),
  field_utran__ba__used(par_utran__ba__used),
  field_utran__ccn__meas__rep(par_utran__ccn__meas__rep)
{
}

PktCellChgNotifR6Additions::PktCellChgNotifR6Additions(const PktCellChgNotifR6Additions& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions.");
if (other_value.utran__ba__used__presence().is_bound()) field_utran__ba__used__presence = other_value.utran__ba__used__presence();
else field_utran__ba__used__presence.clean_up();
if (other_value.utran__ba__used().is_bound()) field_utran__ba__used = other_value.utran__ba__used();
else field_utran__ba__used.clean_up();
if (other_value.utran__ccn__meas__rep().is_bound()) field_utran__ccn__meas__rep = other_value.utran__ccn__meas__rep();
else field_utran__ccn__meas__rep.clean_up();
}

void PktCellChgNotifR6Additions::clean_up()
{
field_utran__ba__used__presence.clean_up();
field_utran__ba__used.clean_up();
field_utran__ccn__meas__rep.clean_up();
}

const TTCN_Typedescriptor_t* PktCellChgNotifR6Additions::get_descriptor() const { return &PktCellChgNotifR6Additions_descr_; }
PktCellChgNotifR6Additions& PktCellChgNotifR6Additions::operator=(const PktCellChgNotifR6Additions& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions.");
  if (other_value.utran__ba__used__presence().is_bound()) field_utran__ba__used__presence = other_value.utran__ba__used__presence();
  else field_utran__ba__used__presence.clean_up();
  if (other_value.utran__ba__used().is_bound()) field_utran__ba__used = other_value.utran__ba__used();
  else field_utran__ba__used.clean_up();
  if (other_value.utran__ccn__meas__rep().is_bound()) field_utran__ccn__meas__rep = other_value.utran__ccn__meas__rep();
  else field_utran__ccn__meas__rep.clean_up();
}
return *this;
}

boolean PktCellChgNotifR6Additions::operator==(const PktCellChgNotifR6Additions& other_value) const
{
return field_utran__ba__used__presence==other_value.field_utran__ba__used__presence
  && field_utran__ba__used==other_value.field_utran__ba__used
  && field_utran__ccn__meas__rep==other_value.field_utran__ccn__meas__rep;
}

boolean PktCellChgNotifR6Additions::is_bound() const
{
return (field_utran__ba__used__presence.is_bound())
  || (OPTIONAL_OMIT == field_utran__ba__used.get_selection() || field_utran__ba__used.is_bound())
  || (field_utran__ccn__meas__rep.is_bound());
}
boolean PktCellChgNotifR6Additions::is_value() const
{
return field_utran__ba__used__presence.is_value()
  && (OPTIONAL_OMIT == field_utran__ba__used.get_selection() || field_utran__ba__used.is_value())
  && field_utran__ccn__meas__rep.is_value();
}
int PktCellChgNotifR6Additions::size_of() const
{
  int ret_val = 2;
  if (field_utran__ba__used.ispresent()) ret_val++;
  return ret_val;
}

void PktCellChgNotifR6Additions::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ utran_ba_used_presence := ");
field_utran__ba__used__presence.log();
TTCN_Logger::log_event_str(", utran_ba_used := ");
field_utran__ba__used.log();
TTCN_Logger::log_event_str(", utran_ccn_meas_rep := ");
field_utran__ccn__meas__rep.log();
TTCN_Logger::log_event_str(" }");
}

void PktCellChgNotifR6Additions::set_implicit_omit()
{
if (utran__ba__used__presence().is_bound()) utran__ba__used__presence().set_implicit_omit();
if (!utran__ba__used().is_bound()) utran__ba__used() = OMIT_VALUE;
else utran__ba__used().set_implicit_omit();
if (utran__ccn__meas__rep().is_bound()) utran__ccn__meas__rep().set_implicit_omit();
}

void PktCellChgNotifR6Additions::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) utran__ba__used__presence().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) utran__ba__used().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) utran__ccn__meas__rep().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "utran_ba_used_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          utran__ba__used__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "utran_ba_used")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          utran__ba__used().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "utran_ccn_meas_rep")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          utran__ccn__meas__rep().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.PktCellChgNotifR6Additions");
  }
}

void PktCellChgNotifR6Additions::encode_text(Text_Buf& text_buf) const
{
field_utran__ba__used__presence.encode_text(text_buf);
field_utran__ba__used.encode_text(text_buf);
field_utran__ccn__meas__rep.encode_text(text_buf);
}

void PktCellChgNotifR6Additions::decode_text(Text_Buf& text_buf)
{
field_utran__ba__used__presence.decode_text(text_buf);
field_utran__ba__used.decode_text(text_buf);
field_utran__ccn__meas__rep.decode_text(text_buf);
}

void PktCellChgNotifR6Additions::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PktCellChgNotifR6Additions::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PktCellChgNotifR6Additions::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, PktCellChgNotifR6Additions_utran__ba__used__presence_descr_.raw->forceomit);
  decoded_field_length = field_utran__ba__used__presence.RAW_decode(PktCellChgNotifR6Additions_utran__ba__used__presence_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_utran__ba__used__presence ==  bs_0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_utran__ba__used = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, PktCellChgNotifR6Additions_utran__ba__used_descr_.raw->forceomit);
  decoded_field_length = field_utran__ba__used().RAW_decode(PktCellChgNotifR6Additions_utran__ba__used_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_utran__ba__used = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_utran__ba__used=OMIT_VALUE;
  RAW_Force_Omit field_2_force_omit(2, force_omit, PktCellChgNotifR6Additions_utran__ccn__meas__rep_descr_.raw->forceomit);
  decoded_field_length = field_utran__ccn__meas__rep.RAW_decode(PktCellChgNotifR6Additions_utran__ccn__meas__rep_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PktCellChgNotifR6Additions::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, PktCellChgNotifR6Additions_utran__ba__used__presence_descr_.raw);
  if (field_utran__ba__used.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, PktCellChgNotifR6Additions_utran__ba__used_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, PktCellChgNotifR6Additions_utran__ccn__meas__rep_descr_.raw);
  encoded_length += field_utran__ba__used__presence.RAW_encode(PktCellChgNotifR6Additions_utran__ba__used__presence_descr_, *myleaf.body.node.nodes[0]);
  if (field_utran__ba__used.ispresent()) {
  encoded_length += field_utran__ba__used().RAW_encode(PktCellChgNotifR6Additions_utran__ba__used_descr_, *myleaf.body.node.nodes[1]);
  }
  encoded_length += field_utran__ccn__meas__rep.RAW_encode(PktCellChgNotifR6Additions_utran__ccn__meas__rep_descr_, *myleaf.body.node.nodes[2]);
  if (field_utran__ba__used.ispresent() && (field_utran__ba__used__presence !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(PktCellChgNotifR6Additions_utran__ba__used__presence_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PktCellChgNotifR6Additions_template::single_value_struct {
BITSTRING_template field_utran__ba__used__presence;
INTEGER_template field_utran__ba__used;
UtranCCNMeasReport_template field_utran__ccn__meas__rep;
};

void PktCellChgNotifR6Additions_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_utran__ba__used__presence = ANY_VALUE;
single_value->field_utran__ba__used = ANY_OR_OMIT;
single_value->field_utran__ccn__meas__rep = ANY_VALUE;
}
}
}

void PktCellChgNotifR6Additions_template::copy_value(const PktCellChgNotifR6Additions& other_value)
{
single_value = new single_value_struct;
if (other_value.utran__ba__used__presence().is_bound()) {
  single_value->field_utran__ba__used__presence = other_value.utran__ba__used__presence();
} else {
  single_value->field_utran__ba__used__presence.clean_up();
}
if (other_value.utran__ba__used().is_bound()) {
  if (other_value.utran__ba__used().ispresent()) single_value->field_utran__ba__used = other_value.utran__ba__used()();
  else single_value->field_utran__ba__used = OMIT_VALUE;
} else {
  single_value->field_utran__ba__used.clean_up();
}
if (other_value.utran__ccn__meas__rep().is_bound()) {
  single_value->field_utran__ccn__meas__rep = other_value.utran__ccn__meas__rep();
} else {
  single_value->field_utran__ccn__meas__rep.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PktCellChgNotifR6Additions_template::copy_template(const PktCellChgNotifR6Additions_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.utran__ba__used__presence().get_selection()) {
single_value->field_utran__ba__used__presence = other_value.utran__ba__used__presence();
} else {
single_value->field_utran__ba__used__presence.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.utran__ba__used().get_selection()) {
single_value->field_utran__ba__used = other_value.utran__ba__used();
} else {
single_value->field_utran__ba__used.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.utran__ccn__meas__rep().get_selection()) {
single_value->field_utran__ccn__meas__rep = other_value.utran__ccn__meas__rep();
} else {
single_value->field_utran__ccn__meas__rep.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PktCellChgNotifR6Additions_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PktCellChgNotifR6Additions_template(*other_value.implication_.precondition);
implication_.implied_template = new PktCellChgNotifR6Additions_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions.");
break;
}
set_selection(other_value);
}

PktCellChgNotifR6Additions_template::PktCellChgNotifR6Additions_template()
{
}

PktCellChgNotifR6Additions_template::PktCellChgNotifR6Additions_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PktCellChgNotifR6Additions_template::PktCellChgNotifR6Additions_template(const PktCellChgNotifR6Additions& other_value)
{
copy_value(other_value);
}

PktCellChgNotifR6Additions_template::PktCellChgNotifR6Additions_template(const OPTIONAL<PktCellChgNotifR6Additions>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PktCellChgNotifR6Additions&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions from an unbound optional field.");
}
}

PktCellChgNotifR6Additions_template::PktCellChgNotifR6Additions_template(PktCellChgNotifR6Additions_template* p_precondition, PktCellChgNotifR6Additions_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PktCellChgNotifR6Additions_template::PktCellChgNotifR6Additions_template(Dynamic_Match_Interface<PktCellChgNotifR6Additions>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PktCellChgNotifR6Additions>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PktCellChgNotifR6Additions_template::PktCellChgNotifR6Additions_template(const PktCellChgNotifR6Additions_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PktCellChgNotifR6Additions_template::~PktCellChgNotifR6Additions_template()
{
clean_up();
}

PktCellChgNotifR6Additions_template& PktCellChgNotifR6Additions_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PktCellChgNotifR6Additions_template& PktCellChgNotifR6Additions_template::operator=(const PktCellChgNotifR6Additions& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PktCellChgNotifR6Additions_template& PktCellChgNotifR6Additions_template::operator=(const OPTIONAL<PktCellChgNotifR6Additions>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PktCellChgNotifR6Additions&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions.");
}
return *this;
}

PktCellChgNotifR6Additions_template& PktCellChgNotifR6Additions_template::operator=(const PktCellChgNotifR6Additions_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PktCellChgNotifR6Additions_template::match(const PktCellChgNotifR6Additions& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.utran__ba__used__presence().is_bound()) return FALSE;
if(!single_value->field_utran__ba__used__presence.match(other_value.utran__ba__used__presence(), legacy))return FALSE;
if(!other_value.utran__ba__used().is_bound()) return FALSE;
if((other_value.utran__ba__used().ispresent() ? !single_value->field_utran__ba__used.match((const INTEGER&)other_value.utran__ba__used(), legacy) : !single_value->field_utran__ba__used.match_omit(legacy)))return FALSE;
if(!other_value.utran__ccn__meas__rep().is_bound()) return FALSE;
if(!single_value->field_utran__ccn__meas__rep.match(other_value.utran__ccn__meas__rep(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions.");
}
return FALSE;
}

boolean PktCellChgNotifR6Additions_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_utran__ba__used__presence.is_bound()
 || (single_value->field_utran__ba__used.is_omit() || single_value->field_utran__ba__used.is_bound())
 || single_value->field_utran__ccn__meas__rep.is_bound();
}

boolean PktCellChgNotifR6Additions_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_utran__ba__used__presence.is_value()
 && (single_value->field_utran__ba__used.is_omit() || single_value->field_utran__ba__used.is_value())
 && single_value->field_utran__ccn__meas__rep.is_value();
}

void PktCellChgNotifR6Additions_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PktCellChgNotifR6Additions PktCellChgNotifR6Additions_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions.");
PktCellChgNotifR6Additions ret_val;
if (single_value->field_utran__ba__used__presence.is_bound()) {
ret_val.utran__ba__used__presence() = single_value->field_utran__ba__used__presence.valueof();
}
if (single_value->field_utran__ba__used.is_omit()) ret_val.utran__ba__used() = OMIT_VALUE;
else if (single_value->field_utran__ba__used.is_bound()) {
ret_val.utran__ba__used() = single_value->field_utran__ba__used.valueof();
}
if (single_value->field_utran__ccn__meas__rep.is_bound()) {
ret_val.utran__ccn__meas__rep() = single_value->field_utran__ccn__meas__rep.valueof();
}
return ret_val;
}

void PktCellChgNotifR6Additions_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PktCellChgNotifR6Additions_template[list_length];
}

PktCellChgNotifR6Additions_template& PktCellChgNotifR6Additions_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions.");
return value_list.list_value[list_index];
}

BITSTRING_template& PktCellChgNotifR6Additions_template::utran__ba__used__presence()
{
set_specific();
return single_value->field_utran__ba__used__presence;
}

const BITSTRING_template& PktCellChgNotifR6Additions_template::utran__ba__used__presence() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field utran_ba_used_presence of a non-specific template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions.");
return single_value->field_utran__ba__used__presence;
}

INTEGER_template& PktCellChgNotifR6Additions_template::utran__ba__used()
{
set_specific();
return single_value->field_utran__ba__used;
}

const INTEGER_template& PktCellChgNotifR6Additions_template::utran__ba__used() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field utran_ba_used of a non-specific template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions.");
return single_value->field_utran__ba__used;
}

UtranCCNMeasReport_template& PktCellChgNotifR6Additions_template::utran__ccn__meas__rep()
{
set_specific();
return single_value->field_utran__ccn__meas__rep;
}

const UtranCCNMeasReport_template& PktCellChgNotifR6Additions_template::utran__ccn__meas__rep() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field utran_ccn_meas_rep of a non-specific template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions.");
return single_value->field_utran__ccn__meas__rep;
}

int PktCellChgNotifR6Additions_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_utran__ba__used.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions.");
  }
  return 0;
}

void PktCellChgNotifR6Additions_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ utran_ba_used_presence := ");
single_value->field_utran__ba__used__presence.log();
TTCN_Logger::log_event_str(", utran_ba_used := ");
single_value->field_utran__ba__used.log();
TTCN_Logger::log_event_str(", utran_ccn_meas_rep := ");
single_value->field_utran__ccn__meas__rep.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PktCellChgNotifR6Additions_template::log_match(const PktCellChgNotifR6Additions& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_utran__ba__used__presence.match(match_value.utran__ba__used__presence(), legacy)){
TTCN_Logger::log_logmatch_info(".utran_ba_used_presence");
single_value->field_utran__ba__used__presence.log_match(match_value.utran__ba__used__presence(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.utran__ba__used().ispresent()){
if(!single_value->field_utran__ba__used.match(match_value.utran__ba__used(), legacy)){
TTCN_Logger::log_logmatch_info(".utran_ba_used");
single_value->field_utran__ba__used.log_match(match_value.utran__ba__used(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_utran__ba__used.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".utran_ba_used := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_utran__ba__used.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_utran__ccn__meas__rep.match(match_value.utran__ccn__meas__rep(), legacy)){
TTCN_Logger::log_logmatch_info(".utran_ccn_meas_rep");
single_value->field_utran__ccn__meas__rep.log_match(match_value.utran__ccn__meas__rep(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ utran_ba_used_presence := ");
single_value->field_utran__ba__used__presence.log_match(match_value.utran__ba__used__presence(), legacy);
TTCN_Logger::log_event_str(", utran_ba_used := ");
if (match_value.utran__ba__used().ispresent()) {
single_value->field_utran__ba__used.log_match(match_value.utran__ba__used(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_utran__ba__used.log();
if (single_value->field_utran__ba__used.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", utran_ccn_meas_rep := ");
single_value->field_utran__ccn__meas__rep.log_match(match_value.utran__ccn__meas__rep(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PktCellChgNotifR6Additions_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (utran__ba__used__presence().is_bound()) utran__ba__used__presence().set_implicit_omit();
if (!utran__ba__used().is_bound()) utran__ba__used() = OMIT_VALUE;
else utran__ba__used().set_implicit_omit();
if (utran__ccn__meas__rep().is_bound()) utran__ccn__meas__rep().set_implicit_omit();
}

void PktCellChgNotifR6Additions_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_utran__ba__used__presence.encode_text(text_buf);
single_value->field_utran__ba__used.encode_text(text_buf);
single_value->field_utran__ccn__meas__rep.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions.");
}
}

void PktCellChgNotifR6Additions_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_utran__ba__used__presence.decode_text(text_buf);
single_value->field_utran__ba__used.decode_text(text_buf);
single_value->field_utran__ccn__meas__rep.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PktCellChgNotifR6Additions_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions.");
}
}

void PktCellChgNotifR6Additions_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PktCellChgNotifR6Additions_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) utran__ba__used__presence().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) utran__ba__used().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) utran__ccn__meas__rep().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "utran_ba_used_presence")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          utran__ba__used__presence().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "utran_ba_used")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          utran__ba__used().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "utran_ccn_meas_rep")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          utran__ccn__meas__rep().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.PktCellChgNotifR6Additions: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PktCellChgNotifR6Additions_template* precondition = new PktCellChgNotifR6Additions_template;
    precondition->set_param(*param.get_elem(0));
    PktCellChgNotifR6Additions_template* implied_template = new PktCellChgNotifR6Additions_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PktCellChgNotifR6Additions_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RLCMAC_CSN1_Types.PktCellChgNotifR6Additions");
  }
  is_ifpresent = param.get_ifpresent();
}

void PktCellChgNotifR6Additions_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_utran__ba__used__presence.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PktCellChgNotifR6Additions");
single_value->field_utran__ba__used.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PktCellChgNotifR6Additions");
single_value->field_utran__ccn__meas__rep.check_restriction(t_res, t_name ? t_name : "@RLCMAC_CSN1_Types.PktCellChgNotifR6Additions");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RLCMAC_CSN1_Types.PktCellChgNotifR6Additions");
}

boolean PktCellChgNotifR6Additions_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PktCellChgNotifR6Additions_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PktCellChgNotifyU0::PktCellChgNotifyU0()
{
}

PktCellChgNotifyU0::PktCellChgNotifyU0(const BITSTRING& par_tag,
    const INTEGER& par_arfcn,
    const INTEGER& par_bsic)
  :   field_tag(par_tag),
  field_arfcn(par_arfcn),
  field_bsic(par_bsic)
{
}

PktCellChgNotifyU0::PktCellChgNotifyU0(const PktCellChgNotifyU0& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RLCMAC_CSN1_Types.PktCellChgNotifyU0.");
if (other_value.tag().is_bound()) field_tag = other_value.tag();
else field_tag.clean_up();
if (other_value.arfcn().is_bound()) field_arfcn = other_value.arfcn();
else field_arfcn.clean_up();
if (other_value.bsic().is_bound()) field_bsic = other_value.bsic();
else field_bsic.clean_up();
}

void PktCellChgNotifyU0::clean_up()
{
field_tag.clean_up();
field_arfcn.clean_up();
field_bsic.clean_up();
}

const TTCN_Typedescriptor_t* PktCellChgNotifyU0::get_descriptor() const { return &PktCellChgNotifyU0_descr_; }
PktCellChgNotifyU0& PktCellChgNotifyU0::operator=(const PktCellChgNotifyU0& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RLCMAC_CSN1_Types.PktCellChgNotifyU0.");
  if (other_value.tag().is_bound()) field_tag = other_value.tag();
  else field_tag.clean_up();
  if (other_value.arfcn().is_bound()) field_arfcn = other_value.arfcn();
  else field_arfcn.clean_up();
  if (other_value.bsic().is_bound()) field_bsic = other_value.bsic();
  else field_bsic.clean_up();
}
return *this;
}

boolean PktCellChgNotifyU0::operator==(const PktCellChgNotifyU0& other_value) const
{
return field_tag==other_value.field_tag
  && field_arfcn==other_value.field_arfcn
  && field_bsic==other_value.field_bsic;
}

boolean PktCellChgNotifyU0::is_bound() const
{
return (field_tag.is_bound())
  || (field_arfcn.is_bound())
  || (field_bsic.is_bound());
}
boolean PktCellChgNotifyU0::is_value() const
{
return field_tag.is_value()
  && field_arfcn.is_value()
  && field_bsic.is_value();
}
void PktCellChgNotifyU0::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tag := ");
field_tag.log();
TTCN_Logger::log_event_str(", arfcn := ");
field_arfcn.log();
TTCN_Logger::log_event_str(", bsic := ");
field_bsic.log();
TTCN_Logger::log_event_str(" }");
}

void PktCellChgNotifyU0::set_implicit_omit()
{
if (tag().is_bound()) tag().set_implicit_omit();
if (arfcn().is_bound()) arfcn().set_implicit_omit();
if (bsic().is_bound()) bsic().set_implicit_omit();
}

void PktCellChgNotifyU0::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RLCMAC_CSN1_Types.PktCellChgNotifyU0 has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tag().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) arfcn().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) bsic().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "arfcn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          arfcn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bsic")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bsic().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RLCMAC_CSN1_Types.PktCellChgNotifyU0: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RLCMAC_CSN1_Types.PktCellChgNotifyU0");
  }
}

void PktCellChgNotifyU0::encode_text(Text_Buf& text_buf) const
{
field_tag.encode_text(text_buf);
field_arfcn.encode_text(text_buf);
field_bsic.encode_text(text_buf);
}

void PktCellChgNotifyU0::decode_text(Text_Buf& text_buf)
{
field_tag.decode_text(text_buf);
field_arfcn.decode_text(text_buf);
field_bsic.decode_text(text_buf);
}

void PktCellChgNotifyU0::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PktCellChgNotifyU0::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PktCellChgNotifyU0::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, PktCellChgNotifyU0_tag_descr_.raw->forceomit);
  decoded_field_length = field_tag.RAW_decode(PktCellChgNotifyU0_tag_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, PktCellChgNotifyU0_arfcn_descr_.raw->forceomit);
  decoded_field_length = field_arfcn.RAW_decode(PktCellChgNotifyU0_arfcn_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, PktCellChgNotifyU0_bsic_descr_.raw->forceomit);
  decoded_field_length = field_bsic.RAW_decode(PktCellChgNotifyU0_bsic_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PktCellChgNotifyU0::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of