// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 9.0.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2023 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "BSSGP_Types.hh"

namespace BSSGP__Types {

/* Member functions of C++ classes */

VelocityData::VelocityData()
{
}

VelocityData::VelocityData(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a& par_lengthIndicator,
    const OCTETSTRING& par_velocityDataValue)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_velocityDataValue(par_velocityDataValue)
{
}

VelocityData::VelocityData(const VelocityData& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSGP_Types.VelocityData.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.velocityDataValue().is_bound()) field_velocityDataValue = other_value.velocityDataValue();
else field_velocityDataValue.clean_up();
}

void VelocityData::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_velocityDataValue.clean_up();
}

const TTCN_Typedescriptor_t* VelocityData::get_descriptor() const { return &VelocityData_descr_; }
VelocityData& VelocityData::operator=(const VelocityData& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSGP_Types.VelocityData.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.velocityDataValue().is_bound()) field_velocityDataValue = other_value.velocityDataValue();
  else field_velocityDataValue.clean_up();
}
return *this;
}

boolean VelocityData::operator==(const VelocityData& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_velocityDataValue==other_value.field_velocityDataValue;
}

boolean VelocityData::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_velocityDataValue.is_bound());
}
boolean VelocityData::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_velocityDataValue.is_value();
}
void VelocityData::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", velocityDataValue := ");
field_velocityDataValue.log();
TTCN_Logger::log_event_str(" }");
}

void VelocityData::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (velocityDataValue().is_bound()) velocityDataValue().set_implicit_omit();
}

void VelocityData::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @BSSGP_Types.VelocityData has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) velocityDataValue().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "velocityDataValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          velocityDataValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.VelocityData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSGP_Types.VelocityData");
  }
}

void VelocityData::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_velocityDataValue.encode_text(text_buf);
}

void VelocityData::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_velocityDataValue.decode_text(text_buf);
}

void VelocityData::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void VelocityData::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int VelocityData::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, VelocityData_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(VelocityData_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_0) selected_field = 0;
  else if (field_ext ==  bs_1) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, VelocityData_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(VelocityData_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_velocityDataValue.RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  if (field_iEI !=  os_126) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int VelocityData::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, VelocityData_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, VelocityData_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, OCTETSTRING_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(VelocityData_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(VelocityData_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_velocityDataValue.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[3]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1:
  if (field_ext !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(VelocityData_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a::ALT_length2:
  if (field_ext !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(VelocityData_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_iEI !=  os_126) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_126.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct VelocityData_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a_template field_lengthIndicator;
OCTETSTRING_template field_velocityDataValue;
};

void VelocityData_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_velocityDataValue = ANY_VALUE;
}
}
}

void VelocityData_template::copy_value(const VelocityData& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.velocityDataValue().is_bound()) {
  single_value->field_velocityDataValue = other_value.velocityDataValue();
} else {
  single_value->field_velocityDataValue.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void VelocityData_template::copy_template(const VelocityData_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.velocityDataValue().get_selection()) {
single_value->field_velocityDataValue = other_value.velocityDataValue();
} else {
single_value->field_velocityDataValue.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new VelocityData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new VelocityData_template(*other_value.implication_.precondition);
implication_.implied_template = new VelocityData_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSGP_Types.VelocityData.");
break;
}
set_selection(other_value);
}

VelocityData_template::VelocityData_template()
{
}

VelocityData_template::VelocityData_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

VelocityData_template::VelocityData_template(const VelocityData& other_value)
{
copy_value(other_value);
}

VelocityData_template::VelocityData_template(const OPTIONAL<VelocityData>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const VelocityData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSGP_Types.VelocityData from an unbound optional field.");
}
}

VelocityData_template::VelocityData_template(VelocityData_template* p_precondition, VelocityData_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

VelocityData_template::VelocityData_template(Dynamic_Match_Interface<VelocityData>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<VelocityData>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

VelocityData_template::VelocityData_template(const VelocityData_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

VelocityData_template::~VelocityData_template()
{
clean_up();
}

VelocityData_template& VelocityData_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

VelocityData_template& VelocityData_template::operator=(const VelocityData& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

VelocityData_template& VelocityData_template::operator=(const OPTIONAL<VelocityData>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const VelocityData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSGP_Types.VelocityData.");
}
return *this;
}

VelocityData_template& VelocityData_template::operator=(const VelocityData_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean VelocityData_template::match(const VelocityData& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.velocityDataValue().is_bound()) return FALSE;
if(!single_value->field_velocityDataValue.match(other_value.velocityDataValue(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSGP_Types.VelocityData.");
}
return FALSE;
}

boolean VelocityData_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_velocityDataValue.is_bound();
}

boolean VelocityData_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_velocityDataValue.is_value();
}

void VelocityData_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

VelocityData VelocityData_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSGP_Types.VelocityData.");
VelocityData ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_velocityDataValue.is_bound()) {
ret_val.velocityDataValue() = single_value->field_velocityDataValue.valueof();
}
return ret_val;
}

void VelocityData_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSGP_Types.VelocityData.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new VelocityData_template[list_length];
}

VelocityData_template& VelocityData_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSGP_Types.VelocityData.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSGP_Types.VelocityData.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& VelocityData_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& VelocityData_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @BSSGP_Types.VelocityData.");
return single_value->field_iEI;
}

BITSTRING_template& VelocityData_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& VelocityData_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @BSSGP_Types.VelocityData.");
return single_value->field_ext;
}

LIN2__2a_template& VelocityData_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a_template& VelocityData_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSGP_Types.VelocityData.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& VelocityData_template::velocityDataValue()
{
set_specific();
return single_value->field_velocityDataValue;
}

const OCTETSTRING_template& VelocityData_template::velocityDataValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field velocityDataValue of a non-specific template of type @BSSGP_Types.VelocityData.");
return single_value->field_velocityDataValue;
}

int VelocityData_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.VelocityData which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSGP_Types.VelocityData containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.VelocityData containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.VelocityData containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.VelocityData containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.VelocityData containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.VelocityData containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.VelocityData containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.VelocityData containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSGP_Types.VelocityData.");
  }
  return 0;
}

void VelocityData_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", velocityDataValue := ");
single_value->field_velocityDataValue.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void VelocityData_template::log_match(const VelocityData& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_velocityDataValue.match(match_value.velocityDataValue(), legacy)){
TTCN_Logger::log_logmatch_info(".velocityDataValue");
single_value->field_velocityDataValue.log_match(match_value.velocityDataValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", velocityDataValue := ");
single_value->field_velocityDataValue.log_match(match_value.velocityDataValue(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void VelocityData_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_velocityDataValue.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSGP_Types.VelocityData.");
}
}

void VelocityData_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_velocityDataValue.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new VelocityData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSGP_Types.VelocityData.");
}
}

void VelocityData_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    VelocityData_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @BSSGP_Types.VelocityData has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) velocityDataValue().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "velocityDataValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          velocityDataValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.VelocityData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    VelocityData_template* precondition = new VelocityData_template;
    precondition->set_param(*param.get_elem(0));
    VelocityData_template* implied_template = new VelocityData_template;
    implied_template->set_param(*param.get_elem(1));
    *this = VelocityData_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSGP_Types.VelocityData");
  }
  is_ifpresent = param.get_ifpresent();
}

void VelocityData_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.VelocityData");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.VelocityData");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.VelocityData");
single_value->field_velocityDataValue.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.VelocityData");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSGP_Types.VelocityData");
}

boolean VelocityData_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean VelocityData_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Requested__GANSS__Assistance__Data::Requested__GANSS__Assistance__Data()
{
}

Requested__GANSS__Assistance__Data::Requested__GANSS__Assistance__Data(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a& par_lengthIndicator,
    const OCTETSTRING& par_requested__GANSS__Assistance__Data__Value)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_requested__GANSS__Assistance__Data__Value(par_requested__GANSS__Assistance__Data__Value)
{
}

Requested__GANSS__Assistance__Data::Requested__GANSS__Assistance__Data(const Requested__GANSS__Assistance__Data& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSGP_Types.Requested_GANSS_Assistance_Data.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.requested__GANSS__Assistance__Data__Value().is_bound()) field_requested__GANSS__Assistance__Data__Value = other_value.requested__GANSS__Assistance__Data__Value();
else field_requested__GANSS__Assistance__Data__Value.clean_up();
}

void Requested__GANSS__Assistance__Data::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_requested__GANSS__Assistance__Data__Value.clean_up();
}

const TTCN_Typedescriptor_t* Requested__GANSS__Assistance__Data::get_descriptor() const { return &Requested__GANSS__Assistance__Data_descr_; }
Requested__GANSS__Assistance__Data& Requested__GANSS__Assistance__Data::operator=(const Requested__GANSS__Assistance__Data& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSGP_Types.Requested_GANSS_Assistance_Data.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.requested__GANSS__Assistance__Data__Value().is_bound()) field_requested__GANSS__Assistance__Data__Value = other_value.requested__GANSS__Assistance__Data__Value();
  else field_requested__GANSS__Assistance__Data__Value.clean_up();
}
return *this;
}

boolean Requested__GANSS__Assistance__Data::operator==(const Requested__GANSS__Assistance__Data& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_requested__GANSS__Assistance__Data__Value==other_value.field_requested__GANSS__Assistance__Data__Value;
}

boolean Requested__GANSS__Assistance__Data::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_requested__GANSS__Assistance__Data__Value.is_bound());
}
boolean Requested__GANSS__Assistance__Data::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_requested__GANSS__Assistance__Data__Value.is_value();
}
void Requested__GANSS__Assistance__Data::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", requested_GANSS_Assistance_Data_Value := ");
field_requested__GANSS__Assistance__Data__Value.log();
TTCN_Logger::log_event_str(" }");
}

void Requested__GANSS__Assistance__Data::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (requested__GANSS__Assistance__Data__Value().is_bound()) requested__GANSS__Assistance__Data__Value().set_implicit_omit();
}

void Requested__GANSS__Assistance__Data::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @BSSGP_Types.Requested_GANSS_Assistance_Data has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) requested__GANSS__Assistance__Data__Value().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requested_GANSS_Assistance_Data_Value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requested__GANSS__Assistance__Data__Value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Requested_GANSS_Assistance_Data: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSGP_Types.Requested_GANSS_Assistance_Data");
  }
}

void Requested__GANSS__Assistance__Data::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_requested__GANSS__Assistance__Data__Value.encode_text(text_buf);
}

void Requested__GANSS__Assistance__Data::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_requested__GANSS__Assistance__Data__Value.decode_text(text_buf);
}

void Requested__GANSS__Assistance__Data::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Requested__GANSS__Assistance__Data::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Requested__GANSS__Assistance__Data::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, Requested__GANSS__Assistance__Data_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(Requested__GANSS__Assistance__Data_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_0) selected_field = 0;
  else if (field_ext ==  bs_1) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, Requested__GANSS__Assistance__Data_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(Requested__GANSS__Assistance__Data_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_requested__GANSS__Assistance__Data__Value.RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  if (field_iEI !=  os_120) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int Requested__GANSS__Assistance__Data::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Requested__GANSS__Assistance__Data_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Requested__GANSS__Assistance__Data_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, OCTETSTRING_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(Requested__GANSS__Assistance__Data_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(Requested__GANSS__Assistance__Data_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_requested__GANSS__Assistance__Data__Value.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[3]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1:
  if (field_ext !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(Requested__GANSS__Assistance__Data_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a::ALT_length2:
  if (field_ext !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(Requested__GANSS__Assistance__Data_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_iEI !=  os_120) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_120.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct Requested__GANSS__Assistance__Data_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a_template field_lengthIndicator;
OCTETSTRING_template field_requested__GANSS__Assistance__Data__Value;
};

void Requested__GANSS__Assistance__Data_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_requested__GANSS__Assistance__Data__Value = ANY_VALUE;
}
}
}

void Requested__GANSS__Assistance__Data_template::copy_value(const Requested__GANSS__Assistance__Data& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.requested__GANSS__Assistance__Data__Value().is_bound()) {
  single_value->field_requested__GANSS__Assistance__Data__Value = other_value.requested__GANSS__Assistance__Data__Value();
} else {
  single_value->field_requested__GANSS__Assistance__Data__Value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Requested__GANSS__Assistance__Data_template::copy_template(const Requested__GANSS__Assistance__Data_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.requested__GANSS__Assistance__Data__Value().get_selection()) {
single_value->field_requested__GANSS__Assistance__Data__Value = other_value.requested__GANSS__Assistance__Data__Value();
} else {
single_value->field_requested__GANSS__Assistance__Data__Value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Requested__GANSS__Assistance__Data_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Requested__GANSS__Assistance__Data_template(*other_value.implication_.precondition);
implication_.implied_template = new Requested__GANSS__Assistance__Data_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSGP_Types.Requested_GANSS_Assistance_Data.");
break;
}
set_selection(other_value);
}

Requested__GANSS__Assistance__Data_template::Requested__GANSS__Assistance__Data_template()
{
}

Requested__GANSS__Assistance__Data_template::Requested__GANSS__Assistance__Data_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Requested__GANSS__Assistance__Data_template::Requested__GANSS__Assistance__Data_template(const Requested__GANSS__Assistance__Data& other_value)
{
copy_value(other_value);
}

Requested__GANSS__Assistance__Data_template::Requested__GANSS__Assistance__Data_template(const OPTIONAL<Requested__GANSS__Assistance__Data>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Requested__GANSS__Assistance__Data&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSGP_Types.Requested_GANSS_Assistance_Data from an unbound optional field.");
}
}

Requested__GANSS__Assistance__Data_template::Requested__GANSS__Assistance__Data_template(Requested__GANSS__Assistance__Data_template* p_precondition, Requested__GANSS__Assistance__Data_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Requested__GANSS__Assistance__Data_template::Requested__GANSS__Assistance__Data_template(Dynamic_Match_Interface<Requested__GANSS__Assistance__Data>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Requested__GANSS__Assistance__Data>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Requested__GANSS__Assistance__Data_template::Requested__GANSS__Assistance__Data_template(const Requested__GANSS__Assistance__Data_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Requested__GANSS__Assistance__Data_template::~Requested__GANSS__Assistance__Data_template()
{
clean_up();
}

Requested__GANSS__Assistance__Data_template& Requested__GANSS__Assistance__Data_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Requested__GANSS__Assistance__Data_template& Requested__GANSS__Assistance__Data_template::operator=(const Requested__GANSS__Assistance__Data& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Requested__GANSS__Assistance__Data_template& Requested__GANSS__Assistance__Data_template::operator=(const OPTIONAL<Requested__GANSS__Assistance__Data>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Requested__GANSS__Assistance__Data&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSGP_Types.Requested_GANSS_Assistance_Data.");
}
return *this;
}

Requested__GANSS__Assistance__Data_template& Requested__GANSS__Assistance__Data_template::operator=(const Requested__GANSS__Assistance__Data_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Requested__GANSS__Assistance__Data_template::match(const Requested__GANSS__Assistance__Data& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.requested__GANSS__Assistance__Data__Value().is_bound()) return FALSE;
if(!single_value->field_requested__GANSS__Assistance__Data__Value.match(other_value.requested__GANSS__Assistance__Data__Value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSGP_Types.Requested_GANSS_Assistance_Data.");
}
return FALSE;
}

boolean Requested__GANSS__Assistance__Data_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_requested__GANSS__Assistance__Data__Value.is_bound();
}

boolean Requested__GANSS__Assistance__Data_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_requested__GANSS__Assistance__Data__Value.is_value();
}

void Requested__GANSS__Assistance__Data_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Requested__GANSS__Assistance__Data Requested__GANSS__Assistance__Data_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSGP_Types.Requested_GANSS_Assistance_Data.");
Requested__GANSS__Assistance__Data ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_requested__GANSS__Assistance__Data__Value.is_bound()) {
ret_val.requested__GANSS__Assistance__Data__Value() = single_value->field_requested__GANSS__Assistance__Data__Value.valueof();
}
return ret_val;
}

void Requested__GANSS__Assistance__Data_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSGP_Types.Requested_GANSS_Assistance_Data.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Requested__GANSS__Assistance__Data_template[list_length];
}

Requested__GANSS__Assistance__Data_template& Requested__GANSS__Assistance__Data_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSGP_Types.Requested_GANSS_Assistance_Data.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSGP_Types.Requested_GANSS_Assistance_Data.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& Requested__GANSS__Assistance__Data_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& Requested__GANSS__Assistance__Data_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @BSSGP_Types.Requested_GANSS_Assistance_Data.");
return single_value->field_iEI;
}

BITSTRING_template& Requested__GANSS__Assistance__Data_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& Requested__GANSS__Assistance__Data_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @BSSGP_Types.Requested_GANSS_Assistance_Data.");
return single_value->field_ext;
}

LIN2__2a_template& Requested__GANSS__Assistance__Data_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a_template& Requested__GANSS__Assistance__Data_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSGP_Types.Requested_GANSS_Assistance_Data.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& Requested__GANSS__Assistance__Data_template::requested__GANSS__Assistance__Data__Value()
{
set_specific();
return single_value->field_requested__GANSS__Assistance__Data__Value;
}

const OCTETSTRING_template& Requested__GANSS__Assistance__Data_template::requested__GANSS__Assistance__Data__Value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field requested_GANSS_Assistance_Data_Value of a non-specific template of type @BSSGP_Types.Requested_GANSS_Assistance_Data.");
return single_value->field_requested__GANSS__Assistance__Data__Value;
}

int Requested__GANSS__Assistance__Data_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Requested_GANSS_Assistance_Data which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSGP_Types.Requested_GANSS_Assistance_Data containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Requested_GANSS_Assistance_Data containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Requested_GANSS_Assistance_Data containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Requested_GANSS_Assistance_Data containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Requested_GANSS_Assistance_Data containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Requested_GANSS_Assistance_Data containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Requested_GANSS_Assistance_Data containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Requested_GANSS_Assistance_Data containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSGP_Types.Requested_GANSS_Assistance_Data.");
  }
  return 0;
}

void Requested__GANSS__Assistance__Data_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", requested_GANSS_Assistance_Data_Value := ");
single_value->field_requested__GANSS__Assistance__Data__Value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Requested__GANSS__Assistance__Data_template::log_match(const Requested__GANSS__Assistance__Data& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_requested__GANSS__Assistance__Data__Value.match(match_value.requested__GANSS__Assistance__Data__Value(), legacy)){
TTCN_Logger::log_logmatch_info(".requested_GANSS_Assistance_Data_Value");
single_value->field_requested__GANSS__Assistance__Data__Value.log_match(match_value.requested__GANSS__Assistance__Data__Value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", requested_GANSS_Assistance_Data_Value := ");
single_value->field_requested__GANSS__Assistance__Data__Value.log_match(match_value.requested__GANSS__Assistance__Data__Value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Requested__GANSS__Assistance__Data_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_requested__GANSS__Assistance__Data__Value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSGP_Types.Requested_GANSS_Assistance_Data.");
}
}

void Requested__GANSS__Assistance__Data_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_requested__GANSS__Assistance__Data__Value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Requested__GANSS__Assistance__Data_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSGP_Types.Requested_GANSS_Assistance_Data.");
}
}

void Requested__GANSS__Assistance__Data_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Requested__GANSS__Assistance__Data_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @BSSGP_Types.Requested_GANSS_Assistance_Data has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) requested__GANSS__Assistance__Data__Value().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "requested_GANSS_Assistance_Data_Value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          requested__GANSS__Assistance__Data__Value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Requested_GANSS_Assistance_Data: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Requested__GANSS__Assistance__Data_template* precondition = new Requested__GANSS__Assistance__Data_template;
    precondition->set_param(*param.get_elem(0));
    Requested__GANSS__Assistance__Data_template* implied_template = new Requested__GANSS__Assistance__Data_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Requested__GANSS__Assistance__Data_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSGP_Types.Requested_GANSS_Assistance_Data");
  }
  is_ifpresent = param.get_ifpresent();
}

void Requested__GANSS__Assistance__Data_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Requested_GANSS_Assistance_Data");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Requested_GANSS_Assistance_Data");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Requested_GANSS_Assistance_Data");
single_value->field_requested__GANSS__Assistance__Data__Value.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Requested_GANSS_Assistance_Data");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSGP_Types.Requested_GANSS_Assistance_Data");
}

boolean Requested__GANSS__Assistance__Data_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Requested__GANSS__Assistance__Data_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

GANSS__Location__Type::GANSS__Location__Type()
{
}

GANSS__Location__Type::GANSS__Location__Type(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a& par_lengthIndicator,
    const BITSTRING& par_galileo,
    const BITSTRING& par_spare)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_galileo(par_galileo),
  field_spare(par_spare)
{
}

GANSS__Location__Type::GANSS__Location__Type(const GANSS__Location__Type& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSGP_Types.GANSS_Location_Type.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.galileo().is_bound()) field_galileo = other_value.galileo();
else field_galileo.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void GANSS__Location__Type::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_galileo.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* GANSS__Location__Type::get_descriptor() const { return &GANSS__Location__Type_descr_; }
GANSS__Location__Type& GANSS__Location__Type::operator=(const GANSS__Location__Type& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSGP_Types.GANSS_Location_Type.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.galileo().is_bound()) field_galileo = other_value.galileo();
  else field_galileo.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean GANSS__Location__Type::operator==(const GANSS__Location__Type& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_galileo==other_value.field_galileo
  && field_spare==other_value.field_spare;
}

boolean GANSS__Location__Type::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_galileo.is_bound())
  || (field_spare.is_bound());
}
boolean GANSS__Location__Type::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_galileo.is_value()
  && field_spare.is_value();
}
void GANSS__Location__Type::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", galileo := ");
field_galileo.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void GANSS__Location__Type::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (galileo().is_bound()) galileo().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void GANSS__Location__Type::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @BSSGP_Types.GANSS_Location_Type has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) galileo().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "galileo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          galileo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.GANSS_Location_Type: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSGP_Types.GANSS_Location_Type");
  }
}

void GANSS__Location__Type::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_galileo.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void GANSS__Location__Type::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_galileo.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void GANSS__Location__Type::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void GANSS__Location__Type::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int GANSS__Location__Type::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, GANSS__Location__Type_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(GANSS__Location__Type_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_0) selected_field = 0;
  else if (field_ext ==  bs_1) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, GANSS__Location__Type_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(GANSS__Location__Type_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_galileo.RAW_decode(General__Types::BIT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT7_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT7_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  if (field_iEI !=  os_119) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int GANSS__Location__Type::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, GANSS__Location__Type_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, GANSS__Location__Type_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT7_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(GANSS__Location__Type_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(GANSS__Location__Type_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_galileo.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT7_descr_, *myleaf.body.node.nodes[4]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 2;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(2);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1:
  if (field_ext !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(GANSS__Location__Type_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a::ALT_length2:
  if (field_ext !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(GANSS__Location__Type_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_iEI !=  os_119) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_119.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct GANSS__Location__Type_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a_template field_lengthIndicator;
BITSTRING_template field_galileo;
BITSTRING_template field_spare;
};

void GANSS__Location__Type_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_galileo = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void GANSS__Location__Type_template::copy_value(const GANSS__Location__Type& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.galileo().is_bound()) {
  single_value->field_galileo = other_value.galileo();
} else {
  single_value->field_galileo.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void GANSS__Location__Type_template::copy_template(const GANSS__Location__Type_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.galileo().get_selection()) {
single_value->field_galileo = other_value.galileo();
} else {
single_value->field_galileo.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new GANSS__Location__Type_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new GANSS__Location__Type_template(*other_value.implication_.precondition);
implication_.implied_template = new GANSS__Location__Type_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSGP_Types.GANSS_Location_Type.");
break;
}
set_selection(other_value);
}

GANSS__Location__Type_template::GANSS__Location__Type_template()
{
}

GANSS__Location__Type_template::GANSS__Location__Type_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

GANSS__Location__Type_template::GANSS__Location__Type_template(const GANSS__Location__Type& other_value)
{
copy_value(other_value);
}

GANSS__Location__Type_template::GANSS__Location__Type_template(const OPTIONAL<GANSS__Location__Type>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GANSS__Location__Type&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSGP_Types.GANSS_Location_Type from an unbound optional field.");
}
}

GANSS__Location__Type_template::GANSS__Location__Type_template(GANSS__Location__Type_template* p_precondition, GANSS__Location__Type_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

GANSS__Location__Type_template::GANSS__Location__Type_template(Dynamic_Match_Interface<GANSS__Location__Type>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<GANSS__Location__Type>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

GANSS__Location__Type_template::GANSS__Location__Type_template(const GANSS__Location__Type_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

GANSS__Location__Type_template::~GANSS__Location__Type_template()
{
clean_up();
}

GANSS__Location__Type_template& GANSS__Location__Type_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

GANSS__Location__Type_template& GANSS__Location__Type_template::operator=(const GANSS__Location__Type& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

GANSS__Location__Type_template& GANSS__Location__Type_template::operator=(const OPTIONAL<GANSS__Location__Type>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GANSS__Location__Type&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSGP_Types.GANSS_Location_Type.");
}
return *this;
}

GANSS__Location__Type_template& GANSS__Location__Type_template::operator=(const GANSS__Location__Type_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean GANSS__Location__Type_template::match(const GANSS__Location__Type& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.galileo().is_bound()) return FALSE;
if(!single_value->field_galileo.match(other_value.galileo(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSGP_Types.GANSS_Location_Type.");
}
return FALSE;
}

boolean GANSS__Location__Type_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_galileo.is_bound()
 || single_value->field_spare.is_bound();
}

boolean GANSS__Location__Type_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_galileo.is_value()
 && single_value->field_spare.is_value();
}

void GANSS__Location__Type_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

GANSS__Location__Type GANSS__Location__Type_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSGP_Types.GANSS_Location_Type.");
GANSS__Location__Type ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_galileo.is_bound()) {
ret_val.galileo() = single_value->field_galileo.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void GANSS__Location__Type_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSGP_Types.GANSS_Location_Type.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new GANSS__Location__Type_template[list_length];
}

GANSS__Location__Type_template& GANSS__Location__Type_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSGP_Types.GANSS_Location_Type.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSGP_Types.GANSS_Location_Type.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& GANSS__Location__Type_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& GANSS__Location__Type_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @BSSGP_Types.GANSS_Location_Type.");
return single_value->field_iEI;
}

BITSTRING_template& GANSS__Location__Type_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& GANSS__Location__Type_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @BSSGP_Types.GANSS_Location_Type.");
return single_value->field_ext;
}

LIN2__2a_template& GANSS__Location__Type_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a_template& GANSS__Location__Type_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSGP_Types.GANSS_Location_Type.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& GANSS__Location__Type_template::galileo()
{
set_specific();
return single_value->field_galileo;
}

const BITSTRING_template& GANSS__Location__Type_template::galileo() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field galileo of a non-specific template of type @BSSGP_Types.GANSS_Location_Type.");
return single_value->field_galileo;
}

BITSTRING_template& GANSS__Location__Type_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& GANSS__Location__Type_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @BSSGP_Types.GANSS_Location_Type.");
return single_value->field_spare;
}

int GANSS__Location__Type_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Location_Type which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Location_Type containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Location_Type containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Location_Type containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Location_Type containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Location_Type containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Location_Type containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Location_Type containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Location_Type containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSGP_Types.GANSS_Location_Type.");
  }
  return 0;
}

void GANSS__Location__Type_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", galileo := ");
single_value->field_galileo.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void GANSS__Location__Type_template::log_match(const GANSS__Location__Type& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_galileo.match(match_value.galileo(), legacy)){
TTCN_Logger::log_logmatch_info(".galileo");
single_value->field_galileo.log_match(match_value.galileo(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", galileo := ");
single_value->field_galileo.log_match(match_value.galileo(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void GANSS__Location__Type_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_galileo.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSGP_Types.GANSS_Location_Type.");
}
}

void GANSS__Location__Type_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_galileo.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new GANSS__Location__Type_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSGP_Types.GANSS_Location_Type.");
}
}

void GANSS__Location__Type_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    GANSS__Location__Type_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @BSSGP_Types.GANSS_Location_Type has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) galileo().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "galileo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          galileo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.GANSS_Location_Type: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    GANSS__Location__Type_template* precondition = new GANSS__Location__Type_template;
    precondition->set_param(*param.get_elem(0));
    GANSS__Location__Type_template* implied_template = new GANSS__Location__Type_template;
    implied_template->set_param(*param.get_elem(1));
    *this = GANSS__Location__Type_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSGP_Types.GANSS_Location_Type");
  }
  is_ifpresent = param.get_ifpresent();
}

void GANSS__Location__Type_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.GANSS_Location_Type");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.GANSS_Location_Type");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.GANSS_Location_Type");
single_value->field_galileo.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.GANSS_Location_Type");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.GANSS_Location_Type");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSGP_Types.GANSS_Location_Type");
}

boolean GANSS__Location__Type_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean GANSS__Location__Type_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const GANSS__Positioning__DataValue GANSS__Positioning__DataList::UNBOUND_ELEM;
GANSS__Positioning__DataList::GANSS__Positioning__DataList()
{
val_ptr = NULL;
}

GANSS__Positioning__DataList::GANSS__Positioning__DataList(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

GANSS__Positioning__DataList::GANSS__Positioning__DataList(const GANSS__Positioning__DataList& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSGP_Types.GANSS_Positioning_DataList.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

GANSS__Positioning__DataList::~GANSS__Positioning__DataList()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void GANSS__Positioning__DataList::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

GANSS__Positioning__DataList& GANSS__Positioning__DataList::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

GANSS__Positioning__DataList& GANSS__Positioning__DataList::operator=(const GANSS__Positioning__DataList& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @BSSGP_Types.GANSS_Positioning_DataList.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean GANSS__Positioning__DataList::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @BSSGP_Types.GANSS_Positioning_DataList.");
return val_ptr->n_elements == 0 ;
}

boolean GANSS__Positioning__DataList::operator==(const GANSS__Positioning__DataList& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @BSSGP_Types.GANSS_Positioning_DataList.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @BSSGP_Types.GANSS_Positioning_DataList.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

GANSS__Positioning__DataValue& GANSS__Positioning__DataList::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @BSSGP_Types.GANSS_Positioning_DataList using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (GANSS__Positioning__DataValue**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new GANSS__Positioning__DataValue(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new GANSS__Positioning__DataValue;
}
return *val_ptr->value_elements[index_value];
}

GANSS__Positioning__DataValue& GANSS__Positioning__DataList::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @BSSGP_Types.GANSS_Positioning_DataList.");
return (*this)[(int)index_value];
}

const GANSS__Positioning__DataValue& GANSS__Positioning__DataList::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @BSSGP_Types.GANSS_Positioning_DataList.");
if (index_value < 0) TTCN_error("Accessing an element of type @BSSGP_Types.GANSS_Positioning_DataList using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @BSSGP_Types.GANSS_Positioning_DataList: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const GANSS__Positioning__DataValue& GANSS__Positioning__DataList::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @BSSGP_Types.GANSS_Positioning_DataList.");
return (*this)[(int)index_value];
}

GANSS__Positioning__DataList GANSS__Positioning__DataList::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

GANSS__Positioning__DataList GANSS__Positioning__DataList::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

GANSS__Positioning__DataList GANSS__Positioning__DataList::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

GANSS__Positioning__DataList GANSS__Positioning__DataList::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @BSSGP_Types.GANSS_Positioning_DataList.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
GANSS__Positioning__DataList ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new GANSS__Positioning__DataValue(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

GANSS__Positioning__DataList GANSS__Positioning__DataList::operator+(const GANSS__Positioning__DataList& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @BSSGP_Types.GANSS_Positioning_DataList concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
GANSS__Positioning__DataList ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new GANSS__Positioning__DataValue(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new GANSS__Positioning__DataValue(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

GANSS__Positioning__DataList GANSS__Positioning__DataList::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @BSSGP_Types.GANSS_Positioning_DataList.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@BSSGP_Types.GANSS_Positioning_DataList","element");
GANSS__Positioning__DataList ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new GANSS__Positioning__DataValue(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

GANSS__Positioning__DataList GANSS__Positioning__DataList::replace(int index, int len, const GANSS__Positioning__DataList& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @BSSGP_Types.GANSS_Positioning_DataList.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @BSSGP_Types.GANSS_Positioning_DataList.");
check_replace_arguments(val_ptr->n_elements, index, len, "@BSSGP_Types.GANSS_Positioning_DataList","element");
GANSS__Positioning__DataList ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new GANSS__Positioning__DataValue(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new GANSS__Positioning__DataValue(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new GANSS__Positioning__DataValue(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

GANSS__Positioning__DataList GANSS__Positioning__DataList::replace(int index, int len, const GANSS__Positioning__DataList_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void GANSS__Positioning__DataList::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @BSSGP_Types.GANSS_Positioning_DataList.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (GANSS__Positioning__DataValue**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new GANSS__Positioning__DataValue(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (GANSS__Positioning__DataValue**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @BSSGP_Types.GANSS_Positioning_DataList: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (GANSS__Positioning__DataValue**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean GANSS__Positioning__DataList::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int GANSS__Positioning__DataList::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @BSSGP_Types.GANSS_Positioning_DataList.");
return val_ptr->n_elements;
}

int GANSS__Positioning__DataList::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @BSSGP_Types.GANSS_Positioning_DataList.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void GANSS__Positioning__DataList::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void GANSS__Positioning__DataList::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void GANSS__Positioning__DataList::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@BSSGP_Types.GANSS_Positioning_DataList");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@BSSGP_Types.GANSS_Positioning_DataList");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void GANSS__Positioning__DataList::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @BSSGP_Types.GANSS_Positioning_DataList.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void GANSS__Positioning__DataList::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @BSSGP_Types.GANSS_Positioning_DataList.");
val_ptr->value_elements = (GANSS__Positioning__DataValue**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new GANSS__Positioning__DataValue;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void GANSS__Positioning__DataList::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void GANSS__Positioning__DataList::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int GANSS__Positioning__DataList::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int GANSS__Positioning__DataList::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void GANSS__Positioning__DataList_template::copy_value(const GANSS__Positioning__DataList& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @BSSGP_Types.GANSS_Positioning_DataList with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (GANSS__Positioning__DataValue_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new GANSS__Positioning__DataValue_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new GANSS__Positioning__DataValue_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void GANSS__Positioning__DataList_template::copy_template(const GANSS__Positioning__DataList_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (GANSS__Positioning__DataValue_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new GANSS__Positioning__DataValue_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new GANSS__Positioning__DataValue_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new GANSS__Positioning__DataList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new GANSS__Positioning__DataList_template(*other_value.implication_.precondition);
implication_.implied_template = new GANSS__Positioning__DataList_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSGP_Types.GANSS_Positioning_DataList.");
break;
}
set_selection(other_value);
}

boolean GANSS__Positioning__DataList_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const GANSS__Positioning__DataList_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const GANSS__Positioning__DataList*)value_ptr)[value_index], legacy);
else return ((const GANSS__Positioning__DataList_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

GANSS__Positioning__DataList_template::GANSS__Positioning__DataList_template()
{
}

GANSS__Positioning__DataList_template::GANSS__Positioning__DataList_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

GANSS__Positioning__DataList_template::GANSS__Positioning__DataList_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

GANSS__Positioning__DataList_template::GANSS__Positioning__DataList_template(const GANSS__Positioning__DataList& other_value)
{
copy_value(other_value);
}

GANSS__Positioning__DataList_template::GANSS__Positioning__DataList_template(const OPTIONAL<GANSS__Positioning__DataList>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GANSS__Positioning__DataList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSGP_Types.GANSS_Positioning_DataList from an unbound optional field.");
}
}

GANSS__Positioning__DataList_template::GANSS__Positioning__DataList_template(GANSS__Positioning__DataList_template* p_precondition, GANSS__Positioning__DataList_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

GANSS__Positioning__DataList_template::GANSS__Positioning__DataList_template(Dynamic_Match_Interface<GANSS__Positioning__DataList>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<GANSS__Positioning__DataList>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

GANSS__Positioning__DataList_template::GANSS__Positioning__DataList_template(const GANSS__Positioning__DataList_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

GANSS__Positioning__DataList_template::~GANSS__Positioning__DataList_template()
{
clean_up();
}

void GANSS__Positioning__DataList_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

GANSS__Positioning__DataList_template& GANSS__Positioning__DataList_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

GANSS__Positioning__DataList_template& GANSS__Positioning__DataList_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

GANSS__Positioning__DataList_template& GANSS__Positioning__DataList_template::operator=(const GANSS__Positioning__DataList& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

GANSS__Positioning__DataList_template& GANSS__Positioning__DataList_template::operator=(const OPTIONAL<GANSS__Positioning__DataList>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GANSS__Positioning__DataList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSGP_Types.GANSS_Positioning_DataList.");
}
return *this;
}

GANSS__Positioning__DataList_template& GANSS__Positioning__DataList_template::operator=(const GANSS__Positioning__DataList_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

GANSS__Positioning__DataValue_template& GANSS__Positioning__DataList_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @BSSGP_Types.GANSS_Positioning_DataList using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @BSSGP_Types.GANSS_Positioning_DataList.");
    break;
}
return *single_value.value_elements[index_value];
}

GANSS__Positioning__DataValue_template& GANSS__Positioning__DataList_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @BSSGP_Types.GANSS_Positioning_DataList.");
return (*this)[(int)index_value];
}

const GANSS__Positioning__DataValue_template& GANSS__Positioning__DataList_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @BSSGP_Types.GANSS_Positioning_DataList using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @BSSGP_Types.GANSS_Positioning_DataList.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @BSSGP_Types.GANSS_Positioning_DataList: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const GANSS__Positioning__DataValue_template& GANSS__Positioning__DataList_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @BSSGP_Types.GANSS_Positioning_DataList.");
return (*this)[(int)index_value];
}

void GANSS__Positioning__DataList_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @BSSGP_Types.GANSS_Positioning_DataList.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (GANSS__Positioning__DataValue_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new GANSS__Positioning__DataValue_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new GANSS__Positioning__DataValue_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (GANSS__Positioning__DataValue_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int GANSS__Positioning__DataList_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int GANSS__Positioning__DataList_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @BSSGP_Types.GANSS_Positioning_DataList which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @BSSGP_Types.GANSS_Positioning_DataList containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @BSSGP_Types.GANSS_Positioning_DataList containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @BSSGP_Types.GANSS_Positioning_DataList containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @BSSGP_Types.GANSS_Positioning_DataList containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @BSSGP_Types.GANSS_Positioning_DataList containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @BSSGP_Types.GANSS_Positioning_DataList.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @BSSGP_Types.GANSS_Positioning_DataList");
}

boolean GANSS__Positioning__DataList_template::match(const GANSS__Positioning__DataList& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @BSSGP_Types.GANSS_Positioning_DataList.");
}
return FALSE;
}

boolean GANSS__Positioning__DataList_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

GANSS__Positioning__DataList GANSS__Positioning__DataList_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSGP_Types.GANSS_Positioning_DataList.");
GANSS__Positioning__DataList ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

GANSS__Positioning__DataList GANSS__Positioning__DataList_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

GANSS__Positioning__DataList GANSS__Positioning__DataList_template::replace(int index, int len, const GANSS__Positioning__DataList_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

GANSS__Positioning__DataList GANSS__Positioning__DataList_template::replace(int index, int len, const GANSS__Positioning__DataList& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void GANSS__Positioning__DataList_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new GANSS__Positioning__DataList_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @BSSGP_Types.GANSS_Positioning_DataList.");
}
set_selection(template_type);
}

GANSS__Positioning__DataList_template& GANSS__Positioning__DataList_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @BSSGP_Types.GANSS_Positioning_DataList.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @BSSGP_Types.GANSS_Positioning_DataList.");
return value_list.list_value[list_index];
}

void GANSS__Positioning__DataList_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void GANSS__Positioning__DataList_template::log_match(const GANSS__Positioning__DataList& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void GANSS__Positioning__DataList_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSGP_Types.GANSS_Positioning_DataList.");
}
}

void GANSS__Positioning__DataList_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @BSSGP_Types.GANSS_Positioning_DataList.");
single_value.value_elements = (GANSS__Positioning__DataValue_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new GANSS__Positioning__DataValue_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new GANSS__Positioning__DataList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @BSSGP_Types.GANSS_Positioning_DataList.");
}
}

boolean GANSS__Positioning__DataList_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean GANSS__Positioning__DataList_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void GANSS__Positioning__DataList_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    GANSS__Positioning__DataList_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    GANSS__Positioning__DataList_template* precondition = new GANSS__Positioning__DataList_template;
    precondition->set_param(*param.get_elem(0));
    GANSS__Positioning__DataList_template* implied_template = new GANSS__Positioning__DataList_template;
    implied_template->set_param(*param.get_elem(1));
    *this = GANSS__Positioning__DataList_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@BSSGP_Types.GANSS_Positioning_DataList");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void GANSS__Positioning__DataList_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.GANSS_Positioning_DataList");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSGP_Types.GANSS_Positioning_DataList");
}

boolean GANSS__Positioning__DataList_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
GANSS__Positioning__DataValue::GANSS__Positioning__DataValue()
{
}

GANSS__Positioning__DataValue::GANSS__Positioning__DataValue(const BITSTRING& par_usage,
    const BITSTRING& par_gANSS__ID,
    const BITSTRING& par_method)
  :   field_usage(par_usage),
  field_gANSS__ID(par_gANSS__ID),
  field_method(par_method)
{
}

GANSS__Positioning__DataValue::GANSS__Positioning__DataValue(const GANSS__Positioning__DataValue& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSGP_Types.GANSS_Positioning_DataValue.");
if (other_value.usage().is_bound()) field_usage = other_value.usage();
else field_usage.clean_up();
if (other_value.gANSS__ID().is_bound()) field_gANSS__ID = other_value.gANSS__ID();
else field_gANSS__ID.clean_up();
if (other_value.method().is_bound()) field_method = other_value.method();
else field_method.clean_up();
}

void GANSS__Positioning__DataValue::clean_up()
{
field_usage.clean_up();
field_gANSS__ID.clean_up();
field_method.clean_up();
}

const TTCN_Typedescriptor_t* GANSS__Positioning__DataValue::get_descriptor() const { return &GANSS__Positioning__DataValue_descr_; }
GANSS__Positioning__DataValue& GANSS__Positioning__DataValue::operator=(const GANSS__Positioning__DataValue& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSGP_Types.GANSS_Positioning_DataValue.");
  if (other_value.usage().is_bound()) field_usage = other_value.usage();
  else field_usage.clean_up();
  if (other_value.gANSS__ID().is_bound()) field_gANSS__ID = other_value.gANSS__ID();
  else field_gANSS__ID.clean_up();
  if (other_value.method().is_bound()) field_method = other_value.method();
  else field_method.clean_up();
}
return *this;
}

boolean GANSS__Positioning__DataValue::operator==(const GANSS__Positioning__DataValue& other_value) const
{
return field_usage==other_value.field_usage
  && field_gANSS__ID==other_value.field_gANSS__ID
  && field_method==other_value.field_method;
}

boolean GANSS__Positioning__DataValue::is_bound() const
{
return (field_usage.is_bound())
  || (field_gANSS__ID.is_bound())
  || (field_method.is_bound());
}
boolean GANSS__Positioning__DataValue::is_value() const
{
return field_usage.is_value()
  && field_gANSS__ID.is_value()
  && field_method.is_value();
}
void GANSS__Positioning__DataValue::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ usage := ");
field_usage.log();
TTCN_Logger::log_event_str(", gANSS_ID := ");
field_gANSS__ID.log();
TTCN_Logger::log_event_str(", method := ");
field_method.log();
TTCN_Logger::log_event_str(" }");
}

void GANSS__Positioning__DataValue::set_implicit_omit()
{
if (usage().is_bound()) usage().set_implicit_omit();
if (gANSS__ID().is_bound()) gANSS__ID().set_implicit_omit();
if (method().is_bound()) method().set_implicit_omit();
}

void GANSS__Positioning__DataValue::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSGP_Types.GANSS_Positioning_DataValue has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) usage().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) gANSS__ID().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) method().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "usage")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          usage().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gANSS_ID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gANSS__ID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "method")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          method().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.GANSS_Positioning_DataValue: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSGP_Types.GANSS_Positioning_DataValue");
  }
}

void GANSS__Positioning__DataValue::encode_text(Text_Buf& text_buf) const
{
field_usage.encode_text(text_buf);
field_gANSS__ID.encode_text(text_buf);
field_method.encode_text(text_buf);
}

void GANSS__Positioning__DataValue::decode_text(Text_Buf& text_buf)
{
field_usage.decode_text(text_buf);
field_gANSS__ID.decode_text(text_buf);
field_method.decode_text(text_buf);
}

void GANSS__Positioning__DataValue::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void GANSS__Positioning__DataValue::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int GANSS__Positioning__DataValue::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_usage.RAW_decode(General__Types::BIT3_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_gANSS__ID.RAW_decode(General__Types::BIT3_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_method.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int GANSS__Positioning__DataValue::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT3_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT3_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT2_descr_.raw);
  encoded_length += field_usage.RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_gANSS__ID.RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_method.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct GANSS__Positioning__DataValue_template::single_value_struct {
BITSTRING_template field_usage;
BITSTRING_template field_gANSS__ID;
BITSTRING_template field_method;
};

void GANSS__Positioning__DataValue_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_usage = ANY_VALUE;
single_value->field_gANSS__ID = ANY_VALUE;
single_value->field_method = ANY_VALUE;
}
}
}

void GANSS__Positioning__DataValue_template::copy_value(const GANSS__Positioning__DataValue& other_value)
{
single_value = new single_value_struct;
if (other_value.usage().is_bound()) {
  single_value->field_usage = other_value.usage();
} else {
  single_value->field_usage.clean_up();
}
if (other_value.gANSS__ID().is_bound()) {
  single_value->field_gANSS__ID = other_value.gANSS__ID();
} else {
  single_value->field_gANSS__ID.clean_up();
}
if (other_value.method().is_bound()) {
  single_value->field_method = other_value.method();
} else {
  single_value->field_method.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void GANSS__Positioning__DataValue_template::copy_template(const GANSS__Positioning__DataValue_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.usage().get_selection()) {
single_value->field_usage = other_value.usage();
} else {
single_value->field_usage.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.gANSS__ID().get_selection()) {
single_value->field_gANSS__ID = other_value.gANSS__ID();
} else {
single_value->field_gANSS__ID.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.method().get_selection()) {
single_value->field_method = other_value.method();
} else {
single_value->field_method.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new GANSS__Positioning__DataValue_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new GANSS__Positioning__DataValue_template(*other_value.implication_.precondition);
implication_.implied_template = new GANSS__Positioning__DataValue_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSGP_Types.GANSS_Positioning_DataValue.");
break;
}
set_selection(other_value);
}

GANSS__Positioning__DataValue_template::GANSS__Positioning__DataValue_template()
{
}

GANSS__Positioning__DataValue_template::GANSS__Positioning__DataValue_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

GANSS__Positioning__DataValue_template::GANSS__Positioning__DataValue_template(const GANSS__Positioning__DataValue& other_value)
{
copy_value(other_value);
}

GANSS__Positioning__DataValue_template::GANSS__Positioning__DataValue_template(const OPTIONAL<GANSS__Positioning__DataValue>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GANSS__Positioning__DataValue&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSGP_Types.GANSS_Positioning_DataValue from an unbound optional field.");
}
}

GANSS__Positioning__DataValue_template::GANSS__Positioning__DataValue_template(GANSS__Positioning__DataValue_template* p_precondition, GANSS__Positioning__DataValue_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

GANSS__Positioning__DataValue_template::GANSS__Positioning__DataValue_template(Dynamic_Match_Interface<GANSS__Positioning__DataValue>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<GANSS__Positioning__DataValue>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

GANSS__Positioning__DataValue_template::GANSS__Positioning__DataValue_template(const GANSS__Positioning__DataValue_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

GANSS__Positioning__DataValue_template::~GANSS__Positioning__DataValue_template()
{
clean_up();
}

GANSS__Positioning__DataValue_template& GANSS__Positioning__DataValue_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

GANSS__Positioning__DataValue_template& GANSS__Positioning__DataValue_template::operator=(const GANSS__Positioning__DataValue& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

GANSS__Positioning__DataValue_template& GANSS__Positioning__DataValue_template::operator=(const OPTIONAL<GANSS__Positioning__DataValue>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GANSS__Positioning__DataValue&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSGP_Types.GANSS_Positioning_DataValue.");
}
return *this;
}

GANSS__Positioning__DataValue_template& GANSS__Positioning__DataValue_template::operator=(const GANSS__Positioning__DataValue_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean GANSS__Positioning__DataValue_template::match(const GANSS__Positioning__DataValue& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.usage().is_bound()) return FALSE;
if(!single_value->field_usage.match(other_value.usage(), legacy))return FALSE;
if(!other_value.gANSS__ID().is_bound()) return FALSE;
if(!single_value->field_gANSS__ID.match(other_value.gANSS__ID(), legacy))return FALSE;
if(!other_value.method().is_bound()) return FALSE;
if(!single_value->field_method.match(other_value.method(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSGP_Types.GANSS_Positioning_DataValue.");
}
return FALSE;
}

boolean GANSS__Positioning__DataValue_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_usage.is_bound()
 || single_value->field_gANSS__ID.is_bound()
 || single_value->field_method.is_bound();
}

boolean GANSS__Positioning__DataValue_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_usage.is_value()
 && single_value->field_gANSS__ID.is_value()
 && single_value->field_method.is_value();
}

void GANSS__Positioning__DataValue_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

GANSS__Positioning__DataValue GANSS__Positioning__DataValue_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSGP_Types.GANSS_Positioning_DataValue.");
GANSS__Positioning__DataValue ret_val;
if (single_value->field_usage.is_bound()) {
ret_val.usage() = single_value->field_usage.valueof();
}
if (single_value->field_gANSS__ID.is_bound()) {
ret_val.gANSS__ID() = single_value->field_gANSS__ID.valueof();
}
if (single_value->field_method.is_bound()) {
ret_val.method() = single_value->field_method.valueof();
}
return ret_val;
}

void GANSS__Positioning__DataValue_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSGP_Types.GANSS_Positioning_DataValue.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new GANSS__Positioning__DataValue_template[list_length];
}

GANSS__Positioning__DataValue_template& GANSS__Positioning__DataValue_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSGP_Types.GANSS_Positioning_DataValue.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSGP_Types.GANSS_Positioning_DataValue.");
return value_list.list_value[list_index];
}

BITSTRING_template& GANSS__Positioning__DataValue_template::usage()
{
set_specific();
return single_value->field_usage;
}

const BITSTRING_template& GANSS__Positioning__DataValue_template::usage() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field usage of a non-specific template of type @BSSGP_Types.GANSS_Positioning_DataValue.");
return single_value->field_usage;
}

BITSTRING_template& GANSS__Positioning__DataValue_template::gANSS__ID()
{
set_specific();
return single_value->field_gANSS__ID;
}

const BITSTRING_template& GANSS__Positioning__DataValue_template::gANSS__ID() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field gANSS_ID of a non-specific template of type @BSSGP_Types.GANSS_Positioning_DataValue.");
return single_value->field_gANSS__ID;
}

BITSTRING_template& GANSS__Positioning__DataValue_template::method()
{
set_specific();
return single_value->field_method;
}

const BITSTRING_template& GANSS__Positioning__DataValue_template::method() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field method of a non-specific template of type @BSSGP_Types.GANSS_Positioning_DataValue.");
return single_value->field_method;
}

int GANSS__Positioning__DataValue_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Positioning_DataValue which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Positioning_DataValue containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Positioning_DataValue containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Positioning_DataValue containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Positioning_DataValue containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Positioning_DataValue containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Positioning_DataValue containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Positioning_DataValue containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Positioning_DataValue containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSGP_Types.GANSS_Positioning_DataValue.");
  }
  return 0;
}

void GANSS__Positioning__DataValue_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ usage := ");
single_value->field_usage.log();
TTCN_Logger::log_event_str(", gANSS_ID := ");
single_value->field_gANSS__ID.log();
TTCN_Logger::log_event_str(", method := ");
single_value->field_method.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void GANSS__Positioning__DataValue_template::log_match(const GANSS__Positioning__DataValue& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_usage.match(match_value.usage(), legacy)){
TTCN_Logger::log_logmatch_info(".usage");
single_value->field_usage.log_match(match_value.usage(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_gANSS__ID.match(match_value.gANSS__ID(), legacy)){
TTCN_Logger::log_logmatch_info(".gANSS_ID");
single_value->field_gANSS__ID.log_match(match_value.gANSS__ID(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_method.match(match_value.method(), legacy)){
TTCN_Logger::log_logmatch_info(".method");
single_value->field_method.log_match(match_value.method(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ usage := ");
single_value->field_usage.log_match(match_value.usage(), legacy);
TTCN_Logger::log_event_str(", gANSS_ID := ");
single_value->field_gANSS__ID.log_match(match_value.gANSS__ID(), legacy);
TTCN_Logger::log_event_str(", method := ");
single_value->field_method.log_match(match_value.method(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void GANSS__Positioning__DataValue_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_usage.encode_text(text_buf);
single_value->field_gANSS__ID.encode_text(text_buf);
single_value->field_method.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSGP_Types.GANSS_Positioning_DataValue.");
}
}

void GANSS__Positioning__DataValue_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_usage.decode_text(text_buf);
single_value->field_gANSS__ID.decode_text(text_buf);
single_value->field_method.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new GANSS__Positioning__DataValue_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSGP_Types.GANSS_Positioning_DataValue.");
}
}

void GANSS__Positioning__DataValue_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    GANSS__Positioning__DataValue_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSGP_Types.GANSS_Positioning_DataValue has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) usage().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) gANSS__ID().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) method().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "usage")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          usage().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gANSS_ID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gANSS__ID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "method")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          method().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.GANSS_Positioning_DataValue: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    GANSS__Positioning__DataValue_template* precondition = new GANSS__Positioning__DataValue_template;
    precondition->set_param(*param.get_elem(0));
    GANSS__Positioning__DataValue_template* implied_template = new GANSS__Positioning__DataValue_template;
    implied_template->set_param(*param.get_elem(1));
    *this = GANSS__Positioning__DataValue_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSGP_Types.GANSS_Positioning_DataValue");
  }
  is_ifpresent = param.get_ifpresent();
}

void GANSS__Positioning__DataValue_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_usage.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.GANSS_Positioning_DataValue");
single_value->field_gANSS__ID.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.GANSS_Positioning_DataValue");
single_value->field_method.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.GANSS_Positioning_DataValue");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSGP_Types.GANSS_Positioning_DataValue");
}

boolean GANSS__Positioning__DataValue_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean GANSS__Positioning__DataValue_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

GANSS__Positioning__Data::GANSS__Positioning__Data()
{
}

GANSS__Positioning__Data::GANSS__Positioning__Data(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a& par_lengthIndicator,
    const GANSS__Positioning__DataList& par_gANSS__Positioning__DataList)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_gANSS__Positioning__DataList(par_gANSS__Positioning__DataList)
{
}

GANSS__Positioning__Data::GANSS__Positioning__Data(const GANSS__Positioning__Data& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSGP_Types.GANSS_Positioning_Data.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.gANSS__Positioning__DataList().is_bound()) field_gANSS__Positioning__DataList = other_value.gANSS__Positioning__DataList();
else field_gANSS__Positioning__DataList.clean_up();
}

void GANSS__Positioning__Data::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_gANSS__Positioning__DataList.clean_up();
}

const TTCN_Typedescriptor_t* GANSS__Positioning__Data::get_descriptor() const { return &GANSS__Positioning__Data_descr_; }
GANSS__Positioning__Data& GANSS__Positioning__Data::operator=(const GANSS__Positioning__Data& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSGP_Types.GANSS_Positioning_Data.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.gANSS__Positioning__DataList().is_bound()) field_gANSS__Positioning__DataList = other_value.gANSS__Positioning__DataList();
  else field_gANSS__Positioning__DataList.clean_up();
}
return *this;
}

boolean GANSS__Positioning__Data::operator==(const GANSS__Positioning__Data& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_gANSS__Positioning__DataList==other_value.field_gANSS__Positioning__DataList;
}

boolean GANSS__Positioning__Data::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_gANSS__Positioning__DataList.is_bound());
}
boolean GANSS__Positioning__Data::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_gANSS__Positioning__DataList.is_value();
}
void GANSS__Positioning__Data::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", gANSS_Positioning_DataList := ");
field_gANSS__Positioning__DataList.log();
TTCN_Logger::log_event_str(" }");
}

void GANSS__Positioning__Data::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (gANSS__Positioning__DataList().is_bound()) gANSS__Positioning__DataList().set_implicit_omit();
}

void GANSS__Positioning__Data::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @BSSGP_Types.GANSS_Positioning_Data has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) gANSS__Positioning__DataList().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gANSS_Positioning_DataList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gANSS__Positioning__DataList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.GANSS_Positioning_Data: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSGP_Types.GANSS_Positioning_Data");
  }
}

void GANSS__Positioning__Data::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_gANSS__Positioning__DataList.encode_text(text_buf);
}

void GANSS__Positioning__Data::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_gANSS__Positioning__DataList.decode_text(text_buf);
}

void GANSS__Positioning__Data::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void GANSS__Positioning__Data::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int GANSS__Positioning__Data::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, GANSS__Positioning__Data_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(GANSS__Positioning__Data_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_0) selected_field = 0;
  else if (field_ext ==  bs_1) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, GANSS__Positioning__Data_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(GANSS__Positioning__Data_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, GANSS__Positioning__DataList_descr_.raw->forceomit);
  decoded_field_length = field_gANSS__Positioning__DataList.RAW_decode(GANSS__Positioning__DataList_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  if (field_iEI !=  os_127) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int GANSS__Positioning__Data::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, GANSS__Positioning__Data_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, GANSS__Positioning__Data_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, GANSS__Positioning__DataList_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(GANSS__Positioning__Data_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(GANSS__Positioning__Data_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_gANSS__Positioning__DataList.RAW_encode(GANSS__Positioning__DataList_descr_, *myleaf.body.node.nodes[3]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1:
  if (field_ext !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(GANSS__Positioning__Data_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a::ALT_length2:
  if (field_ext !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(GANSS__Positioning__Data_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_iEI !=  os_127) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_127.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct GANSS__Positioning__Data_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a_template field_lengthIndicator;
GANSS__Positioning__DataList_template field_gANSS__Positioning__DataList;
};

void GANSS__Positioning__Data_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_gANSS__Positioning__DataList = ANY_VALUE;
}
}
}

void GANSS__Positioning__Data_template::copy_value(const GANSS__Positioning__Data& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.gANSS__Positioning__DataList().is_bound()) {
  single_value->field_gANSS__Positioning__DataList = other_value.gANSS__Positioning__DataList();
} else {
  single_value->field_gANSS__Positioning__DataList.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void GANSS__Positioning__Data_template::copy_template(const GANSS__Positioning__Data_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.gANSS__Positioning__DataList().get_selection()) {
single_value->field_gANSS__Positioning__DataList = other_value.gANSS__Positioning__DataList();
} else {
single_value->field_gANSS__Positioning__DataList.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new GANSS__Positioning__Data_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new GANSS__Positioning__Data_template(*other_value.implication_.precondition);
implication_.implied_template = new GANSS__Positioning__Data_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSGP_Types.GANSS_Positioning_Data.");
break;
}
set_selection(other_value);
}

GANSS__Positioning__Data_template::GANSS__Positioning__Data_template()
{
}

GANSS__Positioning__Data_template::GANSS__Positioning__Data_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

GANSS__Positioning__Data_template::GANSS__Positioning__Data_template(const GANSS__Positioning__Data& other_value)
{
copy_value(other_value);
}

GANSS__Positioning__Data_template::GANSS__Positioning__Data_template(const OPTIONAL<GANSS__Positioning__Data>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GANSS__Positioning__Data&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSGP_Types.GANSS_Positioning_Data from an unbound optional field.");
}
}

GANSS__Positioning__Data_template::GANSS__Positioning__Data_template(GANSS__Positioning__Data_template* p_precondition, GANSS__Positioning__Data_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

GANSS__Positioning__Data_template::GANSS__Positioning__Data_template(Dynamic_Match_Interface<GANSS__Positioning__Data>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<GANSS__Positioning__Data>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

GANSS__Positioning__Data_template::GANSS__Positioning__Data_template(const GANSS__Positioning__Data_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

GANSS__Positioning__Data_template::~GANSS__Positioning__Data_template()
{
clean_up();
}

GANSS__Positioning__Data_template& GANSS__Positioning__Data_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

GANSS__Positioning__Data_template& GANSS__Positioning__Data_template::operator=(const GANSS__Positioning__Data& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

GANSS__Positioning__Data_template& GANSS__Positioning__Data_template::operator=(const OPTIONAL<GANSS__Positioning__Data>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GANSS__Positioning__Data&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSGP_Types.GANSS_Positioning_Data.");
}
return *this;
}

GANSS__Positioning__Data_template& GANSS__Positioning__Data_template::operator=(const GANSS__Positioning__Data_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean GANSS__Positioning__Data_template::match(const GANSS__Positioning__Data& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.gANSS__Positioning__DataList().is_bound()) return FALSE;
if(!single_value->field_gANSS__Positioning__DataList.match(other_value.gANSS__Positioning__DataList(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSGP_Types.GANSS_Positioning_Data.");
}
return FALSE;
}

boolean GANSS__Positioning__Data_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_gANSS__Positioning__DataList.is_bound();
}

boolean GANSS__Positioning__Data_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_gANSS__Positioning__DataList.is_value();
}

void GANSS__Positioning__Data_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

GANSS__Positioning__Data GANSS__Positioning__Data_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSGP_Types.GANSS_Positioning_Data.");
GANSS__Positioning__Data ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_gANSS__Positioning__DataList.is_bound()) {
ret_val.gANSS__Positioning__DataList() = single_value->field_gANSS__Positioning__DataList.valueof();
}
return ret_val;
}

void GANSS__Positioning__Data_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSGP_Types.GANSS_Positioning_Data.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new GANSS__Positioning__Data_template[list_length];
}

GANSS__Positioning__Data_template& GANSS__Positioning__Data_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSGP_Types.GANSS_Positioning_Data.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSGP_Types.GANSS_Positioning_Data.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& GANSS__Positioning__Data_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& GANSS__Positioning__Data_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @BSSGP_Types.GANSS_Positioning_Data.");
return single_value->field_iEI;
}

BITSTRING_template& GANSS__Positioning__Data_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& GANSS__Positioning__Data_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @BSSGP_Types.GANSS_Positioning_Data.");
return single_value->field_ext;
}

LIN2__2a_template& GANSS__Positioning__Data_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a_template& GANSS__Positioning__Data_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSGP_Types.GANSS_Positioning_Data.");
return single_value->field_lengthIndicator;
}

GANSS__Positioning__DataList_template& GANSS__Positioning__Data_template::gANSS__Positioning__DataList()
{
set_specific();
return single_value->field_gANSS__Positioning__DataList;
}

const GANSS__Positioning__DataList_template& GANSS__Positioning__Data_template::gANSS__Positioning__DataList() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field gANSS_Positioning_DataList of a non-specific template of type @BSSGP_Types.GANSS_Positioning_Data.");
return single_value->field_gANSS__Positioning__DataList;
}

int GANSS__Positioning__Data_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Positioning_Data which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Positioning_Data containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Positioning_Data containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Positioning_Data containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Positioning_Data containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Positioning_Data containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Positioning_Data containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Positioning_Data containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.GANSS_Positioning_Data containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSGP_Types.GANSS_Positioning_Data.");
  }
  return 0;
}

void GANSS__Positioning__Data_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", gANSS_Positioning_DataList := ");
single_value->field_gANSS__Positioning__DataList.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void GANSS__Positioning__Data_template::log_match(const GANSS__Positioning__Data& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_gANSS__Positioning__DataList.match(match_value.gANSS__Positioning__DataList(), legacy)){
TTCN_Logger::log_logmatch_info(".gANSS_Positioning_DataList");
single_value->field_gANSS__Positioning__DataList.log_match(match_value.gANSS__Positioning__DataList(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", gANSS_Positioning_DataList := ");
single_value->field_gANSS__Positioning__DataList.log_match(match_value.gANSS__Positioning__DataList(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void GANSS__Positioning__Data_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_gANSS__Positioning__DataList.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSGP_Types.GANSS_Positioning_Data.");
}
}

void GANSS__Positioning__Data_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_gANSS__Positioning__DataList.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new GANSS__Positioning__Data_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSGP_Types.GANSS_Positioning_Data.");
}
}

void GANSS__Positioning__Data_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    GANSS__Positioning__Data_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @BSSGP_Types.GANSS_Positioning_Data has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) gANSS__Positioning__DataList().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gANSS_Positioning_DataList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gANSS__Positioning__DataList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.GANSS_Positioning_Data: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    GANSS__Positioning__Data_template* precondition = new GANSS__Positioning__Data_template;
    precondition->set_param(*param.get_elem(0));
    GANSS__Positioning__Data_template* implied_template = new GANSS__Positioning__Data_template;
    implied_template->set_param(*param.get_elem(1));
    *this = GANSS__Positioning__Data_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSGP_Types.GANSS_Positioning_Data");
  }
  is_ifpresent = param.get_ifpresent();
}

void GANSS__Positioning__Data_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.GANSS_Positioning_Data");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.GANSS_Positioning_Data");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.GANSS_Positioning_Data");
single_value->field_gANSS__Positioning__DataList.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.GANSS_Positioning_Data");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSGP_Types.GANSS_Positioning_Data");
}

boolean GANSS__Positioning__Data_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean GANSS__Positioning__Data_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Flow__Control__Granularity::Flow__Control__Granularity()
{
}

Flow__Control__Granularity::Flow__Control__Granularity(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a& par_lengthIndicator,
    const BITSTRING& par_granularity,
    const BITSTRING& par_reserved)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_granularity(par_granularity),
  field_reserved(par_reserved)
{
}

Flow__Control__Granularity::Flow__Control__Granularity(const Flow__Control__Granularity& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSGP_Types.Flow_Control_Granularity.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.granularity().is_bound()) field_granularity = other_value.granularity();
else field_granularity.clean_up();
if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
else field_reserved.clean_up();
}

void Flow__Control__Granularity::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_granularity.clean_up();
field_reserved.clean_up();
}

const TTCN_Typedescriptor_t* Flow__Control__Granularity::get_descriptor() const { return &Flow__Control__Granularity_descr_; }
Flow__Control__Granularity& Flow__Control__Granularity::operator=(const Flow__Control__Granularity& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSGP_Types.Flow_Control_Granularity.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.granularity().is_bound()) field_granularity = other_value.granularity();
  else field_granularity.clean_up();
  if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
  else field_reserved.clean_up();
}
return *this;
}

boolean Flow__Control__Granularity::operator==(const Flow__Control__Granularity& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_granularity==other_value.field_granularity
  && field_reserved==other_value.field_reserved;
}

boolean Flow__Control__Granularity::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_granularity.is_bound())
  || (field_reserved.is_bound());
}
boolean Flow__Control__Granularity::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_granularity.is_value()
  && field_reserved.is_value();
}
void Flow__Control__Granularity::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", granularity := ");
field_granularity.log();
TTCN_Logger::log_event_str(", reserved := ");
field_reserved.log();
TTCN_Logger::log_event_str(" }");
}

void Flow__Control__Granularity::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (granularity().is_bound()) granularity().set_implicit_omit();
if (reserved().is_bound()) reserved().set_implicit_omit();
}

void Flow__Control__Granularity::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @BSSGP_Types.Flow_Control_Granularity has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) granularity().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "granularity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          granularity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Flow_Control_Granularity: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSGP_Types.Flow_Control_Granularity");
  }
}

void Flow__Control__Granularity::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_granularity.encode_text(text_buf);
field_reserved.encode_text(text_buf);
}

void Flow__Control__Granularity::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_granularity.decode_text(text_buf);
field_reserved.decode_text(text_buf);
}

void Flow__Control__Granularity::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Flow__Control__Granularity::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Flow__Control__Granularity::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, Flow__Control__Granularity_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(Flow__Control__Granularity_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_0) selected_field = 0;
  else if (field_ext ==  bs_1) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, Flow__Control__Granularity_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(Flow__Control__Granularity_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_granularity.RAW_decode(General__Types::BIT2_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_reserved.RAW_decode(General__Types::BIT6_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  if (field_iEI !=  os_62) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int Flow__Control__Granularity::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Flow__Control__Granularity_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Flow__Control__Granularity_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT6_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(Flow__Control__Granularity_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(Flow__Control__Granularity_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_granularity.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_reserved.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[4]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 2;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(2);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1:
  if (field_ext !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(Flow__Control__Granularity_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a::ALT_length2:
  if (field_ext !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(Flow__Control__Granularity_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_iEI !=  os_62) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_62.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct Flow__Control__Granularity_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a_template field_lengthIndicator;
BITSTRING_template field_granularity;
BITSTRING_template field_reserved;
};

void Flow__Control__Granularity_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_granularity = ANY_VALUE;
single_value->field_reserved = ANY_VALUE;
}
}
}

void Flow__Control__Granularity_template::copy_value(const Flow__Control__Granularity& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.granularity().is_bound()) {
  single_value->field_granularity = other_value.granularity();
} else {
  single_value->field_granularity.clean_up();
}
if (other_value.reserved().is_bound()) {
  single_value->field_reserved = other_value.reserved();
} else {
  single_value->field_reserved.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Flow__Control__Granularity_template::copy_template(const Flow__Control__Granularity_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.granularity().get_selection()) {
single_value->field_granularity = other_value.granularity();
} else {
single_value->field_granularity.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reserved().get_selection()) {
single_value->field_reserved = other_value.reserved();
} else {
single_value->field_reserved.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Flow__Control__Granularity_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Flow__Control__Granularity_template(*other_value.implication_.precondition);
implication_.implied_template = new Flow__Control__Granularity_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSGP_Types.Flow_Control_Granularity.");
break;
}
set_selection(other_value);
}

Flow__Control__Granularity_template::Flow__Control__Granularity_template()
{
}

Flow__Control__Granularity_template::Flow__Control__Granularity_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Flow__Control__Granularity_template::Flow__Control__Granularity_template(const Flow__Control__Granularity& other_value)
{
copy_value(other_value);
}

Flow__Control__Granularity_template::Flow__Control__Granularity_template(const OPTIONAL<Flow__Control__Granularity>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Flow__Control__Granularity&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSGP_Types.Flow_Control_Granularity from an unbound optional field.");
}
}

Flow__Control__Granularity_template::Flow__Control__Granularity_template(Flow__Control__Granularity_template* p_precondition, Flow__Control__Granularity_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Flow__Control__Granularity_template::Flow__Control__Granularity_template(Dynamic_Match_Interface<Flow__Control__Granularity>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Flow__Control__Granularity>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Flow__Control__Granularity_template::Flow__Control__Granularity_template(const Flow__Control__Granularity_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Flow__Control__Granularity_template::~Flow__Control__Granularity_template()
{
clean_up();
}

Flow__Control__Granularity_template& Flow__Control__Granularity_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Flow__Control__Granularity_template& Flow__Control__Granularity_template::operator=(const Flow__Control__Granularity& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Flow__Control__Granularity_template& Flow__Control__Granularity_template::operator=(const OPTIONAL<Flow__Control__Granularity>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Flow__Control__Granularity&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSGP_Types.Flow_Control_Granularity.");
}
return *this;
}

Flow__Control__Granularity_template& Flow__Control__Granularity_template::operator=(const Flow__Control__Granularity_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Flow__Control__Granularity_template::match(const Flow__Control__Granularity& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.granularity().is_bound()) return FALSE;
if(!single_value->field_granularity.match(other_value.granularity(), legacy))return FALSE;
if(!other_value.reserved().is_bound()) return FALSE;
if(!single_value->field_reserved.match(other_value.reserved(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSGP_Types.Flow_Control_Granularity.");
}
return FALSE;
}

boolean Flow__Control__Granularity_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_granularity.is_bound()
 || single_value->field_reserved.is_bound();
}

boolean Flow__Control__Granularity_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_granularity.is_value()
 && single_value->field_reserved.is_value();
}

void Flow__Control__Granularity_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Flow__Control__Granularity Flow__Control__Granularity_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSGP_Types.Flow_Control_Granularity.");
Flow__Control__Granularity ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_granularity.is_bound()) {
ret_val.granularity() = single_value->field_granularity.valueof();
}
if (single_value->field_reserved.is_bound()) {
ret_val.reserved() = single_value->field_reserved.valueof();
}
return ret_val;
}

void Flow__Control__Granularity_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSGP_Types.Flow_Control_Granularity.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Flow__Control__Granularity_template[list_length];
}

Flow__Control__Granularity_template& Flow__Control__Granularity_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSGP_Types.Flow_Control_Granularity.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSGP_Types.Flow_Control_Granularity.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& Flow__Control__Granularity_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& Flow__Control__Granularity_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @BSSGP_Types.Flow_Control_Granularity.");
return single_value->field_iEI;
}

BITSTRING_template& Flow__Control__Granularity_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& Flow__Control__Granularity_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @BSSGP_Types.Flow_Control_Granularity.");
return single_value->field_ext;
}

LIN2__2a_template& Flow__Control__Granularity_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a_template& Flow__Control__Granularity_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSGP_Types.Flow_Control_Granularity.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& Flow__Control__Granularity_template::granularity()
{
set_specific();
return single_value->field_granularity;
}

const BITSTRING_template& Flow__Control__Granularity_template::granularity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field granularity of a non-specific template of type @BSSGP_Types.Flow_Control_Granularity.");
return single_value->field_granularity;
}

BITSTRING_template& Flow__Control__Granularity_template::reserved()
{
set_specific();
return single_value->field_reserved;
}

const BITSTRING_template& Flow__Control__Granularity_template::reserved() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reserved of a non-specific template of type @BSSGP_Types.Flow_Control_Granularity.");
return single_value->field_reserved;
}

int Flow__Control__Granularity_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Flow_Control_Granularity which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSGP_Types.Flow_Control_Granularity containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Flow_Control_Granularity containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Flow_Control_Granularity containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Flow_Control_Granularity containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Flow_Control_Granularity containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Flow_Control_Granularity containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Flow_Control_Granularity containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Flow_Control_Granularity containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSGP_Types.Flow_Control_Granularity.");
  }
  return 0;
}

void Flow__Control__Granularity_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", granularity := ");
single_value->field_granularity.log();
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Flow__Control__Granularity_template::log_match(const Flow__Control__Granularity& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_granularity.match(match_value.granularity(), legacy)){
TTCN_Logger::log_logmatch_info(".granularity");
single_value->field_granularity.log_match(match_value.granularity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reserved.match(match_value.reserved(), legacy)){
TTCN_Logger::log_logmatch_info(".reserved");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", granularity := ");
single_value->field_granularity.log_match(match_value.granularity(), legacy);
TTCN_Logger::log_event_str(", reserved := ");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Flow__Control__Granularity_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_granularity.encode_text(text_buf);
single_value->field_reserved.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSGP_Types.Flow_Control_Granularity.");
}
}

void Flow__Control__Granularity_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_granularity.decode_text(text_buf);
single_value->field_reserved.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Flow__Control__Granularity_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSGP_Types.Flow_Control_Granularity.");
}
}

void Flow__Control__Granularity_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Flow__Control__Granularity_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @BSSGP_Types.Flow_Control_Granularity has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) granularity().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "granularity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          granularity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Flow_Control_Granularity: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Flow__Control__Granularity_template* precondition = new Flow__Control__Granularity_template;
    precondition->set_param(*param.get_elem(0));
    Flow__Control__Granularity_template* implied_template = new Flow__Control__Granularity_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Flow__Control__Granularity_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSGP_Types.Flow_Control_Granularity");
  }
  is_ifpresent = param.get_ifpresent();
}

void Flow__Control__Granularity_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Flow_Control_Granularity");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Flow_Control_Granularity");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Flow_Control_Granularity");
single_value->field_granularity.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Flow_Control_Granularity");
single_value->field_reserved.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Flow_Control_Granularity");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSGP_Types.Flow_Control_Granularity");
}

boolean Flow__Control__Granularity_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Flow__Control__Granularity_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ENB__Identifier::ENB__Identifier()
{
}

ENB__Identifier::ENB__Identifier(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a& par_lengthIndicator,
    const HEXSTRING& par_mccDigit1,
    const HEXSTRING& par_mccDigit2,
    const HEXSTRING& par_mccDigit3,
    const HEXSTRING& par_mncDigit3,
    const HEXSTRING& par_mncDigit1,
    const HEXSTRING& par_mncDigit2,
    const OCTETSTRING& par_tac,
    const OCTETSTRING& par_globalEnbID)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_mccDigit1(par_mccDigit1),
  field_mccDigit2(par_mccDigit2),
  field_mccDigit3(par_mccDigit3),
  field_mncDigit3(par_mncDigit3),
  field_mncDigit1(par_mncDigit1),
  field_mncDigit2(par_mncDigit2),
  field_tac(par_tac),
  field_globalEnbID(par_globalEnbID)
{
}

ENB__Identifier::ENB__Identifier(const ENB__Identifier& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSGP_Types.ENB_Identifier.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.mccDigit1().is_bound()) field_mccDigit1 = other_value.mccDigit1();
else field_mccDigit1.clean_up();
if (other_value.mccDigit2().is_bound()) field_mccDigit2 = other_value.mccDigit2();
else field_mccDigit2.clean_up();
if (other_value.mccDigit3().is_bound()) field_mccDigit3 = other_value.mccDigit3();
else field_mccDigit3.clean_up();
if (other_value.mncDigit3().is_bound()) field_mncDigit3 = other_value.mncDigit3();
else field_mncDigit3.clean_up();
if (other_value.mncDigit1().is_bound()) field_mncDigit1 = other_value.mncDigit1();
else field_mncDigit1.clean_up();
if (other_value.mncDigit2().is_bound()) field_mncDigit2 = other_value.mncDigit2();
else field_mncDigit2.clean_up();
if (other_value.tac().is_bound()) field_tac = other_value.tac();
else field_tac.clean_up();
if (other_value.globalEnbID().is_bound()) field_globalEnbID = other_value.globalEnbID();
else field_globalEnbID.clean_up();
}

void ENB__Identifier::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_mccDigit1.clean_up();
field_mccDigit2.clean_up();
field_mccDigit3.clean_up();
field_mncDigit3.clean_up();
field_mncDigit1.clean_up();
field_mncDigit2.clean_up();
field_tac.clean_up();
field_globalEnbID.clean_up();
}

const TTCN_Typedescriptor_t* ENB__Identifier::get_descriptor() const { return &ENB__Identifier_descr_; }
ENB__Identifier& ENB__Identifier::operator=(const ENB__Identifier& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSGP_Types.ENB_Identifier.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.mccDigit1().is_bound()) field_mccDigit1 = other_value.mccDigit1();
  else field_mccDigit1.clean_up();
  if (other_value.mccDigit2().is_bound()) field_mccDigit2 = other_value.mccDigit2();
  else field_mccDigit2.clean_up();
  if (other_value.mccDigit3().is_bound()) field_mccDigit3 = other_value.mccDigit3();
  else field_mccDigit3.clean_up();
  if (other_value.mncDigit3().is_bound()) field_mncDigit3 = other_value.mncDigit3();
  else field_mncDigit3.clean_up();
  if (other_value.mncDigit1().is_bound()) field_mncDigit1 = other_value.mncDigit1();
  else field_mncDigit1.clean_up();
  if (other_value.mncDigit2().is_bound()) field_mncDigit2 = other_value.mncDigit2();
  else field_mncDigit2.clean_up();
  if (other_value.tac().is_bound()) field_tac = other_value.tac();
  else field_tac.clean_up();
  if (other_value.globalEnbID().is_bound()) field_globalEnbID = other_value.globalEnbID();
  else field_globalEnbID.clean_up();
}
return *this;
}

boolean ENB__Identifier::operator==(const ENB__Identifier& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_mccDigit1==other_value.field_mccDigit1
  && field_mccDigit2==other_value.field_mccDigit2
  && field_mccDigit3==other_value.field_mccDigit3
  && field_mncDigit3==other_value.field_mncDigit3
  && field_mncDigit1==other_value.field_mncDigit1
  && field_mncDigit2==other_value.field_mncDigit2
  && field_tac==other_value.field_tac
  && field_globalEnbID==other_value.field_globalEnbID;
}

boolean ENB__Identifier::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_mccDigit1.is_bound())
  || (field_mccDigit2.is_bound())
  || (field_mccDigit3.is_bound())
  || (field_mncDigit3.is_bound())
  || (field_mncDigit1.is_bound())
  || (field_mncDigit2.is_bound())
  || (field_tac.is_bound())
  || (field_globalEnbID.is_bound());
}
boolean ENB__Identifier::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_mccDigit1.is_value()
  && field_mccDigit2.is_value()
  && field_mccDigit3.is_value()
  && field_mncDigit3.is_value()
  && field_mncDigit1.is_value()
  && field_mncDigit2.is_value()
  && field_tac.is_value()
  && field_globalEnbID.is_value();
}
void ENB__Identifier::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", mccDigit1 := ");
field_mccDigit1.log();
TTCN_Logger::log_event_str(", mccDigit2 := ");
field_mccDigit2.log();
TTCN_Logger::log_event_str(", mccDigit3 := ");
field_mccDigit3.log();
TTCN_Logger::log_event_str(", mncDigit3 := ");
field_mncDigit3.log();
TTCN_Logger::log_event_str(", mncDigit1 := ");
field_mncDigit1.log();
TTCN_Logger::log_event_str(", mncDigit2 := ");
field_mncDigit2.log();
TTCN_Logger::log_event_str(", tac := ");
field_tac.log();
TTCN_Logger::log_event_str(", globalEnbID := ");
field_globalEnbID.log();
TTCN_Logger::log_event_str(" }");
}

void ENB__Identifier::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (mccDigit1().is_bound()) mccDigit1().set_implicit_omit();
if (mccDigit2().is_bound()) mccDigit2().set_implicit_omit();
if (mccDigit3().is_bound()) mccDigit3().set_implicit_omit();
if (mncDigit3().is_bound()) mncDigit3().set_implicit_omit();
if (mncDigit1().is_bound()) mncDigit1().set_implicit_omit();
if (mncDigit2().is_bound()) mncDigit2().set_implicit_omit();
if (tac().is_bound()) tac().set_implicit_omit();
if (globalEnbID().is_bound()) globalEnbID().set_implicit_omit();
}

void ENB__Identifier::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (11<param.get_size()) {
      param.error("record value of type @BSSGP_Types.ENB_Identifier has 11 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) mccDigit1().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) mccDigit2().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) mccDigit3().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) mncDigit3().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) mncDigit1().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) mncDigit2().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) tac().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) globalEnbID().set_param(*param.get_elem(10));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mccDigit1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mccDigit1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mccDigit2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mccDigit2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mccDigit3")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mccDigit3().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mncDigit3")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mncDigit3().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mncDigit1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mncDigit1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mncDigit2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mncDigit2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tac")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tac().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "globalEnbID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          globalEnbID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.ENB_Identifier: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSGP_Types.ENB_Identifier");
  }
}

void ENB__Identifier::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_mccDigit1.encode_text(text_buf);
field_mccDigit2.encode_text(text_buf);
field_mccDigit3.encode_text(text_buf);
field_mncDigit3.encode_text(text_buf);
field_mncDigit1.encode_text(text_buf);
field_mncDigit2.encode_text(text_buf);
field_tac.encode_text(text_buf);
field_globalEnbID.encode_text(text_buf);
}

void ENB__Identifier::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_mccDigit1.decode_text(text_buf);
field_mccDigit2.decode_text(text_buf);
field_mccDigit3.decode_text(text_buf);
field_mncDigit3.decode_text(text_buf);
field_mncDigit1.decode_text(text_buf);
field_mncDigit2.decode_text(text_buf);
field_tac.decode_text(text_buf);
field_globalEnbID.decode_text(text_buf);
}

void ENB__Identifier::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ENB__Identifier::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int ENB__Identifier::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, ENB__Identifier_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(ENB__Identifier_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_0) selected_field = 0;
  else if (field_ext ==  bs_1) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, ENB__Identifier_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(ENB__Identifier_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::HEX1_descr_.raw->forceomit);
  decoded_field_length = field_mccDigit1.RAW_decode(General__Types::HEX1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::HEX1_descr_.raw->forceomit);
  decoded_field_length = field_mccDigit2.RAW_decode(General__Types::HEX1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_5_force_omit(5, force_omit, General__Types::HEX1_descr_.raw->forceomit);
  decoded_field_length = field_mccDigit3.RAW_decode(General__Types::HEX1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_6_force_omit(6, force_omit, General__Types::HEX1_descr_.raw->forceomit);
  decoded_field_length = field_mncDigit3.RAW_decode(General__Types::HEX1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_7_force_omit(7, force_omit, General__Types::HEX1_descr_.raw->forceomit);
  decoded_field_length = field_mncDigit1.RAW_decode(General__Types::HEX1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_8_force_omit(8, force_omit, General__Types::HEX1_descr_.raw->forceomit);
  decoded_field_length = field_mncDigit2.RAW_decode(General__Types::HEX1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_9_force_omit(9, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_tac.RAW_decode(General__Types::OCT2_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_9_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_10_force_omit(10, force_omit, General__Types::OCTN_descr_.raw->forceomit);
  decoded_field_length = field_globalEnbID.RAW_decode(General__Types::OCTN_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_10_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  if (field_iEI !=  os_96) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int ENB__Identifier::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 11;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(11);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, ENB__Identifier_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, ENB__Identifier_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::HEX1_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::HEX1_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, General__Types::HEX1_descr_.raw);
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, General__Types::HEX1_descr_.raw);
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, General__Types::HEX1_descr_.raw);
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, General__Types::HEX1_descr_.raw);
  myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 9, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[10] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 10, General__Types::OCTN_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(ENB__Identifier_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(ENB__Identifier_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_mccDigit1.RAW_encode(General__Types::HEX1_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_mccDigit2.RAW_encode(General__Types::HEX1_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_mccDigit3.RAW_encode(General__Types::HEX1_descr_, *myleaf.body.node.nodes[5]);
  encoded_length += field_mncDigit3.RAW_encode(General__Types::HEX1_descr_, *myleaf.body.node.nodes[6]);
  encoded_length += field_mncDigit1.RAW_encode(General__Types::HEX1_descr_, *myleaf.body.node.nodes[7]);
  encoded_length += field_mncDigit2.RAW_encode(General__Types::HEX1_descr_, *myleaf.body.node.nodes[8]);
  encoded_length += field_tac.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[9]);
  encoded_length += field_globalEnbID.RAW_encode(General__Types::OCTN_descr_, *myleaf.body.node.nodes[10]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(8);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[6]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[6]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[4].level = myleaf.body.node.nodes[7]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[4].pos = myleaf.body.node.nodes[7]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[5].level = myleaf.body.node.nodes[8]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[5].pos = myleaf.body.node.nodes[8]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[6].level = myleaf.body.node.nodes[9]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[6].pos = myleaf.body.node.nodes[9]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[7].level = myleaf.body.node.nodes[10]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[7].pos = myleaf.body.node.nodes[10]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1:
  if (field_ext !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(ENB__Identifier_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a::ALT_length2:
  if (field_ext !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(ENB__Identifier_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_iEI !=  os_96) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_96.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct ENB__Identifier_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a_template field_lengthIndicator;
HEXSTRING_template field_mccDigit1;
HEXSTRING_template field_mccDigit2;
HEXSTRING_template field_mccDigit3;
HEXSTRING_template field_mncDigit3;
HEXSTRING_template field_mncDigit1;
HEXSTRING_template field_mncDigit2;
OCTETSTRING_template field_tac;
OCTETSTRING_template field_globalEnbID;
};

void ENB__Identifier_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_mccDigit1 = ANY_VALUE;
single_value->field_mccDigit2 = ANY_VALUE;
single_value->field_mccDigit3 = ANY_VALUE;
single_value->field_mncDigit3 = ANY_VALUE;
single_value->field_mncDigit1 = ANY_VALUE;
single_value->field_mncDigit2 = ANY_VALUE;
single_value->field_tac = ANY_VALUE;
single_value->field_globalEnbID = ANY_VALUE;
}
}
}

void ENB__Identifier_template::copy_value(const ENB__Identifier& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.mccDigit1().is_bound()) {
  single_value->field_mccDigit1 = other_value.mccDigit1();
} else {
  single_value->field_mccDigit1.clean_up();
}
if (other_value.mccDigit2().is_bound()) {
  single_value->field_mccDigit2 = other_value.mccDigit2();
} else {
  single_value->field_mccDigit2.clean_up();
}
if (other_value.mccDigit3().is_bound()) {
  single_value->field_mccDigit3 = other_value.mccDigit3();
} else {
  single_value->field_mccDigit3.clean_up();
}
if (other_value.mncDigit3().is_bound()) {
  single_value->field_mncDigit3 = other_value.mncDigit3();
} else {
  single_value->field_mncDigit3.clean_up();
}
if (other_value.mncDigit1().is_bound()) {
  single_value->field_mncDigit1 = other_value.mncDigit1();
} else {
  single_value->field_mncDigit1.clean_up();
}
if (other_value.mncDigit2().is_bound()) {
  single_value->field_mncDigit2 = other_value.mncDigit2();
} else {
  single_value->field_mncDigit2.clean_up();
}
if (other_value.tac().is_bound()) {
  single_value->field_tac = other_value.tac();
} else {
  single_value->field_tac.clean_up();
}
if (other_value.globalEnbID().is_bound()) {
  single_value->field_globalEnbID = other_value.globalEnbID();
} else {
  single_value->field_globalEnbID.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ENB__Identifier_template::copy_template(const ENB__Identifier_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mccDigit1().get_selection()) {
single_value->field_mccDigit1 = other_value.mccDigit1();
} else {
single_value->field_mccDigit1.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mccDigit2().get_selection()) {
single_value->field_mccDigit2 = other_value.mccDigit2();
} else {
single_value->field_mccDigit2.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mccDigit3().get_selection()) {
single_value->field_mccDigit3 = other_value.mccDigit3();
} else {
single_value->field_mccDigit3.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mncDigit3().get_selection()) {
single_value->field_mncDigit3 = other_value.mncDigit3();
} else {
single_value->field_mncDigit3.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mncDigit1().get_selection()) {
single_value->field_mncDigit1 = other_value.mncDigit1();
} else {
single_value->field_mncDigit1.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mncDigit2().get_selection()) {
single_value->field_mncDigit2 = other_value.mncDigit2();
} else {
single_value->field_mncDigit2.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tac().get_selection()) {
single_value->field_tac = other_value.tac();
} else {
single_value->field_tac.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.globalEnbID().get_selection()) {
single_value->field_globalEnbID = other_value.globalEnbID();
} else {
single_value->field_globalEnbID.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ENB__Identifier_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ENB__Identifier_template(*other_value.implication_.precondition);
implication_.implied_template = new ENB__Identifier_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSGP_Types.ENB_Identifier.");
break;
}
set_selection(other_value);
}

ENB__Identifier_template::ENB__Identifier_template()
{
}

ENB__Identifier_template::ENB__Identifier_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ENB__Identifier_template::ENB__Identifier_template(const ENB__Identifier& other_value)
{
copy_value(other_value);
}

ENB__Identifier_template::ENB__Identifier_template(const OPTIONAL<ENB__Identifier>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ENB__Identifier&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSGP_Types.ENB_Identifier from an unbound optional field.");
}
}

ENB__Identifier_template::ENB__Identifier_template(ENB__Identifier_template* p_precondition, ENB__Identifier_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ENB__Identifier_template::ENB__Identifier_template(Dynamic_Match_Interface<ENB__Identifier>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ENB__Identifier>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ENB__Identifier_template::ENB__Identifier_template(const ENB__Identifier_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ENB__Identifier_template::~ENB__Identifier_template()
{
clean_up();
}

ENB__Identifier_template& ENB__Identifier_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ENB__Identifier_template& ENB__Identifier_template::operator=(const ENB__Identifier& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ENB__Identifier_template& ENB__Identifier_template::operator=(const OPTIONAL<ENB__Identifier>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ENB__Identifier&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSGP_Types.ENB_Identifier.");
}
return *this;
}

ENB__Identifier_template& ENB__Identifier_template::operator=(const ENB__Identifier_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ENB__Identifier_template::match(const ENB__Identifier& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.mccDigit1().is_bound()) return FALSE;
if(!single_value->field_mccDigit1.match(other_value.mccDigit1(), legacy))return FALSE;
if(!other_value.mccDigit2().is_bound()) return FALSE;
if(!single_value->field_mccDigit2.match(other_value.mccDigit2(), legacy))return FALSE;
if(!other_value.mccDigit3().is_bound()) return FALSE;
if(!single_value->field_mccDigit3.match(other_value.mccDigit3(), legacy))return FALSE;
if(!other_value.mncDigit3().is_bound()) return FALSE;
if(!single_value->field_mncDigit3.match(other_value.mncDigit3(), legacy))return FALSE;
if(!other_value.mncDigit1().is_bound()) return FALSE;
if(!single_value->field_mncDigit1.match(other_value.mncDigit1(), legacy))return FALSE;
if(!other_value.mncDigit2().is_bound()) return FALSE;
if(!single_value->field_mncDigit2.match(other_value.mncDigit2(), legacy))return FALSE;
if(!other_value.tac().is_bound()) return FALSE;
if(!single_value->field_tac.match(other_value.tac(), legacy))return FALSE;
if(!other_value.globalEnbID().is_bound()) return FALSE;
if(!single_value->field_globalEnbID.match(other_value.globalEnbID(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSGP_Types.ENB_Identifier.");
}
return FALSE;
}

boolean ENB__Identifier_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_mccDigit1.is_bound()
 || single_value->field_mccDigit2.is_bound()
 || single_value->field_mccDigit3.is_bound()
 || single_value->field_mncDigit3.is_bound()
 || single_value->field_mncDigit1.is_bound()
 || single_value->field_mncDigit2.is_bound()
 || single_value->field_tac.is_bound()
 || single_value->field_globalEnbID.is_bound();
}

boolean ENB__Identifier_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_mccDigit1.is_value()
 && single_value->field_mccDigit2.is_value()
 && single_value->field_mccDigit3.is_value()
 && single_value->field_mncDigit3.is_value()
 && single_value->field_mncDigit1.is_value()
 && single_value->field_mncDigit2.is_value()
 && single_value->field_tac.is_value()
 && single_value->field_globalEnbID.is_value();
}

void ENB__Identifier_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ENB__Identifier ENB__Identifier_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSGP_Types.ENB_Identifier.");
ENB__Identifier ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_mccDigit1.is_bound()) {
ret_val.mccDigit1() = single_value->field_mccDigit1.valueof();
}
if (single_value->field_mccDigit2.is_bound()) {
ret_val.mccDigit2() = single_value->field_mccDigit2.valueof();
}
if (single_value->field_mccDigit3.is_bound()) {
ret_val.mccDigit3() = single_value->field_mccDigit3.valueof();
}
if (single_value->field_mncDigit3.is_bound()) {
ret_val.mncDigit3() = single_value->field_mncDigit3.valueof();
}
if (single_value->field_mncDigit1.is_bound()) {
ret_val.mncDigit1() = single_value->field_mncDigit1.valueof();
}
if (single_value->field_mncDigit2.is_bound()) {
ret_val.mncDigit2() = single_value->field_mncDigit2.valueof();
}
if (single_value->field_tac.is_bound()) {
ret_val.tac() = single_value->field_tac.valueof();
}
if (single_value->field_globalEnbID.is_bound()) {
ret_val.globalEnbID() = single_value->field_globalEnbID.valueof();
}
return ret_val;
}

void ENB__Identifier_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSGP_Types.ENB_Identifier.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ENB__Identifier_template[list_length];
}

ENB__Identifier_template& ENB__Identifier_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSGP_Types.ENB_Identifier.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSGP_Types.ENB_Identifier.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& ENB__Identifier_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& ENB__Identifier_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @BSSGP_Types.ENB_Identifier.");
return single_value->field_iEI;
}

BITSTRING_template& ENB__Identifier_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& ENB__Identifier_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @BSSGP_Types.ENB_Identifier.");
return single_value->field_ext;
}

LIN2__2a_template& ENB__Identifier_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a_template& ENB__Identifier_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSGP_Types.ENB_Identifier.");
return single_value->field_lengthIndicator;
}

HEXSTRING_template& ENB__Identifier_template::mccDigit1()
{
set_specific();
return single_value->field_mccDigit1;
}

const HEXSTRING_template& ENB__Identifier_template::mccDigit1() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mccDigit1 of a non-specific template of type @BSSGP_Types.ENB_Identifier.");
return single_value->field_mccDigit1;
}

HEXSTRING_template& ENB__Identifier_template::mccDigit2()
{
set_specific();
return single_value->field_mccDigit2;
}

const HEXSTRING_template& ENB__Identifier_template::mccDigit2() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mccDigit2 of a non-specific template of type @BSSGP_Types.ENB_Identifier.");
return single_value->field_mccDigit2;
}

HEXSTRING_template& ENB__Identifier_template::mccDigit3()
{
set_specific();
return single_value->field_mccDigit3;
}

const HEXSTRING_template& ENB__Identifier_template::mccDigit3() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mccDigit3 of a non-specific template of type @BSSGP_Types.ENB_Identifier.");
return single_value->field_mccDigit3;
}

HEXSTRING_template& ENB__Identifier_template::mncDigit3()
{
set_specific();
return single_value->field_mncDigit3;
}

const HEXSTRING_template& ENB__Identifier_template::mncDigit3() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mncDigit3 of a non-specific template of type @BSSGP_Types.ENB_Identifier.");
return single_value->field_mncDigit3;
}

HEXSTRING_template& ENB__Identifier_template::mncDigit1()
{
set_specific();
return single_value->field_mncDigit1;
}

const HEXSTRING_template& ENB__Identifier_template::mncDigit1() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mncDigit1 of a non-specific template of type @BSSGP_Types.ENB_Identifier.");
return single_value->field_mncDigit1;
}

HEXSTRING_template& ENB__Identifier_template::mncDigit2()
{
set_specific();
return single_value->field_mncDigit2;
}

const HEXSTRING_template& ENB__Identifier_template::mncDigit2() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mncDigit2 of a non-specific template of type @BSSGP_Types.ENB_Identifier.");
return single_value->field_mncDigit2;
}

OCTETSTRING_template& ENB__Identifier_template::tac()
{
set_specific();
return single_value->field_tac;
}

const OCTETSTRING_template& ENB__Identifier_template::tac() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tac of a non-specific template of type @BSSGP_Types.ENB_Identifier.");
return single_value->field_tac;
}

OCTETSTRING_template& ENB__Identifier_template::globalEnbID()
{
set_specific();
return single_value->field_globalEnbID;
}

const OCTETSTRING_template& ENB__Identifier_template::globalEnbID() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field globalEnbID of a non-specific template of type @BSSGP_Types.ENB_Identifier.");
return single_value->field_globalEnbID;
}

int ENB__Identifier_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.ENB_Identifier which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 11;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSGP_Types.ENB_Identifier containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.ENB_Identifier containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.ENB_Identifier containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.ENB_Identifier containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.ENB_Identifier containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.ENB_Identifier containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.ENB_Identifier containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.ENB_Identifier containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSGP_Types.ENB_Identifier.");
  }
  return 0;
}

void ENB__Identifier_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", mccDigit1 := ");
single_value->field_mccDigit1.log();
TTCN_Logger::log_event_str(", mccDigit2 := ");
single_value->field_mccDigit2.log();
TTCN_Logger::log_event_str(", mccDigit3 := ");
single_value->field_mccDigit3.log();
TTCN_Logger::log_event_str(", mncDigit3 := ");
single_value->field_mncDigit3.log();
TTCN_Logger::log_event_str(", mncDigit1 := ");
single_value->field_mncDigit1.log();
TTCN_Logger::log_event_str(", mncDigit2 := ");
single_value->field_mncDigit2.log();
TTCN_Logger::log_event_str(", tac := ");
single_value->field_tac.log();
TTCN_Logger::log_event_str(", globalEnbID := ");
single_value->field_globalEnbID.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ENB__Identifier_template::log_match(const ENB__Identifier& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mccDigit1.match(match_value.mccDigit1(), legacy)){
TTCN_Logger::log_logmatch_info(".mccDigit1");
single_value->field_mccDigit1.log_match(match_value.mccDigit1(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mccDigit2.match(match_value.mccDigit2(), legacy)){
TTCN_Logger::log_logmatch_info(".mccDigit2");
single_value->field_mccDigit2.log_match(match_value.mccDigit2(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mccDigit3.match(match_value.mccDigit3(), legacy)){
TTCN_Logger::log_logmatch_info(".mccDigit3");
single_value->field_mccDigit3.log_match(match_value.mccDigit3(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mncDigit3.match(match_value.mncDigit3(), legacy)){
TTCN_Logger::log_logmatch_info(".mncDigit3");
single_value->field_mncDigit3.log_match(match_value.mncDigit3(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mncDigit1.match(match_value.mncDigit1(), legacy)){
TTCN_Logger::log_logmatch_info(".mncDigit1");
single_value->field_mncDigit1.log_match(match_value.mncDigit1(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mncDigit2.match(match_value.mncDigit2(), legacy)){
TTCN_Logger::log_logmatch_info(".mncDigit2");
single_value->field_mncDigit2.log_match(match_value.mncDigit2(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_tac.match(match_value.tac(), legacy)){
TTCN_Logger::log_logmatch_info(".tac");
single_value->field_tac.log_match(match_value.tac(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_globalEnbID.match(match_value.globalEnbID(), legacy)){
TTCN_Logger::log_logmatch_info(".globalEnbID");
single_value->field_globalEnbID.log_match(match_value.globalEnbID(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", mccDigit1 := ");
single_value->field_mccDigit1.log_match(match_value.mccDigit1(), legacy);
TTCN_Logger::log_event_str(", mccDigit2 := ");
single_value->field_mccDigit2.log_match(match_value.mccDigit2(), legacy);
TTCN_Logger::log_event_str(", mccDigit3 := ");
single_value->field_mccDigit3.log_match(match_value.mccDigit3(), legacy);
TTCN_Logger::log_event_str(", mncDigit3 := ");
single_value->field_mncDigit3.log_match(match_value.mncDigit3(), legacy);
TTCN_Logger::log_event_str(", mncDigit1 := ");
single_value->field_mncDigit1.log_match(match_value.mncDigit1(), legacy);
TTCN_Logger::log_event_str(", mncDigit2 := ");
single_value->field_mncDigit2.log_match(match_value.mncDigit2(), legacy);
TTCN_Logger::log_event_str(", tac := ");
single_value->field_tac.log_match(match_value.tac(), legacy);
TTCN_Logger::log_event_str(", globalEnbID := ");
single_value->field_globalEnbID.log_match(match_value.globalEnbID(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ENB__Identifier_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_mccDigit1.encode_text(text_buf);
single_value->field_mccDigit2.encode_text(text_buf);
single_value->field_mccDigit3.encode_text(text_buf);
single_value->field_mncDigit3.encode_text(text_buf);
single_value->field_mncDigit1.encode_text(text_buf);
single_value->field_mncDigit2.encode_text(text_buf);
single_value->field_tac.encode_text(text_buf);
single_value->field_globalEnbID.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSGP_Types.ENB_Identifier.");
}
}

void ENB__Identifier_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_mccDigit1.decode_text(text_buf);
single_value->field_mccDigit2.decode_text(text_buf);
single_value->field_mccDigit3.decode_text(text_buf);
single_value->field_mncDigit3.decode_text(text_buf);
single_value->field_mncDigit1.decode_text(text_buf);
single_value->field_mncDigit2.decode_text(text_buf);
single_value->field_tac.decode_text(text_buf);
single_value->field_globalEnbID.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ENB__Identifier_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSGP_Types.ENB_Identifier.");
}
}

void ENB__Identifier_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ENB__Identifier_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (11<param.get_size()) {
      param.error("record template of type @BSSGP_Types.ENB_Identifier has 11 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) mccDigit1().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) mccDigit2().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) mccDigit3().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) mncDigit3().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) mncDigit1().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) mncDigit2().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) tac().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) globalEnbID().set_param(*param.get_elem(10));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mccDigit1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mccDigit1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mccDigit2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mccDigit2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mccDigit3")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mccDigit3().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mncDigit3")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mncDigit3().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mncDigit1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mncDigit1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mncDigit2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mncDigit2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tac")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tac().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "globalEnbID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          globalEnbID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.ENB_Identifier: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ENB__Identifier_template* precondition = new ENB__Identifier_template;
    precondition->set_param(*param.get_elem(0));
    ENB__Identifier_template* implied_template = new ENB__Identifier_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ENB__Identifier_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSGP_Types.ENB_Identifier");
  }
  is_ifpresent = param.get_ifpresent();
}

void ENB__Identifier_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.ENB_Identifier");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.ENB_Identifier");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.ENB_Identifier");
single_value->field_mccDigit1.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.ENB_Identifier");
single_value->field_mccDigit2.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.ENB_Identifier");
single_value->field_mccDigit3.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.ENB_Identifier");
single_value->field_mncDigit3.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.ENB_Identifier");
single_value->field_mncDigit1.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.ENB_Identifier");
single_value->field_mncDigit2.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.ENB_Identifier");
single_value->field_tac.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.ENB_Identifier");
single_value->field_globalEnbID.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.ENB_Identifier");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSGP_Types.ENB_Identifier");
}

boolean ENB__Identifier_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ENB__Identifier_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Subscriber__Profile__ID__For__RAT__Priority::Subscriber__Profile__ID__For__RAT__Priority()
{
}

Subscriber__Profile__ID__For__RAT__Priority::Subscriber__Profile__ID__For__RAT__Priority(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a& par_lengthIndicator,
    const BITSTRING& par_profile__ID)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_profile__ID(par_profile__ID)
{
}

Subscriber__Profile__ID__For__RAT__Priority::Subscriber__Profile__ID__For__RAT__Priority(const Subscriber__Profile__ID__For__RAT__Priority& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.profile__ID().is_bound()) field_profile__ID = other_value.profile__ID();
else field_profile__ID.clean_up();
}

void Subscriber__Profile__ID__For__RAT__Priority::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_profile__ID.clean_up();
}

const TTCN_Typedescriptor_t* Subscriber__Profile__ID__For__RAT__Priority::get_descriptor() const { return &Subscriber__Profile__ID__For__RAT__Priority_descr_; }
Subscriber__Profile__ID__For__RAT__Priority& Subscriber__Profile__ID__For__RAT__Priority::operator=(const Subscriber__Profile__ID__For__RAT__Priority& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.profile__ID().is_bound()) field_profile__ID = other_value.profile__ID();
  else field_profile__ID.clean_up();
}
return *this;
}

boolean Subscriber__Profile__ID__For__RAT__Priority::operator==(const Subscriber__Profile__ID__For__RAT__Priority& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_profile__ID==other_value.field_profile__ID;
}

boolean Subscriber__Profile__ID__For__RAT__Priority::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_profile__ID.is_bound());
}
boolean Subscriber__Profile__ID__For__RAT__Priority::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_profile__ID.is_value();
}
void Subscriber__Profile__ID__For__RAT__Priority::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", profile_ID := ");
field_profile__ID.log();
TTCN_Logger::log_event_str(" }");
}

void Subscriber__Profile__ID__For__RAT__Priority::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (profile__ID().is_bound()) profile__ID().set_implicit_omit();
}

void Subscriber__Profile__ID__For__RAT__Priority::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) profile__ID().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "profile_ID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          profile__ID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority");
  }
}

void Subscriber__Profile__ID__For__RAT__Priority::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_profile__ID.encode_text(text_buf);
}

void Subscriber__Profile__ID__For__RAT__Priority::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_profile__ID.decode_text(text_buf);
}

void Subscriber__Profile__ID__For__RAT__Priority::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Subscriber__Profile__ID__For__RAT__Priority::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Subscriber__Profile__ID__For__RAT__Priority::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, Subscriber__Profile__ID__For__RAT__Priority_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(Subscriber__Profile__ID__For__RAT__Priority_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_0) selected_field = 0;
  else if (field_ext ==  bs_1) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, Subscriber__Profile__ID__For__RAT__Priority_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(Subscriber__Profile__ID__For__RAT__Priority_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT8_descr_.raw->forceomit);
  decoded_field_length = field_profile__ID.RAW_decode(General__Types::BIT8_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  if (field_iEI !=  os_10) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int Subscriber__Profile__ID__For__RAT__Priority::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Subscriber__Profile__ID__For__RAT__Priority_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Subscriber__Profile__ID__For__RAT__Priority_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT8_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(Subscriber__Profile__ID__For__RAT__Priority_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(Subscriber__Profile__ID__For__RAT__Priority_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_profile__ID.RAW_encode(General__Types::BIT8_descr_, *myleaf.body.node.nodes[3]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1:
  if (field_ext !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(Subscriber__Profile__ID__For__RAT__Priority_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a::ALT_length2:
  if (field_ext !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(Subscriber__Profile__ID__For__RAT__Priority_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_iEI !=  os_10) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_10.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct Subscriber__Profile__ID__For__RAT__Priority_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a_template field_lengthIndicator;
BITSTRING_template field_profile__ID;
};

void Subscriber__Profile__ID__For__RAT__Priority_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_profile__ID = ANY_VALUE;
}
}
}

void Subscriber__Profile__ID__For__RAT__Priority_template::copy_value(const Subscriber__Profile__ID__For__RAT__Priority& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.profile__ID().is_bound()) {
  single_value->field_profile__ID = other_value.profile__ID();
} else {
  single_value->field_profile__ID.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Subscriber__Profile__ID__For__RAT__Priority_template::copy_template(const Subscriber__Profile__ID__For__RAT__Priority_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.profile__ID().get_selection()) {
single_value->field_profile__ID = other_value.profile__ID();
} else {
single_value->field_profile__ID.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Subscriber__Profile__ID__For__RAT__Priority_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Subscriber__Profile__ID__For__RAT__Priority_template(*other_value.implication_.precondition);
implication_.implied_template = new Subscriber__Profile__ID__For__RAT__Priority_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority.");
break;
}
set_selection(other_value);
}

Subscriber__Profile__ID__For__RAT__Priority_template::Subscriber__Profile__ID__For__RAT__Priority_template()
{
}

Subscriber__Profile__ID__For__RAT__Priority_template::Subscriber__Profile__ID__For__RAT__Priority_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Subscriber__Profile__ID__For__RAT__Priority_template::Subscriber__Profile__ID__For__RAT__Priority_template(const Subscriber__Profile__ID__For__RAT__Priority& other_value)
{
copy_value(other_value);
}

Subscriber__Profile__ID__For__RAT__Priority_template::Subscriber__Profile__ID__For__RAT__Priority_template(const OPTIONAL<Subscriber__Profile__ID__For__RAT__Priority>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Subscriber__Profile__ID__For__RAT__Priority&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority from an unbound optional field.");
}
}

Subscriber__Profile__ID__For__RAT__Priority_template::Subscriber__Profile__ID__For__RAT__Priority_template(Subscriber__Profile__ID__For__RAT__Priority_template* p_precondition, Subscriber__Profile__ID__For__RAT__Priority_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Subscriber__Profile__ID__For__RAT__Priority_template::Subscriber__Profile__ID__For__RAT__Priority_template(Dynamic_Match_Interface<Subscriber__Profile__ID__For__RAT__Priority>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Subscriber__Profile__ID__For__RAT__Priority>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Subscriber__Profile__ID__For__RAT__Priority_template::Subscriber__Profile__ID__For__RAT__Priority_template(const Subscriber__Profile__ID__For__RAT__Priority_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Subscriber__Profile__ID__For__RAT__Priority_template::~Subscriber__Profile__ID__For__RAT__Priority_template()
{
clean_up();
}

Subscriber__Profile__ID__For__RAT__Priority_template& Subscriber__Profile__ID__For__RAT__Priority_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Subscriber__Profile__ID__For__RAT__Priority_template& Subscriber__Profile__ID__For__RAT__Priority_template::operator=(const Subscriber__Profile__ID__For__RAT__Priority& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Subscriber__Profile__ID__For__RAT__Priority_template& Subscriber__Profile__ID__For__RAT__Priority_template::operator=(const OPTIONAL<Subscriber__Profile__ID__For__RAT__Priority>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Subscriber__Profile__ID__For__RAT__Priority&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority.");
}
return *this;
}

Subscriber__Profile__ID__For__RAT__Priority_template& Subscriber__Profile__ID__For__RAT__Priority_template::operator=(const Subscriber__Profile__ID__For__RAT__Priority_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Subscriber__Profile__ID__For__RAT__Priority_template::match(const Subscriber__Profile__ID__For__RAT__Priority& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.profile__ID().is_bound()) return FALSE;
if(!single_value->field_profile__ID.match(other_value.profile__ID(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority.");
}
return FALSE;
}

boolean Subscriber__Profile__ID__For__RAT__Priority_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_profile__ID.is_bound();
}

boolean Subscriber__Profile__ID__For__RAT__Priority_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_profile__ID.is_value();
}

void Subscriber__Profile__ID__For__RAT__Priority_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Subscriber__Profile__ID__For__RAT__Priority Subscriber__Profile__ID__For__RAT__Priority_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority.");
Subscriber__Profile__ID__For__RAT__Priority ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_profile__ID.is_bound()) {
ret_val.profile__ID() = single_value->field_profile__ID.valueof();
}
return ret_val;
}

void Subscriber__Profile__ID__For__RAT__Priority_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Subscriber__Profile__ID__For__RAT__Priority_template[list_length];
}

Subscriber__Profile__ID__For__RAT__Priority_template& Subscriber__Profile__ID__For__RAT__Priority_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& Subscriber__Profile__ID__For__RAT__Priority_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& Subscriber__Profile__ID__For__RAT__Priority_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority.");
return single_value->field_iEI;
}

BITSTRING_template& Subscriber__Profile__ID__For__RAT__Priority_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& Subscriber__Profile__ID__For__RAT__Priority_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority.");
return single_value->field_ext;
}

LIN2__2a_template& Subscriber__Profile__ID__For__RAT__Priority_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a_template& Subscriber__Profile__ID__For__RAT__Priority_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& Subscriber__Profile__ID__For__RAT__Priority_template::profile__ID()
{
set_specific();
return single_value->field_profile__ID;
}

const BITSTRING_template& Subscriber__Profile__ID__For__RAT__Priority_template::profile__ID() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field profile_ID of a non-specific template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority.");
return single_value->field_profile__ID;
}

int Subscriber__Profile__ID__For__RAT__Priority_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority.");
  }
  return 0;
}

void Subscriber__Profile__ID__For__RAT__Priority_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", profile_ID := ");
single_value->field_profile__ID.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Subscriber__Profile__ID__For__RAT__Priority_template::log_match(const Subscriber__Profile__ID__For__RAT__Priority& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_profile__ID.match(match_value.profile__ID(), legacy)){
TTCN_Logger::log_logmatch_info(".profile_ID");
single_value->field_profile__ID.log_match(match_value.profile__ID(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", profile_ID := ");
single_value->field_profile__ID.log_match(match_value.profile__ID(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Subscriber__Profile__ID__For__RAT__Priority_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_profile__ID.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority.");
}
}

void Subscriber__Profile__ID__For__RAT__Priority_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_profile__ID.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Subscriber__Profile__ID__For__RAT__Priority_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority.");
}
}

void Subscriber__Profile__ID__For__RAT__Priority_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Subscriber__Profile__ID__For__RAT__Priority_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) profile__ID().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "profile_ID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          profile__ID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Subscriber__Profile__ID__For__RAT__Priority_template* precondition = new Subscriber__Profile__ID__For__RAT__Priority_template;
    precondition->set_param(*param.get_elem(0));
    Subscriber__Profile__ID__For__RAT__Priority_template* implied_template = new Subscriber__Profile__ID__For__RAT__Priority_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Subscriber__Profile__ID__For__RAT__Priority_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority");
  }
  is_ifpresent = param.get_ifpresent();
}

void Subscriber__Profile__ID__For__RAT__Priority_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority");
single_value->field_profile__ID.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSGP_Types.Subscriber_Profile_ID_For_RAT_Priority");
}

boolean Subscriber__Profile__ID__For__RAT__Priority_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Subscriber__Profile__ID__For__RAT__Priority_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Request__For__Inter__RAT__Handover__Info::Request__For__Inter__RAT__Handover__Info()
{
}

Request__For__Inter__RAT__Handover__Info::Request__For__Inter__RAT__Handover__Info(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a& par_lengthIndicator,
    const BITSTRING& par_interRATHandoverInfoRequest,
    const BITSTRING& par_eUTRANinterRATHandoverInfoRequest,
    const BITSTRING& par_spare)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_interRATHandoverInfoRequest(par_interRATHandoverInfoRequest),
  field_eUTRANinterRATHandoverInfoRequest(par_eUTRANinterRATHandoverInfoRequest),
  field_spare(par_spare)
{
}

Request__For__Inter__RAT__Handover__Info::Request__For__Inter__RAT__Handover__Info(const Request__For__Inter__RAT__Handover__Info& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.interRATHandoverInfoRequest().is_bound()) field_interRATHandoverInfoRequest = other_value.interRATHandoverInfoRequest();
else field_interRATHandoverInfoRequest.clean_up();
if (other_value.eUTRANinterRATHandoverInfoRequest().is_bound()) field_eUTRANinterRATHandoverInfoRequest = other_value.eUTRANinterRATHandoverInfoRequest();
else field_eUTRANinterRATHandoverInfoRequest.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void Request__For__Inter__RAT__Handover__Info::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_interRATHandoverInfoRequest.clean_up();
field_eUTRANinterRATHandoverInfoRequest.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* Request__For__Inter__RAT__Handover__Info::get_descriptor() const { return &Request__For__Inter__RAT__Handover__Info_descr_; }
Request__For__Inter__RAT__Handover__Info& Request__For__Inter__RAT__Handover__Info::operator=(const Request__For__Inter__RAT__Handover__Info& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.interRATHandoverInfoRequest().is_bound()) field_interRATHandoverInfoRequest = other_value.interRATHandoverInfoRequest();
  else field_interRATHandoverInfoRequest.clean_up();
  if (other_value.eUTRANinterRATHandoverInfoRequest().is_bound()) field_eUTRANinterRATHandoverInfoRequest = other_value.eUTRANinterRATHandoverInfoRequest();
  else field_eUTRANinterRATHandoverInfoRequest.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean Request__For__Inter__RAT__Handover__Info::operator==(const Request__For__Inter__RAT__Handover__Info& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_interRATHandoverInfoRequest==other_value.field_interRATHandoverInfoRequest
  && field_eUTRANinterRATHandoverInfoRequest==other_value.field_eUTRANinterRATHandoverInfoRequest
  && field_spare==other_value.field_spare;
}

boolean Request__For__Inter__RAT__Handover__Info::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_interRATHandoverInfoRequest.is_bound())
  || (field_eUTRANinterRATHandoverInfoRequest.is_bound())
  || (field_spare.is_bound());
}
boolean Request__For__Inter__RAT__Handover__Info::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_interRATHandoverInfoRequest.is_value()
  && field_eUTRANinterRATHandoverInfoRequest.is_value()
  && field_spare.is_value();
}
void Request__For__Inter__RAT__Handover__Info::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", interRATHandoverInfoRequest := ");
field_interRATHandoverInfoRequest.log();
TTCN_Logger::log_event_str(", eUTRANinterRATHandoverInfoRequest := ");
field_eUTRANinterRATHandoverInfoRequest.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void Request__For__Inter__RAT__Handover__Info::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (interRATHandoverInfoRequest().is_bound()) interRATHandoverInfoRequest().set_implicit_omit();
if (eUTRANinterRATHandoverInfoRequest().is_bound()) eUTRANinterRATHandoverInfoRequest().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void Request__For__Inter__RAT__Handover__Info::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record value of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) interRATHandoverInfoRequest().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) eUTRANinterRATHandoverInfoRequest().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "interRATHandoverInfoRequest")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          interRATHandoverInfoRequest().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "eUTRANinterRATHandoverInfoRequest")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          eUTRANinterRATHandoverInfoRequest().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSGP_Types.Request_For_Inter_RAT_Handover_Info");
  }
}

void Request__For__Inter__RAT__Handover__Info::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_interRATHandoverInfoRequest.encode_text(text_buf);
field_eUTRANinterRATHandoverInfoRequest.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void Request__For__Inter__RAT__Handover__Info::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_interRATHandoverInfoRequest.decode_text(text_buf);
field_eUTRANinterRATHandoverInfoRequest.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void Request__For__Inter__RAT__Handover__Info::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Request__For__Inter__RAT__Handover__Info::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Request__For__Inter__RAT__Handover__Info::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, Request__For__Inter__RAT__Handover__Info_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(Request__For__Inter__RAT__Handover__Info_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_0) selected_field = 0;
  else if (field_ext ==  bs_1) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, Request__For__Inter__RAT__Handover__Info_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(Request__For__Inter__RAT__Handover__Info_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_interRATHandoverInfoRequest.RAW_decode(General__Types::BIT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_eUTRANinterRATHandoverInfoRequest.RAW_decode(General__Types::BIT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_5_force_omit(5, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT6_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  if (field_iEI !=  os_112) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int Request__For__Inter__RAT__Handover__Info::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 6;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(6);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Request__For__Inter__RAT__Handover__Info_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Request__For__Inter__RAT__Handover__Info_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, General__Types::BIT6_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(Request__For__Inter__RAT__Handover__Info_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(Request__For__Inter__RAT__Handover__Info_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_interRATHandoverInfoRequest.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_eUTRANinterRATHandoverInfoRequest.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[5]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1:
  if (field_ext !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(Request__For__Inter__RAT__Handover__Info_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a::ALT_length2:
  if (field_ext !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(Request__For__Inter__RAT__Handover__Info_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_iEI !=  os_112) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_112.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct Request__For__Inter__RAT__Handover__Info_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a_template field_lengthIndicator;
BITSTRING_template field_interRATHandoverInfoRequest;
BITSTRING_template field_eUTRANinterRATHandoverInfoRequest;
BITSTRING_template field_spare;
};

void Request__For__Inter__RAT__Handover__Info_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_interRATHandoverInfoRequest = ANY_VALUE;
single_value->field_eUTRANinterRATHandoverInfoRequest = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void Request__For__Inter__RAT__Handover__Info_template::copy_value(const Request__For__Inter__RAT__Handover__Info& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.interRATHandoverInfoRequest().is_bound()) {
  single_value->field_interRATHandoverInfoRequest = other_value.interRATHandoverInfoRequest();
} else {
  single_value->field_interRATHandoverInfoRequest.clean_up();
}
if (other_value.eUTRANinterRATHandoverInfoRequest().is_bound()) {
  single_value->field_eUTRANinterRATHandoverInfoRequest = other_value.eUTRANinterRATHandoverInfoRequest();
} else {
  single_value->field_eUTRANinterRATHandoverInfoRequest.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Request__For__Inter__RAT__Handover__Info_template::copy_template(const Request__For__Inter__RAT__Handover__Info_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.interRATHandoverInfoRequest().get_selection()) {
single_value->field_interRATHandoverInfoRequest = other_value.interRATHandoverInfoRequest();
} else {
single_value->field_interRATHandoverInfoRequest.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.eUTRANinterRATHandoverInfoRequest().get_selection()) {
single_value->field_eUTRANinterRATHandoverInfoRequest = other_value.eUTRANinterRATHandoverInfoRequest();
} else {
single_value->field_eUTRANinterRATHandoverInfoRequest.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Request__For__Inter__RAT__Handover__Info_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Request__For__Inter__RAT__Handover__Info_template(*other_value.implication_.precondition);
implication_.implied_template = new Request__For__Inter__RAT__Handover__Info_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info.");
break;
}
set_selection(other_value);
}

Request__For__Inter__RAT__Handover__Info_template::Request__For__Inter__RAT__Handover__Info_template()
{
}

Request__For__Inter__RAT__Handover__Info_template::Request__For__Inter__RAT__Handover__Info_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Request__For__Inter__RAT__Handover__Info_template::Request__For__Inter__RAT__Handover__Info_template(const Request__For__Inter__RAT__Handover__Info& other_value)
{
copy_value(other_value);
}

Request__For__Inter__RAT__Handover__Info_template::Request__For__Inter__RAT__Handover__Info_template(const OPTIONAL<Request__For__Inter__RAT__Handover__Info>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Request__For__Inter__RAT__Handover__Info&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info from an unbound optional field.");
}
}

Request__For__Inter__RAT__Handover__Info_template::Request__For__Inter__RAT__Handover__Info_template(Request__For__Inter__RAT__Handover__Info_template* p_precondition, Request__For__Inter__RAT__Handover__Info_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Request__For__Inter__RAT__Handover__Info_template::Request__For__Inter__RAT__Handover__Info_template(Dynamic_Match_Interface<Request__For__Inter__RAT__Handover__Info>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Request__For__Inter__RAT__Handover__Info>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Request__For__Inter__RAT__Handover__Info_template::Request__For__Inter__RAT__Handover__Info_template(const Request__For__Inter__RAT__Handover__Info_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Request__For__Inter__RAT__Handover__Info_template::~Request__For__Inter__RAT__Handover__Info_template()
{
clean_up();
}

Request__For__Inter__RAT__Handover__Info_template& Request__For__Inter__RAT__Handover__Info_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Request__For__Inter__RAT__Handover__Info_template& Request__For__Inter__RAT__Handover__Info_template::operator=(const Request__For__Inter__RAT__Handover__Info& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Request__For__Inter__RAT__Handover__Info_template& Request__For__Inter__RAT__Handover__Info_template::operator=(const OPTIONAL<Request__For__Inter__RAT__Handover__Info>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Request__For__Inter__RAT__Handover__Info&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info.");
}
return *this;
}

Request__For__Inter__RAT__Handover__Info_template& Request__For__Inter__RAT__Handover__Info_template::operator=(const Request__For__Inter__RAT__Handover__Info_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Request__For__Inter__RAT__Handover__Info_template::match(const Request__For__Inter__RAT__Handover__Info& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.interRATHandoverInfoRequest().is_bound()) return FALSE;
if(!single_value->field_interRATHandoverInfoRequest.match(other_value.interRATHandoverInfoRequest(), legacy))return FALSE;
if(!other_value.eUTRANinterRATHandoverInfoRequest().is_bound()) return FALSE;
if(!single_value->field_eUTRANinterRATHandoverInfoRequest.match(other_value.eUTRANinterRATHandoverInfoRequest(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info.");
}
return FALSE;
}

boolean Request__For__Inter__RAT__Handover__Info_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_interRATHandoverInfoRequest.is_bound()
 || single_value->field_eUTRANinterRATHandoverInfoRequest.is_bound()
 || single_value->field_spare.is_bound();
}

boolean Request__For__Inter__RAT__Handover__Info_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_interRATHandoverInfoRequest.is_value()
 && single_value->field_eUTRANinterRATHandoverInfoRequest.is_value()
 && single_value->field_spare.is_value();
}

void Request__For__Inter__RAT__Handover__Info_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Request__For__Inter__RAT__Handover__Info Request__For__Inter__RAT__Handover__Info_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info.");
Request__For__Inter__RAT__Handover__Info ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_interRATHandoverInfoRequest.is_bound()) {
ret_val.interRATHandoverInfoRequest() = single_value->field_interRATHandoverInfoRequest.valueof();
}
if (single_value->field_eUTRANinterRATHandoverInfoRequest.is_bound()) {
ret_val.eUTRANinterRATHandoverInfoRequest() = single_value->field_eUTRANinterRATHandoverInfoRequest.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void Request__For__Inter__RAT__Handover__Info_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Request__For__Inter__RAT__Handover__Info_template[list_length];
}

Request__For__Inter__RAT__Handover__Info_template& Request__For__Inter__RAT__Handover__Info_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& Request__For__Inter__RAT__Handover__Info_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& Request__For__Inter__RAT__Handover__Info_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info.");
return single_value->field_iEI;
}

BITSTRING_template& Request__For__Inter__RAT__Handover__Info_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& Request__For__Inter__RAT__Handover__Info_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info.");
return single_value->field_ext;
}

LIN2__2a_template& Request__For__Inter__RAT__Handover__Info_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a_template& Request__For__Inter__RAT__Handover__Info_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& Request__For__Inter__RAT__Handover__Info_template::interRATHandoverInfoRequest()
{
set_specific();
return single_value->field_interRATHandoverInfoRequest;
}

const BITSTRING_template& Request__For__Inter__RAT__Handover__Info_template::interRATHandoverInfoRequest() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field interRATHandoverInfoRequest of a non-specific template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info.");
return single_value->field_interRATHandoverInfoRequest;
}

BITSTRING_template& Request__For__Inter__RAT__Handover__Info_template::eUTRANinterRATHandoverInfoRequest()
{
set_specific();
return single_value->field_eUTRANinterRATHandoverInfoRequest;
}

const BITSTRING_template& Request__For__Inter__RAT__Handover__Info_template::eUTRANinterRATHandoverInfoRequest() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field eUTRANinterRATHandoverInfoRequest of a non-specific template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info.");
return single_value->field_eUTRANinterRATHandoverInfoRequest;
}

BITSTRING_template& Request__For__Inter__RAT__Handover__Info_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& Request__For__Inter__RAT__Handover__Info_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info.");
return single_value->field_spare;
}

int Request__For__Inter__RAT__Handover__Info_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 6;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info.");
  }
  return 0;
}

void Request__For__Inter__RAT__Handover__Info_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", interRATHandoverInfoRequest := ");
single_value->field_interRATHandoverInfoRequest.log();
TTCN_Logger::log_event_str(", eUTRANinterRATHandoverInfoRequest := ");
single_value->field_eUTRANinterRATHandoverInfoRequest.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Request__For__Inter__RAT__Handover__Info_template::log_match(const Request__For__Inter__RAT__Handover__Info& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_interRATHandoverInfoRequest.match(match_value.interRATHandoverInfoRequest(), legacy)){
TTCN_Logger::log_logmatch_info(".interRATHandoverInfoRequest");
single_value->field_interRATHandoverInfoRequest.log_match(match_value.interRATHandoverInfoRequest(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_eUTRANinterRATHandoverInfoRequest.match(match_value.eUTRANinterRATHandoverInfoRequest(), legacy)){
TTCN_Logger::log_logmatch_info(".eUTRANinterRATHandoverInfoRequest");
single_value->field_eUTRANinterRATHandoverInfoRequest.log_match(match_value.eUTRANinterRATHandoverInfoRequest(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", interRATHandoverInfoRequest := ");
single_value->field_interRATHandoverInfoRequest.log_match(match_value.interRATHandoverInfoRequest(), legacy);
TTCN_Logger::log_event_str(", eUTRANinterRATHandoverInfoRequest := ");
single_value->field_eUTRANinterRATHandoverInfoRequest.log_match(match_value.eUTRANinterRATHandoverInfoRequest(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Request__For__Inter__RAT__Handover__Info_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_interRATHandoverInfoRequest.encode_text(text_buf);
single_value->field_eUTRANinterRATHandoverInfoRequest.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info.");
}
}

void Request__For__Inter__RAT__Handover__Info_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_interRATHandoverInfoRequest.decode_text(text_buf);
single_value->field_eUTRANinterRATHandoverInfoRequest.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Request__For__Inter__RAT__Handover__Info_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info.");
}
}

void Request__For__Inter__RAT__Handover__Info_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Request__For__Inter__RAT__Handover__Info_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record template of type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) interRATHandoverInfoRequest().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) eUTRANinterRATHandoverInfoRequest().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "interRATHandoverInfoRequest")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          interRATHandoverInfoRequest().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "eUTRANinterRATHandoverInfoRequest")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          eUTRANinterRATHandoverInfoRequest().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Request_For_Inter_RAT_Handover_Info: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Request__For__Inter__RAT__Handover__Info_template* precondition = new Request__For__Inter__RAT__Handover__Info_template;
    precondition->set_param(*param.get_elem(0));
    Request__For__Inter__RAT__Handover__Info_template* implied_template = new Request__For__Inter__RAT__Handover__Info_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Request__For__Inter__RAT__Handover__Info_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSGP_Types.Request_For_Inter_RAT_Handover_Info");
  }
  is_ifpresent = param.get_ifpresent();
}

void Request__For__Inter__RAT__Handover__Info_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Request_For_Inter_RAT_Handover_Info");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Request_For_Inter_RAT_Handover_Info");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Request_For_Inter_RAT_Handover_Info");
single_value->field_interRATHandoverInfoRequest.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Request_For_Inter_RAT_Handover_Info");
single_value->field_eUTRANinterRATHandoverInfoRequest.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Request_For_Inter_RAT_Handover_Info");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Request_For_Inter_RAT_Handover_Info");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSGP_Types.Request_For_Inter_RAT_Handover_Info");
}

boolean Request__For__Inter__RAT__Handover__Info_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Request__For__Inter__RAT__Handover__Info_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Reliable__Inter__RAT__Handover__Info::Reliable__Inter__RAT__Handover__Info()
{
}

Reliable__Inter__RAT__Handover__Info::Reliable__Inter__RAT__Handover__Info(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a& par_lengthIndicator,
    const BITSTRING& par_reliableInterRATHandoverInfoIndicator,
    const BITSTRING& par_spare)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_reliableInterRATHandoverInfoIndicator(par_reliableInterRATHandoverInfoIndicator),
  field_spare(par_spare)
{
}

Reliable__Inter__RAT__Handover__Info::Reliable__Inter__RAT__Handover__Info(const Reliable__Inter__RAT__Handover__Info& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.reliableInterRATHandoverInfoIndicator().is_bound()) field_reliableInterRATHandoverInfoIndicator = other_value.reliableInterRATHandoverInfoIndicator();
else field_reliableInterRATHandoverInfoIndicator.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void Reliable__Inter__RAT__Handover__Info::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_reliableInterRATHandoverInfoIndicator.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* Reliable__Inter__RAT__Handover__Info::get_descriptor() const { return &Reliable__Inter__RAT__Handover__Info_descr_; }
Reliable__Inter__RAT__Handover__Info& Reliable__Inter__RAT__Handover__Info::operator=(const Reliable__Inter__RAT__Handover__Info& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.reliableInterRATHandoverInfoIndicator().is_bound()) field_reliableInterRATHandoverInfoIndicator = other_value.reliableInterRATHandoverInfoIndicator();
  else field_reliableInterRATHandoverInfoIndicator.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean Reliable__Inter__RAT__Handover__Info::operator==(const Reliable__Inter__RAT__Handover__Info& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_reliableInterRATHandoverInfoIndicator==other_value.field_reliableInterRATHandoverInfoIndicator
  && field_spare==other_value.field_spare;
}

boolean Reliable__Inter__RAT__Handover__Info::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_reliableInterRATHandoverInfoIndicator.is_bound())
  || (field_spare.is_bound());
}
boolean Reliable__Inter__RAT__Handover__Info::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_reliableInterRATHandoverInfoIndicator.is_value()
  && field_spare.is_value();
}
void Reliable__Inter__RAT__Handover__Info::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", reliableInterRATHandoverInfoIndicator := ");
field_reliableInterRATHandoverInfoIndicator.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void Reliable__Inter__RAT__Handover__Info::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (reliableInterRATHandoverInfoIndicator().is_bound()) reliableInterRATHandoverInfoIndicator().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void Reliable__Inter__RAT__Handover__Info::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) reliableInterRATHandoverInfoIndicator().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reliableInterRATHandoverInfoIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reliableInterRATHandoverInfoIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSGP_Types.Reliable_Inter_RAT_Handover_Info");
  }
}

void Reliable__Inter__RAT__Handover__Info::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_reliableInterRATHandoverInfoIndicator.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void Reliable__Inter__RAT__Handover__Info::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_reliableInterRATHandoverInfoIndicator.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void Reliable__Inter__RAT__Handover__Info::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Reliable__Inter__RAT__Handover__Info::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Reliable__Inter__RAT__Handover__Info::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, Reliable__Inter__RAT__Handover__Info_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(Reliable__Inter__RAT__Handover__Info_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_0) selected_field = 0;
  else if (field_ext ==  bs_1) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, Reliable__Inter__RAT__Handover__Info_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(Reliable__Inter__RAT__Handover__Info_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_reliableInterRATHandoverInfoIndicator.RAW_decode(General__Types::BIT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT7_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT7_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  if (field_iEI !=  os_97) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int Reliable__Inter__RAT__Handover__Info::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Reliable__Inter__RAT__Handover__Info_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Reliable__Inter__RAT__Handover__Info_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT7_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(Reliable__Inter__RAT__Handover__Info_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(Reliable__Inter__RAT__Handover__Info_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_reliableInterRATHandoverInfoIndicator.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT7_descr_, *myleaf.body.node.nodes[4]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 2;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(2);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1:
  if (field_ext !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(Reliable__Inter__RAT__Handover__Info_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a::ALT_length2:
  if (field_ext !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(Reliable__Inter__RAT__Handover__Info_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_iEI !=  os_97) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_97.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct Reliable__Inter__RAT__Handover__Info_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a_template field_lengthIndicator;
BITSTRING_template field_reliableInterRATHandoverInfoIndicator;
BITSTRING_template field_spare;
};

void Reliable__Inter__RAT__Handover__Info_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_reliableInterRATHandoverInfoIndicator = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void Reliable__Inter__RAT__Handover__Info_template::copy_value(const Reliable__Inter__RAT__Handover__Info& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.reliableInterRATHandoverInfoIndicator().is_bound()) {
  single_value->field_reliableInterRATHandoverInfoIndicator = other_value.reliableInterRATHandoverInfoIndicator();
} else {
  single_value->field_reliableInterRATHandoverInfoIndicator.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Reliable__Inter__RAT__Handover__Info_template::copy_template(const Reliable__Inter__RAT__Handover__Info_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reliableInterRATHandoverInfoIndicator().get_selection()) {
single_value->field_reliableInterRATHandoverInfoIndicator = other_value.reliableInterRATHandoverInfoIndicator();
} else {
single_value->field_reliableInterRATHandoverInfoIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Reliable__Inter__RAT__Handover__Info_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Reliable__Inter__RAT__Handover__Info_template(*other_value.implication_.precondition);
implication_.implied_template = new Reliable__Inter__RAT__Handover__Info_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info.");
break;
}
set_selection(other_value);
}

Reliable__Inter__RAT__Handover__Info_template::Reliable__Inter__RAT__Handover__Info_template()
{
}

Reliable__Inter__RAT__Handover__Info_template::Reliable__Inter__RAT__Handover__Info_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Reliable__Inter__RAT__Handover__Info_template::Reliable__Inter__RAT__Handover__Info_template(const Reliable__Inter__RAT__Handover__Info& other_value)
{
copy_value(other_value);
}

Reliable__Inter__RAT__Handover__Info_template::Reliable__Inter__RAT__Handover__Info_template(const OPTIONAL<Reliable__Inter__RAT__Handover__Info>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Reliable__Inter__RAT__Handover__Info&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info from an unbound optional field.");
}
}

Reliable__Inter__RAT__Handover__Info_template::Reliable__Inter__RAT__Handover__Info_template(Reliable__Inter__RAT__Handover__Info_template* p_precondition, Reliable__Inter__RAT__Handover__Info_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Reliable__Inter__RAT__Handover__Info_template::Reliable__Inter__RAT__Handover__Info_template(Dynamic_Match_Interface<Reliable__Inter__RAT__Handover__Info>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Reliable__Inter__RAT__Handover__Info>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Reliable__Inter__RAT__Handover__Info_template::Reliable__Inter__RAT__Handover__Info_template(const Reliable__Inter__RAT__Handover__Info_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Reliable__Inter__RAT__Handover__Info_template::~Reliable__Inter__RAT__Handover__Info_template()
{
clean_up();
}

Reliable__Inter__RAT__Handover__Info_template& Reliable__Inter__RAT__Handover__Info_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Reliable__Inter__RAT__Handover__Info_template& Reliable__Inter__RAT__Handover__Info_template::operator=(const Reliable__Inter__RAT__Handover__Info& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Reliable__Inter__RAT__Handover__Info_template& Reliable__Inter__RAT__Handover__Info_template::operator=(const OPTIONAL<Reliable__Inter__RAT__Handover__Info>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Reliable__Inter__RAT__Handover__Info&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info.");
}
return *this;
}

Reliable__Inter__RAT__Handover__Info_template& Reliable__Inter__RAT__Handover__Info_template::operator=(const Reliable__Inter__RAT__Handover__Info_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Reliable__Inter__RAT__Handover__Info_template::match(const Reliable__Inter__RAT__Handover__Info& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.reliableInterRATHandoverInfoIndicator().is_bound()) return FALSE;
if(!single_value->field_reliableInterRATHandoverInfoIndicator.match(other_value.reliableInterRATHandoverInfoIndicator(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info.");
}
return FALSE;
}

boolean Reliable__Inter__RAT__Handover__Info_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_reliableInterRATHandoverInfoIndicator.is_bound()
 || single_value->field_spare.is_bound();
}

boolean Reliable__Inter__RAT__Handover__Info_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_reliableInterRATHandoverInfoIndicator.is_value()
 && single_value->field_spare.is_value();
}

void Reliable__Inter__RAT__Handover__Info_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Reliable__Inter__RAT__Handover__Info Reliable__Inter__RAT__Handover__Info_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info.");
Reliable__Inter__RAT__Handover__Info ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_reliableInterRATHandoverInfoIndicator.is_bound()) {
ret_val.reliableInterRATHandoverInfoIndicator() = single_value->field_reliableInterRATHandoverInfoIndicator.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void Reliable__Inter__RAT__Handover__Info_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Reliable__Inter__RAT__Handover__Info_template[list_length];
}

Reliable__Inter__RAT__Handover__Info_template& Reliable__Inter__RAT__Handover__Info_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& Reliable__Inter__RAT__Handover__Info_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& Reliable__Inter__RAT__Handover__Info_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info.");
return single_value->field_iEI;
}

BITSTRING_template& Reliable__Inter__RAT__Handover__Info_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& Reliable__Inter__RAT__Handover__Info_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info.");
return single_value->field_ext;
}

LIN2__2a_template& Reliable__Inter__RAT__Handover__Info_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a_template& Reliable__Inter__RAT__Handover__Info_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& Reliable__Inter__RAT__Handover__Info_template::reliableInterRATHandoverInfoIndicator()
{
set_specific();
return single_value->field_reliableInterRATHandoverInfoIndicator;
}

const BITSTRING_template& Reliable__Inter__RAT__Handover__Info_template::reliableInterRATHandoverInfoIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reliableInterRATHandoverInfoIndicator of a non-specific template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info.");
return single_value->field_reliableInterRATHandoverInfoIndicator;
}

BITSTRING_template& Reliable__Inter__RAT__Handover__Info_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& Reliable__Inter__RAT__Handover__Info_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info.");
return single_value->field_spare;
}

int Reliable__Inter__RAT__Handover__Info_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info.");
  }
  return 0;
}

void Reliable__Inter__RAT__Handover__Info_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", reliableInterRATHandoverInfoIndicator := ");
single_value->field_reliableInterRATHandoverInfoIndicator.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Reliable__Inter__RAT__Handover__Info_template::log_match(const Reliable__Inter__RAT__Handover__Info& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reliableInterRATHandoverInfoIndicator.match(match_value.reliableInterRATHandoverInfoIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".reliableInterRATHandoverInfoIndicator");
single_value->field_reliableInterRATHandoverInfoIndicator.log_match(match_value.reliableInterRATHandoverInfoIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", reliableInterRATHandoverInfoIndicator := ");
single_value->field_reliableInterRATHandoverInfoIndicator.log_match(match_value.reliableInterRATHandoverInfoIndicator(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Reliable__Inter__RAT__Handover__Info_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_reliableInterRATHandoverInfoIndicator.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info.");
}
}

void Reliable__Inter__RAT__Handover__Info_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_reliableInterRATHandoverInfoIndicator.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Reliable__Inter__RAT__Handover__Info_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info.");
}
}

void Reliable__Inter__RAT__Handover__Info_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Reliable__Inter__RAT__Handover__Info_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) reliableInterRATHandoverInfoIndicator().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reliableInterRATHandoverInfoIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reliableInterRATHandoverInfoIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Reliable_Inter_RAT_Handover_Info: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Reliable__Inter__RAT__Handover__Info_template* precondition = new Reliable__Inter__RAT__Handover__Info_template;
    precondition->set_param(*param.get_elem(0));
    Reliable__Inter__RAT__Handover__Info_template* implied_template = new Reliable__Inter__RAT__Handover__Info_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Reliable__Inter__RAT__Handover__Info_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSGP_Types.Reliable_Inter_RAT_Handover_Info");
  }
  is_ifpresent = param.get_ifpresent();
}

void Reliable__Inter__RAT__Handover__Info_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Reliable_Inter_RAT_Handover_Info");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Reliable_Inter_RAT_Handover_Info");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Reliable_Inter_RAT_Handover_Info");
single_value->field_reliableInterRATHandoverInfoIndicator.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Reliable_Inter_RAT_Handover_Info");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Reliable_Inter_RAT_Handover_Info");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSGP_Types.Reliable_Inter_RAT_Handover_Info");
}

boolean Reliable__Inter__RAT__Handover__Info_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Reliable__Inter__RAT__Handover__Info_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

CSG__Identity::CSG__Identity()
{
}

CSG__Identity::CSG__Identity(const OCTETSTRING& par_cSG__Id24,
    const BITSTRING& par_cSG__Id3,
    const BITSTRING& par_spare)
  :   field_cSG__Id24(par_cSG__Id24),
  field_cSG__Id3(par_cSG__Id3),
  field_spare(par_spare)
{
}

CSG__Identity::CSG__Identity(const CSG__Identity& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSGP_Types.CSG_Identity.");
if (other_value.cSG__Id24().is_bound()) field_cSG__Id24 = other_value.cSG__Id24();
else field_cSG__Id24.clean_up();
if (other_value.cSG__Id3().is_bound()) field_cSG__Id3 = other_value.cSG__Id3();
else field_cSG__Id3.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void CSG__Identity::clean_up()
{
field_cSG__Id24.clean_up();
field_cSG__Id3.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* CSG__Identity::get_descriptor() const { return &CSG__Identity_descr_; }
CSG__Identity& CSG__Identity::operator=(const CSG__Identity& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSGP_Types.CSG_Identity.");
  if (other_value.cSG__Id24().is_bound()) field_cSG__Id24 = other_value.cSG__Id24();
  else field_cSG__Id24.clean_up();
  if (other_value.cSG__Id3().is_bound()) field_cSG__Id3 = other_value.cSG__Id3();
  else field_cSG__Id3.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean CSG__Identity::operator==(const CSG__Identity& other_value) const
{
return field_cSG__Id24==other_value.field_cSG__Id24
  && field_cSG__Id3==other_value.field_cSG__Id3
  && field_spare==other_value.field_spare;
}

boolean CSG__Identity::is_bound() const
{
return (field_cSG__Id24.is_bound())
  || (field_cSG__Id3.is_bound())
  || (field_spare.is_bound());
}
boolean CSG__Identity::is_value() const
{
return field_cSG__Id24.is_value()
  && field_cSG__Id3.is_value()
  && field_spare.is_value();
}
void CSG__Identity::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ cSG_Id24 := ");
field_cSG__Id24.log();
TTCN_Logger::log_event_str(", cSG_Id3 := ");
field_cSG__Id3.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void CSG__Identity::set_implicit_omit()
{
if (cSG__Id24().is_bound()) cSG__Id24().set_implicit_omit();
if (cSG__Id3().is_bound()) cSG__Id3().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void CSG__Identity::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSGP_Types.CSG_Identity has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) cSG__Id24().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cSG__Id3().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cSG_Id24")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cSG__Id24().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cSG_Id3")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cSG__Id3().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.CSG_Identity: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSGP_Types.CSG_Identity");
  }
}

void CSG__Identity::encode_text(Text_Buf& text_buf) const
{
field_cSG__Id24.encode_text(text_buf);
field_cSG__Id3.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void CSG__Identity::decode_text(Text_Buf& text_buf)
{
field_cSG__Id24.decode_text(text_buf);
field_cSG__Id3.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void CSG__Identity::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void CSG__Identity::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int CSG__Identity::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT3_descr_.raw->forceomit);
  decoded_field_length = field_cSG__Id24.RAW_decode(General__Types::OCT3_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_cSG__Id3.RAW_decode(General__Types::BIT3_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT5_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT5_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int CSG__Identity::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT3_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT3_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT5_descr_.raw);
  encoded_length += field_cSG__Id24.RAW_encode(General__Types::OCT3_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_cSG__Id3.RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT5_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct CSG__Identity_template::single_value_struct {
OCTETSTRING_template field_cSG__Id24;
BITSTRING_template field_cSG__Id3;
BITSTRING_template field_spare;
};

void CSG__Identity_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_cSG__Id24 = ANY_VALUE;
single_value->field_cSG__Id3 = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void CSG__Identity_template::copy_value(const CSG__Identity& other_value)
{
single_value = new single_value_struct;
if (other_value.cSG__Id24().is_bound()) {
  single_value->field_cSG__Id24 = other_value.cSG__Id24();
} else {
  single_value->field_cSG__Id24.clean_up();
}
if (other_value.cSG__Id3().is_bound()) {
  single_value->field_cSG__Id3 = other_value.cSG__Id3();
} else {
  single_value->field_cSG__Id3.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void CSG__Identity_template::copy_template(const CSG__Identity_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.cSG__Id24().get_selection()) {
single_value->field_cSG__Id24 = other_value.cSG__Id24();
} else {
single_value->field_cSG__Id24.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cSG__Id3().get_selection()) {
single_value->field_cSG__Id3 = other_value.cSG__Id3();
} else {
single_value->field_cSG__Id3.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new CSG__Identity_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new CSG__Identity_template(*other_value.implication_.precondition);
implication_.implied_template = new CSG__Identity_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSGP_Types.CSG_Identity.");
break;
}
set_selection(other_value);
}

CSG__Identity_template::CSG__Identity_template()
{
}

CSG__Identity_template::CSG__Identity_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

CSG__Identity_template::CSG__Identity_template(const CSG__Identity& other_value)
{
copy_value(other_value);
}

CSG__Identity_template::CSG__Identity_template(const OPTIONAL<CSG__Identity>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CSG__Identity&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSGP_Types.CSG_Identity from an unbound optional field.");
}
}

CSG__Identity_template::CSG__Identity_template(CSG__Identity_template* p_precondition, CSG__Identity_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

CSG__Identity_template::CSG__Identity_template(Dynamic_Match_Interface<CSG__Identity>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<CSG__Identity>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

CSG__Identity_template::CSG__Identity_template(const CSG__Identity_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

CSG__Identity_template::~CSG__Identity_template()
{
clean_up();
}

CSG__Identity_template& CSG__Identity_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

CSG__Identity_template& CSG__Identity_template::operator=(const CSG__Identity& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

CSG__Identity_template& CSG__Identity_template::operator=(const OPTIONAL<CSG__Identity>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CSG__Identity&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSGP_Types.CSG_Identity.");
}
return *this;
}

CSG__Identity_template& CSG__Identity_template::operator=(const CSG__Identity_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean CSG__Identity_template::match(const CSG__Identity& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.cSG__Id24().is_bound()) return FALSE;
if(!single_value->field_cSG__Id24.match(other_value.cSG__Id24(), legacy))return FALSE;
if(!other_value.cSG__Id3().is_bound()) return FALSE;
if(!single_value->field_cSG__Id3.match(other_value.cSG__Id3(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSGP_Types.CSG_Identity.");
}
return FALSE;
}

boolean CSG__Identity_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_cSG__Id24.is_bound()
 || single_value->field_cSG__Id3.is_bound()
 || single_value->field_spare.is_bound();
}

boolean CSG__Identity_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_cSG__Id24.is_value()
 && single_value->field_cSG__Id3.is_value()
 && single_value->field_spare.is_value();
}

void CSG__Identity_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

CSG__Identity CSG__Identity_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSGP_Types.CSG_Identity.");
CSG__Identity ret_val;
if (single_value->field_cSG__Id24.is_bound()) {
ret_val.cSG__Id24() = single_value->field_cSG__Id24.valueof();
}
if (single_value->field_cSG__Id3.is_bound()) {
ret_val.cSG__Id3() = single_value->field_cSG__Id3.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void CSG__Identity_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSGP_Types.CSG_Identity.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new CSG__Identity_template[list_length];
}

CSG__Identity_template& CSG__Identity_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSGP_Types.CSG_Identity.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSGP_Types.CSG_Identity.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& CSG__Identity_template::cSG__Id24()
{
set_specific();
return single_value->field_cSG__Id24;
}

const OCTETSTRING_template& CSG__Identity_template::cSG__Id24() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cSG_Id24 of a non-specific template of type @BSSGP_Types.CSG_Identity.");
return single_value->field_cSG__Id24;
}

BITSTRING_template& CSG__Identity_template::cSG__Id3()
{
set_specific();
return single_value->field_cSG__Id3;
}

const BITSTRING_template& CSG__Identity_template::cSG__Id3() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cSG_Id3 of a non-specific template of type @BSSGP_Types.CSG_Identity.");
return single_value->field_cSG__Id3;
}

BITSTRING_template& CSG__Identity_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& CSG__Identity_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @BSSGP_Types.CSG_Identity.");
return single_value->field_spare;
}

int CSG__Identity_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.CSG_Identity which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSGP_Types.CSG_Identity containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.CSG_Identity containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.CSG_Identity containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.CSG_Identity containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.CSG_Identity containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.CSG_Identity containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.CSG_Identity containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.CSG_Identity containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSGP_Types.CSG_Identity.");
  }
  return 0;
}

void CSG__Identity_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ cSG_Id24 := ");
single_value->field_cSG__Id24.log();
TTCN_Logger::log_event_str(", cSG_Id3 := ");
single_value->field_cSG__Id3.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void CSG__Identity_template::log_match(const CSG__Identity& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_cSG__Id24.match(match_value.cSG__Id24(), legacy)){
TTCN_Logger::log_logmatch_info(".cSG_Id24");
single_value->field_cSG__Id24.log_match(match_value.cSG__Id24(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cSG__Id3.match(match_value.cSG__Id3(), legacy)){
TTCN_Logger::log_logmatch_info(".cSG_Id3");
single_value->field_cSG__Id3.log_match(match_value.cSG__Id3(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ cSG_Id24 := ");
single_value->field_cSG__Id24.log_match(match_value.cSG__Id24(), legacy);
TTCN_Logger::log_event_str(", cSG_Id3 := ");
single_value->field_cSG__Id3.log_match(match_value.cSG__Id3(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void CSG__Identity_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_cSG__Id24.encode_text(text_buf);
single_value->field_cSG__Id3.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSGP_Types.CSG_Identity.");
}
}

void CSG__Identity_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_cSG__Id24.decode_text(text_buf);
single_value->field_cSG__Id3.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new CSG__Identity_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSGP_Types.CSG_Identity.");
}
}

void CSG__Identity_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    CSG__Identity_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSGP_Types.CSG_Identity has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) cSG__Id24().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cSG__Id3().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cSG_Id24")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cSG__Id24().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cSG_Id3")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cSG__Id3().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.CSG_Identity: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    CSG__Identity_template* precondition = new CSG__Identity_template;
    precondition->set_param(*param.get_elem(0));
    CSG__Identity_template* implied_template = new CSG__Identity_template;
    implied_template->set_param(*param.get_elem(1));
    *this = CSG__Identity_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSGP_Types.CSG_Identity");
  }
  is_ifpresent = param.get_ifpresent();
}

void CSG__Identity_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_cSG__Id24.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.CSG_Identity");
single_value->field_cSG__Id3.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.CSG_Identity");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.CSG_Identity");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSGP_Types.CSG_Identity");
}

boolean CSG__Identity_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean CSG__Identity_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

CSG__Identifier__TLV::CSG__Identifier__TLV()
{
}

CSG__Identifier__TLV::CSG__Identifier__TLV(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a& par_lengthIndicator,
    const CSG__Identity& par_cSG__Identity,
    const BITSTRING& par_cell__Acces__Mode,
    const BITSTRING& par_spare)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_cSG__Identity(par_cSG__Identity),
  field_cell__Acces__Mode(par_cell__Acces__Mode),
  field_spare(par_spare)
{
}

CSG__Identifier__TLV::CSG__Identifier__TLV(const CSG__Identifier__TLV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSGP_Types.CSG_Identifier_TLV.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.cSG__Identity().is_bound()) field_cSG__Identity = other_value.cSG__Identity();
else field_cSG__Identity.clean_up();
if (other_value.cell__Acces__Mode().is_bound()) field_cell__Acces__Mode = other_value.cell__Acces__Mode();
else field_cell__Acces__Mode.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void CSG__Identifier__TLV::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_cSG__Identity.clean_up();
field_cell__Acces__Mode.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* CSG__Identifier__TLV::get_descriptor() const { return &CSG__Identifier__TLV_descr_; }
CSG__Identifier__TLV& CSG__Identifier__TLV::operator=(const CSG__Identifier__TLV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSGP_Types.CSG_Identifier_TLV.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.cSG__Identity().is_bound()) field_cSG__Identity = other_value.cSG__Identity();
  else field_cSG__Identity.clean_up();
  if (other_value.cell__Acces__Mode().is_bound()) field_cell__Acces__Mode = other_value.cell__Acces__Mode();
  else field_cell__Acces__Mode.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean CSG__Identifier__TLV::operator==(const CSG__Identifier__TLV& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_cSG__Identity==other_value.field_cSG__Identity
  && field_cell__Acces__Mode==other_value.field_cell__Acces__Mode
  && field_spare==other_value.field_spare;
}

boolean CSG__Identifier__TLV::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_cSG__Identity.is_bound())
  || (field_cell__Acces__Mode.is_bound())
  || (field_spare.is_bound());
}
boolean CSG__Identifier__TLV::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_cSG__Identity.is_value()
  && field_cell__Acces__Mode.is_value()
  && field_spare.is_value();
}
void CSG__Identifier__TLV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", cSG_Identity := ");
field_cSG__Identity.log();
TTCN_Logger::log_event_str(", cell_Acces_Mode := ");
field_cell__Acces__Mode.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void CSG__Identifier__TLV::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (cSG__Identity().is_bound()) cSG__Identity().set_implicit_omit();
if (cell__Acces__Mode().is_bound()) cell__Acces__Mode().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void CSG__Identifier__TLV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record value of type @BSSGP_Types.CSG_Identifier_TLV has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) cSG__Identity().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) cell__Acces__Mode().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cSG_Identity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cSG__Identity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cell_Acces_Mode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cell__Acces__Mode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.CSG_Identifier_TLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSGP_Types.CSG_Identifier_TLV");
  }
}

void CSG__Identifier__TLV::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_cSG__Identity.encode_text(text_buf);
field_cell__Acces__Mode.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void CSG__Identifier__TLV::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_cSG__Identity.decode_text(text_buf);
field_cell__Acces__Mode.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void CSG__Identifier__TLV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void CSG__Identifier__TLV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int CSG__Identifier__TLV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, CSG__Identifier__TLV_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(CSG__Identifier__TLV_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_0) selected_field = 0;
  else if (field_ext ==  bs_1) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, CSG__Identifier__TLV_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(CSG__Identifier__TLV_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, CSG__Identity_descr_.raw->forceomit);
  decoded_field_length = field_cSG__Identity.RAW_decode(CSG__Identity_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_cell__Acces__Mode.RAW_decode(General__Types::BIT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_5_force_omit(5, force_omit, General__Types::BIT7_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT7_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  if (field_iEI !=  os_98) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int CSG__Identifier__TLV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 6;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(6);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, CSG__Identifier__TLV_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, CSG__Identifier__TLV_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, CSG__Identity_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, General__Types::BIT7_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(CSG__Identifier__TLV_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(CSG__Identifier__TLV_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_cSG__Identity.RAW_encode(CSG__Identity_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_cell__Acces__Mode.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT7_descr_, *myleaf.body.node.nodes[5]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1:
  if (field_ext !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(CSG__Identifier__TLV_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a::ALT_length2:
  if (field_ext !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(CSG__Identifier__TLV_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_iEI !=  os_98) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_98.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct CSG__Identifier__TLV_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a_template field_lengthIndicator;
CSG__Identity_template field_cSG__Identity;
BITSTRING_template field_cell__Acces__Mode;
BITSTRING_template field_spare;
};

void CSG__Identifier__TLV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_cSG__Identity = ANY_VALUE;
single_value->field_cell__Acces__Mode = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void CSG__Identifier__TLV_template::copy_value(const CSG__Identifier__TLV& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.cSG__Identity().is_bound()) {
  single_value->field_cSG__Identity = other_value.cSG__Identity();
} else {
  single_value->field_cSG__Identity.clean_up();
}
if (other_value.cell__Acces__Mode().is_bound()) {
  single_value->field_cell__Acces__Mode = other_value.cell__Acces__Mode();
} else {
  single_value->field_cell__Acces__Mode.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void CSG__Identifier__TLV_template::copy_template(const CSG__Identifier__TLV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cSG__Identity().get_selection()) {
single_value->field_cSG__Identity = other_value.cSG__Identity();
} else {
single_value->field_cSG__Identity.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cell__Acces__Mode().get_selection()) {
single_value->field_cell__Acces__Mode = other_value.cell__Acces__Mode();
} else {
single_value->field_cell__Acces__Mode.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new CSG__Identifier__TLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new CSG__Identifier__TLV_template(*other_value.implication_.precondition);
implication_.implied_template = new CSG__Identifier__TLV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSGP_Types.CSG_Identifier_TLV.");
break;
}
set_selection(other_value);
}

CSG__Identifier__TLV_template::CSG__Identifier__TLV_template()
{
}

CSG__Identifier__TLV_template::CSG__Identifier__TLV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

CSG__Identifier__TLV_template::CSG__Identifier__TLV_template(const CSG__Identifier__TLV& other_value)
{
copy_value(other_value);
}

CSG__Identifier__TLV_template::CSG__Identifier__TLV_template(const OPTIONAL<CSG__Identifier__TLV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CSG__Identifier__TLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSGP_Types.CSG_Identifier_TLV from an unbound optional field.");
}
}

CSG__Identifier__TLV_template::CSG__Identifier__TLV_template(CSG__Identifier__TLV_template* p_precondition, CSG__Identifier__TLV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

CSG__Identifier__TLV_template::CSG__Identifier__TLV_template(Dynamic_Match_Interface<CSG__Identifier__TLV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<CSG__Identifier__TLV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

CSG__Identifier__TLV_template::CSG__Identifier__TLV_template(const CSG__Identifier__TLV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

CSG__Identifier__TLV_template::~CSG__Identifier__TLV_template()
{
clean_up();
}

CSG__Identifier__TLV_template& CSG__Identifier__TLV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

CSG__Identifier__TLV_template& CSG__Identifier__TLV_template::operator=(const CSG__Identifier__TLV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

CSG__Identifier__TLV_template& CSG__Identifier__TLV_template::operator=(const OPTIONAL<CSG__Identifier__TLV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CSG__Identifier__TLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSGP_Types.CSG_Identifier_TLV.");
}
return *this;
}

CSG__Identifier__TLV_template& CSG__Identifier__TLV_template::operator=(const CSG__Identifier__TLV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean CSG__Identifier__TLV_template::match(const CSG__Identifier__TLV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.cSG__Identity().is_bound()) return FALSE;
if(!single_value->field_cSG__Identity.match(other_value.cSG__Identity(), legacy))return FALSE;
if(!other_value.cell__Acces__Mode().is_bound()) return FALSE;
if(!single_value->field_cell__Acces__Mode.match(other_value.cell__Acces__Mode(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSGP_Types.CSG_Identifier_TLV.");
}
return FALSE;
}

boolean CSG__Identifier__TLV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_cSG__Identity.is_bound()
 || single_value->field_cell__Acces__Mode.is_bound()
 || single_value->field_spare.is_bound();
}

boolean CSG__Identifier__TLV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_cSG__Identity.is_value()
 && single_value->field_cell__Acces__Mode.is_value()
 && single_value->field_spare.is_value();
}

void CSG__Identifier__TLV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

CSG__Identifier__TLV CSG__Identifier__TLV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSGP_Types.CSG_Identifier_TLV.");
CSG__Identifier__TLV ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_cSG__Identity.is_bound()) {
ret_val.cSG__Identity() = single_value->field_cSG__Identity.valueof();
}
if (single_value->field_cell__Acces__Mode.is_bound()) {
ret_val.cell__Acces__Mode() = single_value->field_cell__Acces__Mode.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void CSG__Identifier__TLV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSGP_Types.CSG_Identifier_TLV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new CSG__Identifier__TLV_template[list_length];
}

CSG__Identifier__TLV_template& CSG__Identifier__TLV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSGP_Types.CSG_Identifier_TLV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSGP_Types.CSG_Identifier_TLV.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& CSG__Identifier__TLV_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& CSG__Identifier__TLV_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @BSSGP_Types.CSG_Identifier_TLV.");
return single_value->field_iEI;
}

BITSTRING_template& CSG__Identifier__TLV_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& CSG__Identifier__TLV_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @BSSGP_Types.CSG_Identifier_TLV.");
return single_value->field_ext;
}

LIN2__2a_template& CSG__Identifier__TLV_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a_template& CSG__Identifier__TLV_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSGP_Types.CSG_Identifier_TLV.");
return single_value->field_lengthIndicator;
}

CSG__Identity_template& CSG__Identifier__TLV_template::cSG__Identity()
{
set_specific();
return single_value->field_cSG__Identity;
}

const CSG__Identity_template& CSG__Identifier__TLV_template::cSG__Identity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cSG_Identity of a non-specific template of type @BSSGP_Types.CSG_Identifier_TLV.");
return single_value->field_cSG__Identity;
}

BITSTRING_template& CSG__Identifier__TLV_template::cell__Acces__Mode()
{
set_specific();
return single_value->field_cell__Acces__Mode;
}

const BITSTRING_template& CSG__Identifier__TLV_template::cell__Acces__Mode() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cell_Acces_Mode of a non-specific template of type @BSSGP_Types.CSG_Identifier_TLV.");
return single_value->field_cell__Acces__Mode;
}

BITSTRING_template& CSG__Identifier__TLV_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& CSG__Identifier__TLV_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @BSSGP_Types.CSG_Identifier_TLV.");
return single_value->field_spare;
}

int CSG__Identifier__TLV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.CSG_Identifier_TLV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 6;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSGP_Types.CSG_Identifier_TLV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.CSG_Identifier_TLV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.CSG_Identifier_TLV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.CSG_Identifier_TLV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.CSG_Identifier_TLV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.CSG_Identifier_TLV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.CSG_Identifier_TLV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.CSG_Identifier_TLV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSGP_Types.CSG_Identifier_TLV.");
  }
  return 0;
}

void CSG__Identifier__TLV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", cSG_Identity := ");
single_value->field_cSG__Identity.log();
TTCN_Logger::log_event_str(", cell_Acces_Mode := ");
single_value->field_cell__Acces__Mode.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void CSG__Identifier__TLV_template::log_match(const CSG__Identifier__TLV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cSG__Identity.match(match_value.cSG__Identity(), legacy)){
TTCN_Logger::log_logmatch_info(".cSG_Identity");
single_value->field_cSG__Identity.log_match(match_value.cSG__Identity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cell__Acces__Mode.match(match_value.cell__Acces__Mode(), legacy)){
TTCN_Logger::log_logmatch_info(".cell_Acces_Mode");
single_value->field_cell__Acces__Mode.log_match(match_value.cell__Acces__Mode(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", cSG_Identity := ");
single_value->field_cSG__Identity.log_match(match_value.cSG__Identity(), legacy);
TTCN_Logger::log_event_str(", cell_Acces_Mode := ");
single_value->field_cell__Acces__Mode.log_match(match_value.cell__Acces__Mode(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void CSG__Identifier__TLV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_cSG__Identity.encode_text(text_buf);
single_value->field_cell__Acces__Mode.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSGP_Types.CSG_Identifier_TLV.");
}
}

void CSG__Identifier__TLV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_cSG__Identity.decode_text(text_buf);
single_value->field_cell__Acces__Mode.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new CSG__Identifier__TLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSGP_Types.CSG_Identifier_TLV.");
}
}

void CSG__Identifier__TLV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    CSG__Identifier__TLV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record template of type @BSSGP_Types.CSG_Identifier_TLV has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) cSG__Identity().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) cell__Acces__Mode().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cSG_Identity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cSG__Identity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cell_Acces_Mode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cell__Acces__Mode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.CSG_Identifier_TLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    CSG__Identifier__TLV_template* precondition = new CSG__Identifier__TLV_template;
    precondition->set_param(*param.get_elem(0));
    CSG__Identifier__TLV_template* implied_template = new CSG__Identifier__TLV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = CSG__Identifier__TLV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSGP_Types.CSG_Identifier_TLV");
  }
  is_ifpresent = param.get_ifpresent();
}

void CSG__Identifier__TLV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.CSG_Identifier_TLV");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.CSG_Identifier_TLV");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.CSG_Identifier_TLV");
single_value->field_cSG__Identity.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.CSG_Identifier_TLV");
single_value->field_cell__Acces__Mode.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.CSG_Identifier_TLV");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.CSG_Identifier_TLV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSGP_Types.CSG_Identifier_TLV");
}

boolean CSG__Identifier__TLV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean CSG__Identifier__TLV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Tracking__Area__Code__TLV::Tracking__Area__Code__TLV()
{
}

Tracking__Area__Code__TLV::Tracking__Area__Code__TLV(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a& par_lengthIndicator,
    const OCTETSTRING& par_valueField)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_valueField(par_valueField)
{
}

Tracking__Area__Code__TLV::Tracking__Area__Code__TLV(const Tracking__Area__Code__TLV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSGP_Types.Tracking_Area_Code_TLV.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
else field_valueField.clean_up();
}

void Tracking__Area__Code__TLV::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_valueField.clean_up();
}

const TTCN_Typedescriptor_t* Tracking__Area__Code__TLV::get_descriptor() const { return &Tracking__Area__Code__TLV_descr_; }
Tracking__Area__Code__TLV& Tracking__Area__Code__TLV::operator=(const Tracking__Area__Code__TLV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSGP_Types.Tracking_Area_Code_TLV.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
  else field_valueField.clean_up();
}
return *this;
}

boolean Tracking__Area__Code__TLV::operator==(const Tracking__Area__Code__TLV& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_valueField==other_value.field_valueField;
}

boolean Tracking__Area__Code__TLV::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_valueField.is_bound());
}
boolean Tracking__Area__Code__TLV::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_valueField.is_value();
}
void Tracking__Area__Code__TLV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", valueField := ");
field_valueField.log();
TTCN_Logger::log_event_str(" }");
}

void Tracking__Area__Code__TLV::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (valueField().is_bound()) valueField().set_implicit_omit();
}

void Tracking__Area__Code__TLV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @BSSGP_Types.Tracking_Area_Code_TLV has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Tracking_Area_Code_TLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSGP_Types.Tracking_Area_Code_TLV");
  }
}

void Tracking__Area__Code__TLV::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_valueField.encode_text(text_buf);
}

void Tracking__Area__Code__TLV::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_valueField.decode_text(text_buf);
}

void Tracking__Area__Code__TLV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Tracking__Area__Code__TLV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Tracking__Area__Code__TLV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, Tracking__Area__Code__TLV_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(Tracking__Area__Code__TLV_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_0) selected_field = 0;
  else if (field_ext ==  bs_1) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, Tracking__Area__Code__TLV_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(Tracking__Area__Code__TLV_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::OCT3_descr_.raw->forceomit);
  decoded_field_length = field_valueField.RAW_decode(General__Types::OCT3_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  if (field_iEI !=  os_99) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int Tracking__Area__Code__TLV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Tracking__Area__Code__TLV_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Tracking__Area__Code__TLV_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::OCT3_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(Tracking__Area__Code__TLV_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(Tracking__Area__Code__TLV_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_valueField.RAW_encode(General__Types::OCT3_descr_, *myleaf.body.node.nodes[3]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1:
  if (field_ext !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(Tracking__Area__Code__TLV_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a::ALT_length2:
  if (field_ext !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(Tracking__Area__Code__TLV_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_iEI !=  os_99) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_99.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct Tracking__Area__Code__TLV_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a_template field_lengthIndicator;
OCTETSTRING_template field_valueField;
};

void Tracking__Area__Code__TLV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_valueField = ANY_VALUE;
}
}
}

void Tracking__Area__Code__TLV_template::copy_value(const Tracking__Area__Code__TLV& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.valueField().is_bound()) {
  single_value->field_valueField = other_value.valueField();
} else {
  single_value->field_valueField.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Tracking__Area__Code__TLV_template::copy_template(const Tracking__Area__Code__TLV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.valueField().get_selection()) {
single_value->field_valueField = other_value.valueField();
} else {
single_value->field_valueField.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Tracking__Area__Code__TLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Tracking__Area__Code__TLV_template(*other_value.implication_.precondition);
implication_.implied_template = new Tracking__Area__Code__TLV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSGP_Types.Tracking_Area_Code_TLV.");
break;
}
set_selection(other_value);
}

Tracking__Area__Code__TLV_template::Tracking__Area__Code__TLV_template()
{
}

Tracking__Area__Code__TLV_template::Tracking__Area__Code__TLV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Tracking__Area__Code__TLV_template::Tracking__Area__Code__TLV_template(const Tracking__Area__Code__TLV& other_value)
{
copy_value(other_value);
}

Tracking__Area__Code__TLV_template::Tracking__Area__Code__TLV_template(const OPTIONAL<Tracking__Area__Code__TLV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Tracking__Area__Code__TLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSGP_Types.Tracking_Area_Code_TLV from an unbound optional field.");
}
}

Tracking__Area__Code__TLV_template::Tracking__Area__Code__TLV_template(Tracking__Area__Code__TLV_template* p_precondition, Tracking__Area__Code__TLV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Tracking__Area__Code__TLV_template::Tracking__Area__Code__TLV_template(Dynamic_Match_Interface<Tracking__Area__Code__TLV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Tracking__Area__Code__TLV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Tracking__Area__Code__TLV_template::Tracking__Area__Code__TLV_template(const Tracking__Area__Code__TLV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Tracking__Area__Code__TLV_template::~Tracking__Area__Code__TLV_template()
{
clean_up();
}

Tracking__Area__Code__TLV_template& Tracking__Area__Code__TLV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Tracking__Area__Code__TLV_template& Tracking__Area__Code__TLV_template::operator=(const Tracking__Area__Code__TLV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Tracking__Area__Code__TLV_template& Tracking__Area__Code__TLV_template::operator=(const OPTIONAL<Tracking__Area__Code__TLV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Tracking__Area__Code__TLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSGP_Types.Tracking_Area_Code_TLV.");
}
return *this;
}

Tracking__Area__Code__TLV_template& Tracking__Area__Code__TLV_template::operator=(const Tracking__Area__Code__TLV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Tracking__Area__Code__TLV_template::match(const Tracking__Area__Code__TLV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.valueField().is_bound()) return FALSE;
if(!single_value->field_valueField.match(other_value.valueField(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSGP_Types.Tracking_Area_Code_TLV.");
}
return FALSE;
}

boolean Tracking__Area__Code__TLV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_valueField.is_bound();
}

boolean Tracking__Area__Code__TLV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_valueField.is_value();
}

void Tracking__Area__Code__TLV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Tracking__Area__Code__TLV Tracking__Area__Code__TLV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSGP_Types.Tracking_Area_Code_TLV.");
Tracking__Area__Code__TLV ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_valueField.is_bound()) {
ret_val.valueField() = single_value->field_valueField.valueof();
}
return ret_val;
}

void Tracking__Area__Code__TLV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSGP_Types.Tracking_Area_Code_TLV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Tracking__Area__Code__TLV_template[list_length];
}

Tracking__Area__Code__TLV_template& Tracking__Area__Code__TLV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSGP_Types.Tracking_Area_Code_TLV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSGP_Types.Tracking_Area_Code_TLV.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& Tracking__Area__Code__TLV_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& Tracking__Area__Code__TLV_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @BSSGP_Types.Tracking_Area_Code_TLV.");
return single_value->field_iEI;
}

BITSTRING_template& Tracking__Area__Code__TLV_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& Tracking__Area__Code__TLV_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @BSSGP_Types.Tracking_Area_Code_TLV.");
return single_value->field_ext;
}

LIN2__2a_template& Tracking__Area__Code__TLV_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a_template& Tracking__Area__Code__TLV_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSGP_Types.Tracking_Area_Code_TLV.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& Tracking__Area__Code__TLV_template::valueField()
{
set_specific();
return single_value->field_valueField;
}

const OCTETSTRING_template& Tracking__Area__Code__TLV_template::valueField() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field valueField of a non-specific template of type @BSSGP_Types.Tracking_Area_Code_TLV.");
return single_value->field_valueField;
}

int Tracking__Area__Code__TLV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Tracking_Area_Code_TLV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSGP_Types.Tracking_Area_Code_TLV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Tracking_Area_Code_TLV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Tracking_Area_Code_TLV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Tracking_Area_Code_TLV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Tracking_Area_Code_TLV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Tracking_Area_Code_TLV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Tracking_Area_Code_TLV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Tracking_Area_Code_TLV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSGP_Types.Tracking_Area_Code_TLV.");
  }
  return 0;
}

void Tracking__Area__Code__TLV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", valueField := ");
single_value->field_valueField.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Tracking__Area__Code__TLV_template::log_match(const Tracking__Area__Code__TLV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_valueField.match(match_value.valueField(), legacy)){
TTCN_Logger::log_logmatch_info(".valueField");
single_value->field_valueField.log_match(match_value.valueField(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", valueField := ");
single_value->field_valueField.log_match(match_value.valueField(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Tracking__Area__Code__TLV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_valueField.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSGP_Types.Tracking_Area_Code_TLV.");
}
}

void Tracking__Area__Code__TLV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_valueField.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Tracking__Area__Code__TLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSGP_Types.Tracking_Area_Code_TLV.");
}
}

void Tracking__Area__Code__TLV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Tracking__Area__Code__TLV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @BSSGP_Types.Tracking_Area_Code_TLV has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Tracking_Area_Code_TLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Tracking__Area__Code__TLV_template* precondition = new Tracking__Area__Code__TLV_template;
    precondition->set_param(*param.get_elem(0));
    Tracking__Area__Code__TLV_template* implied_template = new Tracking__Area__Code__TLV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Tracking__Area__Code__TLV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSGP_Types.Tracking_Area_Code_TLV");
  }
  is_ifpresent = param.get_ifpresent();
}

void Tracking__Area__Code__TLV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Tracking_Area_Code_TLV");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Tracking_Area_Code_TLV");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Tracking_Area_Code_TLV");
single_value->field_valueField.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Tracking_Area_Code_TLV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSGP_Types.Tracking_Area_Code_TLV");
}

boolean Tracking__Area__Code__TLV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Tracking__Area__Code__TLV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Redirect__Attempt__Flag::Redirect__Attempt__Flag()
{
}

Redirect__Attempt__Flag::Redirect__Attempt__Flag(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a& par_lengthIndicator,
    const OCTETSTRING& par_spare)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_spare(par_spare)
{
}

Redirect__Attempt__Flag::Redirect__Attempt__Flag(const Redirect__Attempt__Flag& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSGP_Types.Redirect_Attempt_Flag.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void Redirect__Attempt__Flag::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* Redirect__Attempt__Flag::get_descriptor() const { return &Redirect__Attempt__Flag_descr_; }
Redirect__Attempt__Flag& Redirect__Attempt__Flag::operator=(const Redirect__Attempt__Flag& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSGP_Types.Redirect_Attempt_Flag.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean Redirect__Attempt__Flag::operator==(const Redirect__Attempt__Flag& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_spare==other_value.field_spare;
}

boolean Redirect__Attempt__Flag::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_spare.is_bound());
}
boolean Redirect__Attempt__Flag::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_spare.is_value();
}
void Redirect__Attempt__Flag::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void Redirect__Attempt__Flag::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void Redirect__Attempt__Flag::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @BSSGP_Types.Redirect_Attempt_Flag has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Redirect_Attempt_Flag: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSGP_Types.Redirect_Attempt_Flag");
  }
}

void Redirect__Attempt__Flag::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void Redirect__Attempt__Flag::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void Redirect__Attempt__Flag::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Redirect__Attempt__Flag::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Redirect__Attempt__Flag::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, Redirect__Attempt__Flag_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(Redirect__Attempt__Flag_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_0) selected_field = 0;
  else if (field_ext ==  bs_1) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, Redirect__Attempt__Flag_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(Redirect__Attempt__Flag_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  if (field_iEI !=  os_23) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int Redirect__Attempt__Flag::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Redirect__Attempt__Flag_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Redirect__Attempt__Flag_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::OCT1_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(Redirect__Attempt__Flag_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(Redirect__Attempt__Flag_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_spare.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[3]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1:
  if (field_ext !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(Redirect__Attempt__Flag_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a::ALT_length2:
  if (field_ext !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(Redirect__Attempt__Flag_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_iEI !=  os_23) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_23.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct Redirect__Attempt__Flag_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a_template field_lengthIndicator;
OCTETSTRING_template field_spare;
};

void Redirect__Attempt__Flag_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void Redirect__Attempt__Flag_template::copy_value(const Redirect__Attempt__Flag& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Redirect__Attempt__Flag_template::copy_template(const Redirect__Attempt__Flag_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Redirect__Attempt__Flag_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Redirect__Attempt__Flag_template(*other_value.implication_.precondition);
implication_.implied_template = new Redirect__Attempt__Flag_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSGP_Types.Redirect_Attempt_Flag.");
break;
}
set_selection(other_value);
}

Redirect__Attempt__Flag_template::Redirect__Attempt__Flag_template()
{
}

Redirect__Attempt__Flag_template::Redirect__Attempt__Flag_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Redirect__Attempt__Flag_template::Redirect__Attempt__Flag_template(const Redirect__Attempt__Flag& other_value)
{
copy_value(other_value);
}

Redirect__Attempt__Flag_template::Redirect__Attempt__Flag_template(const OPTIONAL<Redirect__Attempt__Flag>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Redirect__Attempt__Flag&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSGP_Types.Redirect_Attempt_Flag from an unbound optional field.");
}
}

Redirect__Attempt__Flag_template::Redirect__Attempt__Flag_template(Redirect__Attempt__Flag_template* p_precondition, Redirect__Attempt__Flag_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Redirect__Attempt__Flag_template::Redirect__Attempt__Flag_template(Dynamic_Match_Interface<Redirect__Attempt__Flag>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Redirect__Attempt__Flag>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Redirect__Attempt__Flag_template::Redirect__Attempt__Flag_template(const Redirect__Attempt__Flag_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Redirect__Attempt__Flag_template::~Redirect__Attempt__Flag_template()
{
clean_up();
}

Redirect__Attempt__Flag_template& Redirect__Attempt__Flag_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Redirect__Attempt__Flag_template& Redirect__Attempt__Flag_template::operator=(const Redirect__Attempt__Flag& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Redirect__Attempt__Flag_template& Redirect__Attempt__Flag_template::operator=(const OPTIONAL<Redirect__Attempt__Flag>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Redirect__Attempt__Flag&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSGP_Types.Redirect_Attempt_Flag.");
}
return *this;
}

Redirect__Attempt__Flag_template& Redirect__Attempt__Flag_template::operator=(const Redirect__Attempt__Flag_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Redirect__Attempt__Flag_template::match(const Redirect__Attempt__Flag& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSGP_Types.Redirect_Attempt_Flag.");
}
return FALSE;
}

boolean Redirect__Attempt__Flag_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_spare.is_bound();
}

boolean Redirect__Attempt__Flag_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_spare.is_value();
}

void Redirect__Attempt__Flag_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Redirect__Attempt__Flag Redirect__Attempt__Flag_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSGP_Types.Redirect_Attempt_Flag.");
Redirect__Attempt__Flag ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void Redirect__Attempt__Flag_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSGP_Types.Redirect_Attempt_Flag.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Redirect__Attempt__Flag_template[list_length];
}

Redirect__Attempt__Flag_template& Redirect__Attempt__Flag_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSGP_Types.Redirect_Attempt_Flag.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSGP_Types.Redirect_Attempt_Flag.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& Redirect__Attempt__Flag_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& Redirect__Attempt__Flag_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @BSSGP_Types.Redirect_Attempt_Flag.");
return single_value->field_iEI;
}

BITSTRING_template& Redirect__Attempt__Flag_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& Redirect__Attempt__Flag_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @BSSGP_Types.Redirect_Attempt_Flag.");
return single_value->field_ext;
}

LIN2__2a_template& Redirect__Attempt__Flag_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a_template& Redirect__Attempt__Flag_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSGP_Types.Redirect_Attempt_Flag.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& Redirect__Attempt__Flag_template::spare()
{
set_specific();
return single_value->field_spare;
}

const OCTETSTRING_template& Redirect__Attempt__Flag_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @BSSGP_Types.Redirect_Attempt_Flag.");
return single_value->field_spare;
}

int Redirect__Attempt__Flag_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirect_Attempt_Flag which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSGP_Types.Redirect_Attempt_Flag containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirect_Attempt_Flag containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirect_Attempt_Flag containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirect_Attempt_Flag containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirect_Attempt_Flag containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirect_Attempt_Flag containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirect_Attempt_Flag containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirect_Attempt_Flag containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSGP_Types.Redirect_Attempt_Flag.");
  }
  return 0;
}

void Redirect__Attempt__Flag_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Redirect__Attempt__Flag_template::log_match(const Redirect__Attempt__Flag& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Redirect__Attempt__Flag_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSGP_Types.Redirect_Attempt_Flag.");
}
}

void Redirect__Attempt__Flag_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Redirect__Attempt__Flag_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSGP_Types.Redirect_Attempt_Flag.");
}
}

void Redirect__Attempt__Flag_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Redirect__Attempt__Flag_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @BSSGP_Types.Redirect_Attempt_Flag has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Redirect_Attempt_Flag: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Redirect__Attempt__Flag_template* precondition = new Redirect__Attempt__Flag_template;
    precondition->set_param(*param.get_elem(0));
    Redirect__Attempt__Flag_template* implied_template = new Redirect__Attempt__Flag_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Redirect__Attempt__Flag_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSGP_Types.Redirect_Attempt_Flag");
  }
  is_ifpresent = param.get_ifpresent();
}

void Redirect__Attempt__Flag_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Redirect_Attempt_Flag");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Redirect_Attempt_Flag");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Redirect_Attempt_Flag");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Redirect_Attempt_Flag");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSGP_Types.Redirect_Attempt_Flag");
}

boolean Redirect__Attempt__Flag_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Redirect__Attempt__Flag_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Redirection__Indication::Redirection__Indication()
{
}

Redirection__Indication::Redirection__Indication(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a& par_lengthIndicator,
    const BITSTRING& par_reroute__Reject__Cause__value)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_reroute__Reject__Cause__value(par_reroute__Reject__Cause__value)
{
}

Redirection__Indication::Redirection__Indication(const Redirection__Indication& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSGP_Types.Redirection_Indication.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.reroute__Reject__Cause__value().is_bound()) field_reroute__Reject__Cause__value = other_value.reroute__Reject__Cause__value();
else field_reroute__Reject__Cause__value.clean_up();
}

void Redirection__Indication::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_reroute__Reject__Cause__value.clean_up();
}

const TTCN_Typedescriptor_t* Redirection__Indication::get_descriptor() const { return &Redirection__Indication_descr_; }
Redirection__Indication& Redirection__Indication::operator=(const Redirection__Indication& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSGP_Types.Redirection_Indication.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.reroute__Reject__Cause__value().is_bound()) field_reroute__Reject__Cause__value = other_value.reroute__Reject__Cause__value();
  else field_reroute__Reject__Cause__value.clean_up();
}
return *this;
}

boolean Redirection__Indication::operator==(const Redirection__Indication& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_reroute__Reject__Cause__value==other_value.field_reroute__Reject__Cause__value;
}

boolean Redirection__Indication::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_reroute__Reject__Cause__value.is_bound());
}
boolean Redirection__Indication::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_reroute__Reject__Cause__value.is_value();
}
void Redirection__Indication::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", reroute_Reject_Cause_value := ");
field_reroute__Reject__Cause__value.log();
TTCN_Logger::log_event_str(" }");
}

void Redirection__Indication::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (reroute__Reject__Cause__value().is_bound()) reroute__Reject__Cause__value().set_implicit_omit();
}

void Redirection__Indication::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @BSSGP_Types.Redirection_Indication has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) reroute__Reject__Cause__value().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reroute_Reject_Cause_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reroute__Reject__Cause__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Redirection_Indication: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSGP_Types.Redirection_Indication");
  }
}

void Redirection__Indication::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_reroute__Reject__Cause__value.encode_text(text_buf);
}

void Redirection__Indication::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_reroute__Reject__Cause__value.decode_text(text_buf);
}

void Redirection__Indication::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Redirection__Indication::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Redirection__Indication::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, Redirection__Indication_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(Redirection__Indication_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_0) selected_field = 0;
  else if (field_ext ==  bs_1) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, Redirection__Indication_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(Redirection__Indication_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT8_descr_.raw->forceomit);
  decoded_field_length = field_reroute__Reject__Cause__value.RAW_decode(General__Types::BIT8_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  if (field_iEI !=  os_11) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int Redirection__Indication::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Redirection__Indication_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Redirection__Indication_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT8_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(Redirection__Indication_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(Redirection__Indication_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_reroute__Reject__Cause__value.RAW_encode(General__Types::BIT8_descr_, *myleaf.body.node.nodes[3]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1:
  if (field_ext !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(Redirection__Indication_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a::ALT_length2:
  if (field_ext !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(Redirection__Indication_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_iEI !=  os_11) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_11.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct Redirection__Indication_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a_template field_lengthIndicator;
BITSTRING_template field_reroute__Reject__Cause__value;
};

void Redirection__Indication_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_reroute__Reject__Cause__value = ANY_VALUE;
}
}
}

void Redirection__Indication_template::copy_value(const Redirection__Indication& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.reroute__Reject__Cause__value().is_bound()) {
  single_value->field_reroute__Reject__Cause__value = other_value.reroute__Reject__Cause__value();
} else {
  single_value->field_reroute__Reject__Cause__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Redirection__Indication_template::copy_template(const Redirection__Indication_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reroute__Reject__Cause__value().get_selection()) {
single_value->field_reroute__Reject__Cause__value = other_value.reroute__Reject__Cause__value();
} else {
single_value->field_reroute__Reject__Cause__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Redirection__Indication_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Redirection__Indication_template(*other_value.implication_.precondition);
implication_.implied_template = new Redirection__Indication_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSGP_Types.Redirection_Indication.");
break;
}
set_selection(other_value);
}

Redirection__Indication_template::Redirection__Indication_template()
{
}

Redirection__Indication_template::Redirection__Indication_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Redirection__Indication_template::Redirection__Indication_template(const Redirection__Indication& other_value)
{
copy_value(other_value);
}

Redirection__Indication_template::Redirection__Indication_template(const OPTIONAL<Redirection__Indication>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Redirection__Indication&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSGP_Types.Redirection_Indication from an unbound optional field.");
}
}

Redirection__Indication_template::Redirection__Indication_template(Redirection__Indication_template* p_precondition, Redirection__Indication_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Redirection__Indication_template::Redirection__Indication_template(Dynamic_Match_Interface<Redirection__Indication>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Redirection__Indication>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Redirection__Indication_template::Redirection__Indication_template(const Redirection__Indication_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Redirection__Indication_template::~Redirection__Indication_template()
{
clean_up();
}

Redirection__Indication_template& Redirection__Indication_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Redirection__Indication_template& Redirection__Indication_template::operator=(const Redirection__Indication& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Redirection__Indication_template& Redirection__Indication_template::operator=(const OPTIONAL<Redirection__Indication>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Redirection__Indication&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSGP_Types.Redirection_Indication.");
}
return *this;
}

Redirection__Indication_template& Redirection__Indication_template::operator=(const Redirection__Indication_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Redirection__Indication_template::match(const Redirection__Indication& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.reroute__Reject__Cause__value().is_bound()) return FALSE;
if(!single_value->field_reroute__Reject__Cause__value.match(other_value.reroute__Reject__Cause__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSGP_Types.Redirection_Indication.");
}
return FALSE;
}

boolean Redirection__Indication_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_reroute__Reject__Cause__value.is_bound();
}

boolean Redirection__Indication_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_reroute__Reject__Cause__value.is_value();
}

void Redirection__Indication_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Redirection__Indication Redirection__Indication_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSGP_Types.Redirection_Indication.");
Redirection__Indication ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_reroute__Reject__Cause__value.is_bound()) {
ret_val.reroute__Reject__Cause__value() = single_value->field_reroute__Reject__Cause__value.valueof();
}
return ret_val;
}

void Redirection__Indication_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSGP_Types.Redirection_Indication.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Redirection__Indication_template[list_length];
}

Redirection__Indication_template& Redirection__Indication_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSGP_Types.Redirection_Indication.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSGP_Types.Redirection_Indication.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& Redirection__Indication_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& Redirection__Indication_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @BSSGP_Types.Redirection_Indication.");
return single_value->field_iEI;
}

BITSTRING_template& Redirection__Indication_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& Redirection__Indication_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @BSSGP_Types.Redirection_Indication.");
return single_value->field_ext;
}

LIN2__2a_template& Redirection__Indication_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a_template& Redirection__Indication_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSGP_Types.Redirection_Indication.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& Redirection__Indication_template::reroute__Reject__Cause__value()
{
set_specific();
return single_value->field_reroute__Reject__Cause__value;
}

const BITSTRING_template& Redirection__Indication_template::reroute__Reject__Cause__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reroute_Reject_Cause_value of a non-specific template of type @BSSGP_Types.Redirection_Indication.");
return single_value->field_reroute__Reject__Cause__value;
}

int Redirection__Indication_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirection_Indication which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSGP_Types.Redirection_Indication containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirection_Indication containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirection_Indication containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirection_Indication containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirection_Indication containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirection_Indication containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirection_Indication containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirection_Indication containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSGP_Types.Redirection_Indication.");
  }
  return 0;
}

void Redirection__Indication_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", reroute_Reject_Cause_value := ");
single_value->field_reroute__Reject__Cause__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Redirection__Indication_template::log_match(const Redirection__Indication& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reroute__Reject__Cause__value.match(match_value.reroute__Reject__Cause__value(), legacy)){
TTCN_Logger::log_logmatch_info(".reroute_Reject_Cause_value");
single_value->field_reroute__Reject__Cause__value.log_match(match_value.reroute__Reject__Cause__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", reroute_Reject_Cause_value := ");
single_value->field_reroute__Reject__Cause__value.log_match(match_value.reroute__Reject__Cause__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Redirection__Indication_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_reroute__Reject__Cause__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSGP_Types.Redirection_Indication.");
}
}

void Redirection__Indication_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_reroute__Reject__Cause__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Redirection__Indication_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSGP_Types.Redirection_Indication.");
}
}

void Redirection__Indication_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Redirection__Indication_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @BSSGP_Types.Redirection_Indication has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) reroute__Reject__Cause__value().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reroute_Reject_Cause_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reroute__Reject__Cause__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Redirection_Indication: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Redirection__Indication_template* precondition = new Redirection__Indication_template;
    precondition->set_param(*param.get_elem(0));
    Redirection__Indication_template* implied_template = new Redirection__Indication_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Redirection__Indication_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSGP_Types.Redirection_Indication");
  }
  is_ifpresent = param.get_ifpresent();
}

void Redirection__Indication_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Redirection_Indication");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Redirection_Indication");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Redirection_Indication");
single_value->field_reroute__Reject__Cause__value.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Redirection_Indication");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSGP_Types.Redirection_Indication");
}

boolean Redirection__Indication_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Redirection__Indication_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Redirection__Completed::Redirection__Completed()
{
}

Redirection__Completed::Redirection__Completed(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a& par_lengthIndicator,
    const BITSTRING& par_outcome__value)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_outcome__value(par_outcome__value)
{
}

Redirection__Completed::Redirection__Completed(const Redirection__Completed& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSGP_Types.Redirection_Completed.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.outcome__value().is_bound()) field_outcome__value = other_value.outcome__value();
else field_outcome__value.clean_up();
}

void Redirection__Completed::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_outcome__value.clean_up();
}

const TTCN_Typedescriptor_t* Redirection__Completed::get_descriptor() const { return &Redirection__Completed_descr_; }
Redirection__Completed& Redirection__Completed::operator=(const Redirection__Completed& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSGP_Types.Redirection_Completed.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.outcome__value().is_bound()) field_outcome__value = other_value.outcome__value();
  else field_outcome__value.clean_up();
}
return *this;
}

boolean Redirection__Completed::operator==(const Redirection__Completed& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_outcome__value==other_value.field_outcome__value;
}

boolean Redirection__Completed::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_outcome__value.is_bound());
}
boolean Redirection__Completed::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_outcome__value.is_value();
}
void Redirection__Completed::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", outcome_value := ");
field_outcome__value.log();
TTCN_Logger::log_event_str(" }");
}

void Redirection__Completed::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (outcome__value().is_bound()) outcome__value().set_implicit_omit();
}

void Redirection__Completed::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @BSSGP_Types.Redirection_Completed has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) outcome__value().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "outcome_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          outcome__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Redirection_Completed: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSGP_Types.Redirection_Completed");
  }
}

void Redirection__Completed::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_outcome__value.encode_text(text_buf);
}

void Redirection__Completed::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_outcome__value.decode_text(text_buf);
}

void Redirection__Completed::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Redirection__Completed::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Redirection__Completed::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, Redirection__Completed_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(Redirection__Completed_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_0) selected_field = 0;
  else if (field_ext ==  bs_1) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, Redirection__Completed_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(Redirection__Completed_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT8_descr_.raw->forceomit);
  decoded_field_length = field_outcome__value.RAW_decode(General__Types::BIT8_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  if (field_iEI !=  os_12) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int Redirection__Completed::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Redirection__Completed_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Redirection__Completed_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT8_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(Redirection__Completed_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(Redirection__Completed_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_outcome__value.RAW_encode(General__Types::BIT8_descr_, *myleaf.body.node.nodes[3]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1:
  if (field_ext !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(Redirection__Completed_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a::ALT_length2:
  if (field_ext !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(Redirection__Completed_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_iEI !=  os_12) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_12.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct Redirection__Completed_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a_template field_lengthIndicator;
BITSTRING_template field_outcome__value;
};

void Redirection__Completed_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_outcome__value = ANY_VALUE;
}
}
}

void Redirection__Completed_template::copy_value(const Redirection__Completed& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.outcome__value().is_bound()) {
  single_value->field_outcome__value = other_value.outcome__value();
} else {
  single_value->field_outcome__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Redirection__Completed_template::copy_template(const Redirection__Completed_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.outcome__value().get_selection()) {
single_value->field_outcome__value = other_value.outcome__value();
} else {
single_value->field_outcome__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Redirection__Completed_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Redirection__Completed_template(*other_value.implication_.precondition);
implication_.implied_template = new Redirection__Completed_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSGP_Types.Redirection_Completed.");
break;
}
set_selection(other_value);
}

Redirection__Completed_template::Redirection__Completed_template()
{
}

Redirection__Completed_template::Redirection__Completed_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Redirection__Completed_template::Redirection__Completed_template(const Redirection__Completed& other_value)
{
copy_value(other_value);
}

Redirection__Completed_template::Redirection__Completed_template(const OPTIONAL<Redirection__Completed>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Redirection__Completed&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSGP_Types.Redirection_Completed from an unbound optional field.");
}
}

Redirection__Completed_template::Redirection__Completed_template(Redirection__Completed_template* p_precondition, Redirection__Completed_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Redirection__Completed_template::Redirection__Completed_template(Dynamic_Match_Interface<Redirection__Completed>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Redirection__Completed>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Redirection__Completed_template::Redirection__Completed_template(const Redirection__Completed_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Redirection__Completed_template::~Redirection__Completed_template()
{
clean_up();
}

Redirection__Completed_template& Redirection__Completed_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Redirection__Completed_template& Redirection__Completed_template::operator=(const Redirection__Completed& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Redirection__Completed_template& Redirection__Completed_template::operator=(const OPTIONAL<Redirection__Completed>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Redirection__Completed&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSGP_Types.Redirection_Completed.");
}
return *this;
}

Redirection__Completed_template& Redirection__Completed_template::operator=(const Redirection__Completed_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Redirection__Completed_template::match(const Redirection__Completed& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.outcome__value().is_bound()) return FALSE;
if(!single_value->field_outcome__value.match(other_value.outcome__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSGP_Types.Redirection_Completed.");
}
return FALSE;
}

boolean Redirection__Completed_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_outcome__value.is_bound();
}

boolean Redirection__Completed_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_outcome__value.is_value();
}

void Redirection__Completed_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Redirection__Completed Redirection__Completed_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSGP_Types.Redirection_Completed.");
Redirection__Completed ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_outcome__value.is_bound()) {
ret_val.outcome__value() = single_value->field_outcome__value.valueof();
}
return ret_val;
}

void Redirection__Completed_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSGP_Types.Redirection_Completed.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Redirection__Completed_template[list_length];
}

Redirection__Completed_template& Redirection__Completed_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSGP_Types.Redirection_Completed.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSGP_Types.Redirection_Completed.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& Redirection__Completed_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& Redirection__Completed_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @BSSGP_Types.Redirection_Completed.");
return single_value->field_iEI;
}

BITSTRING_template& Redirection__Completed_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& Redirection__Completed_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @BSSGP_Types.Redirection_Completed.");
return single_value->field_ext;
}

LIN2__2a_template& Redirection__Completed_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a_template& Redirection__Completed_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSGP_Types.Redirection_Completed.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& Redirection__Completed_template::outcome__value()
{
set_specific();
return single_value->field_outcome__value;
}

const BITSTRING_template& Redirection__Completed_template::outcome__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field outcome_value of a non-specific template of type @BSSGP_Types.Redirection_Completed.");
return single_value->field_outcome__value;
}

int Redirection__Completed_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirection_Completed which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSGP_Types.Redirection_Completed containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirection_Completed containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirection_Completed containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirection_Completed containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirection_Completed containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirection_Completed containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirection_Completed containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Redirection_Completed containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSGP_Types.Redirection_Completed.");
  }
  return 0;
}

void Redirection__Completed_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", outcome_value := ");
single_value->field_outcome__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Redirection__Completed_template::log_match(const Redirection__Completed& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_outcome__value.match(match_value.outcome__value(), legacy)){
TTCN_Logger::log_logmatch_info(".outcome_value");
single_value->field_outcome__value.log_match(match_value.outcome__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", outcome_value := ");
single_value->field_outcome__value.log_match(match_value.outcome__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Redirection__Completed_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_outcome__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSGP_Types.Redirection_Completed.");
}
}

void Redirection__Completed_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_outcome__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Redirection__Completed_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSGP_Types.Redirection_Completed.");
}
}

void Redirection__Completed_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Redirection__Completed_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @BSSGP_Types.Redirection_Completed has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) outcome__value().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "outcome_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          outcome__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Redirection_Completed: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Redirection__Completed_template* precondition = new Redirection__Completed_template;
    precondition->set_param(*param.get_elem(0));
    Redirection__Completed_template* implied_template = new Redirection__Completed_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Redirection__Completed_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSGP_Types.Redirection_Completed");
  }
  is_ifpresent = param.get_ifpresent();
}

void Redirection__Completed_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Redirection_Completed");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Redirection_Completed");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Redirection_Completed");
single_value->field_outcome__value.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Redirection_Completed");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSGP_Types.Redirection_Completed");
}

boolean Redirection__Completed_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Redirection__Completed_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Unconfirmed__Send__State__Variable::Unconfirmed__Send__State__Variable()
{
}

Unconfirmed__Send__State__Variable::Unconfirmed__Send__State__Variable(const OCTETSTRING& par_iEI,
    const BITSTRING& par_ext,
    const LIN2__2a& par_lengthIndicator,
    const BITSTRING& par_spare,
    const INTEGER& par_vU)
  :   field_iEI(par_iEI),
  field_ext(par_ext),
  field_lengthIndicator(par_lengthIndicator),
  field_spare(par_spare),
  field_vU(par_vU)
{
}

Unconfirmed__Send__State__Variable::Unconfirmed__Send__State__Variable(const Unconfirmed__Send__State__Variable& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSGP_Types.Unconfirmed_Send_State_Variable.");
if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
else field_iEI.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.vU().is_bound()) field_vU = other_value.vU();
else field_vU.clean_up();
}

void Unconfirmed__Send__State__Variable::clean_up()
{
field_iEI.clean_up();
field_ext.clean_up();
field_lengthIndicator.clean_up();
field_spare.clean_up();
field_vU.clean_up();
}

const TTCN_Typedescriptor_t* Unconfirmed__Send__State__Variable::get_descriptor() const { return &Unconfirmed__Send__State__Variable_descr_; }
Unconfirmed__Send__State__Variable& Unconfirmed__Send__State__Variable::operator=(const Unconfirmed__Send__State__Variable& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSGP_Types.Unconfirmed_Send_State_Variable.");
  if (other_value.iEI().is_bound()) field_iEI = other_value.iEI();
  else field_iEI.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.vU().is_bound()) field_vU = other_value.vU();
  else field_vU.clean_up();
}
return *this;
}

boolean Unconfirmed__Send__State__Variable::operator==(const Unconfirmed__Send__State__Variable& other_value) const
{
return field_iEI==other_value.field_iEI
  && field_ext==other_value.field_ext
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_spare==other_value.field_spare
  && field_vU==other_value.field_vU;
}

boolean Unconfirmed__Send__State__Variable::is_bound() const
{
return (field_iEI.is_bound())
  || (field_ext.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_spare.is_bound())
  || (field_vU.is_bound());
}
boolean Unconfirmed__Send__State__Variable::is_value() const
{
return field_iEI.is_value()
  && field_ext.is_value()
  && field_lengthIndicator.is_value()
  && field_spare.is_value()
  && field_vU.is_value();
}
void Unconfirmed__Send__State__Variable::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ iEI := ");
field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", vU := ");
field_vU.log();
TTCN_Logger::log_event_str(" }");
}

void Unconfirmed__Send__State__Variable::set_implicit_omit()
{
if (iEI().is_bound()) iEI().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (vU().is_bound()) vU().set_implicit_omit();
}

void Unconfirmed__Send__State__Variable::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @BSSGP_Types.Unconfirmed_Send_State_Variable has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) vU().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vU")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vU().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Unconfirmed_Send_State_Variable: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSGP_Types.Unconfirmed_Send_State_Variable");
  }
}

void Unconfirmed__Send__State__Variable::encode_text(Text_Buf& text_buf) const
{
field_iEI.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_vU.encode_text(text_buf);
}

void Unconfirmed__Send__State__Variable::decode_text(Text_Buf& text_buf)
{
field_iEI.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_vU.decode_text(text_buf);
}

void Unconfirmed__Send__State__Variable::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Unconfirmed__Send__State__Variable::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Unconfirmed__Send__State__Variable::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field2 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_iEI.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, Unconfirmed__Send__State__Variable_ext_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(Unconfirmed__Send__State__Variable_ext_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_ext ==  bs_0) selected_field = 0;
  else if (field_ext ==  bs_1) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_2_force_omit(2, force_omit, Unconfirmed__Send__State__Variable_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(Unconfirmed__Send__State__Variable_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, selected_field, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1: {
    INTEGER tmp1 = field_lengthIndicator.length1().convert_to_Integer(LIN2__2a_length1_descr_);
    field_lengthIndicator.length1() = tmp1;
    value_of_length_field2 += tmp1.get_long_long_val() * 8;
    break; }
  case LIN2__2a::ALT_length2: {
    INTEGER tmp2 = field_lengthIndicator.length2().convert_to_Integer(LIN2__2a_length2_descr_);
    field_lengthIndicator.length2() = tmp2;
    value_of_length_field2 += tmp2.get_long_long_val() * 8;
    break; }
  default:
    value_of_length_field2 = 0;
  }
  RAW_Force_Omit field_3_force_omit(3, force_omit, Unconfirmed__Send__State__Variable_spare_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(Unconfirmed__Send__State__Variable_spare_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, Unconfirmed__Send__State__Variable_vU_descr_.raw->forceomit);
  decoded_field_length = field_vU.RAW_decode(Unconfirmed__Send__State__Variable_vU_descr_, p_buf, min_of_ints(2, limit, value_of_length_field2), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field2 -= decoded_field_length;
  if (field_iEI !=  os_13) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int Unconfirmed__Send__State__Variable::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Unconfirmed__Send__State__Variable_ext_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Unconfirmed__Send__State__Variable_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, Unconfirmed__Send__State__Variable_spare_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, Unconfirmed__Send__State__Variable_vU_descr_.raw);
  encoded_length += field_iEI.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ext.RAW_encode(Unconfirmed__Send__State__Variable_ext_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lengthIndicator.RAW_encode(Unconfirmed__Send__State__Variable_lengthIndicator_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_spare.RAW_encode(Unconfirmed__Send__State__Variable_spare_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_vU.RAW_encode(Unconfirmed__Send__State__Variable_vU_descr_, *myleaf.body.node.nodes[4]);
  {
  int sel_field = 0;
  while (myleaf.body.node.nodes[2]->body.node.nodes[sel_field] == NULL) { sel_field++; }
  const TTCN_Typedescriptor_t* tmpTypeDesc = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr;
  int tmp_length = myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length;
  delete myleaf.body.node.nodes[2]->body.node.nodes[sel_field];
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field] = new RAW_enc_tree(TRUE, myleaf.body.node.nodes[2], &(myleaf.body.node.nodes[2]->curr_pos), sel_field, tmpTypeDesc->raw);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->length = tmp_length;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->coding_descr = tmpTypeDesc;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.num_of_fields = 2;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields = init_lengthto_fields_list(2);
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[2]->body.node.nodes[sel_field]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  }
  switch (field_lengthIndicator.get_selection()) {
  case LIN2__2a::ALT_length1:
  if (field_ext !=  bs_0) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_0.RAW_encode(Unconfirmed__Send__State__Variable_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case LIN2__2a::ALT_length2:
  if (field_ext !=  bs_1) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 1 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_1.RAW_encode(Unconfirmed__Send__State__Variable_ext_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  if (field_iEI !=  os_13) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_13.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct Unconfirmed__Send__State__Variable_template::single_value_struct {
OCTETSTRING_template field_iEI;
BITSTRING_template field_ext;
LIN2__2a_template field_lengthIndicator;
BITSTRING_template field_spare;
INTEGER_template field_vU;
};

void Unconfirmed__Send__State__Variable_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_iEI = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_vU = ANY_VALUE;
}
}
}

void Unconfirmed__Send__State__Variable_template::copy_value(const Unconfirmed__Send__State__Variable& other_value)
{
single_value = new single_value_struct;
if (other_value.iEI().is_bound()) {
  single_value->field_iEI = other_value.iEI();
} else {
  single_value->field_iEI.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.vU().is_bound()) {
  single_value->field_vU = other_value.vU();
} else {
  single_value->field_vU.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void Unconfirmed__Send__State__Variable_template::copy_template(const Unconfirmed__Send__State__Variable_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.iEI().get_selection()) {
single_value->field_iEI = other_value.iEI();
} else {
single_value->field_iEI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.vU().get_selection()) {
single_value->field_vU = other_value.vU();
} else {
single_value->field_vU.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Unconfirmed__Send__State__Variable_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Unconfirmed__Send__State__Variable_template(*other_value.implication_.precondition);
implication_.implied_template = new Unconfirmed__Send__State__Variable_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSGP_Types.Unconfirmed_Send_State_Variable.");
break;
}
set_selection(other_value);
}

Unconfirmed__Send__State__Variable_template::Unconfirmed__Send__State__Variable_template()
{
}

Unconfirmed__Send__State__Variable_template::Unconfirmed__Send__State__Variable_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Unconfirmed__Send__State__Variable_template::Unconfirmed__Send__State__Variable_template(const Unconfirmed__Send__State__Variable& other_value)
{
copy_value(other_value);
}

Unconfirmed__Send__State__Variable_template::Unconfirmed__Send__State__Variable_template(const OPTIONAL<Unconfirmed__Send__State__Variable>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Unconfirmed__Send__State__Variable&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSGP_Types.Unconfirmed_Send_State_Variable from an unbound optional field.");
}
}

Unconfirmed__Send__State__Variable_template::Unconfirmed__Send__State__Variable_template(Unconfirmed__Send__State__Variable_template* p_precondition, Unconfirmed__Send__State__Variable_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Unconfirmed__Send__State__Variable_template::Unconfirmed__Send__State__Variable_template(Dynamic_Match_Interface<Unconfirmed__Send__State__Variable>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Unconfirmed__Send__State__Variable>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Unconfirmed__Send__State__Variable_template::Unconfirmed__Send__State__Variable_template(const Unconfirmed__Send__State__Variable_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

Unconfirmed__Send__State__Variable_template::~Unconfirmed__Send__State__Variable_template()
{
clean_up();
}

Unconfirmed__Send__State__Variable_template& Unconfirmed__Send__State__Variable_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Unconfirmed__Send__State__Variable_template& Unconfirmed__Send__State__Variable_template::operator=(const Unconfirmed__Send__State__Variable& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Unconfirmed__Send__State__Variable_template& Unconfirmed__Send__State__Variable_template::operator=(const OPTIONAL<Unconfirmed__Send__State__Variable>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Unconfirmed__Send__State__Variable&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSGP_Types.Unconfirmed_Send_State_Variable.");
}
return *this;
}

Unconfirmed__Send__State__Variable_template& Unconfirmed__Send__State__Variable_template::operator=(const Unconfirmed__Send__State__Variable_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Unconfirmed__Send__State__Variable_template::match(const Unconfirmed__Send__State__Variable& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.iEI().is_bound()) return FALSE;
if(!single_value->field_iEI.match(other_value.iEI(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.vU().is_bound()) return FALSE;
if(!single_value->field_vU.match(other_value.vU(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSGP_Types.Unconfirmed_Send_State_Variable.");
}
return FALSE;
}

boolean Unconfirmed__Send__State__Variable_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_iEI.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_spare.is_bound()
 || single_value->field_vU.is_bound();
}

boolean Unconfirmed__Send__State__Variable_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_iEI.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_spare.is_value()
 && single_value->field_vU.is_value();
}

void Unconfirmed__Send__State__Variable_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Unconfirmed__Send__State__Variable Unconfirmed__Send__State__Variable_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSGP_Types.Unconfirmed_Send_State_Variable.");
Unconfirmed__Send__State__Variable ret_val;
if (single_value->field_iEI.is_bound()) {
ret_val.iEI() = single_value->field_iEI.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_vU.is_bound()) {
ret_val.vU() = single_value->field_vU.valueof();
}
return ret_val;
}

void Unconfirmed__Send__State__Variable_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSGP_Types.Unconfirmed_Send_State_Variable.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Unconfirmed__Send__State__Variable_template[list_length];
}

Unconfirmed__Send__State__Variable_template& Unconfirmed__Send__State__Variable_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSGP_Types.Unconfirmed_Send_State_Variable.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSGP_Types.Unconfirmed_Send_State_Variable.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& Unconfirmed__Send__State__Variable_template::iEI()
{
set_specific();
return single_value->field_iEI;
}

const OCTETSTRING_template& Unconfirmed__Send__State__Variable_template::iEI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iEI of a non-specific template of type @BSSGP_Types.Unconfirmed_Send_State_Variable.");
return single_value->field_iEI;
}

BITSTRING_template& Unconfirmed__Send__State__Variable_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& Unconfirmed__Send__State__Variable_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @BSSGP_Types.Unconfirmed_Send_State_Variable.");
return single_value->field_ext;
}

LIN2__2a_template& Unconfirmed__Send__State__Variable_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const LIN2__2a_template& Unconfirmed__Send__State__Variable_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSGP_Types.Unconfirmed_Send_State_Variable.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& Unconfirmed__Send__State__Variable_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& Unconfirmed__Send__State__Variable_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @BSSGP_Types.Unconfirmed_Send_State_Variable.");
return single_value->field_spare;
}

INTEGER_template& Unconfirmed__Send__State__Variable_template::vU()
{
set_specific();
return single_value->field_vU;
}

const INTEGER_template& Unconfirmed__Send__State__Variable_template::vU() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field vU of a non-specific template of type @BSSGP_Types.Unconfirmed_Send_State_Variable.");
return single_value->field_vU;
}

int Unconfirmed__Send__State__Variable_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Unconfirmed_Send_State_Variable which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSGP_Types.Unconfirmed_Send_State_Variable containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Unconfirmed_Send_State_Variable containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Unconfirmed_Send_State_Variable containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Unconfirmed_Send_State_Variable containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Unconfirmed_Send_State_Variable containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Unconfirmed_Send_State_Variable containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Unconfirmed_Send_State_Variable containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.Unconfirmed_Send_State_Variable containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSGP_Types.Unconfirmed_Send_State_Variable.");
  }
  return 0;
}

void Unconfirmed__Send__State__Variable_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", vU := ");
single_value->field_vU.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Unconfirmed__Send__State__Variable_template::log_match(const Unconfirmed__Send__State__Variable& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_iEI.match(match_value.iEI(), legacy)){
TTCN_Logger::log_logmatch_info(".iEI");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_vU.match(match_value.vU(), legacy)){
TTCN_Logger::log_logmatch_info(".vU");
single_value->field_vU.log_match(match_value.vU(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ iEI := ");
single_value->field_iEI.log_match(match_value.iEI(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", vU := ");
single_value->field_vU.log_match(match_value.vU(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Unconfirmed__Send__State__Variable_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_iEI.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_vU.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSGP_Types.Unconfirmed_Send_State_Variable.");
}
}

void Unconfirmed__Send__State__Variable_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_iEI.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_vU.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Unconfirmed__Send__State__Variable_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSGP_Types.Unconfirmed_Send_State_Variable.");
}
}

void Unconfirmed__Send__State__Variable_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Unconfirmed__Send__State__Variable_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @BSSGP_Types.Unconfirmed_Send_State_Variable has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) iEI().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) vU().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iEI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iEI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vU")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vU().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Unconfirmed_Send_State_Variable: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    Unconfirmed__Send__State__Variable_template* precondition = new Unconfirmed__Send__State__Variable_template;
    precondition->set_param(*param.get_elem(0));
    Unconfirmed__Send__State__Variable_template* implied_template = new Unconfirmed__Send__State__Variable_template;
    implied_template->set_param(*param.get_elem(1));
    *this = Unconfirmed__Send__State__Variable_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSGP_Types.Unconfirmed_Send_State_Variable");
  }
  is_ifpresent = param.get_ifpresent();
}

void Unconfirmed__Send__State__Variable_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_iEI.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Unconfirmed_Send_State_Variable");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Unconfirmed_Send_State_Variable");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Unconfirmed_Send_State_Variable");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Unconfirmed_Send_State_Variable");
single_value->field_vU.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Unconfirmed_Send_State_Variable");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSGP_Types.Unconfirmed_Send_State_Variable");
}

boolean Unconfirmed__Send__State__Variable_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Unconfirmed__Send__State__Variable_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RNC__Id__with__Transparent__Container__BSSGP::RNC__Id__with__Transparent__Container__BSSGP()
{
}

RNC__Id__with__Transparent__Container__BSSGP::RNC__Id__with__Transparent__Container__BSSGP(const RNC__Identifier__BSSGP& par_target__RNC__Identifier,
    const Source__to__Target__Transparent__Container& par_source__to__Target__Transparent__Container)
  :   field_target__RNC__Identifier(par_target__RNC__Identifier),
  field_source__to__Target__Transparent__Container(par_source__to__Target__Transparent__Container)
{
}

RNC__Id__with__Transparent__Container__BSSGP::RNC__Id__with__Transparent__Container__BSSGP(const RNC__Id__with__Transparent__Container__BSSGP& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP.");
if (other_value.target__RNC__Identifier().is_bound()) field_target__RNC__Identifier = other_value.target__RNC__Identifier();
else field_target__RNC__Identifier.clean_up();
if (other_value.source__to__Target__Transparent__Container().is_bound()) field_source__to__Target__Transparent__Container = other_value.source__to__Target__Transparent__Container();
else field_source__to__Target__Transparent__Container.clean_up();
}

void RNC__Id__with__Transparent__Container__BSSGP::clean_up()
{
field_target__RNC__Identifier.clean_up();
field_source__to__Target__Transparent__Container.clean_up();
}

const TTCN_Typedescriptor_t* RNC__Id__with__Transparent__Container__BSSGP::get_descriptor() const { return &RNC__Id__with__Transparent__Container__BSSGP_descr_; }
RNC__Id__with__Transparent__Container__BSSGP& RNC__Id__with__Transparent__Container__BSSGP::operator=(const RNC__Id__with__Transparent__Container__BSSGP& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP.");
  if (other_value.target__RNC__Identifier().is_bound()) field_target__RNC__Identifier = other_value.target__RNC__Identifier();
  else field_target__RNC__Identifier.clean_up();
  if (other_value.source__to__Target__Transparent__Container().is_bound()) field_source__to__Target__Transparent__Container = other_value.source__to__Target__Transparent__Container();
  else field_source__to__Target__Transparent__Container.clean_up();
}
return *this;
}

boolean RNC__Id__with__Transparent__Container__BSSGP::operator==(const RNC__Id__with__Transparent__Container__BSSGP& other_value) const
{
return field_target__RNC__Identifier==other_value.field_target__RNC__Identifier
  && field_source__to__Target__Transparent__Container==other_value.field_source__to__Target__Transparent__Container;
}

boolean RNC__Id__with__Transparent__Container__BSSGP::is_bound() const
{
return (field_target__RNC__Identifier.is_bound())
  || (field_source__to__Target__Transparent__Container.is_bound());
}
boolean RNC__Id__with__Transparent__Container__BSSGP::is_value() const
{
return field_target__RNC__Identifier.is_value()
  && field_source__to__Target__Transparent__Container.is_value();
}
void RNC__Id__with__Transparent__Container__BSSGP::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ target_RNC_Identifier := ");
field_target__RNC__Identifier.log();
TTCN_Logger::log_event_str(", source_to_Target_Transparent_Container := ");
field_source__to__Target__Transparent__Container.log();
TTCN_Logger::log_event_str(" }");
}

void RNC__Id__with__Transparent__Container__BSSGP::set_implicit_omit()
{
if (target__RNC__Identifier().is_bound()) target__RNC__Identifier().set_implicit_omit();
if (source__to__Target__Transparent__Container().is_bound()) source__to__Target__Transparent__Container().set_implicit_omit();
}

void RNC__Id__with__Transparent__Container__BSSGP::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) target__RNC__Identifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) source__to__Target__Transparent__Container().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "target_RNC_Identifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          target__RNC__Identifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "source_to_Target_Transparent_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          source__to__Target__Transparent__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP");
  }
}

void RNC__Id__with__Transparent__Container__BSSGP::encode_text(Text_Buf& text_buf) const
{
field_target__RNC__Identifier.encode_text(text_buf);
field_source__to__Target__Transparent__Container.encode_text(text_buf);
}

void RNC__Id__with__Transparent__Container__BSSGP::decode_text(Text_Buf& text_buf)
{
field_target__RNC__Identifier.decode_text(text_buf);
field_source__to__Target__Transparent__Container.decode_text(text_buf);
}

void RNC__Id__with__Transparent__Container__BSSGP::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RNC__Id__with__Transparent__Container__BSSGP::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RNC__Id__with__Transparent__Container__BSSGP::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RNC__Identifier__BSSGP_descr_.raw->forceomit);
  decoded_field_length = field_target__RNC__Identifier.RAW_decode(RNC__Identifier__BSSGP_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, Source__to__Target__Transparent__Container_descr_.raw->forceomit);
  decoded_field_length = field_source__to__Target__Transparent__Container.RAW_decode(Source__to__Target__Transparent__Container_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RNC__Id__with__Transparent__Container__BSSGP::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RNC__Identifier__BSSGP_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Source__to__Target__Transparent__Container_descr_.raw);
  encoded_length += field_target__RNC__Identifier.RAW_encode(RNC__Identifier__BSSGP_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_source__to__Target__Transparent__Container.RAW_encode(Source__to__Target__Transparent__Container_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct RNC__Id__with__Transparent__Container__BSSGP_template::single_value_struct {
RNC__Identifier__BSSGP_template field_target__RNC__Identifier;
Source__to__Target__Transparent__Container_template field_source__to__Target__Transparent__Container;
};

void RNC__Id__with__Transparent__Container__BSSGP_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_target__RNC__Identifier = ANY_VALUE;
single_value->field_source__to__Target__Transparent__Container = ANY_VALUE;
}
}
}

void RNC__Id__with__Transparent__Container__BSSGP_template::copy_value(const RNC__Id__with__Transparent__Container__BSSGP& other_value)
{
single_value = new single_value_struct;
if (other_value.target__RNC__Identifier().is_bound()) {
  single_value->field_target__RNC__Identifier = other_value.target__RNC__Identifier();
} else {
  single_value->field_target__RNC__Identifier.clean_up();
}
if (other_value.source__to__Target__Transparent__Container().is_bound()) {
  single_value->field_source__to__Target__Transparent__Container = other_value.source__to__Target__Transparent__Container();
} else {
  single_value->field_source__to__Target__Transparent__Container.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RNC__Id__with__Transparent__Container__BSSGP_template::copy_template(const RNC__Id__with__Transparent__Container__BSSGP_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.target__RNC__Identifier().get_selection()) {
single_value->field_target__RNC__Identifier = other_value.target__RNC__Identifier();
} else {
single_value->field_target__RNC__Identifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.source__to__Target__Transparent__Container().get_selection()) {
single_value->field_source__to__Target__Transparent__Container = other_value.source__to__Target__Transparent__Container();
} else {
single_value->field_source__to__Target__Transparent__Container.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RNC__Id__with__Transparent__Container__BSSGP_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RNC__Id__with__Transparent__Container__BSSGP_template(*other_value.implication_.precondition);
implication_.implied_template = new RNC__Id__with__Transparent__Container__BSSGP_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP.");
break;
}
set_selection(other_value);
}

RNC__Id__with__Transparent__Container__BSSGP_template::RNC__Id__with__Transparent__Container__BSSGP_template()
{
}

RNC__Id__with__Transparent__Container__BSSGP_template::RNC__Id__with__Transparent__Container__BSSGP_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RNC__Id__with__Transparent__Container__BSSGP_template::RNC__Id__with__Transparent__Container__BSSGP_template(const RNC__Id__with__Transparent__Container__BSSGP& other_value)
{
copy_value(other_value);
}

RNC__Id__with__Transparent__Container__BSSGP_template::RNC__Id__with__Transparent__Container__BSSGP_template(const OPTIONAL<RNC__Id__with__Transparent__Container__BSSGP>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RNC__Id__with__Transparent__Container__BSSGP&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP from an unbound optional field.");
}
}

RNC__Id__with__Transparent__Container__BSSGP_template::RNC__Id__with__Transparent__Container__BSSGP_template(RNC__Id__with__Transparent__Container__BSSGP_template* p_precondition, RNC__Id__with__Transparent__Container__BSSGP_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RNC__Id__with__Transparent__Container__BSSGP_template::RNC__Id__with__Transparent__Container__BSSGP_template(Dynamic_Match_Interface<RNC__Id__with__Transparent__Container__BSSGP>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RNC__Id__with__Transparent__Container__BSSGP>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RNC__Id__with__Transparent__Container__BSSGP_template::RNC__Id__with__Transparent__Container__BSSGP_template(const RNC__Id__with__Transparent__Container__BSSGP_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RNC__Id__with__Transparent__Container__BSSGP_template::~RNC__Id__with__Transparent__Container__BSSGP_template()
{
clean_up();
}

RNC__Id__with__Transparent__Container__BSSGP_template& RNC__Id__with__Transparent__Container__BSSGP_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RNC__Id__with__Transparent__Container__BSSGP_template& RNC__Id__with__Transparent__Container__BSSGP_template::operator=(const RNC__Id__with__Transparent__Container__BSSGP& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RNC__Id__with__Transparent__Container__BSSGP_template& RNC__Id__with__Transparent__Container__BSSGP_template::operator=(const OPTIONAL<RNC__Id__with__Transparent__Container__BSSGP>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RNC__Id__with__Transparent__Container__BSSGP&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP.");
}
return *this;
}

RNC__Id__with__Transparent__Container__BSSGP_template& RNC__Id__with__Transparent__Container__BSSGP_template::operator=(const RNC__Id__with__Transparent__Container__BSSGP_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RNC__Id__with__Transparent__Container__BSSGP_template::match(const RNC__Id__with__Transparent__Container__BSSGP& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.target__RNC__Identifier().is_bound()) return FALSE;
if(!single_value->field_target__RNC__Identifier.match(other_value.target__RNC__Identifier(), legacy))return FALSE;
if(!other_value.source__to__Target__Transparent__Container().is_bound()) return FALSE;
if(!single_value->field_source__to__Target__Transparent__Container.match(other_value.source__to__Target__Transparent__Container(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP.");
}
return FALSE;
}

boolean RNC__Id__with__Transparent__Container__BSSGP_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_target__RNC__Identifier.is_bound()
 || single_value->field_source__to__Target__Transparent__Container.is_bound();
}

boolean RNC__Id__with__Transparent__Container__BSSGP_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_target__RNC__Identifier.is_value()
 && single_value->field_source__to__Target__Transparent__Container.is_value();
}

void RNC__Id__with__Transparent__Container__BSSGP_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RNC__Id__with__Transparent__Container__BSSGP RNC__Id__with__Transparent__Container__BSSGP_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP.");
RNC__Id__with__Transparent__Container__BSSGP ret_val;
if (single_value->field_target__RNC__Identifier.is_bound()) {
ret_val.target__RNC__Identifier() = single_value->field_target__RNC__Identifier.valueof();
}
if (single_value->field_source__to__Target__Transparent__Container.is_bound()) {
ret_val.source__to__Target__Transparent__Container() = single_value->field_source__to__Target__Transparent__Container.valueof();
}
return ret_val;
}

void RNC__Id__with__Transparent__Container__BSSGP_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RNC__Id__with__Transparent__Container__BSSGP_template[list_length];
}

RNC__Id__with__Transparent__Container__BSSGP_template& RNC__Id__with__Transparent__Container__BSSGP_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP.");
return value_list.list_value[list_index];
}

RNC__Identifier__BSSGP_template& RNC__Id__with__Transparent__Container__BSSGP_template::target__RNC__Identifier()
{
set_specific();
return single_value->field_target__RNC__Identifier;
}

const RNC__Identifier__BSSGP_template& RNC__Id__with__Transparent__Container__BSSGP_template::target__RNC__Identifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field target_RNC_Identifier of a non-specific template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP.");
return single_value->field_target__RNC__Identifier;
}

Source__to__Target__Transparent__Container_template& RNC__Id__with__Transparent__Container__BSSGP_template::source__to__Target__Transparent__Container()
{
set_specific();
return single_value->field_source__to__Target__Transparent__Container;
}

const Source__to__Target__Transparent__Container_template& RNC__Id__with__Transparent__Container__BSSGP_template::source__to__Target__Transparent__Container() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field source_to_Target_Transparent_Container of a non-specific template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP.");
return single_value->field_source__to__Target__Transparent__Container;
}

int RNC__Id__with__Transparent__Container__BSSGP_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP.");
  }
  return 0;
}

void RNC__Id__with__Transparent__Container__BSSGP_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ target_RNC_Identifier := ");
single_value->field_target__RNC__Identifier.log();
TTCN_Logger::log_event_str(", source_to_Target_Transparent_Container := ");
single_value->field_source__to__Target__Transparent__Container.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RNC__Id__with__Transparent__Container__BSSGP_template::log_match(const RNC__Id__with__Transparent__Container__BSSGP& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_target__RNC__Identifier.match(match_value.target__RNC__Identifier(), legacy)){
TTCN_Logger::log_logmatch_info(".target_RNC_Identifier");
single_value->field_target__RNC__Identifier.log_match(match_value.target__RNC__Identifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_source__to__Target__Transparent__Container.match(match_value.source__to__Target__Transparent__Container(), legacy)){
TTCN_Logger::log_logmatch_info(".source_to_Target_Transparent_Container");
single_value->field_source__to__Target__Transparent__Container.log_match(match_value.source__to__Target__Transparent__Container(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ target_RNC_Identifier := ");
single_value->field_target__RNC__Identifier.log_match(match_value.target__RNC__Identifier(), legacy);
TTCN_Logger::log_event_str(", source_to_Target_Transparent_Container := ");
single_value->field_source__to__Target__Transparent__Container.log_match(match_value.source__to__Target__Transparent__Container(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RNC__Id__with__Transparent__Container__BSSGP_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_target__RNC__Identifier.encode_text(text_buf);
single_value->field_source__to__Target__Transparent__Container.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP.");
}
}

void RNC__Id__with__Transparent__Container__BSSGP_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_target__RNC__Identifier.decode_text(text_buf);
single_value->field_source__to__Target__Transparent__Container.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RNC__Id__with__Transparent__Container__BSSGP_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP.");
}
}

void RNC__Id__with__Transparent__Container__BSSGP_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RNC__Id__with__Transparent__Container__BSSGP_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) target__RNC__Identifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) source__to__Target__Transparent__Container().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "target_RNC_Identifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          target__RNC__Identifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "source_to_Target_Transparent_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          source__to__Target__Transparent__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RNC__Id__with__Transparent__Container__BSSGP_template* precondition = new RNC__Id__with__Transparent__Container__BSSGP_template;
    precondition->set_param(*param.get_elem(0));
    RNC__Id__with__Transparent__Container__BSSGP_template* implied_template = new RNC__Id__with__Transparent__Container__BSSGP_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RNC__Id__with__Transparent__Container__BSSGP_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP");
  }
  is_ifpresent = param.get_ifpresent();
}

void RNC__Id__with__Transparent__Container__BSSGP_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_target__RNC__Identifier.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP");
single_value->field_source__to__Target__Transparent__Container.check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSGP_Types.RNC_Id_with_Transparent_Container_BSSGP");
}

boolean RNC__Id__with__Transparent__Container__BSSGP_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RNC__Id__with__Transparent__Container__BSSGP_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void Cell__or__RNC__Id__with__Transparent__Container__BSSGP::copy_value(const Cell__or__RNC__Id__with__Transparent__Container__BSSGP& other_value)
{
switch (other_value.union_selection) {
case ALT_cell__Id__with__Transparent__Container:
field_cell__Id__with__Transparent__Container = new Cell__Id__with__Transparent__Container__BSSGP(*other_value.field_cell__Id__with__Transparent__Container);
break;
case ALT_rnc__Id__with__Transparent__Container:
field_rnc__Id__with__Transparent__Container = new RNC__Id__with__Transparent__Container__BSSGP(*other_value.field_rnc__Id__with__Transparent__Container);
break;
default:
TTCN_error("Assignment of an unbound union value of type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
}
union_selection = other_value.union_selection;
}

Cell__or__RNC__Id__with__Transparent__Container__BSSGP::Cell__or__RNC__Id__with__Transparent__Container__BSSGP()
{
union_selection = UNBOUND_VALUE;
}

Cell__or__RNC__Id__with__Transparent__Container__BSSGP::Cell__or__RNC__Id__with__Transparent__Container__BSSGP(const Cell__or__RNC__Id__with__Transparent__Container__BSSGP& other_value)
: Base_Type(){
copy_value(other_value);
}

Cell__or__RNC__Id__with__Transparent__Container__BSSGP::~Cell__or__RNC__Id__with__Transparent__Container__BSSGP()
{
clean_up();
}

Cell__or__RNC__Id__with__Transparent__Container__BSSGP& Cell__or__RNC__Id__with__Transparent__Container__BSSGP::operator=(const Cell__or__RNC__Id__with__Transparent__Container__BSSGP& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean Cell__or__RNC__Id__with__Transparent__Container__BSSGP::operator==(const Cell__or__RNC__Id__with__Transparent__Container__BSSGP& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_cell__Id__with__Transparent__Container:
return *field_cell__Id__with__Transparent__Container == *other_value.field_cell__Id__with__Transparent__Container;
case ALT_rnc__Id__with__Transparent__Container:
return *field_rnc__Id__with__Transparent__Container == *other_value.field_rnc__Id__with__Transparent__Container;
default:
return FALSE;
}
}

Cell__Id__with__Transparent__Container__BSSGP& Cell__or__RNC__Id__with__Transparent__Container__BSSGP::cell__Id__with__Transparent__Container()
{
if (union_selection != ALT_cell__Id__with__Transparent__Container) {
clean_up();
field_cell__Id__with__Transparent__Container = new Cell__Id__with__Transparent__Container__BSSGP;
union_selection = ALT_cell__Id__with__Transparent__Container;
}
return *field_cell__Id__with__Transparent__Container;
}

const Cell__Id__with__Transparent__Container__BSSGP& Cell__or__RNC__Id__with__Transparent__Container__BSSGP::cell__Id__with__Transparent__Container() const
{
if (union_selection != ALT_cell__Id__with__Transparent__Container) TTCN_error("Using non-selected field cell_Id_with_Transparent_Container in a value of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
return *field_cell__Id__with__Transparent__Container;
}

RNC__Id__with__Transparent__Container__BSSGP& Cell__or__RNC__Id__with__Transparent__Container__BSSGP::rnc__Id__with__Transparent__Container()
{
if (union_selection != ALT_rnc__Id__with__Transparent__Container) {
clean_up();
field_rnc__Id__with__Transparent__Container = new RNC__Id__with__Transparent__Container__BSSGP;
union_selection = ALT_rnc__Id__with__Transparent__Container;
}
return *field_rnc__Id__with__Transparent__Container;
}

const RNC__Id__with__Transparent__Container__BSSGP& Cell__or__RNC__Id__with__Transparent__Container__BSSGP::rnc__Id__with__Transparent__Container() const
{
if (union_selection != ALT_rnc__Id__with__Transparent__Container) TTCN_error("Using non-selected field rnc_Id_with_Transparent_Container in a value of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
return *field_rnc__Id__with__Transparent__Container;
}

boolean Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
return union_selection == checked_selection;
}

boolean Cell__or__RNC__Id__with__Transparent__Container__BSSGP::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean Cell__or__RNC__Id__with__Transparent__Container__BSSGP::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_cell__Id__with__Transparent__Container: return field_cell__Id__with__Transparent__Container->is_value();
case ALT_rnc__Id__with__Transparent__Container: return field_rnc__Id__with__Transparent__Container->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void Cell__or__RNC__Id__with__Transparent__Container__BSSGP::clean_up()
{
switch (union_selection) {
case ALT_cell__Id__with__Transparent__Container:
  delete field_cell__Id__with__Transparent__Container;
  break;
case ALT_rnc__Id__with__Transparent__Container:
  delete field_rnc__Id__with__Transparent__Container;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void Cell__or__RNC__Id__with__Transparent__Container__BSSGP::log() const
{
switch (union_selection) {
case ALT_cell__Id__with__Transparent__Container:
TTCN_Logger::log_event_str("{ cell_Id_with_Transparent_Container := ");
field_cell__Id__with__Transparent__Container->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_rnc__Id__with__Transparent__Container:
TTCN_Logger::log_event_str("{ rnc_Id_with_Transparent_Container := ");
field_rnc__Id__with__Transparent__Container->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void Cell__or__RNC__Id__with__Transparent__Container__BSSGP::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "cell_Id_with_Transparent_Container")) {
    cell__Id__with__Transparent__Container().set_param(*mp_last);
    if (!cell__Id__with__Transparent__Container().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "rnc_Id_with_Transparent_Container")) {
    rnc__Id__with__Transparent__Container().set_param(*mp_last);
    if (!rnc__Id__with__Transparent__Container().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.", last_name);
}

void Cell__or__RNC__Id__with__Transparent__Container__BSSGP::set_implicit_omit()
{
switch (union_selection) {
case ALT_cell__Id__with__Transparent__Container:
field_cell__Id__with__Transparent__Container->set_implicit_omit(); break;
case ALT_rnc__Id__with__Transparent__Container:
field_rnc__Id__with__Transparent__Container->set_implicit_omit(); break;
default: break;
}
}

void Cell__or__RNC__Id__with__Transparent__Container__BSSGP::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_cell__Id__with__Transparent__Container:
field_cell__Id__with__Transparent__Container->encode_text(text_buf);
break;
case ALT_rnc__Id__with__Transparent__Container:
field_rnc__Id__with__Transparent__Container->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
}
}

void Cell__or__RNC__Id__with__Transparent__Container__BSSGP::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_cell__Id__with__Transparent__Container:
cell__Id__with__Transparent__Container().decode_text(text_buf);
break;
case ALT_rnc__Id__with__Transparent__Container:
rnc__Id__with__Transparent__Container().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
}
}

void Cell__or__RNC__Id__with__Transparent__Container__BSSGP::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Cell__or__RNC__Id__with__Transparent__Container__BSSGP::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int Cell__or__RNC__Id__with__Transparent__Container__BSSGP::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, Cell__Id__with__Transparent__Container__BSSGP_descr_.raw->forceomit);
      decoded_length = cell__Id__with__Transparent__Container().RAW_decode(Cell__Id__with__Transparent__Container__BSSGP_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, RNC__Id__with__Transparent__Container__BSSGP_descr_.raw->forceomit);
      decoded_length = rnc__Id__with__Transparent__Container().RAW_decode(RNC__Id__with__Transparent__Container__BSSGP_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, Cell__Id__with__Transparent__Container__BSSGP_descr_.raw->forceomit);
      decoded_length = cell__Id__with__Transparent__Container().RAW_decode(Cell__Id__with__Transparent__Container__BSSGP_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_1_force_omit(1, force_omit, RNC__Id__with__Transparent__Container__BSSGP_descr_.raw->forceomit);
      decoded_length = rnc__Id__with__Transparent__Container().RAW_decode(RNC__Id__with__Transparent__Container__BSSGP_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_1_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int Cell__or__RNC__Id__with__Transparent__Container__BSSGP::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  memset(myleaf.body.node.nodes, 0, 2 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_cell__Id__with__Transparent__Container:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, Cell__Id__with__Transparent__Container__BSSGP_descr_.raw);
    encoded_length = field_cell__Id__with__Transparent__Container->RAW_encode(Cell__Id__with__Transparent__Container__BSSGP_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &Cell__Id__with__Transparent__Container__BSSGP_descr_;
    break;
  case ALT_rnc__Id__with__Transparent__Container:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, RNC__Id__with__Transparent__Container__BSSGP_descr_.raw);
    encoded_length = field_rnc__Id__with__Transparent__Container->RAW_encode(RNC__Id__with__Transparent__Container__BSSGP_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &RNC__Id__with__Transparent__Container__BSSGP_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::copy_value(const Cell__or__RNC__Id__with__Transparent__Container__BSSGP& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_cell__Id__with__Transparent__Container:
single_value.field_cell__Id__with__Transparent__Container = new Cell__Id__with__Transparent__Container__BSSGP_template(other_value.cell__Id__with__Transparent__Container());
break;
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_rnc__Id__with__Transparent__Container:
single_value.field_rnc__Id__with__Transparent__Container = new RNC__Id__with__Transparent__Container__BSSGP_template(other_value.rnc__Id__with__Transparent__Container());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
}
set_selection(SPECIFIC_VALUE);
}

void Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::copy_template(const Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_cell__Id__with__Transparent__Container:
single_value.field_cell__Id__with__Transparent__Container = new Cell__Id__with__Transparent__Container__BSSGP_template(*other_value.single_value.field_cell__Id__with__Transparent__Container);
break;
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_rnc__Id__with__Transparent__Container:
single_value.field_rnc__Id__with__Transparent__Container = new RNC__Id__with__Transparent__Container__BSSGP_template(*other_value.single_value.field_rnc__Id__with__Transparent__Container);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template(*other_value.implication_.precondition);
implication_.implied_template = new Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
}
set_selection(other_value);
}

Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template()
{
}

Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template(const Cell__or__RNC__Id__with__Transparent__Container__BSSGP& other_value)
{
copy_value(other_value);
}

Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template(const OPTIONAL<Cell__or__RNC__Id__with__Transparent__Container__BSSGP>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Cell__or__RNC__Id__with__Transparent__Container__BSSGP&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP from an unbound optional field.");
}
}

Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template(Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template* p_precondition, Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template(Dynamic_Match_Interface<Cell__or__RNC__Id__with__Transparent__Container__BSSGP>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Cell__or__RNC__Id__with__Transparent__Container__BSSGP>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template(const Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template& other_value)
: Base_Template(){
copy_template(other_value);
}

Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::~Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template()
{
clean_up();
}

void Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_cell__Id__with__Transparent__Container:
delete single_value.field_cell__Id__with__Transparent__Container;
break;
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_rnc__Id__with__Transparent__Container:
delete single_value.field_rnc__Id__with__Transparent__Container;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template& Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template& Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::operator=(const Cell__or__RNC__Id__with__Transparent__Container__BSSGP& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template& Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::operator=(const OPTIONAL<Cell__or__RNC__Id__with__Transparent__Container__BSSGP>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const Cell__or__RNC__Id__with__Transparent__Container__BSSGP&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
}
return *this;
}

Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template& Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::operator=(const Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::match(const Cell__or__RNC__Id__with__Transparent__Container__BSSGP& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
Cell__or__RNC__Id__with__Transparent__Container__BSSGP::union_selection_type value_selection = other_value.get_selection();
if (value_selection == Cell__or__RNC__Id__with__Transparent__Container__BSSGP::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_cell__Id__with__Transparent__Container:
return single_value.field_cell__Id__with__Transparent__Container->match(other_value.cell__Id__with__Transparent__Container(), legacy);
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_rnc__Id__with__Transparent__Container:
return single_value.field_rnc__Id__with__Transparent__Container->match(other_value.rnc__Id__with__Transparent__Container(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
}
return FALSE;
}

boolean Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_cell__Id__with__Transparent__Container:
return single_value.field_cell__Id__with__Transparent__Container->is_value();
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_rnc__Id__with__Transparent__Container:
return single_value.field_rnc__Id__with__Transparent__Container->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
}
}

Cell__or__RNC__Id__with__Transparent__Container__BSSGP Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
Cell__or__RNC__Id__with__Transparent__Container__BSSGP ret_val;
switch (single_value.union_selection) {
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_cell__Id__with__Transparent__Container:
ret_val.cell__Id__with__Transparent__Container() = single_value.field_cell__Id__with__Transparent__Container->valueof();
break;
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_rnc__Id__with__Transparent__Container:
ret_val.rnc__Id__with__Transparent__Container() = single_value.field_rnc__Id__with__Transparent__Container->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
}
return ret_val;
}

Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template& Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
return value_list.list_value[list_index];
}
void Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template[list_length];
}

Cell__Id__with__Transparent__Container__BSSGP_template& Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::cell__Id__with__Transparent__Container()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_cell__Id__with__Transparent__Container) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cell__Id__with__Transparent__Container = new Cell__Id__with__Transparent__Container__BSSGP_template(ANY_VALUE);
else single_value.field_cell__Id__with__Transparent__Container = new Cell__Id__with__Transparent__Container__BSSGP_template;
single_value.union_selection = Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_cell__Id__with__Transparent__Container;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cell__Id__with__Transparent__Container;
}

const Cell__Id__with__Transparent__Container__BSSGP_template& Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::cell__Id__with__Transparent__Container() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cell_Id_with_Transparent_Container in a non-specific template of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
if (single_value.union_selection != Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_cell__Id__with__Transparent__Container) TTCN_error("Accessing non-selected field cell_Id_with_Transparent_Container in a template of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
return *single_value.field_cell__Id__with__Transparent__Container;
}

RNC__Id__with__Transparent__Container__BSSGP_template& Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::rnc__Id__with__Transparent__Container()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_rnc__Id__with__Transparent__Container) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_rnc__Id__with__Transparent__Container = new RNC__Id__with__Transparent__Container__BSSGP_template(ANY_VALUE);
else single_value.field_rnc__Id__with__Transparent__Container = new RNC__Id__with__Transparent__Container__BSSGP_template;
single_value.union_selection = Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_rnc__Id__with__Transparent__Container;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_rnc__Id__with__Transparent__Container;
}

const RNC__Id__with__Transparent__Container__BSSGP_template& Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::rnc__Id__with__Transparent__Container() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field rnc_Id_with_Transparent_Container in a non-specific template of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
if (single_value.union_selection != Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_rnc__Id__with__Transparent__Container) TTCN_error("Accessing non-selected field rnc_Id_with_Transparent_Container in a template of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
return *single_value.field_rnc__Id__with__Transparent__Container;
}

boolean Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::ischosen(Cell__or__RNC__Id__with__Transparent__Container__BSSGP::union_selection_type checked_selection) const
{
if (checked_selection == Cell__or__RNC__Id__with__Transparent__Container__BSSGP::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == Cell__or__RNC__Id__with__Transparent__Container__BSSGP::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_cell__Id__with__Transparent__Container:
TTCN_Logger::log_event_str("{ cell_Id_with_Transparent_Container := ");
single_value.field_cell__Id__with__Transparent__Container->log();
TTCN_Logger::log_event_str(" }");
break;
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_rnc__Id__with__Transparent__Container:
TTCN_Logger::log_event_str("{ rnc_Id_with_Transparent_Container := ");
single_value.field_rnc__Id__with__Transparent__Container->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::log_match(const Cell__or__RNC__Id__with__Transparent__Container__BSSGP& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_cell__Id__with__Transparent__Container:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cell_Id_with_Transparent_Container");
single_value.field_cell__Id__with__Transparent__Container->log_match(match_value.cell__Id__with__Transparent__Container(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cell_Id_with_Transparent_Container := ");
single_value.field_cell__Id__with__Transparent__Container->log_match(match_value.cell__Id__with__Transparent__Container(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_rnc__Id__with__Transparent__Container:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".rnc_Id_with_Transparent_Container");
single_value.field_rnc__Id__with__Transparent__Container->log_match(match_value.rnc__Id__with__Transparent__Container(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ rnc_Id_with_Transparent_Container := ");
single_value.field_rnc__Id__with__Transparent__Container->log_match(match_value.rnc__Id__with__Transparent__Container(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_cell__Id__with__Transparent__Container:
single_value.field_cell__Id__with__Transparent__Container->encode_text(text_buf);
break;
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_rnc__Id__with__Transparent__Container:
single_value.field_rnc__Id__with__Transparent__Container->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
}
}

void Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = Cell__or__RNC__Id__with__Transparent__Container__BSSGP::UNBOUND_VALUE;
Cell__or__RNC__Id__with__Transparent__Container__BSSGP::union_selection_type new_selection = (Cell__or__RNC__Id__with__Transparent__Container__BSSGP::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_cell__Id__with__Transparent__Container:
single_value.field_cell__Id__with__Transparent__Container = new Cell__Id__with__Transparent__Container__BSSGP_template;
single_value.field_cell__Id__with__Transparent__Container->decode_text(text_buf);
break;
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_rnc__Id__with__Transparent__Container:
single_value.field_rnc__Id__with__Transparent__Container = new RNC__Id__with__Transparent__Container__BSSGP_template;
single_value.field_rnc__Id__with__Transparent__Container->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
}
}

boolean Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP'");
    }
    if (strcmp("cell_Id_with_Transparent_Container", param_field) == 0) {
      cell__Id__with__Transparent__Container().set_param(param);
      return;
    } else if (strcmp("rnc_Id_with_Transparent_Container", param_field) == 0) {
      rnc__Id__with__Transparent__Container().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "cell_Id_with_Transparent_Container")) {
      cell__Id__with__Transparent__Container().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "rnc_Id_with_Transparent_Container")) {
      rnc__Id__with__Transparent__Container().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template* precondition = new Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template;
    precondition->set_param(*m_p->get_elem(0));
    Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template* implied_template = new Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP");
  }
  is_ifpresent = param.get_ifpresent();
}

void Cell__or__RNC__Id__with__Transparent__Container__BSSGP_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_cell__Id__with__Transparent__Container:
single_value.field_cell__Id__with__Transparent__Container->check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP");
return;
case Cell__or__RNC__Id__with__Transparent__Container__BSSGP::ALT_rnc__Id__with__Transparent__Container:
single_value.field_rnc__Id__with__Transparent__Container->check_restriction(t_res, t_name ? t_name : "@BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSGP_Types.Cell_or_RNC_Id_with_Transparent_Container_BSSGP");
}

Cell__Id__with__Transparent__Container__BSSGP::Cell__Id__with__Transparent__Container__BSSGP()
{
}

Cell__Id__with__Transparent__Container__BSSGP::Cell__Id__with__Transparent__Container__BSSGP(const Cell__Identifier& par_target__Cell__Identifier,
    const Source__BSS__to__Target__BSS__Transparent__Container__BSSGP& par_source__BSS__to__Target__BSS__Transparent__Container)
  :   field_target__Cell__Identifier(par_target__Cell__Identifier),
  field_source__BSS__to__Target__BSS__Transparent__Container(par_source__BSS__to__Target__BSS__Transparent__Container)
{
}

Cell__Id__with__Transparent__Container__BSSGP::Cell__Id__with__Transparent__Container__BSSGP(const Cell__Id__with__Transparent__Container__BSSGP& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSGP_Types.Cell_Id_with_Transparent_Container_BSSGP.");
if (other_value.target__Cell__Identifier().is_bound()) field_target__Cell__Identifier = other_value.target__Cell__Identifier();
else field_target__Cell__Identifier.clean_up();
if (other_value.source__BSS__to__Target__BSS__Transparent__Container().is_bound()) field_source__BSS__to__Target__BSS__Transparent__Container = other_value.source__BSS__to__Target__BSS__Transparent__Container();
else field_source__BSS__to__Target__BSS__Transparent__Container.clean_up();
}

void Cell__Id__with__Transparent__Container__BSSGP::clean_up()
{
field_target__Cell__Identifier.clean_up();
field_source__BSS__to__Target__BSS__Transparent__Container.clean_up();
}

const TTCN_Typedescriptor_t* Cell__Id__with__Transparent__Container__BSSGP::get_descriptor() const { return &Cell__Id__with__Transparent__Container__BSSGP_descr_; }
Cell__Id__with__Transparent__Container__BSSGP& Cell__Id__with__Transparent__Container__BSSGP::operator=(const Cell__Id__with__Transparent__Container__BSSGP& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSGP_Types.Cell_Id_with_Transparent_Container_BSSGP.");
  if (other_value.target__Cell__Identifier().is_bound()) field_target__Cell__Identifier = other_value.target__Cell__Identifier();
  else field_target__Cell__Identifier.clean_up();
  if (other_value.source__BSS__to__Target__BSS__Transparent__Container().is_bound()) field_source__BSS__to__Target__BSS__Transparent__Container = other_value.source__BSS__to__Target__BSS__Transparent__Container();
  else field_source__BSS__to__Target__BSS__Transparent__Container.clean_up();
}
return *this;
}

boolean Cell__Id__with__Transparent__Container__BSSGP::operator==(const Cell__Id__with__Transparent__Container__BSSGP& other_value) const
{
return field_target__Cell__Identifier==other_value.field_target__Cell__Identifier
  && field_source__BSS__to__Target__BSS__Transparent__Container==other_value.field_source__BSS__to__Target__BSS__Transparent__Container;
}

boolean Cell__Id__with__Transparent__Container__BSSGP::is_bound() const
{
return (field_target__Cell__Identifier.is_bound())
  || (field_source__BSS__to__Target__BSS__Transparent__Container.is_bound());
}
boolean Cell__Id__with__Transparent__Container__BSSGP::is_value() const
{
return field_target__Cell__Identifier.is_value()
  && field_source__BSS__to__Target__BSS__Transparent__Container.is_value();
}
void Cell__Id__with__Transparent__Container__BSSGP::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ target_Cell_Identifier := ");
field_target__Cell__Identifier.log();
TTCN_Logger::log_event_str(", source_BSS_to_Target_BSS_Transparent_Container := ");
field_source__BSS__to__Target__BSS__Transparent__Container.log();
TTCN_Logger::log_event_str(" }");
}

void Cell__Id__with__Transparent__Container__BSSGP::set_implicit_omit()
{
if (target__Cell__Identifier().is_bound()) target__Cell__Identifier().set_implicit_omit();
if (source__BSS__to__Target__BSS__Transparent__Container().is_bound()) source__BSS__to__Target__BSS__Transparent__Container().set_implicit_omit();
}

void Cell__Id__with__Transparent__Container__BSSGP::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @BSSGP_Types.Cell_Id_with_Transparent_Container_BSSGP has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) target__Cell__Identifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) source__BSS__to__Target__BSS__Transparent__Container().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "target_Cell_Identifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          target__Cell__Identifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "source_BSS_to_Target_BSS_Transparent_Container")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          source__BSS__to__Target__BSS__Transparent__Container().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSGP_Types.Cell_Id_with_Transparent_Container_BSSGP: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSGP_Types.Cell_Id_with_Transparent_Container_BSSGP");
  }
}

void Cell__Id__with__Transparent__Container__BSSGP::encode_text(Text_Buf& text_buf) const
{
field_target__Cell__Identifier.encode_text(text_buf);
field_source__BSS__to__Target__BSS__Transparent__Container.encode_text(text_buf);
}

void Cell__Id__with__Transparent__Container__BSSGP::decode_text(Text_Buf& text_buf)
{
field_target__Cell__Identifier.decode_text(text_buf);
field_source__BSS_