// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 9.0.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2023 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "MobileL3_CC_Types.hh"

namespace MobileL3__CC__Types {

/* Member functions of C++ classes */

SetupContatinerCCBS__LV::SetupContatinerCCBS__LV()
{
}

SetupContatinerCCBS__LV::SetupContatinerCCBS__LV(const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_setupMessage)
  :   field_lengthIndicator(par_lengthIndicator),
  field_setupMessage(par_setupMessage)
{
}

SetupContatinerCCBS__LV::SetupContatinerCCBS__LV(const SetupContatinerCCBS__LV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.SetupContatinerCCBS_LV.");
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.setupMessage().is_bound()) field_setupMessage = other_value.setupMessage();
else field_setupMessage.clean_up();
}

void SetupContatinerCCBS__LV::clean_up()
{
field_lengthIndicator.clean_up();
field_setupMessage.clean_up();
}

const TTCN_Typedescriptor_t* SetupContatinerCCBS__LV::get_descriptor() const { return &SetupContatinerCCBS__LV_descr_; }
SetupContatinerCCBS__LV& SetupContatinerCCBS__LV::operator=(const SetupContatinerCCBS__LV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.SetupContatinerCCBS_LV.");
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.setupMessage().is_bound()) field_setupMessage = other_value.setupMessage();
  else field_setupMessage.clean_up();
}
return *this;
}

boolean SetupContatinerCCBS__LV::operator==(const SetupContatinerCCBS__LV& other_value) const
{
return field_lengthIndicator==other_value.field_lengthIndicator
  && field_setupMessage==other_value.field_setupMessage;
}

boolean SetupContatinerCCBS__LV::is_bound() const
{
return (field_lengthIndicator.is_bound())
  || (field_setupMessage.is_bound());
}
boolean SetupContatinerCCBS__LV::is_value() const
{
return field_lengthIndicator.is_value()
  && field_setupMessage.is_value();
}
void SetupContatinerCCBS__LV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", setupMessage := ");
field_setupMessage.log();
TTCN_Logger::log_event_str(" }");
}

void SetupContatinerCCBS__LV::set_implicit_omit()
{
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (setupMessage().is_bound()) setupMessage().set_implicit_omit();
}

void SetupContatinerCCBS__LV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.SetupContatinerCCBS_LV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) setupMessage().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "setupMessage")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          setupMessage().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.SetupContatinerCCBS_LV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.SetupContatinerCCBS_LV");
  }
}

void SetupContatinerCCBS__LV::encode_text(Text_Buf& text_buf) const
{
field_lengthIndicator.encode_text(text_buf);
field_setupMessage.encode_text(text_buf);
}

void SetupContatinerCCBS__LV::decode_text(Text_Buf& text_buf)
{
field_lengthIndicator.decode_text(text_buf);
field_setupMessage.decode_text(text_buf);
}

void SetupContatinerCCBS__LV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SetupContatinerCCBS__LV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SetupContatinerCCBS__LV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, SetupContatinerCCBS__LV_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(SetupContatinerCCBS__LV_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_lengthIndicator.convert_to_Integer(SetupContatinerCCBS__LV_lengthIndicator_descr_);
  field_lengthIndicator = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::OCTN_descr_.raw->forceomit);
  decoded_field_length = field_setupMessage.RAW_decode(General__Types::OCTN_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int SetupContatinerCCBS__LV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SetupContatinerCCBS__LV_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::OCTN_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &SetupContatinerCCBS__LV_lengthIndicator_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_setupMessage.RAW_encode(General__Types::OCTN_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct SetupContatinerCCBS__LV_template::single_value_struct {
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_setupMessage;
};

void SetupContatinerCCBS__LV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_setupMessage = ANY_VALUE;
}
}
}

void SetupContatinerCCBS__LV_template::copy_value(const SetupContatinerCCBS__LV& other_value)
{
single_value = new single_value_struct;
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.setupMessage().is_bound()) {
  single_value->field_setupMessage = other_value.setupMessage();
} else {
  single_value->field_setupMessage.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SetupContatinerCCBS__LV_template::copy_template(const SetupContatinerCCBS__LV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.setupMessage().get_selection()) {
single_value->field_setupMessage = other_value.setupMessage();
} else {
single_value->field_setupMessage.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SetupContatinerCCBS__LV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SetupContatinerCCBS__LV_template(*other_value.implication_.precondition);
implication_.implied_template = new SetupContatinerCCBS__LV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV.");
break;
}
set_selection(other_value);
}

SetupContatinerCCBS__LV_template::SetupContatinerCCBS__LV_template()
{
}

SetupContatinerCCBS__LV_template::SetupContatinerCCBS__LV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SetupContatinerCCBS__LV_template::SetupContatinerCCBS__LV_template(const SetupContatinerCCBS__LV& other_value)
{
copy_value(other_value);
}

SetupContatinerCCBS__LV_template::SetupContatinerCCBS__LV_template(const OPTIONAL<SetupContatinerCCBS__LV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SetupContatinerCCBS__LV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV from an unbound optional field.");
}
}

SetupContatinerCCBS__LV_template::SetupContatinerCCBS__LV_template(SetupContatinerCCBS__LV_template* p_precondition, SetupContatinerCCBS__LV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SetupContatinerCCBS__LV_template::SetupContatinerCCBS__LV_template(Dynamic_Match_Interface<SetupContatinerCCBS__LV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SetupContatinerCCBS__LV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SetupContatinerCCBS__LV_template::SetupContatinerCCBS__LV_template(const SetupContatinerCCBS__LV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SetupContatinerCCBS__LV_template::~SetupContatinerCCBS__LV_template()
{
clean_up();
}

SetupContatinerCCBS__LV_template& SetupContatinerCCBS__LV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SetupContatinerCCBS__LV_template& SetupContatinerCCBS__LV_template::operator=(const SetupContatinerCCBS__LV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SetupContatinerCCBS__LV_template& SetupContatinerCCBS__LV_template::operator=(const OPTIONAL<SetupContatinerCCBS__LV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SetupContatinerCCBS__LV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV.");
}
return *this;
}

SetupContatinerCCBS__LV_template& SetupContatinerCCBS__LV_template::operator=(const SetupContatinerCCBS__LV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SetupContatinerCCBS__LV_template::match(const SetupContatinerCCBS__LV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.setupMessage().is_bound()) return FALSE;
if(!single_value->field_setupMessage.match(other_value.setupMessage(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV.");
}
return FALSE;
}

boolean SetupContatinerCCBS__LV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_lengthIndicator.is_bound()
 || single_value->field_setupMessage.is_bound();
}

boolean SetupContatinerCCBS__LV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_lengthIndicator.is_value()
 && single_value->field_setupMessage.is_value();
}

void SetupContatinerCCBS__LV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SetupContatinerCCBS__LV SetupContatinerCCBS__LV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV.");
SetupContatinerCCBS__LV ret_val;
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_setupMessage.is_bound()) {
ret_val.setupMessage() = single_value->field_setupMessage.valueof();
}
return ret_val;
}

void SetupContatinerCCBS__LV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SetupContatinerCCBS__LV_template[list_length];
}

SetupContatinerCCBS__LV_template& SetupContatinerCCBS__LV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV.");
return value_list.list_value[list_index];
}

INTEGER_template& SetupContatinerCCBS__LV_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& SetupContatinerCCBS__LV_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& SetupContatinerCCBS__LV_template::setupMessage()
{
set_specific();
return single_value->field_setupMessage;
}

const OCTETSTRING_template& SetupContatinerCCBS__LV_template::setupMessage() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field setupMessage of a non-specific template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV.");
return single_value->field_setupMessage;
}

int SetupContatinerCCBS__LV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV.");
  }
  return 0;
}

void SetupContatinerCCBS__LV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", setupMessage := ");
single_value->field_setupMessage.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SetupContatinerCCBS__LV_template::log_match(const SetupContatinerCCBS__LV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_setupMessage.match(match_value.setupMessage(), legacy)){
TTCN_Logger::log_logmatch_info(".setupMessage");
single_value->field_setupMessage.log_match(match_value.setupMessage(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", setupMessage := ");
single_value->field_setupMessage.log_match(match_value.setupMessage(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SetupContatinerCCBS__LV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_setupMessage.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV.");
}
}

void SetupContatinerCCBS__LV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_setupMessage.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SetupContatinerCCBS__LV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV.");
}
}

void SetupContatinerCCBS__LV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SetupContatinerCCBS__LV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.SetupContatinerCCBS_LV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) setupMessage().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "setupMessage")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          setupMessage().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.SetupContatinerCCBS_LV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SetupContatinerCCBS__LV_template* precondition = new SetupContatinerCCBS__LV_template;
    precondition->set_param(*param.get_elem(0));
    SetupContatinerCCBS__LV_template* implied_template = new SetupContatinerCCBS__LV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SetupContatinerCCBS__LV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.SetupContatinerCCBS_LV");
  }
  is_ifpresent = param.get_ifpresent();
}

void SetupContatinerCCBS__LV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.SetupContatinerCCBS_LV");
single_value->field_setupMessage.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.SetupContatinerCCBS_LV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.SetupContatinerCCBS_LV");
}

boolean SetupContatinerCCBS__LV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SetupContatinerCCBS__LV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ML3__Signal::ML3__Signal()
{
}

ML3__Signal::ML3__Signal(const OCTETSTRING& par_elementIdentifier,
    const OCTETSTRING& par_signalValue)
  :   field_elementIdentifier(par_elementIdentifier),
  field_signalValue(par_signalValue)
{
}

ML3__Signal::ML3__Signal(const ML3__Signal& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.ML3_Signal.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.signalValue().is_bound()) field_signalValue = other_value.signalValue();
else field_signalValue.clean_up();
}

void ML3__Signal::clean_up()
{
field_elementIdentifier.clean_up();
field_signalValue.clean_up();
}

const TTCN_Typedescriptor_t* ML3__Signal::get_descriptor() const { return &ML3__Signal_descr_; }
ML3__Signal& ML3__Signal::operator=(const ML3__Signal& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.ML3_Signal.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.signalValue().is_bound()) field_signalValue = other_value.signalValue();
  else field_signalValue.clean_up();
}
return *this;
}

boolean ML3__Signal::operator==(const ML3__Signal& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_signalValue==other_value.field_signalValue;
}

boolean ML3__Signal::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_signalValue.is_bound());
}
boolean ML3__Signal::is_value() const
{
return field_elementIdentifier.is_value()
  && field_signalValue.is_value();
}
void ML3__Signal::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", signalValue := ");
field_signalValue.log();
TTCN_Logger::log_event_str(" }");
}

void ML3__Signal::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (signalValue().is_bound()) signalValue().set_implicit_omit();
}

void ML3__Signal::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.ML3_Signal has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) signalValue().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "signalValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          signalValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.ML3_Signal: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.ML3_Signal");
  }
}

void ML3__Signal::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_signalValue.encode_text(text_buf);
}

void ML3__Signal::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_signalValue.decode_text(text_buf);
}

void ML3__Signal::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ML3__Signal::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int ML3__Signal::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_signalValue.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int ML3__Signal::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::OCT1_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_signalValue.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct ML3__Signal_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
OCTETSTRING_template field_signalValue;
};

void ML3__Signal_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_signalValue = ANY_VALUE;
}
}
}

void ML3__Signal_template::copy_value(const ML3__Signal& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.signalValue().is_bound()) {
  single_value->field_signalValue = other_value.signalValue();
} else {
  single_value->field_signalValue.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ML3__Signal_template::copy_template(const ML3__Signal_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.signalValue().get_selection()) {
single_value->field_signalValue = other_value.signalValue();
} else {
single_value->field_signalValue.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ML3__Signal_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ML3__Signal_template(*other_value.implication_.precondition);
implication_.implied_template = new ML3__Signal_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.ML3_Signal.");
break;
}
set_selection(other_value);
}

ML3__Signal_template::ML3__Signal_template()
{
}

ML3__Signal_template::ML3__Signal_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ML3__Signal_template::ML3__Signal_template(const ML3__Signal& other_value)
{
copy_value(other_value);
}

ML3__Signal_template::ML3__Signal_template(const OPTIONAL<ML3__Signal>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ML3__Signal&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.ML3_Signal from an unbound optional field.");
}
}

ML3__Signal_template::ML3__Signal_template(ML3__Signal_template* p_precondition, ML3__Signal_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ML3__Signal_template::ML3__Signal_template(Dynamic_Match_Interface<ML3__Signal>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ML3__Signal>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ML3__Signal_template::ML3__Signal_template(const ML3__Signal_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ML3__Signal_template::~ML3__Signal_template()
{
clean_up();
}

ML3__Signal_template& ML3__Signal_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ML3__Signal_template& ML3__Signal_template::operator=(const ML3__Signal& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ML3__Signal_template& ML3__Signal_template::operator=(const OPTIONAL<ML3__Signal>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ML3__Signal&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.ML3_Signal.");
}
return *this;
}

ML3__Signal_template& ML3__Signal_template::operator=(const ML3__Signal_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ML3__Signal_template::match(const ML3__Signal& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.signalValue().is_bound()) return FALSE;
if(!single_value->field_signalValue.match(other_value.signalValue(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.ML3_Signal.");
}
return FALSE;
}

boolean ML3__Signal_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_signalValue.is_bound();
}

boolean ML3__Signal_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_signalValue.is_value();
}

void ML3__Signal_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ML3__Signal ML3__Signal_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.ML3_Signal.");
ML3__Signal ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_signalValue.is_bound()) {
ret_val.signalValue() = single_value->field_signalValue.valueof();
}
return ret_val;
}

void ML3__Signal_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.ML3_Signal.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ML3__Signal_template[list_length];
}

ML3__Signal_template& ML3__Signal_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.ML3_Signal.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.ML3_Signal.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& ML3__Signal_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& ML3__Signal_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_CC_Types.ML3_Signal.");
return single_value->field_elementIdentifier;
}

OCTETSTRING_template& ML3__Signal_template::signalValue()
{
set_specific();
return single_value->field_signalValue;
}

const OCTETSTRING_template& ML3__Signal_template::signalValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field signalValue of a non-specific template of type @MobileL3_CC_Types.ML3_Signal.");
return single_value->field_signalValue;
}

int ML3__Signal_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.ML3_Signal which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.ML3_Signal containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.ML3_Signal containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.ML3_Signal containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.ML3_Signal containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.ML3_Signal containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.ML3_Signal containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.ML3_Signal containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.ML3_Signal containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.ML3_Signal.");
  }
  return 0;
}

void ML3__Signal_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", signalValue := ");
single_value->field_signalValue.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ML3__Signal_template::log_match(const ML3__Signal& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_signalValue.match(match_value.signalValue(), legacy)){
TTCN_Logger::log_logmatch_info(".signalValue");
single_value->field_signalValue.log_match(match_value.signalValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", signalValue := ");
single_value->field_signalValue.log_match(match_value.signalValue(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ML3__Signal_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_signalValue.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.ML3_Signal.");
}
}

void ML3__Signal_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_signalValue.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ML3__Signal_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.ML3_Signal.");
}
}

void ML3__Signal_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ML3__Signal_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.ML3_Signal has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) signalValue().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "signalValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          signalValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.ML3_Signal: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ML3__Signal_template* precondition = new ML3__Signal_template;
    precondition->set_param(*param.get_elem(0));
    ML3__Signal_template* implied_template = new ML3__Signal_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ML3__Signal_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.ML3_Signal");
  }
  is_ifpresent = param.get_ifpresent();
}

void ML3__Signal_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.ML3_Signal");
single_value->field_signalValue.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.ML3_Signal");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.ML3_Signal");
}

boolean ML3__Signal_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ML3__Signal_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

User__user__LV::User__user__LV()
{
}

User__user__LV::User__user__LV(const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_user__userProtocolDiscriminator,
    const OCTETSTRING& par_user__userInformation)
  :   field_lengthIndicator(par_lengthIndicator),
  field_user__userProtocolDiscriminator(par_user__userProtocolDiscriminator),
  field_user__userInformation(par_user__userInformation)
{
}

User__user__LV::User__user__LV(const User__user__LV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.User_user_LV.");
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.user__userProtocolDiscriminator().is_bound()) field_user__userProtocolDiscriminator = other_value.user__userProtocolDiscriminator();
else field_user__userProtocolDiscriminator.clean_up();
if (other_value.user__userInformation().is_bound()) field_user__userInformation = other_value.user__userInformation();
else field_user__userInformation.clean_up();
}

void User__user__LV::clean_up()
{
field_lengthIndicator.clean_up();
field_user__userProtocolDiscriminator.clean_up();
field_user__userInformation.clean_up();
}

const TTCN_Typedescriptor_t* User__user__LV::get_descriptor() const { return &User__user__LV_descr_; }
User__user__LV& User__user__LV::operator=(const User__user__LV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.User_user_LV.");
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.user__userProtocolDiscriminator().is_bound()) field_user__userProtocolDiscriminator = other_value.user__userProtocolDiscriminator();
  else field_user__userProtocolDiscriminator.clean_up();
  if (other_value.user__userInformation().is_bound()) field_user__userInformation = other_value.user__userInformation();
  else field_user__userInformation.clean_up();
}
return *this;
}

boolean User__user__LV::operator==(const User__user__LV& other_value) const
{
return field_lengthIndicator==other_value.field_lengthIndicator
  && field_user__userProtocolDiscriminator==other_value.field_user__userProtocolDiscriminator
  && field_user__userInformation==other_value.field_user__userInformation;
}

boolean User__user__LV::is_bound() const
{
return (field_lengthIndicator.is_bound())
  || (field_user__userProtocolDiscriminator.is_bound())
  || (field_user__userInformation.is_bound());
}
boolean User__user__LV::is_value() const
{
return field_lengthIndicator.is_value()
  && field_user__userProtocolDiscriminator.is_value()
  && field_user__userInformation.is_value();
}
void User__user__LV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", user_userProtocolDiscriminator := ");
field_user__userProtocolDiscriminator.log();
TTCN_Logger::log_event_str(", user_userInformation := ");
field_user__userInformation.log();
TTCN_Logger::log_event_str(" }");
}

void User__user__LV::set_implicit_omit()
{
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (user__userProtocolDiscriminator().is_bound()) user__userProtocolDiscriminator().set_implicit_omit();
if (user__userInformation().is_bound()) user__userInformation().set_implicit_omit();
}

void User__user__LV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.User_user_LV has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) user__userProtocolDiscriminator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) user__userInformation().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_userProtocolDiscriminator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__userProtocolDiscriminator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_userInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__userInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.User_user_LV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.User_user_LV");
  }
}

void User__user__LV::encode_text(Text_Buf& text_buf) const
{
field_lengthIndicator.encode_text(text_buf);
field_user__userProtocolDiscriminator.encode_text(text_buf);
field_user__userInformation.encode_text(text_buf);
}

void User__user__LV::decode_text(Text_Buf& text_buf)
{
field_lengthIndicator.decode_text(text_buf);
field_user__userProtocolDiscriminator.decode_text(text_buf);
field_user__userInformation.decode_text(text_buf);
}

void User__user__LV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void User__user__LV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int User__user__LV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, User__user__LV_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(User__user__LV_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_lengthIndicator.convert_to_Integer(User__user__LV_lengthIndicator_descr_);
  field_lengthIndicator = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_user__userProtocolDiscriminator.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_user__userInformation.RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int User__user__LV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, User__user__LV_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, OCTETSTRING_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &User__user__LV_lengthIndicator_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_user__userProtocolDiscriminator.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_user__userInformation.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct User__user__LV_template::single_value_struct {
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_user__userProtocolDiscriminator;
OCTETSTRING_template field_user__userInformation;
};

void User__user__LV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_user__userProtocolDiscriminator = ANY_VALUE;
single_value->field_user__userInformation = ANY_VALUE;
}
}
}

void User__user__LV_template::copy_value(const User__user__LV& other_value)
{
single_value = new single_value_struct;
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.user__userProtocolDiscriminator().is_bound()) {
  single_value->field_user__userProtocolDiscriminator = other_value.user__userProtocolDiscriminator();
} else {
  single_value->field_user__userProtocolDiscriminator.clean_up();
}
if (other_value.user__userInformation().is_bound()) {
  single_value->field_user__userInformation = other_value.user__userInformation();
} else {
  single_value->field_user__userInformation.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void User__user__LV_template::copy_template(const User__user__LV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.user__userProtocolDiscriminator().get_selection()) {
single_value->field_user__userProtocolDiscriminator = other_value.user__userProtocolDiscriminator();
} else {
single_value->field_user__userProtocolDiscriminator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.user__userInformation().get_selection()) {
single_value->field_user__userInformation = other_value.user__userInformation();
} else {
single_value->field_user__userInformation.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new User__user__LV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new User__user__LV_template(*other_value.implication_.precondition);
implication_.implied_template = new User__user__LV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.User_user_LV.");
break;
}
set_selection(other_value);
}

User__user__LV_template::User__user__LV_template()
{
}

User__user__LV_template::User__user__LV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

User__user__LV_template::User__user__LV_template(const User__user__LV& other_value)
{
copy_value(other_value);
}

User__user__LV_template::User__user__LV_template(const OPTIONAL<User__user__LV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const User__user__LV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.User_user_LV from an unbound optional field.");
}
}

User__user__LV_template::User__user__LV_template(User__user__LV_template* p_precondition, User__user__LV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

User__user__LV_template::User__user__LV_template(Dynamic_Match_Interface<User__user__LV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<User__user__LV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

User__user__LV_template::User__user__LV_template(const User__user__LV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

User__user__LV_template::~User__user__LV_template()
{
clean_up();
}

User__user__LV_template& User__user__LV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

User__user__LV_template& User__user__LV_template::operator=(const User__user__LV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

User__user__LV_template& User__user__LV_template::operator=(const OPTIONAL<User__user__LV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const User__user__LV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.User_user_LV.");
}
return *this;
}

User__user__LV_template& User__user__LV_template::operator=(const User__user__LV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean User__user__LV_template::match(const User__user__LV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.user__userProtocolDiscriminator().is_bound()) return FALSE;
if(!single_value->field_user__userProtocolDiscriminator.match(other_value.user__userProtocolDiscriminator(), legacy))return FALSE;
if(!other_value.user__userInformation().is_bound()) return FALSE;
if(!single_value->field_user__userInformation.match(other_value.user__userInformation(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.User_user_LV.");
}
return FALSE;
}

boolean User__user__LV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_lengthIndicator.is_bound()
 || single_value->field_user__userProtocolDiscriminator.is_bound()
 || single_value->field_user__userInformation.is_bound();
}

boolean User__user__LV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_lengthIndicator.is_value()
 && single_value->field_user__userProtocolDiscriminator.is_value()
 && single_value->field_user__userInformation.is_value();
}

void User__user__LV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

User__user__LV User__user__LV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.User_user_LV.");
User__user__LV ret_val;
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_user__userProtocolDiscriminator.is_bound()) {
ret_val.user__userProtocolDiscriminator() = single_value->field_user__userProtocolDiscriminator.valueof();
}
if (single_value->field_user__userInformation.is_bound()) {
ret_val.user__userInformation() = single_value->field_user__userInformation.valueof();
}
return ret_val;
}

void User__user__LV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.User_user_LV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new User__user__LV_template[list_length];
}

User__user__LV_template& User__user__LV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.User_user_LV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.User_user_LV.");
return value_list.list_value[list_index];
}

INTEGER_template& User__user__LV_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& User__user__LV_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_CC_Types.User_user_LV.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& User__user__LV_template::user__userProtocolDiscriminator()
{
set_specific();
return single_value->field_user__userProtocolDiscriminator;
}

const OCTETSTRING_template& User__user__LV_template::user__userProtocolDiscriminator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field user_userProtocolDiscriminator of a non-specific template of type @MobileL3_CC_Types.User_user_LV.");
return single_value->field_user__userProtocolDiscriminator;
}

OCTETSTRING_template& User__user__LV_template::user__userInformation()
{
set_specific();
return single_value->field_user__userInformation;
}

const OCTETSTRING_template& User__user__LV_template::user__userInformation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field user_userInformation of a non-specific template of type @MobileL3_CC_Types.User_user_LV.");
return single_value->field_user__userInformation;
}

int User__user__LV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_user_LV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_user_LV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_user_LV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_user_LV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_user_LV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_user_LV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_user_LV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_user_LV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_user_LV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.User_user_LV.");
  }
  return 0;
}

void User__user__LV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", user_userProtocolDiscriminator := ");
single_value->field_user__userProtocolDiscriminator.log();
TTCN_Logger::log_event_str(", user_userInformation := ");
single_value->field_user__userInformation.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void User__user__LV_template::log_match(const User__user__LV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_user__userProtocolDiscriminator.match(match_value.user__userProtocolDiscriminator(), legacy)){
TTCN_Logger::log_logmatch_info(".user_userProtocolDiscriminator");
single_value->field_user__userProtocolDiscriminator.log_match(match_value.user__userProtocolDiscriminator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_user__userInformation.match(match_value.user__userInformation(), legacy)){
TTCN_Logger::log_logmatch_info(".user_userInformation");
single_value->field_user__userInformation.log_match(match_value.user__userInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", user_userProtocolDiscriminator := ");
single_value->field_user__userProtocolDiscriminator.log_match(match_value.user__userProtocolDiscriminator(), legacy);
TTCN_Logger::log_event_str(", user_userInformation := ");
single_value->field_user__userInformation.log_match(match_value.user__userInformation(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void User__user__LV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_user__userProtocolDiscriminator.encode_text(text_buf);
single_value->field_user__userInformation.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.User_user_LV.");
}
}

void User__user__LV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_user__userProtocolDiscriminator.decode_text(text_buf);
single_value->field_user__userInformation.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new User__user__LV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.User_user_LV.");
}
}

void User__user__LV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    User__user__LV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.User_user_LV has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) user__userProtocolDiscriminator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) user__userInformation().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_userProtocolDiscriminator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__userProtocolDiscriminator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_userInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__userInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.User_user_LV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    User__user__LV_template* precondition = new User__user__LV_template;
    precondition->set_param(*param.get_elem(0));
    User__user__LV_template* implied_template = new User__user__LV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = User__user__LV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.User_user_LV");
  }
  is_ifpresent = param.get_ifpresent();
}

void User__user__LV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.User_user_LV");
single_value->field_user__userProtocolDiscriminator.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.User_user_LV");
single_value->field_user__userInformation.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.User_user_LV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.User_user_LV");
}

boolean User__user__LV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean User__user__LV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

User__user__TLV::User__user__TLV()
{
}

User__user__TLV::User__user__TLV(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_user__userProtocolDiscriminator,
    const OCTETSTRING& par_user__userInformation)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_user__userProtocolDiscriminator(par_user__userProtocolDiscriminator),
  field_user__userInformation(par_user__userInformation)
{
}

User__user__TLV::User__user__TLV(const User__user__TLV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.User_user_TLV.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.user__userProtocolDiscriminator().is_bound()) field_user__userProtocolDiscriminator = other_value.user__userProtocolDiscriminator();
else field_user__userProtocolDiscriminator.clean_up();
if (other_value.user__userInformation().is_bound()) field_user__userInformation = other_value.user__userInformation();
else field_user__userInformation.clean_up();
}

void User__user__TLV::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_user__userProtocolDiscriminator.clean_up();
field_user__userInformation.clean_up();
}

const TTCN_Typedescriptor_t* User__user__TLV::get_descriptor() const { return &User__user__TLV_descr_; }
User__user__TLV& User__user__TLV::operator=(const User__user__TLV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.User_user_TLV.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.user__userProtocolDiscriminator().is_bound()) field_user__userProtocolDiscriminator = other_value.user__userProtocolDiscriminator();
  else field_user__userProtocolDiscriminator.clean_up();
  if (other_value.user__userInformation().is_bound()) field_user__userInformation = other_value.user__userInformation();
  else field_user__userInformation.clean_up();
}
return *this;
}

boolean User__user__TLV::operator==(const User__user__TLV& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_user__userProtocolDiscriminator==other_value.field_user__userProtocolDiscriminator
  && field_user__userInformation==other_value.field_user__userInformation;
}

boolean User__user__TLV::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_user__userProtocolDiscriminator.is_bound())
  || (field_user__userInformation.is_bound());
}
boolean User__user__TLV::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_user__userProtocolDiscriminator.is_value()
  && field_user__userInformation.is_value();
}
void User__user__TLV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", user_userProtocolDiscriminator := ");
field_user__userProtocolDiscriminator.log();
TTCN_Logger::log_event_str(", user_userInformation := ");
field_user__userInformation.log();
TTCN_Logger::log_event_str(" }");
}

void User__user__TLV::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (user__userProtocolDiscriminator().is_bound()) user__userProtocolDiscriminator().set_implicit_omit();
if (user__userInformation().is_bound()) user__userInformation().set_implicit_omit();
}

void User__user__TLV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.User_user_TLV has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) user__userProtocolDiscriminator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) user__userInformation().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_userProtocolDiscriminator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__userProtocolDiscriminator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_userInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__userInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.User_user_TLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.User_user_TLV");
  }
}

void User__user__TLV::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_user__userProtocolDiscriminator.encode_text(text_buf);
field_user__userInformation.encode_text(text_buf);
}

void User__user__TLV::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_user__userProtocolDiscriminator.decode_text(text_buf);
field_user__userInformation.decode_text(text_buf);
}

void User__user__TLV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void User__user__TLV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int User__user__TLV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, User__user__TLV_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(User__user__TLV_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(User__user__TLV_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_user__userProtocolDiscriminator.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_user__userInformation.RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int User__user__TLV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, User__user__TLV_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, OCTETSTRING_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &User__user__TLV_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  encoded_length += field_user__userProtocolDiscriminator.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_user__userInformation.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct User__user__TLV_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_user__userProtocolDiscriminator;
OCTETSTRING_template field_user__userInformation;
};

void User__user__TLV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_user__userProtocolDiscriminator = ANY_VALUE;
single_value->field_user__userInformation = ANY_VALUE;
}
}
}

void User__user__TLV_template::copy_value(const User__user__TLV& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.user__userProtocolDiscriminator().is_bound()) {
  single_value->field_user__userProtocolDiscriminator = other_value.user__userProtocolDiscriminator();
} else {
  single_value->field_user__userProtocolDiscriminator.clean_up();
}
if (other_value.user__userInformation().is_bound()) {
  single_value->field_user__userInformation = other_value.user__userInformation();
} else {
  single_value->field_user__userInformation.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void User__user__TLV_template::copy_template(const User__user__TLV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.user__userProtocolDiscriminator().get_selection()) {
single_value->field_user__userProtocolDiscriminator = other_value.user__userProtocolDiscriminator();
} else {
single_value->field_user__userProtocolDiscriminator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.user__userInformation().get_selection()) {
single_value->field_user__userInformation = other_value.user__userInformation();
} else {
single_value->field_user__userInformation.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new User__user__TLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new User__user__TLV_template(*other_value.implication_.precondition);
implication_.implied_template = new User__user__TLV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.User_user_TLV.");
break;
}
set_selection(other_value);
}

User__user__TLV_template::User__user__TLV_template()
{
}

User__user__TLV_template::User__user__TLV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

User__user__TLV_template::User__user__TLV_template(const User__user__TLV& other_value)
{
copy_value(other_value);
}

User__user__TLV_template::User__user__TLV_template(const OPTIONAL<User__user__TLV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const User__user__TLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.User_user_TLV from an unbound optional field.");
}
}

User__user__TLV_template::User__user__TLV_template(User__user__TLV_template* p_precondition, User__user__TLV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

User__user__TLV_template::User__user__TLV_template(Dynamic_Match_Interface<User__user__TLV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<User__user__TLV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

User__user__TLV_template::User__user__TLV_template(const User__user__TLV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

User__user__TLV_template::~User__user__TLV_template()
{
clean_up();
}

User__user__TLV_template& User__user__TLV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

User__user__TLV_template& User__user__TLV_template::operator=(const User__user__TLV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

User__user__TLV_template& User__user__TLV_template::operator=(const OPTIONAL<User__user__TLV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const User__user__TLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.User_user_TLV.");
}
return *this;
}

User__user__TLV_template& User__user__TLV_template::operator=(const User__user__TLV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean User__user__TLV_template::match(const User__user__TLV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.user__userProtocolDiscriminator().is_bound()) return FALSE;
if(!single_value->field_user__userProtocolDiscriminator.match(other_value.user__userProtocolDiscriminator(), legacy))return FALSE;
if(!other_value.user__userInformation().is_bound()) return FALSE;
if(!single_value->field_user__userInformation.match(other_value.user__userInformation(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.User_user_TLV.");
}
return FALSE;
}

boolean User__user__TLV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_user__userProtocolDiscriminator.is_bound()
 || single_value->field_user__userInformation.is_bound();
}

boolean User__user__TLV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_user__userProtocolDiscriminator.is_value()
 && single_value->field_user__userInformation.is_value();
}

void User__user__TLV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

User__user__TLV User__user__TLV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.User_user_TLV.");
User__user__TLV ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_user__userProtocolDiscriminator.is_bound()) {
ret_val.user__userProtocolDiscriminator() = single_value->field_user__userProtocolDiscriminator.valueof();
}
if (single_value->field_user__userInformation.is_bound()) {
ret_val.user__userInformation() = single_value->field_user__userInformation.valueof();
}
return ret_val;
}

void User__user__TLV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.User_user_TLV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new User__user__TLV_template[list_length];
}

User__user__TLV_template& User__user__TLV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.User_user_TLV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.User_user_TLV.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& User__user__TLV_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& User__user__TLV_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_CC_Types.User_user_TLV.");
return single_value->field_elementIdentifier;
}

INTEGER_template& User__user__TLV_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& User__user__TLV_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_CC_Types.User_user_TLV.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& User__user__TLV_template::user__userProtocolDiscriminator()
{
set_specific();
return single_value->field_user__userProtocolDiscriminator;
}

const OCTETSTRING_template& User__user__TLV_template::user__userProtocolDiscriminator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field user_userProtocolDiscriminator of a non-specific template of type @MobileL3_CC_Types.User_user_TLV.");
return single_value->field_user__userProtocolDiscriminator;
}

OCTETSTRING_template& User__user__TLV_template::user__userInformation()
{
set_specific();
return single_value->field_user__userInformation;
}

const OCTETSTRING_template& User__user__TLV_template::user__userInformation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field user_userInformation of a non-specific template of type @MobileL3_CC_Types.User_user_TLV.");
return single_value->field_user__userInformation;
}

int User__user__TLV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_user_TLV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_user_TLV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_user_TLV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_user_TLV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_user_TLV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_user_TLV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_user_TLV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_user_TLV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_user_TLV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.User_user_TLV.");
  }
  return 0;
}

void User__user__TLV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", user_userProtocolDiscriminator := ");
single_value->field_user__userProtocolDiscriminator.log();
TTCN_Logger::log_event_str(", user_userInformation := ");
single_value->field_user__userInformation.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void User__user__TLV_template::log_match(const User__user__TLV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_user__userProtocolDiscriminator.match(match_value.user__userProtocolDiscriminator(), legacy)){
TTCN_Logger::log_logmatch_info(".user_userProtocolDiscriminator");
single_value->field_user__userProtocolDiscriminator.log_match(match_value.user__userProtocolDiscriminator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_user__userInformation.match(match_value.user__userInformation(), legacy)){
TTCN_Logger::log_logmatch_info(".user_userInformation");
single_value->field_user__userInformation.log_match(match_value.user__userInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", user_userProtocolDiscriminator := ");
single_value->field_user__userProtocolDiscriminator.log_match(match_value.user__userProtocolDiscriminator(), legacy);
TTCN_Logger::log_event_str(", user_userInformation := ");
single_value->field_user__userInformation.log_match(match_value.user__userInformation(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void User__user__TLV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_user__userProtocolDiscriminator.encode_text(text_buf);
single_value->field_user__userInformation.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.User_user_TLV.");
}
}

void User__user__TLV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_user__userProtocolDiscriminator.decode_text(text_buf);
single_value->field_user__userInformation.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new User__user__TLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.User_user_TLV.");
}
}

void User__user__TLV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    User__user__TLV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.User_user_TLV has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) user__userProtocolDiscriminator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) user__userInformation().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_userProtocolDiscriminator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__userProtocolDiscriminator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_userInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__userInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.User_user_TLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    User__user__TLV_template* precondition = new User__user__TLV_template;
    precondition->set_param(*param.get_elem(0));
    User__user__TLV_template* implied_template = new User__user__TLV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = User__user__TLV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.User_user_TLV");
  }
  is_ifpresent = param.get_ifpresent();
}

void User__user__TLV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.User_user_TLV");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.User_user_TLV");
single_value->field_user__userProtocolDiscriminator.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.User_user_TLV");
single_value->field_user__userInformation.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.User_user_TLV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.User_user_TLV");
}

boolean User__user__TLV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean User__user__TLV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

User__userShort::User__userShort()
{
}

User__userShort::User__userShort(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_user__userProtocolDiscriminator,
    const OCTETSTRING& par_user__userInformation)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_user__userProtocolDiscriminator(par_user__userProtocolDiscriminator),
  field_user__userInformation(par_user__userInformation)
{
}

User__userShort::User__userShort(const User__userShort& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.User_userShort.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.user__userProtocolDiscriminator().is_bound()) field_user__userProtocolDiscriminator = other_value.user__userProtocolDiscriminator();
else field_user__userProtocolDiscriminator.clean_up();
if (other_value.user__userInformation().is_bound()) field_user__userInformation = other_value.user__userInformation();
else field_user__userInformation.clean_up();
}

void User__userShort::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_user__userProtocolDiscriminator.clean_up();
field_user__userInformation.clean_up();
}

const TTCN_Typedescriptor_t* User__userShort::get_descriptor() const { return &User__userShort_descr_; }
User__userShort& User__userShort::operator=(const User__userShort& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.User_userShort.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.user__userProtocolDiscriminator().is_bound()) field_user__userProtocolDiscriminator = other_value.user__userProtocolDiscriminator();
  else field_user__userProtocolDiscriminator.clean_up();
  if (other_value.user__userInformation().is_bound()) field_user__userInformation = other_value.user__userInformation();
  else field_user__userInformation.clean_up();
}
return *this;
}

boolean User__userShort::operator==(const User__userShort& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_user__userProtocolDiscriminator==other_value.field_user__userProtocolDiscriminator
  && field_user__userInformation==other_value.field_user__userInformation;
}

boolean User__userShort::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_user__userProtocolDiscriminator.is_bound())
  || (field_user__userInformation.is_bound());
}
boolean User__userShort::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_user__userProtocolDiscriminator.is_value()
  && field_user__userInformation.is_value();
}
void User__userShort::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", user_userProtocolDiscriminator := ");
field_user__userProtocolDiscriminator.log();
TTCN_Logger::log_event_str(", user_userInformation := ");
field_user__userInformation.log();
TTCN_Logger::log_event_str(" }");
}

void User__userShort::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (user__userProtocolDiscriminator().is_bound()) user__userProtocolDiscriminator().set_implicit_omit();
if (user__userInformation().is_bound()) user__userInformation().set_implicit_omit();
}

void User__userShort::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.User_userShort has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) user__userProtocolDiscriminator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) user__userInformation().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_userProtocolDiscriminator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__userProtocolDiscriminator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_userInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__userInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.User_userShort: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.User_userShort");
  }
}

void User__userShort::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_user__userProtocolDiscriminator.encode_text(text_buf);
field_user__userInformation.encode_text(text_buf);
}

void User__userShort::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_user__userProtocolDiscriminator.decode_text(text_buf);
field_user__userInformation.decode_text(text_buf);
}

void User__userShort::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void User__userShort::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int User__userShort::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, User__userShort_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(User__userShort_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(User__userShort_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_user__userProtocolDiscriminator.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_user__userInformation.RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int User__userShort::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, User__userShort_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, OCTETSTRING_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &User__userShort_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  encoded_length += field_user__userProtocolDiscriminator.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_user__userInformation.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct User__userShort_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_user__userProtocolDiscriminator;
OCTETSTRING_template field_user__userInformation;
};

void User__userShort_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_user__userProtocolDiscriminator = ANY_VALUE;
single_value->field_user__userInformation = ANY_VALUE;
}
}
}

void User__userShort_template::copy_value(const User__userShort& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.user__userProtocolDiscriminator().is_bound()) {
  single_value->field_user__userProtocolDiscriminator = other_value.user__userProtocolDiscriminator();
} else {
  single_value->field_user__userProtocolDiscriminator.clean_up();
}
if (other_value.user__userInformation().is_bound()) {
  single_value->field_user__userInformation = other_value.user__userInformation();
} else {
  single_value->field_user__userInformation.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void User__userShort_template::copy_template(const User__userShort_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.user__userProtocolDiscriminator().get_selection()) {
single_value->field_user__userProtocolDiscriminator = other_value.user__userProtocolDiscriminator();
} else {
single_value->field_user__userProtocolDiscriminator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.user__userInformation().get_selection()) {
single_value->field_user__userInformation = other_value.user__userInformation();
} else {
single_value->field_user__userInformation.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new User__userShort_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new User__userShort_template(*other_value.implication_.precondition);
implication_.implied_template = new User__userShort_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.User_userShort.");
break;
}
set_selection(other_value);
}

User__userShort_template::User__userShort_template()
{
}

User__userShort_template::User__userShort_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

User__userShort_template::User__userShort_template(const User__userShort& other_value)
{
copy_value(other_value);
}

User__userShort_template::User__userShort_template(const OPTIONAL<User__userShort>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const User__userShort&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.User_userShort from an unbound optional field.");
}
}

User__userShort_template::User__userShort_template(User__userShort_template* p_precondition, User__userShort_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

User__userShort_template::User__userShort_template(Dynamic_Match_Interface<User__userShort>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<User__userShort>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

User__userShort_template::User__userShort_template(const User__userShort_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

User__userShort_template::~User__userShort_template()
{
clean_up();
}

User__userShort_template& User__userShort_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

User__userShort_template& User__userShort_template::operator=(const User__userShort& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

User__userShort_template& User__userShort_template::operator=(const OPTIONAL<User__userShort>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const User__userShort&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.User_userShort.");
}
return *this;
}

User__userShort_template& User__userShort_template::operator=(const User__userShort_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean User__userShort_template::match(const User__userShort& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.user__userProtocolDiscriminator().is_bound()) return FALSE;
if(!single_value->field_user__userProtocolDiscriminator.match(other_value.user__userProtocolDiscriminator(), legacy))return FALSE;
if(!other_value.user__userInformation().is_bound()) return FALSE;
if(!single_value->field_user__userInformation.match(other_value.user__userInformation(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.User_userShort.");
}
return FALSE;
}

boolean User__userShort_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_user__userProtocolDiscriminator.is_bound()
 || single_value->field_user__userInformation.is_bound();
}

boolean User__userShort_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_user__userProtocolDiscriminator.is_value()
 && single_value->field_user__userInformation.is_value();
}

void User__userShort_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

User__userShort User__userShort_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.User_userShort.");
User__userShort ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_user__userProtocolDiscriminator.is_bound()) {
ret_val.user__userProtocolDiscriminator() = single_value->field_user__userProtocolDiscriminator.valueof();
}
if (single_value->field_user__userInformation.is_bound()) {
ret_val.user__userInformation() = single_value->field_user__userInformation.valueof();
}
return ret_val;
}

void User__userShort_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.User_userShort.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new User__userShort_template[list_length];
}

User__userShort_template& User__userShort_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.User_userShort.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.User_userShort.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& User__userShort_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& User__userShort_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_CC_Types.User_userShort.");
return single_value->field_elementIdentifier;
}

INTEGER_template& User__userShort_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& User__userShort_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_CC_Types.User_userShort.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& User__userShort_template::user__userProtocolDiscriminator()
{
set_specific();
return single_value->field_user__userProtocolDiscriminator;
}

const OCTETSTRING_template& User__userShort_template::user__userProtocolDiscriminator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field user_userProtocolDiscriminator of a non-specific template of type @MobileL3_CC_Types.User_userShort.");
return single_value->field_user__userProtocolDiscriminator;
}

OCTETSTRING_template& User__userShort_template::user__userInformation()
{
set_specific();
return single_value->field_user__userInformation;
}

const OCTETSTRING_template& User__userShort_template::user__userInformation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field user_userInformation of a non-specific template of type @MobileL3_CC_Types.User_userShort.");
return single_value->field_user__userInformation;
}

int User__userShort_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_userShort which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_userShort containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_userShort containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_userShort containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_userShort containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_userShort containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_userShort containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_userShort containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.User_userShort containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.User_userShort.");
  }
  return 0;
}

void User__userShort_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", user_userProtocolDiscriminator := ");
single_value->field_user__userProtocolDiscriminator.log();
TTCN_Logger::log_event_str(", user_userInformation := ");
single_value->field_user__userInformation.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void User__userShort_template::log_match(const User__userShort& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_user__userProtocolDiscriminator.match(match_value.user__userProtocolDiscriminator(), legacy)){
TTCN_Logger::log_logmatch_info(".user_userProtocolDiscriminator");
single_value->field_user__userProtocolDiscriminator.log_match(match_value.user__userProtocolDiscriminator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_user__userInformation.match(match_value.user__userInformation(), legacy)){
TTCN_Logger::log_logmatch_info(".user_userInformation");
single_value->field_user__userInformation.log_match(match_value.user__userInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", user_userProtocolDiscriminator := ");
single_value->field_user__userProtocolDiscriminator.log_match(match_value.user__userProtocolDiscriminator(), legacy);
TTCN_Logger::log_event_str(", user_userInformation := ");
single_value->field_user__userInformation.log_match(match_value.user__userInformation(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void User__userShort_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_user__userProtocolDiscriminator.encode_text(text_buf);
single_value->field_user__userInformation.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.User_userShort.");
}
}

void User__userShort_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_user__userProtocolDiscriminator.decode_text(text_buf);
single_value->field_user__userInformation.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new User__userShort_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.User_userShort.");
}
}

void User__userShort_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    User__userShort_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.User_userShort has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) user__userProtocolDiscriminator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) user__userInformation().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_userProtocolDiscriminator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__userProtocolDiscriminator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_userInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__userInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.User_userShort: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    User__userShort_template* precondition = new User__userShort_template;
    precondition->set_param(*param.get_elem(0));
    User__userShort_template* implied_template = new User__userShort_template;
    implied_template->set_param(*param.get_elem(1));
    *this = User__userShort_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.User_userShort");
  }
  is_ifpresent = param.get_ifpresent();
}

void User__userShort_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.User_userShort");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.User_userShort");
single_value->field_user__userProtocolDiscriminator.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.User_userShort");
single_value->field_user__userInformation.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.User_userShort");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.User_userShort");
}

boolean User__userShort_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean User__userShort_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

AlertingPattern::AlertingPattern()
{
}

AlertingPattern::AlertingPattern(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const BITSTRING& par_alertingPattern__FIELD,
    const BITSTRING& par_spare)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_alertingPattern__FIELD(par_alertingPattern__FIELD),
  field_spare(par_spare)
{
}

AlertingPattern::AlertingPattern(const AlertingPattern& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.AlertingPattern.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.alertingPattern__FIELD().is_bound()) field_alertingPattern__FIELD = other_value.alertingPattern__FIELD();
else field_alertingPattern__FIELD.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void AlertingPattern::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_alertingPattern__FIELD.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* AlertingPattern::get_descriptor() const { return &AlertingPattern_descr_; }
AlertingPattern& AlertingPattern::operator=(const AlertingPattern& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.AlertingPattern.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.alertingPattern__FIELD().is_bound()) field_alertingPattern__FIELD = other_value.alertingPattern__FIELD();
  else field_alertingPattern__FIELD.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean AlertingPattern::operator==(const AlertingPattern& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_alertingPattern__FIELD==other_value.field_alertingPattern__FIELD
  && field_spare==other_value.field_spare;
}

boolean AlertingPattern::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_alertingPattern__FIELD.is_bound())
  || (field_spare.is_bound());
}
boolean AlertingPattern::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_alertingPattern__FIELD.is_value()
  && field_spare.is_value();
}
void AlertingPattern::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", alertingPattern_FIELD := ");
field_alertingPattern__FIELD.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void AlertingPattern::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (alertingPattern__FIELD().is_bound()) alertingPattern__FIELD().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void AlertingPattern::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.AlertingPattern has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) alertingPattern__FIELD().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "alertingPattern_FIELD")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          alertingPattern__FIELD().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.AlertingPattern: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.AlertingPattern");
  }
}

void AlertingPattern::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_alertingPattern__FIELD.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void AlertingPattern::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_alertingPattern__FIELD.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void AlertingPattern::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void AlertingPattern::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int AlertingPattern::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, AlertingPattern_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(AlertingPattern_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(AlertingPattern_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_alertingPattern__FIELD.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int AlertingPattern::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, AlertingPattern_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT4_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &AlertingPattern_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 2;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(2);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  encoded_length += field_alertingPattern__FIELD.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct AlertingPattern_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
BITSTRING_template field_alertingPattern__FIELD;
BITSTRING_template field_spare;
};

void AlertingPattern_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_alertingPattern__FIELD = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void AlertingPattern_template::copy_value(const AlertingPattern& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.alertingPattern__FIELD().is_bound()) {
  single_value->field_alertingPattern__FIELD = other_value.alertingPattern__FIELD();
} else {
  single_value->field_alertingPattern__FIELD.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void AlertingPattern_template::copy_template(const AlertingPattern_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.alertingPattern__FIELD().get_selection()) {
single_value->field_alertingPattern__FIELD = other_value.alertingPattern__FIELD();
} else {
single_value->field_alertingPattern__FIELD.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new AlertingPattern_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new AlertingPattern_template(*other_value.implication_.precondition);
implication_.implied_template = new AlertingPattern_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.AlertingPattern.");
break;
}
set_selection(other_value);
}

AlertingPattern_template::AlertingPattern_template()
{
}

AlertingPattern_template::AlertingPattern_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

AlertingPattern_template::AlertingPattern_template(const AlertingPattern& other_value)
{
copy_value(other_value);
}

AlertingPattern_template::AlertingPattern_template(const OPTIONAL<AlertingPattern>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const AlertingPattern&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.AlertingPattern from an unbound optional field.");
}
}

AlertingPattern_template::AlertingPattern_template(AlertingPattern_template* p_precondition, AlertingPattern_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

AlertingPattern_template::AlertingPattern_template(Dynamic_Match_Interface<AlertingPattern>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<AlertingPattern>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

AlertingPattern_template::AlertingPattern_template(const AlertingPattern_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

AlertingPattern_template::~AlertingPattern_template()
{
clean_up();
}

AlertingPattern_template& AlertingPattern_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

AlertingPattern_template& AlertingPattern_template::operator=(const AlertingPattern& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

AlertingPattern_template& AlertingPattern_template::operator=(const OPTIONAL<AlertingPattern>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const AlertingPattern&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.AlertingPattern.");
}
return *this;
}

AlertingPattern_template& AlertingPattern_template::operator=(const AlertingPattern_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean AlertingPattern_template::match(const AlertingPattern& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.alertingPattern__FIELD().is_bound()) return FALSE;
if(!single_value->field_alertingPattern__FIELD.match(other_value.alertingPattern__FIELD(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.AlertingPattern.");
}
return FALSE;
}

boolean AlertingPattern_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_alertingPattern__FIELD.is_bound()
 || single_value->field_spare.is_bound();
}

boolean AlertingPattern_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_alertingPattern__FIELD.is_value()
 && single_value->field_spare.is_value();
}

void AlertingPattern_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

AlertingPattern AlertingPattern_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.AlertingPattern.");
AlertingPattern ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_alertingPattern__FIELD.is_bound()) {
ret_val.alertingPattern__FIELD() = single_value->field_alertingPattern__FIELD.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void AlertingPattern_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.AlertingPattern.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new AlertingPattern_template[list_length];
}

AlertingPattern_template& AlertingPattern_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.AlertingPattern.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.AlertingPattern.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& AlertingPattern_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& AlertingPattern_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_CC_Types.AlertingPattern.");
return single_value->field_elementIdentifier;
}

INTEGER_template& AlertingPattern_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& AlertingPattern_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_CC_Types.AlertingPattern.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& AlertingPattern_template::alertingPattern__FIELD()
{
set_specific();
return single_value->field_alertingPattern__FIELD;
}

const BITSTRING_template& AlertingPattern_template::alertingPattern__FIELD() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field alertingPattern_FIELD of a non-specific template of type @MobileL3_CC_Types.AlertingPattern.");
return single_value->field_alertingPattern__FIELD;
}

BITSTRING_template& AlertingPattern_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& AlertingPattern_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @MobileL3_CC_Types.AlertingPattern.");
return single_value->field_spare;
}

int AlertingPattern_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.AlertingPattern which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.AlertingPattern containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.AlertingPattern containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.AlertingPattern containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.AlertingPattern containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.AlertingPattern containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.AlertingPattern containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.AlertingPattern containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.AlertingPattern containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.AlertingPattern.");
  }
  return 0;
}

void AlertingPattern_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", alertingPattern_FIELD := ");
single_value->field_alertingPattern__FIELD.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void AlertingPattern_template::log_match(const AlertingPattern& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_alertingPattern__FIELD.match(match_value.alertingPattern__FIELD(), legacy)){
TTCN_Logger::log_logmatch_info(".alertingPattern_FIELD");
single_value->field_alertingPattern__FIELD.log_match(match_value.alertingPattern__FIELD(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", alertingPattern_FIELD := ");
single_value->field_alertingPattern__FIELD.log_match(match_value.alertingPattern__FIELD(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void AlertingPattern_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_alertingPattern__FIELD.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.AlertingPattern.");
}
}

void AlertingPattern_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_alertingPattern__FIELD.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new AlertingPattern_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.AlertingPattern.");
}
}

void AlertingPattern_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    AlertingPattern_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.AlertingPattern has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) alertingPattern__FIELD().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "alertingPattern_FIELD")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          alertingPattern__FIELD().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.AlertingPattern: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    AlertingPattern_template* precondition = new AlertingPattern_template;
    precondition->set_param(*param.get_elem(0));
    AlertingPattern_template* implied_template = new AlertingPattern_template;
    implied_template->set_param(*param.get_elem(1));
    *this = AlertingPattern_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.AlertingPattern");
  }
  is_ifpresent = param.get_ifpresent();
}

void AlertingPattern_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.AlertingPattern");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.AlertingPattern");
single_value->field_alertingPattern__FIELD.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.AlertingPattern");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.AlertingPattern");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.AlertingPattern");
}

boolean AlertingPattern_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean AlertingPattern_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

AllowedActions::AllowedActions()
{
}

AllowedActions::AllowedActions(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const BITSTRING& par_spare__7,
    const BITSTRING& par_ccbsActivation)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_spare__7(par_spare__7),
  field_ccbsActivation(par_ccbsActivation)
{
}

AllowedActions::AllowedActions(const AllowedActions& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.AllowedActions.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.spare__7().is_bound()) field_spare__7 = other_value.spare__7();
else field_spare__7.clean_up();
if (other_value.ccbsActivation().is_bound()) field_ccbsActivation = other_value.ccbsActivation();
else field_ccbsActivation.clean_up();
}

void AllowedActions::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_spare__7.clean_up();
field_ccbsActivation.clean_up();
}

const TTCN_Typedescriptor_t* AllowedActions::get_descriptor() const { return &AllowedActions_descr_; }
AllowedActions& AllowedActions::operator=(const AllowedActions& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.AllowedActions.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.spare__7().is_bound()) field_spare__7 = other_value.spare__7();
  else field_spare__7.clean_up();
  if (other_value.ccbsActivation().is_bound()) field_ccbsActivation = other_value.ccbsActivation();
  else field_ccbsActivation.clean_up();
}
return *this;
}

boolean AllowedActions::operator==(const AllowedActions& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_spare__7==other_value.field_spare__7
  && field_ccbsActivation==other_value.field_ccbsActivation;
}

boolean AllowedActions::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_spare__7.is_bound())
  || (field_ccbsActivation.is_bound());
}
boolean AllowedActions::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_spare__7.is_value()
  && field_ccbsActivation.is_value();
}
void AllowedActions::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", spare_7 := ");
field_spare__7.log();
TTCN_Logger::log_event_str(", ccbsActivation := ");
field_ccbsActivation.log();
TTCN_Logger::log_event_str(" }");
}

void AllowedActions::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (spare__7().is_bound()) spare__7().set_implicit_omit();
if (ccbsActivation().is_bound()) ccbsActivation().set_implicit_omit();
}

void AllowedActions::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.AllowedActions has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare__7().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) ccbsActivation().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare_7")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare__7().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ccbsActivation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ccbsActivation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.AllowedActions: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.AllowedActions");
  }
}

void AllowedActions::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_spare__7.encode_text(text_buf);
field_ccbsActivation.encode_text(text_buf);
}

void AllowedActions::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_spare__7.decode_text(text_buf);
field_ccbsActivation.decode_text(text_buf);
}

void AllowedActions::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void AllowedActions::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int AllowedActions::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, AllowedActions_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(AllowedActions_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(AllowedActions_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT7_descr_.raw->forceomit);
  decoded_field_length = field_spare__7.RAW_decode(General__Types::BIT7_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_ccbsActivation.RAW_decode(General__Types::BIT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int AllowedActions::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, AllowedActions_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT7_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT1_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &AllowedActions_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 2;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(2);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  encoded_length += field_spare__7.RAW_encode(General__Types::BIT7_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_ccbsActivation.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct AllowedActions_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
BITSTRING_template field_spare__7;
BITSTRING_template field_ccbsActivation;
};

void AllowedActions_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_spare__7 = ANY_VALUE;
single_value->field_ccbsActivation = ANY_VALUE;
}
}
}

void AllowedActions_template::copy_value(const AllowedActions& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.spare__7().is_bound()) {
  single_value->field_spare__7 = other_value.spare__7();
} else {
  single_value->field_spare__7.clean_up();
}
if (other_value.ccbsActivation().is_bound()) {
  single_value->field_ccbsActivation = other_value.ccbsActivation();
} else {
  single_value->field_ccbsActivation.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void AllowedActions_template::copy_template(const AllowedActions_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare__7().get_selection()) {
single_value->field_spare__7 = other_value.spare__7();
} else {
single_value->field_spare__7.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ccbsActivation().get_selection()) {
single_value->field_ccbsActivation = other_value.ccbsActivation();
} else {
single_value->field_ccbsActivation.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new AllowedActions_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new AllowedActions_template(*other_value.implication_.precondition);
implication_.implied_template = new AllowedActions_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.AllowedActions.");
break;
}
set_selection(other_value);
}

AllowedActions_template::AllowedActions_template()
{
}

AllowedActions_template::AllowedActions_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

AllowedActions_template::AllowedActions_template(const AllowedActions& other_value)
{
copy_value(other_value);
}

AllowedActions_template::AllowedActions_template(const OPTIONAL<AllowedActions>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const AllowedActions&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.AllowedActions from an unbound optional field.");
}
}

AllowedActions_template::AllowedActions_template(AllowedActions_template* p_precondition, AllowedActions_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

AllowedActions_template::AllowedActions_template(Dynamic_Match_Interface<AllowedActions>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<AllowedActions>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

AllowedActions_template::AllowedActions_template(const AllowedActions_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

AllowedActions_template::~AllowedActions_template()
{
clean_up();
}

AllowedActions_template& AllowedActions_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

AllowedActions_template& AllowedActions_template::operator=(const AllowedActions& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

AllowedActions_template& AllowedActions_template::operator=(const OPTIONAL<AllowedActions>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const AllowedActions&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.AllowedActions.");
}
return *this;
}

AllowedActions_template& AllowedActions_template::operator=(const AllowedActions_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean AllowedActions_template::match(const AllowedActions& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.spare__7().is_bound()) return FALSE;
if(!single_value->field_spare__7.match(other_value.spare__7(), legacy))return FALSE;
if(!other_value.ccbsActivation().is_bound()) return FALSE;
if(!single_value->field_ccbsActivation.match(other_value.ccbsActivation(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.AllowedActions.");
}
return FALSE;
}

boolean AllowedActions_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_spare__7.is_bound()
 || single_value->field_ccbsActivation.is_bound();
}

boolean AllowedActions_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_spare__7.is_value()
 && single_value->field_ccbsActivation.is_value();
}

void AllowedActions_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

AllowedActions AllowedActions_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.AllowedActions.");
AllowedActions ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_spare__7.is_bound()) {
ret_val.spare__7() = single_value->field_spare__7.valueof();
}
if (single_value->field_ccbsActivation.is_bound()) {
ret_val.ccbsActivation() = single_value->field_ccbsActivation.valueof();
}
return ret_val;
}

void AllowedActions_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.AllowedActions.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new AllowedActions_template[list_length];
}

AllowedActions_template& AllowedActions_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.AllowedActions.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.AllowedActions.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& AllowedActions_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& AllowedActions_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_CC_Types.AllowedActions.");
return single_value->field_elementIdentifier;
}

INTEGER_template& AllowedActions_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& AllowedActions_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_CC_Types.AllowedActions.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& AllowedActions_template::spare__7()
{
set_specific();
return single_value->field_spare__7;
}

const BITSTRING_template& AllowedActions_template::spare__7() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare_7 of a non-specific template of type @MobileL3_CC_Types.AllowedActions.");
return single_value->field_spare__7;
}

BITSTRING_template& AllowedActions_template::ccbsActivation()
{
set_specific();
return single_value->field_ccbsActivation;
}

const BITSTRING_template& AllowedActions_template::ccbsActivation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ccbsActivation of a non-specific template of type @MobileL3_CC_Types.AllowedActions.");
return single_value->field_ccbsActivation;
}

int AllowedActions_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.AllowedActions which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.AllowedActions containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.AllowedActions containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.AllowedActions containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.AllowedActions containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.AllowedActions containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.AllowedActions containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.AllowedActions containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.AllowedActions containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.AllowedActions.");
  }
  return 0;
}

void AllowedActions_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", spare_7 := ");
single_value->field_spare__7.log();
TTCN_Logger::log_event_str(", ccbsActivation := ");
single_value->field_ccbsActivation.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void AllowedActions_template::log_match(const AllowedActions& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare__7.match(match_value.spare__7(), legacy)){
TTCN_Logger::log_logmatch_info(".spare_7");
single_value->field_spare__7.log_match(match_value.spare__7(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ccbsActivation.match(match_value.ccbsActivation(), legacy)){
TTCN_Logger::log_logmatch_info(".ccbsActivation");
single_value->field_ccbsActivation.log_match(match_value.ccbsActivation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", spare_7 := ");
single_value->field_spare__7.log_match(match_value.spare__7(), legacy);
TTCN_Logger::log_event_str(", ccbsActivation := ");
single_value->field_ccbsActivation.log_match(match_value.ccbsActivation(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void AllowedActions_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_spare__7.encode_text(text_buf);
single_value->field_ccbsActivation.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.AllowedActions.");
}
}

void AllowedActions_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_spare__7.decode_text(text_buf);
single_value->field_ccbsActivation.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new AllowedActions_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.AllowedActions.");
}
}

void AllowedActions_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    AllowedActions_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.AllowedActions has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare__7().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) ccbsActivation().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare_7")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare__7().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ccbsActivation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ccbsActivation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.AllowedActions: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    AllowedActions_template* precondition = new AllowedActions_template;
    precondition->set_param(*param.get_elem(0));
    AllowedActions_template* implied_template = new AllowedActions_template;
    implied_template->set_param(*param.get_elem(1));
    *this = AllowedActions_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.AllowedActions");
  }
  is_ifpresent = param.get_ifpresent();
}

void AllowedActions_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.AllowedActions");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.AllowedActions");
single_value->field_spare__7.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.AllowedActions");
single_value->field_ccbsActivation.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.AllowedActions");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.AllowedActions");
}

boolean AllowedActions_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean AllowedActions_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

StreamIdentifier::StreamIdentifier()
{
}

StreamIdentifier::StreamIdentifier(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthf,
    const OCTETSTRING& par_streamIdentifierValue)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthf(par_lengthf),
  field_streamIdentifierValue(par_streamIdentifierValue)
{
}

StreamIdentifier::StreamIdentifier(const StreamIdentifier& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.StreamIdentifier.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
else field_lengthf.clean_up();
if (other_value.streamIdentifierValue().is_bound()) field_streamIdentifierValue = other_value.streamIdentifierValue();
else field_streamIdentifierValue.clean_up();
}

void StreamIdentifier::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthf.clean_up();
field_streamIdentifierValue.clean_up();
}

const TTCN_Typedescriptor_t* StreamIdentifier::get_descriptor() const { return &StreamIdentifier_descr_; }
StreamIdentifier& StreamIdentifier::operator=(const StreamIdentifier& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.StreamIdentifier.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthf().is_bound()) field_lengthf = other_value.lengthf();
  else field_lengthf.clean_up();
  if (other_value.streamIdentifierValue().is_bound()) field_streamIdentifierValue = other_value.streamIdentifierValue();
  else field_streamIdentifierValue.clean_up();
}
return *this;
}

boolean StreamIdentifier::operator==(const StreamIdentifier& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthf==other_value.field_lengthf
  && field_streamIdentifierValue==other_value.field_streamIdentifierValue;
}

boolean StreamIdentifier::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthf.is_bound())
  || (field_streamIdentifierValue.is_bound());
}
boolean StreamIdentifier::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthf.is_value()
  && field_streamIdentifierValue.is_value();
}
void StreamIdentifier::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthf := ");
field_lengthf.log();
TTCN_Logger::log_event_str(", streamIdentifierValue := ");
field_streamIdentifierValue.log();
TTCN_Logger::log_event_str(" }");
}

void StreamIdentifier::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthf().is_bound()) lengthf().set_implicit_omit();
if (streamIdentifierValue().is_bound()) streamIdentifierValue().set_implicit_omit();
}

void StreamIdentifier::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.StreamIdentifier has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) streamIdentifierValue().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "streamIdentifierValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          streamIdentifierValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.StreamIdentifier: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.StreamIdentifier");
  }
}

void StreamIdentifier::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthf.encode_text(text_buf);
field_streamIdentifierValue.encode_text(text_buf);
}

void StreamIdentifier::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthf.decode_text(text_buf);
field_streamIdentifierValue.decode_text(text_buf);
}

void StreamIdentifier::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void StreamIdentifier::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int StreamIdentifier::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, StreamIdentifier_lengthf_descr_.raw->forceomit);
  decoded_field_length = field_lengthf.RAW_decode(StreamIdentifier_lengthf_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthf.convert_to_Integer(StreamIdentifier_lengthf_descr_);
  field_lengthf = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_streamIdentifierValue.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int StreamIdentifier::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, StreamIdentifier_lengthf_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT1_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &StreamIdentifier_lengthf_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_streamIdentifierValue.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct StreamIdentifier_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthf;
OCTETSTRING_template field_streamIdentifierValue;
};

void StreamIdentifier_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthf = ANY_VALUE;
single_value->field_streamIdentifierValue = ANY_VALUE;
}
}
}

void StreamIdentifier_template::copy_value(const StreamIdentifier& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthf().is_bound()) {
  single_value->field_lengthf = other_value.lengthf();
} else {
  single_value->field_lengthf.clean_up();
}
if (other_value.streamIdentifierValue().is_bound()) {
  single_value->field_streamIdentifierValue = other_value.streamIdentifierValue();
} else {
  single_value->field_streamIdentifierValue.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void StreamIdentifier_template::copy_template(const StreamIdentifier_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthf().get_selection()) {
single_value->field_lengthf = other_value.lengthf();
} else {
single_value->field_lengthf.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.streamIdentifierValue().get_selection()) {
single_value->field_streamIdentifierValue = other_value.streamIdentifierValue();
} else {
single_value->field_streamIdentifierValue.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new StreamIdentifier_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new StreamIdentifier_template(*other_value.implication_.precondition);
implication_.implied_template = new StreamIdentifier_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.StreamIdentifier.");
break;
}
set_selection(other_value);
}

StreamIdentifier_template::StreamIdentifier_template()
{
}

StreamIdentifier_template::StreamIdentifier_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

StreamIdentifier_template::StreamIdentifier_template(const StreamIdentifier& other_value)
{
copy_value(other_value);
}

StreamIdentifier_template::StreamIdentifier_template(const OPTIONAL<StreamIdentifier>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const StreamIdentifier&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.StreamIdentifier from an unbound optional field.");
}
}

StreamIdentifier_template::StreamIdentifier_template(StreamIdentifier_template* p_precondition, StreamIdentifier_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

StreamIdentifier_template::StreamIdentifier_template(Dynamic_Match_Interface<StreamIdentifier>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<StreamIdentifier>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

StreamIdentifier_template::StreamIdentifier_template(const StreamIdentifier_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

StreamIdentifier_template::~StreamIdentifier_template()
{
clean_up();
}

StreamIdentifier_template& StreamIdentifier_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

StreamIdentifier_template& StreamIdentifier_template::operator=(const StreamIdentifier& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

StreamIdentifier_template& StreamIdentifier_template::operator=(const OPTIONAL<StreamIdentifier>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const StreamIdentifier&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.StreamIdentifier.");
}
return *this;
}

StreamIdentifier_template& StreamIdentifier_template::operator=(const StreamIdentifier_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean StreamIdentifier_template::match(const StreamIdentifier& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthf().is_bound()) return FALSE;
if(!single_value->field_lengthf.match(other_value.lengthf(), legacy))return FALSE;
if(!other_value.streamIdentifierValue().is_bound()) return FALSE;
if(!single_value->field_streamIdentifierValue.match(other_value.streamIdentifierValue(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.StreamIdentifier.");
}
return FALSE;
}

boolean StreamIdentifier_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthf.is_bound()
 || single_value->field_streamIdentifierValue.is_bound();
}

boolean StreamIdentifier_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthf.is_value()
 && single_value->field_streamIdentifierValue.is_value();
}

void StreamIdentifier_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

StreamIdentifier StreamIdentifier_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.StreamIdentifier.");
StreamIdentifier ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthf.is_bound()) {
ret_val.lengthf() = single_value->field_lengthf.valueof();
}
if (single_value->field_streamIdentifierValue.is_bound()) {
ret_val.streamIdentifierValue() = single_value->field_streamIdentifierValue.valueof();
}
return ret_val;
}

void StreamIdentifier_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.StreamIdentifier.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new StreamIdentifier_template[list_length];
}

StreamIdentifier_template& StreamIdentifier_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.StreamIdentifier.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.StreamIdentifier.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& StreamIdentifier_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& StreamIdentifier_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_CC_Types.StreamIdentifier.");
return single_value->field_elementIdentifier;
}

INTEGER_template& StreamIdentifier_template::lengthf()
{
set_specific();
return single_value->field_lengthf;
}

const INTEGER_template& StreamIdentifier_template::lengthf() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthf of a non-specific template of type @MobileL3_CC_Types.StreamIdentifier.");
return single_value->field_lengthf;
}

OCTETSTRING_template& StreamIdentifier_template::streamIdentifierValue()
{
set_specific();
return single_value->field_streamIdentifierValue;
}

const OCTETSTRING_template& StreamIdentifier_template::streamIdentifierValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field streamIdentifierValue of a non-specific template of type @MobileL3_CC_Types.StreamIdentifier.");
return single_value->field_streamIdentifierValue;
}

int StreamIdentifier_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.StreamIdentifier which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.StreamIdentifier containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.StreamIdentifier containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.StreamIdentifier containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.StreamIdentifier containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.StreamIdentifier containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.StreamIdentifier containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.StreamIdentifier containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.StreamIdentifier containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.StreamIdentifier.");
  }
  return 0;
}

void StreamIdentifier_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log();
TTCN_Logger::log_event_str(", streamIdentifierValue := ");
single_value->field_streamIdentifierValue.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void StreamIdentifier_template::log_match(const StreamIdentifier& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthf.match(match_value.lengthf(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthf");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_streamIdentifierValue.match(match_value.streamIdentifierValue(), legacy)){
TTCN_Logger::log_logmatch_info(".streamIdentifierValue");
single_value->field_streamIdentifierValue.log_match(match_value.streamIdentifierValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthf := ");
single_value->field_lengthf.log_match(match_value.lengthf(), legacy);
TTCN_Logger::log_event_str(", streamIdentifierValue := ");
single_value->field_streamIdentifierValue.log_match(match_value.streamIdentifierValue(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void StreamIdentifier_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthf.encode_text(text_buf);
single_value->field_streamIdentifierValue.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.StreamIdentifier.");
}
}

void StreamIdentifier_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthf.decode_text(text_buf);
single_value->field_streamIdentifierValue.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new StreamIdentifier_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.StreamIdentifier.");
}
}

void StreamIdentifier_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    StreamIdentifier_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.StreamIdentifier has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthf().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) streamIdentifierValue().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthf")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthf().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "streamIdentifierValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          streamIdentifierValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.StreamIdentifier: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    StreamIdentifier_template* precondition = new StreamIdentifier_template;
    precondition->set_param(*param.get_elem(0));
    StreamIdentifier_template* implied_template = new StreamIdentifier_template;
    implied_template->set_param(*param.get_elem(1));
    *this = StreamIdentifier_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.StreamIdentifier");
  }
  is_ifpresent = param.get_ifpresent();
}

void StreamIdentifier_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.StreamIdentifier");
single_value->field_lengthf.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.StreamIdentifier");
single_value->field_streamIdentifierValue.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.StreamIdentifier");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.StreamIdentifier");
}

boolean StreamIdentifier_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean StreamIdentifier_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

NetworkCallControlCapabilities::NetworkCallControlCapabilities()
{
}

NetworkCallControlCapabilities::NetworkCallControlCapabilities(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const BITSTRING& par_mcs,
    const BITSTRING& par_spare)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_mcs(par_mcs),
  field_spare(par_spare)
{
}

NetworkCallControlCapabilities::NetworkCallControlCapabilities(const NetworkCallControlCapabilities& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.NetworkCallControlCapabilities.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.mcs().is_bound()) field_mcs = other_value.mcs();
else field_mcs.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void NetworkCallControlCapabilities::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_mcs.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* NetworkCallControlCapabilities::get_descriptor() const { return &NetworkCallControlCapabilities_descr_; }
NetworkCallControlCapabilities& NetworkCallControlCapabilities::operator=(const NetworkCallControlCapabilities& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.NetworkCallControlCapabilities.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.mcs().is_bound()) field_mcs = other_value.mcs();
  else field_mcs.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean NetworkCallControlCapabilities::operator==(const NetworkCallControlCapabilities& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_mcs==other_value.field_mcs
  && field_spare==other_value.field_spare;
}

boolean NetworkCallControlCapabilities::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_mcs.is_bound())
  || (field_spare.is_bound());
}
boolean NetworkCallControlCapabilities::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_mcs.is_value()
  && field_spare.is_value();
}
void NetworkCallControlCapabilities::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", mcs := ");
field_mcs.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void NetworkCallControlCapabilities::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (mcs().is_bound()) mcs().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void NetworkCallControlCapabilities::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.NetworkCallControlCapabilities has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) mcs().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mcs")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mcs().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.NetworkCallControlCapabilities: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.NetworkCallControlCapabilities");
  }
}

void NetworkCallControlCapabilities::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_mcs.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void NetworkCallControlCapabilities::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_mcs.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void NetworkCallControlCapabilities::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void NetworkCallControlCapabilities::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int NetworkCallControlCapabilities::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, NetworkCallControlCapabilities_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(NetworkCallControlCapabilities_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(NetworkCallControlCapabilities_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_mcs.RAW_decode(General__Types::BIT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT7_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT7_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int NetworkCallControlCapabilities::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, NetworkCallControlCapabilities_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT7_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &NetworkCallControlCapabilities_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 2;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(2);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  encoded_length += field_mcs.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT7_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct NetworkCallControlCapabilities_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
BITSTRING_template field_mcs;
BITSTRING_template field_spare;
};

void NetworkCallControlCapabilities_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_mcs = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void NetworkCallControlCapabilities_template::copy_value(const NetworkCallControlCapabilities& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.mcs().is_bound()) {
  single_value->field_mcs = other_value.mcs();
} else {
  single_value->field_mcs.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void NetworkCallControlCapabilities_template::copy_template(const NetworkCallControlCapabilities_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mcs().get_selection()) {
single_value->field_mcs = other_value.mcs();
} else {
single_value->field_mcs.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new NetworkCallControlCapabilities_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new NetworkCallControlCapabilities_template(*other_value.implication_.precondition);
implication_.implied_template = new NetworkCallControlCapabilities_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.NetworkCallControlCapabilities.");
break;
}
set_selection(other_value);
}

NetworkCallControlCapabilities_template::NetworkCallControlCapabilities_template()
{
}

NetworkCallControlCapabilities_template::NetworkCallControlCapabilities_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

NetworkCallControlCapabilities_template::NetworkCallControlCapabilities_template(const NetworkCallControlCapabilities& other_value)
{
copy_value(other_value);
}

NetworkCallControlCapabilities_template::NetworkCallControlCapabilities_template(const OPTIONAL<NetworkCallControlCapabilities>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NetworkCallControlCapabilities&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.NetworkCallControlCapabilities from an unbound optional field.");
}
}

NetworkCallControlCapabilities_template::NetworkCallControlCapabilities_template(NetworkCallControlCapabilities_template* p_precondition, NetworkCallControlCapabilities_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

NetworkCallControlCapabilities_template::NetworkCallControlCapabilities_template(Dynamic_Match_Interface<NetworkCallControlCapabilities>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<NetworkCallControlCapabilities>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

NetworkCallControlCapabilities_template::NetworkCallControlCapabilities_template(const NetworkCallControlCapabilities_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

NetworkCallControlCapabilities_template::~NetworkCallControlCapabilities_template()
{
clean_up();
}

NetworkCallControlCapabilities_template& NetworkCallControlCapabilities_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

NetworkCallControlCapabilities_template& NetworkCallControlCapabilities_template::operator=(const NetworkCallControlCapabilities& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

NetworkCallControlCapabilities_template& NetworkCallControlCapabilities_template::operator=(const OPTIONAL<NetworkCallControlCapabilities>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NetworkCallControlCapabilities&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.NetworkCallControlCapabilities.");
}
return *this;
}

NetworkCallControlCapabilities_template& NetworkCallControlCapabilities_template::operator=(const NetworkCallControlCapabilities_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean NetworkCallControlCapabilities_template::match(const NetworkCallControlCapabilities& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.mcs().is_bound()) return FALSE;
if(!single_value->field_mcs.match(other_value.mcs(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.NetworkCallControlCapabilities.");
}
return FALSE;
}

boolean NetworkCallControlCapabilities_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_mcs.is_bound()
 || single_value->field_spare.is_bound();
}

boolean NetworkCallControlCapabilities_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_mcs.is_value()
 && single_value->field_spare.is_value();
}

void NetworkCallControlCapabilities_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

NetworkCallControlCapabilities NetworkCallControlCapabilities_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.NetworkCallControlCapabilities.");
NetworkCallControlCapabilities ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_mcs.is_bound()) {
ret_val.mcs() = single_value->field_mcs.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void NetworkCallControlCapabilities_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.NetworkCallControlCapabilities.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new NetworkCallControlCapabilities_template[list_length];
}

NetworkCallControlCapabilities_template& NetworkCallControlCapabilities_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.NetworkCallControlCapabilities.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.NetworkCallControlCapabilities.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& NetworkCallControlCapabilities_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& NetworkCallControlCapabilities_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_CC_Types.NetworkCallControlCapabilities.");
return single_value->field_elementIdentifier;
}

INTEGER_template& NetworkCallControlCapabilities_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& NetworkCallControlCapabilities_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_CC_Types.NetworkCallControlCapabilities.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& NetworkCallControlCapabilities_template::mcs()
{
set_specific();
return single_value->field_mcs;
}

const BITSTRING_template& NetworkCallControlCapabilities_template::mcs() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mcs of a non-specific template of type @MobileL3_CC_Types.NetworkCallControlCapabilities.");
return single_value->field_mcs;
}

BITSTRING_template& NetworkCallControlCapabilities_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& NetworkCallControlCapabilities_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @MobileL3_CC_Types.NetworkCallControlCapabilities.");
return single_value->field_spare;
}

int NetworkCallControlCapabilities_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.NetworkCallControlCapabilities which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.NetworkCallControlCapabilities containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.NetworkCallControlCapabilities containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.NetworkCallControlCapabilities containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.NetworkCallControlCapabilities containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.NetworkCallControlCapabilities containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.NetworkCallControlCapabilities containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.NetworkCallControlCapabilities containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.NetworkCallControlCapabilities containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.NetworkCallControlCapabilities.");
  }
  return 0;
}

void NetworkCallControlCapabilities_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", mcs := ");
single_value->field_mcs.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void NetworkCallControlCapabilities_template::log_match(const NetworkCallControlCapabilities& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mcs.match(match_value.mcs(), legacy)){
TTCN_Logger::log_logmatch_info(".mcs");
single_value->field_mcs.log_match(match_value.mcs(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", mcs := ");
single_value->field_mcs.log_match(match_value.mcs(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void NetworkCallControlCapabilities_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_mcs.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.NetworkCallControlCapabilities.");
}
}

void NetworkCallControlCapabilities_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_mcs.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new NetworkCallControlCapabilities_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.NetworkCallControlCapabilities.");
}
}

void NetworkCallControlCapabilities_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    NetworkCallControlCapabilities_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.NetworkCallControlCapabilities has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) mcs().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mcs")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mcs().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.NetworkCallControlCapabilities: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    NetworkCallControlCapabilities_template* precondition = new NetworkCallControlCapabilities_template;
    precondition->set_param(*param.get_elem(0));
    NetworkCallControlCapabilities_template* implied_template = new NetworkCallControlCapabilities_template;
    implied_template->set_param(*param.get_elem(1));
    *this = NetworkCallControlCapabilities_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.NetworkCallControlCapabilities");
  }
  is_ifpresent = param.get_ifpresent();
}

void NetworkCallControlCapabilities_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.NetworkCallControlCapabilities");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.NetworkCallControlCapabilities");
single_value->field_mcs.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.NetworkCallControlCapabilities");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.NetworkCallControlCapabilities");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.NetworkCallControlCapabilities");
}

boolean NetworkCallControlCapabilities_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean NetworkCallControlCapabilities_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

CauseofNoCli::CauseofNoCli()
{
}

CauseofNoCli::CauseofNoCli(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_causeofNoCli__FIELD)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_causeofNoCli__FIELD(par_causeofNoCli__FIELD)
{
}

CauseofNoCli::CauseofNoCli(const CauseofNoCli& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.CauseofNoCli.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.causeofNoCli__FIELD().is_bound()) field_causeofNoCli__FIELD = other_value.causeofNoCli__FIELD();
else field_causeofNoCli__FIELD.clean_up();
}

void CauseofNoCli::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_causeofNoCli__FIELD.clean_up();
}

const TTCN_Typedescriptor_t* CauseofNoCli::get_descriptor() const { return &CauseofNoCli_descr_; }
CauseofNoCli& CauseofNoCli::operator=(const CauseofNoCli& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.CauseofNoCli.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.causeofNoCli__FIELD().is_bound()) field_causeofNoCli__FIELD = other_value.causeofNoCli__FIELD();
  else field_causeofNoCli__FIELD.clean_up();
}
return *this;
}

boolean CauseofNoCli::operator==(const CauseofNoCli& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_causeofNoCli__FIELD==other_value.field_causeofNoCli__FIELD;
}

boolean CauseofNoCli::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_causeofNoCli__FIELD.is_bound());
}
boolean CauseofNoCli::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_causeofNoCli__FIELD.is_value();
}
void CauseofNoCli::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", causeofNoCli_FIELD := ");
field_causeofNoCli__FIELD.log();
TTCN_Logger::log_event_str(" }");
}

void CauseofNoCli::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (causeofNoCli__FIELD().is_bound()) causeofNoCli__FIELD().set_implicit_omit();
}

void CauseofNoCli::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.CauseofNoCli has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) causeofNoCli__FIELD().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "causeofNoCli_FIELD")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          causeofNoCli__FIELD().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.CauseofNoCli: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.CauseofNoCli");
  }
}

void CauseofNoCli::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_causeofNoCli__FIELD.encode_text(text_buf);
}

void CauseofNoCli::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_causeofNoCli__FIELD.decode_text(text_buf);
}

void CauseofNoCli::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void CauseofNoCli::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int CauseofNoCli::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, CauseofNoCli_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(CauseofNoCli_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(CauseofNoCli_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_causeofNoCli__FIELD.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int CauseofNoCli::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, CauseofNoCli_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT1_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &CauseofNoCli_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_causeofNoCli__FIELD.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct CauseofNoCli_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_causeofNoCli__FIELD;
};

void CauseofNoCli_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_causeofNoCli__FIELD = ANY_VALUE;
}
}
}

void CauseofNoCli_template::copy_value(const CauseofNoCli& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.causeofNoCli__FIELD().is_bound()) {
  single_value->field_causeofNoCli__FIELD = other_value.causeofNoCli__FIELD();
} else {
  single_value->field_causeofNoCli__FIELD.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void CauseofNoCli_template::copy_template(const CauseofNoCli_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.causeofNoCli__FIELD().get_selection()) {
single_value->field_causeofNoCli__FIELD = other_value.causeofNoCli__FIELD();
} else {
single_value->field_causeofNoCli__FIELD.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new CauseofNoCli_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new CauseofNoCli_template(*other_value.implication_.precondition);
implication_.implied_template = new CauseofNoCli_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.CauseofNoCli.");
break;
}
set_selection(other_value);
}

CauseofNoCli_template::CauseofNoCli_template()
{
}

CauseofNoCli_template::CauseofNoCli_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

CauseofNoCli_template::CauseofNoCli_template(const CauseofNoCli& other_value)
{
copy_value(other_value);
}

CauseofNoCli_template::CauseofNoCli_template(const OPTIONAL<CauseofNoCli>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CauseofNoCli&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.CauseofNoCli from an unbound optional field.");
}
}

CauseofNoCli_template::CauseofNoCli_template(CauseofNoCli_template* p_precondition, CauseofNoCli_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

CauseofNoCli_template::CauseofNoCli_template(Dynamic_Match_Interface<CauseofNoCli>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<CauseofNoCli>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

CauseofNoCli_template::CauseofNoCli_template(const CauseofNoCli_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

CauseofNoCli_template::~CauseofNoCli_template()
{
clean_up();
}

CauseofNoCli_template& CauseofNoCli_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

CauseofNoCli_template& CauseofNoCli_template::operator=(const CauseofNoCli& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

CauseofNoCli_template& CauseofNoCli_template::operator=(const OPTIONAL<CauseofNoCli>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CauseofNoCli&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.CauseofNoCli.");
}
return *this;
}

CauseofNoCli_template& CauseofNoCli_template::operator=(const CauseofNoCli_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean CauseofNoCli_template::match(const CauseofNoCli& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.causeofNoCli__FIELD().is_bound()) return FALSE;
if(!single_value->field_causeofNoCli__FIELD.match(other_value.causeofNoCli__FIELD(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.CauseofNoCli.");
}
return FALSE;
}

boolean CauseofNoCli_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_causeofNoCli__FIELD.is_bound();
}

boolean CauseofNoCli_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_causeofNoCli__FIELD.is_value();
}

void CauseofNoCli_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

CauseofNoCli CauseofNoCli_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.CauseofNoCli.");
CauseofNoCli ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_causeofNoCli__FIELD.is_bound()) {
ret_val.causeofNoCli__FIELD() = single_value->field_causeofNoCli__FIELD.valueof();
}
return ret_val;
}

void CauseofNoCli_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.CauseofNoCli.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new CauseofNoCli_template[list_length];
}

CauseofNoCli_template& CauseofNoCli_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.CauseofNoCli.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.CauseofNoCli.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& CauseofNoCli_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& CauseofNoCli_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_CC_Types.CauseofNoCli.");
return single_value->field_elementIdentifier;
}

INTEGER_template& CauseofNoCli_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& CauseofNoCli_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_CC_Types.CauseofNoCli.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& CauseofNoCli_template::causeofNoCli__FIELD()
{
set_specific();
return single_value->field_causeofNoCli__FIELD;
}

const OCTETSTRING_template& CauseofNoCli_template::causeofNoCli__FIELD() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field causeofNoCli_FIELD of a non-specific template of type @MobileL3_CC_Types.CauseofNoCli.");
return single_value->field_causeofNoCli__FIELD;
}

int CauseofNoCli_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.CauseofNoCli which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.CauseofNoCli containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.CauseofNoCli containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.CauseofNoCli containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.CauseofNoCli containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.CauseofNoCli containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.CauseofNoCli containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.CauseofNoCli containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.CauseofNoCli containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.CauseofNoCli.");
  }
  return 0;
}

void CauseofNoCli_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", causeofNoCli_FIELD := ");
single_value->field_causeofNoCli__FIELD.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void CauseofNoCli_template::log_match(const CauseofNoCli& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_causeofNoCli__FIELD.match(match_value.causeofNoCli__FIELD(), legacy)){
TTCN_Logger::log_logmatch_info(".causeofNoCli_FIELD");
single_value->field_causeofNoCli__FIELD.log_match(match_value.causeofNoCli__FIELD(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", causeofNoCli_FIELD := ");
single_value->field_causeofNoCli__FIELD.log_match(match_value.causeofNoCli__FIELD(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void CauseofNoCli_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_causeofNoCli__FIELD.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.CauseofNoCli.");
}
}

void CauseofNoCli_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_causeofNoCli__FIELD.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new CauseofNoCli_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.CauseofNoCli.");
}
}

void CauseofNoCli_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    CauseofNoCli_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.CauseofNoCli has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) causeofNoCli__FIELD().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "causeofNoCli_FIELD")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          causeofNoCli__FIELD().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.CauseofNoCli: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    CauseofNoCli_template* precondition = new CauseofNoCli_template;
    precondition->set_param(*param.get_elem(0));
    CauseofNoCli_template* implied_template = new CauseofNoCli_template;
    implied_template->set_param(*param.get_elem(1));
    *this = CauseofNoCli_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.CauseofNoCli");
  }
  is_ifpresent = param.get_ifpresent();
}

void CauseofNoCli_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.CauseofNoCli");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.CauseofNoCli");
single_value->field_causeofNoCli__FIELD.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.CauseofNoCli");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.CauseofNoCli");
}

boolean CauseofNoCli_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean CauseofNoCli_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ServiceCategory::ServiceCategory()
{
}

ServiceCategory::ServiceCategory(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const BITSTRING& par_emergencyServiceCategory,
    const BITSTRING& par_spare__1)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_emergencyServiceCategory(par_emergencyServiceCategory),
  field_spare__1(par_spare__1)
{
}

ServiceCategory::ServiceCategory(const ServiceCategory& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.ServiceCategory.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.emergencyServiceCategory().is_bound()) field_emergencyServiceCategory = other_value.emergencyServiceCategory();
else field_emergencyServiceCategory.clean_up();
if (other_value.spare__1().is_bound()) field_spare__1 = other_value.spare__1();
else field_spare__1.clean_up();
}

void ServiceCategory::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_emergencyServiceCategory.clean_up();
field_spare__1.clean_up();
}

const TTCN_Typedescriptor_t* ServiceCategory::get_descriptor() const { return &ServiceCategory_descr_; }
ServiceCategory& ServiceCategory::operator=(const ServiceCategory& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.ServiceCategory.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.emergencyServiceCategory().is_bound()) field_emergencyServiceCategory = other_value.emergencyServiceCategory();
  else field_emergencyServiceCategory.clean_up();
  if (other_value.spare__1().is_bound()) field_spare__1 = other_value.spare__1();
  else field_spare__1.clean_up();
}
return *this;
}

boolean ServiceCategory::operator==(const ServiceCategory& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_emergencyServiceCategory==other_value.field_emergencyServiceCategory
  && field_spare__1==other_value.field_spare__1;
}

boolean ServiceCategory::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_emergencyServiceCategory.is_bound())
  || (field_spare__1.is_bound());
}
boolean ServiceCategory::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_emergencyServiceCategory.is_value()
  && field_spare__1.is_value();
}
void ServiceCategory::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", emergencyServiceCategory := ");
field_emergencyServiceCategory.log();
TTCN_Logger::log_event_str(", spare_1 := ");
field_spare__1.log();
TTCN_Logger::log_event_str(" }");
}

void ServiceCategory::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (emergencyServiceCategory().is_bound()) emergencyServiceCategory().set_implicit_omit();
if (spare__1().is_bound()) spare__1().set_implicit_omit();
}

void ServiceCategory::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.ServiceCategory has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) emergencyServiceCategory().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare__1().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "emergencyServiceCategory")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          emergencyServiceCategory().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare_1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare__1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.ServiceCategory: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.ServiceCategory");
  }
}

void ServiceCategory::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_emergencyServiceCategory.encode_text(text_buf);
field_spare__1.encode_text(text_buf);
}

void ServiceCategory::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_emergencyServiceCategory.decode_text(text_buf);
field_spare__1.decode_text(text_buf);
}

void ServiceCategory::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ServiceCategory::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int ServiceCategory::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, ServiceCategory_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(ServiceCategory_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(ServiceCategory_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT7_descr_.raw->forceomit);
  decoded_field_length = field_emergencyServiceCategory.RAW_decode(General__Types::BIT7_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_spare__1.RAW_decode(General__Types::BIT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int ServiceCategory::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, ServiceCategory_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT7_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT1_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &ServiceCategory_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 2;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(2);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  encoded_length += field_emergencyServiceCategory.RAW_encode(General__Types::BIT7_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_spare__1.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct ServiceCategory_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
BITSTRING_template field_emergencyServiceCategory;
BITSTRING_template field_spare__1;
};

void ServiceCategory_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_emergencyServiceCategory = ANY_VALUE;
single_value->field_spare__1 = ANY_VALUE;
}
}
}

void ServiceCategory_template::copy_value(const ServiceCategory& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.emergencyServiceCategory().is_bound()) {
  single_value->field_emergencyServiceCategory = other_value.emergencyServiceCategory();
} else {
  single_value->field_emergencyServiceCategory.clean_up();
}
if (other_value.spare__1().is_bound()) {
  single_value->field_spare__1 = other_value.spare__1();
} else {
  single_value->field_spare__1.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ServiceCategory_template::copy_template(const ServiceCategory_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.emergencyServiceCategory().get_selection()) {
single_value->field_emergencyServiceCategory = other_value.emergencyServiceCategory();
} else {
single_value->field_emergencyServiceCategory.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare__1().get_selection()) {
single_value->field_spare__1 = other_value.spare__1();
} else {
single_value->field_spare__1.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ServiceCategory_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ServiceCategory_template(*other_value.implication_.precondition);
implication_.implied_template = new ServiceCategory_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.ServiceCategory.");
break;
}
set_selection(other_value);
}

ServiceCategory_template::ServiceCategory_template()
{
}

ServiceCategory_template::ServiceCategory_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ServiceCategory_template::ServiceCategory_template(const ServiceCategory& other_value)
{
copy_value(other_value);
}

ServiceCategory_template::ServiceCategory_template(const OPTIONAL<ServiceCategory>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ServiceCategory&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.ServiceCategory from an unbound optional field.");
}
}

ServiceCategory_template::ServiceCategory_template(ServiceCategory_template* p_precondition, ServiceCategory_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ServiceCategory_template::ServiceCategory_template(Dynamic_Match_Interface<ServiceCategory>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ServiceCategory>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ServiceCategory_template::ServiceCategory_template(const ServiceCategory_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ServiceCategory_template::~ServiceCategory_template()
{
clean_up();
}

ServiceCategory_template& ServiceCategory_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ServiceCategory_template& ServiceCategory_template::operator=(const ServiceCategory& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ServiceCategory_template& ServiceCategory_template::operator=(const OPTIONAL<ServiceCategory>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ServiceCategory&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.ServiceCategory.");
}
return *this;
}

ServiceCategory_template& ServiceCategory_template::operator=(const ServiceCategory_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ServiceCategory_template::match(const ServiceCategory& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.emergencyServiceCategory().is_bound()) return FALSE;
if(!single_value->field_emergencyServiceCategory.match(other_value.emergencyServiceCategory(), legacy))return FALSE;
if(!other_value.spare__1().is_bound()) return FALSE;
if(!single_value->field_spare__1.match(other_value.spare__1(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.ServiceCategory.");
}
return FALSE;
}

boolean ServiceCategory_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_emergencyServiceCategory.is_bound()
 || single_value->field_spare__1.is_bound();
}

boolean ServiceCategory_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_emergencyServiceCategory.is_value()
 && single_value->field_spare__1.is_value();
}

void ServiceCategory_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ServiceCategory ServiceCategory_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.ServiceCategory.");
ServiceCategory ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_emergencyServiceCategory.is_bound()) {
ret_val.emergencyServiceCategory() = single_value->field_emergencyServiceCategory.valueof();
}
if (single_value->field_spare__1.is_bound()) {
ret_val.spare__1() = single_value->field_spare__1.valueof();
}
return ret_val;
}

void ServiceCategory_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.ServiceCategory.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ServiceCategory_template[list_length];
}

ServiceCategory_template& ServiceCategory_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.ServiceCategory.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.ServiceCategory.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& ServiceCategory_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& ServiceCategory_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_CC_Types.ServiceCategory.");
return single_value->field_elementIdentifier;
}

INTEGER_template& ServiceCategory_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& ServiceCategory_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_CC_Types.ServiceCategory.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& ServiceCategory_template::emergencyServiceCategory()
{
set_specific();
return single_value->field_emergencyServiceCategory;
}

const BITSTRING_template& ServiceCategory_template::emergencyServiceCategory() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field emergencyServiceCategory of a non-specific template of type @MobileL3_CC_Types.ServiceCategory.");
return single_value->field_emergencyServiceCategory;
}

BITSTRING_template& ServiceCategory_template::spare__1()
{
set_specific();
return single_value->field_spare__1;
}

const BITSTRING_template& ServiceCategory_template::spare__1() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare_1 of a non-specific template of type @MobileL3_CC_Types.ServiceCategory.");
return single_value->field_spare__1;
}

int ServiceCategory_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.ServiceCategory which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.ServiceCategory containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.ServiceCategory containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.ServiceCategory containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.ServiceCategory containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.ServiceCategory containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.ServiceCategory containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.ServiceCategory containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.ServiceCategory containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.ServiceCategory.");
  }
  return 0;
}

void ServiceCategory_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", emergencyServiceCategory := ");
single_value->field_emergencyServiceCategory.log();
TTCN_Logger::log_event_str(", spare_1 := ");
single_value->field_spare__1.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ServiceCategory_template::log_match(const ServiceCategory& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_emergencyServiceCategory.match(match_value.emergencyServiceCategory(), legacy)){
TTCN_Logger::log_logmatch_info(".emergencyServiceCategory");
single_value->field_emergencyServiceCategory.log_match(match_value.emergencyServiceCategory(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare__1.match(match_value.spare__1(), legacy)){
TTCN_Logger::log_logmatch_info(".spare_1");
single_value->field_spare__1.log_match(match_value.spare__1(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", emergencyServiceCategory := ");
single_value->field_emergencyServiceCategory.log_match(match_value.emergencyServiceCategory(), legacy);
TTCN_Logger::log_event_str(", spare_1 := ");
single_value->field_spare__1.log_match(match_value.spare__1(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ServiceCategory_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_emergencyServiceCategory.encode_text(text_buf);
single_value->field_spare__1.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.ServiceCategory.");
}
}

void ServiceCategory_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_emergencyServiceCategory.decode_text(text_buf);
single_value->field_spare__1.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ServiceCategory_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.ServiceCategory.");
}
}

void ServiceCategory_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ServiceCategory_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.ServiceCategory has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) emergencyServiceCategory().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare__1().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "emergencyServiceCategory")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          emergencyServiceCategory().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare_1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare__1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.ServiceCategory: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ServiceCategory_template* precondition = new ServiceCategory_template;
    precondition->set_param(*param.get_elem(0));
    ServiceCategory_template* implied_template = new ServiceCategory_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ServiceCategory_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.ServiceCategory");
  }
  is_ifpresent = param.get_ifpresent();
}

void ServiceCategory_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.ServiceCategory");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.ServiceCategory");
single_value->field_emergencyServiceCategory.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.ServiceCategory");
single_value->field_spare__1.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.ServiceCategory");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.ServiceCategory");
}

boolean ServiceCategory_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ServiceCategory_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

NetworkInitiatedServiceUpgradeIndicator::NetworkInitiatedServiceUpgradeIndicator()
{
}

NetworkInitiatedServiceUpgradeIndicator::NetworkInitiatedServiceUpgradeIndicator(const OCTETSTRING& par_elementIdentifier)
  :   field_elementIdentifier(par_elementIdentifier)
{
}

NetworkInitiatedServiceUpgradeIndicator::NetworkInitiatedServiceUpgradeIndicator(const NetworkInitiatedServiceUpgradeIndicator& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
}

void NetworkInitiatedServiceUpgradeIndicator::clean_up()
{
field_elementIdentifier.clean_up();
}

const TTCN_Typedescriptor_t* NetworkInitiatedServiceUpgradeIndicator::get_descriptor() const { return &NetworkInitiatedServiceUpgradeIndicator_descr_; }
NetworkInitiatedServiceUpgradeIndicator& NetworkInitiatedServiceUpgradeIndicator::operator=(const NetworkInitiatedServiceUpgradeIndicator& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
}
return *this;
}

boolean NetworkInitiatedServiceUpgradeIndicator::operator==(const NetworkInitiatedServiceUpgradeIndicator& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier;
}

boolean NetworkInitiatedServiceUpgradeIndicator::is_bound() const
{
return (field_elementIdentifier.is_bound());
}
boolean NetworkInitiatedServiceUpgradeIndicator::is_value() const
{
return field_elementIdentifier.is_value();
}
void NetworkInitiatedServiceUpgradeIndicator::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(" }");
}

void NetworkInitiatedServiceUpgradeIndicator::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
}

void NetworkInitiatedServiceUpgradeIndicator::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator");
  }
}

void NetworkInitiatedServiceUpgradeIndicator::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
}

void NetworkInitiatedServiceUpgradeIndicator::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
}

void NetworkInitiatedServiceUpgradeIndicator::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void NetworkInitiatedServiceUpgradeIndicator::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int NetworkInitiatedServiceUpgradeIndicator::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int NetworkInitiatedServiceUpgradeIndicator::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 1;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(1);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  return myleaf.length = encoded_length;
}

struct NetworkInitiatedServiceUpgradeIndicator_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
};

void NetworkInitiatedServiceUpgradeIndicator_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
}
}
}

void NetworkInitiatedServiceUpgradeIndicator_template::copy_value(const NetworkInitiatedServiceUpgradeIndicator& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void NetworkInitiatedServiceUpgradeIndicator_template::copy_template(const NetworkInitiatedServiceUpgradeIndicator_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new NetworkInitiatedServiceUpgradeIndicator_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new NetworkInitiatedServiceUpgradeIndicator_template(*other_value.implication_.precondition);
implication_.implied_template = new NetworkInitiatedServiceUpgradeIndicator_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator.");
break;
}
set_selection(other_value);
}

NetworkInitiatedServiceUpgradeIndicator_template::NetworkInitiatedServiceUpgradeIndicator_template()
{
}

NetworkInitiatedServiceUpgradeIndicator_template::NetworkInitiatedServiceUpgradeIndicator_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

NetworkInitiatedServiceUpgradeIndicator_template::NetworkInitiatedServiceUpgradeIndicator_template(const NetworkInitiatedServiceUpgradeIndicator& other_value)
{
copy_value(other_value);
}

NetworkInitiatedServiceUpgradeIndicator_template::NetworkInitiatedServiceUpgradeIndicator_template(const OPTIONAL<NetworkInitiatedServiceUpgradeIndicator>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NetworkInitiatedServiceUpgradeIndicator&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator from an unbound optional field.");
}
}

NetworkInitiatedServiceUpgradeIndicator_template::NetworkInitiatedServiceUpgradeIndicator_template(NetworkInitiatedServiceUpgradeIndicator_template* p_precondition, NetworkInitiatedServiceUpgradeIndicator_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

NetworkInitiatedServiceUpgradeIndicator_template::NetworkInitiatedServiceUpgradeIndicator_template(Dynamic_Match_Interface<NetworkInitiatedServiceUpgradeIndicator>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<NetworkInitiatedServiceUpgradeIndicator>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

NetworkInitiatedServiceUpgradeIndicator_template::NetworkInitiatedServiceUpgradeIndicator_template(const NetworkInitiatedServiceUpgradeIndicator_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

NetworkInitiatedServiceUpgradeIndicator_template::~NetworkInitiatedServiceUpgradeIndicator_template()
{
clean_up();
}

NetworkInitiatedServiceUpgradeIndicator_template& NetworkInitiatedServiceUpgradeIndicator_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

NetworkInitiatedServiceUpgradeIndicator_template& NetworkInitiatedServiceUpgradeIndicator_template::operator=(const NetworkInitiatedServiceUpgradeIndicator& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

NetworkInitiatedServiceUpgradeIndicator_template& NetworkInitiatedServiceUpgradeIndicator_template::operator=(const OPTIONAL<NetworkInitiatedServiceUpgradeIndicator>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NetworkInitiatedServiceUpgradeIndicator&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator.");
}
return *this;
}

NetworkInitiatedServiceUpgradeIndicator_template& NetworkInitiatedServiceUpgradeIndicator_template::operator=(const NetworkInitiatedServiceUpgradeIndicator_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean NetworkInitiatedServiceUpgradeIndicator_template::match(const NetworkInitiatedServiceUpgradeIndicator& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator.");
}
return FALSE;
}

boolean NetworkInitiatedServiceUpgradeIndicator_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound();
}

boolean NetworkInitiatedServiceUpgradeIndicator_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value();
}

void NetworkInitiatedServiceUpgradeIndicator_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

NetworkInitiatedServiceUpgradeIndicator NetworkInitiatedServiceUpgradeIndicator_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator.");
NetworkInitiatedServiceUpgradeIndicator ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
return ret_val;
}

void NetworkInitiatedServiceUpgradeIndicator_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new NetworkInitiatedServiceUpgradeIndicator_template[list_length];
}

NetworkInitiatedServiceUpgradeIndicator_template& NetworkInitiatedServiceUpgradeIndicator_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& NetworkInitiatedServiceUpgradeIndicator_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& NetworkInitiatedServiceUpgradeIndicator_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator.");
return single_value->field_elementIdentifier;
}

int NetworkInitiatedServiceUpgradeIndicator_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator.");
  }
  return 0;
}

void NetworkInitiatedServiceUpgradeIndicator_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void NetworkInitiatedServiceUpgradeIndicator_template::log_match(const NetworkInitiatedServiceUpgradeIndicator& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void NetworkInitiatedServiceUpgradeIndicator_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator.");
}
}

void NetworkInitiatedServiceUpgradeIndicator_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new NetworkInitiatedServiceUpgradeIndicator_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator.");
}
}

void NetworkInitiatedServiceUpgradeIndicator_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    NetworkInitiatedServiceUpgradeIndicator_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    NetworkInitiatedServiceUpgradeIndicator_template* precondition = new NetworkInitiatedServiceUpgradeIndicator_template;
    precondition->set_param(*param.get_elem(0));
    NetworkInitiatedServiceUpgradeIndicator_template* implied_template = new NetworkInitiatedServiceUpgradeIndicator_template;
    implied_template->set_param(*param.get_elem(1));
    *this = NetworkInitiatedServiceUpgradeIndicator_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator");
  }
  is_ifpresent = param.get_ifpresent();
}

void NetworkInitiatedServiceUpgradeIndicator_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.NetworkInitiatedServiceUpgradeIndicator");
}

boolean NetworkInitiatedServiceUpgradeIndicator_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean NetworkInitiatedServiceUpgradeIndicator_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__ML3__Alerting__NW__MS::PDU__ML3__Alerting__NW__MS()
{
}

PDU__ML3__Alerting__NW__MS::PDU__ML3__Alerting__NW__MS(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd,
    const OPTIONAL< MobileL3__CommonIE__Types::Facility__TLV >& par_facility,
    const OPTIONAL< ProgressIndicator__TLV >& par_progressIndicator,
    const OPTIONAL< User__user__TLV >& par_user__user)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd),
  field_facility(par_facility),
  field_progressIndicator(par_progressIndicator),
  field_user__user(par_user__user)
{
}

PDU__ML3__Alerting__NW__MS::PDU__ML3__Alerting__NW__MS(const PDU__ML3__Alerting__NW__MS& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
if (other_value.facility().is_bound()) field_facility = other_value.facility();
else field_facility.clean_up();
if (other_value.progressIndicator().is_bound()) field_progressIndicator = other_value.progressIndicator();
else field_progressIndicator.clean_up();
if (other_value.user__user().is_bound()) field_user__user = other_value.user__user();
else field_user__user.clean_up();
}

void PDU__ML3__Alerting__NW__MS::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
field_facility.clean_up();
field_progressIndicator.clean_up();
field_user__user.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__Alerting__NW__MS::get_descriptor() const { return &PDU__ML3__Alerting__NW__MS_descr_; }
PDU__ML3__Alerting__NW__MS& PDU__ML3__Alerting__NW__MS::operator=(const PDU__ML3__Alerting__NW__MS& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
  if (other_value.facility().is_bound()) field_facility = other_value.facility();
  else field_facility.clean_up();
  if (other_value.progressIndicator().is_bound()) field_progressIndicator = other_value.progressIndicator();
  else field_progressIndicator.clean_up();
  if (other_value.user__user().is_bound()) field_user__user = other_value.user__user();
  else field_user__user.clean_up();
}
return *this;
}

boolean PDU__ML3__Alerting__NW__MS::operator==(const PDU__ML3__Alerting__NW__MS& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd
  && field_facility==other_value.field_facility
  && field_progressIndicator==other_value.field_progressIndicator
  && field_user__user==other_value.field_user__user;
}

boolean PDU__ML3__Alerting__NW__MS::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound())
  || (OPTIONAL_OMIT == field_facility.get_selection() || field_facility.is_bound())
  || (OPTIONAL_OMIT == field_progressIndicator.get_selection() || field_progressIndicator.is_bound())
  || (OPTIONAL_OMIT == field_user__user.get_selection() || field_user__user.is_bound());
}
boolean PDU__ML3__Alerting__NW__MS::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value()
  && (OPTIONAL_OMIT == field_facility.get_selection() || field_facility.is_value())
  && (OPTIONAL_OMIT == field_progressIndicator.get_selection() || field_progressIndicator.is_value())
  && (OPTIONAL_OMIT == field_user__user.get_selection() || field_user__user.is_value());
}
int PDU__ML3__Alerting__NW__MS::size_of() const
{
  int ret_val = 2;
  if (field_facility.ispresent()) ret_val++;
  if (field_progressIndicator.ispresent()) ret_val++;
  if (field_user__user.ispresent()) ret_val++;
  return ret_val;
}

void PDU__ML3__Alerting__NW__MS::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(", facility := ");
field_facility.log();
TTCN_Logger::log_event_str(", progressIndicator := ");
field_progressIndicator.log();
TTCN_Logger::log_event_str(", user_user := ");
field_user__user.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__Alerting__NW__MS::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (!facility().is_bound()) facility() = OMIT_VALUE;
else facility().set_implicit_omit();
if (!progressIndicator().is_bound()) progressIndicator() = OMIT_VALUE;
else progressIndicator().set_implicit_omit();
if (!user__user().is_bound()) user__user() = OMIT_VALUE;
else user__user().set_implicit_omit();
}

void PDU__ML3__Alerting__NW__MS::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) facility().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) progressIndicator().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) user__user().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "progressIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          progressIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_user")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__user().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS");
  }
}

void PDU__ML3__Alerting__NW__MS::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
field_facility.encode_text(text_buf);
field_progressIndicator.encode_text(text_buf);
field_user__user.encode_text(text_buf);
}

void PDU__ML3__Alerting__NW__MS::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
field_facility.decode_text(text_buf);
field_progressIndicator.decode_text(text_buf);
field_user__user.decode_text(text_buf);
}

void PDU__ML3__Alerting__NW__MS::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__Alerting__NW__MS::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__Alerting__NW__MS::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_facility = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, MobileL3__CommonIE__Types::Facility__TLV_descr_.raw->forceomit);
  decoded_field_length = field_facility().RAW_decode(MobileL3__CommonIE__Types::Facility__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_facility = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_facility.ispresent() || field_facility().elementIdentifier() !=  os_0){
  field_facility=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_facility=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_progressIndicator = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, ProgressIndicator__TLV_descr_.raw->forceomit);
  decoded_field_length = field_progressIndicator().RAW_decode(ProgressIndicator__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_progressIndicator = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_progressIndicator.ispresent() || field_progressIndicator().elementIdentifier() !=  os_1){
  field_progressIndicator=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_progressIndicator=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_user__user = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, User__user__TLV_descr_.raw->forceomit);
  decoded_field_length = field_user__user().RAW_decode(User__user__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_user__user = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_user__user.ispresent() || field_user__user().elementIdentifier() !=  os_2){
  field_user__user=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_user__user=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__Alerting__NW__MS::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  if (field_facility.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, MobileL3__CommonIE__Types::Facility__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_progressIndicator.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, ProgressIndicator__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_user__user.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, User__user__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  if (field_facility.ispresent()) {
  encoded_length += field_facility().RAW_encode(MobileL3__CommonIE__Types::Facility__TLV_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_progressIndicator.ispresent()) {
  encoded_length += field_progressIndicator().RAW_encode(ProgressIndicator__TLV_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_user__user.ispresent()) {
  encoded_length += field_user__user().RAW_encode(User__user__TLV_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_facility.ispresent() && (!field_facility.ispresent() || field_facility().elementIdentifier() !=  os_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={2,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_0.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_progressIndicator.ispresent() && (!field_progressIndicator.ispresent() || field_progressIndicator().elementIdentifier() !=  os_1)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={3,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_1.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_user__user.ispresent() && (!field_user__user.ispresent() || field_user__user().elementIdentifier() !=  os_2)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={4,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_2.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__ML3__Alerting__NW__MS_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
MobileL3__CommonIE__Types::Facility__TLV_template field_facility;
ProgressIndicator__TLV_template field_progressIndicator;
User__user__TLV_template field_user__user;
};

void PDU__ML3__Alerting__NW__MS_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
single_value->field_facility = ANY_OR_OMIT;
single_value->field_progressIndicator = ANY_OR_OMIT;
single_value->field_user__user = ANY_OR_OMIT;
}
}
}

void PDU__ML3__Alerting__NW__MS_template::copy_value(const PDU__ML3__Alerting__NW__MS& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
if (other_value.facility().is_bound()) {
  if (other_value.facility().ispresent()) single_value->field_facility = other_value.facility()();
  else single_value->field_facility = OMIT_VALUE;
} else {
  single_value->field_facility.clean_up();
}
if (other_value.progressIndicator().is_bound()) {
  if (other_value.progressIndicator().ispresent()) single_value->field_progressIndicator = other_value.progressIndicator()();
  else single_value->field_progressIndicator = OMIT_VALUE;
} else {
  single_value->field_progressIndicator.clean_up();
}
if (other_value.user__user().is_bound()) {
  if (other_value.user__user().ispresent()) single_value->field_user__user = other_value.user__user()();
  else single_value->field_user__user = OMIT_VALUE;
} else {
  single_value->field_user__user.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__Alerting__NW__MS_template::copy_template(const PDU__ML3__Alerting__NW__MS_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.facility().get_selection()) {
single_value->field_facility = other_value.facility();
} else {
single_value->field_facility.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.progressIndicator().get_selection()) {
single_value->field_progressIndicator = other_value.progressIndicator();
} else {
single_value->field_progressIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.user__user().get_selection()) {
single_value->field_user__user = other_value.user__user();
} else {
single_value->field_user__user.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__Alerting__NW__MS_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__Alerting__NW__MS_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__Alerting__NW__MS_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS.");
break;
}
set_selection(other_value);
}

PDU__ML3__Alerting__NW__MS_template::PDU__ML3__Alerting__NW__MS_template()
{
}

PDU__ML3__Alerting__NW__MS_template::PDU__ML3__Alerting__NW__MS_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__Alerting__NW__MS_template::PDU__ML3__Alerting__NW__MS_template(const PDU__ML3__Alerting__NW__MS& other_value)
{
copy_value(other_value);
}

PDU__ML3__Alerting__NW__MS_template::PDU__ML3__Alerting__NW__MS_template(const OPTIONAL<PDU__ML3__Alerting__NW__MS>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__Alerting__NW__MS&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS from an unbound optional field.");
}
}

PDU__ML3__Alerting__NW__MS_template::PDU__ML3__Alerting__NW__MS_template(PDU__ML3__Alerting__NW__MS_template* p_precondition, PDU__ML3__Alerting__NW__MS_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__Alerting__NW__MS_template::PDU__ML3__Alerting__NW__MS_template(Dynamic_Match_Interface<PDU__ML3__Alerting__NW__MS>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__Alerting__NW__MS>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__Alerting__NW__MS_template::PDU__ML3__Alerting__NW__MS_template(const PDU__ML3__Alerting__NW__MS_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__Alerting__NW__MS_template::~PDU__ML3__Alerting__NW__MS_template()
{
clean_up();
}

PDU__ML3__Alerting__NW__MS_template& PDU__ML3__Alerting__NW__MS_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__Alerting__NW__MS_template& PDU__ML3__Alerting__NW__MS_template::operator=(const PDU__ML3__Alerting__NW__MS& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__Alerting__NW__MS_template& PDU__ML3__Alerting__NW__MS_template::operator=(const OPTIONAL<PDU__ML3__Alerting__NW__MS>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__Alerting__NW__MS&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS.");
}
return *this;
}

PDU__ML3__Alerting__NW__MS_template& PDU__ML3__Alerting__NW__MS_template::operator=(const PDU__ML3__Alerting__NW__MS_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__Alerting__NW__MS_template::match(const PDU__ML3__Alerting__NW__MS& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
if(!other_value.facility().is_bound()) return FALSE;
if((other_value.facility().ispresent() ? !single_value->field_facility.match((const MobileL3__CommonIE__Types::Facility__TLV&)other_value.facility(), legacy) : !single_value->field_facility.match_omit(legacy)))return FALSE;
if(!other_value.progressIndicator().is_bound()) return FALSE;
if((other_value.progressIndicator().ispresent() ? !single_value->field_progressIndicator.match((const ProgressIndicator__TLV&)other_value.progressIndicator(), legacy) : !single_value->field_progressIndicator.match_omit(legacy)))return FALSE;
if(!other_value.user__user().is_bound()) return FALSE;
if((other_value.user__user().ispresent() ? !single_value->field_user__user.match((const User__user__TLV&)other_value.user__user(), legacy) : !single_value->field_user__user.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS.");
}
return FALSE;
}

boolean PDU__ML3__Alerting__NW__MS_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound()
 || (single_value->field_facility.is_omit() || single_value->field_facility.is_bound())
 || (single_value->field_progressIndicator.is_omit() || single_value->field_progressIndicator.is_bound())
 || (single_value->field_user__user.is_omit() || single_value->field_user__user.is_bound());
}

boolean PDU__ML3__Alerting__NW__MS_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value()
 && (single_value->field_facility.is_omit() || single_value->field_facility.is_value())
 && (single_value->field_progressIndicator.is_omit() || single_value->field_progressIndicator.is_value())
 && (single_value->field_user__user.is_omit() || single_value->field_user__user.is_value());
}

void PDU__ML3__Alerting__NW__MS_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__Alerting__NW__MS PDU__ML3__Alerting__NW__MS_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS.");
PDU__ML3__Alerting__NW__MS ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
if (single_value->field_facility.is_omit()) ret_val.facility() = OMIT_VALUE;
else if (single_value->field_facility.is_bound()) {
ret_val.facility() = single_value->field_facility.valueof();
}
if (single_value->field_progressIndicator.is_omit()) ret_val.progressIndicator() = OMIT_VALUE;
else if (single_value->field_progressIndicator.is_bound()) {
ret_val.progressIndicator() = single_value->field_progressIndicator.valueof();
}
if (single_value->field_user__user.is_omit()) ret_val.user__user() = OMIT_VALUE;
else if (single_value->field_user__user.is_bound()) {
ret_val.user__user() = single_value->field_user__user.valueof();
}
return ret_val;
}

void PDU__ML3__Alerting__NW__MS_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__Alerting__NW__MS_template[list_length];
}

PDU__ML3__Alerting__NW__MS_template& PDU__ML3__Alerting__NW__MS_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__Alerting__NW__MS_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__Alerting__NW__MS_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__Alerting__NW__MS_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__Alerting__NW__MS_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS.");
return single_value->field_nsd;
}

MobileL3__CommonIE__Types::Facility__TLV_template& PDU__ML3__Alerting__NW__MS_template::facility()
{
set_specific();
return single_value->field_facility;
}

const MobileL3__CommonIE__Types::Facility__TLV_template& PDU__ML3__Alerting__NW__MS_template::facility() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field facility of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS.");
return single_value->field_facility;
}

ProgressIndicator__TLV_template& PDU__ML3__Alerting__NW__MS_template::progressIndicator()
{
set_specific();
return single_value->field_progressIndicator;
}

const ProgressIndicator__TLV_template& PDU__ML3__Alerting__NW__MS_template::progressIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field progressIndicator of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS.");
return single_value->field_progressIndicator;
}

User__user__TLV_template& PDU__ML3__Alerting__NW__MS_template::user__user()
{
set_specific();
return single_value->field_user__user;
}

const User__user__TLV_template& PDU__ML3__Alerting__NW__MS_template::user__user() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field user_user of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS.");
return single_value->field_user__user;
}

int PDU__ML3__Alerting__NW__MS_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_facility.is_present()) ret_val++;
      if (single_value->field_progressIndicator.is_present()) ret_val++;
      if (single_value->field_user__user.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS.");
  }
  return 0;
}

void PDU__ML3__Alerting__NW__MS_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(", facility := ");
single_value->field_facility.log();
TTCN_Logger::log_event_str(", progressIndicator := ");
single_value->field_progressIndicator.log();
TTCN_Logger::log_event_str(", user_user := ");
single_value->field_user__user.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__Alerting__NW__MS_template::log_match(const PDU__ML3__Alerting__NW__MS& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.facility().ispresent()){
if(!single_value->field_facility.match(match_value.facility(), legacy)){
TTCN_Logger::log_logmatch_info(".facility");
single_value->field_facility.log_match(match_value.facility(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_facility.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".facility := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_facility.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.progressIndicator().ispresent()){
if(!single_value->field_progressIndicator.match(match_value.progressIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".progressIndicator");
single_value->field_progressIndicator.log_match(match_value.progressIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_progressIndicator.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".progressIndicator := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_progressIndicator.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.user__user().ispresent()){
if(!single_value->field_user__user.match(match_value.user__user(), legacy)){
TTCN_Logger::log_logmatch_info(".user_user");
single_value->field_user__user.log_match(match_value.user__user(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_user__user.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".user_user := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_user__user.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(", facility := ");
if (match_value.facility().ispresent()) {
single_value->field_facility.log_match(match_value.facility(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_facility.log();
if (single_value->field_facility.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", progressIndicator := ");
if (match_value.progressIndicator().ispresent()) {
single_value->field_progressIndicator.log_match(match_value.progressIndicator(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_progressIndicator.log();
if (single_value->field_progressIndicator.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", user_user := ");
if (match_value.user__user().ispresent()) {
single_value->field_user__user.log_match(match_value.user__user(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_user__user.log();
if (single_value->field_user__user.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__Alerting__NW__MS_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
single_value->field_facility.encode_text(text_buf);
single_value->field_progressIndicator.encode_text(text_buf);
single_value->field_user__user.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS.");
}
}

void PDU__ML3__Alerting__NW__MS_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
single_value->field_facility.decode_text(text_buf);
single_value->field_progressIndicator.decode_text(text_buf);
single_value->field_user__user.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__Alerting__NW__MS_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS.");
}
}

void PDU__ML3__Alerting__NW__MS_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__Alerting__NW__MS_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) facility().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) progressIndicator().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) user__user().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "progressIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          progressIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_user")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__user().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__Alerting__NW__MS_template* precondition = new PDU__ML3__Alerting__NW__MS_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__Alerting__NW__MS_template* implied_template = new PDU__ML3__Alerting__NW__MS_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__Alerting__NW__MS_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__Alerting__NW__MS_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS");
single_value->field_facility.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS");
single_value->field_progressIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS");
single_value->field_user__user.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Alerting_NW_MS");
}

boolean PDU__ML3__Alerting__NW__MS_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__Alerting__NW__MS_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__ML3__Alerting__MS__NW::PDU__ML3__Alerting__MS__NW()
{
}

PDU__ML3__Alerting__MS__NW::PDU__ML3__Alerting__MS__NW(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd,
    const OPTIONAL< MobileL3__CommonIE__Types::Facility__TLV >& par_facility,
    const OPTIONAL< User__user__TLV >& par_user__user,
    const OPTIONAL< MobileL3__CommonIE__Types::SS__VersionIndicator >& par_ss__VersionIndicator)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd),
  field_facility(par_facility),
  field_user__user(par_user__user),
  field_ss__VersionIndicator(par_ss__VersionIndicator)
{
}

PDU__ML3__Alerting__MS__NW::PDU__ML3__Alerting__MS__NW(const PDU__ML3__Alerting__MS__NW& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
if (other_value.facility().is_bound()) field_facility = other_value.facility();
else field_facility.clean_up();
if (other_value.user__user().is_bound()) field_user__user = other_value.user__user();
else field_user__user.clean_up();
if (other_value.ss__VersionIndicator().is_bound()) field_ss__VersionIndicator = other_value.ss__VersionIndicator();
else field_ss__VersionIndicator.clean_up();
}

void PDU__ML3__Alerting__MS__NW::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
field_facility.clean_up();
field_user__user.clean_up();
field_ss__VersionIndicator.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__Alerting__MS__NW::get_descriptor() const { return &PDU__ML3__Alerting__MS__NW_descr_; }
PDU__ML3__Alerting__MS__NW& PDU__ML3__Alerting__MS__NW::operator=(const PDU__ML3__Alerting__MS__NW& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
  if (other_value.facility().is_bound()) field_facility = other_value.facility();
  else field_facility.clean_up();
  if (other_value.user__user().is_bound()) field_user__user = other_value.user__user();
  else field_user__user.clean_up();
  if (other_value.ss__VersionIndicator().is_bound()) field_ss__VersionIndicator = other_value.ss__VersionIndicator();
  else field_ss__VersionIndicator.clean_up();
}
return *this;
}

boolean PDU__ML3__Alerting__MS__NW::operator==(const PDU__ML3__Alerting__MS__NW& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd
  && field_facility==other_value.field_facility
  && field_user__user==other_value.field_user__user
  && field_ss__VersionIndicator==other_value.field_ss__VersionIndicator;
}

boolean PDU__ML3__Alerting__MS__NW::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound())
  || (OPTIONAL_OMIT == field_facility.get_selection() || field_facility.is_bound())
  || (OPTIONAL_OMIT == field_user__user.get_selection() || field_user__user.is_bound())
  || (OPTIONAL_OMIT == field_ss__VersionIndicator.get_selection() || field_ss__VersionIndicator.is_bound());
}
boolean PDU__ML3__Alerting__MS__NW::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value()
  && (OPTIONAL_OMIT == field_facility.get_selection() || field_facility.is_value())
  && (OPTIONAL_OMIT == field_user__user.get_selection() || field_user__user.is_value())
  && (OPTIONAL_OMIT == field_ss__VersionIndicator.get_selection() || field_ss__VersionIndicator.is_value());
}
int PDU__ML3__Alerting__MS__NW::size_of() const
{
  int ret_val = 2;
  if (field_facility.ispresent()) ret_val++;
  if (field_user__user.ispresent()) ret_val++;
  if (field_ss__VersionIndicator.ispresent()) ret_val++;
  return ret_val;
}

void PDU__ML3__Alerting__MS__NW::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(", facility := ");
field_facility.log();
TTCN_Logger::log_event_str(", user_user := ");
field_user__user.log();
TTCN_Logger::log_event_str(", ss_VersionIndicator := ");
field_ss__VersionIndicator.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__Alerting__MS__NW::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (!facility().is_bound()) facility() = OMIT_VALUE;
else facility().set_implicit_omit();
if (!user__user().is_bound()) user__user() = OMIT_VALUE;
else user__user().set_implicit_omit();
if (!ss__VersionIndicator().is_bound()) ss__VersionIndicator() = OMIT_VALUE;
else ss__VersionIndicator().set_implicit_omit();
}

void PDU__ML3__Alerting__MS__NW::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) facility().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) user__user().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) ss__VersionIndicator().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_user")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__user().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_VersionIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__VersionIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW");
  }
}

void PDU__ML3__Alerting__MS__NW::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
field_facility.encode_text(text_buf);
field_user__user.encode_text(text_buf);
field_ss__VersionIndicator.encode_text(text_buf);
}

void PDU__ML3__Alerting__MS__NW::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
field_facility.decode_text(text_buf);
field_user__user.decode_text(text_buf);
field_ss__VersionIndicator.decode_text(text_buf);
}

void PDU__ML3__Alerting__MS__NW::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__Alerting__MS__NW::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__Alerting__MS__NW::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_facility = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, MobileL3__CommonIE__Types::Facility__TLV_descr_.raw->forceomit);
  decoded_field_length = field_facility().RAW_decode(MobileL3__CommonIE__Types::Facility__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_facility = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_facility.ispresent() || field_facility().elementIdentifier() !=  os_0){
  field_facility=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_facility=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_user__user = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, User__user__TLV_descr_.raw->forceomit);
  decoded_field_length = field_user__user().RAW_decode(User__user__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_user__user = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_user__user.ispresent() || field_user__user().elementIdentifier() !=  os_2){
  field_user__user=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_user__user=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_ss__VersionIndicator = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, MobileL3__CommonIE__Types::SS__VersionIndicator_descr_.raw->forceomit);
  decoded_field_length = field_ss__VersionIndicator().RAW_decode(MobileL3__CommonIE__Types::SS__VersionIndicator_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_ss__VersionIndicator = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_ss__VersionIndicator.ispresent() || field_ss__VersionIndicator().elementIdentifier() !=  os_3){
  field_ss__VersionIndicator=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_ss__VersionIndicator=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__Alerting__MS__NW::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  if (field_facility.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, MobileL3__CommonIE__Types::Facility__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_user__user.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, User__user__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_ss__VersionIndicator.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, MobileL3__CommonIE__Types::SS__VersionIndicator_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  if (field_facility.ispresent()) {
  encoded_length += field_facility().RAW_encode(MobileL3__CommonIE__Types::Facility__TLV_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_user__user.ispresent()) {
  encoded_length += field_user__user().RAW_encode(User__user__TLV_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_ss__VersionIndicator.ispresent()) {
  encoded_length += field_ss__VersionIndicator().RAW_encode(MobileL3__CommonIE__Types::SS__VersionIndicator_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_facility.ispresent() && (!field_facility.ispresent() || field_facility().elementIdentifier() !=  os_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={2,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_0.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_user__user.ispresent() && (!field_user__user.ispresent() || field_user__user().elementIdentifier() !=  os_2)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={3,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_2.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_ss__VersionIndicator.ispresent() && (!field_ss__VersionIndicator.ispresent() || field_ss__VersionIndicator().elementIdentifier() !=  os_3)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={4,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_3.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__ML3__Alerting__MS__NW_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
MobileL3__CommonIE__Types::Facility__TLV_template field_facility;
User__user__TLV_template field_user__user;
MobileL3__CommonIE__Types::SS__VersionIndicator_template field_ss__VersionIndicator;
};

void PDU__ML3__Alerting__MS__NW_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
single_value->field_facility = ANY_OR_OMIT;
single_value->field_user__user = ANY_OR_OMIT;
single_value->field_ss__VersionIndicator = ANY_OR_OMIT;
}
}
}

void PDU__ML3__Alerting__MS__NW_template::copy_value(const PDU__ML3__Alerting__MS__NW& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
if (other_value.facility().is_bound()) {
  if (other_value.facility().ispresent()) single_value->field_facility = other_value.facility()();
  else single_value->field_facility = OMIT_VALUE;
} else {
  single_value->field_facility.clean_up();
}
if (other_value.user__user().is_bound()) {
  if (other_value.user__user().ispresent()) single_value->field_user__user = other_value.user__user()();
  else single_value->field_user__user = OMIT_VALUE;
} else {
  single_value->field_user__user.clean_up();
}
if (other_value.ss__VersionIndicator().is_bound()) {
  if (other_value.ss__VersionIndicator().ispresent()) single_value->field_ss__VersionIndicator = other_value.ss__VersionIndicator()();
  else single_value->field_ss__VersionIndicator = OMIT_VALUE;
} else {
  single_value->field_ss__VersionIndicator.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__Alerting__MS__NW_template::copy_template(const PDU__ML3__Alerting__MS__NW_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.facility().get_selection()) {
single_value->field_facility = other_value.facility();
} else {
single_value->field_facility.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.user__user().get_selection()) {
single_value->field_user__user = other_value.user__user();
} else {
single_value->field_user__user.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ss__VersionIndicator().get_selection()) {
single_value->field_ss__VersionIndicator = other_value.ss__VersionIndicator();
} else {
single_value->field_ss__VersionIndicator.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__Alerting__MS__NW_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__Alerting__MS__NW_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__Alerting__MS__NW_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW.");
break;
}
set_selection(other_value);
}

PDU__ML3__Alerting__MS__NW_template::PDU__ML3__Alerting__MS__NW_template()
{
}

PDU__ML3__Alerting__MS__NW_template::PDU__ML3__Alerting__MS__NW_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__Alerting__MS__NW_template::PDU__ML3__Alerting__MS__NW_template(const PDU__ML3__Alerting__MS__NW& other_value)
{
copy_value(other_value);
}

PDU__ML3__Alerting__MS__NW_template::PDU__ML3__Alerting__MS__NW_template(const OPTIONAL<PDU__ML3__Alerting__MS__NW>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__Alerting__MS__NW&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW from an unbound optional field.");
}
}

PDU__ML3__Alerting__MS__NW_template::PDU__ML3__Alerting__MS__NW_template(PDU__ML3__Alerting__MS__NW_template* p_precondition, PDU__ML3__Alerting__MS__NW_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__Alerting__MS__NW_template::PDU__ML3__Alerting__MS__NW_template(Dynamic_Match_Interface<PDU__ML3__Alerting__MS__NW>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__Alerting__MS__NW>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__Alerting__MS__NW_template::PDU__ML3__Alerting__MS__NW_template(const PDU__ML3__Alerting__MS__NW_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__Alerting__MS__NW_template::~PDU__ML3__Alerting__MS__NW_template()
{
clean_up();
}

PDU__ML3__Alerting__MS__NW_template& PDU__ML3__Alerting__MS__NW_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__Alerting__MS__NW_template& PDU__ML3__Alerting__MS__NW_template::operator=(const PDU__ML3__Alerting__MS__NW& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__Alerting__MS__NW_template& PDU__ML3__Alerting__MS__NW_template::operator=(const OPTIONAL<PDU__ML3__Alerting__MS__NW>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__Alerting__MS__NW&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW.");
}
return *this;
}

PDU__ML3__Alerting__MS__NW_template& PDU__ML3__Alerting__MS__NW_template::operator=(const PDU__ML3__Alerting__MS__NW_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__Alerting__MS__NW_template::match(const PDU__ML3__Alerting__MS__NW& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
if(!other_value.facility().is_bound()) return FALSE;
if((other_value.facility().ispresent() ? !single_value->field_facility.match((const MobileL3__CommonIE__Types::Facility__TLV&)other_value.facility(), legacy) : !single_value->field_facility.match_omit(legacy)))return FALSE;
if(!other_value.user__user().is_bound()) return FALSE;
if((other_value.user__user().ispresent() ? !single_value->field_user__user.match((const User__user__TLV&)other_value.user__user(), legacy) : !single_value->field_user__user.match_omit(legacy)))return FALSE;
if(!other_value.ss__VersionIndicator().is_bound()) return FALSE;
if((other_value.ss__VersionIndicator().ispresent() ? !single_value->field_ss__VersionIndicator.match((const MobileL3__CommonIE__Types::SS__VersionIndicator&)other_value.ss__VersionIndicator(), legacy) : !single_value->field_ss__VersionIndicator.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW.");
}
return FALSE;
}

boolean PDU__ML3__Alerting__MS__NW_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound()
 || (single_value->field_facility.is_omit() || single_value->field_facility.is_bound())
 || (single_value->field_user__user.is_omit() || single_value->field_user__user.is_bound())
 || (single_value->field_ss__VersionIndicator.is_omit() || single_value->field_ss__VersionIndicator.is_bound());
}

boolean PDU__ML3__Alerting__MS__NW_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value()
 && (single_value->field_facility.is_omit() || single_value->field_facility.is_value())
 && (single_value->field_user__user.is_omit() || single_value->field_user__user.is_value())
 && (single_value->field_ss__VersionIndicator.is_omit() || single_value->field_ss__VersionIndicator.is_value());
}

void PDU__ML3__Alerting__MS__NW_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__Alerting__MS__NW PDU__ML3__Alerting__MS__NW_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW.");
PDU__ML3__Alerting__MS__NW ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
if (single_value->field_facility.is_omit()) ret_val.facility() = OMIT_VALUE;
else if (single_value->field_facility.is_bound()) {
ret_val.facility() = single_value->field_facility.valueof();
}
if (single_value->field_user__user.is_omit()) ret_val.user__user() = OMIT_VALUE;
else if (single_value->field_user__user.is_bound()) {
ret_val.user__user() = single_value->field_user__user.valueof();
}
if (single_value->field_ss__VersionIndicator.is_omit()) ret_val.ss__VersionIndicator() = OMIT_VALUE;
else if (single_value->field_ss__VersionIndicator.is_bound()) {
ret_val.ss__VersionIndicator() = single_value->field_ss__VersionIndicator.valueof();
}
return ret_val;
}

void PDU__ML3__Alerting__MS__NW_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__Alerting__MS__NW_template[list_length];
}

PDU__ML3__Alerting__MS__NW_template& PDU__ML3__Alerting__MS__NW_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__Alerting__MS__NW_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__Alerting__MS__NW_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__Alerting__MS__NW_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__Alerting__MS__NW_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW.");
return single_value->field_nsd;
}

MobileL3__CommonIE__Types::Facility__TLV_template& PDU__ML3__Alerting__MS__NW_template::facility()
{
set_specific();
return single_value->field_facility;
}

const MobileL3__CommonIE__Types::Facility__TLV_template& PDU__ML3__Alerting__MS__NW_template::facility() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field facility of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW.");
return single_value->field_facility;
}

User__user__TLV_template& PDU__ML3__Alerting__MS__NW_template::user__user()
{
set_specific();
return single_value->field_user__user;
}

const User__user__TLV_template& PDU__ML3__Alerting__MS__NW_template::user__user() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field user_user of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW.");
return single_value->field_user__user;
}

MobileL3__CommonIE__Types::SS__VersionIndicator_template& PDU__ML3__Alerting__MS__NW_template::ss__VersionIndicator()
{
set_specific();
return single_value->field_ss__VersionIndicator;
}

const MobileL3__CommonIE__Types::SS__VersionIndicator_template& PDU__ML3__Alerting__MS__NW_template::ss__VersionIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ss_VersionIndicator of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW.");
return single_value->field_ss__VersionIndicator;
}

int PDU__ML3__Alerting__MS__NW_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_facility.is_present()) ret_val++;
      if (single_value->field_user__user.is_present()) ret_val++;
      if (single_value->field_ss__VersionIndicator.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW.");
  }
  return 0;
}

void PDU__ML3__Alerting__MS__NW_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(", facility := ");
single_value->field_facility.log();
TTCN_Logger::log_event_str(", user_user := ");
single_value->field_user__user.log();
TTCN_Logger::log_event_str(", ss_VersionIndicator := ");
single_value->field_ss__VersionIndicator.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__Alerting__MS__NW_template::log_match(const PDU__ML3__Alerting__MS__NW& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.facility().ispresent()){
if(!single_value->field_facility.match(match_value.facility(), legacy)){
TTCN_Logger::log_logmatch_info(".facility");
single_value->field_facility.log_match(match_value.facility(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_facility.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".facility := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_facility.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.user__user().ispresent()){
if(!single_value->field_user__user.match(match_value.user__user(), legacy)){
TTCN_Logger::log_logmatch_info(".user_user");
single_value->field_user__user.log_match(match_value.user__user(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_user__user.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".user_user := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_user__user.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.ss__VersionIndicator().ispresent()){
if(!single_value->field_ss__VersionIndicator.match(match_value.ss__VersionIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".ss_VersionIndicator");
single_value->field_ss__VersionIndicator.log_match(match_value.ss__VersionIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ss__VersionIndicator.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ss_VersionIndicator := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ss__VersionIndicator.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(", facility := ");
if (match_value.facility().ispresent()) {
single_value->field_facility.log_match(match_value.facility(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_facility.log();
if (single_value->field_facility.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", user_user := ");
if (match_value.user__user().ispresent()) {
single_value->field_user__user.log_match(match_value.user__user(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_user__user.log();
if (single_value->field_user__user.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", ss_VersionIndicator := ");
if (match_value.ss__VersionIndicator().ispresent()) {
single_value->field_ss__VersionIndicator.log_match(match_value.ss__VersionIndicator(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ss__VersionIndicator.log();
if (single_value->field_ss__VersionIndicator.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__Alerting__MS__NW_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
single_value->field_facility.encode_text(text_buf);
single_value->field_user__user.encode_text(text_buf);
single_value->field_ss__VersionIndicator.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW.");
}
}

void PDU__ML3__Alerting__MS__NW_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
single_value->field_facility.decode_text(text_buf);
single_value->field_user__user.decode_text(text_buf);
single_value->field_ss__VersionIndicator.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__Alerting__MS__NW_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW.");
}
}

void PDU__ML3__Alerting__MS__NW_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__Alerting__MS__NW_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) facility().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) user__user().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) ss__VersionIndicator().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_user")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__user().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_VersionIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__VersionIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__Alerting__MS__NW_template* precondition = new PDU__ML3__Alerting__MS__NW_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__Alerting__MS__NW_template* implied_template = new PDU__ML3__Alerting__MS__NW_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__Alerting__MS__NW_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__Alerting__MS__NW_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW");
single_value->field_facility.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW");
single_value->field_user__user.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW");
single_value->field_ss__VersionIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Alerting_MS_NW");
}

boolean PDU__ML3__Alerting__MS__NW_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__Alerting__MS__NW_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__ML3__CallConfirmed::PDU__ML3__CallConfirmed()
{
}

PDU__ML3__CallConfirmed::PDU__ML3__CallConfirmed(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd,
    const OPTIONAL< RepeatIndicator >& par_repeatIndicator,
    const OPTIONAL< BearerCapability__TLV >& par_bearerCapability1,
    const OPTIONAL< BearerCapability__TLV >& par_bearerCapability2,
    const OPTIONAL< MobileL3__CommonIE__Types::ML3__Cause__TLV >& par_cause,
    const OPTIONAL< CallControlCapabilities >& par_cC__Capabilities,
    const OPTIONAL< StreamIdentifier >& par_streamIdentifier,
    const OPTIONAL< MobileL3__CommonIE__Types::SupportedCodecList >& par_supportedCodecs)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd),
  field_repeatIndicator(par_repeatIndicator),
  field_bearerCapability1(par_bearerCapability1),
  field_bearerCapability2(par_bearerCapability2),
  field_cause(par_cause),
  field_cC__Capabilities(par_cC__Capabilities),
  field_streamIdentifier(par_streamIdentifier),
  field_supportedCodecs(par_supportedCodecs)
{
}

PDU__ML3__CallConfirmed::PDU__ML3__CallConfirmed(const PDU__ML3__CallConfirmed& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
if (other_value.repeatIndicator().is_bound()) field_repeatIndicator = other_value.repeatIndicator();
else field_repeatIndicator.clean_up();
if (other_value.bearerCapability1().is_bound()) field_bearerCapability1 = other_value.bearerCapability1();
else field_bearerCapability1.clean_up();
if (other_value.bearerCapability2().is_bound()) field_bearerCapability2 = other_value.bearerCapability2();
else field_bearerCapability2.clean_up();
if (other_value.cause().is_bound()) field_cause = other_value.cause();
else field_cause.clean_up();
if (other_value.cC__Capabilities().is_bound()) field_cC__Capabilities = other_value.cC__Capabilities();
else field_cC__Capabilities.clean_up();
if (other_value.streamIdentifier().is_bound()) field_streamIdentifier = other_value.streamIdentifier();
else field_streamIdentifier.clean_up();
if (other_value.supportedCodecs().is_bound()) field_supportedCodecs = other_value.supportedCodecs();
else field_supportedCodecs.clean_up();
}

void PDU__ML3__CallConfirmed::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
field_repeatIndicator.clean_up();
field_bearerCapability1.clean_up();
field_bearerCapability2.clean_up();
field_cause.clean_up();
field_cC__Capabilities.clean_up();
field_streamIdentifier.clean_up();
field_supportedCodecs.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__CallConfirmed::get_descriptor() const { return &PDU__ML3__CallConfirmed_descr_; }
PDU__ML3__CallConfirmed& PDU__ML3__CallConfirmed::operator=(const PDU__ML3__CallConfirmed& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
  if (other_value.repeatIndicator().is_bound()) field_repeatIndicator = other_value.repeatIndicator();
  else field_repeatIndicator.clean_up();
  if (other_value.bearerCapability1().is_bound()) field_bearerCapability1 = other_value.bearerCapability1();
  else field_bearerCapability1.clean_up();
  if (other_value.bearerCapability2().is_bound()) field_bearerCapability2 = other_value.bearerCapability2();
  else field_bearerCapability2.clean_up();
  if (other_value.cause().is_bound()) field_cause = other_value.cause();
  else field_cause.clean_up();
  if (other_value.cC__Capabilities().is_bound()) field_cC__Capabilities = other_value.cC__Capabilities();
  else field_cC__Capabilities.clean_up();
  if (other_value.streamIdentifier().is_bound()) field_streamIdentifier = other_value.streamIdentifier();
  else field_streamIdentifier.clean_up();
  if (other_value.supportedCodecs().is_bound()) field_supportedCodecs = other_value.supportedCodecs();
  else field_supportedCodecs.clean_up();
}
return *this;
}

boolean PDU__ML3__CallConfirmed::operator==(const PDU__ML3__CallConfirmed& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd
  && field_repeatIndicator==other_value.field_repeatIndicator
  && field_bearerCapability1==other_value.field_bearerCapability1
  && field_bearerCapability2==other_value.field_bearerCapability2
  && field_cause==other_value.field_cause
  && field_cC__Capabilities==other_value.field_cC__Capabilities
  && field_streamIdentifier==other_value.field_streamIdentifier
  && field_supportedCodecs==other_value.field_supportedCodecs;
}

boolean PDU__ML3__CallConfirmed::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound())
  || (OPTIONAL_OMIT == field_repeatIndicator.get_selection() || field_repeatIndicator.is_bound())
  || (OPTIONAL_OMIT == field_bearerCapability1.get_selection() || field_bearerCapability1.is_bound())
  || (OPTIONAL_OMIT == field_bearerCapability2.get_selection() || field_bearerCapability2.is_bound())
  || (OPTIONAL_OMIT == field_cause.get_selection() || field_cause.is_bound())
  || (OPTIONAL_OMIT == field_cC__Capabilities.get_selection() || field_cC__Capabilities.is_bound())
  || (OPTIONAL_OMIT == field_streamIdentifier.get_selection() || field_streamIdentifier.is_bound())
  || (OPTIONAL_OMIT == field_supportedCodecs.get_selection() || field_supportedCodecs.is_bound());
}
boolean PDU__ML3__CallConfirmed::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value()
  && (OPTIONAL_OMIT == field_repeatIndicator.get_selection() || field_repeatIndicator.is_value())
  && (OPTIONAL_OMIT == field_bearerCapability1.get_selection() || field_bearerCapability1.is_value())
  && (OPTIONAL_OMIT == field_bearerCapability2.get_selection() || field_bearerCapability2.is_value())
  && (OPTIONAL_OMIT == field_cause.get_selection() || field_cause.is_value())
  && (OPTIONAL_OMIT == field_cC__Capabilities.get_selection() || field_cC__Capabilities.is_value())
  && (OPTIONAL_OMIT == field_streamIdentifier.get_selection() || field_streamIdentifier.is_value())
  && (OPTIONAL_OMIT == field_supportedCodecs.get_selection() || field_supportedCodecs.is_value());
}
int PDU__ML3__CallConfirmed::size_of() const
{
  int ret_val = 2;
  if (field_repeatIndicator.ispresent()) ret_val++;
  if (field_bearerCapability1.ispresent()) ret_val++;
  if (field_bearerCapability2.ispresent()) ret_val++;
  if (field_cause.ispresent()) ret_val++;
  if (field_cC__Capabilities.ispresent()) ret_val++;
  if (field_streamIdentifier.ispresent()) ret_val++;
  if (field_supportedCodecs.ispresent()) ret_val++;
  return ret_val;
}

void PDU__ML3__CallConfirmed::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(", repeatIndicator := ");
field_repeatIndicator.log();
TTCN_Logger::log_event_str(", bearerCapability1 := ");
field_bearerCapability1.log();
TTCN_Logger::log_event_str(", bearerCapability2 := ");
field_bearerCapability2.log();
TTCN_Logger::log_event_str(", cause := ");
field_cause.log();
TTCN_Logger::log_event_str(", cC_Capabilities := ");
field_cC__Capabilities.log();
TTCN_Logger::log_event_str(", streamIdentifier := ");
field_streamIdentifier.log();
TTCN_Logger::log_event_str(", supportedCodecs := ");
field_supportedCodecs.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__CallConfirmed::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (!repeatIndicator().is_bound()) repeatIndicator() = OMIT_VALUE;
else repeatIndicator().set_implicit_omit();
if (!bearerCapability1().is_bound()) bearerCapability1() = OMIT_VALUE;
else bearerCapability1().set_implicit_omit();
if (!bearerCapability2().is_bound()) bearerCapability2() = OMIT_VALUE;
else bearerCapability2().set_implicit_omit();
if (!cause().is_bound()) cause() = OMIT_VALUE;
else cause().set_implicit_omit();
if (!cC__Capabilities().is_bound()) cC__Capabilities() = OMIT_VALUE;
else cC__Capabilities().set_implicit_omit();
if (!streamIdentifier().is_bound()) streamIdentifier() = OMIT_VALUE;
else streamIdentifier().set_implicit_omit();
if (!supportedCodecs().is_bound()) supportedCodecs() = OMIT_VALUE;
else supportedCodecs().set_implicit_omit();
}

void PDU__ML3__CallConfirmed::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) repeatIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) bearerCapability1().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) bearerCapability2().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) cC__Capabilities().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) streamIdentifier().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) supportedCodecs().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "repeatIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          repeatIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bearerCapability1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bearerCapability1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bearerCapability2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bearerCapability2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cC_Capabilities")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cC__Capabilities().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "streamIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          streamIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "supportedCodecs")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          supportedCodecs().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_CallConfirmed: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.PDU_ML3_CallConfirmed");
  }
}

void PDU__ML3__CallConfirmed::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
field_repeatIndicator.encode_text(text_buf);
field_bearerCapability1.encode_text(text_buf);
field_bearerCapability2.encode_text(text_buf);
field_cause.encode_text(text_buf);
field_cC__Capabilities.encode_text(text_buf);
field_streamIdentifier.encode_text(text_buf);
field_supportedCodecs.encode_text(text_buf);
}

void PDU__ML3__CallConfirmed::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
field_repeatIndicator.decode_text(text_buf);
field_bearerCapability1.decode_text(text_buf);
field_bearerCapability2.decode_text(text_buf);
field_cause.decode_text(text_buf);
field_cC__Capabilities.decode_text(text_buf);
field_streamIdentifier.decode_text(text_buf);
field_supportedCodecs.decode_text(text_buf);
}

void PDU__ML3__CallConfirmed::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__CallConfirmed::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__CallConfirmed::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_repeatIndicator = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, RepeatIndicator_descr_.raw->forceomit);
  decoded_field_length = field_repeatIndicator().RAW_decode(RepeatIndicator_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_repeatIndicator = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_repeatIndicator.ispresent() || field_repeatIndicator().elementIdentifier() !=  bs_0){
  field_repeatIndicator=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_repeatIndicator=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_bearerCapability1 = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, BearerCapability__TLV_descr_.raw->forceomit);
  decoded_field_length = field_bearerCapability1().RAW_decode(BearerCapability__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_bearerCapability1 = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_bearerCapability1.ispresent() || field_bearerCapability1().elementIdentifier() !=  os_4){
  field_bearerCapability1=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_bearerCapability1=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_bearerCapability2 = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, BearerCapability__TLV_descr_.raw->forceomit);
  decoded_field_length = field_bearerCapability2().RAW_decode(BearerCapability__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_bearerCapability2 = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_bearerCapability2.ispresent() || field_bearerCapability2().elementIdentifier() !=  os_4){
  field_bearerCapability2=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_bearerCapability2=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_cause = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, MobileL3__CommonIE__Types::ML3__Cause__TLV_descr_.raw->forceomit);
  decoded_field_length = field_cause().RAW_decode(MobileL3__CommonIE__Types::ML3__Cause__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_cause = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_cause.ispresent() || field_cause().elementIdentifier() !=  os_5){
  field_cause=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_cause=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_cC__Capabilities = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, CallControlCapabilities_descr_.raw->forceomit);
  decoded_field_length = field_cC__Capabilities().RAW_decode(CallControlCapabilities_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_cC__Capabilities = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_cC__Capabilities.ispresent() || field_cC__Capabilities().elementIdentifier() !=  os_6){
  field_cC__Capabilities=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_cC__Capabilities=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_streamIdentifier = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, StreamIdentifier_descr_.raw->forceomit);
  decoded_field_length = field_streamIdentifier().RAW_decode(StreamIdentifier_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_streamIdentifier = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_streamIdentifier.ispresent() || field_streamIdentifier().elementIdentifier() !=  os_7){
  field_streamIdentifier=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_streamIdentifier=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(8)) {
    field_supportedCodecs = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_8_force_omit(8, force_omit, MobileL3__CommonIE__Types::SupportedCodecList_descr_.raw->forceomit);
  decoded_field_length = field_supportedCodecs().RAW_decode(MobileL3__CommonIE__Types::SupportedCodecList_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 1) {
  field_supportedCodecs = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_supportedCodecs=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__CallConfirmed::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 9;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(9);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  if (field_repeatIndicator.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RepeatIndicator_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_bearerCapability1.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, BearerCapability__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_bearerCapability2.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, BearerCapability__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_cause.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, MobileL3__CommonIE__Types::ML3__Cause__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_cC__Capabilities.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, CallControlCapabilities_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_streamIdentifier.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, StreamIdentifier_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  if (field_supportedCodecs.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, MobileL3__CommonIE__Types::SupportedCodecList_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  if (field_repeatIndicator.ispresent()) {
  encoded_length += field_repeatIndicator().RAW_encode(RepeatIndicator_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_bearerCapability1.ispresent()) {
  encoded_length += field_bearerCapability1().RAW_encode(BearerCapability__TLV_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_bearerCapability2.ispresent()) {
  encoded_length += field_bearerCapability2().RAW_encode(BearerCapability__TLV_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_cause.ispresent()) {
  encoded_length += field_cause().RAW_encode(MobileL3__CommonIE__Types::ML3__Cause__TLV_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_cC__Capabilities.ispresent()) {
  encoded_length += field_cC__Capabilities().RAW_encode(CallControlCapabilities_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_streamIdentifier.ispresent()) {
  encoded_length += field_streamIdentifier().RAW_encode(StreamIdentifier_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_supportedCodecs.ispresent()) {
  encoded_length += field_supportedCodecs().RAW_encode(MobileL3__CommonIE__Types::SupportedCodecList_descr_, *myleaf.body.node.nodes[8]);
  }
  if (field_repeatIndicator.ispresent() && (!field_repeatIndicator.ispresent() || field_repeatIndicator().elementIdentifier() !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={2,1};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_bearerCapability1.ispresent() && (!field_bearerCapability1.ispresent() || field_bearerCapability1().elementIdentifier() !=  os_4)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={3,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_4.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_bearerCapability2.ispresent() && (!field_bearerCapability2.ispresent() || field_bearerCapability2().elementIdentifier() !=  os_4)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={4,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_4.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_cause.ispresent() && (!field_cause.ispresent() || field_cause().elementIdentifier() !=  os_5)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={5,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_5.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_cC__Capabilities.ispresent() && (!field_cC__Capabilities.ispresent() || field_cC__Capabilities().elementIdentifier() !=  os_6)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={6,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_6.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_streamIdentifier.ispresent() && (!field_streamIdentifier.ispresent() || field_streamIdentifier().elementIdentifier() !=  os_7)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={7,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_7.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__ML3__CallConfirmed_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
RepeatIndicator_template field_repeatIndicator;
BearerCapability__TLV_template field_bearerCapability1;
BearerCapability__TLV_template field_bearerCapability2;
MobileL3__CommonIE__Types::ML3__Cause__TLV_template field_cause;
CallControlCapabilities_template field_cC__Capabilities;
StreamIdentifier_template field_streamIdentifier;
MobileL3__CommonIE__Types::SupportedCodecList_template field_supportedCodecs;
};

void PDU__ML3__CallConfirmed_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
single_value->field_repeatIndicator = ANY_OR_OMIT;
single_value->field_bearerCapability1 = ANY_OR_OMIT;
single_value->field_bearerCapability2 = ANY_OR_OMIT;
single_value->field_cause = ANY_OR_OMIT;
single_value->field_cC__Capabilities = ANY_OR_OMIT;
single_value->field_streamIdentifier = ANY_OR_OMIT;
single_value->field_supportedCodecs = ANY_OR_OMIT;
}
}
}

void PDU__ML3__CallConfirmed_template::copy_value(const PDU__ML3__CallConfirmed& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
if (other_value.repeatIndicator().is_bound()) {
  if (other_value.repeatIndicator().ispresent()) single_value->field_repeatIndicator = other_value.repeatIndicator()();
  else single_value->field_repeatIndicator = OMIT_VALUE;
} else {
  single_value->field_repeatIndicator.clean_up();
}
if (other_value.bearerCapability1().is_bound()) {
  if (other_value.bearerCapability1().ispresent()) single_value->field_bearerCapability1 = other_value.bearerCapability1()();
  else single_value->field_bearerCapability1 = OMIT_VALUE;
} else {
  single_value->field_bearerCapability1.clean_up();
}
if (other_value.bearerCapability2().is_bound()) {
  if (other_value.bearerCapability2().ispresent()) single_value->field_bearerCapability2 = other_value.bearerCapability2()();
  else single_value->field_bearerCapability2 = OMIT_VALUE;
} else {
  single_value->field_bearerCapability2.clean_up();
}
if (other_value.cause().is_bound()) {
  if (other_value.cause().ispresent()) single_value->field_cause = other_value.cause()();
  else single_value->field_cause = OMIT_VALUE;
} else {
  single_value->field_cause.clean_up();
}
if (other_value.cC__Capabilities().is_bound()) {
  if (other_value.cC__Capabilities().ispresent()) single_value->field_cC__Capabilities = other_value.cC__Capabilities()();
  else single_value->field_cC__Capabilities = OMIT_VALUE;
} else {
  single_value->field_cC__Capabilities.clean_up();
}
if (other_value.streamIdentifier().is_bound()) {
  if (other_value.streamIdentifier().ispresent()) single_value->field_streamIdentifier = other_value.streamIdentifier()();
  else single_value->field_streamIdentifier = OMIT_VALUE;
} else {
  single_value->field_streamIdentifier.clean_up();
}
if (other_value.supportedCodecs().is_bound()) {
  if (other_value.supportedCodecs().ispresent()) single_value->field_supportedCodecs = other_value.supportedCodecs()();
  else single_value->field_supportedCodecs = OMIT_VALUE;
} else {
  single_value->field_supportedCodecs.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__CallConfirmed_template::copy_template(const PDU__ML3__CallConfirmed_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.repeatIndicator().get_selection()) {
single_value->field_repeatIndicator = other_value.repeatIndicator();
} else {
single_value->field_repeatIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bearerCapability1().get_selection()) {
single_value->field_bearerCapability1 = other_value.bearerCapability1();
} else {
single_value->field_bearerCapability1.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bearerCapability2().get_selection()) {
single_value->field_bearerCapability2 = other_value.bearerCapability2();
} else {
single_value->field_bearerCapability2.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cause().get_selection()) {
single_value->field_cause = other_value.cause();
} else {
single_value->field_cause.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cC__Capabilities().get_selection()) {
single_value->field_cC__Capabilities = other_value.cC__Capabilities();
} else {
single_value->field_cC__Capabilities.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.streamIdentifier().get_selection()) {
single_value->field_streamIdentifier = other_value.streamIdentifier();
} else {
single_value->field_streamIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.supportedCodecs().get_selection()) {
single_value->field_supportedCodecs = other_value.supportedCodecs();
} else {
single_value->field_supportedCodecs.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__CallConfirmed_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__CallConfirmed_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__CallConfirmed_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
break;
}
set_selection(other_value);
}

PDU__ML3__CallConfirmed_template::PDU__ML3__CallConfirmed_template()
{
}

PDU__ML3__CallConfirmed_template::PDU__ML3__CallConfirmed_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__CallConfirmed_template::PDU__ML3__CallConfirmed_template(const PDU__ML3__CallConfirmed& other_value)
{
copy_value(other_value);
}

PDU__ML3__CallConfirmed_template::PDU__ML3__CallConfirmed_template(const OPTIONAL<PDU__ML3__CallConfirmed>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__CallConfirmed&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed from an unbound optional field.");
}
}

PDU__ML3__CallConfirmed_template::PDU__ML3__CallConfirmed_template(PDU__ML3__CallConfirmed_template* p_precondition, PDU__ML3__CallConfirmed_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__CallConfirmed_template::PDU__ML3__CallConfirmed_template(Dynamic_Match_Interface<PDU__ML3__CallConfirmed>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__CallConfirmed>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__CallConfirmed_template::PDU__ML3__CallConfirmed_template(const PDU__ML3__CallConfirmed_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__CallConfirmed_template::~PDU__ML3__CallConfirmed_template()
{
clean_up();
}

PDU__ML3__CallConfirmed_template& PDU__ML3__CallConfirmed_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__CallConfirmed_template& PDU__ML3__CallConfirmed_template::operator=(const PDU__ML3__CallConfirmed& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__CallConfirmed_template& PDU__ML3__CallConfirmed_template::operator=(const OPTIONAL<PDU__ML3__CallConfirmed>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__CallConfirmed&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
}
return *this;
}

PDU__ML3__CallConfirmed_template& PDU__ML3__CallConfirmed_template::operator=(const PDU__ML3__CallConfirmed_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__CallConfirmed_template::match(const PDU__ML3__CallConfirmed& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
if(!other_value.repeatIndicator().is_bound()) return FALSE;
if((other_value.repeatIndicator().ispresent() ? !single_value->field_repeatIndicator.match((const RepeatIndicator&)other_value.repeatIndicator(), legacy) : !single_value->field_repeatIndicator.match_omit(legacy)))return FALSE;
if(!other_value.bearerCapability1().is_bound()) return FALSE;
if((other_value.bearerCapability1().ispresent() ? !single_value->field_bearerCapability1.match((const BearerCapability__TLV&)other_value.bearerCapability1(), legacy) : !single_value->field_bearerCapability1.match_omit(legacy)))return FALSE;
if(!other_value.bearerCapability2().is_bound()) return FALSE;
if((other_value.bearerCapability2().ispresent() ? !single_value->field_bearerCapability2.match((const BearerCapability__TLV&)other_value.bearerCapability2(), legacy) : !single_value->field_bearerCapability2.match_omit(legacy)))return FALSE;
if(!other_value.cause().is_bound()) return FALSE;
if((other_value.cause().ispresent() ? !single_value->field_cause.match((const MobileL3__CommonIE__Types::ML3__Cause__TLV&)other_value.cause(), legacy) : !single_value->field_cause.match_omit(legacy)))return FALSE;
if(!other_value.cC__Capabilities().is_bound()) return FALSE;
if((other_value.cC__Capabilities().ispresent() ? !single_value->field_cC__Capabilities.match((const CallControlCapabilities&)other_value.cC__Capabilities(), legacy) : !single_value->field_cC__Capabilities.match_omit(legacy)))return FALSE;
if(!other_value.streamIdentifier().is_bound()) return FALSE;
if((other_value.streamIdentifier().ispresent() ? !single_value->field_streamIdentifier.match((const StreamIdentifier&)other_value.streamIdentifier(), legacy) : !single_value->field_streamIdentifier.match_omit(legacy)))return FALSE;
if(!other_value.supportedCodecs().is_bound()) return FALSE;
if((other_value.supportedCodecs().ispresent() ? !single_value->field_supportedCodecs.match((const MobileL3__CommonIE__Types::SupportedCodecList&)other_value.supportedCodecs(), legacy) : !single_value->field_supportedCodecs.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
}
return FALSE;
}

boolean PDU__ML3__CallConfirmed_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound()
 || (single_value->field_repeatIndicator.is_omit() || single_value->field_repeatIndicator.is_bound())
 || (single_value->field_bearerCapability1.is_omit() || single_value->field_bearerCapability1.is_bound())
 || (single_value->field_bearerCapability2.is_omit() || single_value->field_bearerCapability2.is_bound())
 || (single_value->field_cause.is_omit() || single_value->field_cause.is_bound())
 || (single_value->field_cC__Capabilities.is_omit() || single_value->field_cC__Capabilities.is_bound())
 || (single_value->field_streamIdentifier.is_omit() || single_value->field_streamIdentifier.is_bound())
 || (single_value->field_supportedCodecs.is_omit() || single_value->field_supportedCodecs.is_bound());
}

boolean PDU__ML3__CallConfirmed_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value()
 && (single_value->field_repeatIndicator.is_omit() || single_value->field_repeatIndicator.is_value())
 && (single_value->field_bearerCapability1.is_omit() || single_value->field_bearerCapability1.is_value())
 && (single_value->field_bearerCapability2.is_omit() || single_value->field_bearerCapability2.is_value())
 && (single_value->field_cause.is_omit() || single_value->field_cause.is_value())
 && (single_value->field_cC__Capabilities.is_omit() || single_value->field_cC__Capabilities.is_value())
 && (single_value->field_streamIdentifier.is_omit() || single_value->field_streamIdentifier.is_value())
 && (single_value->field_supportedCodecs.is_omit() || single_value->field_supportedCodecs.is_value());
}

void PDU__ML3__CallConfirmed_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__CallConfirmed PDU__ML3__CallConfirmed_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
PDU__ML3__CallConfirmed ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
if (single_value->field_repeatIndicator.is_omit()) ret_val.repeatIndicator() = OMIT_VALUE;
else if (single_value->field_repeatIndicator.is_bound()) {
ret_val.repeatIndicator() = single_value->field_repeatIndicator.valueof();
}
if (single_value->field_bearerCapability1.is_omit()) ret_val.bearerCapability1() = OMIT_VALUE;
else if (single_value->field_bearerCapability1.is_bound()) {
ret_val.bearerCapability1() = single_value->field_bearerCapability1.valueof();
}
if (single_value->field_bearerCapability2.is_omit()) ret_val.bearerCapability2() = OMIT_VALUE;
else if (single_value->field_bearerCapability2.is_bound()) {
ret_val.bearerCapability2() = single_value->field_bearerCapability2.valueof();
}
if (single_value->field_cause.is_omit()) ret_val.cause() = OMIT_VALUE;
else if (single_value->field_cause.is_bound()) {
ret_val.cause() = single_value->field_cause.valueof();
}
if (single_value->field_cC__Capabilities.is_omit()) ret_val.cC__Capabilities() = OMIT_VALUE;
else if (single_value->field_cC__Capabilities.is_bound()) {
ret_val.cC__Capabilities() = single_value->field_cC__Capabilities.valueof();
}
if (single_value->field_streamIdentifier.is_omit()) ret_val.streamIdentifier() = OMIT_VALUE;
else if (single_value->field_streamIdentifier.is_bound()) {
ret_val.streamIdentifier() = single_value->field_streamIdentifier.valueof();
}
if (single_value->field_supportedCodecs.is_omit()) ret_val.supportedCodecs() = OMIT_VALUE;
else if (single_value->field_supportedCodecs.is_bound()) {
ret_val.supportedCodecs() = single_value->field_supportedCodecs.valueof();
}
return ret_val;
}

void PDU__ML3__CallConfirmed_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__CallConfirmed_template[list_length];
}

PDU__ML3__CallConfirmed_template& PDU__ML3__CallConfirmed_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__CallConfirmed_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__CallConfirmed_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__CallConfirmed_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__CallConfirmed_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
return single_value->field_nsd;
}

RepeatIndicator_template& PDU__ML3__CallConfirmed_template::repeatIndicator()
{
set_specific();
return single_value->field_repeatIndicator;
}

const RepeatIndicator_template& PDU__ML3__CallConfirmed_template::repeatIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field repeatIndicator of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
return single_value->field_repeatIndicator;
}

BearerCapability__TLV_template& PDU__ML3__CallConfirmed_template::bearerCapability1()
{
set_specific();
return single_value->field_bearerCapability1;
}

const BearerCapability__TLV_template& PDU__ML3__CallConfirmed_template::bearerCapability1() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bearerCapability1 of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
return single_value->field_bearerCapability1;
}

BearerCapability__TLV_template& PDU__ML3__CallConfirmed_template::bearerCapability2()
{
set_specific();
return single_value->field_bearerCapability2;
}

const BearerCapability__TLV_template& PDU__ML3__CallConfirmed_template::bearerCapability2() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bearerCapability2 of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
return single_value->field_bearerCapability2;
}

MobileL3__CommonIE__Types::ML3__Cause__TLV_template& PDU__ML3__CallConfirmed_template::cause()
{
set_specific();
return single_value->field_cause;
}

const MobileL3__CommonIE__Types::ML3__Cause__TLV_template& PDU__ML3__CallConfirmed_template::cause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cause of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
return single_value->field_cause;
}

CallControlCapabilities_template& PDU__ML3__CallConfirmed_template::cC__Capabilities()
{
set_specific();
return single_value->field_cC__Capabilities;
}

const CallControlCapabilities_template& PDU__ML3__CallConfirmed_template::cC__Capabilities() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cC_Capabilities of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
return single_value->field_cC__Capabilities;
}

StreamIdentifier_template& PDU__ML3__CallConfirmed_template::streamIdentifier()
{
set_specific();
return single_value->field_streamIdentifier;
}

const StreamIdentifier_template& PDU__ML3__CallConfirmed_template::streamIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field streamIdentifier of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
return single_value->field_streamIdentifier;
}

MobileL3__CommonIE__Types::SupportedCodecList_template& PDU__ML3__CallConfirmed_template::supportedCodecs()
{
set_specific();
return single_value->field_supportedCodecs;
}

const MobileL3__CommonIE__Types::SupportedCodecList_template& PDU__ML3__CallConfirmed_template::supportedCodecs() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field supportedCodecs of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
return single_value->field_supportedCodecs;
}

int PDU__ML3__CallConfirmed_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_repeatIndicator.is_present()) ret_val++;
      if (single_value->field_bearerCapability1.is_present()) ret_val++;
      if (single_value->field_bearerCapability2.is_present()) ret_val++;
      if (single_value->field_cause.is_present()) ret_val++;
      if (single_value->field_cC__Capabilities.is_present()) ret_val++;
      if (single_value->field_streamIdentifier.is_present()) ret_val++;
      if (single_value->field_supportedCodecs.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
  }
  return 0;
}

void PDU__ML3__CallConfirmed_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(", repeatIndicator := ");
single_value->field_repeatIndicator.log();
TTCN_Logger::log_event_str(", bearerCapability1 := ");
single_value->field_bearerCapability1.log();
TTCN_Logger::log_event_str(", bearerCapability2 := ");
single_value->field_bearerCapability2.log();
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log();
TTCN_Logger::log_event_str(", cC_Capabilities := ");
single_value->field_cC__Capabilities.log();
TTCN_Logger::log_event_str(", streamIdentifier := ");
single_value->field_streamIdentifier.log();
TTCN_Logger::log_event_str(", supportedCodecs := ");
single_value->field_supportedCodecs.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__CallConfirmed_template::log_match(const PDU__ML3__CallConfirmed& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.repeatIndicator().ispresent()){
if(!single_value->field_repeatIndicator.match(match_value.repeatIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".repeatIndicator");
single_value->field_repeatIndicator.log_match(match_value.repeatIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_repeatIndicator.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".repeatIndicator := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_repeatIndicator.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.bearerCapability1().ispresent()){
if(!single_value->field_bearerCapability1.match(match_value.bearerCapability1(), legacy)){
TTCN_Logger::log_logmatch_info(".bearerCapability1");
single_value->field_bearerCapability1.log_match(match_value.bearerCapability1(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_bearerCapability1.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".bearerCapability1 := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_bearerCapability1.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.bearerCapability2().ispresent()){
if(!single_value->field_bearerCapability2.match(match_value.bearerCapability2(), legacy)){
TTCN_Logger::log_logmatch_info(".bearerCapability2");
single_value->field_bearerCapability2.log_match(match_value.bearerCapability2(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_bearerCapability2.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".bearerCapability2 := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_bearerCapability2.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.cause().ispresent()){
if(!single_value->field_cause.match(match_value.cause(), legacy)){
TTCN_Logger::log_logmatch_info(".cause");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_cause.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".cause := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_cause.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.cC__Capabilities().ispresent()){
if(!single_value->field_cC__Capabilities.match(match_value.cC__Capabilities(), legacy)){
TTCN_Logger::log_logmatch_info(".cC_Capabilities");
single_value->field_cC__Capabilities.log_match(match_value.cC__Capabilities(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_cC__Capabilities.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".cC_Capabilities := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_cC__Capabilities.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.streamIdentifier().ispresent()){
if(!single_value->field_streamIdentifier.match(match_value.streamIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".streamIdentifier");
single_value->field_streamIdentifier.log_match(match_value.streamIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_streamIdentifier.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".streamIdentifier := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_streamIdentifier.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.supportedCodecs().ispresent()){
if(!single_value->field_supportedCodecs.match(match_value.supportedCodecs(), legacy)){
TTCN_Logger::log_logmatch_info(".supportedCodecs");
single_value->field_supportedCodecs.log_match(match_value.supportedCodecs(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_supportedCodecs.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".supportedCodecs := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_supportedCodecs.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(", repeatIndicator := ");
if (match_value.repeatIndicator().ispresent()) {
single_value->field_repeatIndicator.log_match(match_value.repeatIndicator(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_repeatIndicator.log();
if (single_value->field_repeatIndicator.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", bearerCapability1 := ");
if (match_value.bearerCapability1().ispresent()) {
single_value->field_bearerCapability1.log_match(match_value.bearerCapability1(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_bearerCapability1.log();
if (single_value->field_bearerCapability1.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", bearerCapability2 := ");
if (match_value.bearerCapability2().ispresent()) {
single_value->field_bearerCapability2.log_match(match_value.bearerCapability2(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_bearerCapability2.log();
if (single_value->field_bearerCapability2.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", cause := ");
if (match_value.cause().ispresent()) {
single_value->field_cause.log_match(match_value.cause(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_cause.log();
if (single_value->field_cause.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", cC_Capabilities := ");
if (match_value.cC__Capabilities().ispresent()) {
single_value->field_cC__Capabilities.log_match(match_value.cC__Capabilities(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_cC__Capabilities.log();
if (single_value->field_cC__Capabilities.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", streamIdentifier := ");
if (match_value.streamIdentifier().ispresent()) {
single_value->field_streamIdentifier.log_match(match_value.streamIdentifier(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_streamIdentifier.log();
if (single_value->field_streamIdentifier.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", supportedCodecs := ");
if (match_value.supportedCodecs().ispresent()) {
single_value->field_supportedCodecs.log_match(match_value.supportedCodecs(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_supportedCodecs.log();
if (single_value->field_supportedCodecs.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__CallConfirmed_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
single_value->field_repeatIndicator.encode_text(text_buf);
single_value->field_bearerCapability1.encode_text(text_buf);
single_value->field_bearerCapability2.encode_text(text_buf);
single_value->field_cause.encode_text(text_buf);
single_value->field_cC__Capabilities.encode_text(text_buf);
single_value->field_streamIdentifier.encode_text(text_buf);
single_value->field_supportedCodecs.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
}
}

void PDU__ML3__CallConfirmed_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
single_value->field_repeatIndicator.decode_text(text_buf);
single_value->field_bearerCapability1.decode_text(text_buf);
single_value->field_bearerCapability2.decode_text(text_buf);
single_value->field_cause.decode_text(text_buf);
single_value->field_cC__Capabilities.decode_text(text_buf);
single_value->field_streamIdentifier.decode_text(text_buf);
single_value->field_supportedCodecs.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__CallConfirmed_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed.");
}
}

void PDU__ML3__CallConfirmed_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__CallConfirmed_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.PDU_ML3_CallConfirmed has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) repeatIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) bearerCapability1().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) bearerCapability2().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) cC__Capabilities().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) streamIdentifier().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) supportedCodecs().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "repeatIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          repeatIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bearerCapability1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bearerCapability1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bearerCapability2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bearerCapability2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cC_Capabilities")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cC__Capabilities().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "streamIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          streamIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "supportedCodecs")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          supportedCodecs().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_CallConfirmed: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__CallConfirmed_template* precondition = new PDU__ML3__CallConfirmed_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__CallConfirmed_template* implied_template = new PDU__ML3__CallConfirmed_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__CallConfirmed_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.PDU_ML3_CallConfirmed");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__CallConfirmed_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CallConfirmed");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CallConfirmed");
single_value->field_repeatIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CallConfirmed");
single_value->field_bearerCapability1.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CallConfirmed");
single_value->field_bearerCapability2.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CallConfirmed");
single_value->field_cause.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CallConfirmed");
single_value->field_cC__Capabilities.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CallConfirmed");
single_value->field_streamIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CallConfirmed");
single_value->field_supportedCodecs.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CallConfirmed");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CallConfirmed");
}

boolean PDU__ML3__CallConfirmed_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__CallConfirmed_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__ML3__CallProceeding::PDU__ML3__CallProceeding()
{
}

PDU__ML3__CallProceeding::PDU__ML3__CallProceeding(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd,
    const OPTIONAL< RepeatIndicator >& par_repeatIndicator,
    const OPTIONAL< BearerCapability__TLV >& par_bearerCapability1,
    const OPTIONAL< BearerCapability__TLV >& par_bearerCapability2,
    const OPTIONAL< MobileL3__CommonIE__Types::Facility__TLV >& par_facility,
    const OPTIONAL< ProgressIndicator__TLV >& par_progressIndicator,
    const OPTIONAL< MobileL3__CommonIE__Types::PriorityLevel__ML3 >& par_priorityGranted,
    const OPTIONAL< NetworkCallControlCapabilities >& par_networkCCCapabilities)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd),
  field_repeatIndicator(par_repeatIndicator),
  field_bearerCapability1(par_bearerCapability1),
  field_bearerCapability2(par_bearerCapability2),
  field_facility(par_facility),
  field_progressIndicator(par_progressIndicator),
  field_priorityGranted(par_priorityGranted),
  field_networkCCCapabilities(par_networkCCCapabilities)
{
}

PDU__ML3__CallProceeding::PDU__ML3__CallProceeding(const PDU__ML3__CallProceeding& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
if (other_value.repeatIndicator().is_bound()) field_repeatIndicator = other_value.repeatIndicator();
else field_repeatIndicator.clean_up();
if (other_value.bearerCapability1().is_bound()) field_bearerCapability1 = other_value.bearerCapability1();
else field_bearerCapability1.clean_up();
if (other_value.bearerCapability2().is_bound()) field_bearerCapability2 = other_value.bearerCapability2();
else field_bearerCapability2.clean_up();
if (other_value.facility().is_bound()) field_facility = other_value.facility();
else field_facility.clean_up();
if (other_value.progressIndicator().is_bound()) field_progressIndicator = other_value.progressIndicator();
else field_progressIndicator.clean_up();
if (other_value.priorityGranted().is_bound()) field_priorityGranted = other_value.priorityGranted();
else field_priorityGranted.clean_up();
if (other_value.networkCCCapabilities().is_bound()) field_networkCCCapabilities = other_value.networkCCCapabilities();
else field_networkCCCapabilities.clean_up();
}

void PDU__ML3__CallProceeding::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
field_repeatIndicator.clean_up();
field_bearerCapability1.clean_up();
field_bearerCapability2.clean_up();
field_facility.clean_up();
field_progressIndicator.clean_up();
field_priorityGranted.clean_up();
field_networkCCCapabilities.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__CallProceeding::get_descriptor() const { return &PDU__ML3__CallProceeding_descr_; }
PDU__ML3__CallProceeding& PDU__ML3__CallProceeding::operator=(const PDU__ML3__CallProceeding& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
  if (other_value.repeatIndicator().is_bound()) field_repeatIndicator = other_value.repeatIndicator();
  else field_repeatIndicator.clean_up();
  if (other_value.bearerCapability1().is_bound()) field_bearerCapability1 = other_value.bearerCapability1();
  else field_bearerCapability1.clean_up();
  if (other_value.bearerCapability2().is_bound()) field_bearerCapability2 = other_value.bearerCapability2();
  else field_bearerCapability2.clean_up();
  if (other_value.facility().is_bound()) field_facility = other_value.facility();
  else field_facility.clean_up();
  if (other_value.progressIndicator().is_bound()) field_progressIndicator = other_value.progressIndicator();
  else field_progressIndicator.clean_up();
  if (other_value.priorityGranted().is_bound()) field_priorityGranted = other_value.priorityGranted();
  else field_priorityGranted.clean_up();
  if (other_value.networkCCCapabilities().is_bound()) field_networkCCCapabilities = other_value.networkCCCapabilities();
  else field_networkCCCapabilities.clean_up();
}
return *this;
}

boolean PDU__ML3__CallProceeding::operator==(const PDU__ML3__CallProceeding& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd
  && field_repeatIndicator==other_value.field_repeatIndicator
  && field_bearerCapability1==other_value.field_bearerCapability1
  && field_bearerCapability2==other_value.field_bearerCapability2
  && field_facility==other_value.field_facility
  && field_progressIndicator==other_value.field_progressIndicator
  && field_priorityGranted==other_value.field_priorityGranted
  && field_networkCCCapabilities==other_value.field_networkCCCapabilities;
}

boolean PDU__ML3__CallProceeding::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound())
  || (OPTIONAL_OMIT == field_repeatIndicator.get_selection() || field_repeatIndicator.is_bound())
  || (OPTIONAL_OMIT == field_bearerCapability1.get_selection() || field_bearerCapability1.is_bound())
  || (OPTIONAL_OMIT == field_bearerCapability2.get_selection() || field_bearerCapability2.is_bound())
  || (OPTIONAL_OMIT == field_facility.get_selection() || field_facility.is_bound())
  || (OPTIONAL_OMIT == field_progressIndicator.get_selection() || field_progressIndicator.is_bound())
  || (OPTIONAL_OMIT == field_priorityGranted.get_selection() || field_priorityGranted.is_bound())
  || (OPTIONAL_OMIT == field_networkCCCapabilities.get_selection() || field_networkCCCapabilities.is_bound());
}
boolean PDU__ML3__CallProceeding::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value()
  && (OPTIONAL_OMIT == field_repeatIndicator.get_selection() || field_repeatIndicator.is_value())
  && (OPTIONAL_OMIT == field_bearerCapability1.get_selection() || field_bearerCapability1.is_value())
  && (OPTIONAL_OMIT == field_bearerCapability2.get_selection() || field_bearerCapability2.is_value())
  && (OPTIONAL_OMIT == field_facility.get_selection() || field_facility.is_value())
  && (OPTIONAL_OMIT == field_progressIndicator.get_selection() || field_progressIndicator.is_value())
  && (OPTIONAL_OMIT == field_priorityGranted.get_selection() || field_priorityGranted.is_value())
  && (OPTIONAL_OMIT == field_networkCCCapabilities.get_selection() || field_networkCCCapabilities.is_value());
}
int PDU__ML3__CallProceeding::size_of() const
{
  int ret_val = 2;
  if (field_repeatIndicator.ispresent()) ret_val++;
  if (field_bearerCapability1.ispresent()) ret_val++;
  if (field_bearerCapability2.ispresent()) ret_val++;
  if (field_facility.ispresent()) ret_val++;
  if (field_progressIndicator.ispresent()) ret_val++;
  if (field_priorityGranted.ispresent()) ret_val++;
  if (field_networkCCCapabilities.ispresent()) ret_val++;
  return ret_val;
}

void PDU__ML3__CallProceeding::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(", repeatIndicator := ");
field_repeatIndicator.log();
TTCN_Logger::log_event_str(", bearerCapability1 := ");
field_bearerCapability1.log();
TTCN_Logger::log_event_str(", bearerCapability2 := ");
field_bearerCapability2.log();
TTCN_Logger::log_event_str(", facility := ");
field_facility.log();
TTCN_Logger::log_event_str(", progressIndicator := ");
field_progressIndicator.log();
TTCN_Logger::log_event_str(", priorityGranted := ");
field_priorityGranted.log();
TTCN_Logger::log_event_str(", networkCCCapabilities := ");
field_networkCCCapabilities.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__CallProceeding::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (!repeatIndicator().is_bound()) repeatIndicator() = OMIT_VALUE;
else repeatIndicator().set_implicit_omit();
if (!bearerCapability1().is_bound()) bearerCapability1() = OMIT_VALUE;
else bearerCapability1().set_implicit_omit();
if (!bearerCapability2().is_bound()) bearerCapability2() = OMIT_VALUE;
else bearerCapability2().set_implicit_omit();
if (!facility().is_bound()) facility() = OMIT_VALUE;
else facility().set_implicit_omit();
if (!progressIndicator().is_bound()) progressIndicator() = OMIT_VALUE;
else progressIndicator().set_implicit_omit();
if (!priorityGranted().is_bound()) priorityGranted() = OMIT_VALUE;
else priorityGranted().set_implicit_omit();
if (!networkCCCapabilities().is_bound()) networkCCCapabilities() = OMIT_VALUE;
else networkCCCapabilities().set_implicit_omit();
}

void PDU__ML3__CallProceeding::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.PDU_ML3_CallProceeding has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) repeatIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) bearerCapability1().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) bearerCapability2().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) facility().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) progressIndicator().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) priorityGranted().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) networkCCCapabilities().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "repeatIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          repeatIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bearerCapability1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bearerCapability1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bearerCapability2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bearerCapability2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "progressIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          progressIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "priorityGranted")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          priorityGranted().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "networkCCCapabilities")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          networkCCCapabilities().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_CallProceeding: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.PDU_ML3_CallProceeding");
  }
}

void PDU__ML3__CallProceeding::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
field_repeatIndicator.encode_text(text_buf);
field_bearerCapability1.encode_text(text_buf);
field_bearerCapability2.encode_text(text_buf);
field_facility.encode_text(text_buf);
field_progressIndicator.encode_text(text_buf);
field_priorityGranted.encode_text(text_buf);
field_networkCCCapabilities.encode_text(text_buf);
}

void PDU__ML3__CallProceeding::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
field_repeatIndicator.decode_text(text_buf);
field_bearerCapability1.decode_text(text_buf);
field_bearerCapability2.decode_text(text_buf);
field_facility.decode_text(text_buf);
field_progressIndicator.decode_text(text_buf);
field_priorityGranted.decode_text(text_buf);
field_networkCCCapabilities.decode_text(text_buf);
}

void PDU__ML3__CallProceeding::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__CallProceeding::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__CallProceeding::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_repeatIndicator = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, RepeatIndicator_descr_.raw->forceomit);
  decoded_field_length = field_repeatIndicator().RAW_decode(RepeatIndicator_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_repeatIndicator = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_repeatIndicator.ispresent() || field_repeatIndicator().elementIdentifier() !=  bs_0){
  field_repeatIndicator=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_repeatIndicator=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_bearerCapability1 = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, BearerCapability__TLV_descr_.raw->forceomit);
  decoded_field_length = field_bearerCapability1().RAW_decode(BearerCapability__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_bearerCapability1 = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_bearerCapability1.ispresent() || field_bearerCapability1().elementIdentifier() !=  os_4){
  field_bearerCapability1=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_bearerCapability1=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_bearerCapability2 = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, BearerCapability__TLV_descr_.raw->forceomit);
  decoded_field_length = field_bearerCapability2().RAW_decode(BearerCapability__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_bearerCapability2 = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_bearerCapability2.ispresent() || field_bearerCapability2().elementIdentifier() !=  os_4){
  field_bearerCapability2=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_bearerCapability2=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_facility = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, MobileL3__CommonIE__Types::Facility__TLV_descr_.raw->forceomit);
  decoded_field_length = field_facility().RAW_decode(MobileL3__CommonIE__Types::Facility__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_facility = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_facility.ispresent() || field_facility().elementIdentifier() !=  os_0){
  field_facility=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_facility=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_progressIndicator = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, ProgressIndicator__TLV_descr_.raw->forceomit);
  decoded_field_length = field_progressIndicator().RAW_decode(ProgressIndicator__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_progressIndicator = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_progressIndicator.ispresent() || field_progressIndicator().elementIdentifier() !=  os_1){
  field_progressIndicator=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_progressIndicator=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_priorityGranted = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, MobileL3__CommonIE__Types::PriorityLevel__ML3_descr_.raw->forceomit);
  decoded_field_length = field_priorityGranted().RAW_decode(MobileL3__CommonIE__Types::PriorityLevel__ML3_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_priorityGranted = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_priorityGranted.ispresent() || field_priorityGranted().elementIdentifier() !=  bs_1){
  field_priorityGranted=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_priorityGranted=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(8)) {
    field_networkCCCapabilities = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_8_force_omit(8, force_omit, NetworkCallControlCapabilities_descr_.raw->forceomit);
  decoded_field_length = field_networkCCCapabilities().RAW_decode(NetworkCallControlCapabilities_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 1) {
  field_networkCCCapabilities = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_networkCCCapabilities.ispresent() || field_networkCCCapabilities().elementIdentifier() !=  os_8){
  field_networkCCCapabilities=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_networkCCCapabilities=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__CallProceeding::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 9;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(9);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  if (field_repeatIndicator.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RepeatIndicator_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_bearerCapability1.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, BearerCapability__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_bearerCapability2.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, BearerCapability__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_facility.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, MobileL3__CommonIE__Types::Facility__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_progressIndicator.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, ProgressIndicator__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_priorityGranted.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, MobileL3__CommonIE__Types::PriorityLevel__ML3_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  if (field_networkCCCapabilities.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, NetworkCallControlCapabilities_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  if (field_repeatIndicator.ispresent()) {
  encoded_length += field_repeatIndicator().RAW_encode(RepeatIndicator_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_bearerCapability1.ispresent()) {
  encoded_length += field_bearerCapability1().RAW_encode(BearerCapability__TLV_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_bearerCapability2.ispresent()) {
  encoded_length += field_bearerCapability2().RAW_encode(BearerCapability__TLV_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_facility.ispresent()) {
  encoded_length += field_facility().RAW_encode(MobileL3__CommonIE__Types::Facility__TLV_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_progressIndicator.ispresent()) {
  encoded_length += field_progressIndicator().RAW_encode(ProgressIndicator__TLV_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_priorityGranted.ispresent()) {
  encoded_length += field_priorityGranted().RAW_encode(MobileL3__CommonIE__Types::PriorityLevel__ML3_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_networkCCCapabilities.ispresent()) {
  encoded_length += field_networkCCCapabilities().RAW_encode(NetworkCallControlCapabilities_descr_, *myleaf.body.node.nodes[8]);
  }
  if (field_repeatIndicator.ispresent() && (!field_repeatIndicator.ispresent() || field_repeatIndicator().elementIdentifier() !=  bs_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={2,1};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_0.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_bearerCapability1.ispresent() && (!field_bearerCapability1.ispresent() || field_bearerCapability1().elementIdentifier() !=  os_4)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={3,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_4.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_bearerCapability2.ispresent() && (!field_bearerCapability2.ispresent() || field_bearerCapability2().elementIdentifier() !=  os_4)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={4,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_4.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_facility.ispresent() && (!field_facility.ispresent() || field_facility().elementIdentifier() !=  os_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={5,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_0.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_progressIndicator.ispresent() && (!field_progressIndicator.ispresent() || field_progressIndicator().elementIdentifier() !=  os_1)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={6,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_1.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_priorityGranted.ispresent() && (!field_priorityGranted.ispresent() || field_priorityGranted().elementIdentifier() !=  bs_1)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={7,2};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_1.RAW_encode(General__Types::BIT4_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_networkCCCapabilities.ispresent() && (!field_networkCCCapabilities.ispresent() || field_networkCCCapabilities().elementIdentifier() !=  os_8)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={8,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_8.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__ML3__CallProceeding_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
RepeatIndicator_template field_repeatIndicator;
BearerCapability__TLV_template field_bearerCapability1;
BearerCapability__TLV_template field_bearerCapability2;
MobileL3__CommonIE__Types::Facility__TLV_template field_facility;
ProgressIndicator__TLV_template field_progressIndicator;
MobileL3__CommonIE__Types::PriorityLevel__ML3_template field_priorityGranted;
NetworkCallControlCapabilities_template field_networkCCCapabilities;
};

void PDU__ML3__CallProceeding_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
single_value->field_repeatIndicator = ANY_OR_OMIT;
single_value->field_bearerCapability1 = ANY_OR_OMIT;
single_value->field_bearerCapability2 = ANY_OR_OMIT;
single_value->field_facility = ANY_OR_OMIT;
single_value->field_progressIndicator = ANY_OR_OMIT;
single_value->field_priorityGranted = ANY_OR_OMIT;
single_value->field_networkCCCapabilities = ANY_OR_OMIT;
}
}
}

void PDU__ML3__CallProceeding_template::copy_value(const PDU__ML3__CallProceeding& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
if (other_value.repeatIndicator().is_bound()) {
  if (other_value.repeatIndicator().ispresent()) single_value->field_repeatIndicator = other_value.repeatIndicator()();
  else single_value->field_repeatIndicator = OMIT_VALUE;
} else {
  single_value->field_repeatIndicator.clean_up();
}
if (other_value.bearerCapability1().is_bound()) {
  if (other_value.bearerCapability1().ispresent()) single_value->field_bearerCapability1 = other_value.bearerCapability1()();
  else single_value->field_bearerCapability1 = OMIT_VALUE;
} else {
  single_value->field_bearerCapability1.clean_up();
}
if (other_value.bearerCapability2().is_bound()) {
  if (other_value.bearerCapability2().ispresent()) single_value->field_bearerCapability2 = other_value.bearerCapability2()();
  else single_value->field_bearerCapability2 = OMIT_VALUE;
} else {
  single_value->field_bearerCapability2.clean_up();
}
if (other_value.facility().is_bound()) {
  if (other_value.facility().ispresent()) single_value->field_facility = other_value.facility()();
  else single_value->field_facility = OMIT_VALUE;
} else {
  single_value->field_facility.clean_up();
}
if (other_value.progressIndicator().is_bound()) {
  if (other_value.progressIndicator().ispresent()) single_value->field_progressIndicator = other_value.progressIndicator()();
  else single_value->field_progressIndicator = OMIT_VALUE;
} else {
  single_value->field_progressIndicator.clean_up();
}
if (other_value.priorityGranted().is_bound()) {
  if (other_value.priorityGranted().ispresent()) single_value->field_priorityGranted = other_value.priorityGranted()();
  else single_value->field_priorityGranted = OMIT_VALUE;
} else {
  single_value->field_priorityGranted.clean_up();
}
if (other_value.networkCCCapabilities().is_bound()) {
  if (other_value.networkCCCapabilities().ispresent()) single_value->field_networkCCCapabilities = other_value.networkCCCapabilities()();
  else single_value->field_networkCCCapabilities = OMIT_VALUE;
} else {
  single_value->field_networkCCCapabilities.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__CallProceeding_template::copy_template(const PDU__ML3__CallProceeding_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.repeatIndicator().get_selection()) {
single_value->field_repeatIndicator = other_value.repeatIndicator();
} else {
single_value->field_repeatIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bearerCapability1().get_selection()) {
single_value->field_bearerCapability1 = other_value.bearerCapability1();
} else {
single_value->field_bearerCapability1.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bearerCapability2().get_selection()) {
single_value->field_bearerCapability2 = other_value.bearerCapability2();
} else {
single_value->field_bearerCapability2.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.facility().get_selection()) {
single_value->field_facility = other_value.facility();
} else {
single_value->field_facility.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.progressIndicator().get_selection()) {
single_value->field_progressIndicator = other_value.progressIndicator();
} else {
single_value->field_progressIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.priorityGranted().get_selection()) {
single_value->field_priorityGranted = other_value.priorityGranted();
} else {
single_value->field_priorityGranted.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.networkCCCapabilities().get_selection()) {
single_value->field_networkCCCapabilities = other_value.networkCCCapabilities();
} else {
single_value->field_networkCCCapabilities.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__CallProceeding_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__CallProceeding_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__CallProceeding_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
break;
}
set_selection(other_value);
}

PDU__ML3__CallProceeding_template::PDU__ML3__CallProceeding_template()
{
}

PDU__ML3__CallProceeding_template::PDU__ML3__CallProceeding_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__CallProceeding_template::PDU__ML3__CallProceeding_template(const PDU__ML3__CallProceeding& other_value)
{
copy_value(other_value);
}

PDU__ML3__CallProceeding_template::PDU__ML3__CallProceeding_template(const OPTIONAL<PDU__ML3__CallProceeding>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__CallProceeding&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding from an unbound optional field.");
}
}

PDU__ML3__CallProceeding_template::PDU__ML3__CallProceeding_template(PDU__ML3__CallProceeding_template* p_precondition, PDU__ML3__CallProceeding_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__CallProceeding_template::PDU__ML3__CallProceeding_template(Dynamic_Match_Interface<PDU__ML3__CallProceeding>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__CallProceeding>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__CallProceeding_template::PDU__ML3__CallProceeding_template(const PDU__ML3__CallProceeding_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__CallProceeding_template::~PDU__ML3__CallProceeding_template()
{
clean_up();
}

PDU__ML3__CallProceeding_template& PDU__ML3__CallProceeding_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__CallProceeding_template& PDU__ML3__CallProceeding_template::operator=(const PDU__ML3__CallProceeding& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__CallProceeding_template& PDU__ML3__CallProceeding_template::operator=(const OPTIONAL<PDU__ML3__CallProceeding>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__CallProceeding&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
}
return *this;
}

PDU__ML3__CallProceeding_template& PDU__ML3__CallProceeding_template::operator=(const PDU__ML3__CallProceeding_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__CallProceeding_template::match(const PDU__ML3__CallProceeding& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
if(!other_value.repeatIndicator().is_bound()) return FALSE;
if((other_value.repeatIndicator().ispresent() ? !single_value->field_repeatIndicator.match((const RepeatIndicator&)other_value.repeatIndicator(), legacy) : !single_value->field_repeatIndicator.match_omit(legacy)))return FALSE;
if(!other_value.bearerCapability1().is_bound()) return FALSE;
if((other_value.bearerCapability1().ispresent() ? !single_value->field_bearerCapability1.match((const BearerCapability__TLV&)other_value.bearerCapability1(), legacy) : !single_value->field_bearerCapability1.match_omit(legacy)))return FALSE;
if(!other_value.bearerCapability2().is_bound()) return FALSE;
if((other_value.bearerCapability2().ispresent() ? !single_value->field_bearerCapability2.match((const BearerCapability__TLV&)other_value.bearerCapability2(), legacy) : !single_value->field_bearerCapability2.match_omit(legacy)))return FALSE;
if(!other_value.facility().is_bound()) return FALSE;
if((other_value.facility().ispresent() ? !single_value->field_facility.match((const MobileL3__CommonIE__Types::Facility__TLV&)other_value.facility(), legacy) : !single_value->field_facility.match_omit(legacy)))return FALSE;
if(!other_value.progressIndicator().is_bound()) return FALSE;
if((other_value.progressIndicator().ispresent() ? !single_value->field_progressIndicator.match((const ProgressIndicator__TLV&)other_value.progressIndicator(), legacy) : !single_value->field_progressIndicator.match_omit(legacy)))return FALSE;
if(!other_value.priorityGranted().is_bound()) return FALSE;
if((other_value.priorityGranted().ispresent() ? !single_value->field_priorityGranted.match((const MobileL3__CommonIE__Types::PriorityLevel__ML3&)other_value.priorityGranted(), legacy) : !single_value->field_priorityGranted.match_omit(legacy)))return FALSE;
if(!other_value.networkCCCapabilities().is_bound()) return FALSE;
if((other_value.networkCCCapabilities().ispresent() ? !single_value->field_networkCCCapabilities.match((const NetworkCallControlCapabilities&)other_value.networkCCCapabilities(), legacy) : !single_value->field_networkCCCapabilities.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
}
return FALSE;
}

boolean PDU__ML3__CallProceeding_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound()
 || (single_value->field_repeatIndicator.is_omit() || single_value->field_repeatIndicator.is_bound())
 || (single_value->field_bearerCapability1.is_omit() || single_value->field_bearerCapability1.is_bound())
 || (single_value->field_bearerCapability2.is_omit() || single_value->field_bearerCapability2.is_bound())
 || (single_value->field_facility.is_omit() || single_value->field_facility.is_bound())
 || (single_value->field_progressIndicator.is_omit() || single_value->field_progressIndicator.is_bound())
 || (single_value->field_priorityGranted.is_omit() || single_value->field_priorityGranted.is_bound())
 || (single_value->field_networkCCCapabilities.is_omit() || single_value->field_networkCCCapabilities.is_bound());
}

boolean PDU__ML3__CallProceeding_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value()
 && (single_value->field_repeatIndicator.is_omit() || single_value->field_repeatIndicator.is_value())
 && (single_value->field_bearerCapability1.is_omit() || single_value->field_bearerCapability1.is_value())
 && (single_value->field_bearerCapability2.is_omit() || single_value->field_bearerCapability2.is_value())
 && (single_value->field_facility.is_omit() || single_value->field_facility.is_value())
 && (single_value->field_progressIndicator.is_omit() || single_value->field_progressIndicator.is_value())
 && (single_value->field_priorityGranted.is_omit() || single_value->field_priorityGranted.is_value())
 && (single_value->field_networkCCCapabilities.is_omit() || single_value->field_networkCCCapabilities.is_value());
}

void PDU__ML3__CallProceeding_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__CallProceeding PDU__ML3__CallProceeding_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
PDU__ML3__CallProceeding ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
if (single_value->field_repeatIndicator.is_omit()) ret_val.repeatIndicator() = OMIT_VALUE;
else if (single_value->field_repeatIndicator.is_bound()) {
ret_val.repeatIndicator() = single_value->field_repeatIndicator.valueof();
}
if (single_value->field_bearerCapability1.is_omit()) ret_val.bearerCapability1() = OMIT_VALUE;
else if (single_value->field_bearerCapability1.is_bound()) {
ret_val.bearerCapability1() = single_value->field_bearerCapability1.valueof();
}
if (single_value->field_bearerCapability2.is_omit()) ret_val.bearerCapability2() = OMIT_VALUE;
else if (single_value->field_bearerCapability2.is_bound()) {
ret_val.bearerCapability2() = single_value->field_bearerCapability2.valueof();
}
if (single_value->field_facility.is_omit()) ret_val.facility() = OMIT_VALUE;
else if (single_value->field_facility.is_bound()) {
ret_val.facility() = single_value->field_facility.valueof();
}
if (single_value->field_progressIndicator.is_omit()) ret_val.progressIndicator() = OMIT_VALUE;
else if (single_value->field_progressIndicator.is_bound()) {
ret_val.progressIndicator() = single_value->field_progressIndicator.valueof();
}
if (single_value->field_priorityGranted.is_omit()) ret_val.priorityGranted() = OMIT_VALUE;
else if (single_value->field_priorityGranted.is_bound()) {
ret_val.priorityGranted() = single_value->field_priorityGranted.valueof();
}
if (single_value->field_networkCCCapabilities.is_omit()) ret_val.networkCCCapabilities() = OMIT_VALUE;
else if (single_value->field_networkCCCapabilities.is_bound()) {
ret_val.networkCCCapabilities() = single_value->field_networkCCCapabilities.valueof();
}
return ret_val;
}

void PDU__ML3__CallProceeding_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__CallProceeding_template[list_length];
}

PDU__ML3__CallProceeding_template& PDU__ML3__CallProceeding_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__CallProceeding_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__CallProceeding_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__CallProceeding_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__CallProceeding_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
return single_value->field_nsd;
}

RepeatIndicator_template& PDU__ML3__CallProceeding_template::repeatIndicator()
{
set_specific();
return single_value->field_repeatIndicator;
}

const RepeatIndicator_template& PDU__ML3__CallProceeding_template::repeatIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field repeatIndicator of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
return single_value->field_repeatIndicator;
}

BearerCapability__TLV_template& PDU__ML3__CallProceeding_template::bearerCapability1()
{
set_specific();
return single_value->field_bearerCapability1;
}

const BearerCapability__TLV_template& PDU__ML3__CallProceeding_template::bearerCapability1() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bearerCapability1 of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
return single_value->field_bearerCapability1;
}

BearerCapability__TLV_template& PDU__ML3__CallProceeding_template::bearerCapability2()
{
set_specific();
return single_value->field_bearerCapability2;
}

const BearerCapability__TLV_template& PDU__ML3__CallProceeding_template::bearerCapability2() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bearerCapability2 of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
return single_value->field_bearerCapability2;
}

MobileL3__CommonIE__Types::Facility__TLV_template& PDU__ML3__CallProceeding_template::facility()
{
set_specific();
return single_value->field_facility;
}

const MobileL3__CommonIE__Types::Facility__TLV_template& PDU__ML3__CallProceeding_template::facility() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field facility of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
return single_value->field_facility;
}

ProgressIndicator__TLV_template& PDU__ML3__CallProceeding_template::progressIndicator()
{
set_specific();
return single_value->field_progressIndicator;
}

const ProgressIndicator__TLV_template& PDU__ML3__CallProceeding_template::progressIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field progressIndicator of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
return single_value->field_progressIndicator;
}

MobileL3__CommonIE__Types::PriorityLevel__ML3_template& PDU__ML3__CallProceeding_template::priorityGranted()
{
set_specific();
return single_value->field_priorityGranted;
}

const MobileL3__CommonIE__Types::PriorityLevel__ML3_template& PDU__ML3__CallProceeding_template::priorityGranted() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field priorityGranted of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
return single_value->field_priorityGranted;
}

NetworkCallControlCapabilities_template& PDU__ML3__CallProceeding_template::networkCCCapabilities()
{
set_specific();
return single_value->field_networkCCCapabilities;
}

const NetworkCallControlCapabilities_template& PDU__ML3__CallProceeding_template::networkCCCapabilities() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field networkCCCapabilities of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
return single_value->field_networkCCCapabilities;
}

int PDU__ML3__CallProceeding_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_repeatIndicator.is_present()) ret_val++;
      if (single_value->field_bearerCapability1.is_present()) ret_val++;
      if (single_value->field_bearerCapability2.is_present()) ret_val++;
      if (single_value->field_facility.is_present()) ret_val++;
      if (single_value->field_progressIndicator.is_present()) ret_val++;
      if (single_value->field_priorityGranted.is_present()) ret_val++;
      if (single_value->field_networkCCCapabilities.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
  }
  return 0;
}

void PDU__ML3__CallProceeding_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(", repeatIndicator := ");
single_value->field_repeatIndicator.log();
TTCN_Logger::log_event_str(", bearerCapability1 := ");
single_value->field_bearerCapability1.log();
TTCN_Logger::log_event_str(", bearerCapability2 := ");
single_value->field_bearerCapability2.log();
TTCN_Logger::log_event_str(", facility := ");
single_value->field_facility.log();
TTCN_Logger::log_event_str(", progressIndicator := ");
single_value->field_progressIndicator.log();
TTCN_Logger::log_event_str(", priorityGranted := ");
single_value->field_priorityGranted.log();
TTCN_Logger::log_event_str(", networkCCCapabilities := ");
single_value->field_networkCCCapabilities.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__CallProceeding_template::log_match(const PDU__ML3__CallProceeding& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.repeatIndicator().ispresent()){
if(!single_value->field_repeatIndicator.match(match_value.repeatIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".repeatIndicator");
single_value->field_repeatIndicator.log_match(match_value.repeatIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_repeatIndicator.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".repeatIndicator := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_repeatIndicator.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.bearerCapability1().ispresent()){
if(!single_value->field_bearerCapability1.match(match_value.bearerCapability1(), legacy)){
TTCN_Logger::log_logmatch_info(".bearerCapability1");
single_value->field_bearerCapability1.log_match(match_value.bearerCapability1(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_bearerCapability1.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".bearerCapability1 := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_bearerCapability1.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.bearerCapability2().ispresent()){
if(!single_value->field_bearerCapability2.match(match_value.bearerCapability2(), legacy)){
TTCN_Logger::log_logmatch_info(".bearerCapability2");
single_value->field_bearerCapability2.log_match(match_value.bearerCapability2(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_bearerCapability2.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".bearerCapability2 := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_bearerCapability2.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.facility().ispresent()){
if(!single_value->field_facility.match(match_value.facility(), legacy)){
TTCN_Logger::log_logmatch_info(".facility");
single_value->field_facility.log_match(match_value.facility(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_facility.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".facility := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_facility.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.progressIndicator().ispresent()){
if(!single_value->field_progressIndicator.match(match_value.progressIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".progressIndicator");
single_value->field_progressIndicator.log_match(match_value.progressIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_progressIndicator.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".progressIndicator := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_progressIndicator.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.priorityGranted().ispresent()){
if(!single_value->field_priorityGranted.match(match_value.priorityGranted(), legacy)){
TTCN_Logger::log_logmatch_info(".priorityGranted");
single_value->field_priorityGranted.log_match(match_value.priorityGranted(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_priorityGranted.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".priorityGranted := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_priorityGranted.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.networkCCCapabilities().ispresent()){
if(!single_value->field_networkCCCapabilities.match(match_value.networkCCCapabilities(), legacy)){
TTCN_Logger::log_logmatch_info(".networkCCCapabilities");
single_value->field_networkCCCapabilities.log_match(match_value.networkCCCapabilities(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_networkCCCapabilities.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".networkCCCapabilities := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_networkCCCapabilities.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(", repeatIndicator := ");
if (match_value.repeatIndicator().ispresent()) {
single_value->field_repeatIndicator.log_match(match_value.repeatIndicator(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_repeatIndicator.log();
if (single_value->field_repeatIndicator.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", bearerCapability1 := ");
if (match_value.bearerCapability1().ispresent()) {
single_value->field_bearerCapability1.log_match(match_value.bearerCapability1(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_bearerCapability1.log();
if (single_value->field_bearerCapability1.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", bearerCapability2 := ");
if (match_value.bearerCapability2().ispresent()) {
single_value->field_bearerCapability2.log_match(match_value.bearerCapability2(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_bearerCapability2.log();
if (single_value->field_bearerCapability2.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", facility := ");
if (match_value.facility().ispresent()) {
single_value->field_facility.log_match(match_value.facility(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_facility.log();
if (single_value->field_facility.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", progressIndicator := ");
if (match_value.progressIndicator().ispresent()) {
single_value->field_progressIndicator.log_match(match_value.progressIndicator(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_progressIndicator.log();
if (single_value->field_progressIndicator.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", priorityGranted := ");
if (match_value.priorityGranted().ispresent()) {
single_value->field_priorityGranted.log_match(match_value.priorityGranted(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_priorityGranted.log();
if (single_value->field_priorityGranted.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", networkCCCapabilities := ");
if (match_value.networkCCCapabilities().ispresent()) {
single_value->field_networkCCCapabilities.log_match(match_value.networkCCCapabilities(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_networkCCCapabilities.log();
if (single_value->field_networkCCCapabilities.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__CallProceeding_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
single_value->field_repeatIndicator.encode_text(text_buf);
single_value->field_bearerCapability1.encode_text(text_buf);
single_value->field_bearerCapability2.encode_text(text_buf);
single_value->field_facility.encode_text(text_buf);
single_value->field_progressIndicator.encode_text(text_buf);
single_value->field_priorityGranted.encode_text(text_buf);
single_value->field_networkCCCapabilities.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
}
}

void PDU__ML3__CallProceeding_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
single_value->field_repeatIndicator.decode_text(text_buf);
single_value->field_bearerCapability1.decode_text(text_buf);
single_value->field_bearerCapability2.decode_text(text_buf);
single_value->field_facility.decode_text(text_buf);
single_value->field_progressIndicator.decode_text(text_buf);
single_value->field_priorityGranted.decode_text(text_buf);
single_value->field_networkCCCapabilities.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__CallProceeding_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding.");
}
}

void PDU__ML3__CallProceeding_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__CallProceeding_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.PDU_ML3_CallProceeding has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) repeatIndicator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) bearerCapability1().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) bearerCapability2().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) facility().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) progressIndicator().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) priorityGranted().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) networkCCCapabilities().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "repeatIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          repeatIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bearerCapability1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bearerCapability1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bearerCapability2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bearerCapability2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "progressIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          progressIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "priorityGranted")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          priorityGranted().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "networkCCCapabilities")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          networkCCCapabilities().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_CallProceeding: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__CallProceeding_template* precondition = new PDU__ML3__CallProceeding_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__CallProceeding_template* implied_template = new PDU__ML3__CallProceeding_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__CallProceeding_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.PDU_ML3_CallProceeding");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__CallProceeding_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CallProceeding");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CallProceeding");
single_value->field_repeatIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CallProceeding");
single_value->field_bearerCapability1.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CallProceeding");
single_value->field_bearerCapability2.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CallProceeding");
single_value->field_facility.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CallProceeding");
single_value->field_progressIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CallProceeding");
single_value->field_priorityGranted.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CallProceeding");
single_value->field_networkCCCapabilities.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CallProceeding");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CallProceeding");
}

boolean PDU__ML3__CallProceeding_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__CallProceeding_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__ML3__CongestionControl::PDU__ML3__CongestionControl()
{
}

PDU__ML3__CongestionControl::PDU__ML3__CongestionControl(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd,
    const BITSTRING& par_congestionLevel,
    const BITSTRING& par_spare__4,
    const OPTIONAL< MobileL3__CommonIE__Types::ML3__Cause__TLV >& par_cause)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd),
  field_congestionLevel(par_congestionLevel),
  field_spare__4(par_spare__4),
  field_cause(par_cause)
{
}

PDU__ML3__CongestionControl::PDU__ML3__CongestionControl(const PDU__ML3__CongestionControl& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.PDU_ML3_CongestionControl.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
if (other_value.congestionLevel().is_bound()) field_congestionLevel = other_value.congestionLevel();
else field_congestionLevel.clean_up();
if (other_value.spare__4().is_bound()) field_spare__4 = other_value.spare__4();
else field_spare__4.clean_up();
if (other_value.cause().is_bound()) field_cause = other_value.cause();
else field_cause.clean_up();
}

void PDU__ML3__CongestionControl::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
field_congestionLevel.clean_up();
field_spare__4.clean_up();
field_cause.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__CongestionControl::get_descriptor() const { return &PDU__ML3__CongestionControl_descr_; }
PDU__ML3__CongestionControl& PDU__ML3__CongestionControl::operator=(const PDU__ML3__CongestionControl& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.PDU_ML3_CongestionControl.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
  if (other_value.congestionLevel().is_bound()) field_congestionLevel = other_value.congestionLevel();
  else field_congestionLevel.clean_up();
  if (other_value.spare__4().is_bound()) field_spare__4 = other_value.spare__4();
  else field_spare__4.clean_up();
  if (other_value.cause().is_bound()) field_cause = other_value.cause();
  else field_cause.clean_up();
}
return *this;
}

boolean PDU__ML3__CongestionControl::operator==(const PDU__ML3__CongestionControl& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd
  && field_congestionLevel==other_value.field_congestionLevel
  && field_spare__4==other_value.field_spare__4
  && field_cause==other_value.field_cause;
}

boolean PDU__ML3__CongestionControl::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound())
  || (field_congestionLevel.is_bound())
  || (field_spare__4.is_bound())
  || (OPTIONAL_OMIT == field_cause.get_selection() || field_cause.is_bound());
}
boolean PDU__ML3__CongestionControl::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value()
  && field_congestionLevel.is_value()
  && field_spare__4.is_value()
  && (OPTIONAL_OMIT == field_cause.get_selection() || field_cause.is_value());
}
int PDU__ML3__CongestionControl::size_of() const
{
  int ret_val = 4;
  if (field_cause.ispresent()) ret_val++;
  return ret_val;
}

void PDU__ML3__CongestionControl::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(", congestionLevel := ");
field_congestionLevel.log();
TTCN_Logger::log_event_str(", spare_4 := ");
field_spare__4.log();
TTCN_Logger::log_event_str(", cause := ");
field_cause.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__CongestionControl::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (congestionLevel().is_bound()) congestionLevel().set_implicit_omit();
if (spare__4().is_bound()) spare__4().set_implicit_omit();
if (!cause().is_bound()) cause() = OMIT_VALUE;
else cause().set_implicit_omit();
}

void PDU__ML3__CongestionControl::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.PDU_ML3_CongestionControl has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) congestionLevel().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare__4().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "congestionLevel")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          congestionLevel().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare_4")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare__4().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_CongestionControl: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.PDU_ML3_CongestionControl");
  }
}

void PDU__ML3__CongestionControl::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
field_congestionLevel.encode_text(text_buf);
field_spare__4.encode_text(text_buf);
field_cause.encode_text(text_buf);
}

void PDU__ML3__CongestionControl::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
field_congestionLevel.decode_text(text_buf);
field_spare__4.decode_text(text_buf);
field_cause.decode_text(text_buf);
}

void PDU__ML3__CongestionControl::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__CongestionControl::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__CongestionControl::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, CongestionLevelV_descr_.raw->forceomit);
  decoded_field_length = field_congestionLevel.RAW_decode(CongestionLevelV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare__4.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_cause = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, MobileL3__CommonIE__Types::ML3__Cause__TLV_descr_.raw->forceomit);
  decoded_field_length = field_cause().RAW_decode(MobileL3__CommonIE__Types::ML3__Cause__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_cause = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_cause.ispresent() || field_cause().elementIdentifier() !=  os_5){
  field_cause=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_cause=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__CongestionControl::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, CongestionLevelV_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT4_descr_.raw);
  if (field_cause.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, MobileL3__CommonIE__Types::ML3__Cause__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_congestionLevel.RAW_encode(CongestionLevelV_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_spare__4.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[3]);
  if (field_cause.ispresent()) {
  encoded_length += field_cause().RAW_encode(MobileL3__CommonIE__Types::ML3__Cause__TLV_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_cause.ispresent() && (!field_cause.ispresent() || field_cause().elementIdentifier() !=  os_5)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={4,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_5.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__ML3__CongestionControl_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
BITSTRING_template field_congestionLevel;
BITSTRING_template field_spare__4;
MobileL3__CommonIE__Types::ML3__Cause__TLV_template field_cause;
};

void PDU__ML3__CongestionControl_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
single_value->field_congestionLevel = ANY_VALUE;
single_value->field_spare__4 = ANY_VALUE;
single_value->field_cause = ANY_OR_OMIT;
}
}
}

void PDU__ML3__CongestionControl_template::copy_value(const PDU__ML3__CongestionControl& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
if (other_value.congestionLevel().is_bound()) {
  single_value->field_congestionLevel = other_value.congestionLevel();
} else {
  single_value->field_congestionLevel.clean_up();
}
if (other_value.spare__4().is_bound()) {
  single_value->field_spare__4 = other_value.spare__4();
} else {
  single_value->field_spare__4.clean_up();
}
if (other_value.cause().is_bound()) {
  if (other_value.cause().ispresent()) single_value->field_cause = other_value.cause()();
  else single_value->field_cause = OMIT_VALUE;
} else {
  single_value->field_cause.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__CongestionControl_template::copy_template(const PDU__ML3__CongestionControl_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.congestionLevel().get_selection()) {
single_value->field_congestionLevel = other_value.congestionLevel();
} else {
single_value->field_congestionLevel.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare__4().get_selection()) {
single_value->field_spare__4 = other_value.spare__4();
} else {
single_value->field_spare__4.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cause().get_selection()) {
single_value->field_cause = other_value.cause();
} else {
single_value->field_cause.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__CongestionControl_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__CongestionControl_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__CongestionControl_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl.");
break;
}
set_selection(other_value);
}

PDU__ML3__CongestionControl_template::PDU__ML3__CongestionControl_template()
{
}

PDU__ML3__CongestionControl_template::PDU__ML3__CongestionControl_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__CongestionControl_template::PDU__ML3__CongestionControl_template(const PDU__ML3__CongestionControl& other_value)
{
copy_value(other_value);
}

PDU__ML3__CongestionControl_template::PDU__ML3__CongestionControl_template(const OPTIONAL<PDU__ML3__CongestionControl>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__CongestionControl&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl from an unbound optional field.");
}
}

PDU__ML3__CongestionControl_template::PDU__ML3__CongestionControl_template(PDU__ML3__CongestionControl_template* p_precondition, PDU__ML3__CongestionControl_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__CongestionControl_template::PDU__ML3__CongestionControl_template(Dynamic_Match_Interface<PDU__ML3__CongestionControl>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__CongestionControl>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__CongestionControl_template::PDU__ML3__CongestionControl_template(const PDU__ML3__CongestionControl_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__CongestionControl_template::~PDU__ML3__CongestionControl_template()
{
clean_up();
}

PDU__ML3__CongestionControl_template& PDU__ML3__CongestionControl_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__CongestionControl_template& PDU__ML3__CongestionControl_template::operator=(const PDU__ML3__CongestionControl& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__CongestionControl_template& PDU__ML3__CongestionControl_template::operator=(const OPTIONAL<PDU__ML3__CongestionControl>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__CongestionControl&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl.");
}
return *this;
}

PDU__ML3__CongestionControl_template& PDU__ML3__CongestionControl_template::operator=(const PDU__ML3__CongestionControl_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__CongestionControl_template::match(const PDU__ML3__CongestionControl& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
if(!other_value.congestionLevel().is_bound()) return FALSE;
if(!single_value->field_congestionLevel.match(other_value.congestionLevel(), legacy))return FALSE;
if(!other_value.spare__4().is_bound()) return FALSE;
if(!single_value->field_spare__4.match(other_value.spare__4(), legacy))return FALSE;
if(!other_value.cause().is_bound()) return FALSE;
if((other_value.cause().ispresent() ? !single_value->field_cause.match((const MobileL3__CommonIE__Types::ML3__Cause__TLV&)other_value.cause(), legacy) : !single_value->field_cause.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl.");
}
return FALSE;
}

boolean PDU__ML3__CongestionControl_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound()
 || single_value->field_congestionLevel.is_bound()
 || single_value->field_spare__4.is_bound()
 || (single_value->field_cause.is_omit() || single_value->field_cause.is_bound());
}

boolean PDU__ML3__CongestionControl_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value()
 && single_value->field_congestionLevel.is_value()
 && single_value->field_spare__4.is_value()
 && (single_value->field_cause.is_omit() || single_value->field_cause.is_value());
}

void PDU__ML3__CongestionControl_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__CongestionControl PDU__ML3__CongestionControl_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl.");
PDU__ML3__CongestionControl ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
if (single_value->field_congestionLevel.is_bound()) {
ret_val.congestionLevel() = single_value->field_congestionLevel.valueof();
}
if (single_value->field_spare__4.is_bound()) {
ret_val.spare__4() = single_value->field_spare__4.valueof();
}
if (single_value->field_cause.is_omit()) ret_val.cause() = OMIT_VALUE;
else if (single_value->field_cause.is_bound()) {
ret_val.cause() = single_value->field_cause.valueof();
}
return ret_val;
}

void PDU__ML3__CongestionControl_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__CongestionControl_template[list_length];
}

PDU__ML3__CongestionControl_template& PDU__ML3__CongestionControl_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__CongestionControl_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__CongestionControl_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__CongestionControl_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__CongestionControl_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl.");
return single_value->field_nsd;
}

BITSTRING_template& PDU__ML3__CongestionControl_template::congestionLevel()
{
set_specific();
return single_value->field_congestionLevel;
}

const BITSTRING_template& PDU__ML3__CongestionControl_template::congestionLevel() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field congestionLevel of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl.");
return single_value->field_congestionLevel;
}

BITSTRING_template& PDU__ML3__CongestionControl_template::spare__4()
{
set_specific();
return single_value->field_spare__4;
}

const BITSTRING_template& PDU__ML3__CongestionControl_template::spare__4() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare_4 of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl.");
return single_value->field_spare__4;
}

MobileL3__CommonIE__Types::ML3__Cause__TLV_template& PDU__ML3__CongestionControl_template::cause()
{
set_specific();
return single_value->field_cause;
}

const MobileL3__CommonIE__Types::ML3__Cause__TLV_template& PDU__ML3__CongestionControl_template::cause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cause of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl.");
return single_value->field_cause;
}

int PDU__ML3__CongestionControl_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 4;
      if (single_value->field_cause.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl.");
  }
  return 0;
}

void PDU__ML3__CongestionControl_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(", congestionLevel := ");
single_value->field_congestionLevel.log();
TTCN_Logger::log_event_str(", spare_4 := ");
single_value->field_spare__4.log();
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__CongestionControl_template::log_match(const PDU__ML3__CongestionControl& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_congestionLevel.match(match_value.congestionLevel(), legacy)){
TTCN_Logger::log_logmatch_info(".congestionLevel");
single_value->field_congestionLevel.log_match(match_value.congestionLevel(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare__4.match(match_value.spare__4(), legacy)){
TTCN_Logger::log_logmatch_info(".spare_4");
single_value->field_spare__4.log_match(match_value.spare__4(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.cause().ispresent()){
if(!single_value->field_cause.match(match_value.cause(), legacy)){
TTCN_Logger::log_logmatch_info(".cause");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_cause.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".cause := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_cause.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(", congestionLevel := ");
single_value->field_congestionLevel.log_match(match_value.congestionLevel(), legacy);
TTCN_Logger::log_event_str(", spare_4 := ");
single_value->field_spare__4.log_match(match_value.spare__4(), legacy);
TTCN_Logger::log_event_str(", cause := ");
if (match_value.cause().ispresent()) {
single_value->field_cause.log_match(match_value.cause(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_cause.log();
if (single_value->field_cause.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__CongestionControl_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
single_value->field_congestionLevel.encode_text(text_buf);
single_value->field_spare__4.encode_text(text_buf);
single_value->field_cause.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl.");
}
}

void PDU__ML3__CongestionControl_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
single_value->field_congestionLevel.decode_text(text_buf);
single_value->field_spare__4.decode_text(text_buf);
single_value->field_cause.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__CongestionControl_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl.");
}
}

void PDU__ML3__CongestionControl_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__CongestionControl_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.PDU_ML3_CongestionControl has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) congestionLevel().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare__4().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "congestionLevel")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          congestionLevel().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare_4")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare__4().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_CongestionControl: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__CongestionControl_template* precondition = new PDU__ML3__CongestionControl_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__CongestionControl_template* implied_template = new PDU__ML3__CongestionControl_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__CongestionControl_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.PDU_ML3_CongestionControl");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__CongestionControl_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CongestionControl");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CongestionControl");
single_value->field_congestionLevel.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CongestionControl");
single_value->field_spare__4.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CongestionControl");
single_value->field_cause.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CongestionControl");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_CongestionControl");
}

boolean PDU__ML3__CongestionControl_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__CongestionControl_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__ML3__Connect__NW__MS::PDU__ML3__Connect__NW__MS()
{
}

PDU__ML3__Connect__NW__MS::PDU__ML3__Connect__NW__MS(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd,
    const OPTIONAL< MobileL3__CommonIE__Types::Facility__TLV >& par_facility,
    const OPTIONAL< ProgressIndicator__TLV >& par_progressIndicator,
    const OPTIONAL< ConnectedNumber >& par_connectedNumber,
    const OPTIONAL< ConnectedSubAddress >& par_connectedSubAddress,
    const OPTIONAL< User__user__TLV >& par_user__user)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd),
  field_facility(par_facility),
  field_progressIndicator(par_progressIndicator),
  field_connectedNumber(par_connectedNumber),
  field_connectedSubAddress(par_connectedSubAddress),
  field_user__user(par_user__user)
{
}

PDU__ML3__Connect__NW__MS::PDU__ML3__Connect__NW__MS(const PDU__ML3__Connect__NW__MS& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
if (other_value.facility().is_bound()) field_facility = other_value.facility();
else field_facility.clean_up();
if (other_value.progressIndicator().is_bound()) field_progressIndicator = other_value.progressIndicator();
else field_progressIndicator.clean_up();
if (other_value.connectedNumber().is_bound()) field_connectedNumber = other_value.connectedNumber();
else field_connectedNumber.clean_up();
if (other_value.connectedSubAddress().is_bound()) field_connectedSubAddress = other_value.connectedSubAddress();
else field_connectedSubAddress.clean_up();
if (other_value.user__user().is_bound()) field_user__user = other_value.user__user();
else field_user__user.clean_up();
}

void PDU__ML3__Connect__NW__MS::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
field_facility.clean_up();
field_progressIndicator.clean_up();
field_connectedNumber.clean_up();
field_connectedSubAddress.clean_up();
field_user__user.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__Connect__NW__MS::get_descriptor() const { return &PDU__ML3__Connect__NW__MS_descr_; }
PDU__ML3__Connect__NW__MS& PDU__ML3__Connect__NW__MS::operator=(const PDU__ML3__Connect__NW__MS& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
  if (other_value.facility().is_bound()) field_facility = other_value.facility();
  else field_facility.clean_up();
  if (other_value.progressIndicator().is_bound()) field_progressIndicator = other_value.progressIndicator();
  else field_progressIndicator.clean_up();
  if (other_value.connectedNumber().is_bound()) field_connectedNumber = other_value.connectedNumber();
  else field_connectedNumber.clean_up();
  if (other_value.connectedSubAddress().is_bound()) field_connectedSubAddress = other_value.connectedSubAddress();
  else field_connectedSubAddress.clean_up();
  if (other_value.user__user().is_bound()) field_user__user = other_value.user__user();
  else field_user__user.clean_up();
}
return *this;
}

boolean PDU__ML3__Connect__NW__MS::operator==(const PDU__ML3__Connect__NW__MS& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd
  && field_facility==other_value.field_facility
  && field_progressIndicator==other_value.field_progressIndicator
  && field_connectedNumber==other_value.field_connectedNumber
  && field_connectedSubAddress==other_value.field_connectedSubAddress
  && field_user__user==other_value.field_user__user;
}

boolean PDU__ML3__Connect__NW__MS::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound())
  || (OPTIONAL_OMIT == field_facility.get_selection() || field_facility.is_bound())
  || (OPTIONAL_OMIT == field_progressIndicator.get_selection() || field_progressIndicator.is_bound())
  || (OPTIONAL_OMIT == field_connectedNumber.get_selection() || field_connectedNumber.is_bound())
  || (OPTIONAL_OMIT == field_connectedSubAddress.get_selection() || field_connectedSubAddress.is_bound())
  || (OPTIONAL_OMIT == field_user__user.get_selection() || field_user__user.is_bound());
}
boolean PDU__ML3__Connect__NW__MS::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value()
  && (OPTIONAL_OMIT == field_facility.get_selection() || field_facility.is_value())
  && (OPTIONAL_OMIT == field_progressIndicator.get_selection() || field_progressIndicator.is_value())
  && (OPTIONAL_OMIT == field_connectedNumber.get_selection() || field_connectedNumber.is_value())
  && (OPTIONAL_OMIT == field_connectedSubAddress.get_selection() || field_connectedSubAddress.is_value())
  && (OPTIONAL_OMIT == field_user__user.get_selection() || field_user__user.is_value());
}
int PDU__ML3__Connect__NW__MS::size_of() const
{
  int ret_val = 2;
  if (field_facility.ispresent()) ret_val++;
  if (field_progressIndicator.ispresent()) ret_val++;
  if (field_connectedNumber.ispresent()) ret_val++;
  if (field_connectedSubAddress.ispresent()) ret_val++;
  if (field_user__user.ispresent()) ret_val++;
  return ret_val;
}

void PDU__ML3__Connect__NW__MS::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(", facility := ");
field_facility.log();
TTCN_Logger::log_event_str(", progressIndicator := ");
field_progressIndicator.log();
TTCN_Logger::log_event_str(", connectedNumber := ");
field_connectedNumber.log();
TTCN_Logger::log_event_str(", connectedSubAddress := ");
field_connectedSubAddress.log();
TTCN_Logger::log_event_str(", user_user := ");
field_user__user.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__Connect__NW__MS::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (!facility().is_bound()) facility() = OMIT_VALUE;
else facility().set_implicit_omit();
if (!progressIndicator().is_bound()) progressIndicator() = OMIT_VALUE;
else progressIndicator().set_implicit_omit();
if (!connectedNumber().is_bound()) connectedNumber() = OMIT_VALUE;
else connectedNumber().set_implicit_omit();
if (!connectedSubAddress().is_bound()) connectedSubAddress() = OMIT_VALUE;
else connectedSubAddress().set_implicit_omit();
if (!user__user().is_bound()) user__user() = OMIT_VALUE;
else user__user().set_implicit_omit();
}

void PDU__ML3__Connect__NW__MS::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) facility().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) progressIndicator().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) connectedNumber().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) connectedSubAddress().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) user__user().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "progressIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          progressIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connectedNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connectedNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connectedSubAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connectedSubAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_user")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__user().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.PDU_ML3_Connect_NW_MS");
  }
}

void PDU__ML3__Connect__NW__MS::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
field_facility.encode_text(text_buf);
field_progressIndicator.encode_text(text_buf);
field_connectedNumber.encode_text(text_buf);
field_connectedSubAddress.encode_text(text_buf);
field_user__user.encode_text(text_buf);
}

void PDU__ML3__Connect__NW__MS::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
field_facility.decode_text(text_buf);
field_progressIndicator.decode_text(text_buf);
field_connectedNumber.decode_text(text_buf);
field_connectedSubAddress.decode_text(text_buf);
field_user__user.decode_text(text_buf);
}

void PDU__ML3__Connect__NW__MS::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__Connect__NW__MS::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__Connect__NW__MS::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_facility = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, MobileL3__CommonIE__Types::Facility__TLV_descr_.raw->forceomit);
  decoded_field_length = field_facility().RAW_decode(MobileL3__CommonIE__Types::Facility__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_facility = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_facility.ispresent() || field_facility().elementIdentifier() !=  os_0){
  field_facility=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_facility=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_progressIndicator = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, ProgressIndicator__TLV_descr_.raw->forceomit);
  decoded_field_length = field_progressIndicator().RAW_decode(ProgressIndicator__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_progressIndicator = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_progressIndicator.ispresent() || field_progressIndicator().elementIdentifier() !=  os_1){
  field_progressIndicator=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_progressIndicator=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_connectedNumber = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, ConnectedNumber_descr_.raw->forceomit);
  decoded_field_length = field_connectedNumber().RAW_decode(ConnectedNumber_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_connectedNumber = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_connectedNumber.ispresent() || field_connectedNumber().elementIdentifier() !=  os_9){
  field_connectedNumber=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_connectedNumber=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_connectedSubAddress = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, ConnectedSubAddress_descr_.raw->forceomit);
  decoded_field_length = field_connectedSubAddress().RAW_decode(ConnectedSubAddress_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_connectedSubAddress = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_connectedSubAddress.ispresent() || field_connectedSubAddress().elementIdentifier() !=  os_10){
  field_connectedSubAddress=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_connectedSubAddress=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_user__user = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, User__user__TLV_descr_.raw->forceomit);
  decoded_field_length = field_user__user().RAW_decode(User__user__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_user__user = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_user__user.ispresent() || field_user__user().elementIdentifier() !=  os_2){
  field_user__user=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_user__user=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__Connect__NW__MS::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 7;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(7);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  if (field_facility.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, MobileL3__CommonIE__Types::Facility__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_progressIndicator.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, ProgressIndicator__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_connectedNumber.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, ConnectedNumber_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_connectedSubAddress.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, ConnectedSubAddress_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_user__user.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, User__user__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  if (field_facility.ispresent()) {
  encoded_length += field_facility().RAW_encode(MobileL3__CommonIE__Types::Facility__TLV_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_progressIndicator.ispresent()) {
  encoded_length += field_progressIndicator().RAW_encode(ProgressIndicator__TLV_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_connectedNumber.ispresent()) {
  encoded_length += field_connectedNumber().RAW_encode(ConnectedNumber_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_connectedSubAddress.ispresent()) {
  encoded_length += field_connectedSubAddress().RAW_encode(ConnectedSubAddress_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_user__user.ispresent()) {
  encoded_length += field_user__user().RAW_encode(User__user__TLV_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_facility.ispresent() && (!field_facility.ispresent() || field_facility().elementIdentifier() !=  os_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={2,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_0.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_progressIndicator.ispresent() && (!field_progressIndicator.ispresent() || field_progressIndicator().elementIdentifier() !=  os_1)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={3,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_1.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_connectedNumber.ispresent() && (!field_connectedNumber.ispresent() || field_connectedNumber().elementIdentifier() !=  os_9)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={4,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_9.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_connectedSubAddress.ispresent() && (!field_connectedSubAddress.ispresent() || field_connectedSubAddress().elementIdentifier() !=  os_10)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={5,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_10.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_user__user.ispresent() && (!field_user__user.ispresent() || field_user__user().elementIdentifier() !=  os_2)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={6,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_2.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__ML3__Connect__NW__MS_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
MobileL3__CommonIE__Types::Facility__TLV_template field_facility;
ProgressIndicator__TLV_template field_progressIndicator;
ConnectedNumber_template field_connectedNumber;
ConnectedSubAddress_template field_connectedSubAddress;
User__user__TLV_template field_user__user;
};

void PDU__ML3__Connect__NW__MS_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
single_value->field_facility = ANY_OR_OMIT;
single_value->field_progressIndicator = ANY_OR_OMIT;
single_value->field_connectedNumber = ANY_OR_OMIT;
single_value->field_connectedSubAddress = ANY_OR_OMIT;
single_value->field_user__user = ANY_OR_OMIT;
}
}
}

void PDU__ML3__Connect__NW__MS_template::copy_value(const PDU__ML3__Connect__NW__MS& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
if (other_value.facility().is_bound()) {
  if (other_value.facility().ispresent()) single_value->field_facility = other_value.facility()();
  else single_value->field_facility = OMIT_VALUE;
} else {
  single_value->field_facility.clean_up();
}
if (other_value.progressIndicator().is_bound()) {
  if (other_value.progressIndicator().ispresent()) single_value->field_progressIndicator = other_value.progressIndicator()();
  else single_value->field_progressIndicator = OMIT_VALUE;
} else {
  single_value->field_progressIndicator.clean_up();
}
if (other_value.connectedNumber().is_bound()) {
  if (other_value.connectedNumber().ispresent()) single_value->field_connectedNumber = other_value.connectedNumber()();
  else single_value->field_connectedNumber = OMIT_VALUE;
} else {
  single_value->field_connectedNumber.clean_up();
}
if (other_value.connectedSubAddress().is_bound()) {
  if (other_value.connectedSubAddress().ispresent()) single_value->field_connectedSubAddress = other_value.connectedSubAddress()();
  else single_value->field_connectedSubAddress = OMIT_VALUE;
} else {
  single_value->field_connectedSubAddress.clean_up();
}
if (other_value.user__user().is_bound()) {
  if (other_value.user__user().ispresent()) single_value->field_user__user = other_value.user__user()();
  else single_value->field_user__user = OMIT_VALUE;
} else {
  single_value->field_user__user.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__Connect__NW__MS_template::copy_template(const PDU__ML3__Connect__NW__MS_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.facility().get_selection()) {
single_value->field_facility = other_value.facility();
} else {
single_value->field_facility.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.progressIndicator().get_selection()) {
single_value->field_progressIndicator = other_value.progressIndicator();
} else {
single_value->field_progressIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.connectedNumber().get_selection()) {
single_value->field_connectedNumber = other_value.connectedNumber();
} else {
single_value->field_connectedNumber.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.connectedSubAddress().get_selection()) {
single_value->field_connectedSubAddress = other_value.connectedSubAddress();
} else {
single_value->field_connectedSubAddress.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.user__user().get_selection()) {
single_value->field_user__user = other_value.user__user();
} else {
single_value->field_user__user.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__Connect__NW__MS_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__Connect__NW__MS_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__Connect__NW__MS_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS.");
break;
}
set_selection(other_value);
}

PDU__ML3__Connect__NW__MS_template::PDU__ML3__Connect__NW__MS_template()
{
}

PDU__ML3__Connect__NW__MS_template::PDU__ML3__Connect__NW__MS_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__Connect__NW__MS_template::PDU__ML3__Connect__NW__MS_template(const PDU__ML3__Connect__NW__MS& other_value)
{
copy_value(other_value);
}

PDU__ML3__Connect__NW__MS_template::PDU__ML3__Connect__NW__MS_template(const OPTIONAL<PDU__ML3__Connect__NW__MS>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__Connect__NW__MS&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS from an unbound optional field.");
}
}

PDU__ML3__Connect__NW__MS_template::PDU__ML3__Connect__NW__MS_template(PDU__ML3__Connect__NW__MS_template* p_precondition, PDU__ML3__Connect__NW__MS_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__Connect__NW__MS_template::PDU__ML3__Connect__NW__MS_template(Dynamic_Match_Interface<PDU__ML3__Connect__NW__MS>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__Connect__NW__MS>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__Connect__NW__MS_template::PDU__ML3__Connect__NW__MS_template(const PDU__ML3__Connect__NW__MS_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__Connect__NW__MS_template::~PDU__ML3__Connect__NW__MS_template()
{
clean_up();
}

PDU__ML3__Connect__NW__MS_template& PDU__ML3__Connect__NW__MS_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__Connect__NW__MS_template& PDU__ML3__Connect__NW__MS_template::operator=(const PDU__ML3__Connect__NW__MS& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__Connect__NW__MS_template& PDU__ML3__Connect__NW__MS_template::operator=(const OPTIONAL<PDU__ML3__Connect__NW__MS>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__Connect__NW__MS&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS.");
}
return *this;
}

PDU__ML3__Connect__NW__MS_template& PDU__ML3__Connect__NW__MS_template::operator=(const PDU__ML3__Connect__NW__MS_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__Connect__NW__MS_template::match(const PDU__ML3__Connect__NW__MS& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
if(!other_value.facility().is_bound()) return FALSE;
if((other_value.facility().ispresent() ? !single_value->field_facility.match((const MobileL3__CommonIE__Types::Facility__TLV&)other_value.facility(), legacy) : !single_value->field_facility.match_omit(legacy)))return FALSE;
if(!other_value.progressIndicator().is_bound()) return FALSE;
if((other_value.progressIndicator().ispresent() ? !single_value->field_progressIndicator.match((const ProgressIndicator__TLV&)other_value.progressIndicator(), legacy) : !single_value->field_progressIndicator.match_omit(legacy)))return FALSE;
if(!other_value.connectedNumber().is_bound()) return FALSE;
if((other_value.connectedNumber().ispresent() ? !single_value->field_connectedNumber.match((const ConnectedNumber&)other_value.connectedNumber(), legacy) : !single_value->field_connectedNumber.match_omit(legacy)))return FALSE;
if(!other_value.connectedSubAddress().is_bound()) return FALSE;
if((other_value.connectedSubAddress().ispresent() ? !single_value->field_connectedSubAddress.match((const ConnectedSubAddress&)other_value.connectedSubAddress(), legacy) : !single_value->field_connectedSubAddress.match_omit(legacy)))return FALSE;
if(!other_value.user__user().is_bound()) return FALSE;
if((other_value.user__user().ispresent() ? !single_value->field_user__user.match((const User__user__TLV&)other_value.user__user(), legacy) : !single_value->field_user__user.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS.");
}
return FALSE;
}

boolean PDU__ML3__Connect__NW__MS_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound()
 || (single_value->field_facility.is_omit() || single_value->field_facility.is_bound())
 || (single_value->field_progressIndicator.is_omit() || single_value->field_progressIndicator.is_bound())
 || (single_value->field_connectedNumber.is_omit() || single_value->field_connectedNumber.is_bound())
 || (single_value->field_connectedSubAddress.is_omit() || single_value->field_connectedSubAddress.is_bound())
 || (single_value->field_user__user.is_omit() || single_value->field_user__user.is_bound());
}

boolean PDU__ML3__Connect__NW__MS_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value()
 && (single_value->field_facility.is_omit() || single_value->field_facility.is_value())
 && (single_value->field_progressIndicator.is_omit() || single_value->field_progressIndicator.is_value())
 && (single_value->field_connectedNumber.is_omit() || single_value->field_connectedNumber.is_value())
 && (single_value->field_connectedSubAddress.is_omit() || single_value->field_connectedSubAddress.is_value())
 && (single_value->field_user__user.is_omit() || single_value->field_user__user.is_value());
}

void PDU__ML3__Connect__NW__MS_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__Connect__NW__MS PDU__ML3__Connect__NW__MS_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS.");
PDU__ML3__Connect__NW__MS ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
if (single_value->field_facility.is_omit()) ret_val.facility() = OMIT_VALUE;
else if (single_value->field_facility.is_bound()) {
ret_val.facility() = single_value->field_facility.valueof();
}
if (single_value->field_progressIndicator.is_omit()) ret_val.progressIndicator() = OMIT_VALUE;
else if (single_value->field_progressIndicator.is_bound()) {
ret_val.progressIndicator() = single_value->field_progressIndicator.valueof();
}
if (single_value->field_connectedNumber.is_omit()) ret_val.connectedNumber() = OMIT_VALUE;
else if (single_value->field_connectedNumber.is_bound()) {
ret_val.connectedNumber() = single_value->field_connectedNumber.valueof();
}
if (single_value->field_connectedSubAddress.is_omit()) ret_val.connectedSubAddress() = OMIT_VALUE;
else if (single_value->field_connectedSubAddress.is_bound()) {
ret_val.connectedSubAddress() = single_value->field_connectedSubAddress.valueof();
}
if (single_value->field_user__user.is_omit()) ret_val.user__user() = OMIT_VALUE;
else if (single_value->field_user__user.is_bound()) {
ret_val.user__user() = single_value->field_user__user.valueof();
}
return ret_val;
}

void PDU__ML3__Connect__NW__MS_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__Connect__NW__MS_template[list_length];
}

PDU__ML3__Connect__NW__MS_template& PDU__ML3__Connect__NW__MS_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__Connect__NW__MS_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__Connect__NW__MS_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__Connect__NW__MS_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__Connect__NW__MS_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS.");
return single_value->field_nsd;
}

MobileL3__CommonIE__Types::Facility__TLV_template& PDU__ML3__Connect__NW__MS_template::facility()
{
set_specific();
return single_value->field_facility;
}

const MobileL3__CommonIE__Types::Facility__TLV_template& PDU__ML3__Connect__NW__MS_template::facility() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field facility of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS.");
return single_value->field_facility;
}

ProgressIndicator__TLV_template& PDU__ML3__Connect__NW__MS_template::progressIndicator()
{
set_specific();
return single_value->field_progressIndicator;
}

const ProgressIndicator__TLV_template& PDU__ML3__Connect__NW__MS_template::progressIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field progressIndicator of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS.");
return single_value->field_progressIndicator;
}

ConnectedNumber_template& PDU__ML3__Connect__NW__MS_template::connectedNumber()
{
set_specific();
return single_value->field_connectedNumber;
}

const ConnectedNumber_template& PDU__ML3__Connect__NW__MS_template::connectedNumber() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field connectedNumber of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS.");
return single_value->field_connectedNumber;
}

ConnectedSubAddress_template& PDU__ML3__Connect__NW__MS_template::connectedSubAddress()
{
set_specific();
return single_value->field_connectedSubAddress;
}

const ConnectedSubAddress_template& PDU__ML3__Connect__NW__MS_template::connectedSubAddress() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field connectedSubAddress of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS.");
return single_value->field_connectedSubAddress;
}

User__user__TLV_template& PDU__ML3__Connect__NW__MS_template::user__user()
{
set_specific();
return single_value->field_user__user;
}

const User__user__TLV_template& PDU__ML3__Connect__NW__MS_template::user__user() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field user_user of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS.");
return single_value->field_user__user;
}

int PDU__ML3__Connect__NW__MS_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_facility.is_present()) ret_val++;
      if (single_value->field_progressIndicator.is_present()) ret_val++;
      if (single_value->field_connectedNumber.is_present()) ret_val++;
      if (single_value->field_connectedSubAddress.is_present()) ret_val++;
      if (single_value->field_user__user.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS.");
  }
  return 0;
}

void PDU__ML3__Connect__NW__MS_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(", facility := ");
single_value->field_facility.log();
TTCN_Logger::log_event_str(", progressIndicator := ");
single_value->field_progressIndicator.log();
TTCN_Logger::log_event_str(", connectedNumber := ");
single_value->field_connectedNumber.log();
TTCN_Logger::log_event_str(", connectedSubAddress := ");
single_value->field_connectedSubAddress.log();
TTCN_Logger::log_event_str(", user_user := ");
single_value->field_user__user.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__Connect__NW__MS_template::log_match(const PDU__ML3__Connect__NW__MS& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.facility().ispresent()){
if(!single_value->field_facility.match(match_value.facility(), legacy)){
TTCN_Logger::log_logmatch_info(".facility");
single_value->field_facility.log_match(match_value.facility(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_facility.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".facility := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_facility.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.progressIndicator().ispresent()){
if(!single_value->field_progressIndicator.match(match_value.progressIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".progressIndicator");
single_value->field_progressIndicator.log_match(match_value.progressIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_progressIndicator.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".progressIndicator := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_progressIndicator.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.connectedNumber().ispresent()){
if(!single_value->field_connectedNumber.match(match_value.connectedNumber(), legacy)){
TTCN_Logger::log_logmatch_info(".connectedNumber");
single_value->field_connectedNumber.log_match(match_value.connectedNumber(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_connectedNumber.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".connectedNumber := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_connectedNumber.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.connectedSubAddress().ispresent()){
if(!single_value->field_connectedSubAddress.match(match_value.connectedSubAddress(), legacy)){
TTCN_Logger::log_logmatch_info(".connectedSubAddress");
single_value->field_connectedSubAddress.log_match(match_value.connectedSubAddress(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_connectedSubAddress.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".connectedSubAddress := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_connectedSubAddress.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.user__user().ispresent()){
if(!single_value->field_user__user.match(match_value.user__user(), legacy)){
TTCN_Logger::log_logmatch_info(".user_user");
single_value->field_user__user.log_match(match_value.user__user(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_user__user.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".user_user := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_user__user.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(", facility := ");
if (match_value.facility().ispresent()) {
single_value->field_facility.log_match(match_value.facility(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_facility.log();
if (single_value->field_facility.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", progressIndicator := ");
if (match_value.progressIndicator().ispresent()) {
single_value->field_progressIndicator.log_match(match_value.progressIndicator(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_progressIndicator.log();
if (single_value->field_progressIndicator.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", connectedNumber := ");
if (match_value.connectedNumber().ispresent()) {
single_value->field_connectedNumber.log_match(match_value.connectedNumber(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_connectedNumber.log();
if (single_value->field_connectedNumber.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", connectedSubAddress := ");
if (match_value.connectedSubAddress().ispresent()) {
single_value->field_connectedSubAddress.log_match(match_value.connectedSubAddress(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_connectedSubAddress.log();
if (single_value->field_connectedSubAddress.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", user_user := ");
if (match_value.user__user().ispresent()) {
single_value->field_user__user.log_match(match_value.user__user(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_user__user.log();
if (single_value->field_user__user.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__Connect__NW__MS_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
single_value->field_facility.encode_text(text_buf);
single_value->field_progressIndicator.encode_text(text_buf);
single_value->field_connectedNumber.encode_text(text_buf);
single_value->field_connectedSubAddress.encode_text(text_buf);
single_value->field_user__user.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS.");
}
}

void PDU__ML3__Connect__NW__MS_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
single_value->field_facility.decode_text(text_buf);
single_value->field_progressIndicator.decode_text(text_buf);
single_value->field_connectedNumber.decode_text(text_buf);
single_value->field_connectedSubAddress.decode_text(text_buf);
single_value->field_user__user.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__Connect__NW__MS_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS.");
}
}

void PDU__ML3__Connect__NW__MS_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__Connect__NW__MS_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) facility().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) progressIndicator().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) connectedNumber().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) connectedSubAddress().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) user__user().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "progressIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          progressIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connectedNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connectedNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connectedSubAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connectedSubAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_user")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__user().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_Connect_NW_MS: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__Connect__NW__MS_template* precondition = new PDU__ML3__Connect__NW__MS_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__Connect__NW__MS_template* implied_template = new PDU__ML3__Connect__NW__MS_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__Connect__NW__MS_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.PDU_ML3_Connect_NW_MS");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__Connect__NW__MS_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Connect_NW_MS");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Connect_NW_MS");
single_value->field_facility.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Connect_NW_MS");
single_value->field_progressIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Connect_NW_MS");
single_value->field_connectedNumber.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Connect_NW_MS");
single_value->field_connectedSubAddress.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Connect_NW_MS");
single_value->field_user__user.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Connect_NW_MS");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Connect_NW_MS");
}

boolean PDU__ML3__Connect__NW__MS_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__Connect__NW__MS_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__ML3__Connect__MS__NW::PDU__ML3__Connect__MS__NW()
{
}

PDU__ML3__Connect__MS__NW::PDU__ML3__Connect__MS__NW(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd,
    const OPTIONAL< MobileL3__CommonIE__Types::Facility__TLV >& par_facility,
    const OPTIONAL< ConnectedSubAddress >& par_connectedSubAddress,
    const OPTIONAL< User__user__TLV >& par_user__user,
    const OPTIONAL< MobileL3__CommonIE__Types::SS__VersionIndicator >& par_ss__VersionIndicator,
    const OPTIONAL< StreamIdentifier >& par_streamIdentifier)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd),
  field_facility(par_facility),
  field_connectedSubAddress(par_connectedSubAddress),
  field_user__user(par_user__user),
  field_ss__VersionIndicator(par_ss__VersionIndicator),
  field_streamIdentifier(par_streamIdentifier)
{
}

PDU__ML3__Connect__MS__NW::PDU__ML3__Connect__MS__NW(const PDU__ML3__Connect__MS__NW& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
if (other_value.facility().is_bound()) field_facility = other_value.facility();
else field_facility.clean_up();
if (other_value.connectedSubAddress().is_bound()) field_connectedSubAddress = other_value.connectedSubAddress();
else field_connectedSubAddress.clean_up();
if (other_value.user__user().is_bound()) field_user__user = other_value.user__user();
else field_user__user.clean_up();
if (other_value.ss__VersionIndicator().is_bound()) field_ss__VersionIndicator = other_value.ss__VersionIndicator();
else field_ss__VersionIndicator.clean_up();
if (other_value.streamIdentifier().is_bound()) field_streamIdentifier = other_value.streamIdentifier();
else field_streamIdentifier.clean_up();
}

void PDU__ML3__Connect__MS__NW::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
field_facility.clean_up();
field_connectedSubAddress.clean_up();
field_user__user.clean_up();
field_ss__VersionIndicator.clean_up();
field_streamIdentifier.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__Connect__MS__NW::get_descriptor() const { return &PDU__ML3__Connect__MS__NW_descr_; }
PDU__ML3__Connect__MS__NW& PDU__ML3__Connect__MS__NW::operator=(const PDU__ML3__Connect__MS__NW& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
  if (other_value.facility().is_bound()) field_facility = other_value.facility();
  else field_facility.clean_up();
  if (other_value.connectedSubAddress().is_bound()) field_connectedSubAddress = other_value.connectedSubAddress();
  else field_connectedSubAddress.clean_up();
  if (other_value.user__user().is_bound()) field_user__user = other_value.user__user();
  else field_user__user.clean_up();
  if (other_value.ss__VersionIndicator().is_bound()) field_ss__VersionIndicator = other_value.ss__VersionIndicator();
  else field_ss__VersionIndicator.clean_up();
  if (other_value.streamIdentifier().is_bound()) field_streamIdentifier = other_value.streamIdentifier();
  else field_streamIdentifier.clean_up();
}
return *this;
}

boolean PDU__ML3__Connect__MS__NW::operator==(const PDU__ML3__Connect__MS__NW& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd
  && field_facility==other_value.field_facility
  && field_connectedSubAddress==other_value.field_connectedSubAddress
  && field_user__user==other_value.field_user__user
  && field_ss__VersionIndicator==other_value.field_ss__VersionIndicator
  && field_streamIdentifier==other_value.field_streamIdentifier;
}

boolean PDU__ML3__Connect__MS__NW::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound())
  || (OPTIONAL_OMIT == field_facility.get_selection() || field_facility.is_bound())
  || (OPTIONAL_OMIT == field_connectedSubAddress.get_selection() || field_connectedSubAddress.is_bound())
  || (OPTIONAL_OMIT == field_user__user.get_selection() || field_user__user.is_bound())
  || (OPTIONAL_OMIT == field_ss__VersionIndicator.get_selection() || field_ss__VersionIndicator.is_bound())
  || (OPTIONAL_OMIT == field_streamIdentifier.get_selection() || field_streamIdentifier.is_bound());
}
boolean PDU__ML3__Connect__MS__NW::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value()
  && (OPTIONAL_OMIT == field_facility.get_selection() || field_facility.is_value())
  && (OPTIONAL_OMIT == field_connectedSubAddress.get_selection() || field_connectedSubAddress.is_value())
  && (OPTIONAL_OMIT == field_user__user.get_selection() || field_user__user.is_value())
  && (OPTIONAL_OMIT == field_ss__VersionIndicator.get_selection() || field_ss__VersionIndicator.is_value())
  && (OPTIONAL_OMIT == field_streamIdentifier.get_selection() || field_streamIdentifier.is_value());
}
int PDU__ML3__Connect__MS__NW::size_of() const
{
  int ret_val = 2;
  if (field_facility.ispresent()) ret_val++;
  if (field_connectedSubAddress.ispresent()) ret_val++;
  if (field_user__user.ispresent()) ret_val++;
  if (field_ss__VersionIndicator.ispresent()) ret_val++;
  if (field_streamIdentifier.ispresent()) ret_val++;
  return ret_val;
}

void PDU__ML3__Connect__MS__NW::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(", facility := ");
field_facility.log();
TTCN_Logger::log_event_str(", connectedSubAddress := ");
field_connectedSubAddress.log();
TTCN_Logger::log_event_str(", user_user := ");
field_user__user.log();
TTCN_Logger::log_event_str(", ss_VersionIndicator := ");
field_ss__VersionIndicator.log();
TTCN_Logger::log_event_str(", streamIdentifier := ");
field_streamIdentifier.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__Connect__MS__NW::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
if (!facility().is_bound()) facility() = OMIT_VALUE;
else facility().set_implicit_omit();
if (!connectedSubAddress().is_bound()) connectedSubAddress() = OMIT_VALUE;
else connectedSubAddress().set_implicit_omit();
if (!user__user().is_bound()) user__user() = OMIT_VALUE;
else user__user().set_implicit_omit();
if (!ss__VersionIndicator().is_bound()) ss__VersionIndicator() = OMIT_VALUE;
else ss__VersionIndicator().set_implicit_omit();
if (!streamIdentifier().is_bound()) streamIdentifier() = OMIT_VALUE;
else streamIdentifier().set_implicit_omit();
}

void PDU__ML3__Connect__MS__NW::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) facility().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) connectedSubAddress().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) user__user().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) ss__VersionIndicator().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) streamIdentifier().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connectedSubAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connectedSubAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_user")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__user().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_VersionIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__VersionIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "streamIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          streamIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.PDU_ML3_Connect_MS_NW");
  }
}

void PDU__ML3__Connect__MS__NW::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
field_facility.encode_text(text_buf);
field_connectedSubAddress.encode_text(text_buf);
field_user__user.encode_text(text_buf);
field_ss__VersionIndicator.encode_text(text_buf);
field_streamIdentifier.encode_text(text_buf);
}

void PDU__ML3__Connect__MS__NW::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
field_facility.decode_text(text_buf);
field_connectedSubAddress.decode_text(text_buf);
field_user__user.decode_text(text_buf);
field_ss__VersionIndicator.decode_text(text_buf);
field_streamIdentifier.decode_text(text_buf);
}

void PDU__ML3__Connect__MS__NW::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__Connect__MS__NW::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__Connect__MS__NW::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_facility = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, MobileL3__CommonIE__Types::Facility__TLV_descr_.raw->forceomit);
  decoded_field_length = field_facility().RAW_decode(MobileL3__CommonIE__Types::Facility__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_facility = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_facility.ispresent() || field_facility().elementIdentifier() !=  os_0){
  field_facility=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_facility=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_connectedSubAddress = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, ConnectedSubAddress_descr_.raw->forceomit);
  decoded_field_length = field_connectedSubAddress().RAW_decode(ConnectedSubAddress_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_connectedSubAddress = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_connectedSubAddress.ispresent() || field_connectedSubAddress().elementIdentifier() !=  os_10){
  field_connectedSubAddress=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_connectedSubAddress=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_user__user = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, User__user__TLV_descr_.raw->forceomit);
  decoded_field_length = field_user__user().RAW_decode(User__user__TLV_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_user__user = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_user__user.ispresent() || field_user__user().elementIdentifier() !=  os_2){
  field_user__user=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_user__user=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_ss__VersionIndicator = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, MobileL3__CommonIE__Types::SS__VersionIndicator_descr_.raw->forceomit);
  decoded_field_length = field_ss__VersionIndicator().RAW_decode(MobileL3__CommonIE__Types::SS__VersionIndicator_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_ss__VersionIndicator = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_ss__VersionIndicator.ispresent() || field_ss__VersionIndicator().elementIdentifier() !=  os_3){
  field_ss__VersionIndicator=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_ss__VersionIndicator=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_streamIdentifier = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, StreamIdentifier_descr_.raw->forceomit);
  decoded_field_length = field_streamIdentifier().RAW_decode(StreamIdentifier_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_streamIdentifier = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
       if(!field_streamIdentifier.ispresent() || field_streamIdentifier().elementIdentifier() !=  os_7){
  field_streamIdentifier=OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  }
  else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  }
  else field_streamIdentifier=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__Connect__MS__NW::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 7;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(7);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  if (field_facility.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, MobileL3__CommonIE__Types::Facility__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_connectedSubAddress.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, ConnectedSubAddress_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_user__user.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, User__user__TLV_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_ss__VersionIndicator.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, MobileL3__CommonIE__Types::SS__VersionIndicator_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_streamIdentifier.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, StreamIdentifier_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  if (field_facility.ispresent()) {
  encoded_length += field_facility().RAW_encode(MobileL3__CommonIE__Types::Facility__TLV_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_connectedSubAddress.ispresent()) {
  encoded_length += field_connectedSubAddress().RAW_encode(ConnectedSubAddress_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_user__user.ispresent()) {
  encoded_length += field_user__user().RAW_encode(User__user__TLV_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_ss__VersionIndicator.ispresent()) {
  encoded_length += field_ss__VersionIndicator().RAW_encode(MobileL3__CommonIE__Types::SS__VersionIndicator_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_streamIdentifier.ispresent()) {
  encoded_length += field_streamIdentifier().RAW_encode(StreamIdentifier_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_facility.ispresent() && (!field_facility.ispresent() || field_facility().elementIdentifier() !=  os_0)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={2,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_0.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_connectedSubAddress.ispresent() && (!field_connectedSubAddress.ispresent() || field_connectedSubAddress().elementIdentifier() !=  os_10)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={3,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_10.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_user__user.ispresent() && (!field_user__user.ispresent() || field_user__user().elementIdentifier() !=  os_2)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={4,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_2.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_ss__VersionIndicator.ispresent() && (!field_ss__VersionIndicator.ispresent() || field_ss__VersionIndicator().elementIdentifier() !=  os_3)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={5,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_3.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  if (field_streamIdentifier.ispresent() && (!field_streamIdentifier.ispresent() || field_streamIdentifier().elementIdentifier() !=  os_7)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+2;
  int new_pos0[]={6,0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,2,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_7.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__ML3__Connect__MS__NW_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
MobileL3__CommonIE__Types::Facility__TLV_template field_facility;
ConnectedSubAddress_template field_connectedSubAddress;
User__user__TLV_template field_user__user;
MobileL3__CommonIE__Types::SS__VersionIndicator_template field_ss__VersionIndicator;
StreamIdentifier_template field_streamIdentifier;
};

void PDU__ML3__Connect__MS__NW_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
single_value->field_facility = ANY_OR_OMIT;
single_value->field_connectedSubAddress = ANY_OR_OMIT;
single_value->field_user__user = ANY_OR_OMIT;
single_value->field_ss__VersionIndicator = ANY_OR_OMIT;
single_value->field_streamIdentifier = ANY_OR_OMIT;
}
}
}

void PDU__ML3__Connect__MS__NW_template::copy_value(const PDU__ML3__Connect__MS__NW& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
if (other_value.facility().is_bound()) {
  if (other_value.facility().ispresent()) single_value->field_facility = other_value.facility()();
  else single_value->field_facility = OMIT_VALUE;
} else {
  single_value->field_facility.clean_up();
}
if (other_value.connectedSubAddress().is_bound()) {
  if (other_value.connectedSubAddress().ispresent()) single_value->field_connectedSubAddress = other_value.connectedSubAddress()();
  else single_value->field_connectedSubAddress = OMIT_VALUE;
} else {
  single_value->field_connectedSubAddress.clean_up();
}
if (other_value.user__user().is_bound()) {
  if (other_value.user__user().ispresent()) single_value->field_user__user = other_value.user__user()();
  else single_value->field_user__user = OMIT_VALUE;
} else {
  single_value->field_user__user.clean_up();
}
if (other_value.ss__VersionIndicator().is_bound()) {
  if (other_value.ss__VersionIndicator().ispresent()) single_value->field_ss__VersionIndicator = other_value.ss__VersionIndicator()();
  else single_value->field_ss__VersionIndicator = OMIT_VALUE;
} else {
  single_value->field_ss__VersionIndicator.clean_up();
}
if (other_value.streamIdentifier().is_bound()) {
  if (other_value.streamIdentifier().ispresent()) single_value->field_streamIdentifier = other_value.streamIdentifier()();
  else single_value->field_streamIdentifier = OMIT_VALUE;
} else {
  single_value->field_streamIdentifier.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__Connect__MS__NW_template::copy_template(const PDU__ML3__Connect__MS__NW_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.facility().get_selection()) {
single_value->field_facility = other_value.facility();
} else {
single_value->field_facility.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.connectedSubAddress().get_selection()) {
single_value->field_connectedSubAddress = other_value.connectedSubAddress();
} else {
single_value->field_connectedSubAddress.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.user__user().get_selection()) {
single_value->field_user__user = other_value.user__user();
} else {
single_value->field_user__user.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ss__VersionIndicator().get_selection()) {
single_value->field_ss__VersionIndicator = other_value.ss__VersionIndicator();
} else {
single_value->field_ss__VersionIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.streamIdentifier().get_selection()) {
single_value->field_streamIdentifier = other_value.streamIdentifier();
} else {
single_value->field_streamIdentifier.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__Connect__MS__NW_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__Connect__MS__NW_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__Connect__MS__NW_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW.");
break;
}
set_selection(other_value);
}

PDU__ML3__Connect__MS__NW_template::PDU__ML3__Connect__MS__NW_template()
{
}

PDU__ML3__Connect__MS__NW_template::PDU__ML3__Connect__MS__NW_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__Connect__MS__NW_template::PDU__ML3__Connect__MS__NW_template(const PDU__ML3__Connect__MS__NW& other_value)
{
copy_value(other_value);
}

PDU__ML3__Connect__MS__NW_template::PDU__ML3__Connect__MS__NW_template(const OPTIONAL<PDU__ML3__Connect__MS__NW>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__Connect__MS__NW&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW from an unbound optional field.");
}
}

PDU__ML3__Connect__MS__NW_template::PDU__ML3__Connect__MS__NW_template(PDU__ML3__Connect__MS__NW_template* p_precondition, PDU__ML3__Connect__MS__NW_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__Connect__MS__NW_template::PDU__ML3__Connect__MS__NW_template(Dynamic_Match_Interface<PDU__ML3__Connect__MS__NW>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__Connect__MS__NW>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__Connect__MS__NW_template::PDU__ML3__Connect__MS__NW_template(const PDU__ML3__Connect__MS__NW_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__Connect__MS__NW_template::~PDU__ML3__Connect__MS__NW_template()
{
clean_up();
}

PDU__ML3__Connect__MS__NW_template& PDU__ML3__Connect__MS__NW_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__Connect__MS__NW_template& PDU__ML3__Connect__MS__NW_template::operator=(const PDU__ML3__Connect__MS__NW& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__Connect__MS__NW_template& PDU__ML3__Connect__MS__NW_template::operator=(const OPTIONAL<PDU__ML3__Connect__MS__NW>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__Connect__MS__NW&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW.");
}
return *this;
}

PDU__ML3__Connect__MS__NW_template& PDU__ML3__Connect__MS__NW_template::operator=(const PDU__ML3__Connect__MS__NW_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__Connect__MS__NW_template::match(const PDU__ML3__Connect__MS__NW& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
if(!other_value.facility().is_bound()) return FALSE;
if((other_value.facility().ispresent() ? !single_value->field_facility.match((const MobileL3__CommonIE__Types::Facility__TLV&)other_value.facility(), legacy) : !single_value->field_facility.match_omit(legacy)))return FALSE;
if(!other_value.connectedSubAddress().is_bound()) return FALSE;
if((other_value.connectedSubAddress().ispresent() ? !single_value->field_connectedSubAddress.match((const ConnectedSubAddress&)other_value.connectedSubAddress(), legacy) : !single_value->field_connectedSubAddress.match_omit(legacy)))return FALSE;
if(!other_value.user__user().is_bound()) return FALSE;
if((other_value.user__user().ispresent() ? !single_value->field_user__user.match((const User__user__TLV&)other_value.user__user(), legacy) : !single_value->field_user__user.match_omit(legacy)))return FALSE;
if(!other_value.ss__VersionIndicator().is_bound()) return FALSE;
if((other_value.ss__VersionIndicator().ispresent() ? !single_value->field_ss__VersionIndicator.match((const MobileL3__CommonIE__Types::SS__VersionIndicator&)other_value.ss__VersionIndicator(), legacy) : !single_value->field_ss__VersionIndicator.match_omit(legacy)))return FALSE;
if(!other_value.streamIdentifier().is_bound()) return FALSE;
if((other_value.streamIdentifier().ispresent() ? !single_value->field_streamIdentifier.match((const StreamIdentifier&)other_value.streamIdentifier(), legacy) : !single_value->field_streamIdentifier.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW.");
}
return FALSE;
}

boolean PDU__ML3__Connect__MS__NW_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound()
 || (single_value->field_facility.is_omit() || single_value->field_facility.is_bound())
 || (single_value->field_connectedSubAddress.is_omit() || single_value->field_connectedSubAddress.is_bound())
 || (single_value->field_user__user.is_omit() || single_value->field_user__user.is_bound())
 || (single_value->field_ss__VersionIndicator.is_omit() || single_value->field_ss__VersionIndicator.is_bound())
 || (single_value->field_streamIdentifier.is_omit() || single_value->field_streamIdentifier.is_bound());
}

boolean PDU__ML3__Connect__MS__NW_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value()
 && (single_value->field_facility.is_omit() || single_value->field_facility.is_value())
 && (single_value->field_connectedSubAddress.is_omit() || single_value->field_connectedSubAddress.is_value())
 && (single_value->field_user__user.is_omit() || single_value->field_user__user.is_value())
 && (single_value->field_ss__VersionIndicator.is_omit() || single_value->field_ss__VersionIndicator.is_value())
 && (single_value->field_streamIdentifier.is_omit() || single_value->field_streamIdentifier.is_value());
}

void PDU__ML3__Connect__MS__NW_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__Connect__MS__NW PDU__ML3__Connect__MS__NW_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW.");
PDU__ML3__Connect__MS__NW ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
if (single_value->field_facility.is_omit()) ret_val.facility() = OMIT_VALUE;
else if (single_value->field_facility.is_bound()) {
ret_val.facility() = single_value->field_facility.valueof();
}
if (single_value->field_connectedSubAddress.is_omit()) ret_val.connectedSubAddress() = OMIT_VALUE;
else if (single_value->field_connectedSubAddress.is_bound()) {
ret_val.connectedSubAddress() = single_value->field_connectedSubAddress.valueof();
}
if (single_value->field_user__user.is_omit()) ret_val.user__user() = OMIT_VALUE;
else if (single_value->field_user__user.is_bound()) {
ret_val.user__user() = single_value->field_user__user.valueof();
}
if (single_value->field_ss__VersionIndicator.is_omit()) ret_val.ss__VersionIndicator() = OMIT_VALUE;
else if (single_value->field_ss__VersionIndicator.is_bound()) {
ret_val.ss__VersionIndicator() = single_value->field_ss__VersionIndicator.valueof();
}
if (single_value->field_streamIdentifier.is_omit()) ret_val.streamIdentifier() = OMIT_VALUE;
else if (single_value->field_streamIdentifier.is_bound()) {
ret_val.streamIdentifier() = single_value->field_streamIdentifier.valueof();
}
return ret_val;
}

void PDU__ML3__Connect__MS__NW_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__Connect__MS__NW_template[list_length];
}

PDU__ML3__Connect__MS__NW_template& PDU__ML3__Connect__MS__NW_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__Connect__MS__NW_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__Connect__MS__NW_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__Connect__MS__NW_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__Connect__MS__NW_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW.");
return single_value->field_nsd;
}

MobileL3__CommonIE__Types::Facility__TLV_template& PDU__ML3__Connect__MS__NW_template::facility()
{
set_specific();
return single_value->field_facility;
}

const MobileL3__CommonIE__Types::Facility__TLV_template& PDU__ML3__Connect__MS__NW_template::facility() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field facility of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW.");
return single_value->field_facility;
}

ConnectedSubAddress_template& PDU__ML3__Connect__MS__NW_template::connectedSubAddress()
{
set_specific();
return single_value->field_connectedSubAddress;
}

const ConnectedSubAddress_template& PDU__ML3__Connect__MS__NW_template::connectedSubAddress() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field connectedSubAddress of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW.");
return single_value->field_connectedSubAddress;
}

User__user__TLV_template& PDU__ML3__Connect__MS__NW_template::user__user()
{
set_specific();
return single_value->field_user__user;
}

const User__user__TLV_template& PDU__ML3__Connect__MS__NW_template::user__user() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field user_user of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW.");
return single_value->field_user__user;
}

MobileL3__CommonIE__Types::SS__VersionIndicator_template& PDU__ML3__Connect__MS__NW_template::ss__VersionIndicator()
{
set_specific();
return single_value->field_ss__VersionIndicator;
}

const MobileL3__CommonIE__Types::SS__VersionIndicator_template& PDU__ML3__Connect__MS__NW_template::ss__VersionIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ss_VersionIndicator of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW.");
return single_value->field_ss__VersionIndicator;
}

StreamIdentifier_template& PDU__ML3__Connect__MS__NW_template::streamIdentifier()
{
set_specific();
return single_value->field_streamIdentifier;
}

const StreamIdentifier_template& PDU__ML3__Connect__MS__NW_template::streamIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field streamIdentifier of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW.");
return single_value->field_streamIdentifier;
}

int PDU__ML3__Connect__MS__NW_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_facility.is_present()) ret_val++;
      if (single_value->field_connectedSubAddress.is_present()) ret_val++;
      if (single_value->field_user__user.is_present()) ret_val++;
      if (single_value->field_ss__VersionIndicator.is_present()) ret_val++;
      if (single_value->field_streamIdentifier.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW.");
  }
  return 0;
}

void PDU__ML3__Connect__MS__NW_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(", facility := ");
single_value->field_facility.log();
TTCN_Logger::log_event_str(", connectedSubAddress := ");
single_value->field_connectedSubAddress.log();
TTCN_Logger::log_event_str(", user_user := ");
single_value->field_user__user.log();
TTCN_Logger::log_event_str(", ss_VersionIndicator := ");
single_value->field_ss__VersionIndicator.log();
TTCN_Logger::log_event_str(", streamIdentifier := ");
single_value->field_streamIdentifier.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__Connect__MS__NW_template::log_match(const PDU__ML3__Connect__MS__NW& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.facility().ispresent()){
if(!single_value->field_facility.match(match_value.facility(), legacy)){
TTCN_Logger::log_logmatch_info(".facility");
single_value->field_facility.log_match(match_value.facility(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_facility.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".facility := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_facility.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.connectedSubAddress().ispresent()){
if(!single_value->field_connectedSubAddress.match(match_value.connectedSubAddress(), legacy)){
TTCN_Logger::log_logmatch_info(".connectedSubAddress");
single_value->field_connectedSubAddress.log_match(match_value.connectedSubAddress(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_connectedSubAddress.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".connectedSubAddress := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_connectedSubAddress.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.user__user().ispresent()){
if(!single_value->field_user__user.match(match_value.user__user(), legacy)){
TTCN_Logger::log_logmatch_info(".user_user");
single_value->field_user__user.log_match(match_value.user__user(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_user__user.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".user_user := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_user__user.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.ss__VersionIndicator().ispresent()){
if(!single_value->field_ss__VersionIndicator.match(match_value.ss__VersionIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".ss_VersionIndicator");
single_value->field_ss__VersionIndicator.log_match(match_value.ss__VersionIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ss__VersionIndicator.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ss_VersionIndicator := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ss__VersionIndicator.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.streamIdentifier().ispresent()){
if(!single_value->field_streamIdentifier.match(match_value.streamIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".streamIdentifier");
single_value->field_streamIdentifier.log_match(match_value.streamIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_streamIdentifier.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".streamIdentifier := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_streamIdentifier.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(", facility := ");
if (match_value.facility().ispresent()) {
single_value->field_facility.log_match(match_value.facility(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_facility.log();
if (single_value->field_facility.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", connectedSubAddress := ");
if (match_value.connectedSubAddress().ispresent()) {
single_value->field_connectedSubAddress.log_match(match_value.connectedSubAddress(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_connectedSubAddress.log();
if (single_value->field_connectedSubAddress.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", user_user := ");
if (match_value.user__user().ispresent()) {
single_value->field_user__user.log_match(match_value.user__user(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_user__user.log();
if (single_value->field_user__user.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", ss_VersionIndicator := ");
if (match_value.ss__VersionIndicator().ispresent()) {
single_value->field_ss__VersionIndicator.log_match(match_value.ss__VersionIndicator(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ss__VersionIndicator.log();
if (single_value->field_ss__VersionIndicator.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", streamIdentifier := ");
if (match_value.streamIdentifier().ispresent()) {
single_value->field_streamIdentifier.log_match(match_value.streamIdentifier(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_streamIdentifier.log();
if (single_value->field_streamIdentifier.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__Connect__MS__NW_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
single_value->field_facility.encode_text(text_buf);
single_value->field_connectedSubAddress.encode_text(text_buf);
single_value->field_user__user.encode_text(text_buf);
single_value->field_ss__VersionIndicator.encode_text(text_buf);
single_value->field_streamIdentifier.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW.");
}
}

void PDU__ML3__Connect__MS__NW_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
single_value->field_facility.decode_text(text_buf);
single_value->field_connectedSubAddress.decode_text(text_buf);
single_value->field_user__user.decode_text(text_buf);
single_value->field_ss__VersionIndicator.decode_text(text_buf);
single_value->field_streamIdentifier.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__Connect__MS__NW_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW.");
}
}

void PDU__ML3__Connect__MS__NW_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__Connect__MS__NW_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) facility().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) connectedSubAddress().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) user__user().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) ss__VersionIndicator().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) streamIdentifier().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facility")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facility().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "connectedSubAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          connectedSubAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "user_user")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          user__user().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ss_VersionIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ss__VersionIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "streamIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          streamIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_Connect_MS_NW: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__Connect__MS__NW_template* precondition = new PDU__ML3__Connect__MS__NW_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__Connect__MS__NW_template* implied_template = new PDU__ML3__Connect__MS__NW_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__Connect__MS__NW_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.PDU_ML3_Connect_MS_NW");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__Connect__MS__NW_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Connect_MS_NW");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Connect_MS_NW");
single_value->field_facility.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Connect_MS_NW");
single_value->field_connectedSubAddress.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Connect_MS_NW");
single_value->field_user__user.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Connect_MS_NW");
single_value->field_ss__VersionIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Connect_MS_NW");
single_value->field_streamIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Connect_MS_NW");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_Connect_MS_NW");
}

boolean PDU__ML3__Connect__MS__NW_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__Connect__MS__NW_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__ML3__ConnectAck::PDU__ML3__ConnectAck()
{
}

PDU__ML3__ConnectAck::PDU__ML3__ConnectAck(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd)
{
}

PDU__ML3__ConnectAck::PDU__ML3__ConnectAck(const PDU__ML3__ConnectAck& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.PDU_ML3_ConnectAck.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
}

void PDU__ML3__ConnectAck::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__ConnectAck::get_descriptor() const { return &PDU__ML3__ConnectAck_descr_; }
PDU__ML3__ConnectAck& PDU__ML3__ConnectAck::operator=(const PDU__ML3__ConnectAck& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.PDU_ML3_ConnectAck.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
}
return *this;
}

boolean PDU__ML3__ConnectAck::operator==(const PDU__ML3__ConnectAck& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd;
}

boolean PDU__ML3__ConnectAck::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound());
}
boolean PDU__ML3__ConnectAck::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value();
}
void PDU__ML3__ConnectAck::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
field_nsd.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__ML3__ConnectAck::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (nsd().is_bound()) nsd().set_implicit_omit();
}

void PDU__ML3__ConnectAck::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_CC_Types.PDU_ML3_ConnectAck has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_ConnectAck: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_CC_Types.PDU_ML3_ConnectAck");
  }
}

void PDU__ML3__ConnectAck::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_nsd.encode_text(text_buf);
}

void PDU__ML3__ConnectAck::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_nsd.decode_text(text_buf);
}

void PDU__ML3__ConnectAck::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__ML3__ConnectAck::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__ML3__ConnectAck::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_nsd.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__ML3__ConnectAck::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT6_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_nsd.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct PDU__ML3__ConnectAck_template::single_value_struct {
BITSTRING_template field_messageType;
BITSTRING_template field_nsd;
};

void PDU__ML3__ConnectAck_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_nsd = ANY_VALUE;
}
}
}

void PDU__ML3__ConnectAck_template::copy_value(const PDU__ML3__ConnectAck& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.nsd().is_bound()) {
  single_value->field_nsd = other_value.nsd();
} else {
  single_value->field_nsd.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__ML3__ConnectAck_template::copy_template(const PDU__ML3__ConnectAck_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsd().get_selection()) {
single_value->field_nsd = other_value.nsd();
} else {
single_value->field_nsd.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__ML3__ConnectAck_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__ML3__ConnectAck_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__ML3__ConnectAck_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck.");
break;
}
set_selection(other_value);
}

PDU__ML3__ConnectAck_template::PDU__ML3__ConnectAck_template()
{
}

PDU__ML3__ConnectAck_template::PDU__ML3__ConnectAck_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__ML3__ConnectAck_template::PDU__ML3__ConnectAck_template(const PDU__ML3__ConnectAck& other_value)
{
copy_value(other_value);
}

PDU__ML3__ConnectAck_template::PDU__ML3__ConnectAck_template(const OPTIONAL<PDU__ML3__ConnectAck>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__ConnectAck&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck from an unbound optional field.");
}
}

PDU__ML3__ConnectAck_template::PDU__ML3__ConnectAck_template(PDU__ML3__ConnectAck_template* p_precondition, PDU__ML3__ConnectAck_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__ML3__ConnectAck_template::PDU__ML3__ConnectAck_template(Dynamic_Match_Interface<PDU__ML3__ConnectAck>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__ML3__ConnectAck>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__ML3__ConnectAck_template::PDU__ML3__ConnectAck_template(const PDU__ML3__ConnectAck_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__ML3__ConnectAck_template::~PDU__ML3__ConnectAck_template()
{
clean_up();
}

PDU__ML3__ConnectAck_template& PDU__ML3__ConnectAck_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__ML3__ConnectAck_template& PDU__ML3__ConnectAck_template::operator=(const PDU__ML3__ConnectAck& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__ML3__ConnectAck_template& PDU__ML3__ConnectAck_template::operator=(const OPTIONAL<PDU__ML3__ConnectAck>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__ML3__ConnectAck&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck.");
}
return *this;
}

PDU__ML3__ConnectAck_template& PDU__ML3__ConnectAck_template::operator=(const PDU__ML3__ConnectAck_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__ML3__ConnectAck_template::match(const PDU__ML3__ConnectAck& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.nsd().is_bound()) return FALSE;
if(!single_value->field_nsd.match(other_value.nsd(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck.");
}
return FALSE;
}

boolean PDU__ML3__ConnectAck_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_nsd.is_bound();
}

boolean PDU__ML3__ConnectAck_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_nsd.is_value();
}

void PDU__ML3__ConnectAck_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__ML3__ConnectAck PDU__ML3__ConnectAck_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck.");
PDU__ML3__ConnectAck ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_nsd.is_bound()) {
ret_val.nsd() = single_value->field_nsd.valueof();
}
return ret_val;
}

void PDU__ML3__ConnectAck_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__ML3__ConnectAck_template[list_length];
}

PDU__ML3__ConnectAck_template& PDU__ML3__ConnectAck_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__ML3__ConnectAck_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const BITSTRING_template& PDU__ML3__ConnectAck_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck.");
return single_value->field_messageType;
}

BITSTRING_template& PDU__ML3__ConnectAck_template::nsd()
{
set_specific();
return single_value->field_nsd;
}

const BITSTRING_template& PDU__ML3__ConnectAck_template::nsd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsd of a non-specific template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck.");
return single_value->field_nsd;
}

int PDU__ML3__ConnectAck_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck.");
  }
  return 0;
}

void PDU__ML3__ConnectAck_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__ML3__ConnectAck_template::log_match(const PDU__ML3__ConnectAck& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nsd.match(match_value.nsd(), legacy)){
TTCN_Logger::log_logmatch_info(".nsd");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", nsd := ");
single_value->field_nsd.log_match(match_value.nsd(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__ML3__ConnectAck_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_nsd.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck.");
}
}

void PDU__ML3__ConnectAck_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_nsd.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__ML3__ConnectAck_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck.");
}
}

void PDU__ML3__ConnectAck_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__ML3__ConnectAck_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_CC_Types.PDU_ML3_ConnectAck has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) nsd().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_CC_Types.PDU_ML3_ConnectAck: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__ML3__ConnectAck_template* precondition = new PDU__ML3__ConnectAck_template;
    precondition->set_param(*param.get_elem(0));
    PDU__ML3__ConnectAck_template* implied_template = new PDU__ML3__ConnectAck_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__ML3__ConnectAck_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_CC_Types.PDU_ML3_ConnectAck");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__ML3__ConnectAck_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_ConnectAck");
single_value->field_nsd.check_restriction(t_res, t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_ConnectAck");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_CC_Types.PDU_ML3_ConnectAck");
}

boolean PDU__ML3__ConnectAck_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__ML3__ConnectAck_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__ML3__Disconnect__NW__MS::PDU__ML3__Disconnect__NW__MS()
{
}

PDU__ML3__Disconnect__NW__MS::PDU__ML3__Disconnect__NW__MS(const BITSTRING& par_messageType,
    const BITSTRING& par_nsd,
    const MobileL3__CommonIE__Types::ML3__Cause__LV& par_cause,
    const OPTIONAL< MobileL3__CommonIE__Types::Facility__TLV >& par_facility,
    const OPTIONAL< ProgressIndicator__TLV >& par_progressIndicator,
    const OPTIONAL< User__user__TLV >& par_user__user,
    const OPTIONAL< AllowedActions >& par_allowedActions)
  :   field_messageType(par_messageType),
  field_nsd(par_nsd),
  field_cause(par_cause),
  field_facility(par_facility),
  field_progressIndicator(par_progressIndicator),
  field_user__user(par_user__user),
  field_allowedActions(par_allowedActions)
{
}

PDU__ML3__Disconnect__NW__MS::PDU__ML3__Disconnect__NW__MS(const PDU__ML3__Disconnect__NW__MS& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_CC_Types.PDU_ML3_Disconnect_NW_MS.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
else field_nsd.clean_up();
if (other_value.cause().is_bound()) field_cause = other_value.cause();
else field_cause.clean_up();
if (other_value.facility().is_bound()) field_facility = other_value.facility();
else field_facility.clean_up();
if (other_value.progressIndicator().is_bound()) field_progressIndicator = other_value.progressIndicator();
else field_progressIndicator.clean_up();
if (other_value.user__user().is_bound()) field_user__user = other_value.user__user();
else field_user__user.clean_up();
if (other_value.allowedActions().is_bound()) field_allowedActions = other_value.allowedActions();
else field_allowedActions.clean_up();
}

void PDU__ML3__Disconnect__NW__MS::clean_up()
{
field_messageType.clean_up();
field_nsd.clean_up();
field_cause.clean_up();
field_facility.clean_up();
field_progressIndicator.clean_up();
field_user__user.clean_up();
field_allowedActions.clean_up();
}

const TTCN_Typedescriptor_t* PDU__ML3__Disconnect__NW__MS::get_descriptor() const { return &PDU__ML3__Disconnect__NW__MS_descr_; }
PDU__ML3__Disconnect__NW__MS& PDU__ML3__Disconnect__NW__MS::operator=(const PDU__ML3__Disconnect__NW__MS& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_CC_Types.PDU_ML3_Disconnect_NW_MS.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.nsd().is_bound()) field_nsd = other_value.nsd();
  else field_nsd.clean_up();
  if (other_value.cause().is_bound()) field_cause = other_value.cause();
  else field_cause.clean_up();
  if (other_value.facility().is_bound()) field_facility = other_value.facility();
  else field_facility.clean_up();
  if (other_value.progressIndicator().is_bound()) field_progressIndicator = other_value.progressIndicator();
  else field_progressIndicator.clean_up();
  if (other_value.user__user().is_bound()) field_user__user = other_value.user__user();
  else field_user__user.clean_up();
  if (other_value.allowedActions().is_bound()) field_allowedActions = other_value.allowedActions();
  else field_allowedActions.clean_up();
}
return *this;
}

boolean PDU__ML3__Disconnect__NW__MS::operator==(const PDU__ML3__Disconnect__NW__MS& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_nsd==other_value.field_nsd
  && field_cause==other_value.field_cause
  && field_facility==other_value.field_facility
  && field_progressIndicator==other_value.field_progressIndicator
  && field_user__user==other_value.field_user__user
  && field_allowedActions==other_value.field_allowedActions;
}

boolean PDU__ML3__Disconnect__NW__MS::is_bound() const
{
return (field_messageType.is_bound())
  || (field_nsd.is_bound())
  || (field_cause.is_bound())
  || (OPTIONAL_OMIT == field_facility.get_selection() || field_facility.is_bound())
  || (OPTIONAL_OMIT == field_progressIndicator.get_selection() || field_progressIndicator.is_bound())
  || (OPTIONAL_OMIT == field_user__user.get_selection() || field_user__user.is_bound())
  || (OPTIONAL_OMIT == field_allowedActions.get_selection() || field_allowedActions.is_bound());
}
boolean PDU__ML3__Disconnect__NW__MS::is_value() const
{
return field_messageType.is_value()
  && field_nsd.is_value()
  && field_cause.is_value()
  && (OPTIONAL_OMIT == field_facility.get_selection() || field_facility.is_value())
  && (OPTIONAL_OMIT == field_progressIndicator.get_selection() || field_progressIndicator.is_value())
  && (OPTIONAL_OMIT == field_user__user.get_selection() || field_user__user.is_value())
  && (OPTIONAL_OMIT == field_allowedActions.get_selection() || field_allowedActions.is_value());
}
int PDU__ML3__Disconnect__NW__MS::size_of() const
{
  int ret_val = 3;
  if (field_facility.ispresent