// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 9.0.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2023 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "MobileL3_GMM_SM_Types.hh"

namespace MobileL3__GMM__SM__Types {

/* Member functions of C++ classes */

NSAPIV::NSAPIV()
{
}

NSAPIV::NSAPIV(const BITSTRING& par_valueField,
    const BITSTRING& par_spare)
  :   field_valueField(par_valueField),
  field_spare(par_spare)
{
}

NSAPIV::NSAPIV(const NSAPIV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.NSAPIV.");
if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
else field_valueField.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void NSAPIV::clean_up()
{
field_valueField.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* NSAPIV::get_descriptor() const { return &NSAPIV_descr_; }
NSAPIV& NSAPIV::operator=(const NSAPIV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.NSAPIV.");
  if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
  else field_valueField.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean NSAPIV::operator==(const NSAPIV& other_value) const
{
return field_valueField==other_value.field_valueField
  && field_spare==other_value.field_spare;
}

boolean NSAPIV::is_bound() const
{
return (field_valueField.is_bound())
  || (field_spare.is_bound());
}
boolean NSAPIV::is_value() const
{
return field_valueField.is_value()
  && field_spare.is_value();
}
void NSAPIV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ valueField := ");
field_valueField.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void NSAPIV::set_implicit_omit()
{
if (valueField().is_bound()) valueField().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void NSAPIV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.NSAPIV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.NSAPIV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.NSAPIV");
  }
}

void NSAPIV::encode_text(Text_Buf& text_buf) const
{
field_valueField.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void NSAPIV::decode_text(Text_Buf& text_buf)
{
field_valueField.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void NSAPIV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void NSAPIV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int NSAPIV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_valueField.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int NSAPIV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT4_descr_.raw);
  encoded_length += field_valueField.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct NSAPIV_template::single_value_struct {
BITSTRING_template field_valueField;
BITSTRING_template field_spare;
};

void NSAPIV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_valueField = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void NSAPIV_template::copy_value(const NSAPIV& other_value)
{
single_value = new single_value_struct;
if (other_value.valueField().is_bound()) {
  single_value->field_valueField = other_value.valueField();
} else {
  single_value->field_valueField.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void NSAPIV_template::copy_template(const NSAPIV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.valueField().get_selection()) {
single_value->field_valueField = other_value.valueField();
} else {
single_value->field_valueField.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new NSAPIV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new NSAPIV_template(*other_value.implication_.precondition);
implication_.implied_template = new NSAPIV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.NSAPIV.");
break;
}
set_selection(other_value);
}

NSAPIV_template::NSAPIV_template()
{
}

NSAPIV_template::NSAPIV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

NSAPIV_template::NSAPIV_template(const NSAPIV& other_value)
{
copy_value(other_value);
}

NSAPIV_template::NSAPIV_template(const OPTIONAL<NSAPIV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NSAPIV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.NSAPIV from an unbound optional field.");
}
}

NSAPIV_template::NSAPIV_template(NSAPIV_template* p_precondition, NSAPIV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

NSAPIV_template::NSAPIV_template(Dynamic_Match_Interface<NSAPIV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<NSAPIV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

NSAPIV_template::NSAPIV_template(const NSAPIV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

NSAPIV_template::~NSAPIV_template()
{
clean_up();
}

NSAPIV_template& NSAPIV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

NSAPIV_template& NSAPIV_template::operator=(const NSAPIV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

NSAPIV_template& NSAPIV_template::operator=(const OPTIONAL<NSAPIV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NSAPIV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.NSAPIV.");
}
return *this;
}

NSAPIV_template& NSAPIV_template::operator=(const NSAPIV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean NSAPIV_template::match(const NSAPIV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.valueField().is_bound()) return FALSE;
if(!single_value->field_valueField.match(other_value.valueField(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.NSAPIV.");
}
return FALSE;
}

boolean NSAPIV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_valueField.is_bound()
 || single_value->field_spare.is_bound();
}

boolean NSAPIV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_valueField.is_value()
 && single_value->field_spare.is_value();
}

void NSAPIV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

NSAPIV NSAPIV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.NSAPIV.");
NSAPIV ret_val;
if (single_value->field_valueField.is_bound()) {
ret_val.valueField() = single_value->field_valueField.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void NSAPIV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.NSAPIV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new NSAPIV_template[list_length];
}

NSAPIV_template& NSAPIV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.NSAPIV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.NSAPIV.");
return value_list.list_value[list_index];
}

BITSTRING_template& NSAPIV_template::valueField()
{
set_specific();
return single_value->field_valueField;
}

const BITSTRING_template& NSAPIV_template::valueField() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field valueField of a non-specific template of type @MobileL3_GMM_SM_Types.NSAPIV.");
return single_value->field_valueField;
}

BITSTRING_template& NSAPIV_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& NSAPIV_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @MobileL3_GMM_SM_Types.NSAPIV.");
return single_value->field_spare;
}

int NSAPIV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.NSAPIV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.NSAPIV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.NSAPIV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.NSAPIV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.NSAPIV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.NSAPIV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.NSAPIV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.NSAPIV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.NSAPIV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.NSAPIV.");
  }
  return 0;
}

void NSAPIV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ valueField := ");
single_value->field_valueField.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void NSAPIV_template::log_match(const NSAPIV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_valueField.match(match_value.valueField(), legacy)){
TTCN_Logger::log_logmatch_info(".valueField");
single_value->field_valueField.log_match(match_value.valueField(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ valueField := ");
single_value->field_valueField.log_match(match_value.valueField(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void NSAPIV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_valueField.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.NSAPIV.");
}
}

void NSAPIV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_valueField.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new NSAPIV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.NSAPIV.");
}
}

void NSAPIV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    NSAPIV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.NSAPIV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.NSAPIV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    NSAPIV_template* precondition = new NSAPIV_template;
    precondition->set_param(*param.get_elem(0));
    NSAPIV_template* implied_template = new NSAPIV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = NSAPIV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.NSAPIV");
  }
  is_ifpresent = param.get_ifpresent();
}

void NSAPIV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_valueField.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.NSAPIV");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.NSAPIV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.NSAPIV");
}

boolean NSAPIV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean NSAPIV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

NSAPITV::NSAPITV()
{
}

NSAPITV::NSAPITV(const OCTETSTRING& par_elementIdentifier,
    const NSAPIV& par_valueField)
  :   field_elementIdentifier(par_elementIdentifier),
  field_valueField(par_valueField)
{
}

NSAPITV::NSAPITV(const NSAPITV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.NSAPITV.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
else field_valueField.clean_up();
}

void NSAPITV::clean_up()
{
field_elementIdentifier.clean_up();
field_valueField.clean_up();
}

const TTCN_Typedescriptor_t* NSAPITV::get_descriptor() const { return &NSAPITV_descr_; }
NSAPITV& NSAPITV::operator=(const NSAPITV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.NSAPITV.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
  else field_valueField.clean_up();
}
return *this;
}

boolean NSAPITV::operator==(const NSAPITV& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_valueField==other_value.field_valueField;
}

boolean NSAPITV::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_valueField.is_bound());
}
boolean NSAPITV::is_value() const
{
return field_elementIdentifier.is_value()
  && field_valueField.is_value();
}
void NSAPITV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", valueField := ");
field_valueField.log();
TTCN_Logger::log_event_str(" }");
}

void NSAPITV::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (valueField().is_bound()) valueField().set_implicit_omit();
}

void NSAPITV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.NSAPITV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.NSAPITV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.NSAPITV");
  }
}

void NSAPITV::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_valueField.encode_text(text_buf);
}

void NSAPITV::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_valueField.decode_text(text_buf);
}

void NSAPITV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void NSAPITV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int NSAPITV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, NSAPIV_descr_.raw->forceomit);
  decoded_field_length = field_valueField.RAW_decode(NSAPIV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int NSAPITV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, NSAPIV_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_valueField.RAW_encode(NSAPIV_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct NSAPITV_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
NSAPIV_template field_valueField;
};

void NSAPITV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_valueField = ANY_VALUE;
}
}
}

void NSAPITV_template::copy_value(const NSAPITV& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.valueField().is_bound()) {
  single_value->field_valueField = other_value.valueField();
} else {
  single_value->field_valueField.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void NSAPITV_template::copy_template(const NSAPITV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.valueField().get_selection()) {
single_value->field_valueField = other_value.valueField();
} else {
single_value->field_valueField.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new NSAPITV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new NSAPITV_template(*other_value.implication_.precondition);
implication_.implied_template = new NSAPITV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.NSAPITV.");
break;
}
set_selection(other_value);
}

NSAPITV_template::NSAPITV_template()
{
}

NSAPITV_template::NSAPITV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

NSAPITV_template::NSAPITV_template(const NSAPITV& other_value)
{
copy_value(other_value);
}

NSAPITV_template::NSAPITV_template(const OPTIONAL<NSAPITV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NSAPITV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.NSAPITV from an unbound optional field.");
}
}

NSAPITV_template::NSAPITV_template(NSAPITV_template* p_precondition, NSAPITV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

NSAPITV_template::NSAPITV_template(Dynamic_Match_Interface<NSAPITV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<NSAPITV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

NSAPITV_template::NSAPITV_template(const NSAPITV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

NSAPITV_template::~NSAPITV_template()
{
clean_up();
}

NSAPITV_template& NSAPITV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

NSAPITV_template& NSAPITV_template::operator=(const NSAPITV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

NSAPITV_template& NSAPITV_template::operator=(const OPTIONAL<NSAPITV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const NSAPITV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.NSAPITV.");
}
return *this;
}

NSAPITV_template& NSAPITV_template::operator=(const NSAPITV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean NSAPITV_template::match(const NSAPITV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.valueField().is_bound()) return FALSE;
if(!single_value->field_valueField.match(other_value.valueField(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.NSAPITV.");
}
return FALSE;
}

boolean NSAPITV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_valueField.is_bound();
}

boolean NSAPITV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_valueField.is_value();
}

void NSAPITV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

NSAPITV NSAPITV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.NSAPITV.");
NSAPITV ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_valueField.is_bound()) {
ret_val.valueField() = single_value->field_valueField.valueof();
}
return ret_val;
}

void NSAPITV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.NSAPITV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new NSAPITV_template[list_length];
}

NSAPITV_template& NSAPITV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.NSAPITV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.NSAPITV.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& NSAPITV_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& NSAPITV_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_GMM_SM_Types.NSAPITV.");
return single_value->field_elementIdentifier;
}

NSAPIV_template& NSAPITV_template::valueField()
{
set_specific();
return single_value->field_valueField;
}

const NSAPIV_template& NSAPITV_template::valueField() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field valueField of a non-specific template of type @MobileL3_GMM_SM_Types.NSAPITV.");
return single_value->field_valueField;
}

int NSAPITV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.NSAPITV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.NSAPITV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.NSAPITV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.NSAPITV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.NSAPITV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.NSAPITV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.NSAPITV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.NSAPITV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.NSAPITV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.NSAPITV.");
  }
  return 0;
}

void NSAPITV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", valueField := ");
single_value->field_valueField.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void NSAPITV_template::log_match(const NSAPITV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_valueField.match(match_value.valueField(), legacy)){
TTCN_Logger::log_logmatch_info(".valueField");
single_value->field_valueField.log_match(match_value.valueField(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", valueField := ");
single_value->field_valueField.log_match(match_value.valueField(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void NSAPITV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_valueField.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.NSAPITV.");
}
}

void NSAPITV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_valueField.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new NSAPITV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.NSAPITV.");
}
}

void NSAPITV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    NSAPITV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.NSAPITV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.NSAPITV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    NSAPITV_template* precondition = new NSAPITV_template;
    precondition->set_param(*param.get_elem(0));
    NSAPITV_template* implied_template = new NSAPITV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = NSAPITV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.NSAPITV");
  }
  is_ifpresent = param.get_ifpresent();
}

void NSAPITV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.NSAPITV");
single_value->field_valueField.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.NSAPITV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.NSAPITV");
}

boolean NSAPITV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean NSAPITV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ProtocolConfigOptionsV::ProtocolConfigOptionsV()
{
}

ProtocolConfigOptionsV::ProtocolConfigOptionsV(const BITSTRING& par_configProtocol,
    const BITSTRING& par_spare,
    const BITSTRING& par_extensionField,
    const OPTIONAL< ProtocolIDs__and__ContainerIDs >& par_protocolIDs__and__ContainerIDs)
  :   field_configProtocol(par_configProtocol),
  field_spare(par_spare),
  field_extensionField(par_extensionField),
  field_protocolIDs__and__ContainerIDs(par_protocolIDs__and__ContainerIDs)
{
}

ProtocolConfigOptionsV::ProtocolConfigOptionsV(const ProtocolConfigOptionsV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV.");
if (other_value.configProtocol().is_bound()) field_configProtocol = other_value.configProtocol();
else field_configProtocol.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.extensionField().is_bound()) field_extensionField = other_value.extensionField();
else field_extensionField.clean_up();
if (other_value.protocolIDs__and__ContainerIDs().is_bound()) field_protocolIDs__and__ContainerIDs = other_value.protocolIDs__and__ContainerIDs();
else field_protocolIDs__and__ContainerIDs.clean_up();
}

void ProtocolConfigOptionsV::clean_up()
{
field_configProtocol.clean_up();
field_spare.clean_up();
field_extensionField.clean_up();
field_protocolIDs__and__ContainerIDs.clean_up();
}

const TTCN_Typedescriptor_t* ProtocolConfigOptionsV::get_descriptor() const { return &ProtocolConfigOptionsV_descr_; }
ProtocolConfigOptionsV& ProtocolConfigOptionsV::operator=(const ProtocolConfigOptionsV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV.");
  if (other_value.configProtocol().is_bound()) field_configProtocol = other_value.configProtocol();
  else field_configProtocol.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.extensionField().is_bound()) field_extensionField = other_value.extensionField();
  else field_extensionField.clean_up();
  if (other_value.protocolIDs__and__ContainerIDs().is_bound()) field_protocolIDs__and__ContainerIDs = other_value.protocolIDs__and__ContainerIDs();
  else field_protocolIDs__and__ContainerIDs.clean_up();
}
return *this;
}

boolean ProtocolConfigOptionsV::operator==(const ProtocolConfigOptionsV& other_value) const
{
return field_configProtocol==other_value.field_configProtocol
  && field_spare==other_value.field_spare
  && field_extensionField==other_value.field_extensionField
  && field_protocolIDs__and__ContainerIDs==other_value.field_protocolIDs__and__ContainerIDs;
}

boolean ProtocolConfigOptionsV::is_bound() const
{
return (field_configProtocol.is_bound())
  || (field_spare.is_bound())
  || (field_extensionField.is_bound())
  || (OPTIONAL_OMIT == field_protocolIDs__and__ContainerIDs.get_selection() || field_protocolIDs__and__ContainerIDs.is_bound());
}
boolean ProtocolConfigOptionsV::is_value() const
{
return field_configProtocol.is_value()
  && field_spare.is_value()
  && field_extensionField.is_value()
  && (OPTIONAL_OMIT == field_protocolIDs__and__ContainerIDs.get_selection() || field_protocolIDs__and__ContainerIDs.is_value());
}
int ProtocolConfigOptionsV::size_of() const
{
  int ret_val = 3;
  if (field_protocolIDs__and__ContainerIDs.ispresent()) ret_val++;
  return ret_val;
}

void ProtocolConfigOptionsV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ configProtocol := ");
field_configProtocol.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", extensionField := ");
field_extensionField.log();
TTCN_Logger::log_event_str(", protocolIDs_and_ContainerIDs := ");
field_protocolIDs__and__ContainerIDs.log();
TTCN_Logger::log_event_str(" }");
}

void ProtocolConfigOptionsV::set_implicit_omit()
{
if (configProtocol().is_bound()) configProtocol().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (extensionField().is_bound()) extensionField().set_implicit_omit();
if (!protocolIDs__and__ContainerIDs().is_bound()) protocolIDs__and__ContainerIDs() = OMIT_VALUE;
else protocolIDs__and__ContainerIDs().set_implicit_omit();
}

void ProtocolConfigOptionsV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) configProtocol().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionField().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) protocolIDs__and__ContainerIDs().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "configProtocol")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          configProtocol().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolIDs_and_ContainerIDs")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolIDs__and__ContainerIDs().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.ProtocolConfigOptionsV");
  }
}

void ProtocolConfigOptionsV::encode_text(Text_Buf& text_buf) const
{
field_configProtocol.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_extensionField.encode_text(text_buf);
field_protocolIDs__and__ContainerIDs.encode_text(text_buf);
}

void ProtocolConfigOptionsV::decode_text(Text_Buf& text_buf)
{
field_configProtocol.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_extensionField.decode_text(text_buf);
field_protocolIDs__and__ContainerIDs.decode_text(text_buf);
}

void ProtocolConfigOptionsV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ProtocolConfigOptionsV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int ProtocolConfigOptionsV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_configProtocol.RAW_decode(General__Types::BIT3_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_extensionField.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_protocolIDs__and__ContainerIDs = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, ProtocolIDs__and__ContainerIDs_descr_.raw->forceomit);
  decoded_field_length = field_protocolIDs__and__ContainerIDs().RAW_decode(ProtocolIDs__and__ContainerIDs_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_protocolIDs__and__ContainerIDs = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_protocolIDs__and__ContainerIDs=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int ProtocolConfigOptionsV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT3_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT1_descr_.raw);
  if (field_protocolIDs__and__ContainerIDs.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, ProtocolIDs__and__ContainerIDs_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  encoded_length += field_configProtocol.RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_extensionField.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[2]);
  if (field_protocolIDs__and__ContainerIDs.ispresent()) {
  encoded_length += field_protocolIDs__and__ContainerIDs().RAW_encode(ProtocolIDs__and__ContainerIDs_descr_, *myleaf.body.node.nodes[3]);
  }
  return myleaf.length = encoded_length;
}

struct ProtocolConfigOptionsV_template::single_value_struct {
BITSTRING_template field_configProtocol;
BITSTRING_template field_spare;
BITSTRING_template field_extensionField;
ProtocolIDs__and__ContainerIDs_template field_protocolIDs__and__ContainerIDs;
};

void ProtocolConfigOptionsV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_configProtocol = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_extensionField = ANY_VALUE;
single_value->field_protocolIDs__and__ContainerIDs = ANY_OR_OMIT;
}
}
}

void ProtocolConfigOptionsV_template::copy_value(const ProtocolConfigOptionsV& other_value)
{
single_value = new single_value_struct;
if (other_value.configProtocol().is_bound()) {
  single_value->field_configProtocol = other_value.configProtocol();
} else {
  single_value->field_configProtocol.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.extensionField().is_bound()) {
  single_value->field_extensionField = other_value.extensionField();
} else {
  single_value->field_extensionField.clean_up();
}
if (other_value.protocolIDs__and__ContainerIDs().is_bound()) {
  if (other_value.protocolIDs__and__ContainerIDs().ispresent()) single_value->field_protocolIDs__and__ContainerIDs = other_value.protocolIDs__and__ContainerIDs()();
  else single_value->field_protocolIDs__and__ContainerIDs = OMIT_VALUE;
} else {
  single_value->field_protocolIDs__and__ContainerIDs.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ProtocolConfigOptionsV_template::copy_template(const ProtocolConfigOptionsV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.configProtocol().get_selection()) {
single_value->field_configProtocol = other_value.configProtocol();
} else {
single_value->field_configProtocol.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionField().get_selection()) {
single_value->field_extensionField = other_value.extensionField();
} else {
single_value->field_extensionField.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protocolIDs__and__ContainerIDs().get_selection()) {
single_value->field_protocolIDs__and__ContainerIDs = other_value.protocolIDs__and__ContainerIDs();
} else {
single_value->field_protocolIDs__and__ContainerIDs.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ProtocolConfigOptionsV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ProtocolConfigOptionsV_template(*other_value.implication_.precondition);
implication_.implied_template = new ProtocolConfigOptionsV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV.");
break;
}
set_selection(other_value);
}

ProtocolConfigOptionsV_template::ProtocolConfigOptionsV_template()
{
}

ProtocolConfigOptionsV_template::ProtocolConfigOptionsV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ProtocolConfigOptionsV_template::ProtocolConfigOptionsV_template(const ProtocolConfigOptionsV& other_value)
{
copy_value(other_value);
}

ProtocolConfigOptionsV_template::ProtocolConfigOptionsV_template(const OPTIONAL<ProtocolConfigOptionsV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ProtocolConfigOptionsV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV from an unbound optional field.");
}
}

ProtocolConfigOptionsV_template::ProtocolConfigOptionsV_template(ProtocolConfigOptionsV_template* p_precondition, ProtocolConfigOptionsV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ProtocolConfigOptionsV_template::ProtocolConfigOptionsV_template(Dynamic_Match_Interface<ProtocolConfigOptionsV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ProtocolConfigOptionsV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ProtocolConfigOptionsV_template::ProtocolConfigOptionsV_template(const ProtocolConfigOptionsV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ProtocolConfigOptionsV_template::~ProtocolConfigOptionsV_template()
{
clean_up();
}

ProtocolConfigOptionsV_template& ProtocolConfigOptionsV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ProtocolConfigOptionsV_template& ProtocolConfigOptionsV_template::operator=(const ProtocolConfigOptionsV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ProtocolConfigOptionsV_template& ProtocolConfigOptionsV_template::operator=(const OPTIONAL<ProtocolConfigOptionsV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ProtocolConfigOptionsV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV.");
}
return *this;
}

ProtocolConfigOptionsV_template& ProtocolConfigOptionsV_template::operator=(const ProtocolConfigOptionsV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ProtocolConfigOptionsV_template::match(const ProtocolConfigOptionsV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.configProtocol().is_bound()) return FALSE;
if(!single_value->field_configProtocol.match(other_value.configProtocol(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.extensionField().is_bound()) return FALSE;
if(!single_value->field_extensionField.match(other_value.extensionField(), legacy))return FALSE;
if(!other_value.protocolIDs__and__ContainerIDs().is_bound()) return FALSE;
if((other_value.protocolIDs__and__ContainerIDs().ispresent() ? !single_value->field_protocolIDs__and__ContainerIDs.match((const ProtocolIDs__and__ContainerIDs&)other_value.protocolIDs__and__ContainerIDs(), legacy) : !single_value->field_protocolIDs__and__ContainerIDs.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV.");
}
return FALSE;
}

boolean ProtocolConfigOptionsV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_configProtocol.is_bound()
 || single_value->field_spare.is_bound()
 || single_value->field_extensionField.is_bound()
 || (single_value->field_protocolIDs__and__ContainerIDs.is_omit() || single_value->field_protocolIDs__and__ContainerIDs.is_bound());
}

boolean ProtocolConfigOptionsV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_configProtocol.is_value()
 && single_value->field_spare.is_value()
 && single_value->field_extensionField.is_value()
 && (single_value->field_protocolIDs__and__ContainerIDs.is_omit() || single_value->field_protocolIDs__and__ContainerIDs.is_value());
}

void ProtocolConfigOptionsV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ProtocolConfigOptionsV ProtocolConfigOptionsV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV.");
ProtocolConfigOptionsV ret_val;
if (single_value->field_configProtocol.is_bound()) {
ret_val.configProtocol() = single_value->field_configProtocol.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_extensionField.is_bound()) {
ret_val.extensionField() = single_value->field_extensionField.valueof();
}
if (single_value->field_protocolIDs__and__ContainerIDs.is_omit()) ret_val.protocolIDs__and__ContainerIDs() = OMIT_VALUE;
else if (single_value->field_protocolIDs__and__ContainerIDs.is_bound()) {
ret_val.protocolIDs__and__ContainerIDs() = single_value->field_protocolIDs__and__ContainerIDs.valueof();
}
return ret_val;
}

void ProtocolConfigOptionsV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ProtocolConfigOptionsV_template[list_length];
}

ProtocolConfigOptionsV_template& ProtocolConfigOptionsV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV.");
return value_list.list_value[list_index];
}

BITSTRING_template& ProtocolConfigOptionsV_template::configProtocol()
{
set_specific();
return single_value->field_configProtocol;
}

const BITSTRING_template& ProtocolConfigOptionsV_template::configProtocol() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field configProtocol of a non-specific template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV.");
return single_value->field_configProtocol;
}

BITSTRING_template& ProtocolConfigOptionsV_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& ProtocolConfigOptionsV_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV.");
return single_value->field_spare;
}

BITSTRING_template& ProtocolConfigOptionsV_template::extensionField()
{
set_specific();
return single_value->field_extensionField;
}

const BITSTRING_template& ProtocolConfigOptionsV_template::extensionField() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionField of a non-specific template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV.");
return single_value->field_extensionField;
}

ProtocolIDs__and__ContainerIDs_template& ProtocolConfigOptionsV_template::protocolIDs__and__ContainerIDs()
{
set_specific();
return single_value->field_protocolIDs__and__ContainerIDs;
}

const ProtocolIDs__and__ContainerIDs_template& ProtocolConfigOptionsV_template::protocolIDs__and__ContainerIDs() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protocolIDs_and_ContainerIDs of a non-specific template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV.");
return single_value->field_protocolIDs__and__ContainerIDs;
}

int ProtocolConfigOptionsV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 3;
      if (single_value->field_protocolIDs__and__ContainerIDs.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV.");
  }
  return 0;
}

void ProtocolConfigOptionsV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ configProtocol := ");
single_value->field_configProtocol.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", extensionField := ");
single_value->field_extensionField.log();
TTCN_Logger::log_event_str(", protocolIDs_and_ContainerIDs := ");
single_value->field_protocolIDs__and__ContainerIDs.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ProtocolConfigOptionsV_template::log_match(const ProtocolConfigOptionsV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_configProtocol.match(match_value.configProtocol(), legacy)){
TTCN_Logger::log_logmatch_info(".configProtocol");
single_value->field_configProtocol.log_match(match_value.configProtocol(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_extensionField.match(match_value.extensionField(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionField");
single_value->field_extensionField.log_match(match_value.extensionField(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.protocolIDs__and__ContainerIDs().ispresent()){
if(!single_value->field_protocolIDs__and__ContainerIDs.match(match_value.protocolIDs__and__ContainerIDs(), legacy)){
TTCN_Logger::log_logmatch_info(".protocolIDs_and_ContainerIDs");
single_value->field_protocolIDs__and__ContainerIDs.log_match(match_value.protocolIDs__and__ContainerIDs(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_protocolIDs__and__ContainerIDs.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".protocolIDs_and_ContainerIDs := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_protocolIDs__and__ContainerIDs.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ configProtocol := ");
single_value->field_configProtocol.log_match(match_value.configProtocol(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", extensionField := ");
single_value->field_extensionField.log_match(match_value.extensionField(), legacy);
TTCN_Logger::log_event_str(", protocolIDs_and_ContainerIDs := ");
if (match_value.protocolIDs__and__ContainerIDs().ispresent()) {
single_value->field_protocolIDs__and__ContainerIDs.log_match(match_value.protocolIDs__and__ContainerIDs(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_protocolIDs__and__ContainerIDs.log();
if (single_value->field_protocolIDs__and__ContainerIDs.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ProtocolConfigOptionsV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_configProtocol.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_extensionField.encode_text(text_buf);
single_value->field_protocolIDs__and__ContainerIDs.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV.");
}
}

void ProtocolConfigOptionsV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_configProtocol.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_extensionField.decode_text(text_buf);
single_value->field_protocolIDs__and__ContainerIDs.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ProtocolConfigOptionsV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV.");
}
}

void ProtocolConfigOptionsV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ProtocolConfigOptionsV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) configProtocol().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionField().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) protocolIDs__and__ContainerIDs().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "configProtocol")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          configProtocol().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolIDs_and_ContainerIDs")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolIDs__and__ContainerIDs().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ProtocolConfigOptionsV_template* precondition = new ProtocolConfigOptionsV_template;
    precondition->set_param(*param.get_elem(0));
    ProtocolConfigOptionsV_template* implied_template = new ProtocolConfigOptionsV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ProtocolConfigOptionsV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.ProtocolConfigOptionsV");
  }
  is_ifpresent = param.get_ifpresent();
}

void ProtocolConfigOptionsV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_configProtocol.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ProtocolConfigOptionsV");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ProtocolConfigOptionsV");
single_value->field_extensionField.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ProtocolConfigOptionsV");
single_value->field_protocolIDs__and__ContainerIDs.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ProtocolConfigOptionsV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.ProtocolConfigOptionsV");
}

boolean ProtocolConfigOptionsV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ProtocolConfigOptionsV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const ProtocolID__or__ContainerID ProtocolIDs__and__ContainerIDs::UNBOUND_ELEM;
ProtocolIDs__and__ContainerIDs::ProtocolIDs__and__ContainerIDs()
{
val_ptr = NULL;
}

ProtocolIDs__and__ContainerIDs::ProtocolIDs__and__ContainerIDs(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

ProtocolIDs__and__ContainerIDs::ProtocolIDs__and__ContainerIDs(const ProtocolIDs__and__ContainerIDs& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

ProtocolIDs__and__ContainerIDs::~ProtocolIDs__and__ContainerIDs()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void ProtocolIDs__and__ContainerIDs::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

ProtocolIDs__and__ContainerIDs& ProtocolIDs__and__ContainerIDs::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

ProtocolIDs__and__ContainerIDs& ProtocolIDs__and__ContainerIDs::operator=(const ProtocolIDs__and__ContainerIDs& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean ProtocolIDs__and__ContainerIDs::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
return val_ptr->n_elements == 0 ;
}

boolean ProtocolIDs__and__ContainerIDs::operator==(const ProtocolIDs__and__ContainerIDs& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

ProtocolID__or__ContainerID& ProtocolIDs__and__ContainerIDs::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (ProtocolID__or__ContainerID**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new ProtocolID__or__ContainerID(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new ProtocolID__or__ContainerID;
}
return *val_ptr->value_elements[index_value];
}

ProtocolID__or__ContainerID& ProtocolIDs__and__ContainerIDs::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
return (*this)[(int)index_value];
}

const ProtocolID__or__ContainerID& ProtocolIDs__and__ContainerIDs::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
if (index_value < 0) TTCN_error("Accessing an element of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const ProtocolID__or__ContainerID& ProtocolIDs__and__ContainerIDs::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
return (*this)[(int)index_value];
}

ProtocolIDs__and__ContainerIDs ProtocolIDs__and__ContainerIDs::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

ProtocolIDs__and__ContainerIDs ProtocolIDs__and__ContainerIDs::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

ProtocolIDs__and__ContainerIDs ProtocolIDs__and__ContainerIDs::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

ProtocolIDs__and__ContainerIDs ProtocolIDs__and__ContainerIDs::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
ProtocolIDs__and__ContainerIDs ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new ProtocolID__or__ContainerID(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

ProtocolIDs__and__ContainerIDs ProtocolIDs__and__ContainerIDs::operator+(const ProtocolIDs__and__ContainerIDs& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
ProtocolIDs__and__ContainerIDs ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new ProtocolID__or__ContainerID(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new ProtocolID__or__ContainerID(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

ProtocolIDs__and__ContainerIDs ProtocolIDs__and__ContainerIDs::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs","element");
ProtocolIDs__and__ContainerIDs ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new ProtocolID__or__ContainerID(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

ProtocolIDs__and__ContainerIDs ProtocolIDs__and__ContainerIDs::replace(int index, int len, const ProtocolIDs__and__ContainerIDs& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
check_replace_arguments(val_ptr->n_elements, index, len, "@MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs","element");
ProtocolIDs__and__ContainerIDs ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new ProtocolID__or__ContainerID(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new ProtocolID__or__ContainerID(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new ProtocolID__or__ContainerID(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

ProtocolIDs__and__ContainerIDs ProtocolIDs__and__ContainerIDs::replace(int index, int len, const ProtocolIDs__and__ContainerIDs_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void ProtocolIDs__and__ContainerIDs::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (ProtocolID__or__ContainerID**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new ProtocolID__or__ContainerID(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (ProtocolID__or__ContainerID**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (ProtocolID__or__ContainerID**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean ProtocolIDs__and__ContainerIDs::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int ProtocolIDs__and__ContainerIDs::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
return val_ptr->n_elements;
}

int ProtocolIDs__and__ContainerIDs::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void ProtocolIDs__and__ContainerIDs::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void ProtocolIDs__and__ContainerIDs::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void ProtocolIDs__and__ContainerIDs::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void ProtocolIDs__and__ContainerIDs::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void ProtocolIDs__and__ContainerIDs::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
val_ptr->value_elements = (ProtocolID__or__ContainerID**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new ProtocolID__or__ContainerID;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void ProtocolIDs__and__ContainerIDs::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ProtocolIDs__and__ContainerIDs::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int ProtocolIDs__and__ContainerIDs::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int ProtocolIDs__and__ContainerIDs::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void ProtocolIDs__and__ContainerIDs_template::copy_value(const ProtocolIDs__and__ContainerIDs& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (ProtocolID__or__ContainerID_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new ProtocolID__or__ContainerID_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new ProtocolID__or__ContainerID_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void ProtocolIDs__and__ContainerIDs_template::copy_template(const ProtocolIDs__and__ContainerIDs_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (ProtocolID__or__ContainerID_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new ProtocolID__or__ContainerID_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new ProtocolID__or__ContainerID_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ProtocolIDs__and__ContainerIDs_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ProtocolIDs__and__ContainerIDs_template(*other_value.implication_.precondition);
implication_.implied_template = new ProtocolIDs__and__ContainerIDs_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
break;
}
set_selection(other_value);
}

boolean ProtocolIDs__and__ContainerIDs_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const ProtocolIDs__and__ContainerIDs_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const ProtocolIDs__and__ContainerIDs*)value_ptr)[value_index], legacy);
else return ((const ProtocolIDs__and__ContainerIDs_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

ProtocolIDs__and__ContainerIDs_template::ProtocolIDs__and__ContainerIDs_template()
{
}

ProtocolIDs__and__ContainerIDs_template::ProtocolIDs__and__ContainerIDs_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

ProtocolIDs__and__ContainerIDs_template::ProtocolIDs__and__ContainerIDs_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

ProtocolIDs__and__ContainerIDs_template::ProtocolIDs__and__ContainerIDs_template(const ProtocolIDs__and__ContainerIDs& other_value)
{
copy_value(other_value);
}

ProtocolIDs__and__ContainerIDs_template::ProtocolIDs__and__ContainerIDs_template(const OPTIONAL<ProtocolIDs__and__ContainerIDs>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ProtocolIDs__and__ContainerIDs&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs from an unbound optional field.");
}
}

ProtocolIDs__and__ContainerIDs_template::ProtocolIDs__and__ContainerIDs_template(ProtocolIDs__and__ContainerIDs_template* p_precondition, ProtocolIDs__and__ContainerIDs_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ProtocolIDs__and__ContainerIDs_template::ProtocolIDs__and__ContainerIDs_template(Dynamic_Match_Interface<ProtocolIDs__and__ContainerIDs>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ProtocolIDs__and__ContainerIDs>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ProtocolIDs__and__ContainerIDs_template::ProtocolIDs__and__ContainerIDs_template(const ProtocolIDs__and__ContainerIDs_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

ProtocolIDs__and__ContainerIDs_template::~ProtocolIDs__and__ContainerIDs_template()
{
clean_up();
}

void ProtocolIDs__and__ContainerIDs_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ProtocolIDs__and__ContainerIDs_template& ProtocolIDs__and__ContainerIDs_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ProtocolIDs__and__ContainerIDs_template& ProtocolIDs__and__ContainerIDs_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

ProtocolIDs__and__ContainerIDs_template& ProtocolIDs__and__ContainerIDs_template::operator=(const ProtocolIDs__and__ContainerIDs& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ProtocolIDs__and__ContainerIDs_template& ProtocolIDs__and__ContainerIDs_template::operator=(const OPTIONAL<ProtocolIDs__and__ContainerIDs>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ProtocolIDs__and__ContainerIDs&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
}
return *this;
}

ProtocolIDs__and__ContainerIDs_template& ProtocolIDs__and__ContainerIDs_template::operator=(const ProtocolIDs__and__ContainerIDs_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

ProtocolID__or__ContainerID_template& ProtocolIDs__and__ContainerIDs_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
    break;
}
return *single_value.value_elements[index_value];
}

ProtocolID__or__ContainerID_template& ProtocolIDs__and__ContainerIDs_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
return (*this)[(int)index_value];
}

const ProtocolID__or__ContainerID_template& ProtocolIDs__and__ContainerIDs_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const ProtocolID__or__ContainerID_template& ProtocolIDs__and__ContainerIDs_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
return (*this)[(int)index_value];
}

void ProtocolIDs__and__ContainerIDs_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (ProtocolID__or__ContainerID_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new ProtocolID__or__ContainerID_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new ProtocolID__or__ContainerID_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (ProtocolID__or__ContainerID_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int ProtocolIDs__and__ContainerIDs_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int ProtocolIDs__and__ContainerIDs_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs");
}

boolean ProtocolIDs__and__ContainerIDs_template::match(const ProtocolIDs__and__ContainerIDs& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
}
return FALSE;
}

boolean ProtocolIDs__and__ContainerIDs_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

ProtocolIDs__and__ContainerIDs ProtocolIDs__and__ContainerIDs_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
ProtocolIDs__and__ContainerIDs ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

ProtocolIDs__and__ContainerIDs ProtocolIDs__and__ContainerIDs_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

ProtocolIDs__and__ContainerIDs ProtocolIDs__and__ContainerIDs_template::replace(int index, int len, const ProtocolIDs__and__ContainerIDs_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

ProtocolIDs__and__ContainerIDs ProtocolIDs__and__ContainerIDs_template::replace(int index, int len, const ProtocolIDs__and__ContainerIDs& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void ProtocolIDs__and__ContainerIDs_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new ProtocolIDs__and__ContainerIDs_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
}
set_selection(template_type);
}

ProtocolIDs__and__ContainerIDs_template& ProtocolIDs__and__ContainerIDs_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
return value_list.list_value[list_index];
}

void ProtocolIDs__and__ContainerIDs_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void ProtocolIDs__and__ContainerIDs_template::log_match(const ProtocolIDs__and__ContainerIDs& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ProtocolIDs__and__ContainerIDs_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
}
}

void ProtocolIDs__and__ContainerIDs_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
single_value.value_elements = (ProtocolID__or__ContainerID_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new ProtocolID__or__ContainerID_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ProtocolIDs__and__ContainerIDs_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs.");
}
}

boolean ProtocolIDs__and__ContainerIDs_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ProtocolIDs__and__ContainerIDs_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void ProtocolIDs__and__ContainerIDs_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ProtocolIDs__and__ContainerIDs_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ProtocolIDs__and__ContainerIDs_template* precondition = new ProtocolIDs__and__ContainerIDs_template;
    precondition->set_param(*param.get_elem(0));
    ProtocolIDs__and__ContainerIDs_template* implied_template = new ProtocolIDs__and__ContainerIDs_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ProtocolIDs__and__ContainerIDs_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void ProtocolIDs__and__ContainerIDs_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.ProtocolIDs_and_ContainerIDs");
}

boolean ProtocolIDs__and__ContainerIDs_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
ProtocolID__or__ContainerID::ProtocolID__or__ContainerID()
{
}

ProtocolID__or__ContainerID::ProtocolID__or__ContainerID(const OCTETSTRING& par_protocolID__or__ContainerID,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_protID__orContID__Contents)
  :   field_protocolID__or__ContainerID(par_protocolID__or__ContainerID),
  field_lengthIndicator(par_lengthIndicator),
  field_protID__orContID__Contents(par_protID__orContID__Contents)
{
}

ProtocolID__or__ContainerID::ProtocolID__or__ContainerID(const ProtocolID__or__ContainerID& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID.");
if (other_value.protocolID__or__ContainerID().is_bound()) field_protocolID__or__ContainerID = other_value.protocolID__or__ContainerID();
else field_protocolID__or__ContainerID.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.protID__orContID__Contents().is_bound()) field_protID__orContID__Contents = other_value.protID__orContID__Contents();
else field_protID__orContID__Contents.clean_up();
}

void ProtocolID__or__ContainerID::clean_up()
{
field_protocolID__or__ContainerID.clean_up();
field_lengthIndicator.clean_up();
field_protID__orContID__Contents.clean_up();
}

const TTCN_Typedescriptor_t* ProtocolID__or__ContainerID::get_descriptor() const { return &ProtocolID__or__ContainerID_descr_; }
ProtocolID__or__ContainerID& ProtocolID__or__ContainerID::operator=(const ProtocolID__or__ContainerID& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID.");
  if (other_value.protocolID__or__ContainerID().is_bound()) field_protocolID__or__ContainerID = other_value.protocolID__or__ContainerID();
  else field_protocolID__or__ContainerID.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.protID__orContID__Contents().is_bound()) field_protID__orContID__Contents = other_value.protID__orContID__Contents();
  else field_protID__orContID__Contents.clean_up();
}
return *this;
}

boolean ProtocolID__or__ContainerID::operator==(const ProtocolID__or__ContainerID& other_value) const
{
return field_protocolID__or__ContainerID==other_value.field_protocolID__or__ContainerID
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_protID__orContID__Contents==other_value.field_protID__orContID__Contents;
}

boolean ProtocolID__or__ContainerID::is_bound() const
{
return (field_protocolID__or__ContainerID.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_protID__orContID__Contents.is_bound());
}
boolean ProtocolID__or__ContainerID::is_value() const
{
return field_protocolID__or__ContainerID.is_value()
  && field_lengthIndicator.is_value()
  && field_protID__orContID__Contents.is_value();
}
void ProtocolID__or__ContainerID::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ protocolID_or_ContainerID := ");
field_protocolID__or__ContainerID.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", protID_orContID_Contents := ");
field_protID__orContID__Contents.log();
TTCN_Logger::log_event_str(" }");
}

void ProtocolID__or__ContainerID::set_implicit_omit()
{
if (protocolID__or__ContainerID().is_bound()) protocolID__or__ContainerID().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (protID__orContID__Contents().is_bound()) protID__orContID__Contents().set_implicit_omit();
}

void ProtocolID__or__ContainerID::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) protocolID__or__ContainerID().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) protID__orContID__Contents().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolID_or_ContainerID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolID__or__ContainerID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protID_orContID_Contents")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protID__orContID__Contents().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID");
  }
}

void ProtocolID__or__ContainerID::encode_text(Text_Buf& text_buf) const
{
field_protocolID__or__ContainerID.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_protID__orContID__Contents.encode_text(text_buf);
}

void ProtocolID__or__ContainerID::decode_text(Text_Buf& text_buf)
{
field_protocolID__or__ContainerID.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_protID__orContID__Contents.decode_text(text_buf);
}

void ProtocolID__or__ContainerID::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ProtocolID__or__ContainerID::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int ProtocolID__or__ContainerID::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_protocolID__or__ContainerID.RAW_decode(General__Types::OCT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, ProtocolID__or__ContainerID_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(ProtocolID__or__ContainerID_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(ProtocolID__or__ContainerID_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_protID__orContID__Contents.RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int ProtocolID__or__ContainerID::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, ProtocolID__or__ContainerID_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, OCTETSTRING_descr_.raw);
  encoded_length += field_protocolID__or__ContainerID.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &ProtocolID__or__ContainerID_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_protID__orContID__Contents.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct ProtocolID__or__ContainerID_template::single_value_struct {
OCTETSTRING_template field_protocolID__or__ContainerID;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_protID__orContID__Contents;
};

void ProtocolID__or__ContainerID_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_protocolID__or__ContainerID = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_protID__orContID__Contents = ANY_VALUE;
}
}
}

void ProtocolID__or__ContainerID_template::copy_value(const ProtocolID__or__ContainerID& other_value)
{
single_value = new single_value_struct;
if (other_value.protocolID__or__ContainerID().is_bound()) {
  single_value->field_protocolID__or__ContainerID = other_value.protocolID__or__ContainerID();
} else {
  single_value->field_protocolID__or__ContainerID.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.protID__orContID__Contents().is_bound()) {
  single_value->field_protID__orContID__Contents = other_value.protID__orContID__Contents();
} else {
  single_value->field_protID__orContID__Contents.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ProtocolID__or__ContainerID_template::copy_template(const ProtocolID__or__ContainerID_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.protocolID__or__ContainerID().get_selection()) {
single_value->field_protocolID__or__ContainerID = other_value.protocolID__or__ContainerID();
} else {
single_value->field_protocolID__or__ContainerID.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protID__orContID__Contents().get_selection()) {
single_value->field_protID__orContID__Contents = other_value.protID__orContID__Contents();
} else {
single_value->field_protID__orContID__Contents.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ProtocolID__or__ContainerID_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ProtocolID__or__ContainerID_template(*other_value.implication_.precondition);
implication_.implied_template = new ProtocolID__or__ContainerID_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID.");
break;
}
set_selection(other_value);
}

ProtocolID__or__ContainerID_template::ProtocolID__or__ContainerID_template()
{
}

ProtocolID__or__ContainerID_template::ProtocolID__or__ContainerID_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ProtocolID__or__ContainerID_template::ProtocolID__or__ContainerID_template(const ProtocolID__or__ContainerID& other_value)
{
copy_value(other_value);
}

ProtocolID__or__ContainerID_template::ProtocolID__or__ContainerID_template(const OPTIONAL<ProtocolID__or__ContainerID>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ProtocolID__or__ContainerID&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID from an unbound optional field.");
}
}

ProtocolID__or__ContainerID_template::ProtocolID__or__ContainerID_template(ProtocolID__or__ContainerID_template* p_precondition, ProtocolID__or__ContainerID_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ProtocolID__or__ContainerID_template::ProtocolID__or__ContainerID_template(Dynamic_Match_Interface<ProtocolID__or__ContainerID>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ProtocolID__or__ContainerID>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ProtocolID__or__ContainerID_template::ProtocolID__or__ContainerID_template(const ProtocolID__or__ContainerID_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ProtocolID__or__ContainerID_template::~ProtocolID__or__ContainerID_template()
{
clean_up();
}

ProtocolID__or__ContainerID_template& ProtocolID__or__ContainerID_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ProtocolID__or__ContainerID_template& ProtocolID__or__ContainerID_template::operator=(const ProtocolID__or__ContainerID& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ProtocolID__or__ContainerID_template& ProtocolID__or__ContainerID_template::operator=(const OPTIONAL<ProtocolID__or__ContainerID>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ProtocolID__or__ContainerID&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID.");
}
return *this;
}

ProtocolID__or__ContainerID_template& ProtocolID__or__ContainerID_template::operator=(const ProtocolID__or__ContainerID_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ProtocolID__or__ContainerID_template::match(const ProtocolID__or__ContainerID& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.protocolID__or__ContainerID().is_bound()) return FALSE;
if(!single_value->field_protocolID__or__ContainerID.match(other_value.protocolID__or__ContainerID(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.protID__orContID__Contents().is_bound()) return FALSE;
if(!single_value->field_protID__orContID__Contents.match(other_value.protID__orContID__Contents(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID.");
}
return FALSE;
}

boolean ProtocolID__or__ContainerID_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_protocolID__or__ContainerID.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_protID__orContID__Contents.is_bound();
}

boolean ProtocolID__or__ContainerID_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_protocolID__or__ContainerID.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_protID__orContID__Contents.is_value();
}

void ProtocolID__or__ContainerID_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ProtocolID__or__ContainerID ProtocolID__or__ContainerID_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID.");
ProtocolID__or__ContainerID ret_val;
if (single_value->field_protocolID__or__ContainerID.is_bound()) {
ret_val.protocolID__or__ContainerID() = single_value->field_protocolID__or__ContainerID.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_protID__orContID__Contents.is_bound()) {
ret_val.protID__orContID__Contents() = single_value->field_protID__orContID__Contents.valueof();
}
return ret_val;
}

void ProtocolID__or__ContainerID_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ProtocolID__or__ContainerID_template[list_length];
}

ProtocolID__or__ContainerID_template& ProtocolID__or__ContainerID_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& ProtocolID__or__ContainerID_template::protocolID__or__ContainerID()
{
set_specific();
return single_value->field_protocolID__or__ContainerID;
}

const OCTETSTRING_template& ProtocolID__or__ContainerID_template::protocolID__or__ContainerID() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protocolID_or_ContainerID of a non-specific template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID.");
return single_value->field_protocolID__or__ContainerID;
}

INTEGER_template& ProtocolID__or__ContainerID_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& ProtocolID__or__ContainerID_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& ProtocolID__or__ContainerID_template::protID__orContID__Contents()
{
set_specific();
return single_value->field_protID__orContID__Contents;
}

const OCTETSTRING_template& ProtocolID__or__ContainerID_template::protID__orContID__Contents() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protID_orContID_Contents of a non-specific template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID.");
return single_value->field_protID__orContID__Contents;
}

int ProtocolID__or__ContainerID_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID.");
  }
  return 0;
}

void ProtocolID__or__ContainerID_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ protocolID_or_ContainerID := ");
single_value->field_protocolID__or__ContainerID.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", protID_orContID_Contents := ");
single_value->field_protID__orContID__Contents.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ProtocolID__or__ContainerID_template::log_match(const ProtocolID__or__ContainerID& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_protocolID__or__ContainerID.match(match_value.protocolID__or__ContainerID(), legacy)){
TTCN_Logger::log_logmatch_info(".protocolID_or_ContainerID");
single_value->field_protocolID__or__ContainerID.log_match(match_value.protocolID__or__ContainerID(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_protID__orContID__Contents.match(match_value.protID__orContID__Contents(), legacy)){
TTCN_Logger::log_logmatch_info(".protID_orContID_Contents");
single_value->field_protID__orContID__Contents.log_match(match_value.protID__orContID__Contents(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ protocolID_or_ContainerID := ");
single_value->field_protocolID__or__ContainerID.log_match(match_value.protocolID__or__ContainerID(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", protID_orContID_Contents := ");
single_value->field_protID__orContID__Contents.log_match(match_value.protID__orContID__Contents(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ProtocolID__or__ContainerID_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_protocolID__or__ContainerID.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_protID__orContID__Contents.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID.");
}
}

void ProtocolID__or__ContainerID_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_protocolID__or__ContainerID.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_protID__orContID__Contents.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ProtocolID__or__ContainerID_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID.");
}
}

void ProtocolID__or__ContainerID_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ProtocolID__or__ContainerID_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) protocolID__or__ContainerID().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) protID__orContID__Contents().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolID_or_ContainerID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolID__or__ContainerID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protID_orContID_Contents")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protID__orContID__Contents().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ProtocolID__or__ContainerID_template* precondition = new ProtocolID__or__ContainerID_template;
    precondition->set_param(*param.get_elem(0));
    ProtocolID__or__ContainerID_template* implied_template = new ProtocolID__or__ContainerID_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ProtocolID__or__ContainerID_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID");
  }
  is_ifpresent = param.get_ifpresent();
}

void ProtocolID__or__ContainerID_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_protocolID__or__ContainerID.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID");
single_value->field_protID__orContID__Contents.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.ProtocolID_or_ContainerID");
}

boolean ProtocolID__or__ContainerID_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ProtocolID__or__ContainerID_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ProtocolConfigOptionsTLV::ProtocolConfigOptionsTLV()
{
}

ProtocolConfigOptionsTLV::ProtocolConfigOptionsTLV(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const ProtocolConfigOptionsV& par_protocolConfigOptionsV)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_protocolConfigOptionsV(par_protocolConfigOptionsV)
{
}

ProtocolConfigOptionsTLV::ProtocolConfigOptionsTLV(const ProtocolConfigOptionsTLV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.protocolConfigOptionsV().is_bound()) field_protocolConfigOptionsV = other_value.protocolConfigOptionsV();
else field_protocolConfigOptionsV.clean_up();
}

void ProtocolConfigOptionsTLV::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_protocolConfigOptionsV.clean_up();
}

const TTCN_Typedescriptor_t* ProtocolConfigOptionsTLV::get_descriptor() const { return &ProtocolConfigOptionsTLV_descr_; }
ProtocolConfigOptionsTLV& ProtocolConfigOptionsTLV::operator=(const ProtocolConfigOptionsTLV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.protocolConfigOptionsV().is_bound()) field_protocolConfigOptionsV = other_value.protocolConfigOptionsV();
  else field_protocolConfigOptionsV.clean_up();
}
return *this;
}

boolean ProtocolConfigOptionsTLV::operator==(const ProtocolConfigOptionsTLV& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_protocolConfigOptionsV==other_value.field_protocolConfigOptionsV;
}

boolean ProtocolConfigOptionsTLV::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_protocolConfigOptionsV.is_bound());
}
boolean ProtocolConfigOptionsTLV::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_protocolConfigOptionsV.is_value();
}
void ProtocolConfigOptionsTLV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", protocolConfigOptionsV := ");
field_protocolConfigOptionsV.log();
TTCN_Logger::log_event_str(" }");
}

void ProtocolConfigOptionsTLV::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (protocolConfigOptionsV().is_bound()) protocolConfigOptionsV().set_implicit_omit();
}

void ProtocolConfigOptionsTLV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOptionsV().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOptionsV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOptionsV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV");
  }
}

void ProtocolConfigOptionsTLV::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_protocolConfigOptionsV.encode_text(text_buf);
}

void ProtocolConfigOptionsTLV::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_protocolConfigOptionsV.decode_text(text_buf);
}

void ProtocolConfigOptionsTLV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ProtocolConfigOptionsTLV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int ProtocolConfigOptionsTLV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, ProtocolConfigOptionsTLV_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(ProtocolConfigOptionsTLV_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(ProtocolConfigOptionsTLV_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, ProtocolConfigOptionsV_descr_.raw->forceomit);
  decoded_field_length = field_protocolConfigOptionsV.RAW_decode(ProtocolConfigOptionsV_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_0) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int ProtocolConfigOptionsTLV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, ProtocolConfigOptionsTLV_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, ProtocolConfigOptionsV_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &ProtocolConfigOptionsTLV_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_protocolConfigOptionsV.RAW_encode(ProtocolConfigOptionsV_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier !=  os_0) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_0.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct ProtocolConfigOptionsTLV_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
ProtocolConfigOptionsV_template field_protocolConfigOptionsV;
};

void ProtocolConfigOptionsTLV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_protocolConfigOptionsV = ANY_VALUE;
}
}
}

void ProtocolConfigOptionsTLV_template::copy_value(const ProtocolConfigOptionsTLV& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.protocolConfigOptionsV().is_bound()) {
  single_value->field_protocolConfigOptionsV = other_value.protocolConfigOptionsV();
} else {
  single_value->field_protocolConfigOptionsV.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ProtocolConfigOptionsTLV_template::copy_template(const ProtocolConfigOptionsTLV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protocolConfigOptionsV().get_selection()) {
single_value->field_protocolConfigOptionsV = other_value.protocolConfigOptionsV();
} else {
single_value->field_protocolConfigOptionsV.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ProtocolConfigOptionsTLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ProtocolConfigOptionsTLV_template(*other_value.implication_.precondition);
implication_.implied_template = new ProtocolConfigOptionsTLV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV.");
break;
}
set_selection(other_value);
}

ProtocolConfigOptionsTLV_template::ProtocolConfigOptionsTLV_template()
{
}

ProtocolConfigOptionsTLV_template::ProtocolConfigOptionsTLV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ProtocolConfigOptionsTLV_template::ProtocolConfigOptionsTLV_template(const ProtocolConfigOptionsTLV& other_value)
{
copy_value(other_value);
}

ProtocolConfigOptionsTLV_template::ProtocolConfigOptionsTLV_template(const OPTIONAL<ProtocolConfigOptionsTLV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ProtocolConfigOptionsTLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV from an unbound optional field.");
}
}

ProtocolConfigOptionsTLV_template::ProtocolConfigOptionsTLV_template(ProtocolConfigOptionsTLV_template* p_precondition, ProtocolConfigOptionsTLV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ProtocolConfigOptionsTLV_template::ProtocolConfigOptionsTLV_template(Dynamic_Match_Interface<ProtocolConfigOptionsTLV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ProtocolConfigOptionsTLV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ProtocolConfigOptionsTLV_template::ProtocolConfigOptionsTLV_template(const ProtocolConfigOptionsTLV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ProtocolConfigOptionsTLV_template::~ProtocolConfigOptionsTLV_template()
{
clean_up();
}

ProtocolConfigOptionsTLV_template& ProtocolConfigOptionsTLV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ProtocolConfigOptionsTLV_template& ProtocolConfigOptionsTLV_template::operator=(const ProtocolConfigOptionsTLV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ProtocolConfigOptionsTLV_template& ProtocolConfigOptionsTLV_template::operator=(const OPTIONAL<ProtocolConfigOptionsTLV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ProtocolConfigOptionsTLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV.");
}
return *this;
}

ProtocolConfigOptionsTLV_template& ProtocolConfigOptionsTLV_template::operator=(const ProtocolConfigOptionsTLV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ProtocolConfigOptionsTLV_template::match(const ProtocolConfigOptionsTLV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.protocolConfigOptionsV().is_bound()) return FALSE;
if(!single_value->field_protocolConfigOptionsV.match(other_value.protocolConfigOptionsV(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV.");
}
return FALSE;
}

boolean ProtocolConfigOptionsTLV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_protocolConfigOptionsV.is_bound();
}

boolean ProtocolConfigOptionsTLV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_protocolConfigOptionsV.is_value();
}

void ProtocolConfigOptionsTLV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ProtocolConfigOptionsTLV ProtocolConfigOptionsTLV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV.");
ProtocolConfigOptionsTLV ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_protocolConfigOptionsV.is_bound()) {
ret_val.protocolConfigOptionsV() = single_value->field_protocolConfigOptionsV.valueof();
}
return ret_val;
}

void ProtocolConfigOptionsTLV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ProtocolConfigOptionsTLV_template[list_length];
}

ProtocolConfigOptionsTLV_template& ProtocolConfigOptionsTLV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& ProtocolConfigOptionsTLV_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& ProtocolConfigOptionsTLV_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV.");
return single_value->field_elementIdentifier;
}

INTEGER_template& ProtocolConfigOptionsTLV_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& ProtocolConfigOptionsTLV_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV.");
return single_value->field_lengthIndicator;
}

ProtocolConfigOptionsV_template& ProtocolConfigOptionsTLV_template::protocolConfigOptionsV()
{
set_specific();
return single_value->field_protocolConfigOptionsV;
}

const ProtocolConfigOptionsV_template& ProtocolConfigOptionsTLV_template::protocolConfigOptionsV() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protocolConfigOptionsV of a non-specific template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV.");
return single_value->field_protocolConfigOptionsV;
}

int ProtocolConfigOptionsTLV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV.");
  }
  return 0;
}

void ProtocolConfigOptionsTLV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", protocolConfigOptionsV := ");
single_value->field_protocolConfigOptionsV.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ProtocolConfigOptionsTLV_template::log_match(const ProtocolConfigOptionsTLV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_protocolConfigOptionsV.match(match_value.protocolConfigOptionsV(), legacy)){
TTCN_Logger::log_logmatch_info(".protocolConfigOptionsV");
single_value->field_protocolConfigOptionsV.log_match(match_value.protocolConfigOptionsV(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", protocolConfigOptionsV := ");
single_value->field_protocolConfigOptionsV.log_match(match_value.protocolConfigOptionsV(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ProtocolConfigOptionsTLV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_protocolConfigOptionsV.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV.");
}
}

void ProtocolConfigOptionsTLV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_protocolConfigOptionsV.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ProtocolConfigOptionsTLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV.");
}
}

void ProtocolConfigOptionsTLV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ProtocolConfigOptionsTLV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) protocolConfigOptionsV().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolConfigOptionsV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolConfigOptionsV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ProtocolConfigOptionsTLV_template* precondition = new ProtocolConfigOptionsTLV_template;
    precondition->set_param(*param.get_elem(0));
    ProtocolConfigOptionsTLV_template* implied_template = new ProtocolConfigOptionsTLV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ProtocolConfigOptionsTLV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV");
  }
  is_ifpresent = param.get_ifpresent();
}

void ProtocolConfigOptionsTLV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV");
single_value->field_protocolConfigOptionsV.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.ProtocolConfigOptionsTLV");
}

boolean ProtocolConfigOptionsTLV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ProtocolConfigOptionsTLV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDPAddressV::PDPAddressV()
{
}

PDPAddressV::PDPAddressV(const BITSTRING& par_pdpTypeOrg,
    const BITSTRING& par_spare,
    const OCTETSTRING& par_pdpTypeNum,
    const OPTIONAL< OCTETSTRING >& par_addressInfo)
  :   field_pdpTypeOrg(par_pdpTypeOrg),
  field_spare(par_spare),
  field_pdpTypeNum(par_pdpTypeNum),
  field_addressInfo(par_addressInfo)
{
}

PDPAddressV::PDPAddressV(const PDPAddressV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PDPAddressV.");
if (other_value.pdpTypeOrg().is_bound()) field_pdpTypeOrg = other_value.pdpTypeOrg();
else field_pdpTypeOrg.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.pdpTypeNum().is_bound()) field_pdpTypeNum = other_value.pdpTypeNum();
else field_pdpTypeNum.clean_up();
if (other_value.addressInfo().is_bound()) field_addressInfo = other_value.addressInfo();
else field_addressInfo.clean_up();
}

void PDPAddressV::clean_up()
{
field_pdpTypeOrg.clean_up();
field_spare.clean_up();
field_pdpTypeNum.clean_up();
field_addressInfo.clean_up();
}

const TTCN_Typedescriptor_t* PDPAddressV::get_descriptor() const { return &PDPAddressV_descr_; }
PDPAddressV& PDPAddressV::operator=(const PDPAddressV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PDPAddressV.");
  if (other_value.pdpTypeOrg().is_bound()) field_pdpTypeOrg = other_value.pdpTypeOrg();
  else field_pdpTypeOrg.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.pdpTypeNum().is_bound()) field_pdpTypeNum = other_value.pdpTypeNum();
  else field_pdpTypeNum.clean_up();
  if (other_value.addressInfo().is_bound()) field_addressInfo = other_value.addressInfo();
  else field_addressInfo.clean_up();
}
return *this;
}

boolean PDPAddressV::operator==(const PDPAddressV& other_value) const
{
return field_pdpTypeOrg==other_value.field_pdpTypeOrg
  && field_spare==other_value.field_spare
  && field_pdpTypeNum==other_value.field_pdpTypeNum
  && field_addressInfo==other_value.field_addressInfo;
}

boolean PDPAddressV::is_bound() const
{
return (field_pdpTypeOrg.is_bound())
  || (field_spare.is_bound())
  || (field_pdpTypeNum.is_bound())
  || (OPTIONAL_OMIT == field_addressInfo.get_selection() || field_addressInfo.is_bound());
}
boolean PDPAddressV::is_value() const
{
return field_pdpTypeOrg.is_value()
  && field_spare.is_value()
  && field_pdpTypeNum.is_value()
  && (OPTIONAL_OMIT == field_addressInfo.get_selection() || field_addressInfo.is_value());
}
int PDPAddressV::size_of() const
{
  int ret_val = 3;
  if (field_addressInfo.ispresent()) ret_val++;
  return ret_val;
}

void PDPAddressV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ pdpTypeOrg := ");
field_pdpTypeOrg.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", pdpTypeNum := ");
field_pdpTypeNum.log();
TTCN_Logger::log_event_str(", addressInfo := ");
field_addressInfo.log();
TTCN_Logger::log_event_str(" }");
}

void PDPAddressV::set_implicit_omit()
{
if (pdpTypeOrg().is_bound()) pdpTypeOrg().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (pdpTypeNum().is_bound()) pdpTypeNum().set_implicit_omit();
if (!addressInfo().is_bound()) addressInfo() = OMIT_VALUE;
else addressInfo().set_implicit_omit();
}

void PDPAddressV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PDPAddressV has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) pdpTypeOrg().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) pdpTypeNum().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) addressInfo().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdpTypeOrg")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdpTypeOrg().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdpTypeNum")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdpTypeNum().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "addressInfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          addressInfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDPAddressV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PDPAddressV");
  }
}

void PDPAddressV::encode_text(Text_Buf& text_buf) const
{
field_pdpTypeOrg.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_pdpTypeNum.encode_text(text_buf);
field_addressInfo.encode_text(text_buf);
}

void PDPAddressV::decode_text(Text_Buf& text_buf)
{
field_pdpTypeOrg.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_pdpTypeNum.decode_text(text_buf);
field_addressInfo.decode_text(text_buf);
}

void PDPAddressV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDPAddressV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDPAddressV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_pdpTypeOrg.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_pdpTypeNum.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_addressInfo = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_addressInfo().RAW_decode(OCTETSTRING_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_addressInfo = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_addressInfo=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDPAddressV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT1_descr_.raw);
  if (field_addressInfo.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, OCTETSTRING_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  encoded_length += field_pdpTypeOrg.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_pdpTypeNum.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[2]);
  if (field_addressInfo.ispresent()) {
  encoded_length += field_addressInfo().RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[3]);
  }
  return myleaf.length = encoded_length;
}

struct PDPAddressV_template::single_value_struct {
BITSTRING_template field_pdpTypeOrg;
BITSTRING_template field_spare;
OCTETSTRING_template field_pdpTypeNum;
OCTETSTRING_template field_addressInfo;
};

void PDPAddressV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_pdpTypeOrg = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_pdpTypeNum = ANY_VALUE;
single_value->field_addressInfo = ANY_OR_OMIT;
}
}
}

void PDPAddressV_template::copy_value(const PDPAddressV& other_value)
{
single_value = new single_value_struct;
if (other_value.pdpTypeOrg().is_bound()) {
  single_value->field_pdpTypeOrg = other_value.pdpTypeOrg();
} else {
  single_value->field_pdpTypeOrg.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.pdpTypeNum().is_bound()) {
  single_value->field_pdpTypeNum = other_value.pdpTypeNum();
} else {
  single_value->field_pdpTypeNum.clean_up();
}
if (other_value.addressInfo().is_bound()) {
  if (other_value.addressInfo().ispresent()) single_value->field_addressInfo = other_value.addressInfo()();
  else single_value->field_addressInfo = OMIT_VALUE;
} else {
  single_value->field_addressInfo.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDPAddressV_template::copy_template(const PDPAddressV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.pdpTypeOrg().get_selection()) {
single_value->field_pdpTypeOrg = other_value.pdpTypeOrg();
} else {
single_value->field_pdpTypeOrg.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pdpTypeNum().get_selection()) {
single_value->field_pdpTypeNum = other_value.pdpTypeNum();
} else {
single_value->field_pdpTypeNum.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.addressInfo().get_selection()) {
single_value->field_addressInfo = other_value.addressInfo();
} else {
single_value->field_addressInfo.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDPAddressV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDPAddressV_template(*other_value.implication_.precondition);
implication_.implied_template = new PDPAddressV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDPAddressV.");
break;
}
set_selection(other_value);
}

PDPAddressV_template::PDPAddressV_template()
{
}

PDPAddressV_template::PDPAddressV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDPAddressV_template::PDPAddressV_template(const PDPAddressV& other_value)
{
copy_value(other_value);
}

PDPAddressV_template::PDPAddressV_template(const OPTIONAL<PDPAddressV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDPAddressV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PDPAddressV from an unbound optional field.");
}
}

PDPAddressV_template::PDPAddressV_template(PDPAddressV_template* p_precondition, PDPAddressV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDPAddressV_template::PDPAddressV_template(Dynamic_Match_Interface<PDPAddressV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDPAddressV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDPAddressV_template::PDPAddressV_template(const PDPAddressV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDPAddressV_template::~PDPAddressV_template()
{
clean_up();
}

PDPAddressV_template& PDPAddressV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDPAddressV_template& PDPAddressV_template::operator=(const PDPAddressV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDPAddressV_template& PDPAddressV_template::operator=(const OPTIONAL<PDPAddressV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDPAddressV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PDPAddressV.");
}
return *this;
}

PDPAddressV_template& PDPAddressV_template::operator=(const PDPAddressV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDPAddressV_template::match(const PDPAddressV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.pdpTypeOrg().is_bound()) return FALSE;
if(!single_value->field_pdpTypeOrg.match(other_value.pdpTypeOrg(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.pdpTypeNum().is_bound()) return FALSE;
if(!single_value->field_pdpTypeNum.match(other_value.pdpTypeNum(), legacy))return FALSE;
if(!other_value.addressInfo().is_bound()) return FALSE;
if((other_value.addressInfo().ispresent() ? !single_value->field_addressInfo.match((const OCTETSTRING&)other_value.addressInfo(), legacy) : !single_value->field_addressInfo.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDPAddressV.");
}
return FALSE;
}

boolean PDPAddressV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_pdpTypeOrg.is_bound()
 || single_value->field_spare.is_bound()
 || single_value->field_pdpTypeNum.is_bound()
 || (single_value->field_addressInfo.is_omit() || single_value->field_addressInfo.is_bound());
}

boolean PDPAddressV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_pdpTypeOrg.is_value()
 && single_value->field_spare.is_value()
 && single_value->field_pdpTypeNum.is_value()
 && (single_value->field_addressInfo.is_omit() || single_value->field_addressInfo.is_value());
}

void PDPAddressV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDPAddressV PDPAddressV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PDPAddressV.");
PDPAddressV ret_val;
if (single_value->field_pdpTypeOrg.is_bound()) {
ret_val.pdpTypeOrg() = single_value->field_pdpTypeOrg.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_pdpTypeNum.is_bound()) {
ret_val.pdpTypeNum() = single_value->field_pdpTypeNum.valueof();
}
if (single_value->field_addressInfo.is_omit()) ret_val.addressInfo() = OMIT_VALUE;
else if (single_value->field_addressInfo.is_bound()) {
ret_val.addressInfo() = single_value->field_addressInfo.valueof();
}
return ret_val;
}

void PDPAddressV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PDPAddressV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDPAddressV_template[list_length];
}

PDPAddressV_template& PDPAddressV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PDPAddressV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PDPAddressV.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDPAddressV_template::pdpTypeOrg()
{
set_specific();
return single_value->field_pdpTypeOrg;
}

const BITSTRING_template& PDPAddressV_template::pdpTypeOrg() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pdpTypeOrg of a non-specific template of type @MobileL3_GMM_SM_Types.PDPAddressV.");
return single_value->field_pdpTypeOrg;
}

BITSTRING_template& PDPAddressV_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& PDPAddressV_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @MobileL3_GMM_SM_Types.PDPAddressV.");
return single_value->field_spare;
}

OCTETSTRING_template& PDPAddressV_template::pdpTypeNum()
{
set_specific();
return single_value->field_pdpTypeNum;
}

const OCTETSTRING_template& PDPAddressV_template::pdpTypeNum() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pdpTypeNum of a non-specific template of type @MobileL3_GMM_SM_Types.PDPAddressV.");
return single_value->field_pdpTypeNum;
}

OCTETSTRING_template& PDPAddressV_template::addressInfo()
{
set_specific();
return single_value->field_addressInfo;
}

const OCTETSTRING_template& PDPAddressV_template::addressInfo() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field addressInfo of a non-specific template of type @MobileL3_GMM_SM_Types.PDPAddressV.");
return single_value->field_addressInfo;
}

int PDPAddressV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 3;
      if (single_value->field_addressInfo.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDPAddressV.");
  }
  return 0;
}

void PDPAddressV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ pdpTypeOrg := ");
single_value->field_pdpTypeOrg.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", pdpTypeNum := ");
single_value->field_pdpTypeNum.log();
TTCN_Logger::log_event_str(", addressInfo := ");
single_value->field_addressInfo.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDPAddressV_template::log_match(const PDPAddressV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_pdpTypeOrg.match(match_value.pdpTypeOrg(), legacy)){
TTCN_Logger::log_logmatch_info(".pdpTypeOrg");
single_value->field_pdpTypeOrg.log_match(match_value.pdpTypeOrg(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_pdpTypeNum.match(match_value.pdpTypeNum(), legacy)){
TTCN_Logger::log_logmatch_info(".pdpTypeNum");
single_value->field_pdpTypeNum.log_match(match_value.pdpTypeNum(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.addressInfo().ispresent()){
if(!single_value->field_addressInfo.match(match_value.addressInfo(), legacy)){
TTCN_Logger::log_logmatch_info(".addressInfo");
single_value->field_addressInfo.log_match(match_value.addressInfo(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_addressInfo.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".addressInfo := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_addressInfo.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ pdpTypeOrg := ");
single_value->field_pdpTypeOrg.log_match(match_value.pdpTypeOrg(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", pdpTypeNum := ");
single_value->field_pdpTypeNum.log_match(match_value.pdpTypeNum(), legacy);
TTCN_Logger::log_event_str(", addressInfo := ");
if (match_value.addressInfo().ispresent()) {
single_value->field_addressInfo.log_match(match_value.addressInfo(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_addressInfo.log();
if (single_value->field_addressInfo.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDPAddressV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_pdpTypeOrg.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_pdpTypeNum.encode_text(text_buf);
single_value->field_addressInfo.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDPAddressV.");
}
}

void PDPAddressV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_pdpTypeOrg.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_pdpTypeNum.decode_text(text_buf);
single_value->field_addressInfo.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDPAddressV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PDPAddressV.");
}
}

void PDPAddressV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDPAddressV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PDPAddressV has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) pdpTypeOrg().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) pdpTypeNum().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) addressInfo().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdpTypeOrg")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdpTypeOrg().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdpTypeNum")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdpTypeNum().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "addressInfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          addressInfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDPAddressV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDPAddressV_template* precondition = new PDPAddressV_template;
    precondition->set_param(*param.get_elem(0));
    PDPAddressV_template* implied_template = new PDPAddressV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDPAddressV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PDPAddressV");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDPAddressV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_pdpTypeOrg.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDPAddressV");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDPAddressV");
single_value->field_pdpTypeNum.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDPAddressV");
single_value->field_addressInfo.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDPAddressV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PDPAddressV");
}

boolean PDPAddressV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDPAddressV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDPAddressLV::PDPAddressLV()
{
}

PDPAddressLV::PDPAddressLV(const INTEGER& par_lengthIndicator,
    const PDPAddressV& par_pdpAddressV)
  :   field_lengthIndicator(par_lengthIndicator),
  field_pdpAddressV(par_pdpAddressV)
{
}

PDPAddressLV::PDPAddressLV(const PDPAddressLV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PDPAddressLV.");
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.pdpAddressV().is_bound()) field_pdpAddressV = other_value.pdpAddressV();
else field_pdpAddressV.clean_up();
}

void PDPAddressLV::clean_up()
{
field_lengthIndicator.clean_up();
field_pdpAddressV.clean_up();
}

const TTCN_Typedescriptor_t* PDPAddressLV::get_descriptor() const { return &PDPAddressLV_descr_; }
PDPAddressLV& PDPAddressLV::operator=(const PDPAddressLV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PDPAddressLV.");
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.pdpAddressV().is_bound()) field_pdpAddressV = other_value.pdpAddressV();
  else field_pdpAddressV.clean_up();
}
return *this;
}

boolean PDPAddressLV::operator==(const PDPAddressLV& other_value) const
{
return field_lengthIndicator==other_value.field_lengthIndicator
  && field_pdpAddressV==other_value.field_pdpAddressV;
}

boolean PDPAddressLV::is_bound() const
{
return (field_lengthIndicator.is_bound())
  || (field_pdpAddressV.is_bound());
}
boolean PDPAddressLV::is_value() const
{
return field_lengthIndicator.is_value()
  && field_pdpAddressV.is_value();
}
void PDPAddressLV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", pdpAddressV := ");
field_pdpAddressV.log();
TTCN_Logger::log_event_str(" }");
}

void PDPAddressLV::set_implicit_omit()
{
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (pdpAddressV().is_bound()) pdpAddressV().set_implicit_omit();
}

void PDPAddressLV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PDPAddressLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) pdpAddressV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdpAddressV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdpAddressV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDPAddressLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PDPAddressLV");
  }
}

void PDPAddressLV::encode_text(Text_Buf& text_buf) const
{
field_lengthIndicator.encode_text(text_buf);
field_pdpAddressV.encode_text(text_buf);
}

void PDPAddressLV::decode_text(Text_Buf& text_buf)
{
field_lengthIndicator.decode_text(text_buf);
field_pdpAddressV.decode_text(text_buf);
}

void PDPAddressLV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDPAddressLV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDPAddressLV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, PDPAddressLV_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(PDPAddressLV_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_lengthIndicator.convert_to_Integer(PDPAddressLV_lengthIndicator_descr_);
  field_lengthIndicator = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, PDPAddressV_descr_.raw->forceomit);
  decoded_field_length = field_pdpAddressV.RAW_decode(PDPAddressV_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDPAddressLV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, PDPAddressLV_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, PDPAddressV_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &PDPAddressLV_lengthIndicator_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_pdpAddressV.RAW_encode(PDPAddressV_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct PDPAddressLV_template::single_value_struct {
INTEGER_template field_lengthIndicator;
PDPAddressV_template field_pdpAddressV;
};

void PDPAddressLV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_pdpAddressV = ANY_VALUE;
}
}
}

void PDPAddressLV_template::copy_value(const PDPAddressLV& other_value)
{
single_value = new single_value_struct;
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.pdpAddressV().is_bound()) {
  single_value->field_pdpAddressV = other_value.pdpAddressV();
} else {
  single_value->field_pdpAddressV.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDPAddressLV_template::copy_template(const PDPAddressLV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pdpAddressV().get_selection()) {
single_value->field_pdpAddressV = other_value.pdpAddressV();
} else {
single_value->field_pdpAddressV.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDPAddressLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDPAddressLV_template(*other_value.implication_.precondition);
implication_.implied_template = new PDPAddressLV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDPAddressLV.");
break;
}
set_selection(other_value);
}

PDPAddressLV_template::PDPAddressLV_template()
{
}

PDPAddressLV_template::PDPAddressLV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDPAddressLV_template::PDPAddressLV_template(const PDPAddressLV& other_value)
{
copy_value(other_value);
}

PDPAddressLV_template::PDPAddressLV_template(const OPTIONAL<PDPAddressLV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDPAddressLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PDPAddressLV from an unbound optional field.");
}
}

PDPAddressLV_template::PDPAddressLV_template(PDPAddressLV_template* p_precondition, PDPAddressLV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDPAddressLV_template::PDPAddressLV_template(Dynamic_Match_Interface<PDPAddressLV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDPAddressLV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDPAddressLV_template::PDPAddressLV_template(const PDPAddressLV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDPAddressLV_template::~PDPAddressLV_template()
{
clean_up();
}

PDPAddressLV_template& PDPAddressLV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDPAddressLV_template& PDPAddressLV_template::operator=(const PDPAddressLV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDPAddressLV_template& PDPAddressLV_template::operator=(const OPTIONAL<PDPAddressLV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDPAddressLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PDPAddressLV.");
}
return *this;
}

PDPAddressLV_template& PDPAddressLV_template::operator=(const PDPAddressLV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDPAddressLV_template::match(const PDPAddressLV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.pdpAddressV().is_bound()) return FALSE;
if(!single_value->field_pdpAddressV.match(other_value.pdpAddressV(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDPAddressLV.");
}
return FALSE;
}

boolean PDPAddressLV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_lengthIndicator.is_bound()
 || single_value->field_pdpAddressV.is_bound();
}

boolean PDPAddressLV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_lengthIndicator.is_value()
 && single_value->field_pdpAddressV.is_value();
}

void PDPAddressLV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDPAddressLV PDPAddressLV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PDPAddressLV.");
PDPAddressLV ret_val;
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_pdpAddressV.is_bound()) {
ret_val.pdpAddressV() = single_value->field_pdpAddressV.valueof();
}
return ret_val;
}

void PDPAddressLV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PDPAddressLV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDPAddressLV_template[list_length];
}

PDPAddressLV_template& PDPAddressLV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PDPAddressLV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PDPAddressLV.");
return value_list.list_value[list_index];
}

INTEGER_template& PDPAddressLV_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& PDPAddressLV_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_GMM_SM_Types.PDPAddressLV.");
return single_value->field_lengthIndicator;
}

PDPAddressV_template& PDPAddressLV_template::pdpAddressV()
{
set_specific();
return single_value->field_pdpAddressV;
}

const PDPAddressV_template& PDPAddressLV_template::pdpAddressV() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pdpAddressV of a non-specific template of type @MobileL3_GMM_SM_Types.PDPAddressLV.");
return single_value->field_pdpAddressV;
}

int PDPAddressLV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressLV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressLV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressLV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressLV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressLV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressLV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressLV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressLV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressLV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDPAddressLV.");
  }
  return 0;
}

void PDPAddressLV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", pdpAddressV := ");
single_value->field_pdpAddressV.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDPAddressLV_template::log_match(const PDPAddressLV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_pdpAddressV.match(match_value.pdpAddressV(), legacy)){
TTCN_Logger::log_logmatch_info(".pdpAddressV");
single_value->field_pdpAddressV.log_match(match_value.pdpAddressV(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", pdpAddressV := ");
single_value->field_pdpAddressV.log_match(match_value.pdpAddressV(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDPAddressLV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_pdpAddressV.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDPAddressLV.");
}
}

void PDPAddressLV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_pdpAddressV.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDPAddressLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PDPAddressLV.");
}
}

void PDPAddressLV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDPAddressLV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PDPAddressLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) pdpAddressV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdpAddressV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdpAddressV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDPAddressLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDPAddressLV_template* precondition = new PDPAddressLV_template;
    precondition->set_param(*param.get_elem(0));
    PDPAddressLV_template* implied_template = new PDPAddressLV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDPAddressLV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PDPAddressLV");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDPAddressLV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDPAddressLV");
single_value->field_pdpAddressV.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDPAddressLV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PDPAddressLV");
}

boolean PDPAddressLV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDPAddressLV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDPAddressTLV::PDPAddressTLV()
{
}

PDPAddressTLV::PDPAddressTLV(const OCTETSTRING& par_elementIdentifier,
    const PDPAddressLV& par_pDPAddressLV)
  :   field_elementIdentifier(par_elementIdentifier),
  field_pDPAddressLV(par_pDPAddressLV)
{
}

PDPAddressTLV::PDPAddressTLV(const PDPAddressTLV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.PDPAddressTLV.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.pDPAddressLV().is_bound()) field_pDPAddressLV = other_value.pDPAddressLV();
else field_pDPAddressLV.clean_up();
}

void PDPAddressTLV::clean_up()
{
field_elementIdentifier.clean_up();
field_pDPAddressLV.clean_up();
}

const TTCN_Typedescriptor_t* PDPAddressTLV::get_descriptor() const { return &PDPAddressTLV_descr_; }
PDPAddressTLV& PDPAddressTLV::operator=(const PDPAddressTLV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.PDPAddressTLV.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.pDPAddressLV().is_bound()) field_pDPAddressLV = other_value.pDPAddressLV();
  else field_pDPAddressLV.clean_up();
}
return *this;
}

boolean PDPAddressTLV::operator==(const PDPAddressTLV& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_pDPAddressLV==other_value.field_pDPAddressLV;
}

boolean PDPAddressTLV::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_pDPAddressLV.is_bound());
}
boolean PDPAddressTLV::is_value() const
{
return field_elementIdentifier.is_value()
  && field_pDPAddressLV.is_value();
}
void PDPAddressTLV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", pDPAddressLV := ");
field_pDPAddressLV.log();
TTCN_Logger::log_event_str(" }");
}

void PDPAddressTLV::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (pDPAddressLV().is_bound()) pDPAddressLV().set_implicit_omit();
}

void PDPAddressTLV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.PDPAddressTLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) pDPAddressLV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pDPAddressLV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pDPAddressLV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDPAddressTLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.PDPAddressTLV");
  }
}

void PDPAddressTLV::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_pDPAddressLV.encode_text(text_buf);
}

void PDPAddressTLV::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_pDPAddressLV.decode_text(text_buf);
}

void PDPAddressTLV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDPAddressTLV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDPAddressTLV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, PDPAddressLV_descr_.raw->forceomit);
  decoded_field_length = field_pDPAddressLV.RAW_decode(PDPAddressLV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_elementIdentifier !=  os_9) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDPAddressTLV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, PDPAddressLV_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_pDPAddressLV.RAW_encode(PDPAddressLV_descr_, *myleaf.body.node.nodes[1]);
  if (field_elementIdentifier !=  os_9) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_9.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDPAddressTLV_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
PDPAddressLV_template field_pDPAddressLV;
};

void PDPAddressTLV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_pDPAddressLV = ANY_VALUE;
}
}
}

void PDPAddressTLV_template::copy_value(const PDPAddressTLV& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.pDPAddressLV().is_bound()) {
  single_value->field_pDPAddressLV = other_value.pDPAddressLV();
} else {
  single_value->field_pDPAddressLV.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDPAddressTLV_template::copy_template(const PDPAddressTLV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pDPAddressLV().get_selection()) {
single_value->field_pDPAddressLV = other_value.pDPAddressLV();
} else {
single_value->field_pDPAddressLV.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDPAddressTLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDPAddressTLV_template(*other_value.implication_.precondition);
implication_.implied_template = new PDPAddressTLV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDPAddressTLV.");
break;
}
set_selection(other_value);
}

PDPAddressTLV_template::PDPAddressTLV_template()
{
}

PDPAddressTLV_template::PDPAddressTLV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDPAddressTLV_template::PDPAddressTLV_template(const PDPAddressTLV& other_value)
{
copy_value(other_value);
}

PDPAddressTLV_template::PDPAddressTLV_template(const OPTIONAL<PDPAddressTLV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDPAddressTLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.PDPAddressTLV from an unbound optional field.");
}
}

PDPAddressTLV_template::PDPAddressTLV_template(PDPAddressTLV_template* p_precondition, PDPAddressTLV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDPAddressTLV_template::PDPAddressTLV_template(Dynamic_Match_Interface<PDPAddressTLV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDPAddressTLV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDPAddressTLV_template::PDPAddressTLV_template(const PDPAddressTLV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDPAddressTLV_template::~PDPAddressTLV_template()
{
clean_up();
}

PDPAddressTLV_template& PDPAddressTLV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDPAddressTLV_template& PDPAddressTLV_template::operator=(const PDPAddressTLV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDPAddressTLV_template& PDPAddressTLV_template::operator=(const OPTIONAL<PDPAddressTLV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDPAddressTLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.PDPAddressTLV.");
}
return *this;
}

PDPAddressTLV_template& PDPAddressTLV_template::operator=(const PDPAddressTLV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDPAddressTLV_template::match(const PDPAddressTLV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.pDPAddressLV().is_bound()) return FALSE;
if(!single_value->field_pDPAddressLV.match(other_value.pDPAddressLV(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDPAddressTLV.");
}
return FALSE;
}

boolean PDPAddressTLV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_pDPAddressLV.is_bound();
}

boolean PDPAddressTLV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_pDPAddressLV.is_value();
}

void PDPAddressTLV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDPAddressTLV PDPAddressTLV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.PDPAddressTLV.");
PDPAddressTLV ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_pDPAddressLV.is_bound()) {
ret_val.pDPAddressLV() = single_value->field_pDPAddressLV.valueof();
}
return ret_val;
}

void PDPAddressTLV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.PDPAddressTLV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDPAddressTLV_template[list_length];
}

PDPAddressTLV_template& PDPAddressTLV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.PDPAddressTLV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.PDPAddressTLV.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDPAddressTLV_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& PDPAddressTLV_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_GMM_SM_Types.PDPAddressTLV.");
return single_value->field_elementIdentifier;
}

PDPAddressLV_template& PDPAddressTLV_template::pDPAddressLV()
{
set_specific();
return single_value->field_pDPAddressLV;
}

const PDPAddressLV_template& PDPAddressTLV_template::pDPAddressLV() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pDPAddressLV of a non-specific template of type @MobileL3_GMM_SM_Types.PDPAddressTLV.");
return single_value->field_pDPAddressLV;
}

int PDPAddressTLV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressTLV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressTLV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressTLV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressTLV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressTLV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressTLV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressTLV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressTLV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.PDPAddressTLV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDPAddressTLV.");
  }
  return 0;
}

void PDPAddressTLV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", pDPAddressLV := ");
single_value->field_pDPAddressLV.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDPAddressTLV_template::log_match(const PDPAddressTLV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_pDPAddressLV.match(match_value.pDPAddressLV(), legacy)){
TTCN_Logger::log_logmatch_info(".pDPAddressLV");
single_value->field_pDPAddressLV.log_match(match_value.pDPAddressLV(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", pDPAddressLV := ");
single_value->field_pDPAddressLV.log_match(match_value.pDPAddressLV(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDPAddressTLV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_pDPAddressLV.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.PDPAddressTLV.");
}
}

void PDPAddressTLV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_pDPAddressLV.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDPAddressTLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.PDPAddressTLV.");
}
}

void PDPAddressTLV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDPAddressTLV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.PDPAddressTLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) pDPAddressLV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pDPAddressLV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pDPAddressLV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.PDPAddressTLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDPAddressTLV_template* precondition = new PDPAddressTLV_template;
    precondition->set_param(*param.get_elem(0));
    PDPAddressTLV_template* implied_template = new PDPAddressTLV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDPAddressTLV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.PDPAddressTLV");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDPAddressTLV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDPAddressTLV");
single_value->field_pDPAddressLV.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.PDPAddressTLV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.PDPAddressTLV");
}

boolean PDPAddressTLV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDPAddressTLV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

QoSV::QoSV()
{
}

QoSV::QoSV(const BITSTRING& par_reliabilityClass,
    const BITSTRING& par_delayClass,
    const BITSTRING& par_spare1,
    const BITSTRING& par_precedenceClass,
    const BITSTRING& par_spare2,
    const BITSTRING& par_peakThroughput,
    const BITSTRING& par_meanThroughput,
    const BITSTRING& par_spare3,
    const OPTIONAL< BITSTRING >& par_deliverErroneusSDU,
    const OPTIONAL< BITSTRING >& par_deliveryOrder,
    const OPTIONAL< BITSTRING >& par_trafficClass,
    const OPTIONAL< OCTETSTRING >& par_maxSDUSize,
    const OPTIONAL< OCTETSTRING >& par_maxBitrateUplink,
    const OPTIONAL< OCTETSTRING >& par_maxBitrateDownlink,
    const OPTIONAL< BITSTRING >& par_sduErrorRatio,
    const OPTIONAL< BITSTRING >& par_residualBER,
    const OPTIONAL< BITSTRING >& par_trafficHandlingPriority,
    const OPTIONAL< BITSTRING >& par_transferDelay,
    const OPTIONAL< OCTETSTRING >& par_guaranteedBitRateUplink,
    const OPTIONAL< OCTETSTRING >& par_guaranteedBitRateDownlink,
    const OPTIONAL< BITSTRING >& par_sourceStatisticsDescriptor,
    const OPTIONAL< BITSTRING >& par_signallingIndication,
    const OPTIONAL< BITSTRING >& par_spare4,
    const OPTIONAL< OCTETSTRING >& par_maxBitrateDownlinkExt,
    const OPTIONAL< OCTETSTRING >& par_guaranteedBitRateDownlinkExt,
    const OPTIONAL< OCTETSTRING >& par_maxBitrateUplinkExt,
    const OPTIONAL< OCTETSTRING >& par_guaranteedBitRateUplinkExt,
    const OPTIONAL< OCTETSTRING >& par_maxBitrateDownlinkExt2,
    const OPTIONAL< OCTETSTRING >& par_guaranteedBitRateDownlinkExt2,
    const OPTIONAL< OCTETSTRING >& par_maxBitrateUplinkExt2,
    const OPTIONAL< OCTETSTRING >& par_guaranteedBitRateUplinkExt2)
  :   field_reliabilityClass(par_reliabilityClass),
  field_delayClass(par_delayClass),
  field_spare1(par_spare1),
  field_precedenceClass(par_precedenceClass),
  field_spare2(par_spare2),
  field_peakThroughput(par_peakThroughput),
  field_meanThroughput(par_meanThroughput),
  field_spare3(par_spare3),
  field_deliverErroneusSDU(par_deliverErroneusSDU),
  field_deliveryOrder(par_deliveryOrder),
  field_trafficClass(par_trafficClass),
  field_maxSDUSize(par_maxSDUSize),
  field_maxBitrateUplink(par_maxBitrateUplink),
  field_maxBitrateDownlink(par_maxBitrateDownlink),
  field_sduErrorRatio(par_sduErrorRatio),
  field_residualBER(par_residualBER),
  field_trafficHandlingPriority(par_trafficHandlingPriority),
  field_transferDelay(par_transferDelay),
  field_guaranteedBitRateUplink(par_guaranteedBitRateUplink),
  field_guaranteedBitRateDownlink(par_guaranteedBitRateDownlink),
  field_sourceStatisticsDescriptor(par_sourceStatisticsDescriptor),
  field_signallingIndication(par_signallingIndication),
  field_spare4(par_spare4),
  field_maxBitrateDownlinkExt(par_maxBitrateDownlinkExt),
  field_guaranteedBitRateDownlinkExt(par_guaranteedBitRateDownlinkExt),
  field_maxBitrateUplinkExt(par_maxBitrateUplinkExt),
  field_guaranteedBitRateUplinkExt(par_guaranteedBitRateUplinkExt),
  field_maxBitrateDownlinkExt2(par_maxBitrateDownlinkExt2),
  field_guaranteedBitRateDownlinkExt2(par_guaranteedBitRateDownlinkExt2),
  field_maxBitrateUplinkExt2(par_maxBitrateUplinkExt2),
  field_guaranteedBitRateUplinkExt2(par_guaranteedBitRateUplinkExt2)
{
}

QoSV::QoSV(const QoSV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.QoSV.");
if (other_value.reliabilityClass().is_bound()) field_reliabilityClass = other_value.reliabilityClass();
else field_reliabilityClass.clean_up();
if (other_value.delayClass().is_bound()) field_delayClass = other_value.delayClass();
else field_delayClass.clean_up();
if (other_value.spare1().is_bound()) field_spare1 = other_value.spare1();
else field_spare1.clean_up();
if (other_value.precedenceClass().is_bound()) field_precedenceClass = other_value.precedenceClass();
else field_precedenceClass.clean_up();
if (other_value.spare2().is_bound()) field_spare2 = other_value.spare2();
else field_spare2.clean_up();
if (other_value.peakThroughput().is_bound()) field_peakThroughput = other_value.peakThroughput();
else field_peakThroughput.clean_up();
if (other_value.meanThroughput().is_bound()) field_meanThroughput = other_value.meanThroughput();
else field_meanThroughput.clean_up();
if (other_value.spare3().is_bound()) field_spare3 = other_value.spare3();
else field_spare3.clean_up();
if (other_value.deliverErroneusSDU().is_bound()) field_deliverErroneusSDU = other_value.deliverErroneusSDU();
else field_deliverErroneusSDU.clean_up();
if (other_value.deliveryOrder().is_bound()) field_deliveryOrder = other_value.deliveryOrder();
else field_deliveryOrder.clean_up();
if (other_value.trafficClass().is_bound()) field_trafficClass = other_value.trafficClass();
else field_trafficClass.clean_up();
if (other_value.maxSDUSize().is_bound()) field_maxSDUSize = other_value.maxSDUSize();
else field_maxSDUSize.clean_up();
if (other_value.maxBitrateUplink().is_bound()) field_maxBitrateUplink = other_value.maxBitrateUplink();
else field_maxBitrateUplink.clean_up();
if (other_value.maxBitrateDownlink().is_bound()) field_maxBitrateDownlink = other_value.maxBitrateDownlink();
else field_maxBitrateDownlink.clean_up();
if (other_value.sduErrorRatio().is_bound()) field_sduErrorRatio = other_value.sduErrorRatio();
else field_sduErrorRatio.clean_up();
if (other_value.residualBER().is_bound()) field_residualBER = other_value.residualBER();
else field_residualBER.clean_up();
if (other_value.trafficHandlingPriority().is_bound()) field_trafficHandlingPriority = other_value.trafficHandlingPriority();
else field_trafficHandlingPriority.clean_up();
if (other_value.transferDelay().is_bound()) field_transferDelay = other_value.transferDelay();
else field_transferDelay.clean_up();
if (other_value.guaranteedBitRateUplink().is_bound()) field_guaranteedBitRateUplink = other_value.guaranteedBitRateUplink();
else field_guaranteedBitRateUplink.clean_up();
if (other_value.guaranteedBitRateDownlink().is_bound()) field_guaranteedBitRateDownlink = other_value.guaranteedBitRateDownlink();
else field_guaranteedBitRateDownlink.clean_up();
if (other_value.sourceStatisticsDescriptor().is_bound()) field_sourceStatisticsDescriptor = other_value.sourceStatisticsDescriptor();
else field_sourceStatisticsDescriptor.clean_up();
if (other_value.signallingIndication().is_bound()) field_signallingIndication = other_value.signallingIndication();
else field_signallingIndication.clean_up();
if (other_value.spare4().is_bound()) field_spare4 = other_value.spare4();
else field_spare4.clean_up();
if (other_value.maxBitrateDownlinkExt().is_bound()) field_maxBitrateDownlinkExt = other_value.maxBitrateDownlinkExt();
else field_maxBitrateDownlinkExt.clean_up();
if (other_value.guaranteedBitRateDownlinkExt().is_bound()) field_guaranteedBitRateDownlinkExt = other_value.guaranteedBitRateDownlinkExt();
else field_guaranteedBitRateDownlinkExt.clean_up();
if (other_value.maxBitrateUplinkExt().is_bound()) field_maxBitrateUplinkExt = other_value.maxBitrateUplinkExt();
else field_maxBitrateUplinkExt.clean_up();
if (other_value.guaranteedBitRateUplinkExt().is_bound()) field_guaranteedBitRateUplinkExt = other_value.guaranteedBitRateUplinkExt();
else field_guaranteedBitRateUplinkExt.clean_up();
if (other_value.maxBitrateDownlinkExt2().is_bound()) field_maxBitrateDownlinkExt2 = other_value.maxBitrateDownlinkExt2();
else field_maxBitrateDownlinkExt2.clean_up();
if (other_value.guaranteedBitRateDownlinkExt2().is_bound()) field_guaranteedBitRateDownlinkExt2 = other_value.guaranteedBitRateDownlinkExt2();
else field_guaranteedBitRateDownlinkExt2.clean_up();
if (other_value.maxBitrateUplinkExt2().is_bound()) field_maxBitrateUplinkExt2 = other_value.maxBitrateUplinkExt2();
else field_maxBitrateUplinkExt2.clean_up();
if (other_value.guaranteedBitRateUplinkExt2().is_bound()) field_guaranteedBitRateUplinkExt2 = other_value.guaranteedBitRateUplinkExt2();
else field_guaranteedBitRateUplinkExt2.clean_up();
}

void QoSV::clean_up()
{
field_reliabilityClass.clean_up();
field_delayClass.clean_up();
field_spare1.clean_up();
field_precedenceClass.clean_up();
field_spare2.clean_up();
field_peakThroughput.clean_up();
field_meanThroughput.clean_up();
field_spare3.clean_up();
field_deliverErroneusSDU.clean_up();
field_deliveryOrder.clean_up();
field_trafficClass.clean_up();
field_maxSDUSize.clean_up();
field_maxBitrateUplink.clean_up();
field_maxBitrateDownlink.clean_up();
field_sduErrorRatio.clean_up();
field_residualBER.clean_up();
field_trafficHandlingPriority.clean_up();
field_transferDelay.clean_up();
field_guaranteedBitRateUplink.clean_up();
field_guaranteedBitRateDownlink.clean_up();
field_sourceStatisticsDescriptor.clean_up();
field_signallingIndication.clean_up();
field_spare4.clean_up();
field_maxBitrateDownlinkExt.clean_up();
field_guaranteedBitRateDownlinkExt.clean_up();
field_maxBitrateUplinkExt.clean_up();
field_guaranteedBitRateUplinkExt.clean_up();
field_maxBitrateDownlinkExt2.clean_up();
field_guaranteedBitRateDownlinkExt2.clean_up();
field_maxBitrateUplinkExt2.clean_up();
field_guaranteedBitRateUplinkExt2.clean_up();
}

const TTCN_Typedescriptor_t* QoSV::get_descriptor() const { return &QoSV_descr_; }
QoSV& QoSV::operator=(const QoSV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.QoSV.");
  if (other_value.reliabilityClass().is_bound()) field_reliabilityClass = other_value.reliabilityClass();
  else field_reliabilityClass.clean_up();
  if (other_value.delayClass().is_bound()) field_delayClass = other_value.delayClass();
  else field_delayClass.clean_up();
  if (other_value.spare1().is_bound()) field_spare1 = other_value.spare1();
  else field_spare1.clean_up();
  if (other_value.precedenceClass().is_bound()) field_precedenceClass = other_value.precedenceClass();
  else field_precedenceClass.clean_up();
  if (other_value.spare2().is_bound()) field_spare2 = other_value.spare2();
  else field_spare2.clean_up();
  if (other_value.peakThroughput().is_bound()) field_peakThroughput = other_value.peakThroughput();
  else field_peakThroughput.clean_up();
  if (other_value.meanThroughput().is_bound()) field_meanThroughput = other_value.meanThroughput();
  else field_meanThroughput.clean_up();
  if (other_value.spare3().is_bound()) field_spare3 = other_value.spare3();
  else field_spare3.clean_up();
  if (other_value.deliverErroneusSDU().is_bound()) field_deliverErroneusSDU = other_value.deliverErroneusSDU();
  else field_deliverErroneusSDU.clean_up();
  if (other_value.deliveryOrder().is_bound()) field_deliveryOrder = other_value.deliveryOrder();
  else field_deliveryOrder.clean_up();
  if (other_value.trafficClass().is_bound()) field_trafficClass = other_value.trafficClass();
  else field_trafficClass.clean_up();
  if (other_value.maxSDUSize().is_bound()) field_maxSDUSize = other_value.maxSDUSize();
  else field_maxSDUSize.clean_up();
  if (other_value.maxBitrateUplink().is_bound()) field_maxBitrateUplink = other_value.maxBitrateUplink();
  else field_maxBitrateUplink.clean_up();
  if (other_value.maxBitrateDownlink().is_bound()) field_maxBitrateDownlink = other_value.maxBitrateDownlink();
  else field_maxBitrateDownlink.clean_up();
  if (other_value.sduErrorRatio().is_bound()) field_sduErrorRatio = other_value.sduErrorRatio();
  else field_sduErrorRatio.clean_up();
  if (other_value.residualBER().is_bound()) field_residualBER = other_value.residualBER();
  else field_residualBER.clean_up();
  if (other_value.trafficHandlingPriority().is_bound()) field_trafficHandlingPriority = other_value.trafficHandlingPriority();
  else field_trafficHandlingPriority.clean_up();
  if (other_value.transferDelay().is_bound()) field_transferDelay = other_value.transferDelay();
  else field_transferDelay.clean_up();
  if (other_value.guaranteedBitRateUplink().is_bound()) field_guaranteedBitRateUplink = other_value.guaranteedBitRateUplink();
  else field_guaranteedBitRateUplink.clean_up();
  if (other_value.guaranteedBitRateDownlink().is_bound()) field_guaranteedBitRateDownlink = other_value.guaranteedBitRateDownlink();
  else field_guaranteedBitRateDownlink.clean_up();
  if (other_value.sourceStatisticsDescriptor().is_bound()) field_sourceStatisticsDescriptor = other_value.sourceStatisticsDescriptor();
  else field_sourceStatisticsDescriptor.clean_up();
  if (other_value.signallingIndication().is_bound()) field_signallingIndication = other_value.signallingIndication();
  else field_signallingIndication.clean_up();
  if (other_value.spare4().is_bound()) field_spare4 = other_value.spare4();
  else field_spare4.clean_up();
  if (other_value.maxBitrateDownlinkExt().is_bound()) field_maxBitrateDownlinkExt = other_value.maxBitrateDownlinkExt();
  else field_maxBitrateDownlinkExt.clean_up();
  if (other_value.guaranteedBitRateDownlinkExt().is_bound()) field_guaranteedBitRateDownlinkExt = other_value.guaranteedBitRateDownlinkExt();
  else field_guaranteedBitRateDownlinkExt.clean_up();
  if (other_value.maxBitrateUplinkExt().is_bound()) field_maxBitrateUplinkExt = other_value.maxBitrateUplinkExt();
  else field_maxBitrateUplinkExt.clean_up();
  if (other_value.guaranteedBitRateUplinkExt().is_bound()) field_guaranteedBitRateUplinkExt = other_value.guaranteedBitRateUplinkExt();
  else field_guaranteedBitRateUplinkExt.clean_up();
  if (other_value.maxBitrateDownlinkExt2().is_bound()) field_maxBitrateDownlinkExt2 = other_value.maxBitrateDownlinkExt2();
  else field_maxBitrateDownlinkExt2.clean_up();
  if (other_value.guaranteedBitRateDownlinkExt2().is_bound()) field_guaranteedBitRateDownlinkExt2 = other_value.guaranteedBitRateDownlinkExt2();
  else field_guaranteedBitRateDownlinkExt2.clean_up();
  if (other_value.maxBitrateUplinkExt2().is_bound()) field_maxBitrateUplinkExt2 = other_value.maxBitrateUplinkExt2();
  else field_maxBitrateUplinkExt2.clean_up();
  if (other_value.guaranteedBitRateUplinkExt2().is_bound()) field_guaranteedBitRateUplinkExt2 = other_value.guaranteedBitRateUplinkExt2();
  else field_guaranteedBitRateUplinkExt2.clean_up();
}
return *this;
}

boolean QoSV::operator==(const QoSV& other_value) const
{
return field_reliabilityClass==other_value.field_reliabilityClass
  && field_delayClass==other_value.field_delayClass
  && field_spare1==other_value.field_spare1
  && field_precedenceClass==other_value.field_precedenceClass
  && field_spare2==other_value.field_spare2
  && field_peakThroughput==other_value.field_peakThroughput
  && field_meanThroughput==other_value.field_meanThroughput
  && field_spare3==other_value.field_spare3
  && field_deliverErroneusSDU==other_value.field_deliverErroneusSDU
  && field_deliveryOrder==other_value.field_deliveryOrder
  && field_trafficClass==other_value.field_trafficClass
  && field_maxSDUSize==other_value.field_maxSDUSize
  && field_maxBitrateUplink==other_value.field_maxBitrateUplink
  && field_maxBitrateDownlink==other_value.field_maxBitrateDownlink
  && field_sduErrorRatio==other_value.field_sduErrorRatio
  && field_residualBER==other_value.field_residualBER
  && field_trafficHandlingPriority==other_value.field_trafficHandlingPriority
  && field_transferDelay==other_value.field_transferDelay
  && field_guaranteedBitRateUplink==other_value.field_guaranteedBitRateUplink
  && field_guaranteedBitRateDownlink==other_value.field_guaranteedBitRateDownlink
  && field_sourceStatisticsDescriptor==other_value.field_sourceStatisticsDescriptor
  && field_signallingIndication==other_value.field_signallingIndication
  && field_spare4==other_value.field_spare4
  && field_maxBitrateDownlinkExt==other_value.field_maxBitrateDownlinkExt
  && field_guaranteedBitRateDownlinkExt==other_value.field_guaranteedBitRateDownlinkExt
  && field_maxBitrateUplinkExt==other_value.field_maxBitrateUplinkExt
  && field_guaranteedBitRateUplinkExt==other_value.field_guaranteedBitRateUplinkExt
  && field_maxBitrateDownlinkExt2==other_value.field_maxBitrateDownlinkExt2
  && field_guaranteedBitRateDownlinkExt2==other_value.field_guaranteedBitRateDownlinkExt2
  && field_maxBitrateUplinkExt2==other_value.field_maxBitrateUplinkExt2
  && field_guaranteedBitRateUplinkExt2==other_value.field_guaranteedBitRateUplinkExt2;
}

boolean QoSV::is_bound() const
{
return (field_reliabilityClass.is_bound())
  || (field_delayClass.is_bound())
  || (field_spare1.is_bound())
  || (field_precedenceClass.is_bound())
  || (field_spare2.is_bound())
  || (field_peakThroughput.is_bound())
  || (field_meanThroughput.is_bound())
  || (field_spare3.is_bound())
  || (OPTIONAL_OMIT == field_deliverErroneusSDU.get_selection() || field_deliverErroneusSDU.is_bound())
  || (OPTIONAL_OMIT == field_deliveryOrder.get_selection() || field_deliveryOrder.is_bound())
  || (OPTIONAL_OMIT == field_trafficClass.get_selection() || field_trafficClass.is_bound())
  || (OPTIONAL_OMIT == field_maxSDUSize.get_selection() || field_maxSDUSize.is_bound())
  || (OPTIONAL_OMIT == field_maxBitrateUplink.get_selection() || field_maxBitrateUplink.is_bound())
  || (OPTIONAL_OMIT == field_maxBitrateDownlink.get_selection() || field_maxBitrateDownlink.is_bound())
  || (OPTIONAL_OMIT == field_sduErrorRatio.get_selection() || field_sduErrorRatio.is_bound())
  || (OPTIONAL_OMIT == field_residualBER.get_selection() || field_residualBER.is_bound())
  || (OPTIONAL_OMIT == field_trafficHandlingPriority.get_selection() || field_trafficHandlingPriority.is_bound())
  || (OPTIONAL_OMIT == field_transferDelay.get_selection() || field_transferDelay.is_bound())
  || (OPTIONAL_OMIT == field_guaranteedBitRateUplink.get_selection() || field_guaranteedBitRateUplink.is_bound())
  || (OPTIONAL_OMIT == field_guaranteedBitRateDownlink.get_selection() || field_guaranteedBitRateDownlink.is_bound())
  || (OPTIONAL_OMIT == field_sourceStatisticsDescriptor.get_selection() || field_sourceStatisticsDescriptor.is_bound())
  || (OPTIONAL_OMIT == field_signallingIndication.get_selection() || field_signallingIndication.is_bound())
  || (OPTIONAL_OMIT == field_spare4.get_selection() || field_spare4.is_bound())
  || (OPTIONAL_OMIT == field_maxBitrateDownlinkExt.get_selection() || field_maxBitrateDownlinkExt.is_bound())
  || (OPTIONAL_OMIT == field_guaranteedBitRateDownlinkExt.get_selection() || field_guaranteedBitRateDownlinkExt.is_bound())
  || (OPTIONAL_OMIT == field_maxBitrateUplinkExt.get_selection() || field_maxBitrateUplinkExt.is_bound())
  || (OPTIONAL_OMIT == field_guaranteedBitRateUplinkExt.get_selection() || field_guaranteedBitRateUplinkExt.is_bound())
  || (OPTIONAL_OMIT == field_maxBitrateDownlinkExt2.get_selection() || field_maxBitrateDownlinkExt2.is_bound())
  || (OPTIONAL_OMIT == field_guaranteedBitRateDownlinkExt2.get_selection() || field_guaranteedBitRateDownlinkExt2.is_bound())
  || (OPTIONAL_OMIT == field_maxBitrateUplinkExt2.get_selection() || field_maxBitrateUplinkExt2.is_bound())
  || (OPTIONAL_OMIT == field_guaranteedBitRateUplinkExt2.get_selection() || field_guaranteedBitRateUplinkExt2.is_bound());
}
boolean QoSV::is_value() const
{
return field_reliabilityClass.is_value()
  && field_delayClass.is_value()
  && field_spare1.is_value()
  && field_precedenceClass.is_value()
  && field_spare2.is_value()
  && field_peakThroughput.is_value()
  && field_meanThroughput.is_value()
  && field_spare3.is_value()
  && (OPTIONAL_OMIT == field_deliverErroneusSDU.get_selection() || field_deliverErroneusSDU.is_value())
  && (OPTIONAL_OMIT == field_deliveryOrder.get_selection() || field_deliveryOrder.is_value())
  && (OPTIONAL_OMIT == field_trafficClass.get_selection() || field_trafficClass.is_value())
  && (OPTIONAL_OMIT == field_maxSDUSize.get_selection() || field_maxSDUSize.is_value())
  && (OPTIONAL_OMIT == field_maxBitrateUplink.get_selection() || field_maxBitrateUplink.is_value())
  && (OPTIONAL_OMIT == field_maxBitrateDownlink.get_selection() || field_maxBitrateDownlink.is_value())
  && (OPTIONAL_OMIT == field_sduErrorRatio.get_selection() || field_sduErrorRatio.is_value())
  && (OPTIONAL_OMIT == field_residualBER.get_selection() || field_residualBER.is_value())
  && (OPTIONAL_OMIT == field_trafficHandlingPriority.get_selection() || field_trafficHandlingPriority.is_value())
  && (OPTIONAL_OMIT == field_transferDelay.get_selection() || field_transferDelay.is_value())
  && (OPTIONAL_OMIT == field_guaranteedBitRateUplink.get_selection() || field_guaranteedBitRateUplink.is_value())
  && (OPTIONAL_OMIT == field_guaranteedBitRateDownlink.get_selection() || field_guaranteedBitRateDownlink.is_value())
  && (OPTIONAL_OMIT == field_sourceStatisticsDescriptor.get_selection() || field_sourceStatisticsDescriptor.is_value())
  && (OPTIONAL_OMIT == field_signallingIndication.get_selection() || field_signallingIndication.is_value())
  && (OPTIONAL_OMIT == field_spare4.get_selection() || field_spare4.is_value())
  && (OPTIONAL_OMIT == field_maxBitrateDownlinkExt.get_selection() || field_maxBitrateDownlinkExt.is_value())
  && (OPTIONAL_OMIT == field_guaranteedBitRateDownlinkExt.get_selection() || field_guaranteedBitRateDownlinkExt.is_value())
  && (OPTIONAL_OMIT == field_maxBitrateUplinkExt.get_selection() || field_maxBitrateUplinkExt.is_value())
  && (OPTIONAL_OMIT == field_guaranteedBitRateUplinkExt.get_selection() || field_guaranteedBitRateUplinkExt.is_value())
  && (OPTIONAL_OMIT == field_maxBitrateDownlinkExt2.get_selection() || field_maxBitrateDownlinkExt2.is_value())
  && (OPTIONAL_OMIT == field_guaranteedBitRateDownlinkExt2.get_selection() || field_guaranteedBitRateDownlinkExt2.is_value())
  && (OPTIONAL_OMIT == field_maxBitrateUplinkExt2.get_selection() || field_maxBitrateUplinkExt2.is_value())
  && (OPTIONAL_OMIT == field_guaranteedBitRateUplinkExt2.get_selection() || field_guaranteedBitRateUplinkExt2.is_value());
}
int QoSV::size_of() const
{
  int ret_val = 8;
  if (field_deliverErroneusSDU.ispresent()) ret_val++;
  if (field_deliveryOrder.ispresent()) ret_val++;
  if (field_trafficClass.ispresent()) ret_val++;
  if (field_maxSDUSize.ispresent()) ret_val++;
  if (field_maxBitrateUplink.ispresent()) ret_val++;
  if (field_maxBitrateDownlink.ispresent()) ret_val++;
  if (field_sduErrorRatio.ispresent()) ret_val++;
  if (field_residualBER.ispresent()) ret_val++;
  if (field_trafficHandlingPriority.ispresent()) ret_val++;
  if (field_transferDelay.ispresent()) ret_val++;
  if (field_guaranteedBitRateUplink.ispresent()) ret_val++;
  if (field_guaranteedBitRateDownlink.ispresent()) ret_val++;
  if (field_sourceStatisticsDescriptor.ispresent()) ret_val++;
  if (field_signallingIndication.ispresent()) ret_val++;
  if (field_spare4.ispresent()) ret_val++;
  if (field_maxBitrateDownlinkExt.ispresent()) ret_val++;
  if (field_guaranteedBitRateDownlinkExt.ispresent()) ret_val++;
  if (field_maxBitrateUplinkExt.ispresent()) ret_val++;
  if (field_guaranteedBitRateUplinkExt.ispresent()) ret_val++;
  if (field_maxBitrateDownlinkExt2.ispresent()) ret_val++;
  if (field_guaranteedBitRateDownlinkExt2.ispresent()) ret_val++;
  if (field_maxBitrateUplinkExt2.ispresent()) ret_val++;
  if (field_guaranteedBitRateUplinkExt2.ispresent()) ret_val++;
  return ret_val;
}

void QoSV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ reliabilityClass := ");
field_reliabilityClass.log();
TTCN_Logger::log_event_str(", delayClass := ");
field_delayClass.log();
TTCN_Logger::log_event_str(", spare1 := ");
field_spare1.log();
TTCN_Logger::log_event_str(", precedenceClass := ");
field_precedenceClass.log();
TTCN_Logger::log_event_str(", spare2 := ");
field_spare2.log();
TTCN_Logger::log_event_str(", peakThroughput := ");
field_peakThroughput.log();
TTCN_Logger::log_event_str(", meanThroughput := ");
field_meanThroughput.log();
TTCN_Logger::log_event_str(", spare3 := ");
field_spare3.log();
TTCN_Logger::log_event_str(", deliverErroneusSDU := ");
field_deliverErroneusSDU.log();
TTCN_Logger::log_event_str(", deliveryOrder := ");
field_deliveryOrder.log();
TTCN_Logger::log_event_str(", trafficClass := ");
field_trafficClass.log();
TTCN_Logger::log_event_str(", maxSDUSize := ");
field_maxSDUSize.log();
TTCN_Logger::log_event_str(", maxBitrateUplink := ");
field_maxBitrateUplink.log();
TTCN_Logger::log_event_str(", maxBitrateDownlink := ");
field_maxBitrateDownlink.log();
TTCN_Logger::log_event_str(", sduErrorRatio := ");
field_sduErrorRatio.log();
TTCN_Logger::log_event_str(", residualBER := ");
field_residualBER.log();
TTCN_Logger::log_event_str(", trafficHandlingPriority := ");
field_trafficHandlingPriority.log();
TTCN_Logger::log_event_str(", transferDelay := ");
field_transferDelay.log();
TTCN_Logger::log_event_str(", guaranteedBitRateUplink := ");
field_guaranteedBitRateUplink.log();
TTCN_Logger::log_event_str(", guaranteedBitRateDownlink := ");
field_guaranteedBitRateDownlink.log();
TTCN_Logger::log_event_str(", sourceStatisticsDescriptor := ");
field_sourceStatisticsDescriptor.log();
TTCN_Logger::log_event_str(", signallingIndication := ");
field_signallingIndication.log();
TTCN_Logger::log_event_str(", spare4 := ");
field_spare4.log();
TTCN_Logger::log_event_str(", maxBitrateDownlinkExt := ");
field_maxBitrateDownlinkExt.log();
TTCN_Logger::log_event_str(", guaranteedBitRateDownlinkExt := ");
field_guaranteedBitRateDownlinkExt.log();
TTCN_Logger::log_event_str(", maxBitrateUplinkExt := ");
field_maxBitrateUplinkExt.log();
TTCN_Logger::log_event_str(", guaranteedBitRateUplinkExt := ");
field_guaranteedBitRateUplinkExt.log();
TTCN_Logger::log_event_str(", maxBitrateDownlinkExt2 := ");
field_maxBitrateDownlinkExt2.log();
TTCN_Logger::log_event_str(", guaranteedBitRateDownlinkExt2 := ");
field_guaranteedBitRateDownlinkExt2.log();
TTCN_Logger::log_event_str(", maxBitrateUplinkExt2 := ");
field_maxBitrateUplinkExt2.log();
TTCN_Logger::log_event_str(", guaranteedBitRateUplinkExt2 := ");
field_guaranteedBitRateUplinkExt2.log();
TTCN_Logger::log_event_str(" }");
}

void QoSV::set_implicit_omit()
{
if (reliabilityClass().is_bound()) reliabilityClass().set_implicit_omit();
if (delayClass().is_bound()) delayClass().set_implicit_omit();
if (spare1().is_bound()) spare1().set_implicit_omit();
if (precedenceClass().is_bound()) precedenceClass().set_implicit_omit();
if (spare2().is_bound()) spare2().set_implicit_omit();
if (peakThroughput().is_bound()) peakThroughput().set_implicit_omit();
if (meanThroughput().is_bound()) meanThroughput().set_implicit_omit();
if (spare3().is_bound()) spare3().set_implicit_omit();
if (!deliverErroneusSDU().is_bound()) deliverErroneusSDU() = OMIT_VALUE;
else deliverErroneusSDU().set_implicit_omit();
if (!deliveryOrder().is_bound()) deliveryOrder() = OMIT_VALUE;
else deliveryOrder().set_implicit_omit();
if (!trafficClass().is_bound()) trafficClass() = OMIT_VALUE;
else trafficClass().set_implicit_omit();
if (!maxSDUSize().is_bound()) maxSDUSize() = OMIT_VALUE;
else maxSDUSize().set_implicit_omit();
if (!maxBitrateUplink().is_bound()) maxBitrateUplink() = OMIT_VALUE;
else maxBitrateUplink().set_implicit_omit();
if (!maxBitrateDownlink().is_bound()) maxBitrateDownlink() = OMIT_VALUE;
else maxBitrateDownlink().set_implicit_omit();
if (!sduErrorRatio().is_bound()) sduErrorRatio() = OMIT_VALUE;
else sduErrorRatio().set_implicit_omit();
if (!residualBER().is_bound()) residualBER() = OMIT_VALUE;
else residualBER().set_implicit_omit();
if (!trafficHandlingPriority().is_bound()) trafficHandlingPriority() = OMIT_VALUE;
else trafficHandlingPriority().set_implicit_omit();
if (!transferDelay().is_bound()) transferDelay() = OMIT_VALUE;
else transferDelay().set_implicit_omit();
if (!guaranteedBitRateUplink().is_bound()) guaranteedBitRateUplink() = OMIT_VALUE;
else guaranteedBitRateUplink().set_implicit_omit();
if (!guaranteedBitRateDownlink().is_bound()) guaranteedBitRateDownlink() = OMIT_VALUE;
else guaranteedBitRateDownlink().set_implicit_omit();
if (!sourceStatisticsDescriptor().is_bound()) sourceStatisticsDescriptor() = OMIT_VALUE;
else sourceStatisticsDescriptor().set_implicit_omit();
if (!signallingIndication().is_bound()) signallingIndication() = OMIT_VALUE;
else signallingIndication().set_implicit_omit();
if (!spare4().is_bound()) spare4() = OMIT_VALUE;
else spare4().set_implicit_omit();
if (!maxBitrateDownlinkExt().is_bound()) maxBitrateDownlinkExt() = OMIT_VALUE;
else maxBitrateDownlinkExt().set_implicit_omit();
if (!guaranteedBitRateDownlinkExt().is_bound()) guaranteedBitRateDownlinkExt() = OMIT_VALUE;
else guaranteedBitRateDownlinkExt().set_implicit_omit();
if (!maxBitrateUplinkExt().is_bound()) maxBitrateUplinkExt() = OMIT_VALUE;
else maxBitrateUplinkExt().set_implicit_omit();
if (!guaranteedBitRateUplinkExt().is_bound()) guaranteedBitRateUplinkExt() = OMIT_VALUE;
else guaranteedBitRateUplinkExt().set_implicit_omit();
if (!maxBitrateDownlinkExt2().is_bound()) maxBitrateDownlinkExt2() = OMIT_VALUE;
else maxBitrateDownlinkExt2().set_implicit_omit();
if (!guaranteedBitRateDownlinkExt2().is_bound()) guaranteedBitRateDownlinkExt2() = OMIT_VALUE;
else guaranteedBitRateDownlinkExt2().set_implicit_omit();
if (!maxBitrateUplinkExt2().is_bound()) maxBitrateUplinkExt2() = OMIT_VALUE;
else maxBitrateUplinkExt2().set_implicit_omit();
if (!guaranteedBitRateUplinkExt2().is_bound()) guaranteedBitRateUplinkExt2() = OMIT_VALUE;
else guaranteedBitRateUplinkExt2().set_implicit_omit();
}

void QoSV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (31<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.QoSV has 31 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) reliabilityClass().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) delayClass().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare1().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) precedenceClass().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) spare2().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) peakThroughput().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) meanThroughput().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) spare3().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) deliverErroneusSDU().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) deliveryOrder().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) trafficClass().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) maxSDUSize().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) maxBitrateUplink().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) maxBitrateDownlink().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) sduErrorRatio().set_param(*param.get_elem(14));
    if (param.get_size()>15 && param.get_elem(15)->get_type()!=Module_Param::MP_NotUsed) residualBER().set_param(*param.get_elem(15));
    if (param.get_size()>16 && param.get_elem(16)->get_type()!=Module_Param::MP_NotUsed) trafficHandlingPriority().set_param(*param.get_elem(16));
    if (param.get_size()>17 && param.get_elem(17)->get_type()!=Module_Param::MP_NotUsed) transferDelay().set_param(*param.get_elem(17));
    if (param.get_size()>18 && param.get_elem(18)->get_type()!=Module_Param::MP_NotUsed) guaranteedBitRateUplink().set_param(*param.get_elem(18));
    if (param.get_size()>19 && param.get_elem(19)->get_type()!=Module_Param::MP_NotUsed) guaranteedBitRateDownlink().set_param(*param.get_elem(19));
    if (param.get_size()>20 && param.get_elem(20)->get_type()!=Module_Param::MP_NotUsed) sourceStatisticsDescriptor().set_param(*param.get_elem(20));
    if (param.get_size()>21 && param.get_elem(21)->get_type()!=Module_Param::MP_NotUsed) signallingIndication().set_param(*param.get_elem(21));
    if (param.get_size()>22 && param.get_elem(22)->get_type()!=Module_Param::MP_NotUsed) spare4().set_param(*param.get_elem(22));
    if (param.get_size()>23 && param.get_elem(23)->get_type()!=Module_Param::MP_NotUsed) maxBitrateDownlinkExt().set_param(*param.get_elem(23));
    if (param.get_size()>24 && param.get_elem(24)->get_type()!=Module_Param::MP_NotUsed) guaranteedBitRateDownlinkExt().set_param(*param.get_elem(24));
    if (param.get_size()>25 && param.get_elem(25)->get_type()!=Module_Param::MP_NotUsed) maxBitrateUplinkExt().set_param(*param.get_elem(25));
    if (param.get_size()>26 && param.get_elem(26)->get_type()!=Module_Param::MP_NotUsed) guaranteedBitRateUplinkExt().set_param(*param.get_elem(26));
    if (param.get_size()>27 && param.get_elem(27)->get_type()!=Module_Param::MP_NotUsed) maxBitrateDownlinkExt2().set_param(*param.get_elem(27));
    if (param.get_size()>28 && param.get_elem(28)->get_type()!=Module_Param::MP_NotUsed) guaranteedBitRateDownlinkExt2().set_param(*param.get_elem(28));
    if (param.get_size()>29 && param.get_elem(29)->get_type()!=Module_Param::MP_NotUsed) maxBitrateUplinkExt2().set_param(*param.get_elem(29));
    if (param.get_size()>30 && param.get_elem(30)->get_type()!=Module_Param::MP_NotUsed) guaranteedBitRateUplinkExt2().set_param(*param.get_elem(30));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reliabilityClass")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reliabilityClass().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "delayClass")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          delayClass().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "precedenceClass")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          precedenceClass().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "peakThroughput")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          peakThroughput().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "meanThroughput")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          meanThroughput().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare3")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare3().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "deliverErroneusSDU")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          deliverErroneusSDU().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "deliveryOrder")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          deliveryOrder().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "trafficClass")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          trafficClass().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "maxSDUSize")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          maxSDUSize().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "maxBitrateUplink")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          maxBitrateUplink().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "maxBitrateDownlink")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          maxBitrateDownlink().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sduErrorRatio")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sduErrorRatio().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "residualBER")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          residualBER().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "trafficHandlingPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          trafficHandlingPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "transferDelay")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          transferDelay().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "guaranteedBitRateUplink")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          guaranteedBitRateUplink().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "guaranteedBitRateDownlink")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          guaranteedBitRateDownlink().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sourceStatisticsDescriptor")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sourceStatisticsDescriptor().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "signallingIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          signallingIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare4")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare4().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "maxBitrateDownlinkExt")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          maxBitrateDownlinkExt().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "guaranteedBitRateDownlinkExt")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          guaranteedBitRateDownlinkExt().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "maxBitrateUplinkExt")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          maxBitrateUplinkExt().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "guaranteedBitRateUplinkExt")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          guaranteedBitRateUplinkExt().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "maxBitrateDownlinkExt2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          maxBitrateDownlinkExt2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "guaranteedBitRateDownlinkExt2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          guaranteedBitRateDownlinkExt2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "maxBitrateUplinkExt2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          maxBitrateUplinkExt2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "guaranteedBitRateUplinkExt2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          guaranteedBitRateUplinkExt2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.QoSV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.QoSV");
  }
}

void QoSV::encode_text(Text_Buf& text_buf) const
{
field_reliabilityClass.encode_text(text_buf);
field_delayClass.encode_text(text_buf);
field_spare1.encode_text(text_buf);
field_precedenceClass.encode_text(text_buf);
field_spare2.encode_text(text_buf);
field_peakThroughput.encode_text(text_buf);
field_meanThroughput.encode_text(text_buf);
field_spare3.encode_text(text_buf);
field_deliverErroneusSDU.encode_text(text_buf);
field_deliveryOrder.encode_text(text_buf);
field_trafficClass.encode_text(text_buf);
field_maxSDUSize.encode_text(text_buf);
field_maxBitrateUplink.encode_text(text_buf);
field_maxBitrateDownlink.encode_text(text_buf);
field_sduErrorRatio.encode_text(text_buf);
field_residualBER.encode_text(text_buf);
field_trafficHandlingPriority.encode_text(text_buf);
field_transferDelay.encode_text(text_buf);
field_guaranteedBitRateUplink.encode_text(text_buf);
field_guaranteedBitRateDownlink.encode_text(text_buf);
field_sourceStatisticsDescriptor.encode_text(text_buf);
field_signallingIndication.encode_text(text_buf);
field_spare4.encode_text(text_buf);
field_maxBitrateDownlinkExt.encode_text(text_buf);
field_guaranteedBitRateDownlinkExt.encode_text(text_buf);
field_maxBitrateUplinkExt.encode_text(text_buf);
field_guaranteedBitRateUplinkExt.encode_text(text_buf);
field_maxBitrateDownlinkExt2.encode_text(text_buf);
field_guaranteedBitRateDownlinkExt2.encode_text(text_buf);
field_maxBitrateUplinkExt2.encode_text(text_buf);
field_guaranteedBitRateUplinkExt2.encode_text(text_buf);
}

void QoSV::decode_text(Text_Buf& text_buf)
{
field_reliabilityClass.decode_text(text_buf);
field_delayClass.decode_text(text_buf);
field_spare1.decode_text(text_buf);
field_precedenceClass.decode_text(text_buf);
field_spare2.decode_text(text_buf);
field_peakThroughput.decode_text(text_buf);
field_meanThroughput.decode_text(text_buf);
field_spare3.decode_text(text_buf);
field_deliverErroneusSDU.decode_text(text_buf);
field_deliveryOrder.decode_text(text_buf);
field_trafficClass.decode_text(text_buf);
field_maxSDUSize.decode_text(text_buf);
field_maxBitrateUplink.decode_text(text_buf);
field_maxBitrateDownlink.decode_text(text_buf);
field_sduErrorRatio.decode_text(text_buf);
field_residualBER.decode_text(text_buf);
field_trafficHandlingPriority.decode_text(text_buf);
field_transferDelay.decode_text(text_buf);
field_guaranteedBitRateUplink.decode_text(text_buf);
field_guaranteedBitRateDownlink.decode_text(text_buf);
field_sourceStatisticsDescriptor.decode_text(text_buf);
field_signallingIndication.decode_text(text_buf);
field_spare4.decode_text(text_buf);
field_maxBitrateDownlinkExt.decode_text(text_buf);
field_guaranteedBitRateDownlinkExt.decode_text(text_buf);
field_maxBitrateUplinkExt.decode_text(text_buf);
field_guaranteedBitRateUplinkExt.decode_text(text_buf);
field_maxBitrateDownlinkExt2.decode_text(text_buf);
field_guaranteedBitRateDownlinkExt2.decode_text(text_buf);
field_maxBitrateUplinkExt2.decode_text(text_buf);
field_guaranteedBitRateUplinkExt2.decode_text(text_buf);
}

void QoSV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void QoSV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int QoSV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_reliabilityClass.RAW_decode(General__Types::BIT3_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_delayClass.RAW_decode(General__Types::BIT3_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_spare1.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_precedenceClass.RAW_decode(General__Types::BIT3_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_spare2.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_5_force_omit(5, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_peakThroughput.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_6_force_omit(6, force_omit, General__Types::BIT5_descr_.raw->forceomit);
  decoded_field_length = field_meanThroughput.RAW_decode(General__Types::BIT5_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_7_force_omit(7, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_spare3.RAW_decode(General__Types::BIT3_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(8)) {
    field_deliverErroneusSDU = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_8_force_omit(8, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_deliverErroneusSDU().RAW_decode(General__Types::BIT3_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 1) {
  field_deliverErroneusSDU = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_deliverErroneusSDU=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(9)) {
    field_deliveryOrder = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_9_force_omit(9, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_deliveryOrder().RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_9_force_omit);
  if (decoded_field_length < 1) {
  field_deliveryOrder = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_deliveryOrder=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(10)) {
    field_trafficClass = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_10_force_omit(10, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_trafficClass().RAW_decode(General__Types::BIT3_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_10_force_omit);
  if (decoded_field_length < 1) {
  field_trafficClass = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_trafficClass=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(11)) {
    field_maxSDUSize = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_11_force_omit(11, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_maxSDUSize().RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_11_force_omit);
  if (decoded_field_length < 1) {
  field_maxSDUSize = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_maxSDUSize=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(12)) {
    field_maxBitrateUplink = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_12_force_omit(12, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_maxBitrateUplink().RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_12_force_omit);
  if (decoded_field_length < 1) {
  field_maxBitrateUplink = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_maxBitrateUplink=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(13)) {
    field_maxBitrateDownlink = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_13_force_omit(13, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_maxBitrateDownlink().RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_13_force_omit);
  if (decoded_field_length < 1) {
  field_maxBitrateDownlink = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_maxBitrateDownlink=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(14)) {
    field_sduErrorRatio = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_14_force_omit(14, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_sduErrorRatio().RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_14_force_omit);
  if (decoded_field_length < 1) {
  field_sduErrorRatio = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_sduErrorRatio=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(15)) {
    field_residualBER = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_15_force_omit(15, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_residualBER().RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_15_force_omit);
  if (decoded_field_length < 1) {
  field_residualBER = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_residualBER=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(16)) {
    field_trafficHandlingPriority = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_16_force_omit(16, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_trafficHandlingPriority().RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_16_force_omit);
  if (decoded_field_length < 1) {
  field_trafficHandlingPriority = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_trafficHandlingPriority=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(17)) {
    field_transferDelay = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_17_force_omit(17, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_transferDelay().RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_17_force_omit);
  if (decoded_field_length < 1) {
  field_transferDelay = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_transferDelay=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(18)) {
    field_guaranteedBitRateUplink = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_18_force_omit(18, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_guaranteedBitRateUplink().RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_18_force_omit);
  if (decoded_field_length < 1) {
  field_guaranteedBitRateUplink = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_guaranteedBitRateUplink=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(19)) {
    field_guaranteedBitRateDownlink = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_19_force_omit(19, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_guaranteedBitRateDownlink().RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_19_force_omit);
  if (decoded_field_length < 1) {
  field_guaranteedBitRateDownlink = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_guaranteedBitRateDownlink=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(20)) {
    field_sourceStatisticsDescriptor = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_20_force_omit(20, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_sourceStatisticsDescriptor().RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_20_force_omit);
  if (decoded_field_length < 1) {
  field_sourceStatisticsDescriptor = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_sourceStatisticsDescriptor=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(21)) {
    field_signallingIndication = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_21_force_omit(21, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_signallingIndication().RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_21_force_omit);
  if (decoded_field_length < 1) {
  field_signallingIndication = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_signallingIndication=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(22)) {
    field_spare4 = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_22_force_omit(22, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_spare4().RAW_decode(General__Types::BIT3_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_22_force_omit);
  if (decoded_field_length < 1) {
  field_spare4 = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_spare4=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(23)) {
    field_maxBitrateDownlinkExt = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_23_force_omit(23, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_maxBitrateDownlinkExt().RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_23_force_omit);
  if (decoded_field_length < 1) {
  field_maxBitrateDownlinkExt = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_maxBitrateDownlinkExt=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(24)) {
    field_guaranteedBitRateDownlinkExt = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_24_force_omit(24, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_guaranteedBitRateDownlinkExt().RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_24_force_omit);
  if (decoded_field_length < 1) {
  field_guaranteedBitRateDownlinkExt = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_guaranteedBitRateDownlinkExt=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(25)) {
    field_maxBitrateUplinkExt = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_25_force_omit(25, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_maxBitrateUplinkExt().RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_25_force_omit);
  if (decoded_field_length < 1) {
  field_maxBitrateUplinkExt = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_maxBitrateUplinkExt=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(26)) {
    field_guaranteedBitRateUplinkExt = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_26_force_omit(26, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_guaranteedBitRateUplinkExt().RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_26_force_omit);
  if (decoded_field_length < 1) {
  field_guaranteedBitRateUplinkExt = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_guaranteedBitRateUplinkExt=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(27)) {
    field_maxBitrateDownlinkExt2 = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_27_force_omit(27, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_maxBitrateDownlinkExt2().RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_27_force_omit);
  if (decoded_field_length < 1) {
  field_maxBitrateDownlinkExt2 = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_maxBitrateDownlinkExt2=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(28)) {
    field_guaranteedBitRateDownlinkExt2 = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_28_force_omit(28, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_guaranteedBitRateDownlinkExt2().RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_28_force_omit);
  if (decoded_field_length < 1) {
  field_guaranteedBitRateDownlinkExt2 = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_guaranteedBitRateDownlinkExt2=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(29)) {
    field_maxBitrateUplinkExt2 = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_29_force_omit(29, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_maxBitrateUplinkExt2().RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_29_force_omit);
  if (decoded_field_length < 1) {
  field_maxBitrateUplinkExt2 = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_maxBitrateUplinkExt2=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(30)) {
    field_guaranteedBitRateUplinkExt2 = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_30_force_omit(30, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_guaranteedBitRateUplinkExt2().RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_30_force_omit);
  if (decoded_field_length < 1) {
  field_guaranteedBitRateUplinkExt2 = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_guaranteedBitRateUplinkExt2=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int QoSV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 31;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(31);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT3_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT3_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT3_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, General__Types::BIT5_descr_.raw);
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, General__Types::BIT3_descr_.raw);
  if (field_deliverErroneusSDU.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, General__Types::BIT3_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  if (field_deliveryOrder.ispresent()) {
  myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 9, General__Types::BIT2_descr_.raw);
  }
  else myleaf.body.node.nodes[9] = NULL;
  if (field_trafficClass.ispresent()) {
  myleaf.body.node.nodes[10] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 10, General__Types::BIT3_descr_.raw);
  }
  else myleaf.body.node.nodes[10] = NULL;
  if (field_maxSDUSize.ispresent()) {
  myleaf.body.node.nodes[11] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 11, General__Types::OCT1_descr_.raw);
  }
  else myleaf.body.node.nodes[11] = NULL;
  if (field_maxBitrateUplink.ispresent()) {
  myleaf.body.node.nodes[12] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 12, General__Types::OCT1_descr_.raw);
  }
  else myleaf.body.node.nodes[12] = NULL;
  if (field_maxBitrateDownlink.ispresent()) {
  myleaf.body.node.nodes[13] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 13, General__Types::OCT1_descr_.raw);
  }
  else myleaf.body.node.nodes[13] = NULL;
  if (field_sduErrorRatio.ispresent()) {
  myleaf.body.node.nodes[14] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 14, General__Types::BIT4_descr_.raw);
  }
  else myleaf.body.node.nodes[14] = NULL;
  if (field_residualBER.ispresent()) {
  myleaf.body.node.nodes[15] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 15, General__Types::BIT4_descr_.raw);
  }
  else myleaf.body.node.nodes[15] = NULL;
  if (field_trafficHandlingPriority.ispresent()) {
  myleaf.body.node.nodes[16] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 16, General__Types::BIT2_descr_.raw);
  }
  else myleaf.body.node.nodes[16] = NULL;
  if (field_transferDelay.ispresent()) {
  myleaf.body.node.nodes[17] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 17, General__Types::BIT6_descr_.raw);
  }
  else myleaf.body.node.nodes[17] = NULL;
  if (field_guaranteedBitRateUplink.ispresent()) {
  myleaf.body.node.nodes[18] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 18, General__Types::OCT1_descr_.raw);
  }
  else myleaf.body.node.nodes[18] = NULL;
  if (field_guaranteedBitRateDownlink.ispresent()) {
  myleaf.body.node.nodes[19] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 19, General__Types::OCT1_descr_.raw);
  }
  else myleaf.body.node.nodes[19] = NULL;
  if (field_sourceStatisticsDescriptor.ispresent()) {
  myleaf.body.node.nodes[20] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 20, General__Types::BIT4_descr_.raw);
  }
  else myleaf.body.node.nodes[20] = NULL;
  if (field_signallingIndication.ispresent()) {
  myleaf.body.node.nodes[21] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 21, General__Types::BIT1_descr_.raw);
  }
  else myleaf.body.node.nodes[21] = NULL;
  if (field_spare4.ispresent()) {
  myleaf.body.node.nodes[22] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 22, General__Types::BIT3_descr_.raw);
  }
  else myleaf.body.node.nodes[22] = NULL;
  if (field_maxBitrateDownlinkExt.ispresent()) {
  myleaf.body.node.nodes[23] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 23, General__Types::OCT1_descr_.raw);
  }
  else myleaf.body.node.nodes[23] = NULL;
  if (field_guaranteedBitRateDownlinkExt.ispresent()) {
  myleaf.body.node.nodes[24] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 24, General__Types::OCT1_descr_.raw);
  }
  else myleaf.body.node.nodes[24] = NULL;
  if (field_maxBitrateUplinkExt.ispresent()) {
  myleaf.body.node.nodes[25] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 25, General__Types::OCT1_descr_.raw);
  }
  else myleaf.body.node.nodes[25] = NULL;
  if (field_guaranteedBitRateUplinkExt.ispresent()) {
  myleaf.body.node.nodes[26] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 26, General__Types::OCT1_descr_.raw);
  }
  else myleaf.body.node.nodes[26] = NULL;
  if (field_maxBitrateDownlinkExt2.ispresent()) {
  myleaf.body.node.nodes[27] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 27, General__Types::OCT1_descr_.raw);
  }
  else myleaf.body.node.nodes[27] = NULL;
  if (field_guaranteedBitRateDownlinkExt2.ispresent()) {
  myleaf.body.node.nodes[28] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 28, General__Types::OCT1_descr_.raw);
  }
  else myleaf.body.node.nodes[28] = NULL;
  if (field_maxBitrateUplinkExt2.ispresent()) {
  myleaf.body.node.nodes[29] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 29, General__Types::OCT1_descr_.raw);
  }
  else myleaf.body.node.nodes[29] = NULL;
  if (field_guaranteedBitRateUplinkExt2.ispresent()) {
  myleaf.body.node.nodes[30] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 30, General__Types::OCT1_descr_.raw);
  }
  else myleaf.body.node.nodes[30] = NULL;
  encoded_length += field_reliabilityClass.RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_delayClass.RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_spare1.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_precedenceClass.RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_spare2.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_peakThroughput.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[5]);
  encoded_length += field_meanThroughput.RAW_encode(General__Types::BIT5_descr_, *myleaf.body.node.nodes[6]);
  encoded_length += field_spare3.RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[7]);
  if (field_deliverErroneusSDU.ispresent()) {
  encoded_length += field_deliverErroneusSDU().RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[8]);
  }
  if (field_deliveryOrder.ispresent()) {
  encoded_length += field_deliveryOrder().RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[9]);
  }
  if (field_trafficClass.ispresent()) {
  encoded_length += field_trafficClass().RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[10]);
  }
  if (field_maxSDUSize.ispresent()) {
  encoded_length += field_maxSDUSize().RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[11]);
  }
  if (field_maxBitrateUplink.ispresent()) {
  encoded_length += field_maxBitrateUplink().RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[12]);
  }
  if (field_maxBitrateDownlink.ispresent()) {
  encoded_length += field_maxBitrateDownlink().RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[13]);
  }
  if (field_sduErrorRatio.ispresent()) {
  encoded_length += field_sduErrorRatio().RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[14]);
  }
  if (field_residualBER.ispresent()) {
  encoded_length += field_residualBER().RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[15]);
  }
  if (field_trafficHandlingPriority.ispresent()) {
  encoded_length += field_trafficHandlingPriority().RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[16]);
  }
  if (field_transferDelay.ispresent()) {
  encoded_length += field_transferDelay().RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[17]);
  }
  if (field_guaranteedBitRateUplink.ispresent()) {
  encoded_length += field_guaranteedBitRateUplink().RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[18]);
  }
  if (field_guaranteedBitRateDownlink.ispresent()) {
  encoded_length += field_guaranteedBitRateDownlink().RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[19]);
  }
  if (field_sourceStatisticsDescriptor.ispresent()) {
  encoded_length += field_sourceStatisticsDescriptor().RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[20]);
  }
  if (field_signallingIndication.ispresent()) {
  encoded_length += field_signallingIndication().RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[21]);
  }
  if (field_spare4.ispresent()) {
  encoded_length += field_spare4().RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[22]);
  }
  if (field_maxBitrateDownlinkExt.ispresent()) {
  encoded_length += field_maxBitrateDownlinkExt().RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[23]);
  }
  if (field_guaranteedBitRateDownlinkExt.ispresent()) {
  encoded_length += field_guaranteedBitRateDownlinkExt().RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[24]);
  }
  if (field_maxBitrateUplinkExt.ispresent()) {
  encoded_length += field_maxBitrateUplinkExt().RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[25]);
  }
  if (field_guaranteedBitRateUplinkExt.ispresent()) {
  encoded_length += field_guaranteedBitRateUplinkExt().RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[26]);
  }
  if (field_maxBitrateDownlinkExt2.ispresent()) {
  encoded_length += field_maxBitrateDownlinkExt2().RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[27]);
  }
  if (field_guaranteedBitRateDownlinkExt2.ispresent()) {
  encoded_length += field_guaranteedBitRateDownlinkExt2().RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[28]);
  }
  if (field_maxBitrateUplinkExt2.ispresent()) {
  encoded_length += field_maxBitrateUplinkExt2().RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[29]);
  }
  if (field_guaranteedBitRateUplinkExt2.ispresent()) {
  encoded_length += field_guaranteedBitRateUplinkExt2().RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[30]);
  }
  return myleaf.length = encoded_length;
}

struct QoSV_template::single_value_struct {
BITSTRING_template field_reliabilityClass;
BITSTRING_template field_delayClass;
BITSTRING_template field_spare1;
BITSTRING_template field_precedenceClass;
BITSTRING_template field_spare2;
BITSTRING_template field_peakThroughput;
BITSTRING_template field_meanThroughput;
BITSTRING_template field_spare3;
BITSTRING_template field_deliverErroneusSDU;
BITSTRING_template field_deliveryOrder;
BITSTRING_template field_trafficClass;
OCTETSTRING_template field_maxSDUSize;
OCTETSTRING_template field_maxBitrateUplink;
OCTETSTRING_template field_maxBitrateDownlink;
BITSTRING_template field_sduErrorRatio;
BITSTRING_template field_residualBER;
BITSTRING_template field_trafficHandlingPriority;
BITSTRING_template field_transferDelay;
OCTETSTRING_template field_guaranteedBitRateUplink;
OCTETSTRING_template field_guaranteedBitRateDownlink;
BITSTRING_template field_sourceStatisticsDescriptor;
BITSTRING_template field_signallingIndication;
BITSTRING_template field_spare4;
OCTETSTRING_template field_maxBitrateDownlinkExt;
OCTETSTRING_template field_guaranteedBitRateDownlinkExt;
OCTETSTRING_template field_maxBitrateUplinkExt;
OCTETSTRING_template field_guaranteedBitRateUplinkExt;
OCTETSTRING_template field_maxBitrateDownlinkExt2;
OCTETSTRING_template field_guaranteedBitRateDownlinkExt2;
OCTETSTRING_template field_maxBitrateUplinkExt2;
OCTETSTRING_template field_guaranteedBitRateUplinkExt2;
};

void QoSV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_reliabilityClass = ANY_VALUE;
single_value->field_delayClass = ANY_VALUE;
single_value->field_spare1 = ANY_VALUE;
single_value->field_precedenceClass = ANY_VALUE;
single_value->field_spare2 = ANY_VALUE;
single_value->field_peakThroughput = ANY_VALUE;
single_value->field_meanThroughput = ANY_VALUE;
single_value->field_spare3 = ANY_VALUE;
single_value->field_deliverErroneusSDU = ANY_OR_OMIT;
single_value->field_deliveryOrder = ANY_OR_OMIT;
single_value->field_trafficClass = ANY_OR_OMIT;
single_value->field_maxSDUSize = ANY_OR_OMIT;
single_value->field_maxBitrateUplink = ANY_OR_OMIT;
single_value->field_maxBitrateDownlink = ANY_OR_OMIT;
single_value->field_sduErrorRatio = ANY_OR_OMIT;
single_value->field_residualBER = ANY_OR_OMIT;
single_value->field_trafficHandlingPriority = ANY_OR_OMIT;
single_value->field_transferDelay = ANY_OR_OMIT;
single_value->field_guaranteedBitRateUplink = ANY_OR_OMIT;
single_value->field_guaranteedBitRateDownlink = ANY_OR_OMIT;
single_value->field_sourceStatisticsDescriptor = ANY_OR_OMIT;
single_value->field_signallingIndication = ANY_OR_OMIT;
single_value->field_spare4 = ANY_OR_OMIT;
single_value->field_maxBitrateDownlinkExt = ANY_OR_OMIT;
single_value->field_guaranteedBitRateDownlinkExt = ANY_OR_OMIT;
single_value->field_maxBitrateUplinkExt = ANY_OR_OMIT;
single_value->field_guaranteedBitRateUplinkExt = ANY_OR_OMIT;
single_value->field_maxBitrateDownlinkExt2 = ANY_OR_OMIT;
single_value->field_guaranteedBitRateDownlinkExt2 = ANY_OR_OMIT;
single_value->field_maxBitrateUplinkExt2 = ANY_OR_OMIT;
single_value->field_guaranteedBitRateUplinkExt2 = ANY_OR_OMIT;
}
}
}

void QoSV_template::copy_value(const QoSV& other_value)
{
single_value = new single_value_struct;
if (other_value.reliabilityClass().is_bound()) {
  single_value->field_reliabilityClass = other_value.reliabilityClass();
} else {
  single_value->field_reliabilityClass.clean_up();
}
if (other_value.delayClass().is_bound()) {
  single_value->field_delayClass = other_value.delayClass();
} else {
  single_value->field_delayClass.clean_up();
}
if (other_value.spare1().is_bound()) {
  single_value->field_spare1 = other_value.spare1();
} else {
  single_value->field_spare1.clean_up();
}
if (other_value.precedenceClass().is_bound()) {
  single_value->field_precedenceClass = other_value.precedenceClass();
} else {
  single_value->field_precedenceClass.clean_up();
}
if (other_value.spare2().is_bound()) {
  single_value->field_spare2 = other_value.spare2();
} else {
  single_value->field_spare2.clean_up();
}
if (other_value.peakThroughput().is_bound()) {
  single_value->field_peakThroughput = other_value.peakThroughput();
} else {
  single_value->field_peakThroughput.clean_up();
}
if (other_value.meanThroughput().is_bound()) {
  single_value->field_meanThroughput = other_value.meanThroughput();
} else {
  single_value->field_meanThroughput.clean_up();
}
if (other_value.spare3().is_bound()) {
  single_value->field_spare3 = other_value.spare3();
} else {
  single_value->field_spare3.clean_up();
}
if (other_value.deliverErroneusSDU().is_bound()) {
  if (other_value.deliverErroneusSDU().ispresent()) single_value->field_deliverErroneusSDU = other_value.deliverErroneusSDU()();
  else single_value->field_deliverErroneusSDU = OMIT_VALUE;
} else {
  single_value->field_deliverErroneusSDU.clean_up();
}
if (other_value.deliveryOrder().is_bound()) {
  if (other_value.deliveryOrder().ispresent()) single_value->field_deliveryOrder = other_value.deliveryOrder()();
  else single_value->field_deliveryOrder = OMIT_VALUE;
} else {
  single_value->field_deliveryOrder.clean_up();
}
if (other_value.trafficClass().is_bound()) {
  if (other_value.trafficClass().ispresent()) single_value->field_trafficClass = other_value.trafficClass()();
  else single_value->field_trafficClass = OMIT_VALUE;
} else {
  single_value->field_trafficClass.clean_up();
}
if (other_value.maxSDUSize().is_bound()) {
  if (other_value.maxSDUSize().ispresent()) single_value->field_maxSDUSize = other_value.maxSDUSize()();
  else single_value->field_maxSDUSize = OMIT_VALUE;
} else {
  single_value->field_maxSDUSize.clean_up();
}
if (other_value.maxBitrateUplink().is_bound()) {
  if (other_value.maxBitrateUplink().ispresent()) single_value->field_maxBitrateUplink = other_value.maxBitrateUplink()();
  else single_value->field_maxBitrateUplink = OMIT_VALUE;
} else {
  single_value->field_maxBitrateUplink.clean_up();
}
if (other_value.maxBitrateDownlink().is_bound()) {
  if (other_value.maxBitrateDownlink().ispresent()) single_value->field_maxBitrateDownlink = other_value.maxBitrateDownlink()();
  else single_value->field_maxBitrateDownlink = OMIT_VALUE;
} else {
  single_value->field_maxBitrateDownlink.clean_up();
}
if (other_value.sduErrorRatio().is_bound()) {
  if (other_value.sduErrorRatio().ispresent()) single_value->field_sduErrorRatio = other_value.sduErrorRatio()();
  else single_value->field_sduErrorRatio = OMIT_VALUE;
} else {
  single_value->field_sduErrorRatio.clean_up();
}
if (other_value.residualBER().is_bound()) {
  if (other_value.residualBER().ispresent()) single_value->field_residualBER = other_value.residualBER()();
  else single_value->field_residualBER = OMIT_VALUE;
} else {
  single_value->field_residualBER.clean_up();
}
if (other_value.trafficHandlingPriority().is_bound()) {
  if (other_value.trafficHandlingPriority().ispresent()) single_value->field_trafficHandlingPriority = other_value.trafficHandlingPriority()();
  else single_value->field_trafficHandlingPriority = OMIT_VALUE;
} else {
  single_value->field_trafficHandlingPriority.clean_up();
}
if (other_value.transferDelay().is_bound()) {
  if (other_value.transferDelay().ispresent()) single_value->field_transferDelay = other_value.transferDelay()();
  else single_value->field_transferDelay = OMIT_VALUE;
} else {
  single_value->field_transferDelay.clean_up();
}
if (other_value.guaranteedBitRateUplink().is_bound()) {
  if (other_value.guaranteedBitRateUplink().ispresent()) single_value->field_guaranteedBitRateUplink = other_value.guaranteedBitRateUplink()();
  else single_value->field_guaranteedBitRateUplink = OMIT_VALUE;
} else {
  single_value->field_guaranteedBitRateUplink.clean_up();
}
if (other_value.guaranteedBitRateDownlink().is_bound()) {
  if (other_value.guaranteedBitRateDownlink().ispresent()) single_value->field_guaranteedBitRateDownlink = other_value.guaranteedBitRateDownlink()();
  else single_value->field_guaranteedBitRateDownlink = OMIT_VALUE;
} else {
  single_value->field_guaranteedBitRateDownlink.clean_up();
}
if (other_value.sourceStatisticsDescriptor().is_bound()) {
  if (other_value.sourceStatisticsDescriptor().ispresent()) single_value->field_sourceStatisticsDescriptor = other_value.sourceStatisticsDescriptor()();
  else single_value->field_sourceStatisticsDescriptor = OMIT_VALUE;
} else {
  single_value->field_sourceStatisticsDescriptor.clean_up();
}
if (other_value.signallingIndication().is_bound()) {
  if (other_value.signallingIndication().ispresent()) single_value->field_signallingIndication = other_value.signallingIndication()();
  else single_value->field_signallingIndication = OMIT_VALUE;
} else {
  single_value->field_signallingIndication.clean_up();
}
if (other_value.spare4().is_bound()) {
  if (other_value.spare4().ispresent()) single_value->field_spare4 = other_value.spare4()();
  else single_value->field_spare4 = OMIT_VALUE;
} else {
  single_value->field_spare4.clean_up();
}
if (other_value.maxBitrateDownlinkExt().is_bound()) {
  if (other_value.maxBitrateDownlinkExt().ispresent()) single_value->field_maxBitrateDownlinkExt = other_value.maxBitrateDownlinkExt()();
  else single_value->field_maxBitrateDownlinkExt = OMIT_VALUE;
} else {
  single_value->field_maxBitrateDownlinkExt.clean_up();
}
if (other_value.guaranteedBitRateDownlinkExt().is_bound()) {
  if (other_value.guaranteedBitRateDownlinkExt().ispresent()) single_value->field_guaranteedBitRateDownlinkExt = other_value.guaranteedBitRateDownlinkExt()();
  else single_value->field_guaranteedBitRateDownlinkExt = OMIT_VALUE;
} else {
  single_value->field_guaranteedBitRateDownlinkExt.clean_up();
}
if (other_value.maxBitrateUplinkExt().is_bound()) {
  if (other_value.maxBitrateUplinkExt().ispresent()) single_value->field_maxBitrateUplinkExt = other_value.maxBitrateUplinkExt()();
  else single_value->field_maxBitrateUplinkExt = OMIT_VALUE;
} else {
  single_value->field_maxBitrateUplinkExt.clean_up();
}
if (other_value.guaranteedBitRateUplinkExt().is_bound()) {
  if (other_value.guaranteedBitRateUplinkExt().ispresent()) single_value->field_guaranteedBitRateUplinkExt = other_value.guaranteedBitRateUplinkExt()();
  else single_value->field_guaranteedBitRateUplinkExt = OMIT_VALUE;
} else {
  single_value->field_guaranteedBitRateUplinkExt.clean_up();
}
if (other_value.maxBitrateDownlinkExt2().is_bound()) {
  if (other_value.maxBitrateDownlinkExt2().ispresent()) single_value->field_maxBitrateDownlinkExt2 = other_value.maxBitrateDownlinkExt2()();
  else single_value->field_maxBitrateDownlinkExt2 = OMIT_VALUE;
} else {
  single_value->field_maxBitrateDownlinkExt2.clean_up();
}
if (other_value.guaranteedBitRateDownlinkExt2().is_bound()) {
  if (other_value.guaranteedBitRateDownlinkExt2().ispresent()) single_value->field_guaranteedBitRateDownlinkExt2 = other_value.guaranteedBitRateDownlinkExt2()();
  else single_value->field_guaranteedBitRateDownlinkExt2 = OMIT_VALUE;
} else {
  single_value->field_guaranteedBitRateDownlinkExt2.clean_up();
}
if (other_value.maxBitrateUplinkExt2().is_bound()) {
  if (other_value.maxBitrateUplinkExt2().ispresent()) single_value->field_maxBitrateUplinkExt2 = other_value.maxBitrateUplinkExt2()();
  else single_value->field_maxBitrateUplinkExt2 = OMIT_VALUE;
} else {
  single_value->field_maxBitrateUplinkExt2.clean_up();
}
if (other_value.guaranteedBitRateUplinkExt2().is_bound()) {
  if (other_value.guaranteedBitRateUplinkExt2().ispresent()) single_value->field_guaranteedBitRateUplinkExt2 = other_value.guaranteedBitRateUplinkExt2()();
  else single_value->field_guaranteedBitRateUplinkExt2 = OMIT_VALUE;
} else {
  single_value->field_guaranteedBitRateUplinkExt2.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void QoSV_template::copy_template(const QoSV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.reliabilityClass().get_selection()) {
single_value->field_reliabilityClass = other_value.reliabilityClass();
} else {
single_value->field_reliabilityClass.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.delayClass().get_selection()) {
single_value->field_delayClass = other_value.delayClass();
} else {
single_value->field_delayClass.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare1().get_selection()) {
single_value->field_spare1 = other_value.spare1();
} else {
single_value->field_spare1.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.precedenceClass().get_selection()) {
single_value->field_precedenceClass = other_value.precedenceClass();
} else {
single_value->field_precedenceClass.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare2().get_selection()) {
single_value->field_spare2 = other_value.spare2();
} else {
single_value->field_spare2.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.peakThroughput().get_selection()) {
single_value->field_peakThroughput = other_value.peakThroughput();
} else {
single_value->field_peakThroughput.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.meanThroughput().get_selection()) {
single_value->field_meanThroughput = other_value.meanThroughput();
} else {
single_value->field_meanThroughput.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare3().get_selection()) {
single_value->field_spare3 = other_value.spare3();
} else {
single_value->field_spare3.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.deliverErroneusSDU().get_selection()) {
single_value->field_deliverErroneusSDU = other_value.deliverErroneusSDU();
} else {
single_value->field_deliverErroneusSDU.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.deliveryOrder().get_selection()) {
single_value->field_deliveryOrder = other_value.deliveryOrder();
} else {
single_value->field_deliveryOrder.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.trafficClass().get_selection()) {
single_value->field_trafficClass = other_value.trafficClass();
} else {
single_value->field_trafficClass.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.maxSDUSize().get_selection()) {
single_value->field_maxSDUSize = other_value.maxSDUSize();
} else {
single_value->field_maxSDUSize.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.maxBitrateUplink().get_selection()) {
single_value->field_maxBitrateUplink = other_value.maxBitrateUplink();
} else {
single_value->field_maxBitrateUplink.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.maxBitrateDownlink().get_selection()) {
single_value->field_maxBitrateDownlink = other_value.maxBitrateDownlink();
} else {
single_value->field_maxBitrateDownlink.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sduErrorRatio().get_selection()) {
single_value->field_sduErrorRatio = other_value.sduErrorRatio();
} else {
single_value->field_sduErrorRatio.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.residualBER().get_selection()) {
single_value->field_residualBER = other_value.residualBER();
} else {
single_value->field_residualBER.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.trafficHandlingPriority().get_selection()) {
single_value->field_trafficHandlingPriority = other_value.trafficHandlingPriority();
} else {
single_value->field_trafficHandlingPriority.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.transferDelay().get_selection()) {
single_value->field_transferDelay = other_value.transferDelay();
} else {
single_value->field_transferDelay.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.guaranteedBitRateUplink().get_selection()) {
single_value->field_guaranteedBitRateUplink = other_value.guaranteedBitRateUplink();
} else {
single_value->field_guaranteedBitRateUplink.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.guaranteedBitRateDownlink().get_selection()) {
single_value->field_guaranteedBitRateDownlink = other_value.guaranteedBitRateDownlink();
} else {
single_value->field_guaranteedBitRateDownlink.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sourceStatisticsDescriptor().get_selection()) {
single_value->field_sourceStatisticsDescriptor = other_value.sourceStatisticsDescriptor();
} else {
single_value->field_sourceStatisticsDescriptor.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.signallingIndication().get_selection()) {
single_value->field_signallingIndication = other_value.signallingIndication();
} else {
single_value->field_signallingIndication.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare4().get_selection()) {
single_value->field_spare4 = other_value.spare4();
} else {
single_value->field_spare4.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.maxBitrateDownlinkExt().get_selection()) {
single_value->field_maxBitrateDownlinkExt = other_value.maxBitrateDownlinkExt();
} else {
single_value->field_maxBitrateDownlinkExt.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.guaranteedBitRateDownlinkExt().get_selection()) {
single_value->field_guaranteedBitRateDownlinkExt = other_value.guaranteedBitRateDownlinkExt();
} else {
single_value->field_guaranteedBitRateDownlinkExt.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.maxBitrateUplinkExt().get_selection()) {
single_value->field_maxBitrateUplinkExt = other_value.maxBitrateUplinkExt();
} else {
single_value->field_maxBitrateUplinkExt.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.guaranteedBitRateUplinkExt().get_selection()) {
single_value->field_guaranteedBitRateUplinkExt = other_value.guaranteedBitRateUplinkExt();
} else {
single_value->field_guaranteedBitRateUplinkExt.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.maxBitrateDownlinkExt2().get_selection()) {
single_value->field_maxBitrateDownlinkExt2 = other_value.maxBitrateDownlinkExt2();
} else {
single_value->field_maxBitrateDownlinkExt2.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.guaranteedBitRateDownlinkExt2().get_selection()) {
single_value->field_guaranteedBitRateDownlinkExt2 = other_value.guaranteedBitRateDownlinkExt2();
} else {
single_value->field_guaranteedBitRateDownlinkExt2.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.maxBitrateUplinkExt2().get_selection()) {
single_value->field_maxBitrateUplinkExt2 = other_value.maxBitrateUplinkExt2();
} else {
single_value->field_maxBitrateUplinkExt2.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.guaranteedBitRateUplinkExt2().get_selection()) {
single_value->field_guaranteedBitRateUplinkExt2 = other_value.guaranteedBitRateUplinkExt2();
} else {
single_value->field_guaranteedBitRateUplinkExt2.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new QoSV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new QoSV_template(*other_value.implication_.precondition);
implication_.implied_template = new QoSV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.QoSV.");
break;
}
set_selection(other_value);
}

QoSV_template::QoSV_template()
{
}

QoSV_template::QoSV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

QoSV_template::QoSV_template(const QoSV& other_value)
{
copy_value(other_value);
}

QoSV_template::QoSV_template(const OPTIONAL<QoSV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const QoSV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.QoSV from an unbound optional field.");
}
}

QoSV_template::QoSV_template(QoSV_template* p_precondition, QoSV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

QoSV_template::QoSV_template(Dynamic_Match_Interface<QoSV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<QoSV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

QoSV_template::QoSV_template(const QoSV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

QoSV_template::~QoSV_template()
{
clean_up();
}

QoSV_template& QoSV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

QoSV_template& QoSV_template::operator=(const QoSV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

QoSV_template& QoSV_template::operator=(const OPTIONAL<QoSV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const QoSV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.QoSV.");
}
return *this;
}

QoSV_template& QoSV_template::operator=(const QoSV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean QoSV_template::match(const QoSV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.reliabilityClass().is_bound()) return FALSE;
if(!single_value->field_reliabilityClass.match(other_value.reliabilityClass(), legacy))return FALSE;
if(!other_value.delayClass().is_bound()) return FALSE;
if(!single_value->field_delayClass.match(other_value.delayClass(), legacy))return FALSE;
if(!other_value.spare1().is_bound()) return FALSE;
if(!single_value->field_spare1.match(other_value.spare1(), legacy))return FALSE;
if(!other_value.precedenceClass().is_bound()) return FALSE;
if(!single_value->field_precedenceClass.match(other_value.precedenceClass(), legacy))return FALSE;
if(!other_value.spare2().is_bound()) return FALSE;
if(!single_value->field_spare2.match(other_value.spare2(), legacy))return FALSE;
if(!other_value.peakThroughput().is_bound()) return FALSE;
if(!single_value->field_peakThroughput.match(other_value.peakThroughput(), legacy))return FALSE;
if(!other_value.meanThroughput().is_bound()) return FALSE;
if(!single_value->field_meanThroughput.match(other_value.meanThroughput(), legacy))return FALSE;
if(!other_value.spare3().is_bound()) return FALSE;
if(!single_value->field_spare3.match(other_value.spare3(), legacy))return FALSE;
if(!other_value.deliverErroneusSDU().is_bound()) return FALSE;
if((other_value.deliverErroneusSDU().ispresent() ? !single_value->field_deliverErroneusSDU.match((const BITSTRING&)other_value.deliverErroneusSDU(), legacy) : !single_value->field_deliverErroneusSDU.match_omit(legacy)))return FALSE;
if(!other_value.deliveryOrder().is_bound()) return FALSE;
if((other_value.deliveryOrder().ispresent() ? !single_value->field_deliveryOrder.match((const BITSTRING&)other_value.deliveryOrder(), legacy) : !single_value->field_deliveryOrder.match_omit(legacy)))return FALSE;
if(!other_value.trafficClass().is_bound()) return FALSE;
if((other_value.trafficClass().ispresent() ? !single_value->field_trafficClass.match((const BITSTRING&)other_value.trafficClass(), legacy) : !single_value->field_trafficClass.match_omit(legacy)))return FALSE;
if(!other_value.maxSDUSize().is_bound()) return FALSE;
if((other_value.maxSDUSize().ispresent() ? !single_value->field_maxSDUSize.match((const OCTETSTRING&)other_value.maxSDUSize(), legacy) : !single_value->field_maxSDUSize.match_omit(legacy)))return FALSE;
if(!other_value.maxBitrateUplink().is_bound()) return FALSE;
if((other_value.maxBitrateUplink().ispresent() ? !single_value->field_maxBitrateUplink.match((const OCTETSTRING&)other_value.maxBitrateUplink(), legacy) : !single_value->field_maxBitrateUplink.match_omit(legacy)))return FALSE;
if(!other_value.maxBitrateDownlink().is_bound()) return FALSE;
if((other_value.maxBitrateDownlink().ispresent() ? !single_value->field_maxBitrateDownlink.match((const OCTETSTRING&)other_value.maxBitrateDownlink(), legacy) : !single_value->field_maxBitrateDownlink.match_omit(legacy)))return FALSE;
if(!other_value.sduErrorRatio().is_bound()) return FALSE;
if((other_value.sduErrorRatio().ispresent() ? !single_value->field_sduErrorRatio.match((const BITSTRING&)other_value.sduErrorRatio(), legacy) : !single_value->field_sduErrorRatio.match_omit(legacy)))return FALSE;
if(!other_value.residualBER().is_bound()) return FALSE;
if((other_value.residualBER().ispresent() ? !single_value->field_residualBER.match((const BITSTRING&)other_value.residualBER(), legacy) : !single_value->field_residualBER.match_omit(legacy)))return FALSE;
if(!other_value.trafficHandlingPriority().is_bound()) return FALSE;
if((other_value.trafficHandlingPriority().ispresent() ? !single_value->field_trafficHandlingPriority.match((const BITSTRING&)other_value.trafficHandlingPriority(), legacy) : !single_value->field_trafficHandlingPriority.match_omit(legacy)))return FALSE;
if(!other_value.transferDelay().is_bound()) return FALSE;
if((other_value.transferDelay().ispresent() ? !single_value->field_transferDelay.match((const BITSTRING&)other_value.transferDelay(), legacy) : !single_value->field_transferDelay.match_omit(legacy)))return FALSE;
if(!other_value.guaranteedBitRateUplink().is_bound()) return FALSE;
if((other_value.guaranteedBitRateUplink().ispresent() ? !single_value->field_guaranteedBitRateUplink.match((const OCTETSTRING&)other_value.guaranteedBitRateUplink(), legacy) : !single_value->field_guaranteedBitRateUplink.match_omit(legacy)))return FALSE;
if(!other_value.guaranteedBitRateDownlink().is_bound()) return FALSE;
if((other_value.guaranteedBitRateDownlink().ispresent() ? !single_value->field_guaranteedBitRateDownlink.match((const OCTETSTRING&)other_value.guaranteedBitRateDownlink(), legacy) : !single_value->field_guaranteedBitRateDownlink.match_omit(legacy)))return FALSE;
if(!other_value.sourceStatisticsDescriptor().is_bound()) return FALSE;
if((other_value.sourceStatisticsDescriptor().ispresent() ? !single_value->field_sourceStatisticsDescriptor.match((const BITSTRING&)other_value.sourceStatisticsDescriptor(), legacy) : !single_value->field_sourceStatisticsDescriptor.match_omit(legacy)))return FALSE;
if(!other_value.signallingIndication().is_bound()) return FALSE;
if((other_value.signallingIndication().ispresent() ? !single_value->field_signallingIndication.match((const BITSTRING&)other_value.signallingIndication(), legacy) : !single_value->field_signallingIndication.match_omit(legacy)))return FALSE;
if(!other_value.spare4().is_bound()) return FALSE;
if((other_value.spare4().ispresent() ? !single_value->field_spare4.match((const BITSTRING&)other_value.spare4(), legacy) : !single_value->field_spare4.match_omit(legacy)))return FALSE;
if(!other_value.maxBitrateDownlinkExt().is_bound()) return FALSE;
if((other_value.maxBitrateDownlinkExt().ispresent() ? !single_value->field_maxBitrateDownlinkExt.match((const OCTETSTRING&)other_value.maxBitrateDownlinkExt(), legacy) : !single_value->field_maxBitrateDownlinkExt.match_omit(legacy)))return FALSE;
if(!other_value.guaranteedBitRateDownlinkExt().is_bound()) return FALSE;
if((other_value.guaranteedBitRateDownlinkExt().ispresent() ? !single_value->field_guaranteedBitRateDownlinkExt.match((const OCTETSTRING&)other_value.guaranteedBitRateDownlinkExt(), legacy) : !single_value->field_guaranteedBitRateDownlinkExt.match_omit(legacy)))return FALSE;
if(!other_value.maxBitrateUplinkExt().is_bound()) return FALSE;
if((other_value.maxBitrateUplinkExt().ispresent() ? !single_value->field_maxBitrateUplinkExt.match((const OCTETSTRING&)other_value.maxBitrateUplinkExt(), legacy) : !single_value->field_maxBitrateUplinkExt.match_omit(legacy)))return FALSE;
if(!other_value.guaranteedBitRateUplinkExt().is_bound()) return FALSE;
if((other_value.guaranteedBitRateUplinkExt().ispresent() ? !single_value->field_guaranteedBitRateUplinkExt.match((const OCTETSTRING&)other_value.guaranteedBitRateUplinkExt(), legacy) : !single_value->field_guaranteedBitRateUplinkExt.match_omit(legacy)))return FALSE;
if(!other_value.maxBitrateDownlinkExt2().is_bound()) return FALSE;
if((other_value.maxBitrateDownlinkExt2().ispresent() ? !single_value->field_maxBitrateDownlinkExt2.match((const OCTETSTRING&)other_value.maxBitrateDownlinkExt2(), legacy) : !single_value->field_maxBitrateDownlinkExt2.match_omit(legacy)))return FALSE;
if(!other_value.guaranteedBitRateDownlinkExt2().is_bound()) return FALSE;
if((other_value.guaranteedBitRateDownlinkExt2().ispresent() ? !single_value->field_guaranteedBitRateDownlinkExt2.match((const OCTETSTRING&)other_value.guaranteedBitRateDownlinkExt2(), legacy) : !single_value->field_guaranteedBitRateDownlinkExt2.match_omit(legacy)))return FALSE;
if(!other_value.maxBitrateUplinkExt2().is_bound()) return FALSE;
if((other_value.maxBitrateUplinkExt2().ispresent() ? !single_value->field_maxBitrateUplinkExt2.match((const OCTETSTRING&)other_value.maxBitrateUplinkExt2(), legacy) : !single_value->field_maxBitrateUplinkExt2.match_omit(legacy)))return FALSE;
if(!other_value.guaranteedBitRateUplinkExt2().is_bound()) return FALSE;
if((other_value.guaranteedBitRateUplinkExt2().ispresent() ? !single_value->field_guaranteedBitRateUplinkExt2.match((const OCTETSTRING&)other_value.guaranteedBitRateUplinkExt2(), legacy) : !single_value->field_guaranteedBitRateUplinkExt2.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.QoSV.");
}
return FALSE;
}

boolean QoSV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_reliabilityClass.is_bound()
 || single_value->field_delayClass.is_bound()
 || single_value->field_spare1.is_bound()
 || single_value->field_precedenceClass.is_bound()
 || single_value->field_spare2.is_bound()
 || single_value->field_peakThroughput.is_bound()
 || single_value->field_meanThroughput.is_bound()
 || single_value->field_spare3.is_bound()
 || (single_value->field_deliverErroneusSDU.is_omit() || single_value->field_deliverErroneusSDU.is_bound())
 || (single_value->field_deliveryOrder.is_omit() || single_value->field_deliveryOrder.is_bound())
 || (single_value->field_trafficClass.is_omit() || single_value->field_trafficClass.is_bound())
 || (single_value->field_maxSDUSize.is_omit() || single_value->field_maxSDUSize.is_bound())
 || (single_value->field_maxBitrateUplink.is_omit() || single_value->field_maxBitrateUplink.is_bound())
 || (single_value->field_maxBitrateDownlink.is_omit() || single_value->field_maxBitrateDownlink.is_bound())
 || (single_value->field_sduErrorRatio.is_omit() || single_value->field_sduErrorRatio.is_bound())
 || (single_value->field_residualBER.is_omit() || single_value->field_residualBER.is_bound())
 || (single_value->field_trafficHandlingPriority.is_omit() || single_value->field_trafficHandlingPriority.is_bound())
 || (single_value->field_transferDelay.is_omit() || single_value->field_transferDelay.is_bound())
 || (single_value->field_guaranteedBitRateUplink.is_omit() || single_value->field_guaranteedBitRateUplink.is_bound())
 || (single_value->field_guaranteedBitRateDownlink.is_omit() || single_value->field_guaranteedBitRateDownlink.is_bound())
 || (single_value->field_sourceStatisticsDescriptor.is_omit() || single_value->field_sourceStatisticsDescriptor.is_bound())
 || (single_value->field_signallingIndication.is_omit() || single_value->field_signallingIndication.is_bound())
 || (single_value->field_spare4.is_omit() || single_value->field_spare4.is_bound())
 || (single_value->field_maxBitrateDownlinkExt.is_omit() || single_value->field_maxBitrateDownlinkExt.is_bound())
 || (single_value->field_guaranteedBitRateDownlinkExt.is_omit() || single_value->field_guaranteedBitRateDownlinkExt.is_bound())
 || (single_value->field_maxBitrateUplinkExt.is_omit() || single_value->field_maxBitrateUplinkExt.is_bound())
 || (single_value->field_guaranteedBitRateUplinkExt.is_omit() || single_value->field_guaranteedBitRateUplinkExt.is_bound())
 || (single_value->field_maxBitrateDownlinkExt2.is_omit() || single_value->field_maxBitrateDownlinkExt2.is_bound())
 || (single_value->field_guaranteedBitRateDownlinkExt2.is_omit() || single_value->field_guaranteedBitRateDownlinkExt2.is_bound())
 || (single_value->field_maxBitrateUplinkExt2.is_omit() || single_value->field_maxBitrateUplinkExt2.is_bound())
 || (single_value->field_guaranteedBitRateUplinkExt2.is_omit() || single_value->field_guaranteedBitRateUplinkExt2.is_bound());
}

boolean QoSV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_reliabilityClass.is_value()
 && single_value->field_delayClass.is_value()
 && single_value->field_spare1.is_value()
 && single_value->field_precedenceClass.is_value()
 && single_value->field_spare2.is_value()
 && single_value->field_peakThroughput.is_value()
 && single_value->field_meanThroughput.is_value()
 && single_value->field_spare3.is_value()
 && (single_value->field_deliverErroneusSDU.is_omit() || single_value->field_deliverErroneusSDU.is_value())
 && (single_value->field_deliveryOrder.is_omit() || single_value->field_deliveryOrder.is_value())
 && (single_value->field_trafficClass.is_omit() || single_value->field_trafficClass.is_value())
 && (single_value->field_maxSDUSize.is_omit() || single_value->field_maxSDUSize.is_value())
 && (single_value->field_maxBitrateUplink.is_omit() || single_value->field_maxBitrateUplink.is_value())
 && (single_value->field_maxBitrateDownlink.is_omit() || single_value->field_maxBitrateDownlink.is_value())
 && (single_value->field_sduErrorRatio.is_omit() || single_value->field_sduErrorRatio.is_value())
 && (single_value->field_residualBER.is_omit() || single_value->field_residualBER.is_value())
 && (single_value->field_trafficHandlingPriority.is_omit() || single_value->field_trafficHandlingPriority.is_value())
 && (single_value->field_transferDelay.is_omit() || single_value->field_transferDelay.is_value())
 && (single_value->field_guaranteedBitRateUplink.is_omit() || single_value->field_guaranteedBitRateUplink.is_value())
 && (single_value->field_guaranteedBitRateDownlink.is_omit() || single_value->field_guaranteedBitRateDownlink.is_value())
 && (single_value->field_sourceStatisticsDescriptor.is_omit() || single_value->field_sourceStatisticsDescriptor.is_value())
 && (single_value->field_signallingIndication.is_omit() || single_value->field_signallingIndication.is_value())
 && (single_value->field_spare4.is_omit() || single_value->field_spare4.is_value())
 && (single_value->field_maxBitrateDownlinkExt.is_omit() || single_value->field_maxBitrateDownlinkExt.is_value())
 && (single_value->field_guaranteedBitRateDownlinkExt.is_omit() || single_value->field_guaranteedBitRateDownlinkExt.is_value())
 && (single_value->field_maxBitrateUplinkExt.is_omit() || single_value->field_maxBitrateUplinkExt.is_value())
 && (single_value->field_guaranteedBitRateUplinkExt.is_omit() || single_value->field_guaranteedBitRateUplinkExt.is_value())
 && (single_value->field_maxBitrateDownlinkExt2.is_omit() || single_value->field_maxBitrateDownlinkExt2.is_value())
 && (single_value->field_guaranteedBitRateDownlinkExt2.is_omit() || single_value->field_guaranteedBitRateDownlinkExt2.is_value())
 && (single_value->field_maxBitrateUplinkExt2.is_omit() || single_value->field_maxBitrateUplinkExt2.is_value())
 && (single_value->field_guaranteedBitRateUplinkExt2.is_omit() || single_value->field_guaranteedBitRateUplinkExt2.is_value());
}

void QoSV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

QoSV QoSV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
QoSV ret_val;
if (single_value->field_reliabilityClass.is_bound()) {
ret_val.reliabilityClass() = single_value->field_reliabilityClass.valueof();
}
if (single_value->field_delayClass.is_bound()) {
ret_val.delayClass() = single_value->field_delayClass.valueof();
}
if (single_value->field_spare1.is_bound()) {
ret_val.spare1() = single_value->field_spare1.valueof();
}
if (single_value->field_precedenceClass.is_bound()) {
ret_val.precedenceClass() = single_value->field_precedenceClass.valueof();
}
if (single_value->field_spare2.is_bound()) {
ret_val.spare2() = single_value->field_spare2.valueof();
}
if (single_value->field_peakThroughput.is_bound()) {
ret_val.peakThroughput() = single_value->field_peakThroughput.valueof();
}
if (single_value->field_meanThroughput.is_bound()) {
ret_val.meanThroughput() = single_value->field_meanThroughput.valueof();
}
if (single_value->field_spare3.is_bound()) {
ret_val.spare3() = single_value->field_spare3.valueof();
}
if (single_value->field_deliverErroneusSDU.is_omit()) ret_val.deliverErroneusSDU() = OMIT_VALUE;
else if (single_value->field_deliverErroneusSDU.is_bound()) {
ret_val.deliverErroneusSDU() = single_value->field_deliverErroneusSDU.valueof();
}
if (single_value->field_deliveryOrder.is_omit()) ret_val.deliveryOrder() = OMIT_VALUE;
else if (single_value->field_deliveryOrder.is_bound()) {
ret_val.deliveryOrder() = single_value->field_deliveryOrder.valueof();
}
if (single_value->field_trafficClass.is_omit()) ret_val.trafficClass() = OMIT_VALUE;
else if (single_value->field_trafficClass.is_bound()) {
ret_val.trafficClass() = single_value->field_trafficClass.valueof();
}
if (single_value->field_maxSDUSize.is_omit()) ret_val.maxSDUSize() = OMIT_VALUE;
else if (single_value->field_maxSDUSize.is_bound()) {
ret_val.maxSDUSize() = single_value->field_maxSDUSize.valueof();
}
if (single_value->field_maxBitrateUplink.is_omit()) ret_val.maxBitrateUplink() = OMIT_VALUE;
else if (single_value->field_maxBitrateUplink.is_bound()) {
ret_val.maxBitrateUplink() = single_value->field_maxBitrateUplink.valueof();
}
if (single_value->field_maxBitrateDownlink.is_omit()) ret_val.maxBitrateDownlink() = OMIT_VALUE;
else if (single_value->field_maxBitrateDownlink.is_bound()) {
ret_val.maxBitrateDownlink() = single_value->field_maxBitrateDownlink.valueof();
}
if (single_value->field_sduErrorRatio.is_omit()) ret_val.sduErrorRatio() = OMIT_VALUE;
else if (single_value->field_sduErrorRatio.is_bound()) {
ret_val.sduErrorRatio() = single_value->field_sduErrorRatio.valueof();
}
if (single_value->field_residualBER.is_omit()) ret_val.residualBER() = OMIT_VALUE;
else if (single_value->field_residualBER.is_bound()) {
ret_val.residualBER() = single_value->field_residualBER.valueof();
}
if (single_value->field_trafficHandlingPriority.is_omit()) ret_val.trafficHandlingPriority() = OMIT_VALUE;
else if (single_value->field_trafficHandlingPriority.is_bound()) {
ret_val.trafficHandlingPriority() = single_value->field_trafficHandlingPriority.valueof();
}
if (single_value->field_transferDelay.is_omit()) ret_val.transferDelay() = OMIT_VALUE;
else if (single_value->field_transferDelay.is_bound()) {
ret_val.transferDelay() = single_value->field_transferDelay.valueof();
}
if (single_value->field_guaranteedBitRateUplink.is_omit()) ret_val.guaranteedBitRateUplink() = OMIT_VALUE;
else if (single_value->field_guaranteedBitRateUplink.is_bound()) {
ret_val.guaranteedBitRateUplink() = single_value->field_guaranteedBitRateUplink.valueof();
}
if (single_value->field_guaranteedBitRateDownlink.is_omit()) ret_val.guaranteedBitRateDownlink() = OMIT_VALUE;
else if (single_value->field_guaranteedBitRateDownlink.is_bound()) {
ret_val.guaranteedBitRateDownlink() = single_value->field_guaranteedBitRateDownlink.valueof();
}
if (single_value->field_sourceStatisticsDescriptor.is_omit()) ret_val.sourceStatisticsDescriptor() = OMIT_VALUE;
else if (single_value->field_sourceStatisticsDescriptor.is_bound()) {
ret_val.sourceStatisticsDescriptor() = single_value->field_sourceStatisticsDescriptor.valueof();
}
if (single_value->field_signallingIndication.is_omit()) ret_val.signallingIndication() = OMIT_VALUE;
else if (single_value->field_signallingIndication.is_bound()) {
ret_val.signallingIndication() = single_value->field_signallingIndication.valueof();
}
if (single_value->field_spare4.is_omit()) ret_val.spare4() = OMIT_VALUE;
else if (single_value->field_spare4.is_bound()) {
ret_val.spare4() = single_value->field_spare4.valueof();
}
if (single_value->field_maxBitrateDownlinkExt.is_omit()) ret_val.maxBitrateDownlinkExt() = OMIT_VALUE;
else if (single_value->field_maxBitrateDownlinkExt.is_bound()) {
ret_val.maxBitrateDownlinkExt() = single_value->field_maxBitrateDownlinkExt.valueof();
}
if (single_value->field_guaranteedBitRateDownlinkExt.is_omit()) ret_val.guaranteedBitRateDownlinkExt() = OMIT_VALUE;
else if (single_value->field_guaranteedBitRateDownlinkExt.is_bound()) {
ret_val.guaranteedBitRateDownlinkExt() = single_value->field_guaranteedBitRateDownlinkExt.valueof();
}
if (single_value->field_maxBitrateUplinkExt.is_omit()) ret_val.maxBitrateUplinkExt() = OMIT_VALUE;
else if (single_value->field_maxBitrateUplinkExt.is_bound()) {
ret_val.maxBitrateUplinkExt() = single_value->field_maxBitrateUplinkExt.valueof();
}
if (single_value->field_guaranteedBitRateUplinkExt.is_omit()) ret_val.guaranteedBitRateUplinkExt() = OMIT_VALUE;
else if (single_value->field_guaranteedBitRateUplinkExt.is_bound()) {
ret_val.guaranteedBitRateUplinkExt() = single_value->field_guaranteedBitRateUplinkExt.valueof();
}
if (single_value->field_maxBitrateDownlinkExt2.is_omit()) ret_val.maxBitrateDownlinkExt2() = OMIT_VALUE;
else if (single_value->field_maxBitrateDownlinkExt2.is_bound()) {
ret_val.maxBitrateDownlinkExt2() = single_value->field_maxBitrateDownlinkExt2.valueof();
}
if (single_value->field_guaranteedBitRateDownlinkExt2.is_omit()) ret_val.guaranteedBitRateDownlinkExt2() = OMIT_VALUE;
else if (single_value->field_guaranteedBitRateDownlinkExt2.is_bound()) {
ret_val.guaranteedBitRateDownlinkExt2() = single_value->field_guaranteedBitRateDownlinkExt2.valueof();
}
if (single_value->field_maxBitrateUplinkExt2.is_omit()) ret_val.maxBitrateUplinkExt2() = OMIT_VALUE;
else if (single_value->field_maxBitrateUplinkExt2.is_bound()) {
ret_val.maxBitrateUplinkExt2() = single_value->field_maxBitrateUplinkExt2.valueof();
}
if (single_value->field_guaranteedBitRateUplinkExt2.is_omit()) ret_val.guaranteedBitRateUplinkExt2() = OMIT_VALUE;
else if (single_value->field_guaranteedBitRateUplinkExt2.is_bound()) {
ret_val.guaranteedBitRateUplinkExt2() = single_value->field_guaranteedBitRateUplinkExt2.valueof();
}
return ret_val;
}

void QoSV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.QoSV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new QoSV_template[list_length];
}

QoSV_template& QoSV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.QoSV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.QoSV.");
return value_list.list_value[list_index];
}

BITSTRING_template& QoSV_template::reliabilityClass()
{
set_specific();
return single_value->field_reliabilityClass;
}

const BITSTRING_template& QoSV_template::reliabilityClass() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reliabilityClass of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_reliabilityClass;
}

BITSTRING_template& QoSV_template::delayClass()
{
set_specific();
return single_value->field_delayClass;
}

const BITSTRING_template& QoSV_template::delayClass() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field delayClass of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_delayClass;
}

BITSTRING_template& QoSV_template::spare1()
{
set_specific();
return single_value->field_spare1;
}

const BITSTRING_template& QoSV_template::spare1() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare1 of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_spare1;
}

BITSTRING_template& QoSV_template::precedenceClass()
{
set_specific();
return single_value->field_precedenceClass;
}

const BITSTRING_template& QoSV_template::precedenceClass() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field precedenceClass of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_precedenceClass;
}

BITSTRING_template& QoSV_template::spare2()
{
set_specific();
return single_value->field_spare2;
}

const BITSTRING_template& QoSV_template::spare2() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare2 of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_spare2;
}

BITSTRING_template& QoSV_template::peakThroughput()
{
set_specific();
return single_value->field_peakThroughput;
}

const BITSTRING_template& QoSV_template::peakThroughput() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field peakThroughput of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_peakThroughput;
}

BITSTRING_template& QoSV_template::meanThroughput()
{
set_specific();
return single_value->field_meanThroughput;
}

const BITSTRING_template& QoSV_template::meanThroughput() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field meanThroughput of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_meanThroughput;
}

BITSTRING_template& QoSV_template::spare3()
{
set_specific();
return single_value->field_spare3;
}

const BITSTRING_template& QoSV_template::spare3() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare3 of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_spare3;
}

BITSTRING_template& QoSV_template::deliverErroneusSDU()
{
set_specific();
return single_value->field_deliverErroneusSDU;
}

const BITSTRING_template& QoSV_template::deliverErroneusSDU() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field deliverErroneusSDU of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_deliverErroneusSDU;
}

BITSTRING_template& QoSV_template::deliveryOrder()
{
set_specific();
return single_value->field_deliveryOrder;
}

const BITSTRING_template& QoSV_template::deliveryOrder() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field deliveryOrder of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_deliveryOrder;
}

BITSTRING_template& QoSV_template::trafficClass()
{
set_specific();
return single_value->field_trafficClass;
}

const BITSTRING_template& QoSV_template::trafficClass() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field trafficClass of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_trafficClass;
}

OCTETSTRING_template& QoSV_template::maxSDUSize()
{
set_specific();
return single_value->field_maxSDUSize;
}

const OCTETSTRING_template& QoSV_template::maxSDUSize() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field maxSDUSize of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_maxSDUSize;
}

OCTETSTRING_template& QoSV_template::maxBitrateUplink()
{
set_specific();
return single_value->field_maxBitrateUplink;
}

const OCTETSTRING_template& QoSV_template::maxBitrateUplink() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field maxBitrateUplink of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_maxBitrateUplink;
}

OCTETSTRING_template& QoSV_template::maxBitrateDownlink()
{
set_specific();
return single_value->field_maxBitrateDownlink;
}

const OCTETSTRING_template& QoSV_template::maxBitrateDownlink() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field maxBitrateDownlink of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_maxBitrateDownlink;
}

BITSTRING_template& QoSV_template::sduErrorRatio()
{
set_specific();
return single_value->field_sduErrorRatio;
}

const BITSTRING_template& QoSV_template::sduErrorRatio() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sduErrorRatio of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_sduErrorRatio;
}

BITSTRING_template& QoSV_template::residualBER()
{
set_specific();
return single_value->field_residualBER;
}

const BITSTRING_template& QoSV_template::residualBER() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field residualBER of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_residualBER;
}

BITSTRING_template& QoSV_template::trafficHandlingPriority()
{
set_specific();
return single_value->field_trafficHandlingPriority;
}

const BITSTRING_template& QoSV_template::trafficHandlingPriority() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field trafficHandlingPriority of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_trafficHandlingPriority;
}

BITSTRING_template& QoSV_template::transferDelay()
{
set_specific();
return single_value->field_transferDelay;
}

const BITSTRING_template& QoSV_template::transferDelay() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field transferDelay of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_transferDelay;
}

OCTETSTRING_template& QoSV_template::guaranteedBitRateUplink()
{
set_specific();
return single_value->field_guaranteedBitRateUplink;
}

const OCTETSTRING_template& QoSV_template::guaranteedBitRateUplink() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field guaranteedBitRateUplink of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_guaranteedBitRateUplink;
}

OCTETSTRING_template& QoSV_template::guaranteedBitRateDownlink()
{
set_specific();
return single_value->field_guaranteedBitRateDownlink;
}

const OCTETSTRING_template& QoSV_template::guaranteedBitRateDownlink() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field guaranteedBitRateDownlink of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_guaranteedBitRateDownlink;
}

BITSTRING_template& QoSV_template::sourceStatisticsDescriptor()
{
set_specific();
return single_value->field_sourceStatisticsDescriptor;
}

const BITSTRING_template& QoSV_template::sourceStatisticsDescriptor() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sourceStatisticsDescriptor of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_sourceStatisticsDescriptor;
}

BITSTRING_template& QoSV_template::signallingIndication()
{
set_specific();
return single_value->field_signallingIndication;
}

const BITSTRING_template& QoSV_template::signallingIndication() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field signallingIndication of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_signallingIndication;
}

BITSTRING_template& QoSV_template::spare4()
{
set_specific();
return single_value->field_spare4;
}

const BITSTRING_template& QoSV_template::spare4() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare4 of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_spare4;
}

OCTETSTRING_template& QoSV_template::maxBitrateDownlinkExt()
{
set_specific();
return single_value->field_maxBitrateDownlinkExt;
}

const OCTETSTRING_template& QoSV_template::maxBitrateDownlinkExt() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field maxBitrateDownlinkExt of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_maxBitrateDownlinkExt;
}

OCTETSTRING_template& QoSV_template::guaranteedBitRateDownlinkExt()
{
set_specific();
return single_value->field_guaranteedBitRateDownlinkExt;
}

const OCTETSTRING_template& QoSV_template::guaranteedBitRateDownlinkExt() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field guaranteedBitRateDownlinkExt of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_guaranteedBitRateDownlinkExt;
}

OCTETSTRING_template& QoSV_template::maxBitrateUplinkExt()
{
set_specific();
return single_value->field_maxBitrateUplinkExt;
}

const OCTETSTRING_template& QoSV_template::maxBitrateUplinkExt() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field maxBitrateUplinkExt of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_maxBitrateUplinkExt;
}

OCTETSTRING_template& QoSV_template::guaranteedBitRateUplinkExt()
{
set_specific();
return single_value->field_guaranteedBitRateUplinkExt;
}

const OCTETSTRING_template& QoSV_template::guaranteedBitRateUplinkExt() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field guaranteedBitRateUplinkExt of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_guaranteedBitRateUplinkExt;
}

OCTETSTRING_template& QoSV_template::maxBitrateDownlinkExt2()
{
set_specific();
return single_value->field_maxBitrateDownlinkExt2;
}

const OCTETSTRING_template& QoSV_template::maxBitrateDownlinkExt2() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field maxBitrateDownlinkExt2 of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_maxBitrateDownlinkExt2;
}

OCTETSTRING_template& QoSV_template::guaranteedBitRateDownlinkExt2()
{
set_specific();
return single_value->field_guaranteedBitRateDownlinkExt2;
}

const OCTETSTRING_template& QoSV_template::guaranteedBitRateDownlinkExt2() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field guaranteedBitRateDownlinkExt2 of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_guaranteedBitRateDownlinkExt2;
}

OCTETSTRING_template& QoSV_template::maxBitrateUplinkExt2()
{
set_specific();
return single_value->field_maxBitrateUplinkExt2;
}

const OCTETSTRING_template& QoSV_template::maxBitrateUplinkExt2() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field maxBitrateUplinkExt2 of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_maxBitrateUplinkExt2;
}

OCTETSTRING_template& QoSV_template::guaranteedBitRateUplinkExt2()
{
set_specific();
return single_value->field_guaranteedBitRateUplinkExt2;
}

const OCTETSTRING_template& QoSV_template::guaranteedBitRateUplinkExt2() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field guaranteedBitRateUplinkExt2 of a non-specific template of type @MobileL3_GMM_SM_Types.QoSV.");
return single_value->field_guaranteedBitRateUplinkExt2;
}

int QoSV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 8;
      if (single_value->field_deliverErroneusSDU.is_present()) ret_val++;
      if (single_value->field_deliveryOrder.is_present()) ret_val++;
      if (single_value->field_trafficClass.is_present()) ret_val++;
      if (single_value->field_maxSDUSize.is_present()) ret_val++;
      if (single_value->field_maxBitrateUplink.is_present()) ret_val++;
      if (single_value->field_maxBitrateDownlink.is_present()) ret_val++;
      if (single_value->field_sduErrorRatio.is_present()) ret_val++;
      if (single_value->field_residualBER.is_present()) ret_val++;
      if (single_value->field_trafficHandlingPriority.is_present()) ret_val++;
      if (single_value->field_transferDelay.is_present()) ret_val++;
      if (single_value->field_guaranteedBitRateUplink.is_present()) ret_val++;
      if (single_value->field_guaranteedBitRateDownlink.is_present()) ret_val++;
      if (single_value->field_sourceStatisticsDescriptor.is_present()) ret_val++;
      if (single_value->field_signallingIndication.is_present()) ret_val++;
      if (single_value->field_spare4.is_present()) ret_val++;
      if (single_value->field_maxBitrateDownlinkExt.is_present()) ret_val++;
      if (single_value->field_guaranteedBitRateDownlinkExt.is_present()) ret_val++;
      if (single_value->field_maxBitrateUplinkExt.is_present()) ret_val++;
      if (single_value->field_guaranteedBitRateUplinkExt.is_present()) ret_val++;
      if (single_value->field_maxBitrateDownlinkExt2.is_present()) ret_val++;
      if (single_value->field_guaranteedBitRateDownlinkExt2.is_present()) ret_val++;
      if (single_value->field_maxBitrateUplinkExt2.is_present()) ret_val++;
      if (single_value->field_guaranteedBitRateUplinkExt2.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.QoSV.");
  }
  return 0;
}

void QoSV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ reliabilityClass := ");
single_value->field_reliabilityClass.log();
TTCN_Logger::log_event_str(", delayClass := ");
single_value->field_delayClass.log();
TTCN_Logger::log_event_str(", spare1 := ");
single_value->field_spare1.log();
TTCN_Logger::log_event_str(", precedenceClass := ");
single_value->field_precedenceClass.log();
TTCN_Logger::log_event_str(", spare2 := ");
single_value->field_spare2.log();
TTCN_Logger::log_event_str(", peakThroughput := ");
single_value->field_peakThroughput.log();
TTCN_Logger::log_event_str(", meanThroughput := ");
single_value->field_meanThroughput.log();
TTCN_Logger::log_event_str(", spare3 := ");
single_value->field_spare3.log();
TTCN_Logger::log_event_str(", deliverErroneusSDU := ");
single_value->field_deliverErroneusSDU.log();
TTCN_Logger::log_event_str(", deliveryOrder := ");
single_value->field_deliveryOrder.log();
TTCN_Logger::log_event_str(", trafficClass := ");
single_value->field_trafficClass.log();
TTCN_Logger::log_event_str(", maxSDUSize := ");
single_value->field_maxSDUSize.log();
TTCN_Logger::log_event_str(", maxBitrateUplink := ");
single_value->field_maxBitrateUplink.log();
TTCN_Logger::log_event_str(", maxBitrateDownlink := ");
single_value->field_maxBitrateDownlink.log();
TTCN_Logger::log_event_str(", sduErrorRatio := ");
single_value->field_sduErrorRatio.log();
TTCN_Logger::log_event_str(", residualBER := ");
single_value->field_residualBER.log();
TTCN_Logger::log_event_str(", trafficHandlingPriority := ");
single_value->field_trafficHandlingPriority.log();
TTCN_Logger::log_event_str(", transferDelay := ");
single_value->field_transferDelay.log();
TTCN_Logger::log_event_str(", guaranteedBitRateUplink := ");
single_value->field_guaranteedBitRateUplink.log();
TTCN_Logger::log_event_str(", guaranteedBitRateDownlink := ");
single_value->field_guaranteedBitRateDownlink.log();
TTCN_Logger::log_event_str(", sourceStatisticsDescriptor := ");
single_value->field_sourceStatisticsDescriptor.log();
TTCN_Logger::log_event_str(", signallingIndication := ");
single_value->field_signallingIndication.log();
TTCN_Logger::log_event_str(", spare4 := ");
single_value->field_spare4.log();
TTCN_Logger::log_event_str(", maxBitrateDownlinkExt := ");
single_value->field_maxBitrateDownlinkExt.log();
TTCN_Logger::log_event_str(", guaranteedBitRateDownlinkExt := ");
single_value->field_guaranteedBitRateDownlinkExt.log();
TTCN_Logger::log_event_str(", maxBitrateUplinkExt := ");
single_value->field_maxBitrateUplinkExt.log();
TTCN_Logger::log_event_str(", guaranteedBitRateUplinkExt := ");
single_value->field_guaranteedBitRateUplinkExt.log();
TTCN_Logger::log_event_str(", maxBitrateDownlinkExt2 := ");
single_value->field_maxBitrateDownlinkExt2.log();
TTCN_Logger::log_event_str(", guaranteedBitRateDownlinkExt2 := ");
single_value->field_guaranteedBitRateDownlinkExt2.log();
TTCN_Logger::log_event_str(", maxBitrateUplinkExt2 := ");
single_value->field_maxBitrateUplinkExt2.log();
TTCN_Logger::log_event_str(", guaranteedBitRateUplinkExt2 := ");
single_value->field_guaranteedBitRateUplinkExt2.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void QoSV_template::log_match(const QoSV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_reliabilityClass.match(match_value.reliabilityClass(), legacy)){
TTCN_Logger::log_logmatch_info(".reliabilityClass");
single_value->field_reliabilityClass.log_match(match_value.reliabilityClass(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_delayClass.match(match_value.delayClass(), legacy)){
TTCN_Logger::log_logmatch_info(".delayClass");
single_value->field_delayClass.log_match(match_value.delayClass(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare1.match(match_value.spare1(), legacy)){
TTCN_Logger::log_logmatch_info(".spare1");
single_value->field_spare1.log_match(match_value.spare1(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_precedenceClass.match(match_value.precedenceClass(), legacy)){
TTCN_Logger::log_logmatch_info(".precedenceClass");
single_value->field_precedenceClass.log_match(match_value.precedenceClass(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare2.match(match_value.spare2(), legacy)){
TTCN_Logger::log_logmatch_info(".spare2");
single_value->field_spare2.log_match(match_value.spare2(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_peakThroughput.match(match_value.peakThroughput(), legacy)){
TTCN_Logger::log_logmatch_info(".peakThroughput");
single_value->field_peakThroughput.log_match(match_value.peakThroughput(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_meanThroughput.match(match_value.meanThroughput(), legacy)){
TTCN_Logger::log_logmatch_info(".meanThroughput");
single_value->field_meanThroughput.log_match(match_value.meanThroughput(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare3.match(match_value.spare3(), legacy)){
TTCN_Logger::log_logmatch_info(".spare3");
single_value->field_spare3.log_match(match_value.spare3(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.deliverErroneusSDU().ispresent()){
if(!single_value->field_deliverErroneusSDU.match(match_value.deliverErroneusSDU(), legacy)){
TTCN_Logger::log_logmatch_info(".deliverErroneusSDU");
single_value->field_deliverErroneusSDU.log_match(match_value.deliverErroneusSDU(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_deliverErroneusSDU.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".deliverErroneusSDU := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_deliverErroneusSDU.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.deliveryOrder().ispresent()){
if(!single_value->field_deliveryOrder.match(match_value.deliveryOrder(), legacy)){
TTCN_Logger::log_logmatch_info(".deliveryOrder");
single_value->field_deliveryOrder.log_match(match_value.deliveryOrder(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_deliveryOrder.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".deliveryOrder := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_deliveryOrder.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.trafficClass().ispresent()){
if(!single_value->field_trafficClass.match(match_value.trafficClass(), legacy)){
TTCN_Logger::log_logmatch_info(".trafficClass");
single_value->field_trafficClass.log_match(match_value.trafficClass(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_trafficClass.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".trafficClass := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_trafficClass.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.maxSDUSize().ispresent()){
if(!single_value->field_maxSDUSize.match(match_value.maxSDUSize(), legacy)){
TTCN_Logger::log_logmatch_info(".maxSDUSize");
single_value->field_maxSDUSize.log_match(match_value.maxSDUSize(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_maxSDUSize.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".maxSDUSize := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_maxSDUSize.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.maxBitrateUplink().ispresent()){
if(!single_value->field_maxBitrateUplink.match(match_value.maxBitrateUplink(), legacy)){
TTCN_Logger::log_logmatch_info(".maxBitrateUplink");
single_value->field_maxBitrateUplink.log_match(match_value.maxBitrateUplink(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_maxBitrateUplink.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".maxBitrateUplink := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_maxBitrateUplink.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.maxBitrateDownlink().ispresent()){
if(!single_value->field_maxBitrateDownlink.match(match_value.maxBitrateDownlink(), legacy)){
TTCN_Logger::log_logmatch_info(".maxBitrateDownlink");
single_value->field_maxBitrateDownlink.log_match(match_value.maxBitrateDownlink(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_maxBitrateDownlink.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".maxBitrateDownlink := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_maxBitrateDownlink.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.sduErrorRatio().ispresent()){
if(!single_value->field_sduErrorRatio.match(match_value.sduErrorRatio(), legacy)){
TTCN_Logger::log_logmatch_info(".sduErrorRatio");
single_value->field_sduErrorRatio.log_match(match_value.sduErrorRatio(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_sduErrorRatio.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".sduErrorRatio := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_sduErrorRatio.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.residualBER().ispresent()){
if(!single_value->field_residualBER.match(match_value.residualBER(), legacy)){
TTCN_Logger::log_logmatch_info(".residualBER");
single_value->field_residualBER.log_match(match_value.residualBER(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_residualBER.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".residualBER := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_residualBER.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.trafficHandlingPriority().ispresent()){
if(!single_value->field_trafficHandlingPriority.match(match_value.trafficHandlingPriority(), legacy)){
TTCN_Logger::log_logmatch_info(".trafficHandlingPriority");
single_value->field_trafficHandlingPriority.log_match(match_value.trafficHandlingPriority(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_trafficHandlingPriority.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".trafficHandlingPriority := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_trafficHandlingPriority.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.transferDelay().ispresent()){
if(!single_value->field_transferDelay.match(match_value.transferDelay(), legacy)){
TTCN_Logger::log_logmatch_info(".transferDelay");
single_value->field_transferDelay.log_match(match_value.transferDelay(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_transferDelay.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".transferDelay := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_transferDelay.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.guaranteedBitRateUplink().ispresent()){
if(!single_value->field_guaranteedBitRateUplink.match(match_value.guaranteedBitRateUplink(), legacy)){
TTCN_Logger::log_logmatch_info(".guaranteedBitRateUplink");
single_value->field_guaranteedBitRateUplink.log_match(match_value.guaranteedBitRateUplink(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_guaranteedBitRateUplink.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".guaranteedBitRateUplink := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_guaranteedBitRateUplink.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.guaranteedBitRateDownlink().ispresent()){
if(!single_value->field_guaranteedBitRateDownlink.match(match_value.guaranteedBitRateDownlink(), legacy)){
TTCN_Logger::log_logmatch_info(".guaranteedBitRateDownlink");
single_value->field_guaranteedBitRateDownlink.log_match(match_value.guaranteedBitRateDownlink(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_guaranteedBitRateDownlink.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".guaranteedBitRateDownlink := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_guaranteedBitRateDownlink.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.sourceStatisticsDescriptor().ispresent()){
if(!single_value->field_sourceStatisticsDescriptor.match(match_value.sourceStatisticsDescriptor(), legacy)){
TTCN_Logger::log_logmatch_info(".sourceStatisticsDescriptor");
single_value->field_sourceStatisticsDescriptor.log_match(match_value.sourceStatisticsDescriptor(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_sourceStatisticsDescriptor.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".sourceStatisticsDescriptor := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_sourceStatisticsDescriptor.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.signallingIndication().ispresent()){
if(!single_value->field_signallingIndication.match(match_value.signallingIndication(), legacy)){
TTCN_Logger::log_logmatch_info(".signallingIndication");
single_value->field_signallingIndication.log_match(match_value.signallingIndication(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_signallingIndication.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".signallingIndication := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_signallingIndication.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.spare4().ispresent()){
if(!single_value->field_spare4.match(match_value.spare4(), legacy)){
TTCN_Logger::log_logmatch_info(".spare4");
single_value->field_spare4.log_match(match_value.spare4(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_spare4.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".spare4 := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_spare4.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.maxBitrateDownlinkExt().ispresent()){
if(!single_value->field_maxBitrateDownlinkExt.match(match_value.maxBitrateDownlinkExt(), legacy)){
TTCN_Logger::log_logmatch_info(".maxBitrateDownlinkExt");
single_value->field_maxBitrateDownlinkExt.log_match(match_value.maxBitrateDownlinkExt(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_maxBitrateDownlinkExt.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".maxBitrateDownlinkExt := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_maxBitrateDownlinkExt.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.guaranteedBitRateDownlinkExt().ispresent()){
if(!single_value->field_guaranteedBitRateDownlinkExt.match(match_value.guaranteedBitRateDownlinkExt(), legacy)){
TTCN_Logger::log_logmatch_info(".guaranteedBitRateDownlinkExt");
single_value->field_guaranteedBitRateDownlinkExt.log_match(match_value.guaranteedBitRateDownlinkExt(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_guaranteedBitRateDownlinkExt.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".guaranteedBitRateDownlinkExt := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_guaranteedBitRateDownlinkExt.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.maxBitrateUplinkExt().ispresent()){
if(!single_value->field_maxBitrateUplinkExt.match(match_value.maxBitrateUplinkExt(), legacy)){
TTCN_Logger::log_logmatch_info(".maxBitrateUplinkExt");
single_value->field_maxBitrateUplinkExt.log_match(match_value.maxBitrateUplinkExt(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_maxBitrateUplinkExt.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".maxBitrateUplinkExt := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_maxBitrateUplinkExt.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.guaranteedBitRateUplinkExt().ispresent()){
if(!single_value->field_guaranteedBitRateUplinkExt.match(match_value.guaranteedBitRateUplinkExt(), legacy)){
TTCN_Logger::log_logmatch_info(".guaranteedBitRateUplinkExt");
single_value->field_guaranteedBitRateUplinkExt.log_match(match_value.guaranteedBitRateUplinkExt(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_guaranteedBitRateUplinkExt.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".guaranteedBitRateUplinkExt := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_guaranteedBitRateUplinkExt.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.maxBitrateDownlinkExt2().ispresent()){
if(!single_value->field_maxBitrateDownlinkExt2.match(match_value.maxBitrateDownlinkExt2(), legacy)){
TTCN_Logger::log_logmatch_info(".maxBitrateDownlinkExt2");
single_value->field_maxBitrateDownlinkExt2.log_match(match_value.maxBitrateDownlinkExt2(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_maxBitrateDownlinkExt2.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".maxBitrateDownlinkExt2 := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_maxBitrateDownlinkExt2.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.guaranteedBitRateDownlinkExt2().ispresent()){
if(!single_value->field_guaranteedBitRateDownlinkExt2.match(match_value.guaranteedBitRateDownlinkExt2(), legacy)){
TTCN_Logger::log_logmatch_info(".guaranteedBitRateDownlinkExt2");
single_value->field_guaranteedBitRateDownlinkExt2.log_match(match_value.guaranteedBitRateDownlinkExt2(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_guaranteedBitRateDownlinkExt2.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".guaranteedBitRateDownlinkExt2 := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_guaranteedBitRateDownlinkExt2.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.maxBitrateUplinkExt2().ispresent()){
if(!single_value->field_maxBitrateUplinkExt2.match(match_value.maxBitrateUplinkExt2(), legacy)){
TTCN_Logger::log_logmatch_info(".maxBitrateUplinkExt2");
single_value->field_maxBitrateUplinkExt2.log_match(match_value.maxBitrateUplinkExt2(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_maxBitrateUplinkExt2.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".maxBitrateUplinkExt2 := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_maxBitrateUplinkExt2.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.guaranteedBitRateUplinkExt2().ispresent()){
if(!single_value->field_guaranteedBitRateUplinkExt2.match(match_value.guaranteedBitRateUplinkExt2(), legacy)){
TTCN_Logger::log_logmatch_info(".guaranteedBitRateUplinkExt2");
single_value->field_guaranteedBitRateUplinkExt2.log_match(match_value.guaranteedBitRateUplinkExt2(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_guaranteedBitRateUplinkExt2.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".guaranteedBitRateUplinkExt2 := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_guaranteedBitRateUplinkExt2.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ reliabilityClass := ");
single_value->field_reliabilityClass.log_match(match_value.reliabilityClass(), legacy);
TTCN_Logger::log_event_str(", delayClass := ");
single_value->field_delayClass.log_match(match_value.delayClass(), legacy);
TTCN_Logger::log_event_str(", spare1 := ");
single_value->field_spare1.log_match(match_value.spare1(), legacy);
TTCN_Logger::log_event_str(", precedenceClass := ");
single_value->field_precedenceClass.log_match(match_value.precedenceClass(), legacy);
TTCN_Logger::log_event_str(", spare2 := ");
single_value->field_spare2.log_match(match_value.spare2(), legacy);
TTCN_Logger::log_event_str(", peakThroughput := ");
single_value->field_peakThroughput.log_match(match_value.peakThroughput(), legacy);
TTCN_Logger::log_event_str(", meanThroughput := ");
single_value->field_meanThroughput.log_match(match_value.meanThroughput(), legacy);
TTCN_Logger::log_event_str(", spare3 := ");
single_value->field_spare3.log_match(match_value.spare3(), legacy);
TTCN_Logger::log_event_str(", deliverErroneusSDU := ");
if (match_value.deliverErroneusSDU().ispresent()) {
single_value->field_deliverErroneusSDU.log_match(match_value.deliverErroneusSDU(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_deliverErroneusSDU.log();
if (single_value->field_deliverErroneusSDU.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", deliveryOrder := ");
if (match_value.deliveryOrder().ispresent()) {
single_value->field_deliveryOrder.log_match(match_value.deliveryOrder(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_deliveryOrder.log();
if (single_value->field_deliveryOrder.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", trafficClass := ");
if (match_value.trafficClass().ispresent()) {
single_value->field_trafficClass.log_match(match_value.trafficClass(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_trafficClass.log();
if (single_value->field_trafficClass.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", maxSDUSize := ");
if (match_value.maxSDUSize().ispresent()) {
single_value->field_maxSDUSize.log_match(match_value.maxSDUSize(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_maxSDUSize.log();
if (single_value->field_maxSDUSize.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", maxBitrateUplink := ");
if (match_value.maxBitrateUplink().ispresent()) {
single_value->field_maxBitrateUplink.log_match(match_value.maxBitrateUplink(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_maxBitrateUplink.log();
if (single_value->field_maxBitrateUplink.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", maxBitrateDownlink := ");
if (match_value.maxBitrateDownlink().ispresent()) {
single_value->field_maxBitrateDownlink.log_match(match_value.maxBitrateDownlink(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_maxBitrateDownlink.log();
if (single_value->field_maxBitrateDownlink.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", sduErrorRatio := ");
if (match_value.sduErrorRatio().ispresent()) {
single_value->field_sduErrorRatio.log_match(match_value.sduErrorRatio(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_sduErrorRatio.log();
if (single_value->field_sduErrorRatio.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", residualBER := ");
if (match_value.residualBER().ispresent()) {
single_value->field_residualBER.log_match(match_value.residualBER(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_residualBER.log();
if (single_value->field_residualBER.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", trafficHandlingPriority := ");
if (match_value.trafficHandlingPriority().ispresent()) {
single_value->field_trafficHandlingPriority.log_match(match_value.trafficHandlingPriority(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_trafficHandlingPriority.log();
if (single_value->field_trafficHandlingPriority.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", transferDelay := ");
if (match_value.transferDelay().ispresent()) {
single_value->field_transferDelay.log_match(match_value.transferDelay(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_transferDelay.log();
if (single_value->field_transferDelay.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", guaranteedBitRateUplink := ");
if (match_value.guaranteedBitRateUplink().ispresent()) {
single_value->field_guaranteedBitRateUplink.log_match(match_value.guaranteedBitRateUplink(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_guaranteedBitRateUplink.log();
if (single_value->field_guaranteedBitRateUplink.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", guaranteedBitRateDownlink := ");
if (match_value.guaranteedBitRateDownlink().ispresent()) {
single_value->field_guaranteedBitRateDownlink.log_match(match_value.guaranteedBitRateDownlink(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_guaranteedBitRateDownlink.log();
if (single_value->field_guaranteedBitRateDownlink.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", sourceStatisticsDescriptor := ");
if (match_value.sourceStatisticsDescriptor().ispresent()) {
single_value->field_sourceStatisticsDescriptor.log_match(match_value.sourceStatisticsDescriptor(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_sourceStatisticsDescriptor.log();
if (single_value->field_sourceStatisticsDescriptor.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", signallingIndication := ");
if (match_value.signallingIndication().ispresent()) {
single_value->field_signallingIndication.log_match(match_value.signallingIndication(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_signallingIndication.log();
if (single_value->field_signallingIndication.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", spare4 := ");
if (match_value.spare4().ispresent()) {
single_value->field_spare4.log_match(match_value.spare4(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_spare4.log();
if (single_value->field_spare4.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", maxBitrateDownlinkExt := ");
if (match_value.maxBitrateDownlinkExt().ispresent()) {
single_value->field_maxBitrateDownlinkExt.log_match(match_value.maxBitrateDownlinkExt(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_maxBitrateDownlinkExt.log();
if (single_value->field_maxBitrateDownlinkExt.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", guaranteedBitRateDownlinkExt := ");
if (match_value.guaranteedBitRateDownlinkExt().ispresent()) {
single_value->field_guaranteedBitRateDownlinkExt.log_match(match_value.guaranteedBitRateDownlinkExt(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_guaranteedBitRateDownlinkExt.log();
if (single_value->field_guaranteedBitRateDownlinkExt.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", maxBitrateUplinkExt := ");
if (match_value.maxBitrateUplinkExt().ispresent()) {
single_value->field_maxBitrateUplinkExt.log_match(match_value.maxBitrateUplinkExt(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_maxBitrateUplinkExt.log();
if (single_value->field_maxBitrateUplinkExt.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", guaranteedBitRateUplinkExt := ");
if (match_value.guaranteedBitRateUplinkExt().ispresent()) {
single_value->field_guaranteedBitRateUplinkExt.log_match(match_value.guaranteedBitRateUplinkExt(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_guaranteedBitRateUplinkExt.log();
if (single_value->field_guaranteedBitRateUplinkExt.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", maxBitrateDownlinkExt2 := ");
if (match_value.maxBitrateDownlinkExt2().ispresent()) {
single_value->field_maxBitrateDownlinkExt2.log_match(match_value.maxBitrateDownlinkExt2(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_maxBitrateDownlinkExt2.log();
if (single_value->field_maxBitrateDownlinkExt2.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", guaranteedBitRateDownlinkExt2 := ");
if (match_value.guaranteedBitRateDownlinkExt2().ispresent()) {
single_value->field_guaranteedBitRateDownlinkExt2.log_match(match_value.guaranteedBitRateDownlinkExt2(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_guaranteedBitRateDownlinkExt2.log();
if (single_value->field_guaranteedBitRateDownlinkExt2.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", maxBitrateUplinkExt2 := ");
if (match_value.maxBitrateUplinkExt2().ispresent()) {
single_value->field_maxBitrateUplinkExt2.log_match(match_value.maxBitrateUplinkExt2(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_maxBitrateUplinkExt2.log();
if (single_value->field_maxBitrateUplinkExt2.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", guaranteedBitRateUplinkExt2 := ");
if (match_value.guaranteedBitRateUplinkExt2().ispresent()) {
single_value->field_guaranteedBitRateUplinkExt2.log_match(match_value.guaranteedBitRateUplinkExt2(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_guaranteedBitRateUplinkExt2.log();
if (single_value->field_guaranteedBitRateUplinkExt2.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void QoSV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_reliabilityClass.encode_text(text_buf);
single_value->field_delayClass.encode_text(text_buf);
single_value->field_spare1.encode_text(text_buf);
single_value->field_precedenceClass.encode_text(text_buf);
single_value->field_spare2.encode_text(text_buf);
single_value->field_peakThroughput.encode_text(text_buf);
single_value->field_meanThroughput.encode_text(text_buf);
single_value->field_spare3.encode_text(text_buf);
single_value->field_deliverErroneusSDU.encode_text(text_buf);
single_value->field_deliveryOrder.encode_text(text_buf);
single_value->field_trafficClass.encode_text(text_buf);
single_value->field_maxSDUSize.encode_text(text_buf);
single_value->field_maxBitrateUplink.encode_text(text_buf);
single_value->field_maxBitrateDownlink.encode_text(text_buf);
single_value->field_sduErrorRatio.encode_text(text_buf);
single_value->field_residualBER.encode_text(text_buf);
single_value->field_trafficHandlingPriority.encode_text(text_buf);
single_value->field_transferDelay.encode_text(text_buf);
single_value->field_guaranteedBitRateUplink.encode_text(text_buf);
single_value->field_guaranteedBitRateDownlink.encode_text(text_buf);
single_value->field_sourceStatisticsDescriptor.encode_text(text_buf);
single_value->field_signallingIndication.encode_text(text_buf);
single_value->field_spare4.encode_text(text_buf);
single_value->field_maxBitrateDownlinkExt.encode_text(text_buf);
single_value->field_guaranteedBitRateDownlinkExt.encode_text(text_buf);
single_value->field_maxBitrateUplinkExt.encode_text(text_buf);
single_value->field_guaranteedBitRateUplinkExt.encode_text(text_buf);
single_value->field_maxBitrateDownlinkExt2.encode_text(text_buf);
single_value->field_guaranteedBitRateDownlinkExt2.encode_text(text_buf);
single_value->field_maxBitrateUplinkExt2.encode_text(text_buf);
single_value->field_guaranteedBitRateUplinkExt2.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.QoSV.");
}
}

void QoSV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_reliabilityClass.decode_text(text_buf);
single_value->field_delayClass.decode_text(text_buf);
single_value->field_spare1.decode_text(text_buf);
single_value->field_precedenceClass.decode_text(text_buf);
single_value->field_spare2.decode_text(text_buf);
single_value->field_peakThroughput.decode_text(text_buf);
single_value->field_meanThroughput.decode_text(text_buf);
single_value->field_spare3.decode_text(text_buf);
single_value->field_deliverErroneusSDU.decode_text(text_buf);
single_value->field_deliveryOrder.decode_text(text_buf);
single_value->field_trafficClass.decode_text(text_buf);
single_value->field_maxSDUSize.decode_text(text_buf);
single_value->field_maxBitrateUplink.decode_text(text_buf);
single_value->field_maxBitrateDownlink.decode_text(text_buf);
single_value->field_sduErrorRatio.decode_text(text_buf);
single_value->field_residualBER.decode_text(text_buf);
single_value->field_trafficHandlingPriority.decode_text(text_buf);
single_value->field_transferDelay.decode_text(text_buf);
single_value->field_guaranteedBitRateUplink.decode_text(text_buf);
single_value->field_guaranteedBitRateDownlink.decode_text(text_buf);
single_value->field_sourceStatisticsDescriptor.decode_text(text_buf);
single_value->field_signallingIndication.decode_text(text_buf);
single_value->field_spare4.decode_text(text_buf);
single_value->field_maxBitrateDownlinkExt.decode_text(text_buf);
single_value->field_guaranteedBitRateDownlinkExt.decode_text(text_buf);
single_value->field_maxBitrateUplinkExt.decode_text(text_buf);
single_value->field_guaranteedBitRateUplinkExt.decode_text(text_buf);
single_value->field_maxBitrateDownlinkExt2.decode_text(text_buf);
single_value->field_guaranteedBitRateDownlinkExt2.decode_text(text_buf);
single_value->field_maxBitrateUplinkExt2.decode_text(text_buf);
single_value->field_guaranteedBitRateUplinkExt2.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new QoSV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.QoSV.");
}
}

void QoSV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    QoSV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (31<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.QoSV has 31 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) reliabilityClass().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) delayClass().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare1().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) precedenceClass().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) spare2().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) peakThroughput().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) meanThroughput().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) spare3().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) deliverErroneusSDU().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) deliveryOrder().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) trafficClass().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) maxSDUSize().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) maxBitrateUplink().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) maxBitrateDownlink().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) sduErrorRatio().set_param(*param.get_elem(14));
    if (param.get_size()>15 && param.get_elem(15)->get_type()!=Module_Param::MP_NotUsed) residualBER().set_param(*param.get_elem(15));
    if (param.get_size()>16 && param.get_elem(16)->get_type()!=Module_Param::MP_NotUsed) trafficHandlingPriority().set_param(*param.get_elem(16));
    if (param.get_size()>17 && param.get_elem(17)->get_type()!=Module_Param::MP_NotUsed) transferDelay().set_param(*param.get_elem(17));
    if (param.get_size()>18 && param.get_elem(18)->get_type()!=Module_Param::MP_NotUsed) guaranteedBitRateUplink().set_param(*param.get_elem(18));
    if (param.get_size()>19 && param.get_elem(19)->get_type()!=Module_Param::MP_NotUsed) guaranteedBitRateDownlink().set_param(*param.get_elem(19));
    if (param.get_size()>20 && param.get_elem(20)->get_type()!=Module_Param::MP_NotUsed) sourceStatisticsDescriptor().set_param(*param.get_elem(20));
    if (param.get_size()>21 && param.get_elem(21)->get_type()!=Module_Param::MP_NotUsed) signallingIndication().set_param(*param.get_elem(21));
    if (param.get_size()>22 && param.get_elem(22)->get_type()!=Module_Param::MP_NotUsed) spare4().set_param(*param.get_elem(22));
    if (param.get_size()>23 && param.get_elem(23)->get_type()!=Module_Param::MP_NotUsed) maxBitrateDownlinkExt().set_param(*param.get_elem(23));
    if (param.get_size()>24 && param.get_elem(24)->get_type()!=Module_Param::MP_NotUsed) guaranteedBitRateDownlinkExt().set_param(*param.get_elem(24));
    if (param.get_size()>25 && param.get_elem(25)->get_type()!=Module_Param::MP_NotUsed) maxBitrateUplinkExt().set_param(*param.get_elem(25));
    if (param.get_size()>26 && param.get_elem(26)->get_type()!=Module_Param::MP_NotUsed) guaranteedBitRateUplinkExt().set_param(*param.get_elem(26));
    if (param.get_size()>27 && param.get_elem(27)->get_type()!=Module_Param::MP_NotUsed) maxBitrateDownlinkExt2().set_param(*param.get_elem(27));
    if (param.get_size()>28 && param.get_elem(28)->get_type()!=Module_Param::MP_NotUsed) guaranteedBitRateDownlinkExt2().set_param(*param.get_elem(28));
    if (param.get_size()>29 && param.get_elem(29)->get_type()!=Module_Param::MP_NotUsed) maxBitrateUplinkExt2().set_param(*param.get_elem(29));
    if (param.get_size()>30 && param.get_elem(30)->get_type()!=Module_Param::MP_NotUsed) guaranteedBitRateUplinkExt2().set_param(*param.get_elem(30));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reliabilityClass")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reliabilityClass().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "delayClass")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          delayClass().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "precedenceClass")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          precedenceClass().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "peakThroughput")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          peakThroughput().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "meanThroughput")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          meanThroughput().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare3")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare3().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "deliverErroneusSDU")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          deliverErroneusSDU().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "deliveryOrder")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          deliveryOrder().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "trafficClass")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          trafficClass().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "maxSDUSize")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          maxSDUSize().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "maxBitrateUplink")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          maxBitrateUplink().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "maxBitrateDownlink")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          maxBitrateDownlink().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sduErrorRatio")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sduErrorRatio().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "residualBER")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          residualBER().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "trafficHandlingPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          trafficHandlingPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "transferDelay")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          transferDelay().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "guaranteedBitRateUplink")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          guaranteedBitRateUplink().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "guaranteedBitRateDownlink")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          guaranteedBitRateDownlink().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sourceStatisticsDescriptor")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sourceStatisticsDescriptor().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "signallingIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          signallingIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare4")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare4().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "maxBitrateDownlinkExt")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          maxBitrateDownlinkExt().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "guaranteedBitRateDownlinkExt")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          guaranteedBitRateDownlinkExt().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "maxBitrateUplinkExt")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          maxBitrateUplinkExt().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "guaranteedBitRateUplinkExt")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          guaranteedBitRateUplinkExt().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "maxBitrateDownlinkExt2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          maxBitrateDownlinkExt2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "guaranteedBitRateDownlinkExt2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          guaranteedBitRateDownlinkExt2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "maxBitrateUplinkExt2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          maxBitrateUplinkExt2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "guaranteedBitRateUplinkExt2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          guaranteedBitRateUplinkExt2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.QoSV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    QoSV_template* precondition = new QoSV_template;
    precondition->set_param(*param.get_elem(0));
    QoSV_template* implied_template = new QoSV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = QoSV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.QoSV");
  }
  is_ifpresent = param.get_ifpresent();
}

void QoSV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_reliabilityClass.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_delayClass.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_spare1.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_precedenceClass.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_spare2.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_peakThroughput.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_meanThroughput.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_spare3.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_deliverErroneusSDU.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_deliveryOrder.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_trafficClass.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_maxSDUSize.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_maxBitrateUplink.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_maxBitrateDownlink.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_sduErrorRatio.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_residualBER.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_trafficHandlingPriority.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_transferDelay.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_guaranteedBitRateUplink.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_guaranteedBitRateDownlink.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_sourceStatisticsDescriptor.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_signallingIndication.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_spare4.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_maxBitrateDownlinkExt.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_guaranteedBitRateDownlinkExt.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_maxBitrateUplinkExt.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_guaranteedBitRateUplinkExt.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_maxBitrateDownlinkExt2.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_guaranteedBitRateDownlinkExt2.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_maxBitrateUplinkExt2.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
single_value->field_guaranteedBitRateUplinkExt2.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSV");
}

boolean QoSV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean QoSV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

QoSLV::QoSLV()
{
}

QoSLV::QoSLV(const INTEGER& par_lengthIndicator,
    const QoSV& par_qoSV)
  :   field_lengthIndicator(par_lengthIndicator),
  field_qoSV(par_qoSV)
{
}

QoSLV::QoSLV(const QoSLV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.QoSLV.");
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.qoSV().is_bound()) field_qoSV = other_value.qoSV();
else field_qoSV.clean_up();
}

void QoSLV::clean_up()
{
field_lengthIndicator.clean_up();
field_qoSV.clean_up();
}

const TTCN_Typedescriptor_t* QoSLV::get_descriptor() const { return &QoSLV_descr_; }
QoSLV& QoSLV::operator=(const QoSLV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.QoSLV.");
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.qoSV().is_bound()) field_qoSV = other_value.qoSV();
  else field_qoSV.clean_up();
}
return *this;
}

boolean QoSLV::operator==(const QoSLV& other_value) const
{
return field_lengthIndicator==other_value.field_lengthIndicator
  && field_qoSV==other_value.field_qoSV;
}

boolean QoSLV::is_bound() const
{
return (field_lengthIndicator.is_bound())
  || (field_qoSV.is_bound());
}
boolean QoSLV::is_value() const
{
return field_lengthIndicator.is_value()
  && field_qoSV.is_value();
}
void QoSLV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", qoSV := ");
field_qoSV.log();
TTCN_Logger::log_event_str(" }");
}

void QoSLV::set_implicit_omit()
{
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (qoSV().is_bound()) qoSV().set_implicit_omit();
}

void QoSLV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.QoSLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) qoSV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "qoSV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          qoSV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.QoSLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.QoSLV");
  }
}

void QoSLV::encode_text(Text_Buf& text_buf) const
{
field_lengthIndicator.encode_text(text_buf);
field_qoSV.encode_text(text_buf);
}

void QoSLV::decode_text(Text_Buf& text_buf)
{
field_lengthIndicator.decode_text(text_buf);
field_qoSV.decode_text(text_buf);
}

void QoSLV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void QoSLV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int QoSLV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, QoSLV_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(QoSLV_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_lengthIndicator.convert_to_Integer(QoSLV_lengthIndicator_descr_);
  field_lengthIndicator = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, QoSV_descr_.raw->forceomit);
  decoded_field_length = field_qoSV.RAW_decode(QoSV_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int QoSLV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, QoSLV_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, QoSV_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &QoSLV_lengthIndicator_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_qoSV.RAW_encode(QoSV_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct QoSLV_template::single_value_struct {
INTEGER_template field_lengthIndicator;
QoSV_template field_qoSV;
};

void QoSLV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_qoSV = ANY_VALUE;
}
}
}

void QoSLV_template::copy_value(const QoSLV& other_value)
{
single_value = new single_value_struct;
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.qoSV().is_bound()) {
  single_value->field_qoSV = other_value.qoSV();
} else {
  single_value->field_qoSV.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void QoSLV_template::copy_template(const QoSLV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.qoSV().get_selection()) {
single_value->field_qoSV = other_value.qoSV();
} else {
single_value->field_qoSV.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new QoSLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new QoSLV_template(*other_value.implication_.precondition);
implication_.implied_template = new QoSLV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.QoSLV.");
break;
}
set_selection(other_value);
}

QoSLV_template::QoSLV_template()
{
}

QoSLV_template::QoSLV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

QoSLV_template::QoSLV_template(const QoSLV& other_value)
{
copy_value(other_value);
}

QoSLV_template::QoSLV_template(const OPTIONAL<QoSLV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const QoSLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.QoSLV from an unbound optional field.");
}
}

QoSLV_template::QoSLV_template(QoSLV_template* p_precondition, QoSLV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

QoSLV_template::QoSLV_template(Dynamic_Match_Interface<QoSLV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<QoSLV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

QoSLV_template::QoSLV_template(const QoSLV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

QoSLV_template::~QoSLV_template()
{
clean_up();
}

QoSLV_template& QoSLV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

QoSLV_template& QoSLV_template::operator=(const QoSLV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

QoSLV_template& QoSLV_template::operator=(const OPTIONAL<QoSLV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const QoSLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.QoSLV.");
}
return *this;
}

QoSLV_template& QoSLV_template::operator=(const QoSLV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean QoSLV_template::match(const QoSLV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.qoSV().is_bound()) return FALSE;
if(!single_value->field_qoSV.match(other_value.qoSV(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.QoSLV.");
}
return FALSE;
}

boolean QoSLV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_lengthIndicator.is_bound()
 || single_value->field_qoSV.is_bound();
}

boolean QoSLV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_lengthIndicator.is_value()
 && single_value->field_qoSV.is_value();
}

void QoSLV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

QoSLV QoSLV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.QoSLV.");
QoSLV ret_val;
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_qoSV.is_bound()) {
ret_val.qoSV() = single_value->field_qoSV.valueof();
}
return ret_val;
}

void QoSLV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.QoSLV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new QoSLV_template[list_length];
}

QoSLV_template& QoSLV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.QoSLV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.QoSLV.");
return value_list.list_value[list_index];
}

INTEGER_template& QoSLV_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& QoSLV_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_GMM_SM_Types.QoSLV.");
return single_value->field_lengthIndicator;
}

QoSV_template& QoSLV_template::qoSV()
{
set_specific();
return single_value->field_qoSV;
}

const QoSV_template& QoSLV_template::qoSV() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field qoSV of a non-specific template of type @MobileL3_GMM_SM_Types.QoSLV.");
return single_value->field_qoSV;
}

int QoSLV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSLV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSLV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSLV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSLV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSLV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSLV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSLV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSLV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSLV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.QoSLV.");
  }
  return 0;
}

void QoSLV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", qoSV := ");
single_value->field_qoSV.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void QoSLV_template::log_match(const QoSLV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_qoSV.match(match_value.qoSV(), legacy)){
TTCN_Logger::log_logmatch_info(".qoSV");
single_value->field_qoSV.log_match(match_value.qoSV(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", qoSV := ");
single_value->field_qoSV.log_match(match_value.qoSV(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void QoSLV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_qoSV.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.QoSLV.");
}
}

void QoSLV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_qoSV.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new QoSLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.QoSLV.");
}
}

void QoSLV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    QoSLV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.QoSLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) qoSV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "qoSV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          qoSV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.QoSLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    QoSLV_template* precondition = new QoSLV_template;
    precondition->set_param(*param.get_elem(0));
    QoSLV_template* implied_template = new QoSLV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = QoSLV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.QoSLV");
  }
  is_ifpresent = param.get_ifpresent();
}

void QoSLV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSLV");
single_value->field_qoSV.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSLV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSLV");
}

boolean QoSLV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean QoSLV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

QoSTLV::QoSTLV()
{
}

QoSTLV::QoSTLV(const OCTETSTRING& par_elementIdentifier,
    const QoSLV& par_qoSLV)
  :   field_elementIdentifier(par_elementIdentifier),
  field_qoSLV(par_qoSLV)
{
}

QoSTLV::QoSTLV(const QoSTLV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.QoSTLV.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.qoSLV().is_bound()) field_qoSLV = other_value.qoSLV();
else field_qoSLV.clean_up();
}

void QoSTLV::clean_up()
{
field_elementIdentifier.clean_up();
field_qoSLV.clean_up();
}

const TTCN_Typedescriptor_t* QoSTLV::get_descriptor() const { return &QoSTLV_descr_; }
QoSTLV& QoSTLV::operator=(const QoSTLV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.QoSTLV.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.qoSLV().is_bound()) field_qoSLV = other_value.qoSLV();
  else field_qoSLV.clean_up();
}
return *this;
}

boolean QoSTLV::operator==(const QoSTLV& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_qoSLV==other_value.field_qoSLV;
}

boolean QoSTLV::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_qoSLV.is_bound());
}
boolean QoSTLV::is_value() const
{
return field_elementIdentifier.is_value()
  && field_qoSLV.is_value();
}
void QoSTLV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", qoSLV := ");
field_qoSLV.log();
TTCN_Logger::log_event_str(" }");
}

void QoSTLV::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (qoSLV().is_bound()) qoSLV().set_implicit_omit();
}

void QoSTLV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.QoSTLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) qoSLV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "qoSLV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          qoSLV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.QoSTLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.QoSTLV");
  }
}

void QoSTLV::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_qoSLV.encode_text(text_buf);
}

void QoSTLV::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_qoSLV.decode_text(text_buf);
}

void QoSTLV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void QoSTLV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int QoSTLV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, QoSLV_descr_.raw->forceomit);
  decoded_field_length = field_qoSLV.RAW_decode(QoSLV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_elementIdentifier !=  os_15) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int QoSTLV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, QoSLV_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_qoSLV.RAW_encode(QoSLV_descr_, *myleaf.body.node.nodes[1]);
  if (field_elementIdentifier !=  os_15) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_15.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct QoSTLV_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
QoSLV_template field_qoSLV;
};

void QoSTLV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_qoSLV = ANY_VALUE;
}
}
}

void QoSTLV_template::copy_value(const QoSTLV& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.qoSLV().is_bound()) {
  single_value->field_qoSLV = other_value.qoSLV();
} else {
  single_value->field_qoSLV.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void QoSTLV_template::copy_template(const QoSTLV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.qoSLV().get_selection()) {
single_value->field_qoSLV = other_value.qoSLV();
} else {
single_value->field_qoSLV.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new QoSTLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new QoSTLV_template(*other_value.implication_.precondition);
implication_.implied_template = new QoSTLV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.QoSTLV.");
break;
}
set_selection(other_value);
}

QoSTLV_template::QoSTLV_template()
{
}

QoSTLV_template::QoSTLV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

QoSTLV_template::QoSTLV_template(const QoSTLV& other_value)
{
copy_value(other_value);
}

QoSTLV_template::QoSTLV_template(const OPTIONAL<QoSTLV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const QoSTLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.QoSTLV from an unbound optional field.");
}
}

QoSTLV_template::QoSTLV_template(QoSTLV_template* p_precondition, QoSTLV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

QoSTLV_template::QoSTLV_template(Dynamic_Match_Interface<QoSTLV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<QoSTLV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

QoSTLV_template::QoSTLV_template(const QoSTLV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

QoSTLV_template::~QoSTLV_template()
{
clean_up();
}

QoSTLV_template& QoSTLV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

QoSTLV_template& QoSTLV_template::operator=(const QoSTLV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

QoSTLV_template& QoSTLV_template::operator=(const OPTIONAL<QoSTLV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const QoSTLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.QoSTLV.");
}
return *this;
}

QoSTLV_template& QoSTLV_template::operator=(const QoSTLV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean QoSTLV_template::match(const QoSTLV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.qoSLV().is_bound()) return FALSE;
if(!single_value->field_qoSLV.match(other_value.qoSLV(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.QoSTLV.");
}
return FALSE;
}

boolean QoSTLV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_qoSLV.is_bound();
}

boolean QoSTLV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_qoSLV.is_value();
}

void QoSTLV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

QoSTLV QoSTLV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.QoSTLV.");
QoSTLV ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_qoSLV.is_bound()) {
ret_val.qoSLV() = single_value->field_qoSLV.valueof();
}
return ret_val;
}

void QoSTLV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.QoSTLV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new QoSTLV_template[list_length];
}

QoSTLV_template& QoSTLV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.QoSTLV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.QoSTLV.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& QoSTLV_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& QoSTLV_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_GMM_SM_Types.QoSTLV.");
return single_value->field_elementIdentifier;
}

QoSLV_template& QoSTLV_template::qoSLV()
{
set_specific();
return single_value->field_qoSLV;
}

const QoSLV_template& QoSTLV_template::qoSLV() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field qoSLV of a non-specific template of type @MobileL3_GMM_SM_Types.QoSTLV.");
return single_value->field_qoSLV;
}

int QoSTLV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSTLV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSTLV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSTLV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSTLV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSTLV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSTLV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSTLV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSTLV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.QoSTLV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.QoSTLV.");
  }
  return 0;
}

void QoSTLV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", qoSLV := ");
single_value->field_qoSLV.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void QoSTLV_template::log_match(const QoSTLV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_qoSLV.match(match_value.qoSLV(), legacy)){
TTCN_Logger::log_logmatch_info(".qoSLV");
single_value->field_qoSLV.log_match(match_value.qoSLV(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", qoSLV := ");
single_value->field_qoSLV.log_match(match_value.qoSLV(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void QoSTLV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_qoSLV.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.QoSTLV.");
}
}

void QoSTLV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_qoSLV.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new QoSTLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.QoSTLV.");
}
}

void QoSTLV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    QoSTLV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.QoSTLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) qoSLV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "qoSLV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          qoSLV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.QoSTLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    QoSTLV_template* precondition = new QoSTLV_template;
    precondition->set_param(*param.get_elem(0));
    QoSTLV_template* implied_template = new QoSTLV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = QoSTLV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.QoSTLV");
  }
  is_ifpresent = param.get_ifpresent();
}

void QoSTLV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSTLV");
single_value->field_qoSLV.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSTLV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.QoSTLV");
}

boolean QoSTLV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean QoSTLV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ReAttemptIndicatorV::ReAttemptIndicatorV()
{
}

ReAttemptIndicatorV::ReAttemptIndicatorV(const BITSTRING& par_rATCValue,
    const BITSTRING& par_ePLMNCValue,
    const BITSTRING& par_spare)
  :   field_rATCValue(par_rATCValue),
  field_ePLMNCValue(par_ePLMNCValue),
  field_spare(par_spare)
{
}

ReAttemptIndicatorV::ReAttemptIndicatorV(const ReAttemptIndicatorV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
if (other_value.rATCValue().is_bound()) field_rATCValue = other_value.rATCValue();
else field_rATCValue.clean_up();
if (other_value.ePLMNCValue().is_bound()) field_ePLMNCValue = other_value.ePLMNCValue();
else field_ePLMNCValue.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void ReAttemptIndicatorV::clean_up()
{
field_rATCValue.clean_up();
field_ePLMNCValue.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* ReAttemptIndicatorV::get_descriptor() const { return &ReAttemptIndicatorV_descr_; }
ReAttemptIndicatorV& ReAttemptIndicatorV::operator=(const ReAttemptIndicatorV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
  if (other_value.rATCValue().is_bound()) field_rATCValue = other_value.rATCValue();
  else field_rATCValue.clean_up();
  if (other_value.ePLMNCValue().is_bound()) field_ePLMNCValue = other_value.ePLMNCValue();
  else field_ePLMNCValue.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean ReAttemptIndicatorV::operator==(const ReAttemptIndicatorV& other_value) const
{
return field_rATCValue==other_value.field_rATCValue
  && field_ePLMNCValue==other_value.field_ePLMNCValue
  && field_spare==other_value.field_spare;
}

boolean ReAttemptIndicatorV::is_bound() const
{
return (field_rATCValue.is_bound())
  || (field_ePLMNCValue.is_bound())
  || (field_spare.is_bound());
}
boolean ReAttemptIndicatorV::is_value() const
{
return field_rATCValue.is_value()
  && field_ePLMNCValue.is_value()
  && field_spare.is_value();
}
void ReAttemptIndicatorV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ rATCValue := ");
field_rATCValue.log();
TTCN_Logger::log_event_str(", ePLMNCValue := ");
field_ePLMNCValue.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void ReAttemptIndicatorV::set_implicit_omit()
{
if (rATCValue().is_bound()) rATCValue().set_implicit_omit();
if (ePLMNCValue().is_bound()) ePLMNCValue().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void ReAttemptIndicatorV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) rATCValue().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ePLMNCValue().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rATCValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rATCValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ePLMNCValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ePLMNCValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.ReAttemptIndicatorV");
  }
}

void ReAttemptIndicatorV::encode_text(Text_Buf& text_buf) const
{
field_rATCValue.encode_text(text_buf);
field_ePLMNCValue.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void ReAttemptIndicatorV::decode_text(Text_Buf& text_buf)
{
field_rATCValue.decode_text(text_buf);
field_ePLMNCValue.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void ReAttemptIndicatorV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ReAttemptIndicatorV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int ReAttemptIndicatorV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_rATCValue.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_ePLMNCValue.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int ReAttemptIndicatorV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT6_descr_.raw);
  encoded_length += field_rATCValue.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_ePLMNCValue.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct ReAttemptIndicatorV_template::single_value_struct {
BITSTRING_template field_rATCValue;
BITSTRING_template field_ePLMNCValue;
BITSTRING_template field_spare;
};

void ReAttemptIndicatorV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_rATCValue = ANY_VALUE;
single_value->field_ePLMNCValue = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void ReAttemptIndicatorV_template::copy_value(const ReAttemptIndicatorV& other_value)
{
single_value = new single_value_struct;
if (other_value.rATCValue().is_bound()) {
  single_value->field_rATCValue = other_value.rATCValue();
} else {
  single_value->field_rATCValue.clean_up();
}
if (other_value.ePLMNCValue().is_bound()) {
  single_value->field_ePLMNCValue = other_value.ePLMNCValue();
} else {
  single_value->field_ePLMNCValue.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ReAttemptIndicatorV_template::copy_template(const ReAttemptIndicatorV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.rATCValue().get_selection()) {
single_value->field_rATCValue = other_value.rATCValue();
} else {
single_value->field_rATCValue.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ePLMNCValue().get_selection()) {
single_value->field_ePLMNCValue = other_value.ePLMNCValue();
} else {
single_value->field_ePLMNCValue.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ReAttemptIndicatorV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ReAttemptIndicatorV_template(*other_value.implication_.precondition);
implication_.implied_template = new ReAttemptIndicatorV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
break;
}
set_selection(other_value);
}

ReAttemptIndicatorV_template::ReAttemptIndicatorV_template()
{
}

ReAttemptIndicatorV_template::ReAttemptIndicatorV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ReAttemptIndicatorV_template::ReAttemptIndicatorV_template(const ReAttemptIndicatorV& other_value)
{
copy_value(other_value);
}

ReAttemptIndicatorV_template::ReAttemptIndicatorV_template(const OPTIONAL<ReAttemptIndicatorV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ReAttemptIndicatorV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV from an unbound optional field.");
}
}

ReAttemptIndicatorV_template::ReAttemptIndicatorV_template(ReAttemptIndicatorV_template* p_precondition, ReAttemptIndicatorV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ReAttemptIndicatorV_template::ReAttemptIndicatorV_template(Dynamic_Match_Interface<ReAttemptIndicatorV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ReAttemptIndicatorV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ReAttemptIndicatorV_template::ReAttemptIndicatorV_template(const ReAttemptIndicatorV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ReAttemptIndicatorV_template::~ReAttemptIndicatorV_template()
{
clean_up();
}

ReAttemptIndicatorV_template& ReAttemptIndicatorV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ReAttemptIndicatorV_template& ReAttemptIndicatorV_template::operator=(const ReAttemptIndicatorV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ReAttemptIndicatorV_template& ReAttemptIndicatorV_template::operator=(const OPTIONAL<ReAttemptIndicatorV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ReAttemptIndicatorV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
}
return *this;
}

ReAttemptIndicatorV_template& ReAttemptIndicatorV_template::operator=(const ReAttemptIndicatorV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ReAttemptIndicatorV_template::match(const ReAttemptIndicatorV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.rATCValue().is_bound()) return FALSE;
if(!single_value->field_rATCValue.match(other_value.rATCValue(), legacy))return FALSE;
if(!other_value.ePLMNCValue().is_bound()) return FALSE;
if(!single_value->field_ePLMNCValue.match(other_value.ePLMNCValue(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
}
return FALSE;
}

boolean ReAttemptIndicatorV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_rATCValue.is_bound()
 || single_value->field_ePLMNCValue.is_bound()
 || single_value->field_spare.is_bound();
}

boolean ReAttemptIndicatorV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_rATCValue.is_value()
 && single_value->field_ePLMNCValue.is_value()
 && single_value->field_spare.is_value();
}

void ReAttemptIndicatorV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ReAttemptIndicatorV ReAttemptIndicatorV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
ReAttemptIndicatorV ret_val;
if (single_value->field_rATCValue.is_bound()) {
ret_val.rATCValue() = single_value->field_rATCValue.valueof();
}
if (single_value->field_ePLMNCValue.is_bound()) {
ret_val.ePLMNCValue() = single_value->field_ePLMNCValue.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void ReAttemptIndicatorV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ReAttemptIndicatorV_template[list_length];
}

ReAttemptIndicatorV_template& ReAttemptIndicatorV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
return value_list.list_value[list_index];
}

BITSTRING_template& ReAttemptIndicatorV_template::rATCValue()
{
set_specific();
return single_value->field_rATCValue;
}

const BITSTRING_template& ReAttemptIndicatorV_template::rATCValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rATCValue of a non-specific template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
return single_value->field_rATCValue;
}

BITSTRING_template& ReAttemptIndicatorV_template::ePLMNCValue()
{
set_specific();
return single_value->field_ePLMNCValue;
}

const BITSTRING_template& ReAttemptIndicatorV_template::ePLMNCValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ePLMNCValue of a non-specific template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
return single_value->field_ePLMNCValue;
}

BITSTRING_template& ReAttemptIndicatorV_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& ReAttemptIndicatorV_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
return single_value->field_spare;
}

int ReAttemptIndicatorV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
  }
  return 0;
}

void ReAttemptIndicatorV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ rATCValue := ");
single_value->field_rATCValue.log();
TTCN_Logger::log_event_str(", ePLMNCValue := ");
single_value->field_ePLMNCValue.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ReAttemptIndicatorV_template::log_match(const ReAttemptIndicatorV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_rATCValue.match(match_value.rATCValue(), legacy)){
TTCN_Logger::log_logmatch_info(".rATCValue");
single_value->field_rATCValue.log_match(match_value.rATCValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ePLMNCValue.match(match_value.ePLMNCValue(), legacy)){
TTCN_Logger::log_logmatch_info(".ePLMNCValue");
single_value->field_ePLMNCValue.log_match(match_value.ePLMNCValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ rATCValue := ");
single_value->field_rATCValue.log_match(match_value.rATCValue(), legacy);
TTCN_Logger::log_event_str(", ePLMNCValue := ");
single_value->field_ePLMNCValue.log_match(match_value.ePLMNCValue(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ReAttemptIndicatorV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_rATCValue.encode_text(text_buf);
single_value->field_ePLMNCValue.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
}
}

void ReAttemptIndicatorV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_rATCValue.decode_text(text_buf);
single_value->field_ePLMNCValue.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ReAttemptIndicatorV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV.");
}
}

void ReAttemptIndicatorV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ReAttemptIndicatorV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) rATCValue().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ePLMNCValue().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rATCValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rATCValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ePLMNCValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ePLMNCValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.ReAttemptIndicatorV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ReAttemptIndicatorV_template* precondition = new ReAttemptIndicatorV_template;
    precondition->set_param(*param.get_elem(0));
    ReAttemptIndicatorV_template* implied_template = new ReAttemptIndicatorV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ReAttemptIndicatorV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.ReAttemptIndicatorV");
  }
  is_ifpresent = param.get_ifpresent();
}

void ReAttemptIndicatorV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_rATCValue.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ReAttemptIndicatorV");
single_value->field_ePLMNCValue.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ReAttemptIndicatorV");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ReAttemptIndicatorV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.ReAttemptIndicatorV");
}

boolean ReAttemptIndicatorV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ReAttemptIndicatorV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ReAttemptIndicatorLV::ReAttemptIndicatorLV()
{
}

ReAttemptIndicatorLV::ReAttemptIndicatorLV(const INTEGER& par_lengthIndicator,
    const ReAttemptIndicatorV& par_reAttemptIndicatorV)
  :   field_lengthIndicator(par_lengthIndicator),
  field_reAttemptIndicatorV(par_reAttemptIndicatorV)
{
}

ReAttemptIndicatorLV::ReAttemptIndicatorLV(const ReAttemptIndicatorLV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.reAttemptIndicatorV().is_bound()) field_reAttemptIndicatorV = other_value.reAttemptIndicatorV();
else field_reAttemptIndicatorV.clean_up();
}

void ReAttemptIndicatorLV::clean_up()
{
field_lengthIndicator.clean_up();
field_reAttemptIndicatorV.clean_up();
}

const TTCN_Typedescriptor_t* ReAttemptIndicatorLV::get_descriptor() const { return &ReAttemptIndicatorLV_descr_; }
ReAttemptIndicatorLV& ReAttemptIndicatorLV::operator=(const ReAttemptIndicatorLV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.reAttemptIndicatorV().is_bound()) field_reAttemptIndicatorV = other_value.reAttemptIndicatorV();
  else field_reAttemptIndicatorV.clean_up();
}
return *this;
}

boolean ReAttemptIndicatorLV::operator==(const ReAttemptIndicatorLV& other_value) const
{
return field_lengthIndicator==other_value.field_lengthIndicator
  && field_reAttemptIndicatorV==other_value.field_reAttemptIndicatorV;
}

boolean ReAttemptIndicatorLV::is_bound() const
{
return (field_lengthIndicator.is_bound())
  || (field_reAttemptIndicatorV.is_bound());
}
boolean ReAttemptIndicatorLV::is_value() const
{
return field_lengthIndicator.is_value()
  && field_reAttemptIndicatorV.is_value();
}
void ReAttemptIndicatorLV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", reAttemptIndicatorV := ");
field_reAttemptIndicatorV.log();
TTCN_Logger::log_event_str(" }");
}

void ReAttemptIndicatorLV::set_implicit_omit()
{
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (reAttemptIndicatorV().is_bound()) reAttemptIndicatorV().set_implicit_omit();
}

void ReAttemptIndicatorLV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reAttemptIndicatorV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reAttemptIndicatorV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reAttemptIndicatorV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.ReAttemptIndicatorLV");
  }
}

void ReAttemptIndicatorLV::encode_text(Text_Buf& text_buf) const
{
field_lengthIndicator.encode_text(text_buf);
field_reAttemptIndicatorV.encode_text(text_buf);
}

void ReAttemptIndicatorLV::decode_text(Text_Buf& text_buf)
{
field_lengthIndicator.decode_text(text_buf);
field_reAttemptIndicatorV.decode_text(text_buf);
}

void ReAttemptIndicatorLV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ReAttemptIndicatorLV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int ReAttemptIndicatorLV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, ReAttemptIndicatorLV_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(ReAttemptIndicatorLV_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_lengthIndicator.convert_to_Integer(ReAttemptIndicatorLV_lengthIndicator_descr_);
  field_lengthIndicator = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, ReAttemptIndicatorV_descr_.raw->forceomit);
  decoded_field_length = field_reAttemptIndicatorV.RAW_decode(ReAttemptIndicatorV_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int ReAttemptIndicatorLV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, ReAttemptIndicatorLV_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, ReAttemptIndicatorV_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &ReAttemptIndicatorLV_lengthIndicator_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_reAttemptIndicatorV.RAW_encode(ReAttemptIndicatorV_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct ReAttemptIndicatorLV_template::single_value_struct {
INTEGER_template field_lengthIndicator;
ReAttemptIndicatorV_template field_reAttemptIndicatorV;
};

void ReAttemptIndicatorLV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_reAttemptIndicatorV = ANY_VALUE;
}
}
}

void ReAttemptIndicatorLV_template::copy_value(const ReAttemptIndicatorLV& other_value)
{
single_value = new single_value_struct;
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.reAttemptIndicatorV().is_bound()) {
  single_value->field_reAttemptIndicatorV = other_value.reAttemptIndicatorV();
} else {
  single_value->field_reAttemptIndicatorV.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ReAttemptIndicatorLV_template::copy_template(const ReAttemptIndicatorLV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reAttemptIndicatorV().get_selection()) {
single_value->field_reAttemptIndicatorV = other_value.reAttemptIndicatorV();
} else {
single_value->field_reAttemptIndicatorV.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ReAttemptIndicatorLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ReAttemptIndicatorLV_template(*other_value.implication_.precondition);
implication_.implied_template = new ReAttemptIndicatorLV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
break;
}
set_selection(other_value);
}

ReAttemptIndicatorLV_template::ReAttemptIndicatorLV_template()
{
}

ReAttemptIndicatorLV_template::ReAttemptIndicatorLV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ReAttemptIndicatorLV_template::ReAttemptIndicatorLV_template(const ReAttemptIndicatorLV& other_value)
{
copy_value(other_value);
}

ReAttemptIndicatorLV_template::ReAttemptIndicatorLV_template(const OPTIONAL<ReAttemptIndicatorLV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ReAttemptIndicatorLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV from an unbound optional field.");
}
}

ReAttemptIndicatorLV_template::ReAttemptIndicatorLV_template(ReAttemptIndicatorLV_template* p_precondition, ReAttemptIndicatorLV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ReAttemptIndicatorLV_template::ReAttemptIndicatorLV_template(Dynamic_Match_Interface<ReAttemptIndicatorLV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ReAttemptIndicatorLV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ReAttemptIndicatorLV_template::ReAttemptIndicatorLV_template(const ReAttemptIndicatorLV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ReAttemptIndicatorLV_template::~ReAttemptIndicatorLV_template()
{
clean_up();
}

ReAttemptIndicatorLV_template& ReAttemptIndicatorLV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ReAttemptIndicatorLV_template& ReAttemptIndicatorLV_template::operator=(const ReAttemptIndicatorLV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ReAttemptIndicatorLV_template& ReAttemptIndicatorLV_template::operator=(const OPTIONAL<ReAttemptIndicatorLV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ReAttemptIndicatorLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
}
return *this;
}

ReAttemptIndicatorLV_template& ReAttemptIndicatorLV_template::operator=(const ReAttemptIndicatorLV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ReAttemptIndicatorLV_template::match(const ReAttemptIndicatorLV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.reAttemptIndicatorV().is_bound()) return FALSE;
if(!single_value->field_reAttemptIndicatorV.match(other_value.reAttemptIndicatorV(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
}
return FALSE;
}

boolean ReAttemptIndicatorLV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_lengthIndicator.is_bound()
 || single_value->field_reAttemptIndicatorV.is_bound();
}

boolean ReAttemptIndicatorLV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_lengthIndicator.is_value()
 && single_value->field_reAttemptIndicatorV.is_value();
}

void ReAttemptIndicatorLV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ReAttemptIndicatorLV ReAttemptIndicatorLV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
ReAttemptIndicatorLV ret_val;
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_reAttemptIndicatorV.is_bound()) {
ret_val.reAttemptIndicatorV() = single_value->field_reAttemptIndicatorV.valueof();
}
return ret_val;
}

void ReAttemptIndicatorLV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ReAttemptIndicatorLV_template[list_length];
}

ReAttemptIndicatorLV_template& ReAttemptIndicatorLV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
return value_list.list_value[list_index];
}

INTEGER_template& ReAttemptIndicatorLV_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& ReAttemptIndicatorLV_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
return single_value->field_lengthIndicator;
}

ReAttemptIndicatorV_template& ReAttemptIndicatorLV_template::reAttemptIndicatorV()
{
set_specific();
return single_value->field_reAttemptIndicatorV;
}

const ReAttemptIndicatorV_template& ReAttemptIndicatorLV_template::reAttemptIndicatorV() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reAttemptIndicatorV of a non-specific template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
return single_value->field_reAttemptIndicatorV;
}

int ReAttemptIndicatorLV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
  }
  return 0;
}

void ReAttemptIndicatorLV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", reAttemptIndicatorV := ");
single_value->field_reAttemptIndicatorV.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ReAttemptIndicatorLV_template::log_match(const ReAttemptIndicatorLV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reAttemptIndicatorV.match(match_value.reAttemptIndicatorV(), legacy)){
TTCN_Logger::log_logmatch_info(".reAttemptIndicatorV");
single_value->field_reAttemptIndicatorV.log_match(match_value.reAttemptIndicatorV(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", reAttemptIndicatorV := ");
single_value->field_reAttemptIndicatorV.log_match(match_value.reAttemptIndicatorV(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ReAttemptIndicatorLV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_reAttemptIndicatorV.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
}
}

void ReAttemptIndicatorLV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_reAttemptIndicatorV.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ReAttemptIndicatorLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV.");
}
}

void ReAttemptIndicatorLV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ReAttemptIndicatorLV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reAttemptIndicatorV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reAttemptIndicatorV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reAttemptIndicatorV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.ReAttemptIndicatorLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ReAttemptIndicatorLV_template* precondition = new ReAttemptIndicatorLV_template;
    precondition->set_param(*param.get_elem(0));
    ReAttemptIndicatorLV_template* implied_template = new ReAttemptIndicatorLV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ReAttemptIndicatorLV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.ReAttemptIndicatorLV");
  }
  is_ifpresent = param.get_ifpresent();
}

void ReAttemptIndicatorLV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ReAttemptIndicatorLV");
single_value->field_reAttemptIndicatorV.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ReAttemptIndicatorLV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.ReAttemptIndicatorLV");
}

boolean ReAttemptIndicatorLV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ReAttemptIndicatorLV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ReAttemptIndicatorTLV::ReAttemptIndicatorTLV()
{
}

ReAttemptIndicatorTLV::ReAttemptIndicatorTLV(const OCTETSTRING& par_elementIdentifier,
    const ReAttemptIndicatorLV& par_reAttemptIndicatorLV)
  :   field_elementIdentifier(par_elementIdentifier),
  field_reAttemptIndicatorLV(par_reAttemptIndicatorLV)
{
}

ReAttemptIndicatorTLV::ReAttemptIndicatorTLV(const ReAttemptIndicatorTLV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.reAttemptIndicatorLV().is_bound()) field_reAttemptIndicatorLV = other_value.reAttemptIndicatorLV();
else field_reAttemptIndicatorLV.clean_up();
}

void ReAttemptIndicatorTLV::clean_up()
{
field_elementIdentifier.clean_up();
field_reAttemptIndicatorLV.clean_up();
}

const TTCN_Typedescriptor_t* ReAttemptIndicatorTLV::get_descriptor() const { return &ReAttemptIndicatorTLV_descr_; }
ReAttemptIndicatorTLV& ReAttemptIndicatorTLV::operator=(const ReAttemptIndicatorTLV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.reAttemptIndicatorLV().is_bound()) field_reAttemptIndicatorLV = other_value.reAttemptIndicatorLV();
  else field_reAttemptIndicatorLV.clean_up();
}
return *this;
}

boolean ReAttemptIndicatorTLV::operator==(const ReAttemptIndicatorTLV& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_reAttemptIndicatorLV==other_value.field_reAttemptIndicatorLV;
}

boolean ReAttemptIndicatorTLV::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_reAttemptIndicatorLV.is_bound());
}
boolean ReAttemptIndicatorTLV::is_value() const
{
return field_elementIdentifier.is_value()
  && field_reAttemptIndicatorLV.is_value();
}
void ReAttemptIndicatorTLV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", reAttemptIndicatorLV := ");
field_reAttemptIndicatorLV.log();
TTCN_Logger::log_event_str(" }");
}

void ReAttemptIndicatorTLV::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (reAttemptIndicatorLV().is_bound()) reAttemptIndicatorLV().set_implicit_omit();
}

void ReAttemptIndicatorTLV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reAttemptIndicatorLV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reAttemptIndicatorLV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reAttemptIndicatorLV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV");
  }
}

void ReAttemptIndicatorTLV::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_reAttemptIndicatorLV.encode_text(text_buf);
}

void ReAttemptIndicatorTLV::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_reAttemptIndicatorLV.decode_text(text_buf);
}

void ReAttemptIndicatorTLV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void ReAttemptIndicatorTLV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int ReAttemptIndicatorTLV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, ReAttemptIndicatorLV_descr_.raw->forceomit);
  decoded_field_length = field_reAttemptIndicatorLV.RAW_decode(ReAttemptIndicatorLV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_elementIdentifier !=  os_16) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int ReAttemptIndicatorTLV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, ReAttemptIndicatorLV_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_reAttemptIndicatorLV.RAW_encode(ReAttemptIndicatorLV_descr_, *myleaf.body.node.nodes[1]);
  if (field_elementIdentifier !=  os_16) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_16.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct ReAttemptIndicatorTLV_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
ReAttemptIndicatorLV_template field_reAttemptIndicatorLV;
};

void ReAttemptIndicatorTLV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_reAttemptIndicatorLV = ANY_VALUE;
}
}
}

void ReAttemptIndicatorTLV_template::copy_value(const ReAttemptIndicatorTLV& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.reAttemptIndicatorLV().is_bound()) {
  single_value->field_reAttemptIndicatorLV = other_value.reAttemptIndicatorLV();
} else {
  single_value->field_reAttemptIndicatorLV.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ReAttemptIndicatorTLV_template::copy_template(const ReAttemptIndicatorTLV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reAttemptIndicatorLV().get_selection()) {
single_value->field_reAttemptIndicatorLV = other_value.reAttemptIndicatorLV();
} else {
single_value->field_reAttemptIndicatorLV.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ReAttemptIndicatorTLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ReAttemptIndicatorTLV_template(*other_value.implication_.precondition);
implication_.implied_template = new ReAttemptIndicatorTLV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
break;
}
set_selection(other_value);
}

ReAttemptIndicatorTLV_template::ReAttemptIndicatorTLV_template()
{
}

ReAttemptIndicatorTLV_template::ReAttemptIndicatorTLV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ReAttemptIndicatorTLV_template::ReAttemptIndicatorTLV_template(const ReAttemptIndicatorTLV& other_value)
{
copy_value(other_value);
}

ReAttemptIndicatorTLV_template::ReAttemptIndicatorTLV_template(const OPTIONAL<ReAttemptIndicatorTLV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ReAttemptIndicatorTLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV from an unbound optional field.");
}
}

ReAttemptIndicatorTLV_template::ReAttemptIndicatorTLV_template(ReAttemptIndicatorTLV_template* p_precondition, ReAttemptIndicatorTLV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ReAttemptIndicatorTLV_template::ReAttemptIndicatorTLV_template(Dynamic_Match_Interface<ReAttemptIndicatorTLV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ReAttemptIndicatorTLV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ReAttemptIndicatorTLV_template::ReAttemptIndicatorTLV_template(const ReAttemptIndicatorTLV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ReAttemptIndicatorTLV_template::~ReAttemptIndicatorTLV_template()
{
clean_up();
}

ReAttemptIndicatorTLV_template& ReAttemptIndicatorTLV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ReAttemptIndicatorTLV_template& ReAttemptIndicatorTLV_template::operator=(const ReAttemptIndicatorTLV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ReAttemptIndicatorTLV_template& ReAttemptIndicatorTLV_template::operator=(const OPTIONAL<ReAttemptIndicatorTLV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ReAttemptIndicatorTLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
}
return *this;
}

ReAttemptIndicatorTLV_template& ReAttemptIndicatorTLV_template::operator=(const ReAttemptIndicatorTLV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ReAttemptIndicatorTLV_template::match(const ReAttemptIndicatorTLV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.reAttemptIndicatorLV().is_bound()) return FALSE;
if(!single_value->field_reAttemptIndicatorLV.match(other_value.reAttemptIndicatorLV(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
}
return FALSE;
}

boolean ReAttemptIndicatorTLV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_reAttemptIndicatorLV.is_bound();
}

boolean ReAttemptIndicatorTLV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_reAttemptIndicatorLV.is_value();
}

void ReAttemptIndicatorTLV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ReAttemptIndicatorTLV ReAttemptIndicatorTLV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
ReAttemptIndicatorTLV ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_reAttemptIndicatorLV.is_bound()) {
ret_val.reAttemptIndicatorLV() = single_value->field_reAttemptIndicatorLV.valueof();
}
return ret_val;
}

void ReAttemptIndicatorTLV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ReAttemptIndicatorTLV_template[list_length];
}

ReAttemptIndicatorTLV_template& ReAttemptIndicatorTLV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& ReAttemptIndicatorTLV_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& ReAttemptIndicatorTLV_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
return single_value->field_elementIdentifier;
}

ReAttemptIndicatorLV_template& ReAttemptIndicatorTLV_template::reAttemptIndicatorLV()
{
set_specific();
return single_value->field_reAttemptIndicatorLV;
}

const ReAttemptIndicatorLV_template& ReAttemptIndicatorTLV_template::reAttemptIndicatorLV() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reAttemptIndicatorLV of a non-specific template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
return single_value->field_reAttemptIndicatorLV;
}

int ReAttemptIndicatorTLV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
  }
  return 0;
}

void ReAttemptIndicatorTLV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", reAttemptIndicatorLV := ");
single_value->field_reAttemptIndicatorLV.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ReAttemptIndicatorTLV_template::log_match(const ReAttemptIndicatorTLV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_reAttemptIndicatorLV.match(match_value.reAttemptIndicatorLV(), legacy)){
TTCN_Logger::log_logmatch_info(".reAttemptIndicatorLV");
single_value->field_reAttemptIndicatorLV.log_match(match_value.reAttemptIndicatorLV(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", reAttemptIndicatorLV := ");
single_value->field_reAttemptIndicatorLV.log_match(match_value.reAttemptIndicatorLV(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ReAttemptIndicatorTLV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_reAttemptIndicatorLV.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
}
}

void ReAttemptIndicatorTLV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_reAttemptIndicatorLV.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ReAttemptIndicatorTLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV.");
}
}

void ReAttemptIndicatorTLV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ReAttemptIndicatorTLV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reAttemptIndicatorLV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reAttemptIndicatorLV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reAttemptIndicatorLV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ReAttemptIndicatorTLV_template* precondition = new ReAttemptIndicatorTLV_template;
    precondition->set_param(*param.get_elem(0));
    ReAttemptIndicatorTLV_template* implied_template = new ReAttemptIndicatorTLV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ReAttemptIndicatorTLV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV");
  }
  is_ifpresent = param.get_ifpresent();
}

void ReAttemptIndicatorTLV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV");
single_value->field_reAttemptIndicatorLV.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.ReAttemptIndicatorTLV");
}

boolean ReAttemptIndicatorTLV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ReAttemptIndicatorTLV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SMCause2LV::SMCause2LV()
{
}

SMCause2LV::SMCause2LV(const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_sMCause2V)
  :   field_lengthIndicator(par_lengthIndicator),
  field_sMCause2V(par_sMCause2V)
{
}

SMCause2LV::SMCause2LV(const SMCause2LV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.SMCause2LV.");
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.sMCause2V().is_bound()) field_sMCause2V = other_value.sMCause2V();
else field_sMCause2V.clean_up();
}

void SMCause2LV::clean_up()
{
field_lengthIndicator.clean_up();
field_sMCause2V.clean_up();
}

const TTCN_Typedescriptor_t* SMCause2LV::get_descriptor() const { return &SMCause2LV_descr_; }
SMCause2LV& SMCause2LV::operator=(const SMCause2LV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.SMCause2LV.");
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.sMCause2V().is_bound()) field_sMCause2V = other_value.sMCause2V();
  else field_sMCause2V.clean_up();
}
return *this;
}

boolean SMCause2LV::operator==(const SMCause2LV& other_value) const
{
return field_lengthIndicator==other_value.field_lengthIndicator
  && field_sMCause2V==other_value.field_sMCause2V;
}

boolean SMCause2LV::is_bound() const
{
return (field_lengthIndicator.is_bound())
  || (field_sMCause2V.is_bound());
}
boolean SMCause2LV::is_value() const
{
return field_lengthIndicator.is_value()
  && field_sMCause2V.is_value();
}
void SMCause2LV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", sMCause2V := ");
field_sMCause2V.log();
TTCN_Logger::log_event_str(" }");
}

void SMCause2LV::set_implicit_omit()
{
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (sMCause2V().is_bound()) sMCause2V().set_implicit_omit();
}

void SMCause2LV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.SMCause2LV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) sMCause2V().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sMCause2V")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sMCause2V().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.SMCause2LV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.SMCause2LV");
  }
}

void SMCause2LV::encode_text(Text_Buf& text_buf) const
{
field_lengthIndicator.encode_text(text_buf);
field_sMCause2V.encode_text(text_buf);
}

void SMCause2LV::decode_text(Text_Buf& text_buf)
{
field_lengthIndicator.decode_text(text_buf);
field_sMCause2V.decode_text(text_buf);
}

void SMCause2LV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SMCause2LV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SMCause2LV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, SMCause2LV_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(SMCause2LV_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_lengthIndicator.convert_to_Integer(SMCause2LV_lengthIndicator_descr_);
  field_lengthIndicator = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_sMCause2V.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int SMCause2LV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, SMCause2LV_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::OCT1_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &SMCause2LV_lengthIndicator_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_sMCause2V.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct SMCause2LV_template::single_value_struct {
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_sMCause2V;
};

void SMCause2LV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_sMCause2V = ANY_VALUE;
}
}
}

void SMCause2LV_template::copy_value(const SMCause2LV& other_value)
{
single_value = new single_value_struct;
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.sMCause2V().is_bound()) {
  single_value->field_sMCause2V = other_value.sMCause2V();
} else {
  single_value->field_sMCause2V.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SMCause2LV_template::copy_template(const SMCause2LV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sMCause2V().get_selection()) {
single_value->field_sMCause2V = other_value.sMCause2V();
} else {
single_value->field_sMCause2V.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SMCause2LV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SMCause2LV_template(*other_value.implication_.precondition);
implication_.implied_template = new SMCause2LV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
break;
}
set_selection(other_value);
}

SMCause2LV_template::SMCause2LV_template()
{
}

SMCause2LV_template::SMCause2LV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SMCause2LV_template::SMCause2LV_template(const SMCause2LV& other_value)
{
copy_value(other_value);
}

SMCause2LV_template::SMCause2LV_template(const OPTIONAL<SMCause2LV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SMCause2LV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.SMCause2LV from an unbound optional field.");
}
}

SMCause2LV_template::SMCause2LV_template(SMCause2LV_template* p_precondition, SMCause2LV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SMCause2LV_template::SMCause2LV_template(Dynamic_Match_Interface<SMCause2LV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SMCause2LV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SMCause2LV_template::SMCause2LV_template(const SMCause2LV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SMCause2LV_template::~SMCause2LV_template()
{
clean_up();
}

SMCause2LV_template& SMCause2LV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SMCause2LV_template& SMCause2LV_template::operator=(const SMCause2LV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SMCause2LV_template& SMCause2LV_template::operator=(const OPTIONAL<SMCause2LV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SMCause2LV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
}
return *this;
}

SMCause2LV_template& SMCause2LV_template::operator=(const SMCause2LV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SMCause2LV_template::match(const SMCause2LV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.sMCause2V().is_bound()) return FALSE;
if(!single_value->field_sMCause2V.match(other_value.sMCause2V(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
}
return FALSE;
}

boolean SMCause2LV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_lengthIndicator.is_bound()
 || single_value->field_sMCause2V.is_bound();
}

boolean SMCause2LV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_lengthIndicator.is_value()
 && single_value->field_sMCause2V.is_value();
}

void SMCause2LV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SMCause2LV SMCause2LV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
SMCause2LV ret_val;
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_sMCause2V.is_bound()) {
ret_val.sMCause2V() = single_value->field_sMCause2V.valueof();
}
return ret_val;
}

void SMCause2LV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SMCause2LV_template[list_length];
}

SMCause2LV_template& SMCause2LV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
return value_list.list_value[list_index];
}

INTEGER_template& SMCause2LV_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& SMCause2LV_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& SMCause2LV_template::sMCause2V()
{
set_specific();
return single_value->field_sMCause2V;
}

const OCTETSTRING_template& SMCause2LV_template::sMCause2V() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sMCause2V of a non-specific template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
return single_value->field_sMCause2V;
}

int SMCause2LV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2LV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2LV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2LV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2LV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2LV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2LV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2LV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2LV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2LV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
  }
  return 0;
}

void SMCause2LV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", sMCause2V := ");
single_value->field_sMCause2V.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SMCause2LV_template::log_match(const SMCause2LV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sMCause2V.match(match_value.sMCause2V(), legacy)){
TTCN_Logger::log_logmatch_info(".sMCause2V");
single_value->field_sMCause2V.log_match(match_value.sMCause2V(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", sMCause2V := ");
single_value->field_sMCause2V.log_match(match_value.sMCause2V(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SMCause2LV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_sMCause2V.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
}
}

void SMCause2LV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_sMCause2V.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SMCause2LV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.SMCause2LV.");
}
}

void SMCause2LV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SMCause2LV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.SMCause2LV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) sMCause2V().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sMCause2V")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sMCause2V().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.SMCause2LV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SMCause2LV_template* precondition = new SMCause2LV_template;
    precondition->set_param(*param.get_elem(0));
    SMCause2LV_template* implied_template = new SMCause2LV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SMCause2LV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.SMCause2LV");
  }
  is_ifpresent = param.get_ifpresent();
}

void SMCause2LV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.SMCause2LV");
single_value->field_sMCause2V.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.SMCause2LV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.SMCause2LV");
}

boolean SMCause2LV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SMCause2LV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SMCause2TLV::SMCause2TLV()
{
}

SMCause2TLV::SMCause2TLV(const OCTETSTRING& par_elementIdentifier,
    const SMCause2LV& par_sMCause2LV)
  :   field_elementIdentifier(par_elementIdentifier),
  field_sMCause2LV(par_sMCause2LV)
{
}

SMCause2TLV::SMCause2TLV(const SMCause2TLV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.sMCause2LV().is_bound()) field_sMCause2LV = other_value.sMCause2LV();
else field_sMCause2LV.clean_up();
}

void SMCause2TLV::clean_up()
{
field_elementIdentifier.clean_up();
field_sMCause2LV.clean_up();
}

const TTCN_Typedescriptor_t* SMCause2TLV::get_descriptor() const { return &SMCause2TLV_descr_; }
SMCause2TLV& SMCause2TLV::operator=(const SMCause2TLV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.sMCause2LV().is_bound()) field_sMCause2LV = other_value.sMCause2LV();
  else field_sMCause2LV.clean_up();
}
return *this;
}

boolean SMCause2TLV::operator==(const SMCause2TLV& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_sMCause2LV==other_value.field_sMCause2LV;
}

boolean SMCause2TLV::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_sMCause2LV.is_bound());
}
boolean SMCause2TLV::is_value() const
{
return field_elementIdentifier.is_value()
  && field_sMCause2LV.is_value();
}
void SMCause2TLV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", sMCause2LV := ");
field_sMCause2LV.log();
TTCN_Logger::log_event_str(" }");
}

void SMCause2TLV::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (sMCause2LV().is_bound()) sMCause2LV().set_implicit_omit();
}

void SMCause2TLV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.SMCause2TLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) sMCause2LV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sMCause2LV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sMCause2LV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.SMCause2TLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.SMCause2TLV");
  }
}

void SMCause2TLV::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_sMCause2LV.encode_text(text_buf);
}

void SMCause2TLV::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_sMCause2LV.decode_text(text_buf);
}

void SMCause2TLV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SMCause2TLV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SMCause2TLV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, SMCause2LV_descr_.raw->forceomit);
  decoded_field_length = field_sMCause2LV.RAW_decode(SMCause2LV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_elementIdentifier !=  os_17) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int SMCause2TLV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, SMCause2LV_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_sMCause2LV.RAW_encode(SMCause2LV_descr_, *myleaf.body.node.nodes[1]);
  if (field_elementIdentifier !=  os_17) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_17.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct SMCause2TLV_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
SMCause2LV_template field_sMCause2LV;
};

void SMCause2TLV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_sMCause2LV = ANY_VALUE;
}
}
}

void SMCause2TLV_template::copy_value(const SMCause2TLV& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.sMCause2LV().is_bound()) {
  single_value->field_sMCause2LV = other_value.sMCause2LV();
} else {
  single_value->field_sMCause2LV.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SMCause2TLV_template::copy_template(const SMCause2TLV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sMCause2LV().get_selection()) {
single_value->field_sMCause2LV = other_value.sMCause2LV();
} else {
single_value->field_sMCause2LV.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SMCause2TLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SMCause2TLV_template(*other_value.implication_.precondition);
implication_.implied_template = new SMCause2TLV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
break;
}
set_selection(other_value);
}

SMCause2TLV_template::SMCause2TLV_template()
{
}

SMCause2TLV_template::SMCause2TLV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SMCause2TLV_template::SMCause2TLV_template(const SMCause2TLV& other_value)
{
copy_value(other_value);
}

SMCause2TLV_template::SMCause2TLV_template(const OPTIONAL<SMCause2TLV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SMCause2TLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.SMCause2TLV from an unbound optional field.");
}
}

SMCause2TLV_template::SMCause2TLV_template(SMCause2TLV_template* p_precondition, SMCause2TLV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SMCause2TLV_template::SMCause2TLV_template(Dynamic_Match_Interface<SMCause2TLV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SMCause2TLV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SMCause2TLV_template::SMCause2TLV_template(const SMCause2TLV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SMCause2TLV_template::~SMCause2TLV_template()
{
clean_up();
}

SMCause2TLV_template& SMCause2TLV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SMCause2TLV_template& SMCause2TLV_template::operator=(const SMCause2TLV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SMCause2TLV_template& SMCause2TLV_template::operator=(const OPTIONAL<SMCause2TLV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SMCause2TLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
}
return *this;
}

SMCause2TLV_template& SMCause2TLV_template::operator=(const SMCause2TLV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SMCause2TLV_template::match(const SMCause2TLV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.sMCause2LV().is_bound()) return FALSE;
if(!single_value->field_sMCause2LV.match(other_value.sMCause2LV(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
}
return FALSE;
}

boolean SMCause2TLV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_sMCause2LV.is_bound();
}

boolean SMCause2TLV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_sMCause2LV.is_value();
}

void SMCause2TLV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SMCause2TLV SMCause2TLV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
SMCause2TLV ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_sMCause2LV.is_bound()) {
ret_val.sMCause2LV() = single_value->field_sMCause2LV.valueof();
}
return ret_val;
}

void SMCause2TLV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SMCause2TLV_template[list_length];
}

SMCause2TLV_template& SMCause2TLV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& SMCause2TLV_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& SMCause2TLV_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
return single_value->field_elementIdentifier;
}

SMCause2LV_template& SMCause2TLV_template::sMCause2LV()
{
set_specific();
return single_value->field_sMCause2LV;
}

const SMCause2LV_template& SMCause2TLV_template::sMCause2LV() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sMCause2LV of a non-specific template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
return single_value->field_sMCause2LV;
}

int SMCause2TLV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2TLV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2TLV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2TLV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2TLV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2TLV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2TLV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2TLV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2TLV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.SMCause2TLV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
  }
  return 0;
}

void SMCause2TLV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", sMCause2LV := ");
single_value->field_sMCause2LV.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SMCause2TLV_template::log_match(const SMCause2TLV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sMCause2LV.match(match_value.sMCause2LV(), legacy)){
TTCN_Logger::log_logmatch_info(".sMCause2LV");
single_value->field_sMCause2LV.log_match(match_value.sMCause2LV(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", sMCause2LV := ");
single_value->field_sMCause2LV.log_match(match_value.sMCause2LV(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SMCause2TLV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_sMCause2LV.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
}
}

void SMCause2TLV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_sMCause2LV.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SMCause2TLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.SMCause2TLV.");
}
}

void SMCause2TLV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SMCause2TLV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.SMCause2TLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) sMCause2LV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sMCause2LV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sMCause2LV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.SMCause2TLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SMCause2TLV_template* precondition = new SMCause2TLV_template;
    precondition->set_param(*param.get_elem(0));
    SMCause2TLV_template* implied_template = new SMCause2TLV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SMCause2TLV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.SMCause2TLV");
  }
  is_ifpresent = param.get_ifpresent();
}

void SMCause2TLV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.SMCause2TLV");
single_value->field_sMCause2LV.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.SMCause2TLV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.SMCause2TLV");
}

boolean SMCause2TLV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SMCause2TLV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

LinkedTIV::LinkedTIV()
{
}

LinkedTIV::LinkedTIV(const BITSTRING& par_spare,
    const BITSTRING& par_tio,
    const BITSTRING& par_tiFlag,
    const OPTIONAL< TI__Extension >& par_tIExtension)
  :   field_spare(par_spare),
  field_tio(par_tio),
  field_tiFlag(par_tiFlag),
  field_tIExtension(par_tIExtension)
{
}

LinkedTIV::LinkedTIV(const LinkedTIV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.LinkedTIV.");
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.tio().is_bound()) field_tio = other_value.tio();
else field_tio.clean_up();
if (other_value.tiFlag().is_bound()) field_tiFlag = other_value.tiFlag();
else field_tiFlag.clean_up();
if (other_value.tIExtension().is_bound()) field_tIExtension = other_value.tIExtension();
else field_tIExtension.clean_up();
}

void LinkedTIV::clean_up()
{
field_spare.clean_up();
field_tio.clean_up();
field_tiFlag.clean_up();
field_tIExtension.clean_up();
}

const TTCN_Typedescriptor_t* LinkedTIV::get_descriptor() const { return &LinkedTIV_descr_; }
LinkedTIV& LinkedTIV::operator=(const LinkedTIV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.LinkedTIV.");
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.tio().is_bound()) field_tio = other_value.tio();
  else field_tio.clean_up();
  if (other_value.tiFlag().is_bound()) field_tiFlag = other_value.tiFlag();
  else field_tiFlag.clean_up();
  if (other_value.tIExtension().is_bound()) field_tIExtension = other_value.tIExtension();
  else field_tIExtension.clean_up();
}
return *this;
}

boolean LinkedTIV::operator==(const LinkedTIV& other_value) const
{
return field_spare==other_value.field_spare
  && field_tio==other_value.field_tio
  && field_tiFlag==other_value.field_tiFlag
  && field_tIExtension==other_value.field_tIExtension;
}

boolean LinkedTIV::is_bound() const
{
return (field_spare.is_bound())
  || (field_tio.is_bound())
  || (field_tiFlag.is_bound())
  || (OPTIONAL_OMIT == field_tIExtension.get_selection() || field_tIExtension.is_bound());
}
boolean LinkedTIV::is_value() const
{
return field_spare.is_value()
  && field_tio.is_value()
  && field_tiFlag.is_value()
  && (OPTIONAL_OMIT == field_tIExtension.get_selection() || field_tIExtension.is_value());
}
int LinkedTIV::size_of() const
{
  int ret_val = 3;
  if (field_tIExtension.ispresent()) ret_val++;
  return ret_val;
}

void LinkedTIV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", tio := ");
field_tio.log();
TTCN_Logger::log_event_str(", tiFlag := ");
field_tiFlag.log();
TTCN_Logger::log_event_str(", tIExtension := ");
field_tIExtension.log();
TTCN_Logger::log_event_str(" }");
}

void LinkedTIV::set_implicit_omit()
{
if (spare().is_bound()) spare().set_implicit_omit();
if (tio().is_bound()) tio().set_implicit_omit();
if (tiFlag().is_bound()) tiFlag().set_implicit_omit();
if (!tIExtension().is_bound()) tIExtension() = OMIT_VALUE;
else tIExtension().set_implicit_omit();
}

void LinkedTIV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.LinkedTIV has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) tio().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) tiFlag().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) tIExtension().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tio")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tio().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tiFlag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tiFlag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tIExtension")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tIExtension().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.LinkedTIV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.LinkedTIV");
  }
}

void LinkedTIV::encode_text(Text_Buf& text_buf) const
{
field_spare.encode_text(text_buf);
field_tio.encode_text(text_buf);
field_tiFlag.encode_text(text_buf);
field_tIExtension.encode_text(text_buf);
}

void LinkedTIV::decode_text(Text_Buf& text_buf)
{
field_spare.decode_text(text_buf);
field_tio.decode_text(text_buf);
field_tiFlag.decode_text(text_buf);
field_tIExtension.decode_text(text_buf);
}

void LinkedTIV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void LinkedTIV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int LinkedTIV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_tio.RAW_decode(General__Types::BIT3_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_tiFlag.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_tio ==  bs_14){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_tIExtension = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, LinkedTIV_tIExtension_descr_.raw->forceomit);
  decoded_field_length = field_tIExtension().RAW_decode(LinkedTIV_tIExtension_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_tIExtension = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_tIExtension=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int LinkedTIV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT3_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT1_descr_.raw);
  if (field_tIExtension.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, LinkedTIV_tIExtension_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  encoded_length += field_spare.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_tio.RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_tiFlag.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[2]);
  if (field_tIExtension.ispresent()) {
  encoded_length += field_tIExtension().RAW_encode(LinkedTIV_tIExtension_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_tIExtension.ispresent() && (field_tio !=  bs_14)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={1};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_14.RAW_encode(General__Types::BIT3_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct LinkedTIV_template::single_value_struct {
BITSTRING_template field_spare;
BITSTRING_template field_tio;
BITSTRING_template field_tiFlag;
TI__Extension_template field_tIExtension;
};

void LinkedTIV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_spare = ANY_VALUE;
single_value->field_tio = ANY_VALUE;
single_value->field_tiFlag = ANY_VALUE;
single_value->field_tIExtension = ANY_OR_OMIT;
}
}
}

void LinkedTIV_template::copy_value(const LinkedTIV& other_value)
{
single_value = new single_value_struct;
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.tio().is_bound()) {
  single_value->field_tio = other_value.tio();
} else {
  single_value->field_tio.clean_up();
}
if (other_value.tiFlag().is_bound()) {
  single_value->field_tiFlag = other_value.tiFlag();
} else {
  single_value->field_tiFlag.clean_up();
}
if (other_value.tIExtension().is_bound()) {
  if (other_value.tIExtension().ispresent()) single_value->field_tIExtension = other_value.tIExtension()();
  else single_value->field_tIExtension = OMIT_VALUE;
} else {
  single_value->field_tIExtension.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void LinkedTIV_template::copy_template(const LinkedTIV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tio().get_selection()) {
single_value->field_tio = other_value.tio();
} else {
single_value->field_tio.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tiFlag().get_selection()) {
single_value->field_tiFlag = other_value.tiFlag();
} else {
single_value->field_tiFlag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tIExtension().get_selection()) {
single_value->field_tIExtension = other_value.tIExtension();
} else {
single_value->field_tIExtension.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new LinkedTIV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new LinkedTIV_template(*other_value.implication_.precondition);
implication_.implied_template = new LinkedTIV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
break;
}
set_selection(other_value);
}

LinkedTIV_template::LinkedTIV_template()
{
}

LinkedTIV_template::LinkedTIV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

LinkedTIV_template::LinkedTIV_template(const LinkedTIV& other_value)
{
copy_value(other_value);
}

LinkedTIV_template::LinkedTIV_template(const OPTIONAL<LinkedTIV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LinkedTIV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.LinkedTIV from an unbound optional field.");
}
}

LinkedTIV_template::LinkedTIV_template(LinkedTIV_template* p_precondition, LinkedTIV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

LinkedTIV_template::LinkedTIV_template(Dynamic_Match_Interface<LinkedTIV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<LinkedTIV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

LinkedTIV_template::LinkedTIV_template(const LinkedTIV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

LinkedTIV_template::~LinkedTIV_template()
{
clean_up();
}

LinkedTIV_template& LinkedTIV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

LinkedTIV_template& LinkedTIV_template::operator=(const LinkedTIV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

LinkedTIV_template& LinkedTIV_template::operator=(const OPTIONAL<LinkedTIV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LinkedTIV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
}
return *this;
}

LinkedTIV_template& LinkedTIV_template::operator=(const LinkedTIV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean LinkedTIV_template::match(const LinkedTIV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.tio().is_bound()) return FALSE;
if(!single_value->field_tio.match(other_value.tio(), legacy))return FALSE;
if(!other_value.tiFlag().is_bound()) return FALSE;
if(!single_value->field_tiFlag.match(other_value.tiFlag(), legacy))return FALSE;
if(!other_value.tIExtension().is_bound()) return FALSE;
if((other_value.tIExtension().ispresent() ? !single_value->field_tIExtension.match((const TI__Extension&)other_value.tIExtension(), legacy) : !single_value->field_tIExtension.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
}
return FALSE;
}

boolean LinkedTIV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_spare.is_bound()
 || single_value->field_tio.is_bound()
 || single_value->field_tiFlag.is_bound()
 || (single_value->field_tIExtension.is_omit() || single_value->field_tIExtension.is_bound());
}

boolean LinkedTIV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_spare.is_value()
 && single_value->field_tio.is_value()
 && single_value->field_tiFlag.is_value()
 && (single_value->field_tIExtension.is_omit() || single_value->field_tIExtension.is_value());
}

void LinkedTIV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

LinkedTIV LinkedTIV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
LinkedTIV ret_val;
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_tio.is_bound()) {
ret_val.tio() = single_value->field_tio.valueof();
}
if (single_value->field_tiFlag.is_bound()) {
ret_val.tiFlag() = single_value->field_tiFlag.valueof();
}
if (single_value->field_tIExtension.is_omit()) ret_val.tIExtension() = OMIT_VALUE;
else if (single_value->field_tIExtension.is_bound()) {
ret_val.tIExtension() = single_value->field_tIExtension.valueof();
}
return ret_val;
}

void LinkedTIV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new LinkedTIV_template[list_length];
}

LinkedTIV_template& LinkedTIV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
return value_list.list_value[list_index];
}

BITSTRING_template& LinkedTIV_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& LinkedTIV_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
return single_value->field_spare;
}

BITSTRING_template& LinkedTIV_template::tio()
{
set_specific();
return single_value->field_tio;
}

const BITSTRING_template& LinkedTIV_template::tio() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tio of a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
return single_value->field_tio;
}

BITSTRING_template& LinkedTIV_template::tiFlag()
{
set_specific();
return single_value->field_tiFlag;
}

const BITSTRING_template& LinkedTIV_template::tiFlag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tiFlag of a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
return single_value->field_tiFlag;
}

TI__Extension_template& LinkedTIV_template::tIExtension()
{
set_specific();
return single_value->field_tIExtension;
}

const TI__Extension_template& LinkedTIV_template::tIExtension() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tIExtension of a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
return single_value->field_tIExtension;
}

int LinkedTIV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTIV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 3;
      if (single_value->field_tIExtension.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTIV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTIV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTIV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTIV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTIV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTIV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTIV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTIV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
  }
  return 0;
}

void LinkedTIV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", tio := ");
single_value->field_tio.log();
TTCN_Logger::log_event_str(", tiFlag := ");
single_value->field_tiFlag.log();
TTCN_Logger::log_event_str(", tIExtension := ");
single_value->field_tIExtension.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void LinkedTIV_template::log_match(const LinkedTIV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_tio.match(match_value.tio(), legacy)){
TTCN_Logger::log_logmatch_info(".tio");
single_value->field_tio.log_match(match_value.tio(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_tiFlag.match(match_value.tiFlag(), legacy)){
TTCN_Logger::log_logmatch_info(".tiFlag");
single_value->field_tiFlag.log_match(match_value.tiFlag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.tIExtension().ispresent()){
if(!single_value->field_tIExtension.match(match_value.tIExtension(), legacy)){
TTCN_Logger::log_logmatch_info(".tIExtension");
single_value->field_tIExtension.log_match(match_value.tIExtension(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_tIExtension.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".tIExtension := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_tIExtension.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", tio := ");
single_value->field_tio.log_match(match_value.tio(), legacy);
TTCN_Logger::log_event_str(", tiFlag := ");
single_value->field_tiFlag.log_match(match_value.tiFlag(), legacy);
TTCN_Logger::log_event_str(", tIExtension := ");
if (match_value.tIExtension().ispresent()) {
single_value->field_tIExtension.log_match(match_value.tIExtension(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_tIExtension.log();
if (single_value->field_tIExtension.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void LinkedTIV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_spare.encode_text(text_buf);
single_value->field_tio.encode_text(text_buf);
single_value->field_tiFlag.encode_text(text_buf);
single_value->field_tIExtension.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
}
}

void LinkedTIV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_spare.decode_text(text_buf);
single_value->field_tio.decode_text(text_buf);
single_value->field_tiFlag.decode_text(text_buf);
single_value->field_tIExtension.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new LinkedTIV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.LinkedTIV.");
}
}

void LinkedTIV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    LinkedTIV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.LinkedTIV has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) tio().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) tiFlag().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) tIExtension().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tio")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tio().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tiFlag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tiFlag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tIExtension")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tIExtension().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.LinkedTIV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    LinkedTIV_template* precondition = new LinkedTIV_template;
    precondition->set_param(*param.get_elem(0));
    LinkedTIV_template* implied_template = new LinkedTIV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = LinkedTIV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.LinkedTIV");
  }
  is_ifpresent = param.get_ifpresent();
}

void LinkedTIV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTIV");
single_value->field_tio.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTIV");
single_value->field_tiFlag.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTIV");
single_value->field_tIExtension.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTIV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTIV");
}

boolean LinkedTIV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean LinkedTIV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

TI__Extension::TI__Extension()
{
}

TI__Extension::TI__Extension(const BITSTRING& par_tI__Value,
    const BITSTRING& par_tI__ExtBit)
  :   field_tI__Value(par_tI__Value),
  field_tI__ExtBit(par_tI__ExtBit)
{
}

TI__Extension::TI__Extension(const TI__Extension& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.TI_Extension.");
if (other_value.tI__Value().is_bound()) field_tI__Value = other_value.tI__Value();
else field_tI__Value.clean_up();
if (other_value.tI__ExtBit().is_bound()) field_tI__ExtBit = other_value.tI__ExtBit();
else field_tI__ExtBit.clean_up();
}

void TI__Extension::clean_up()
{
field_tI__Value.clean_up();
field_tI__ExtBit.clean_up();
}

const TTCN_Typedescriptor_t* TI__Extension::get_descriptor() const { return &TI__Extension_descr_; }
TI__Extension& TI__Extension::operator=(const TI__Extension& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.TI_Extension.");
  if (other_value.tI__Value().is_bound()) field_tI__Value = other_value.tI__Value();
  else field_tI__Value.clean_up();
  if (other_value.tI__ExtBit().is_bound()) field_tI__ExtBit = other_value.tI__ExtBit();
  else field_tI__ExtBit.clean_up();
}
return *this;
}

boolean TI__Extension::operator==(const TI__Extension& other_value) const
{
return field_tI__Value==other_value.field_tI__Value
  && field_tI__ExtBit==other_value.field_tI__ExtBit;
}

boolean TI__Extension::is_bound() const
{
return (field_tI__Value.is_bound())
  || (field_tI__ExtBit.is_bound());
}
boolean TI__Extension::is_value() const
{
return field_tI__Value.is_value()
  && field_tI__ExtBit.is_value();
}
void TI__Extension::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ tI_Value := ");
field_tI__Value.log();
TTCN_Logger::log_event_str(", tI_ExtBit := ");
field_tI__ExtBit.log();
TTCN_Logger::log_event_str(" }");
}

void TI__Extension::set_implicit_omit()
{
if (tI__Value().is_bound()) tI__Value().set_implicit_omit();
if (tI__ExtBit().is_bound()) tI__ExtBit().set_implicit_omit();
}

void TI__Extension::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.TI_Extension has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tI__Value().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) tI__ExtBit().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tI_Value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tI__Value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tI_ExtBit")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tI__ExtBit().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.TI_Extension: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.TI_Extension");
  }
}

void TI__Extension::encode_text(Text_Buf& text_buf) const
{
field_tI__Value.encode_text(text_buf);
field_tI__ExtBit.encode_text(text_buf);
}

void TI__Extension::decode_text(Text_Buf& text_buf)
{
field_tI__Value.decode_text(text_buf);
field_tI__ExtBit.decode_text(text_buf);
}

void TI__Extension::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void TI__Extension::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int TI__Extension::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT7_descr_.raw->forceomit);
  decoded_field_length = field_tI__Value.RAW_decode(General__Types::BIT7_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_tI__ExtBit.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int TI__Extension::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT7_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT1_descr_.raw);
  encoded_length += field_tI__Value.RAW_encode(General__Types::BIT7_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_tI__ExtBit.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct TI__Extension_template::single_value_struct {
BITSTRING_template field_tI__Value;
BITSTRING_template field_tI__ExtBit;
};

void TI__Extension_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_tI__Value = ANY_VALUE;
single_value->field_tI__ExtBit = ANY_VALUE;
}
}
}

void TI__Extension_template::copy_value(const TI__Extension& other_value)
{
single_value = new single_value_struct;
if (other_value.tI__Value().is_bound()) {
  single_value->field_tI__Value = other_value.tI__Value();
} else {
  single_value->field_tI__Value.clean_up();
}
if (other_value.tI__ExtBit().is_bound()) {
  single_value->field_tI__ExtBit = other_value.tI__ExtBit();
} else {
  single_value->field_tI__ExtBit.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void TI__Extension_template::copy_template(const TI__Extension_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.tI__Value().get_selection()) {
single_value->field_tI__Value = other_value.tI__Value();
} else {
single_value->field_tI__Value.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tI__ExtBit().get_selection()) {
single_value->field_tI__ExtBit = other_value.tI__ExtBit();
} else {
single_value->field_tI__ExtBit.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new TI__Extension_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new TI__Extension_template(*other_value.implication_.precondition);
implication_.implied_template = new TI__Extension_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.TI_Extension.");
break;
}
set_selection(other_value);
}

TI__Extension_template::TI__Extension_template()
{
}

TI__Extension_template::TI__Extension_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

TI__Extension_template::TI__Extension_template(const TI__Extension& other_value)
{
copy_value(other_value);
}

TI__Extension_template::TI__Extension_template(const OPTIONAL<TI__Extension>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const TI__Extension&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.TI_Extension from an unbound optional field.");
}
}

TI__Extension_template::TI__Extension_template(TI__Extension_template* p_precondition, TI__Extension_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

TI__Extension_template::TI__Extension_template(Dynamic_Match_Interface<TI__Extension>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<TI__Extension>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

TI__Extension_template::TI__Extension_template(const TI__Extension_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

TI__Extension_template::~TI__Extension_template()
{
clean_up();
}

TI__Extension_template& TI__Extension_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

TI__Extension_template& TI__Extension_template::operator=(const TI__Extension& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

TI__Extension_template& TI__Extension_template::operator=(const OPTIONAL<TI__Extension>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const TI__Extension&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.TI_Extension.");
}
return *this;
}

TI__Extension_template& TI__Extension_template::operator=(const TI__Extension_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean TI__Extension_template::match(const TI__Extension& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.tI__Value().is_bound()) return FALSE;
if(!single_value->field_tI__Value.match(other_value.tI__Value(), legacy))return FALSE;
if(!other_value.tI__ExtBit().is_bound()) return FALSE;
if(!single_value->field_tI__ExtBit.match(other_value.tI__ExtBit(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.TI_Extension.");
}
return FALSE;
}

boolean TI__Extension_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_tI__Value.is_bound()
 || single_value->field_tI__ExtBit.is_bound();
}

boolean TI__Extension_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_tI__Value.is_value()
 && single_value->field_tI__ExtBit.is_value();
}

void TI__Extension_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

TI__Extension TI__Extension_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.TI_Extension.");
TI__Extension ret_val;
if (single_value->field_tI__Value.is_bound()) {
ret_val.tI__Value() = single_value->field_tI__Value.valueof();
}
if (single_value->field_tI__ExtBit.is_bound()) {
ret_val.tI__ExtBit() = single_value->field_tI__ExtBit.valueof();
}
return ret_val;
}

void TI__Extension_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.TI_Extension.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new TI__Extension_template[list_length];
}

TI__Extension_template& TI__Extension_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.TI_Extension.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.TI_Extension.");
return value_list.list_value[list_index];
}

BITSTRING_template& TI__Extension_template::tI__Value()
{
set_specific();
return single_value->field_tI__Value;
}

const BITSTRING_template& TI__Extension_template::tI__Value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tI_Value of a non-specific template of type @MobileL3_GMM_SM_Types.TI_Extension.");
return single_value->field_tI__Value;
}

BITSTRING_template& TI__Extension_template::tI__ExtBit()
{
set_specific();
return single_value->field_tI__ExtBit;
}

const BITSTRING_template& TI__Extension_template::tI__ExtBit() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tI_ExtBit of a non-specific template of type @MobileL3_GMM_SM_Types.TI_Extension.");
return single_value->field_tI__ExtBit;
}

int TI__Extension_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TI_Extension which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TI_Extension containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TI_Extension containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TI_Extension containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TI_Extension containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TI_Extension containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TI_Extension containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TI_Extension containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.TI_Extension containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.TI_Extension.");
  }
  return 0;
}

void TI__Extension_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ tI_Value := ");
single_value->field_tI__Value.log();
TTCN_Logger::log_event_str(", tI_ExtBit := ");
single_value->field_tI__ExtBit.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void TI__Extension_template::log_match(const TI__Extension& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_tI__Value.match(match_value.tI__Value(), legacy)){
TTCN_Logger::log_logmatch_info(".tI_Value");
single_value->field_tI__Value.log_match(match_value.tI__Value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_tI__ExtBit.match(match_value.tI__ExtBit(), legacy)){
TTCN_Logger::log_logmatch_info(".tI_ExtBit");
single_value->field_tI__ExtBit.log_match(match_value.tI__ExtBit(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ tI_Value := ");
single_value->field_tI__Value.log_match(match_value.tI__Value(), legacy);
TTCN_Logger::log_event_str(", tI_ExtBit := ");
single_value->field_tI__ExtBit.log_match(match_value.tI__ExtBit(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void TI__Extension_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_tI__Value.encode_text(text_buf);
single_value->field_tI__ExtBit.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.TI_Extension.");
}
}

void TI__Extension_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_tI__Value.decode_text(text_buf);
single_value->field_tI__ExtBit.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new TI__Extension_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.TI_Extension.");
}
}

void TI__Extension_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    TI__Extension_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.TI_Extension has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) tI__Value().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) tI__ExtBit().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tI_Value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tI__Value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tI_ExtBit")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tI__ExtBit().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.TI_Extension: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    TI__Extension_template* precondition = new TI__Extension_template;
    precondition->set_param(*param.get_elem(0));
    TI__Extension_template* implied_template = new TI__Extension_template;
    implied_template->set_param(*param.get_elem(1));
    *this = TI__Extension_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.TI_Extension");
  }
  is_ifpresent = param.get_ifpresent();
}

void TI__Extension_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_tI__Value.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.TI_Extension");
single_value->field_tI__ExtBit.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.TI_Extension");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.TI_Extension");
}

boolean TI__Extension_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean TI__Extension_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

LinkedTILV::LinkedTILV()
{
}

LinkedTILV::LinkedTILV(const INTEGER& par_lengthIndicator,
    const LinkedTIV& par_valueField)
  :   field_lengthIndicator(par_lengthIndicator),
  field_valueField(par_valueField)
{
}

LinkedTILV::LinkedTILV(const LinkedTILV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.LinkedTILV.");
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
else field_valueField.clean_up();
}

void LinkedTILV::clean_up()
{
field_lengthIndicator.clean_up();
field_valueField.clean_up();
}

const TTCN_Typedescriptor_t* LinkedTILV::get_descriptor() const { return &LinkedTILV_descr_; }
LinkedTILV& LinkedTILV::operator=(const LinkedTILV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.LinkedTILV.");
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
  else field_valueField.clean_up();
}
return *this;
}

boolean LinkedTILV::operator==(const LinkedTILV& other_value) const
{
return field_lengthIndicator==other_value.field_lengthIndicator
  && field_valueField==other_value.field_valueField;
}

boolean LinkedTILV::is_bound() const
{
return (field_lengthIndicator.is_bound())
  || (field_valueField.is_bound());
}
boolean LinkedTILV::is_value() const
{
return field_lengthIndicator.is_value()
  && field_valueField.is_value();
}
void LinkedTILV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", valueField := ");
field_valueField.log();
TTCN_Logger::log_event_str(" }");
}

void LinkedTILV::set_implicit_omit()
{
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (valueField().is_bound()) valueField().set_implicit_omit();
}

void LinkedTILV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.LinkedTILV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.LinkedTILV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.LinkedTILV");
  }
}

void LinkedTILV::encode_text(Text_Buf& text_buf) const
{
field_lengthIndicator.encode_text(text_buf);
field_valueField.encode_text(text_buf);
}

void LinkedTILV::decode_text(Text_Buf& text_buf)
{
field_lengthIndicator.decode_text(text_buf);
field_valueField.decode_text(text_buf);
}

void LinkedTILV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void LinkedTILV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int LinkedTILV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, LinkedTILV_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(LinkedTILV_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_lengthIndicator.convert_to_Integer(LinkedTILV_lengthIndicator_descr_);
  field_lengthIndicator = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, LinkedTIV_descr_.raw->forceomit);
  decoded_field_length = field_valueField.RAW_decode(LinkedTIV_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int LinkedTILV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, LinkedTILV_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, LinkedTIV_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &LinkedTILV_lengthIndicator_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_valueField.RAW_encode(LinkedTIV_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct LinkedTILV_template::single_value_struct {
INTEGER_template field_lengthIndicator;
LinkedTIV_template field_valueField;
};

void LinkedTILV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_valueField = ANY_VALUE;
}
}
}

void LinkedTILV_template::copy_value(const LinkedTILV& other_value)
{
single_value = new single_value_struct;
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.valueField().is_bound()) {
  single_value->field_valueField = other_value.valueField();
} else {
  single_value->field_valueField.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void LinkedTILV_template::copy_template(const LinkedTILV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.valueField().get_selection()) {
single_value->field_valueField = other_value.valueField();
} else {
single_value->field_valueField.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new LinkedTILV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new LinkedTILV_template(*other_value.implication_.precondition);
implication_.implied_template = new LinkedTILV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
break;
}
set_selection(other_value);
}

LinkedTILV_template::LinkedTILV_template()
{
}

LinkedTILV_template::LinkedTILV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

LinkedTILV_template::LinkedTILV_template(const LinkedTILV& other_value)
{
copy_value(other_value);
}

LinkedTILV_template::LinkedTILV_template(const OPTIONAL<LinkedTILV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LinkedTILV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.LinkedTILV from an unbound optional field.");
}
}

LinkedTILV_template::LinkedTILV_template(LinkedTILV_template* p_precondition, LinkedTILV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

LinkedTILV_template::LinkedTILV_template(Dynamic_Match_Interface<LinkedTILV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<LinkedTILV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

LinkedTILV_template::LinkedTILV_template(const LinkedTILV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

LinkedTILV_template::~LinkedTILV_template()
{
clean_up();
}

LinkedTILV_template& LinkedTILV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

LinkedTILV_template& LinkedTILV_template::operator=(const LinkedTILV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

LinkedTILV_template& LinkedTILV_template::operator=(const OPTIONAL<LinkedTILV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LinkedTILV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
}
return *this;
}

LinkedTILV_template& LinkedTILV_template::operator=(const LinkedTILV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean LinkedTILV_template::match(const LinkedTILV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.valueField().is_bound()) return FALSE;
if(!single_value->field_valueField.match(other_value.valueField(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
}
return FALSE;
}

boolean LinkedTILV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_lengthIndicator.is_bound()
 || single_value->field_valueField.is_bound();
}

boolean LinkedTILV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_lengthIndicator.is_value()
 && single_value->field_valueField.is_value();
}

void LinkedTILV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

LinkedTILV LinkedTILV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
LinkedTILV ret_val;
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_valueField.is_bound()) {
ret_val.valueField() = single_value->field_valueField.valueof();
}
return ret_val;
}

void LinkedTILV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new LinkedTILV_template[list_length];
}

LinkedTILV_template& LinkedTILV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
return value_list.list_value[list_index];
}

INTEGER_template& LinkedTILV_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& LinkedTILV_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
return single_value->field_lengthIndicator;
}

LinkedTIV_template& LinkedTILV_template::valueField()
{
set_specific();
return single_value->field_valueField;
}

const LinkedTIV_template& LinkedTILV_template::valueField() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field valueField of a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
return single_value->field_valueField;
}

int LinkedTILV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTILV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTILV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTILV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTILV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTILV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTILV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTILV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTILV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTILV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
  }
  return 0;
}

void LinkedTILV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", valueField := ");
single_value->field_valueField.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void LinkedTILV_template::log_match(const LinkedTILV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_valueField.match(match_value.valueField(), legacy)){
TTCN_Logger::log_logmatch_info(".valueField");
single_value->field_valueField.log_match(match_value.valueField(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", valueField := ");
single_value->field_valueField.log_match(match_value.valueField(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void LinkedTILV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_valueField.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
}
}

void LinkedTILV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_valueField.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new LinkedTILV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.LinkedTILV.");
}
}

void LinkedTILV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    LinkedTILV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.LinkedTILV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.LinkedTILV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    LinkedTILV_template* precondition = new LinkedTILV_template;
    precondition->set_param(*param.get_elem(0));
    LinkedTILV_template* implied_template = new LinkedTILV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = LinkedTILV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.LinkedTILV");
  }
  is_ifpresent = param.get_ifpresent();
}

void LinkedTILV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTILV");
single_value->field_valueField.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTILV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTILV");
}

boolean LinkedTILV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean LinkedTILV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

LinkedTITLV::LinkedTITLV()
{
}

LinkedTITLV::LinkedTITLV(const OCTETSTRING& par_elementIdentifier,
    const LinkedTILV& par_linkedTILV)
  :   field_elementIdentifier(par_elementIdentifier),
  field_linkedTILV(par_linkedTILV)
{
}

LinkedTITLV::LinkedTITLV(const LinkedTITLV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.linkedTILV().is_bound()) field_linkedTILV = other_value.linkedTILV();
else field_linkedTILV.clean_up();
}

void LinkedTITLV::clean_up()
{
field_elementIdentifier.clean_up();
field_linkedTILV.clean_up();
}

const TTCN_Typedescriptor_t* LinkedTITLV::get_descriptor() const { return &LinkedTITLV_descr_; }
LinkedTITLV& LinkedTITLV::operator=(const LinkedTITLV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.linkedTILV().is_bound()) field_linkedTILV = other_value.linkedTILV();
  else field_linkedTILV.clean_up();
}
return *this;
}

boolean LinkedTITLV::operator==(const LinkedTITLV& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_linkedTILV==other_value.field_linkedTILV;
}

boolean LinkedTITLV::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_linkedTILV.is_bound());
}
boolean LinkedTITLV::is_value() const
{
return field_elementIdentifier.is_value()
  && field_linkedTILV.is_value();
}
void LinkedTITLV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", linkedTILV := ");
field_linkedTILV.log();
TTCN_Logger::log_event_str(" }");
}

void LinkedTITLV::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (linkedTILV().is_bound()) linkedTILV().set_implicit_omit();
}

void LinkedTITLV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.LinkedTITLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) linkedTILV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "linkedTILV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          linkedTILV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.LinkedTITLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.LinkedTITLV");
  }
}

void LinkedTITLV::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_linkedTILV.encode_text(text_buf);
}

void LinkedTITLV::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_linkedTILV.decode_text(text_buf);
}

void LinkedTITLV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void LinkedTITLV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int LinkedTITLV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, LinkedTILV_descr_.raw->forceomit);
  decoded_field_length = field_linkedTILV.RAW_decode(LinkedTILV_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int LinkedTITLV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, LinkedTILV_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_linkedTILV.RAW_encode(LinkedTILV_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct LinkedTITLV_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
LinkedTILV_template field_linkedTILV;
};

void LinkedTITLV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_linkedTILV = ANY_VALUE;
}
}
}

void LinkedTITLV_template::copy_value(const LinkedTITLV& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.linkedTILV().is_bound()) {
  single_value->field_linkedTILV = other_value.linkedTILV();
} else {
  single_value->field_linkedTILV.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void LinkedTITLV_template::copy_template(const LinkedTITLV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.linkedTILV().get_selection()) {
single_value->field_linkedTILV = other_value.linkedTILV();
} else {
single_value->field_linkedTILV.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new LinkedTITLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new LinkedTITLV_template(*other_value.implication_.precondition);
implication_.implied_template = new LinkedTITLV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
break;
}
set_selection(other_value);
}

LinkedTITLV_template::LinkedTITLV_template()
{
}

LinkedTITLV_template::LinkedTITLV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

LinkedTITLV_template::LinkedTITLV_template(const LinkedTITLV& other_value)
{
copy_value(other_value);
}

LinkedTITLV_template::LinkedTITLV_template(const OPTIONAL<LinkedTITLV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LinkedTITLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.LinkedTITLV from an unbound optional field.");
}
}

LinkedTITLV_template::LinkedTITLV_template(LinkedTITLV_template* p_precondition, LinkedTITLV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

LinkedTITLV_template::LinkedTITLV_template(Dynamic_Match_Interface<LinkedTITLV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<LinkedTITLV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

LinkedTITLV_template::LinkedTITLV_template(const LinkedTITLV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

LinkedTITLV_template::~LinkedTITLV_template()
{
clean_up();
}

LinkedTITLV_template& LinkedTITLV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

LinkedTITLV_template& LinkedTITLV_template::operator=(const LinkedTITLV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

LinkedTITLV_template& LinkedTITLV_template::operator=(const OPTIONAL<LinkedTITLV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LinkedTITLV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
}
return *this;
}

LinkedTITLV_template& LinkedTITLV_template::operator=(const LinkedTITLV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean LinkedTITLV_template::match(const LinkedTITLV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.linkedTILV().is_bound()) return FALSE;
if(!single_value->field_linkedTILV.match(other_value.linkedTILV(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
}
return FALSE;
}

boolean LinkedTITLV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_linkedTILV.is_bound();
}

boolean LinkedTITLV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_linkedTILV.is_value();
}

void LinkedTITLV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

LinkedTITLV LinkedTITLV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
LinkedTITLV ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_linkedTILV.is_bound()) {
ret_val.linkedTILV() = single_value->field_linkedTILV.valueof();
}
return ret_val;
}

void LinkedTITLV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new LinkedTITLV_template[list_length];
}

LinkedTITLV_template& LinkedTITLV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& LinkedTITLV_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& LinkedTITLV_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
return single_value->field_elementIdentifier;
}

LinkedTILV_template& LinkedTITLV_template::linkedTILV()
{
set_specific();
return single_value->field_linkedTILV;
}

const LinkedTILV_template& LinkedTITLV_template::linkedTILV() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field linkedTILV of a non-specific template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
return single_value->field_linkedTILV;
}

int LinkedTITLV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTITLV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTITLV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTITLV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTITLV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTITLV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTITLV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTITLV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTITLV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LinkedTITLV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
  }
  return 0;
}

void LinkedTITLV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", linkedTILV := ");
single_value->field_linkedTILV.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void LinkedTITLV_template::log_match(const LinkedTITLV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_linkedTILV.match(match_value.linkedTILV(), legacy)){
TTCN_Logger::log_logmatch_info(".linkedTILV");
single_value->field_linkedTILV.log_match(match_value.linkedTILV(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", linkedTILV := ");
single_value->field_linkedTILV.log_match(match_value.linkedTILV(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void LinkedTITLV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_linkedTILV.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
}
}

void LinkedTITLV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_linkedTILV.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new LinkedTITLV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.LinkedTITLV.");
}
}

void LinkedTITLV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    LinkedTITLV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.LinkedTITLV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) linkedTILV().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "linkedTILV")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          linkedTILV().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.LinkedTITLV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    LinkedTITLV_template* precondition = new LinkedTITLV_template;
    precondition->set_param(*param.get_elem(0));
    LinkedTITLV_template* implied_template = new LinkedTITLV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = LinkedTITLV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.LinkedTITLV");
  }
  is_ifpresent = param.get_ifpresent();
}

void LinkedTITLV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTITLV");
single_value->field_linkedTILV.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTITLV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.LinkedTITLV");
}

boolean LinkedTITLV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean LinkedTITLV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

LLC__SAPIV::LLC__SAPIV()
{
}

LLC__SAPIV::LLC__SAPIV(const BITSTRING& par_valueField,
    const BITSTRING& par_spare)
  :   field_valueField(par_valueField),
  field_spare(par_spare)
{
}

LLC__SAPIV::LLC__SAPIV(const LLC__SAPIV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
else field_valueField.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void LLC__SAPIV::clean_up()
{
field_valueField.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* LLC__SAPIV::get_descriptor() const { return &LLC__SAPIV_descr_; }
LLC__SAPIV& LLC__SAPIV::operator=(const LLC__SAPIV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
  if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
  else field_valueField.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean LLC__SAPIV::operator==(const LLC__SAPIV& other_value) const
{
return field_valueField==other_value.field_valueField
  && field_spare==other_value.field_spare;
}

boolean LLC__SAPIV::is_bound() const
{
return (field_valueField.is_bound())
  || (field_spare.is_bound());
}
boolean LLC__SAPIV::is_value() const
{
return field_valueField.is_value()
  && field_spare.is_value();
}
void LLC__SAPIV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ valueField := ");
field_valueField.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void LLC__SAPIV::set_implicit_omit()
{
if (valueField().is_bound()) valueField().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void LLC__SAPIV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.LLC_SAPIV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.LLC_SAPIV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.LLC_SAPIV");
  }
}

void LLC__SAPIV::encode_text(Text_Buf& text_buf) const
{
field_valueField.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void LLC__SAPIV::decode_text(Text_Buf& text_buf)
{
field_valueField.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void LLC__SAPIV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void LLC__SAPIV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int LLC__SAPIV::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_valueField.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int LLC__SAPIV::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT4_descr_.raw);
  encoded_length += field_valueField.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct LLC__SAPIV_template::single_value_struct {
BITSTRING_template field_valueField;
BITSTRING_template field_spare;
};

void LLC__SAPIV_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_valueField = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void LLC__SAPIV_template::copy_value(const LLC__SAPIV& other_value)
{
single_value = new single_value_struct;
if (other_value.valueField().is_bound()) {
  single_value->field_valueField = other_value.valueField();
} else {
  single_value->field_valueField.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void LLC__SAPIV_template::copy_template(const LLC__SAPIV_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.valueField().get_selection()) {
single_value->field_valueField = other_value.valueField();
} else {
single_value->field_valueField.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new LLC__SAPIV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new LLC__SAPIV_template(*other_value.implication_.precondition);
implication_.implied_template = new LLC__SAPIV_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
break;
}
set_selection(other_value);
}

LLC__SAPIV_template::LLC__SAPIV_template()
{
}

LLC__SAPIV_template::LLC__SAPIV_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

LLC__SAPIV_template::LLC__SAPIV_template(const LLC__SAPIV& other_value)
{
copy_value(other_value);
}

LLC__SAPIV_template::LLC__SAPIV_template(const OPTIONAL<LLC__SAPIV>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LLC__SAPIV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV from an unbound optional field.");
}
}

LLC__SAPIV_template::LLC__SAPIV_template(LLC__SAPIV_template* p_precondition, LLC__SAPIV_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

LLC__SAPIV_template::LLC__SAPIV_template(Dynamic_Match_Interface<LLC__SAPIV>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<LLC__SAPIV>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

LLC__SAPIV_template::LLC__SAPIV_template(const LLC__SAPIV_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

LLC__SAPIV_template::~LLC__SAPIV_template()
{
clean_up();
}

LLC__SAPIV_template& LLC__SAPIV_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

LLC__SAPIV_template& LLC__SAPIV_template::operator=(const LLC__SAPIV& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

LLC__SAPIV_template& LLC__SAPIV_template::operator=(const OPTIONAL<LLC__SAPIV>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const LLC__SAPIV&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
}
return *this;
}

LLC__SAPIV_template& LLC__SAPIV_template::operator=(const LLC__SAPIV_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean LLC__SAPIV_template::match(const LLC__SAPIV& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.valueField().is_bound()) return FALSE;
if(!single_value->field_valueField.match(other_value.valueField(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
}
return FALSE;
}

boolean LLC__SAPIV_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_valueField.is_bound()
 || single_value->field_spare.is_bound();
}

boolean LLC__SAPIV_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_valueField.is_value()
 && single_value->field_spare.is_value();
}

void LLC__SAPIV_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

LLC__SAPIV LLC__SAPIV_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
LLC__SAPIV ret_val;
if (single_value->field_valueField.is_bound()) {
ret_val.valueField() = single_value->field_valueField.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void LLC__SAPIV_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new LLC__SAPIV_template[list_length];
}

LLC__SAPIV_template& LLC__SAPIV_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
return value_list.list_value[list_index];
}

BITSTRING_template& LLC__SAPIV_template::valueField()
{
set_specific();
return single_value->field_valueField;
}

const BITSTRING_template& LLC__SAPIV_template::valueField() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field valueField of a non-specific template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
return single_value->field_valueField;
}

BITSTRING_template& LLC__SAPIV_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& LLC__SAPIV_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
return single_value->field_spare;
}

int LLC__SAPIV_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
  }
  return 0;
}

void LLC__SAPIV_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ valueField := ");
single_value->field_valueField.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void LLC__SAPIV_template::log_match(const LLC__SAPIV& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_valueField.match(match_value.valueField(), legacy)){
TTCN_Logger::log_logmatch_info(".valueField");
single_value->field_valueField.log_match(match_value.valueField(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ valueField := ");
single_value->field_valueField.log_match(match_value.valueField(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void LLC__SAPIV_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_valueField.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
}
}

void LLC__SAPIV_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_valueField.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new LLC__SAPIV_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MobileL3_GMM_SM_Types.LLC_SAPIV.");
}
}

void LLC__SAPIV_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    LLC__SAPIV_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MobileL3_GMM_SM_Types.LLC_SAPIV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.LLC_SAPIV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    LLC__SAPIV_template* precondition = new LLC__SAPIV_template;
    precondition->set_param(*param.get_elem(0));
    LLC__SAPIV_template* implied_template = new LLC__SAPIV_template;
    implied_template->set_param(*param.get_elem(1));
    *this = LLC__SAPIV_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MobileL3_GMM_SM_Types.LLC_SAPIV");
  }
  is_ifpresent = param.get_ifpresent();
}

void LLC__SAPIV_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_valueField.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LLC_SAPIV");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@MobileL3_GMM_SM_Types.LLC_SAPIV");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MobileL3_GMM_SM_Types.LLC_SAPIV");
}

boolean LLC__SAPIV_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean LLC__SAPIV_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

LLC__SAPITV::LLC__SAPITV()
{
}

LLC__SAPITV::LLC__SAPITV(const OCTETSTRING& par_elementIdentifier,
    const LLC__SAPIV& par_valueField)
  :   field_elementIdentifier(par_elementIdentifier),
  field_valueField(par_valueField)
{
}

LLC__SAPITV::LLC__SAPITV(const LLC__SAPITV& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MobileL3_GMM_SM_Types.LLC_SAPITV.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
else field_valueField.clean_up();
}

void LLC__SAPITV::clean_up()
{
field_elementIdentifier.clean_up();
field_valueField.clean_up();
}

const TTCN_Typedescriptor_t* LLC__SAPITV::get_descriptor() const { return &LLC__SAPITV_descr_; }
LLC__SAPITV& LLC__SAPITV::operator=(const LLC__SAPITV& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MobileL3_GMM_SM_Types.LLC_SAPITV.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.valueField().is_bound()) field_valueField = other_value.valueField();
  else field_valueField.clean_up();
}
return *this;
}

boolean LLC__SAPITV::operator==(const LLC__SAPITV& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_valueField==other_value.field_valueField;
}

boolean LLC__SAPITV::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_valueField.is_bound());
}
boolean LLC__SAPITV::is_value() const
{
return field_elementIdentifier.is_value()
  && field_valueField.is_value();
}
void LLC__SAPITV::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", valueField := ");
field_valueField.log();
TTCN_Logger::log_event_str(" }");
}

void LLC__SAPITV::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (valueField().is_bound()) valueField().set_implicit_omit();
}

void LLC__SAPITV::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MobileL3_GMM_SM_Types.LLC_SAPITV has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) valueField().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "valueField")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          valueField().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MobileL3_GMM_SM_Types.LLC_SAPITV: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MobileL3_GMM_SM_Types.LLC_SAPITV");
  }
}

void LLC__SAPITV::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_valueField.encode_text(text_buf);
}

void LLC__SAPITV::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_valueField.decode_text(text_buf);
}

void LLC__SAPITV::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void LLC__SAPITV::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_