/* (C) 2024 by sysmocom s.f.m.c. GmbH
 * All Rights Reserved
 *
 * Author: Philipp Maier
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.osmocom.androidApduProxy;

import org.junit.Test;

import static org.junit.Assert.*;

import java.util.Arrays;

public class UtilsUnitTest {
    @Test
    public void b2hTest()
    {
        assertEquals("0102030405060708090A0B0C0D0E0F",
                Utils.b2h(new byte[]{0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,0xA,0xB,0xC,0xD,0xE,0xF}));
        assertEquals("112233445566778899AABBCCDDEEFF",
                Utils.b2h(new byte[]{0x11,0x22,0x33,0x44,0x55,0x66,0x77,(byte)0x88,(byte)0x99,(byte)0xAA,(byte)0xBB,(byte)0xCC,(byte)0xDD,(byte)0xEE,(byte)0xFF}));
    }

    @Test
    public void h2bTest()
    {
        assertTrue(Arrays.equals(new byte[]{0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,0xA,0xB,0xC,0xD,0xE,0xF},
                Utils.h2b("0102030405060708090A0B0C0D0E0F")));
        assertTrue(Arrays.equals(new byte[]{0x11,0x22,0x33,0x44,0x55,0x66,0x77,(byte)0x88,(byte)0x99,(byte)0xAA,(byte)0xBB,(byte)0xCC,(byte)0xDD,(byte)0xEE,(byte)0xFF},
                Utils.h2b("112233445566778899AABBCCDDEEFF")));
    }

    @Test
    public void adjustAtrTest()
    {
        //Real world samples
        assertEquals("3B8F018031E073FE211F57454375313013653F",
                    Utils.b2h(Utils.adjustATR(Utils.h2b("3b9f96803f87828031e073fe211f574543753130136502"))));
        assertEquals("3B8F018031E073FE211F57454375313013653F",
                Utils.b2h(Utils.adjustATR(Utils.h2b("3B8F018031E073FE211F57454375313013653F"))));
        assertEquals("3B8A0192027593110001020221CC",
                Utils.b2h(Utils.adjustATR(Utils.h2b("3b9a940092027593110001020221"))));
        assertEquals("3B8F018031A073BE211367432007180000017A",
                Utils.b2h(Utils.adjustATR(Utils.h2b("3b9f96801fc78031a073be21136743200718000001a5"))));
        assertEquals("3B8F018031E073FE211B674A4C753034054B36",
                Utils.b2h(Utils.adjustATR(Utils.h2b("3b9f96801f878031e073fe211b674a4c753034054ba9"))));
        assertEquals("3B8F018031E073FE211B674A3575303502595B",
                Utils.b2h(Utils.adjustATR(Utils.h2b("3b9f96801f878031e073fe211b674a357530350259c4"))));
        assertEquals("3B8C018073C8211366050363510002D4",
                Utils.b2h(Utils.adjustATR(Utils.h2b("3bdc18ff8191fe1fc38073c821136605036351000250"))));

        //Short ATR
        assertEquals(null, Utils.adjustATR(null));
        assertEquals(null, Utils.adjustATR(Utils.h2b("3b")));

        //Very short but valid ATR
        assertEquals("3B800181", Utils.b2h(Utils.adjustATR(Utils.h2b("3B8001"))));
        assertEquals("3B800181", Utils.b2h(Utils.adjustATR(Utils.h2b("3B8000"))));

        //Missing historical bytes, otherwise valid
        assertEquals("3B800181", Utils.b2h(Utils.adjustATR(Utils.h2b("3B8F01"))));

        //Invalid ATR with random errors
        assertEquals("3B800181",
                Utils.b2h(Utils.adjustATR(Utils.h2b("3bdc1c8faf1280191fe1fc38073c80250"))));
        assertEquals("3B800181",
                Utils.b2h(Utils.adjustATR(Utils.h2b("9a8f37e48a32ee9327"))));
        assertEquals("3B800181",
                Utils.b2h(Utils.adjustATR(Utils.h2b("0000000000000000"))));
        assertEquals("3B800181",
                Utils.b2h(Utils.adjustATR(Utils.h2b("ffffffffffffffff"))));
    }
}
