/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework;

import javacard.framework.JCSystem;
import javacard.framework.PIN;
import javacard.framework.PINException;
import javacard.framework.Util;

public class OwnerPIN
implements PIN {
    private byte tryLimit;
    private byte maxPINSize;
    private byte[] pinValue;
    private byte pinSize;
    private boolean[] flags;
    private static final byte VALIDATED = 0;
    private static final byte NUMFLAGS = 1;
    private byte[] triesLeft;
    private byte[] temps;
    private static final byte TRIES = 0;
    private static final byte NUMTEMPS = 1;

    public OwnerPIN(byte tryLimit, byte maxPINSize) throws PINException {
        if (tryLimit < 1 || maxPINSize < 1) {
            PINException.throwIt((short)1);
        }
        this.pinValue = new byte[maxPINSize];
        this.pinSize = maxPINSize;
        this.maxPINSize = maxPINSize;
        this.tryLimit = tryLimit;
        this.triesLeft = new byte[1];
        this.resetTriesRemaining();
    }

    public boolean check(byte[] pin, short offset, byte length) throws ArrayIndexOutOfBoundsException, NullPointerException {
        boolean noMoreTries = false;
        this.setValidatedFlag(false);
        if (this.getTriesRemaining() == 0) {
            noMoreTries = true;
        } else {
            this.decrementTriesRemaining();
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (length != 0) {
            byte by = pin[(short)(offset + length - 1)];
        }
        if (length != this.pinSize || noMoreTries) {
            return false;
        }
        if (Util.arrayCompare(pin, offset, this.pinValue, (short)0, length) == 0) {
            this.setValidatedFlag(true);
            this.resetTriesRemaining();
            return true;
        }
        return false;
    }

    private void createFlags() {
        if (this.flags != null) {
            return;
        }
        this.flags = JCSystem.makeTransientBooleanArray((short)1, (byte)1);
        this.setValidatedFlag(false);
    }

    private void decrementTriesRemaining() {
        if (this.temps == null) {
            this.temps = JCSystem.makeTransientByteArray((short)1, (byte)1);
        }
        this.temps[0] = (byte)(this.triesLeft[0] - 1);
        Util.arrayCopyNonAtomic(this.temps, (short)0, this.triesLeft, (short)0, (short)1);
    }

    public byte getTriesRemaining() {
        return this.triesLeft[0];
    }

    protected boolean getValidatedFlag() {
        this.createFlags();
        return this.flags[0];
    }

    public boolean isValidated() {
        return this.getValidatedFlag();
    }

    public void reset() {
        if (this.isValidated()) {
            this.resetAndUnblock();
        }
    }

    public void resetAndUnblock() {
        this.resetTriesRemaining();
        this.setValidatedFlag(false);
    }

    private void resetTriesRemaining() {
        this.triesLeft[0] = this.tryLimit;
    }

    protected void setValidatedFlag(boolean value) {
        this.createFlags();
        this.flags[0] = value;
    }

    public void update(byte[] pin, short offset, byte length) throws PINException {
        if (length > this.maxPINSize) {
            PINException.throwIt((short)1);
        }
        Util.arrayCopy(pin, offset, this.pinValue, (short)0, length);
        this.pinSize = length;
        this.resetTriesRemaining();
        this.setValidatedFlag(false);
    }
}

