/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.basicstructure;

public class MethodDefinition {
    protected String method_name;
    protected String descriptor;
    protected int access_flags;
    protected int token = 255;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_ABSTRACT = 1024;

    public MethodDefinition() {
    }

    public MethodDefinition(MethodDefinition a_method) {
        this.token = a_method.token;
        this.method_name = a_method.method_name;
        this.descriptor = a_method.descriptor;
        this.access_flags = a_method.access_flags;
    }

    public int getAccessFlags() {
        return this.access_flags;
    }

    public String getMethodDescriptor() {
        return this.descriptor;
    }

    public String getMethodName() {
        return this.method_name;
    }

    public String getMethodSignature() {
        return String.valueOf(this.method_name) + this.descriptor;
    }

    public int getMethodToken() {
        return this.token;
    }

    public boolean isAbstract() {
        return (this.getAccessFlags() & 0x400) != 0;
    }

    public boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public boolean isFinal() {
        return (this.getAccessFlags() & 0x10) != 0;
    }

    public boolean isPrivate() {
        return (this.getAccessFlags() & 2) != 0;
    }

    public boolean isProtected() {
        return (this.getAccessFlags() & 4) != 0;
    }

    public boolean isPublic() {
        return (this.getAccessFlags() & 1) != 0;
    }

    public boolean isStatic() {
        return (this.getAccessFlags() & 8) != 0;
    }

    public void setAccessFlags(int access_flags) {
        this.access_flags = access_flags;
    }

    public void setMethodDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public void setMethodName(String method_name) {
        this.method_name = method_name;
    }

    public void setMethodSignature(String signature) {
        int i = signature.indexOf(40);
        this.method_name = signature.substring(0, i);
        this.descriptor = signature.substring(i, signature.length());
    }

    public void setMethodToken(int token) {
        this.token = token;
    }
}

