/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.classfile.attributes.JAttribute;
import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.constants.JConstantPool;
import com.sun.javacard.classfile.instructions.JInstruction;
import java.io.DataInputStream;
import java.io.IOException;

public class JMethod
extends MethodDefinition {
    private JConstantPool constant_pool;
    private int name_index;
    private int descriptor_index;
    private JAttribute[] attributes = null;
    private JCodeAttr code_attr = null;
    private String[] exceptionsThrown;

    public JMethod(JConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }

    public JAttribute[] getAttributes() {
        return this.attributes;
    }

    public JInstruction getCode() {
        if (this.code_attr == null) {
            return null;
        }
        return this.code_attr.getCode();
    }

    public JCodeAttr getCodeAttr() {
        return this.code_attr;
    }

    public String[] getExceptionsThrown() {
        return this.exceptionsThrown;
    }

    public void parse(DataInputStream dis) throws IOException {
        this.access_flags = dis.readUnsignedShort();
        this.name_index = dis.readUnsignedShort();
        this.descriptor_index = dis.readUnsignedShort();
        int attribute_count = dis.readUnsignedShort();
        this.attributes = new JAttribute[attribute_count];
        int i = 0;
        while (i < attribute_count) {
            int index = dis.readUnsignedShort();
            this.attributes[i] = JAttribute.create(this.constant_pool, index);
            this.attributes[i].parse(dis);
            ++i;
        }
    }

    public void resolve() {
        this.method_name = this.constant_pool.getConstantUtf8(this.name_index).getString();
        this.descriptor = this.constant_pool.getConstantUtf8(this.descriptor_index).getString();
        int i = 0;
        while (i < this.attributes.length) {
            if (this.attributes[i] instanceof JCodeAttr) {
                this.code_attr = (JCodeAttr)this.attributes[i];
                this.code_attr.resolve();
            }
            ++i;
        }
    }
}

