/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter;

import com.sun.javacard.converter.AppletProfile;
import com.sun.javacard.converter.PackageProfile;
import com.sun.javacard.converter.util.ClassFileNameFilter;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.converter.util.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConversionProfile {
    public static final byte OUTPUT_CAP_FILE = 1;
    public static final byte OUTPUT_EXP_FILE = 2;
    public static final byte OUTPUT_JCA_FILE = 4;
    public boolean int_supported = false;
    public boolean this_exp_provided = false;
    public boolean debug = false;
    public boolean profile = false;
    public boolean verify = false;
    public boolean mask = false;
    public boolean packageUpgrade = false;
    public int output = 0;
    public boolean deleteJCA = true;
    public String[] export_path = null;
    public String class_root = null;
    public File[] classes;
    public String output_dir = null;
    public PackageProfile package_profile = null;
    public AppletProfile[] applets_profile = null;

    private void enumerateClasses() {
        String[] class_names;
        File class_dir;
        String package_name = this.package_profile.package_name.replace('/', File.separatorChar);
        File class_root_dir = new File(this.class_root);
        if (!class_root_dir.exists()) {
            Notifier.error("profile.3", this.class_root);
            ConversionProfile.usage();
            System.exit(1);
        }
        if (!(class_dir = new File(class_root_dir, package_name)).exists()) {
            Notifier.error("profile.5", String.valueOf(this.class_root) + File.separatorChar + package_name);
            ConversionProfile.usage();
            System.exit(1);
        }
        if ((class_names = class_dir.list(new ClassFileNameFilter())) == null) {
            Notifier.error("profile.6");
            ConversionProfile.usage();
            System.exit(1);
        }
        this.classes = new File[class_names.length];
        int i = 0;
        while (i < class_names.length) {
            this.classes[i] = new File(class_dir, class_names[i]);
            ++i;
        }
    }

    public File getFullOutputPath() {
        String sub_dir = new String(String.valueOf(this.package_profile.package_name.replace('/', File.separatorChar)) + File.separatorChar + "javacard");
        return new File(this.output_dir, sub_dir);
    }

    public void parse(String[] argv) {
        try {
            if (argv == null || argv.length == 0) {
                ConversionProfile.usage();
                System.exit(1);
            }
            if (argv[0].equals("-config")) {
                this.parseOptionsFromFile(argv);
            } else {
                this.parseOptionsFromCommandLine(argv);
            }
            if (this.package_profile == null) {
                ConversionProfile.usage();
                System.exit(1);
            }
            if (this.class_root == null) {
                this.class_root = new String(System.getProperty("user.dir"));
            }
            this.enumerateClasses();
            if (this.output == 0) {
                this.output |= 4;
                this.output |= 2;
            }
            if (this.output_dir == null) {
                this.output_dir = this.class_root;
            }
            if (this.export_path == null) {
                String path = System.getProperty("java.class.path");
                this.export_path = Strings.toStrings(path, File.pathSeparator);
            }
            if (this.applets_profile == null) {
                this.applets_profile = new AppletProfile[0];
            }
        }
        catch (Exception exception) {
            ConversionProfile.usage();
            System.exit(1);
        }
    }

    private void parseOptionsFromCommandLine(String[] argv) {
        Vector<AppletProfile> applet_vector = new Vector<AppletProfile>();
        int i = 0;
        while (i < argv.length) {
            block43: {
                if (argv[i].equals("-i")) {
                    this.int_supported = true;
                } else if (argv[i].equals("-classdir")) {
                    this.class_root = argv[++i];
                } else if (argv[i].equals("-exportpath")) {
                    this.export_path = argv[++i].indexOf("/") != -1 ? Strings.toStrings(argv[i], ":") : Strings.toStrings(argv[i], File.pathSeparator);
                } else if (argv[i].equals("-exportmap")) {
                    this.this_exp_provided = true;
                } else if (argv[i].equals("-applet")) {
                    AppletProfile applet_profile = new AppletProfile();
                    byte[] aid = null;
                    try {
                        aid = Strings.toByteArray(argv[++i], ":");
                    }
                    catch (Exception exception) {
                        Notifier.error("profile.4", argv[i]);
                        ConversionProfile.usage();
                        System.exit(1);
                    }
                    if (aid.length > 16 || aid.length < 5) {
                        Notifier.error("profile.1", argv[i]);
                        ConversionProfile.usage();
                        System.exit(1);
                    }
                    applet_profile.aid = aid;
                    applet_profile.install_class = argv[++i].replace('.', '/');
                    applet_vector.addElement(applet_profile);
                } else {
                    String version;
                    if (argv[i].equals("-out")) {
                        while (true) {
                            if (argv[i + 1].equals("JCA")) {
                                this.output |= 4;
                                ++i;
                                continue;
                            }
                            if (argv[i + 1].equals("EXP")) {
                                this.output |= 2;
                                ++i;
                                continue;
                            }
                            break block43;
                            break;
                        }
                    }
                    if (argv[i].equals("-d")) {
                        this.output_dir = argv[++i];
                    } else if (argv[i].equals("-verbose")) {
                        Notifier.setVerboseFlag(true);
                    } else if (argv[i].equals("-v")) {
                        Notifier.setVerboseFlag(true);
                    } else if (argv[i].equals("-version")) {
                        version = new String(String.valueOf(String.valueOf(1)) + "." + String.valueOf(2));
                        Notifier.out("converter.version", version);
                        Notifier.out("converter.copyright");
                        System.exit(0);
                    } else if (argv[i].equals("-V")) {
                        version = new String(String.valueOf(String.valueOf(1)) + "." + String.valueOf(2));
                        Notifier.out("converter.version", version);
                        Notifier.out("converter.copyright");
                        System.exit(0);
                    } else if (argv[i].equals("-help")) {
                        ConversionProfile.usage();
                        System.exit(0);
                    } else if (argv[i].equals("-mask")) {
                        this.mask = true;
                    } else if (argv[i].equals("-nowarn")) {
                        Notifier.setNoWarningFlag(true);
                    } else if (argv[i].equals("-nobanner")) {
                        Notifier.setNoBannerFlag(true);
                    } else {
                        if (argv[i].startsWith("-")) {
                            Notifier.error("profile.0", argv[i]);
                            ConversionProfile.usage();
                            System.exit(1);
                        }
                        this.package_profile = new PackageProfile();
                        this.package_profile.package_name = argv[i].replace('.', '/');
                        byte[] aid = null;
                        try {
                            aid = Strings.toByteArray(argv[++i], ":");
                        }
                        catch (Exception exception) {
                            Notifier.error("profile.4", argv[i]);
                            ConversionProfile.usage();
                            System.exit(1);
                        }
                        if (aid.length < 5 || aid.length > 16) {
                            Notifier.error("profile.1", argv[i]);
                            ConversionProfile.usage();
                            System.exit(1);
                        }
                        this.package_profile.aid = aid;
                        byte[] versions = null;
                        try {
                            versions = Strings.toByteArray(argv[++i], ".");
                        }
                        catch (Exception exception) {
                            Notifier.error("profile.2", argv[i]);
                            ConversionProfile.usage();
                            System.exit(1);
                        }
                        if (versions.length != 2) {
                            Notifier.error("profile.2", argv[i]);
                            ConversionProfile.usage();
                            System.exit(1);
                        }
                        this.package_profile.major_version = versions[0];
                        this.package_profile.minor_version = versions[1];
                    }
                }
            }
            ++i;
        }
        this.applets_profile = new AppletProfile[applet_vector.size()];
        applet_vector.copyInto(this.applets_profile);
    }

    private void parseOptionsFromFile(String[] argv) {
        boolean i = false;
        String file_name = argv[1];
        Vector<String> tokens = new Vector<String>(20);
        try {
            String a_line;
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(new FileInputStream(file_name)));
            while ((a_line = reader.readLine()) != null) {
                StringTokenizer parser = new StringTokenizer(a_line);
                while (parser.hasMoreTokens()) {
                    tokens.addElement(parser.nextToken());
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Notifier.error("converter.0", file_name);
            ConversionProfile.usage();
            System.exit(1);
        }
        catch (IOException iOException) {
            Notifier.error("converter.1", file_name);
            ConversionProfile.usage();
            System.exit(1);
        }
        Object[] arguments = new String[tokens.size()];
        tokens.copyInto(arguments);
        this.parseOptionsFromCommandLine((String[])arguments);
    }

    public static void usage() {
        int i = 0;
        while (i < 27) {
            Notifier.out("usage." + i);
            ++i;
        }
    }
}

