/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter;

import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfExportFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class Exp2Text {
    public static final int Exp2Text_MAJOR_VERSION = 1;
    public static final int Exp2Text_MINOR_VERSION = 0;

    public static void main(String[] args) {
        String class_dir = null;
        String output_dir = null;
        Notifier.newLine();
        Notifier.out("exp2text.version", "1.0");
        Notifier.out("exp2text.copyright");
        Notifier.newLine();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-classdir")) {
                class_dir = args[++i];
            } else if (args[i].equals("-d")) {
                output_dir = args[++i];
            } else if (args[i].equals("-help")) {
                Exp2Text.usage();
                System.exit(0);
            } else {
                if (!args[i].startsWith("-")) break;
                Notifier.error("profile.0", args[i]);
                Exp2Text.outputStatus();
                System.exit(1);
                break;
            }
            ++i;
        }
        if (class_dir == null) {
            class_dir = System.getProperty("user.dir");
        }
        if (output_dir == null) {
            output_dir = class_dir;
        }
        if (i == args.length) {
            Notifier.error("exp2text.6");
            Exp2Text.outputStatus();
            System.exit(1);
        }
        while (i < args.length) {
            String package_name = args[i].replace('.', '/');
            String ef_name = Names.getExportFileName(package_name);
            String ef_text_name = String.valueOf(ef_name.replace('.', '_')) + ".tex";
            char c = File.separatorChar;
            EfExportFile export_file = new EfExportFile();
            try {
                Object[] arguments;
                String ef_path = String.valueOf(class_dir) + c + args[i].replace('.', c) + c + "javacard" + c + ef_name;
                File ef_file = new File(ef_path);
                if (!ef_file.exists()) {
                    arguments = new String[]{ef_name, String.valueOf(class_dir) + c + args[i].replace('.', c) + c + "javacard"};
                    Notifier.error("exp2text.0", arguments);
                    Exp2Text.outputStatus();
                    System.exit(1);
                }
                if (ef_file.isDirectory()) {
                    arguments = new String[]{ef_name, String.valueOf(class_dir) + c + args[i].replace('.', c) + c + "javacard"};
                    Notifier.error("exp2text.1", arguments);
                    Exp2Text.outputStatus();
                    System.exit(1);
                }
                if (!ef_file.canRead()) {
                    Notifier.error("exp2text.2", ef_name);
                    Exp2Text.outputStatus();
                    System.exit(1);
                }
                DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(ef_file)));
                export_file.parse(dis);
                dis.close();
                export_file.resolve();
            }
            catch (Exception exception) {
                Notifier.error("exp2text.4", ef_name);
                Exp2Text.outputStatus();
                System.exit(1);
            }
            try {
                File ef_out_file;
                File ef_out_path = new File(String.valueOf(output_dir) + c + args[i].replace('.', c) + c + "javacard");
                if (!ef_out_path.exists()) {
                    ef_out_path.mkdirs();
                }
                if ((ef_out_file = new File(ef_out_path, ef_text_name)).exists() && !ef_out_file.canWrite()) {
                    Notifier.error("exp2text.3", ef_text_name);
                    Exp2Text.outputStatus();
                    System.exit(1);
                }
                PrintWriter pw = new PrintWriter(new BufferedOutputStream(new FileOutputStream(ef_out_file)));
                export_file.toText(pw);
                pw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                Notifier.error("exp2text.5", ef_text_name);
                Exp2Text.outputStatus();
                System.exit(1);
            }
            ++i;
        }
        Exp2Text.outputStatus();
        System.exit(0);
    }

    public static void outputStatus() {
        Notifier.newLine();
        Object[] args = new String[]{String.valueOf(Notifier.getErrorCount()), String.valueOf(Notifier.getWarningCount())};
        Notifier.out("out.1", args);
    }

    public static void usage() {
        int i = 0;
        while (i < 7) {
            Notifier.out("exp2textusage." + i);
            ++i;
        }
    }
}

