/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.checkers;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JField;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.classfile.JPackage;
import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.attributes.JLocalVarTableAttr;
import com.sun.javacard.classfile.attributes.JLocalVariable;
import com.sun.javacard.classfile.instructions.JInstrByteIndex;
import com.sun.javacard.classfile.instructions.JInstrClassRef;
import com.sun.javacard.classfile.instructions.JInstrCpByteRef;
import com.sun.javacard.classfile.instructions.JInstrCpShortRef;
import com.sun.javacard.classfile.instructions.JInstrFieldRef;
import com.sun.javacard.classfile.instructions.JInstrMethodRef;
import com.sun.javacard.classfile.instructions.JInstruction;
import com.sun.javacard.classfile.instructions.JavaByteCode;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.checkers.BCCheckingTable;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.instructions.JcInstrLookupSwitch;
import com.sun.javacard.jcfile.instructions.JcInstrTableSwitch;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.lang.reflect.Modifier;

public class SubsetChecker {
    ConversionProfile conversion_profile;

    public SubsetChecker(ConversionProfile conversion_profile) {
        this.conversion_profile = conversion_profile;
    }

    public void check(JPackage java_package) {
        JClassFile[] java_classes = java_package.getClasses();
        int i = 0;
        while (i < java_classes.length) {
            this.checkClass(java_classes[i]);
            ++i;
        }
    }

    public void check(JcPackage jc_package) {
        JcClass[] jc_classes = jc_package.getClasses();
        if (jc_classes.length > 255) {
            Notifier.error("subset.10", jc_package.getPackageName());
        }
        int i = 0;
        while (i < jc_classes.length) {
            this.checkClass(jc_package, jc_classes[i]);
            ++i;
        }
        this.checkAccessControl(jc_package);
    }

    private void checkAccessControl(JcPackage jc_package) {
        JcClass[] jc_classes = jc_package.getClasses();
        int i = 0;
        while (i < jc_classes.length) {
            JcClass jc_class = jc_classes[i];
            if (jc_class.isInterfaceType()) {
                if (Modifier.isPublic(jc_class.getAccessFlags())) {
                    String[] super_interfaces = jc_class.getSuperInterfaces();
                    int j = 0;
                    while (j < super_interfaces.length) {
                        int access_flags;
                        JcClass jc_interface = jc_package.getClass(super_interfaces[j]);
                        if (jc_interface != null && !Modifier.isPublic(access_flags = jc_interface.getAccessFlags())) {
                            Object[] args = new String[]{jc_class.getClassName().replace('/', '.'), jc_interface.getClassName().replace('/', '.')};
                            Notifier.error("subset.50", args);
                        }
                        ++j;
                    }
                }
            } else {
                JcClass super_class;
                String super_class_name = jc_class.getSuperClassName();
                if (super_class_name != null && (super_class = jc_package.getClass(super_class_name)) != null) {
                    JcMethod[] jc_methods = jc_class.getMethods();
                    MethodDefinition[] pack_methods = super_class.getPackageMethodTable().getMethods();
                    int j = 0;
                    while (j < jc_methods.length) {
                        JcMethod jc_method = jc_methods[j];
                        int access_flags = jc_method.getAccessFlags();
                        if (Modifier.isPublic(access_flags) || Modifier.isProtected(access_flags)) {
                            int k = 0;
                            while (k < pack_methods.length) {
                                MethodDefinition pack_method = pack_methods[k];
                                if (jc_method.getMethodSignature().equals(pack_method.getMethodSignature())) {
                                    Object[] args = new String[]{jc_class.getClassName().replace('/', '.'), Names.getMethodNameInJavaStyle(jc_method.getMethodName(), jc_method.getMethodDescriptor())};
                                    Notifier.error("subset.51", args);
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private void checkByteCode(JcMethod jc_method, String class_name) {
        JcInstruction code = jc_method.getCode();
        String method_name = jc_method.getMethodName();
        int code_size = 0;
        while (code != null) {
            code_size += code.getSizeInBytes();
            int opcode = code.getOpcode();
            switch (opcode) {
                case 117: 
                case 118: {
                    int num_cases = ((JcInstrLookupSwitch)code).getNumMatchPairs();
                    if (num_cases <= 65536) break;
                    Object[] args = new Object[]{class_name.replace('/', '.'), method_name};
                    Notifier.error("subset.18", args);
                    break;
                }
                case 115: 
                case 116: {
                    JcInstrTableSwitch table_switch_instr = (JcInstrTableSwitch)code;
                    int num_cases = table_switch_instr.getHighValue() - table_switch_instr.getLowValue() + 1;
                    if (num_cases <= 65536) break;
                    Object[] args = new Object[]{class_name.replace('/', '.'), method_name};
                    Notifier.error("subset.18", args);
                    break;
                }
            }
            code = code.getNextInstr();
        }
        if (code_size > Short.MAX_VALUE) {
            Object[] args = new Object[]{class_name.replace('/', '.'), method_name};
            Notifier.error("subset.17", args);
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    private void checkByteCodes(JMethod java_method, String class_name) {
        String method_name = java_method.getMethodName();
        JInstruction code = java_method.getCode();
        while (code != null) {
            block26: {
                int opcode;
                block28: {
                    block27: {
                        opcode = code.getOpcode();
                        if (!method_name.equals("<clinit>")) break block27;
                        if (BCCheckingTable.isClinitUnsupported(opcode)) {
                            Object[] args = new Object[]{class_name.replace('/', '.'), JavaByteCode.getMnemonic(opcode)};
                            Notifier.error(code.getSourceLineNumber(), "subset.20", args);
                            break block28;
                        } else if (BCCheckingTable.isClinitUnreasonable(opcode)) {
                            Object[] args = new Object[]{class_name.replace('/', '.'), JavaByteCode.getMnemonic(opcode)};
                            Notifier.error(code.getSourceLineNumber(), "subset.21", args);
                        }
                        break block28;
                    }
                    if (!BCCheckingTable.isJCSupported(opcode)) {
                        this.reportErrforUnsupportedByteCode(class_name, method_name, java_method.getMethodDescriptor(), code);
                    }
                }
                block0 : switch (opcode) {
                    case 193: {
                        Object[] args;
                        String check_class_name = ((JInstrClassRef)code).getClassName();
                        String error_string = this.checkType(check_class_name);
                        if (error_string != null) {
                            args = new Object[]{class_name.replace('/', '.'), error_string};
                            Notifier.error(code.getSourceLineNumber(), "subset.31", args);
                        }
                        break;
                    }
                    case 192: {
                        Object[] args;
                        String check_class_name = ((JInstrClassRef)code).getClassName();
                        String error_string = this.checkType(check_class_name);
                        if (error_string != null) {
                            args = new Object[]{class_name.replace('/', '.'), error_string};
                            Notifier.error(code.getSourceLineNumber(), "subset.32", args);
                        }
                        break;
                    }
                    case 188: {
                        int atype = ((JInstrByteIndex)code).getIndex();
                        switch (atype) {
                            case 5: {
                                Object[] args = new Object[]{class_name.replace('/', '.'), "char[]"};
                                Notifier.error(code.getSourceLineNumber(), "subset.33", args);
                                break block0;
                            }
                            case 6: {
                                Object[] args = new Object[]{class_name.replace('/', '.'), "float[]"};
                                Notifier.error(code.getSourceLineNumber(), "subset.33", args);
                                break block0;
                            }
                            case 7: {
                                Object[] args = new Object[]{class_name.replace('/', '.'), "double[]"};
                                Notifier.error(code.getSourceLineNumber(), "subset.33", args);
                                break block0;
                            }
                            case 11: {
                                Object[] args = new Object[]{class_name.replace('/', '.'), "long[]"};
                                Notifier.error(code.getSourceLineNumber(), "subset.33", args);
                                break block0;
                            }
                            default: {
                                break block26;
                            }
                        }
                    }
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: {
                        JInstrMethodRef method_instr = (JInstrMethodRef)code;
                        String descriptor = method_instr.getDescriptor();
                        String invoked_method_class_name = method_instr.getClassName();
                        String invoked_method_name = method_instr.getMethodName();
                        String[] param_descs = MethodDescriptor.getParamDescriptors(descriptor);
                        int j = 0;
                        while (true) {
                            if (j >= param_descs.length) {
                                String return_desc = MethodDescriptor.getReturnDescriptor(descriptor);
                                String error_string = this.checkType(return_desc);
                                if (error_string != null) {
                                    Object[] args = new Object[]{class_name.replace('/', '.'), error_string, Names.getMethodNameInJavaStyle(invoked_method_name, descriptor), invoked_method_class_name.replace('/', '.')};
                                    Notifier.error(code.getSourceLineNumber(), "subset.35", args);
                                }
                                break block26;
                            }
                            String error_string = this.checkType(param_descs[j]);
                            if (error_string != null) {
                                Object[] args = new Object[]{class_name.replace('/', '.'), error_string, Names.getMethodNameInJavaStyle(invoked_method_name, descriptor), invoked_method_class_name.replace('/', '.')};
                                Notifier.error(code.getSourceLineNumber(), "subset.34", args);
                            }
                            ++j;
                        }
                    }
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: {
                        JInstrFieldRef field_instr = (JInstrFieldRef)code;
                        String field_class_name = field_instr.getClassName();
                        String field_name = field_instr.getFieldName();
                        String descriptor = field_instr.getDescriptor();
                        String error_string = this.checkType(descriptor);
                        if (error_string != null) {
                            Object[] args = new Object[]{class_name.replace('/', '.'), error_string, field_name, field_class_name.replace('/', '.')};
                            Notifier.error(code.getSourceLineNumber(), "subset.36", args);
                        } else {
                            break;
                        }
                    }
                }
            }
            code = code.getNextInstr();
        }
    }

    private void checkClass(JClassFile java_class) {
        if (java_class.isInterfaceType() && !java_class.isAbstract()) {
            Object[] args = new Object[]{java_class.getClassName().replace('/', '.')};
            Notifier.warning("flags.1", args);
            java_class.setAbstract(true);
        }
        JField[] java_fields = java_class.getFields();
        int i = 0;
        while (i < java_fields.length) {
            this.checkField(java_fields[i], java_class.getClassName());
            ++i;
        }
        JMethod[] java_methods = java_class.getMethods();
        int i2 = 0;
        while (i2 < java_methods.length) {
            this.checkMethod(java_methods[i2], java_class.getClassName());
            ++i2;
        }
    }

    private void checkClass(JcPackage jc_package, JcClass jc_class) {
        String class_name = jc_class.getClassName();
        if (jc_class.getSuperInterfaces().length > 15) {
            if (jc_class.isInterfaceType()) {
                Notifier.error("subset.9", class_name.replace('/', '.'));
            } else {
                Notifier.error("subset.8", class_name.replace('/', '.'));
            }
        }
        int pub_static_fields_count = 0;
        int instance_field_size = 0;
        JcField[] jc_fields = jc_class.getFields();
        int i = 0;
        while (i < jc_fields.length) {
            int access_flags = jc_fields[i].getAccessFlags();
            if (Modifier.isStatic(access_flags)) {
                if (Modifier.isPublic(access_flags) || Modifier.isProtected(access_flags)) {
                    ++pub_static_fields_count;
                }
            } else {
                String descriptor = jc_fields[i].getFieldDescriptor();
                instance_field_size = DataType.getType(descriptor) == 3 ? (instance_field_size += 2) : ++instance_field_size;
            }
            ++i;
        }
        if (pub_static_fields_count > 255) {
            Notifier.error("subset.11", class_name.replace('/', '.'));
        }
        String[] supers = jc_class.getPublicSuperClasses();
        int i2 = 0;
        while (i2 < supers.length) {
            JcClass jc_cl = jc_package.getClass(supers[i2]);
            if (jc_cl != null) {
                jc_fields = jc_cl.getFields();
                int j = 0;
                while (j < jc_fields.length) {
                    int access_flags = jc_fields[j].getAccessFlags();
                    if (!Modifier.isStatic(access_flags)) {
                        String descriptor = jc_fields[j].getFieldDescriptor();
                        instance_field_size = DataType.getType(descriptor) == 3 ? (instance_field_size += 2) : ++instance_field_size;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        if (instance_field_size > 255) {
            Notifier.error("subset.12", class_name.replace('/', '.'));
        }
        JcMethod[] jc_methods = jc_class.getMethods();
        int pub_static_method_count = 0;
        int i3 = 0;
        while (i3 < jc_methods.length) {
            int access_flags = jc_methods[i3].getAccessFlags();
            if (Modifier.isStatic(access_flags)) {
                if (Modifier.isPublic(access_flags) || Modifier.isProtected(access_flags)) {
                    ++pub_static_method_count;
                }
            } else if (jc_methods[i3].getMethodName().equals("<init>") && (Modifier.isPublic(access_flags) || Modifier.isProtected(access_flags))) {
                ++pub_static_method_count;
            }
            ++i3;
        }
        if (pub_static_method_count > 255) {
            Notifier.error("subset.13", class_name.replace('/', '.'));
        }
        if (jc_class.getPublicMethodTable().getMethods().length > 128) {
            Notifier.error("subset.14", class_name.replace('/', '.'));
        }
        if (jc_class.getPackageMethodTable().getMethods().length > 128) {
            Notifier.error("subset.15", class_name.replace('/', '.'));
        }
        int i4 = 0;
        while (i4 < jc_methods.length) {
            this.checkMethod(jc_methods[i4], class_name);
            ++i4;
        }
    }

    private void checkField(JField java_field, String class_name) {
        Object[] args;
        int access_flags;
        String descriptor = java_field.getFieldDescriptor();
        String field_name = java_field.getFieldName();
        String error_string = this.checkType(descriptor);
        if (error_string != null) {
            Object[] args2 = new Object[]{class_name.replace('/', '.'), error_string, field_name};
            Notifier.error("subset.1", args2);
        }
        if (Modifier.isVolatile(access_flags = java_field.getAccessFlags())) {
            args = new Object[]{class_name.replace('/', '.'), "volatile", field_name};
            Notifier.error("subset.2", args);
        }
        if (Modifier.isTransient(access_flags)) {
            args = new Object[]{class_name.replace('/', '.'), "transient", field_name};
            Notifier.error("subset.2", args);
        }
        if (Modifier.isStatic(access_flags) && Modifier.isFinal(access_flags) && java_field.getFieldDescriptor().startsWith("L")) {
            args = new Object[]{class_name.replace('/', '.'), field_name};
            Notifier.error("subset.53", args);
        }
        if (!this.conversion_profile.mask && Modifier.isStatic(access_flags) && (this.conversion_profile.applets_profile == null || this.conversion_profile.applets_profile.length == 0) && java_field.getValue() != null && DataType.isArrayType(descriptor)) {
            args = new Object[]{class_name.replace('/', '.'), field_name};
            Notifier.error("subset.22", args);
        }
    }

    private void checkLocalVariables(JMethod java_method, String class_name) {
        Object[] args;
        JCodeAttr code_attr = java_method.getCodeAttr();
        if (code_attr == null) {
            return;
        }
        JLocalVarTableAttr local_var_attr = code_attr.getLocalVarTableAttr();
        if (this.conversion_profile.debug && local_var_attr == null && code_attr.getMaxLocals() > 0) {
            args = new String[]{class_name.replace('/', '.')};
            Notifier.error("locals.1", args);
        }
        if (local_var_attr == null && code_attr.getMaxLocals() > 0) {
            args = new String[]{java_method.getMethodName(), class_name.replace('/', '.')};
            Notifier.warning("locals.2", args);
        }
        if (local_var_attr == null) {
            return;
        }
        JLocalVariable[] locals = local_var_attr.getLocalVars();
        int i = 0;
        while (i < locals.length) {
            JLocalVariable local = locals[i];
            if (DataType.getType(local.getDescriptor()) == 8) {
                Object[] args2 = new String[]{class_name.replace('/', '.'), "char"};
                Notifier.error("subset.40", args2);
            }
            ++i;
        }
    }

    private void checkMethod(JMethod java_method, String class_name) {
        Object[] args;
        int access_flags = java_method.getAccessFlags();
        String method_name = java_method.getMethodName();
        String descriptor = java_method.getMethodDescriptor();
        if (Modifier.isSynchronized(access_flags)) {
            args = new Object[]{class_name.replace('/', '.'), "synchronized", method_name};
            Notifier.error("subset.4", args);
        }
        if (Modifier.isNative(access_flags) && !this.conversion_profile.mask) {
            args = new Object[]{class_name.replace('/', '.'), "native", method_name};
            Notifier.error("subset.4", args);
        }
        String[] param_descs = MethodDescriptor.getParamDescriptors(descriptor);
        int i = 0;
        while (i < param_descs.length) {
            String error_string = this.checkType(param_descs[i]);
            if (error_string != null) {
                Object[] args2 = new Object[]{class_name.replace('/', '.'), error_string, method_name};
                Notifier.error("subset.5", args2);
            }
            ++i;
        }
        String return_desc = MethodDescriptor.getReturnDescriptor(descriptor);
        String error_string = this.checkType(return_desc);
        if (error_string != null && error_string != null) {
            Object[] args3 = new Object[]{class_name.replace('/', '.'), error_string, method_name};
            Notifier.error("subset.6", args3);
        }
        this.checkLocalVariables(java_method, class_name);
        this.checkByteCodes(java_method, class_name);
    }

    private void checkMethod(JcMethod jc_method, String class_name) {
        String method_name = jc_method.getMethodName();
        if (jc_method.getMaxLocals() + jc_method.getNargs() > 255) {
            Object[] args = new Object[]{class_name.replace('/', '.'), method_name};
            Notifier.error("subset.16", args);
        }
        this.checkByteCode(jc_method, class_name);
    }

    private String checkType(String descriptor) {
        int type = DataType.getType(descriptor);
        switch (type) {
            case 8: {
                return "char";
            }
            case 6: {
                return "double";
            }
            case 5: {
                return "float";
            }
            case 4: {
                return "long";
            }
            case 10: {
                if (DataType.isMultiDimensionArray(descriptor)) {
                    return "multidimension array";
                }
                if (descriptor.equals("Ljava/lang/String;")) {
                    return "String";
                }
                if (descriptor.equals("[Ljava/lang/String;")) {
                    return "String";
                }
                if (descriptor.equals("[C")) {
                    return "char[]";
                }
                if (descriptor.equals("[D")) {
                    return "double[]";
                }
                if (descriptor.equals("[F")) {
                    return "float[]";
                }
                if (!descriptor.equals("[J")) break;
                return "long[]";
            }
        }
        return null;
    }

    private void reportErrforUnsupportedByteCode(String class_name, String method_name, String method_descriptor, JInstruction code) {
        int opcode = code.getOpcode();
        int line_num = code.getSourceLineNumber();
        switch (opcode) {
            case 57: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                Object[] args = new String[]{class_name.replace('/', '.'), "double"};
                Notifier.error(line_num, "subset.40", args);
                break;
            }
            case 56: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                Object[] args = new String[]{class_name.replace('/', '.'), "float"};
                Notifier.error(line_num, "subset.40", args);
                break;
            }
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                Object[] args = new String[]{class_name.replace('/', '.'), "long"};
                Notifier.error(line_num, "subset.40", args);
                break;
            }
            case 14: 
            case 15: {
                int value = opcode - 14;
                Object[] args = new String[]{class_name.replace('/', '.'), "double"};
                Notifier.error(line_num, "subset.41", args);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                int value = opcode - 11;
                Object[] args = new String[]{class_name.replace('/', '.'), "float"};
                Notifier.error(line_num, "subset.41", args);
                break;
            }
            case 9: 
            case 10: {
                int value = opcode - 9;
                Object[] args = new String[]{class_name.replace('/', '.'), "long"};
                Notifier.error(line_num, "subset.41", args);
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                Object[] args;
                int value;
                int value_type = opcode == 18 ? ((JInstrCpByteRef)code).getValueType() : ((JInstrCpShortRef)code).getValueType();
                if (value_type == 5) {
                    value = opcode - 9;
                    args = new String[]{class_name.replace('/', '.'), "float"};
                    Notifier.error(line_num, "subset.41", args);
                }
                if (value_type == 20) {
                    value = opcode - 9;
                    args = new String[]{class_name.replace('/', '.'), "String"};
                    Notifier.error(line_num, "subset.41", args);
                }
                if (value_type == 4) {
                    value = opcode - 9;
                    args = new String[]{class_name.replace('/', '.'), "long"};
                    Notifier.error(line_num, "subset.41", args);
                }
                if (value_type != 6) break;
                value = opcode - 9;
                args = new String[]{class_name.replace('/', '.'), "double"};
                Notifier.error(line_num, "subset.41", args);
                break;
            }
            case 146: {
                Object[] args = new String[]{class_name.replace('/', '.'), "char"};
                Notifier.error(line_num, "subset.42", args);
                break;
            }
            case 135: {
                Object[] args = new String[]{class_name.replace('/', '.'), "double"};
                Notifier.error(line_num, "subset.43", args);
                break;
            }
            case 134: {
                Object[] args = new String[]{class_name.replace('/', '.'), "float"};
                Notifier.error(line_num, "subset.43", args);
                break;
            }
            case 133: {
                Object[] args = new String[]{class_name.replace('/', '.'), "long"};
                Notifier.error(line_num, "subset.43", args);
                break;
            }
            case 194: 
            case 195: {
                Notifier.error(line_num, "subset.44", class_name.replace('/', '.'));
                break;
            }
            case 197: {
                Notifier.error(line_num, "subset.45", class_name.replace('/', '.'));
                break;
            }
            case 200: 
            case 201: {
                Object[] args = new String[]{class_name.replace('/', '.'), Names.getMethodNameInJavaStyle(method_name, method_descriptor)};
                Notifier.error("subset.46", args);
                break;
            }
        }
    }
}

