/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.instructions.JInstrShortBranch;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.instructions.JcInstrBranch;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstruction;

class InstrBranchConverter
extends InstructionConverter {
    public InstrBranchConverter(InstrContainer instr_container, MethodConverter method_converter) {
        super(instr_container, method_converter);
    }

    private JcInstruction Goto(int jc_opcode) {
        JInstrShortBranch branch_instr = (JInstrShortBranch)this.java_instr;
        int branch_offset = branch_instr.getBranchOffset();
        int label = this.getBranchLabel(branch_offset);
        this.jc_instr = new JcInstrBranch(jc_opcode, label);
        return this.jc_instr;
    }

    private JcInstruction IfAcmpCond(int jc_opcode) {
        OperandStackEntry value1 = this.operand_stack.pop();
        OperandStackEntry value2 = this.operand_stack.pop();
        JInstrShortBranch branch_instr = (JInstrShortBranch)this.java_instr;
        int branch_offset = branch_instr.getBranchOffset();
        int label = this.getBranchLabel(branch_offset);
        this.jc_instr = new JcInstrBranch(jc_opcode, label);
        return this.jc_instr;
    }

    private JcInstruction IfCond(int jc_opcode) throws Exception {
        OperandStackEntry value = this.operand_stack.pop();
        JInstrShortBranch branch_instr = (JInstrShortBranch)this.java_instr;
        int branch_offset = branch_instr.getBranchOffset();
        int label = this.getBranchLabel(branch_offset);
        switch (value.getType()) {
            case 3: {
                this.jc_instr = new JcInstrNoOperands(10);
                this.operand_stack.push(value);
                this.operand_stack.push(3, this.instr_container);
                this.operand_stack.pop();
                this.operand_stack.pop();
                JcInstrNoOperands icmp = new JcInstrNoOperands(95);
                this.jc_instr.setNextInstr(icmp);
                icmp.setPrevInstr(this.jc_instr);
                JcInstrBranch if_cond = new JcInstrBranch(jc_opcode, label);
                icmp.setNextInstr(if_cond);
                if_cond.setPrevInstr(icmp);
                this.method_converter.getPackageConverter().setIntFlag(true);
                return this.jc_instr;
            }
            case 1: 
            case 2: {
                if (value.hasOverflowPotential()) {
                    if (this.method_converter.isIntSupported()) {
                        value.rollBack();
                    } else {
                        Notifier.error(this.java_instr.getSourceLineNumber(), "int.21", this.method_converter.getClassName().replace('/', '.'));
                        throw new ConversionException();
                    }
                }
                this.jc_instr = new JcInstrBranch(jc_opcode, label);
                return this.jc_instr;
            }
        }
        throw new ConverterInternalError();
    }

    private JcInstruction IfIcmpCond(int jc_opcode1, int jc_opcode2) throws Exception {
        OperandStackEntry value1 = this.operand_stack.peek(1);
        OperandStackEntry value2 = this.operand_stack.peek(2);
        JInstrShortBranch branch_instr = (JInstrShortBranch)this.java_instr;
        int branch_offset = branch_instr.getBranchOffset();
        int label = this.getBranchLabel(branch_offset);
        if (value1.getType() == 3 || value2.getType() == 3) {
            if (value2.getType() != 3) {
                if (this.method_converter.isIntSupported()) {
                    value2.rollBack();
                } else {
                    throw new ConverterInternalError();
                }
            }
            if (value1.getType() != 3) {
                if (this.method_converter.isIntSupported()) {
                    value1.rollBack();
                } else {
                    throw new ConverterInternalError();
                }
            }
            this.jc_instr = new JcInstrNoOperands(95);
            JcInstrBranch if_cond = new JcInstrBranch(jc_opcode2, label);
            this.jc_instr.setNextInstr(if_cond);
            if_cond.setPrevInstr(this.jc_instr);
            this.method_converter.getPackageConverter().setIntFlag(true);
        } else {
            if (value2.hasOverflowPotential()) {
                if (this.method_converter.isIntSupported()) {
                    value2.rollBack();
                } else {
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.21", this.method_converter.getClassName().replace('/', '.'));
                    throw new ConversionException();
                }
            }
            if (value1.hasOverflowPotential()) {
                if (this.method_converter.isIntSupported()) {
                    value1.rollBack();
                } else {
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.21", this.method_converter.getClassName().replace('/', '.'));
                    throw new ConversionException();
                }
            }
            this.jc_instr = new JcInstrBranch(jc_opcode1, label);
        }
        this.operand_stack.pop();
        this.operand_stack.pop();
        return this.jc_instr;
    }

    private JcInstruction IfNull(int jc_opcode) {
        OperandStackEntry value = this.operand_stack.pop();
        int label = this.getBranchLabel(((JInstrShortBranch)this.java_instr).getBranchOffset());
        return new JcInstrBranch(jc_opcode, label);
    }

    public JcInstruction convert() throws Exception {
        int opcode = this.java_instr.getOpcode();
        switch (opcode) {
            case 198: {
                return this.IfNull(158);
            }
            case 199: {
                return this.IfNull(159);
            }
            case 153: {
                return this.IfCond(152);
            }
            case 154: {
                return this.IfCond(153);
            }
            case 155: {
                return this.IfCond(154);
            }
            case 156: {
                return this.IfCond(155);
            }
            case 157: {
                return this.IfCond(156);
            }
            case 158: {
                return this.IfCond(157);
            }
            case 159: {
                return this.IfIcmpCond(162, 152);
            }
            case 160: {
                return this.IfIcmpCond(163, 153);
            }
            case 164: {
                return this.IfIcmpCond(167, 157);
            }
            case 161: {
                return this.IfIcmpCond(164, 154);
            }
            case 162: {
                return this.IfIcmpCond(165, 155);
            }
            case 163: {
                return this.IfIcmpCond(166, 156);
            }
            case 165: {
                return this.IfAcmpCond(160);
            }
            case 166: {
                return this.IfAcmpCond(161);
            }
            case 167: {
                return this.Goto(168);
            }
        }
        throw new ConverterInternalError();
    }

    private int getBranchLabel(int branch_offset) {
        int target_pc = this.java_instr.getPC() + branch_offset;
        InstrContainer cur_instr_container = this.method_converter.getInstrContainers();
        while (cur_instr_container != null) {
            int pc = cur_instr_container.getJInstr().getPC();
            if (target_pc == pc) {
                if (cur_instr_container.getLabel() == -1) {
                    throw new ConverterInternalError();
                }
                return cur_instr_container.getLabel();
            }
            cur_instr_container = cur_instr_container.getNextInstrContainer();
        }
        throw new ConverterInternalError();
    }
}

