/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.optimizers;

import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.constants.JcConstantFieldRef;
import com.sun.javacard.jcfile.instructions.JcInstrFieldRef;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.lang.reflect.Modifier;

public class FieldInstrOptimizer {
    JcPackage jc_package;

    public FieldInstrOptimizer(JcPackage jc_package) {
        this.jc_package = jc_package;
    }

    private boolean canOptimize(JcInstruction current_instr) {
        int opcode = current_instr.getOpcode();
        if (opcode == 24) {
            JcInstruction next_instr = current_instr.getNextInstr();
            if (next_instr == null) {
                return false;
            }
            int next_instr_opcode = next_instr.getOpcode();
            return next_instr_opcode >= 131 && next_instr_opcode <= 134;
        }
        return false;
    }

    private JcInstruction createOptimizedInstrs(JcInstruction current_instr) {
        JcInstruction next_instr = current_instr.getNextInstr();
        int new_opcode = 0;
        switch (next_instr.getOpcode()) {
            case 131: {
                new_opcode = 173;
                break;
            }
            case 132: {
                new_opcode = 174;
                break;
            }
            case 133: {
                new_opcode = 175;
                break;
            }
            case 134: {
                new_opcode = 176;
                break;
            }
        }
        JcConstantFieldRef field_ref = ((JcInstrFieldRef)next_instr).getFieldRef();
        JcInstrFieldRef new_instr = new JcInstrFieldRef(new_opcode, field_ref);
        if (current_instr.getLabel() != -1) {
            new_instr.setLabel(current_instr.getLabel());
        }
        if (next_instr.getLabel() != -1) {
            new_instr.setLabel(next_instr.getLabel());
        }
        new_instr.setSourceLineNumber(current_instr.getSourceLineNumber());
        return new_instr;
    }

    public JcPackage optimize() {
        JcClass[] jc_classes = this.jc_package.getClasses();
        int i = 0;
        while (i < jc_classes.length) {
            JcClass jc_class = jc_classes[i];
            JcMethod[] jc_methods = jc_class.getMethods();
            int j = 0;
            while (j < jc_methods.length) {
                JcMethod jc_method = jc_methods[j];
                int access_flags = jc_method.getAccessFlags();
                if (!Modifier.isStatic(access_flags)) {
                    JcInstruction code = jc_method.getCode();
                    JcInstruction optimized_code = this.optimizeCode(code);
                    jc_method.setCode(optimized_code);
                }
                ++j;
            }
            ++i;
        }
        return this.jc_package;
    }

    private JcInstruction optimizeCode(JcInstruction first_instr) {
        if (first_instr == null) {
            return null;
        }
        JcInstruction current_instr = first_instr;
        if (this.canOptimize(current_instr)) {
            first_instr = this.createOptimizedInstrs(current_instr);
            current_instr = current_instr.getNextInstr().getNextInstr();
            first_instr.setNextInstr(current_instr);
            if (current_instr != null) {
                current_instr.setPrevInstr(first_instr);
            }
        } else {
            current_instr = current_instr.getNextInstr();
        }
        while (current_instr != null) {
            if (this.canOptimize(current_instr)) {
                JcInstruction new_instr = this.createOptimizedInstrs(current_instr);
                JcInstruction prev_instr = current_instr.getPrevInstr();
                prev_instr.setNextInstr(new_instr);
                new_instr.setPrevInstr(prev_instr);
                current_instr = current_instr.getNextInstr().getNextInstr();
                new_instr.setNextInstr(current_instr);
                if (current_instr == null) continue;
                current_instr.setPrevInstr(new_instr);
                continue;
            }
            current_instr = current_instr.getNextInstr();
        }
        return first_instr;
    }
}

