/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.util;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class Notifier {
    private static final int NO_LINE_NUMBER = -1;
    protected static ResourceBundle messages = ResourceBundle.getBundle("com/sun/javacard/converter/MessagesBundle");
    protected static boolean no_warn = false;
    protected static boolean no_banner = false;
    protected static PrintWriter progress_writer = new PrintWriter(System.out, true);
    protected static PrintWriter error_writer = new PrintWriter(System.err, true);
    protected static PrintWriter output_writer = new PrintWriter(System.out, true);
    protected static int error_count = 0;
    protected static int warning_count = 0;
    protected static boolean verbose = false;

    public static void error(int line_number, String key) {
        ++error_count;
        if (line_number > 0) {
            Object[] args = new String[]{String.valueOf(line_number)};
            error_writer.print(MessageFormat.format(messages.getString("key.error.linenumber"), args));
        } else {
            error_writer.print(messages.getString("key.error"));
        }
        error_writer.println(messages.getString(key));
    }

    public static void error(int line_number, String key, String arg) {
        Object[] args = new Object[]{arg};
        Notifier.error(line_number, key, args);
    }

    public static void error(int line_number, String key, Object[] args) {
        ++error_count;
        if (line_number > 0) {
            Object[] line_args = new String[]{String.valueOf(line_number)};
            error_writer.print(MessageFormat.format(messages.getString("key.error.linenumber"), line_args));
        } else {
            error_writer.print(messages.getString("key.error"));
        }
        error_writer.println(MessageFormat.format(messages.getString(key), args));
    }

    public static void error(String key) {
        Notifier.error(-1, key);
    }

    public static void error(String key, String arg) {
        Notifier.error(-1, key, arg);
    }

    public static void error(String key, Object[] args) {
        Notifier.error(-1, key, args);
    }

    public static int getErrorCount() {
        return error_count;
    }

    public static PrintWriter getErrorWriter() {
        return error_writer;
    }

    public static boolean getNoBannerFlag() {
        return no_banner;
    }

    public static boolean getNoWarningFlag() {
        return no_warn;
    }

    public static PrintWriter getOutputWriter() {
        return output_writer;
    }

    public static PrintWriter getProgressWriter() {
        return progress_writer;
    }

    public static boolean getVerboseFlag() {
        return verbose;
    }

    public static int getWarningCount() {
        return warning_count;
    }

    public static void newLine() {
        if (!no_banner) {
            output_writer.println();
        }
    }

    public static void out(String key) {
        if (!no_banner) {
            output_writer.println(messages.getString(key));
        }
    }

    public static void out(String key, String arg) {
        if (!no_banner) {
            Object[] args = new Object[]{arg};
            output_writer.println(MessageFormat.format(messages.getString(key), args));
        }
    }

    public static void out(String key, Object[] args) {
        if (!no_banner) {
            output_writer.println(MessageFormat.format(messages.getString(key), args));
        }
    }

    public static void progress(String key) {
        if (verbose) {
            Notifier.out(key);
        }
    }

    public static void progress(String key, String arg) {
        if (verbose) {
            Notifier.out(key, arg);
        }
    }

    public static void progress(String key, Object[] args) {
        if (verbose) {
            Notifier.out(key, args);
        }
    }

    public static void setErrorWriter(PrintWriter writer) {
        error_writer = writer;
    }

    public static void setNoBannerFlag(boolean flag) {
        no_banner = flag;
    }

    public static void setNoWarningFlag(boolean flag) {
        no_warn = flag;
    }

    public static void setOutputWriter(PrintWriter writer) {
        output_writer = writer;
    }

    public static void setProgressWriter(PrintWriter writer) {
        progress_writer = writer;
    }

    public static void setVerbose(boolean flag) {
        verbose = flag;
    }

    public static void setVerboseFlag(boolean flag) {
        verbose = flag;
    }

    public static void warning(int line_number, String key) {
        ++warning_count;
        if (no_warn) {
            return;
        }
        if (line_number > 0) {
            Object[] line_args = new String[]{String.valueOf(line_number)};
            error_writer.print(MessageFormat.format(messages.getString("key.warning.linenumber"), line_args));
        } else {
            error_writer.print(messages.getString("key.warning"));
        }
        error_writer.println(messages.getString(key));
    }

    public static void warning(int line_number, String key, String arg) {
        Object[] args = new Object[]{arg};
        Notifier.warning(line_number, key, args);
    }

    public static void warning(int line_number, String key, Object[] args) {
        ++warning_count;
        if (no_warn) {
            return;
        }
        if (line_number > 0) {
            Object[] line_args = new String[]{String.valueOf(line_number)};
            error_writer.print(MessageFormat.format(messages.getString("key.warning.linenumber"), line_args));
        } else {
            error_writer.print(messages.getString("key.warning"));
        }
        error_writer.println(MessageFormat.format(messages.getString(key), args));
    }

    public static void warning(String key) {
        Notifier.warning(-1, key);
    }

    public static void warning(String key, String arg) {
        Notifier.warning(-1, key, arg);
    }

    public static void warning(String key, Object[] args) {
        Notifier.warning(-1, key, args);
    }
}

