/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.util;

import com.sun.javacard.converter.ConverterException;
import java.util.StringTokenizer;

public class Strings {
    public static byte[] toByteArray(String string, String delimiter) throws Exception {
        String[] strings = Strings.toStrings(string, delimiter);
        byte[] bytes = new byte[strings.length];
        int i = 0;
        while (i < strings.length) {
            bytes[i] = Integer.decode(strings[i]).byteValue();
            if (Integer.decode(strings[i]) > 255) {
                throw new ConverterException("invalid AID");
            }
            ++i;
        }
        return bytes;
    }

    public static final String toHexString(byte value) {
        return "0x" + Integer.toHexString(value & 0xFF).toUpperCase();
    }

    public static final String toHexString(int value) {
        String hexString = Long.toHexString(value & 0xFFFFFFFF).toUpperCase();
        int addNumZeros = 8 - hexString.length();
        StringBuffer sb = new StringBuffer();
        while (addNumZeros != 0) {
            sb.append("0");
            --addNumZeros;
        }
        sb.append(hexString);
        return sb.toString();
    }

    public static final String toHexString(short value) {
        String hexString = Integer.toHexString(value & 0xFFFF).toUpperCase();
        int addNumZeros = 4 - hexString.length();
        StringBuffer sb = new StringBuffer();
        while (addNumZeros != 0) {
            sb.append("0");
        }
        sb.append(hexString);
        return sb.toString();
    }

    public static final String toHexString(byte[] value, String delimiter) {
        StringBuffer sb = new StringBuffer();
        sb.append(Strings.toHexString(value[0]));
        int i = 1;
        while (i < value.length) {
            sb.append(delimiter);
            sb.append(Strings.toHexString(value[i]));
            ++i;
        }
        return sb.toString();
    }

    public static String[] toStrings(String string, String delimiter) {
        StringTokenizer parser = new StringTokenizer(string, delimiter);
        int num_token = parser.countTokens();
        String[] strings = new String[num_token];
        int count = 0;
        while (parser.hasMoreTokens()) {
            strings[count++] = parser.nextToken();
        }
        return strings;
    }
}

