/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugcomponent;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.debugcomponent.DebugComponent;
import com.sun.javacard.debugcomponent.LineInfo;
import com.sun.javacard.debugcomponent.VariableInfo;
import com.sun.javacard.jcfile.JcLocalVariable;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class MethodDebugInfo
extends MethodDefinition {
    private int name_index;
    private int descriptor_index;
    private int location;
    private int header_size;
    private int bytecode_size;
    private VariableInfo[] var_table;
    private LineInfo[] line_table;

    public MethodDebugInfo(JcMethod jc_method, DebugComponent debug_comp) {
        super(jc_method);
        this.build(jc_method, debug_comp);
    }

    private void build(JcMethod jc_method, DebugComponent debug_comp) {
        this.name_index = debug_comp.addString(this.method_name);
        this.descriptor_index = debug_comp.addString(this.descriptor);
        this.header_size = 2;
        if (jc_method.getMaxStack() > 15) {
            this.header_size = 4;
        }
        if (jc_method.getNargs() > 15) {
            this.header_size = 4;
        }
        if (jc_method.getMaxLocals() > 15) {
            this.header_size = 4;
        }
        JcInstruction jc_code = jc_method.getCode();
        while (jc_code != null) {
            this.bytecode_size += jc_code.getSizeInBytes();
            jc_code = jc_code.getNextInstr();
        }
        JcLocalVariable[] local_vars = jc_method.getLocalVariables();
        Vector<VariableInfo> var_vector = new Vector<VariableInfo>();
        int i = 0;
        while (i < local_vars.length) {
            JcLocalVariable this_local = local_vars[i];
            while (this_local != null) {
                var_vector.addElement(new VariableInfo(jc_method, this_local, debug_comp));
                this_local = this_local.getNext();
            }
            ++i;
        }
        this.var_table = new VariableInfo[var_vector.size()];
        var_vector.copyInto(this.var_table);
        jc_code = jc_method.getCode();
        Vector<LineInfo> line_vector = new Vector<LineInfo>(20, 10);
        while (jc_code != null) {
            JcInstruction start_instr = jc_code;
            JcInstruction end_instr = jc_code;
            int source_line = start_instr.getSourceLineNumber();
            while (jc_code != null) {
                end_instr = jc_code;
                if (jc_code.getSourceLineNumber() != source_line) break;
                jc_code = jc_code.getNextInstr();
            }
            int start_pc = start_instr.getPC();
            int end_pc = end_instr.getPC();
            if (jc_code == null) {
                end_pc += end_instr.getSizeInBytes();
            }
            LineInfo line_info = new LineInfo(start_pc, end_pc, source_line);
            line_vector.addElement(line_info);
        }
        this.line_table = new LineInfo[line_vector.size()];
        line_vector.copyInto(this.line_table);
    }

    public int getSize() {
        int size = 0;
        int i = 0;
        while (i < this.var_table.length) {
            size += this.var_table[i].getSize();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.line_table.length) {
            size += this.line_table[i2].getSize();
            ++i2;
        }
        return size + 15;
    }

    public void toBinary(DataOutputStream dos) throws IOException {
        dos.writeShort(this.name_index);
        dos.writeShort(this.descriptor_index);
        dos.writeShort(this.access_flags);
        dos.writeShort(this.location);
        dos.writeByte(this.header_size);
        dos.writeShort(this.bytecode_size);
        dos.writeShort(this.var_table.length);
        dos.writeShort(this.line_table.length);
        int i = 0;
        while (i < this.var_table.length) {
            this.var_table[i].toBinary(dos);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.line_table.length) {
            this.line_table[i2].toBinary(dos);
            ++i2;
        }
        dos.flush();
    }

    public void toText(PrintWriter pw, int tab_level) throws IOException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < tab_level) {
            sb.append("\t");
            ++i;
        }
        String indent = sb.toString();
        pw.println(String.valueOf(indent) + "method_debug_info { ");
        pw.println(String.valueOf(indent) + "\tname_index " + this.name_index + "\t\t//" + this.method_name);
        pw.println(String.valueOf(indent) + "\tdescriptor_index " + this.descriptor_index + "\t\t//" + this.descriptor);
        pw.println(String.valueOf(indent) + "\taccess_flags " + Modifier.toString(this.access_flags));
        pw.println(String.valueOf(indent) + "\tlocation " + this.location);
        pw.println(String.valueOf(indent) + "\theader_size " + this.header_size);
        pw.println(String.valueOf(indent) + "\tbytecode_size " + this.bytecode_size);
        pw.println(String.valueOf(indent) + "\tvariable_count " + this.var_table.length);
        pw.println(String.valueOf(indent) + "\tline_count " + this.line_table.length);
        int i2 = 0;
        while (i2 < this.var_table.length) {
            this.var_table[i2].toText(pw, tab_level + 1);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.line_table.length) {
            this.line_table[i3].toText(pw, tab_level + 1);
            ++i3;
        }
        pw.println(String.valueOf(indent) + "}");
        pw.flush();
    }
}

