/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.ClassIdentifier;
import com.sun.javacard.jcasm.JCClass;

public class SuperInterface {
    protected ClassIdentifier classIdentifier;
    protected String className;
    protected JCClass parentClass;
    protected JCClass resolvedTo;

    SuperInterface(JCClass parentClass, ClassIdentifier classIdentifier) {
        Assert.PreCondition(classIdentifier != null, "classIdentifier != null");
        this.parentClass = parentClass;
        this.classIdentifier = classIdentifier;
    }

    SuperInterface(JCClass parentClass, String className) {
        Assert.PreCondition(className != null, "className != null");
        this.parentClass = parentClass;
        this.className = className;
    }

    public ClassIdentifier getClassIdentifier() {
        return this.classIdentifier;
    }

    public String getName() {
        return this.className;
    }

    public boolean isResolved() {
        return this.resolvedTo != null;
    }

    public JCClass resolve() {
        Assert.PreCondition(this.resolvedTo != null, "resolvedTo != null");
        return this.resolvedTo;
    }

    public void resolve(JCClass c) {
        Assert.PreCondition(c != null, "c != null");
        this.resolvedTo = c;
    }
}

