/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.SortableVector;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Map;

public class ClassComponent
extends Component {
    protected SortableVector classVector = new SortableVector();

    public ClassComponent(JCPackage p) {
        super(p);
    }

    void add(JCClass c) {
        this.classVector.addElement(c);
    }

    void assignAddresses() {
        int address = 0;
        this.classVector.sort();
        Enumeration e = this.classVector.elements();
        while (e.hasMoreElements()) {
            JCClass c = (JCClass)e.nextElement();
            c.relocate(address);
            address += c.size();
            int instanceFieldRelocPc = 0;
            Enumeration f = c.fieldElements();
            while (f.hasMoreElements()) {
                Field field = (Field)f.nextElement();
                if (Modifier.isStatic(field.getAttributes())) continue;
                field.relocate(instanceFieldRelocPc);
                instanceFieldRelocPc += Math.max(2, field.size());
            }
        }
    }

    public int dataSize() {
        int size = 0;
        Enumeration e = this.classVector.elements();
        while (e.hasMoreElements()) {
            JCClass c = (JCClass)e.nextElement();
            size += c.size();
        }
        return size;
    }

    protected void getDebugOffsets(Map offsets) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            byte[] header = super.toByteArray();
            dos.write(header, 0, header.length);
            Enumeration e = this.classVector.elements();
            while (e.hasMoreElements()) {
                JCClass c = (JCClass)e.nextElement();
                byte[] array = c.toByteArray();
                offsets.put(c.getName(), new Integer(dos.size()));
                dos.write(array, 0, array.length);
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    protected byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            byte[] header = super.toByteArray();
            dos.write(header, 0, header.length);
            Enumeration e = this.classVector.elements();
            while (e.hasMoreElements()) {
                JCClass c = (JCClass)e.nextElement();
                byte[] array = c.toByteArray();
                dos.write(array, 0, array.length);
            }
            dos.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        Assert.PostCondition(this.size() == bos.size(), "size() != bos.size()");
        return bos.toByteArray();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        Enumeration e = this.classVector.elements();
        while (e.hasMoreElements()) {
            JCClass c = (JCClass)e.nextElement();
            byte[] array = c.toByteArray();
            sb.append("Class: " + Msg.toHexString(array) + Msg.eol);
        }
        return sb.toString();
    }
}

