/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.ParseException;
import com.sun.javacard.jcasm.Parser;
import com.sun.javacard.jcasm.cap.CapFile;
import com.sun.javacard.jcasm.cap.CapLinker;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Main {
    public static boolean noBanner;

    private static void banner() {
        Object[] arguments = new Object[]{new Integer(0), new Integer(55)};
        Msg.info("main.0", arguments);
        Msg.info("main.2", null);
    }

    public static void main(String[] argv) {
        File outputFile = null;
        String inputFile = null;
        Globals.mode = 1;
        int i = 0;
        while (i < argv.length && argv[i].startsWith("-")) {
            if (argv[i].equals("-debug")) {
                Globals.debug = true;
                try {
                    Globals.debugLevel = Integer.decode(argv[++i]);
                }
                catch (NumberFormatException numberFormatException) {
                    Main.usage(true);
                }
            } else if (argv[i].equals("-help")) {
                Main.usage(false);
                System.exit(0);
            } else if (argv[i].equals("-nobanner")) {
                noBanner = true;
            } else if (argv[i].equals("-o")) {
                if (++i < argv.length) {
                    outputFile = new File(argv[i]);
                } else {
                    Main.usage(true);
                }
            } else if (argv[i].startsWith("-o")) {
                outputFile = new File(argv[i].substring(2));
            } else if (argv[i].equals("-version")) {
                Main.banner();
                System.exit(0);
            } else {
                if (argv[i].equals("--")) {
                    ++i;
                    break;
                }
                Object[] args = new Object[]{argv[i]};
                Msg.error("main.1", args);
                Main.usage(true);
            }
            ++i;
        }
        if (i < argv.length) {
            inputFile = argv[i++];
        } else {
            Main.usage(true);
        }
        File iFile = new File(inputFile);
        String cName = null;
        try {
            cName = iFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            cName = "";
        }
        if (Globals.debug) {
            String dName = null;
            int lastSep = cName.lastIndexOf(File.pathSeparatorChar);
            dName = lastSep == -1 ? "debug.cap" : String.valueOf(cName.substring(0, lastSep)) + "debug.cap";
        }
        if (!noBanner) {
            Main.banner();
        }
        Parser parser = null;
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(inputFile));
            parser = new Parser(bis);
            Parser.inputSpec = inputFile;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Object[] arguments = new Object[]{inputFile};
            Msg.error("main.16", arguments);
            System.exit(1);
        }
        JCPackage pack = null;
        try {
            pack = Parser.PackageDeclaration();
        }
        catch (ParseException e) {
            System.err.println(e);
            ++Globals.errors;
        }
        if (Globals.errors == 0) {
            CapFile cap = new CapFile(pack);
            if (Globals.errors == 0) {
                CapLinker.link(pack);
                if (Globals.errors == 0) {
                    try {
                        if (outputFile == null) {
                            outputFile = new File("a.jar");
                        }
                        cap.gen(outputFile);
                    }
                    catch (IOException e) {
                        System.err.println(e);
                        ++Globals.errors;
                    }
                }
            }
        }
        if (Globals.errors != 0) {
            outputFile.delete();
        }
        System.exit(Globals.errors);
    }

    private static void usage(boolean isError) {
        Msg.info("main.10", null);
        Msg.info("main.11", null);
        System.err.println("");
        int i = 12;
        while (i < 16) {
            Msg.info("main." + i, null);
            ++i;
        }
        if (isError) {
            System.exit(1);
        }
    }
}

