/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.mask.OutputFormatter;
import com.sun.javacard.jcasm.mask.RomMask;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;

public class SizeOutputFormatter
extends OutputFormatter {
    private int nPackages;
    private int nClasses;
    private int nStaticFields;
    private int nFinalStaticFields;
    private int classSize;
    private int nMethods;
    private int nNativeMethods;
    private int methodSize;
    private int exTblCount;
    private int exportSize;
    private Vector packageStats = new Vector();
    private Vector classStats = new Vector();
    private Vector methodStats = new Vector();

    public SizeOutputFormatter(BufferedReader configFile) throws IOException {
        super(configFile);
    }

    public void format(RomMask r) {
        Enumeration e = r.packageElements();
        while (e.hasMoreElements()) {
            JCPackage jPackage = (JCPackage)e.nextElement();
            ExportComponent export = new ExportComponent(jPackage);
            ++this.nPackages;
            this.packageStats.addElement(new PackageStat(jPackage.getIdentifier()));
            Enumeration c = jPackage.classElements();
            while (c.hasMoreElements()) {
                JCClass jClass = (JCClass)c.nextElement();
                jClass.relocate(0);
                ++this.nClasses;
                this.classSize += jClass.size();
                this.classStats.addElement(new ClassStat(jClass.getName(), jClass.size()));
                Enumeration f = jClass.fieldElements();
                while (f.hasMoreElements()) {
                    Field jField = (Field)f.nextElement();
                    jField.relocate(0);
                    int mod = jField.getAttributes();
                    if (!Modifier.isStatic(mod)) continue;
                    ++this.nStaticFields;
                    if (!Modifier.isFinal(mod)) continue;
                    ++this.nFinalStaticFields;
                }
                Enumeration m = jClass.methodElements();
                while (m.hasMoreElements()) {
                    JCMethod jMethod = (JCMethod)m.nextElement();
                    jMethod.relocate(0);
                    int mod = jMethod.getAttributes();
                    if (Modifier.isNative(mod)) {
                        ++this.nNativeMethods;
                        continue;
                    }
                    ++this.nMethods;
                    this.methodSize += jMethod.size();
                    this.methodStats.addElement(new MethodStat(jMethod.getName(), jMethod.size()));
                    ExceptionTable exTbl = jMethod.getExceptionTable();
                    if (exTbl == null) continue;
                    Enumeration h = exTbl.elements();
                    while (h.hasMoreElements()) {
                        ExceptionTableEntry entry = (ExceptionTableEntry)h.nextElement();
                        ++this.exTblCount;
                    }
                }
                export.add(jClass);
            }
            this.exportSize += export.size();
        }
    }

    public void write(OutputStream os) {
        PrintWriter pw = new PrintWriter(os);
        Object[] args = new Object[4];
        pw.println(Msg.getMessage("size.1"));
        args[0] = new Integer(this.nPackages);
        pw.println(Msg.getMessage("size.2", args));
        args[0] = new Integer(this.nClasses);
        pw.println(Msg.getMessage("size.3", args));
        args[0] = new Integer(this.nMethods);
        pw.println(Msg.getMessage("size.4", args));
        args[0] = new Integer(this.nNativeMethods);
        pw.println(Msg.getMessage("size.5", args));
        args[0] = new Integer(this.nStaticFields);
        args[1] = new Integer(this.nFinalStaticFields);
        pw.println(Msg.getMessage("size.6", args));
        args[0] = new Integer(this.classSize);
        pw.println(Msg.getMessage("size.7", args));
        args[0] = new Integer(this.methodSize);
        pw.println(Msg.getMessage("size.8", args));
        args[0] = new Integer(this.exTblCount * 8);
        args[1] = new Integer(this.exTblCount);
        pw.println(Msg.getMessage("size.12", args));
        args[0] = new Integer(this.exportSize);
        pw.println(Msg.getMessage("size.13", args));
        pw.println("");
        pw.println(Msg.getMessage("size.9", null));
        Enumeration e = this.packageStats.elements();
        while (e.hasMoreElements()) {
            PackageStat stat = (PackageStat)e.nextElement();
            args[0] = stat.pid.getAid().toString();
            args[1] = new Integer(stat.pid.getMajorVersion());
            args[2] = new Integer(stat.pid.getMinorVersion());
            pw.println(Msg.getMessage("size.91", args));
        }
        pw.println("");
        pw.println(Msg.getMessage("size.10", null));
        Enumeration e2 = this.classStats.elements();
        while (e2.hasMoreElements()) {
            ClassStat stat = (ClassStat)e2.nextElement();
            pw.println(String.valueOf(stat.name) + ": " + stat.size);
        }
        pw.println("");
        pw.println(Msg.getMessage("size.11", null));
        Enumeration e3 = this.methodStats.elements();
        while (e3.hasMoreElements()) {
            MethodStat stat = (MethodStat)e3.nextElement();
            pw.println(String.valueOf(stat.name) + ": " + stat.size);
        }
        pw.flush();
    }

    static class PackageStat {
        PackageIdentifier pid;

        PackageStat(PackageIdentifier pid) {
            this.pid = pid;
        }
    }

    static class ClassStat {
        String name;
        int size;

        ClassStat(String name, int size) {
            this.name = name;
            this.size = size;
        }
    }

    static class MethodStat {
        String name;
        int size;

        MethodStat(String name, int size) {
            this.name = name;
            this.size = size;
        }
    }
}

