/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassAndMethodDescriptor;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.ConstantPoolComponent;
import com.sun.javacard.offcardverifier.ConstantPoolEntry;
import com.sun.javacard.offcardverifier.Contour;
import com.sun.javacard.offcardverifier.ExnHandler;
import com.sun.javacard.offcardverifier.Instr;
import com.sun.javacard.offcardverifier.InstrLookupSwitch;
import com.sun.javacard.offcardverifier.InstrTableSwitch;
import com.sun.javacard.offcardverifier.MethodTypeAndFlags;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.State;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeArray;
import com.sun.javacard.offcardverifier.TypeClass;
import com.sun.javacard.offcardverifier.TypeInit;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.TypeNull;
import com.sun.javacard.offcardverifier.TypeRetaddr;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.Hashtable;
import java.util.Stack;

class AbstrInterp {
    private static Type[][] stackEffect;
    private static final int REGULAR_METHOD = 0;
    private static final int INIT_METHOD = 1;
    private static final int INIT_METHOD_IN_INITIALIZER = 2;
    private static Type actualSelfType;
    private static Hashtable seenStates;
    private static Stack pendingStates;
    private static Type methodResultType;
    private static TypeClass currentClass;
    private static int methodInitStatus;

    AbstrInterp() {
    }

    private static void checkProtectedAccess(Type tyObj) {
        if (!tyObj.isSubtype(currentClass)) {
            throw new VerifierError("AbstrInterp.52");
        }
    }

    private static void checkUninitialized(Type[] locals, Type[] stack, int sp) {
        int i = 0;
        while (i < locals.length) {
            Type l = locals[i];
            if (l != null && l instanceof TypeInit) {
                throw new VerifierError("AbstrInterp.110", i, (Object)l);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < sp) {
            Type s = stack[i2];
            if (s instanceof TypeInit) {
                throw new VerifierError("AbstrInterp.111", i2, (Object)s);
            }
            ++i2;
        }
    }

    private static void enterState(int pc, Contour contour, Type[] locals, Type[] stack, int sp) {
        State newstate = new State(pc, contour, locals, stack, sp);
        State oldstate = (State)seenStates.get(newstate);
        if (oldstate == null) {
            seenStates.put(newstate, newstate);
            pendingStates.push(newstate);
            return;
        }
        boolean unchanged = true;
        if (oldstate.sp != newstate.sp) {
            throw new VerifierError("AbstrInterp.100", oldstate.sp, newstate.sp);
        }
        int i = 0;
        while (i < oldstate.locals.length) {
            Type oldty = oldstate.locals[i];
            Type newty = newstate.locals[i];
            if (oldty != null) {
                Type mergedty;
                oldstate.locals[i] = mergedty = newty != null ? oldty.lub(newty) : null;
                unchanged = unchanged && oldty.equals(mergedty);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < oldstate.sp) {
            Type oldty = oldstate.stack[i2];
            Type newty = newstate.stack[i2];
            Type mergedty = oldty.lub(newty);
            if (mergedty == null) {
                throw new VerifierError("AbstrInterp.101", i2, (Object)oldty, (Object)newty);
            }
            oldstate.stack[i2] = mergedty;
            unchanged = unchanged && oldty.equals(mergedty);
            ++i2;
        }
        if (!unchanged) {
            pendingStates.push(oldstate);
        }
    }

    private static TypeClass findCpoolReferenceClass(int idx) {
        ConstantPoolEntry cp = Cap.ConstantPool.entry(idx);
        switch (cp.tag()) {
            case 2: 
            case 3: 
            case 4: {
                return new TypeClass(cp.classRefVirtualRef());
            }
            case 7: {
                if (cp.isExternalStaticRef()) {
                    return new TypeClass(cp.classStaticRef());
                }
                ClassAndMethodDescriptor cmdesc = Methodref.findDescr(cp.internalStaticRef());
                return new TypeClass(cmdesc.classDescr.thisClass());
            }
        }
        throw new VerifierError("AbstrInterp.51");
    }

    private static int findCpoolReferenceClassref(int idx) {
        ConstantPoolEntry cp = Cap.ConstantPool.entry(idx);
        return cp.classRef();
    }

    private static TypeMethod findCpoolReferenceMethodtype(int idx) {
        int tyIdx = Cap.TypeDescr.constantPoolType(idx);
        Safeptr ty = Cap.TypeDescr.at(tyIdx);
        return TypeMethod.parseCap(ty);
    }

    private static Type findCpoolReferenceType(int idx) {
        int tyIdx = Cap.TypeDescr.constantPoolType(idx);
        Safeptr ty = Cap.TypeDescr.at(tyIdx);
        return Type.parseCap(ty).normalize();
    }

    static void initialize() {
        Type[][] se = new Type[][]{{null, null}, {null, Type.Null, null}, {null, Type.Short, null}, {null, Type.Short, null}, {null, Type.Short, null}, {null, Type.Short, null}, {null, Type.Short, null}, {null, Type.Short, null}, {null, Type.Short, null}, {null, Type.Int, Type.Int2, null}, {null, Type.Int, Type.Int2, null}, {null, Type.Int, Type.Int2, null}, {null, Type.Int, Type.Int2, null}, {null, Type.Int, Type.Int2, null}, {null, Type.Int, Type.Int2, null}, {null, Type.Int, Type.Int2, null}, {null, Type.Short, null}, {null, Type.Short, null}, {null, Type.Int, Type.Int2, null}, {null, Type.Int, Type.Int2, null}, {null, Type.Int, Type.Int2, null}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, {Type.ByteArray, Type.Short, null, Type.Short, null}, {Type.ShortArray, Type.Short, null, Type.Short, null}, {Type.IntArray, Type.Short, null, Type.Int, Type.Int2, null}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, {Type.ByteArray, Type.Short, Type.Short, null, null}, {Type.ShortArray, Type.Short, Type.Short, null, null}, {Type.IntArray, Type.Short, Type.Int, Type.Int2, null, null}, null, null, null, null, null, null, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, {Type.Short, Type.Short, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Int, Type.Int2, null}, null, null, {Type.Short, null, Type.Short, null}, {Type.Short, null, Type.Int, Type.Int2, null}, {Type.Int, Type.Int2, null, Type.Short, null}, {Type.Int, Type.Int2, null, Type.Short, null}, {Type.Int, Type.Int2, Type.Int, Type.Int2, null, Type.Short, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {new TypeClass(Classref.Object), null, null}, {new TypeClass(Classref.Object), null, null}, {new TypeClass(Classref.Object), new TypeClass(Classref.Object), null, null}, {new TypeClass(Classref.Object), new TypeClass(Classref.Object), null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {null, null}, null, null, {Type.Short, null, null}, {Type.Int, Type.Int2, null, null}, {Type.Short, null, null}, {Type.Int, Type.Int2, null, null}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, {new TypeClass(Classref.Throwable), null, null}, null, {new TypeClass(Classref.Object), null, Type.Short, null}, null, null, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {Type.Short, null, null}, {new TypeClass(Classref.Object), null, null}, {new TypeClass(Classref.Object), null, null}, {new TypeClass(Classref.Object), new TypeClass(Classref.Object), null, null}, {new TypeClass(Classref.Object), new TypeClass(Classref.Object), null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {Type.Short, Type.Short, null, null}, {null, null}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
        stackEffect = se;
    }

    private static Type[] initializeInstance(Type[] ty, int n) {
        Type[] newty = (Type[])ty.clone();
        TypeClass initialized = new TypeClass(((TypeInit)AbstrInterp.actualSelfType).classref);
        int i = 0;
        while (i < n) {
            if (actualSelfType.equals(newty[i])) {
                newty[i] = initialized;
            }
            ++i;
        }
        return newty;
    }

    private static int matchArgumentsAndPushResult(Type[] stack, int sp, TypeMethod mty, TypeClass selfty, int initStatus, boolean isExternalProtected) {
        int numArgs = mty.args.length;
        if (selfty != null) {
            ++numArgs;
        }
        if (sp < numArgs) {
            throw new VerifierError("AbstrInterp.48");
        }
        int i = 0;
        actualSelfType = null;
        if (selfty != null) {
            Type ty = stack[sp - numArgs];
            boolean matched = false;
            switch (initStatus) {
                case 0: {
                    matched = ty.isSubtype(selfty);
                    break;
                }
                case 1: {
                    matched = ty instanceof TypeInit && ((TypeInit)ty).classref == selfty.classref;
                    actualSelfType = ty;
                    break;
                }
                case 2: {
                    matched = ty instanceof TypeInit && Classref.isSameOrSuper(((TypeInit)ty).classref, selfty.classref);
                    actualSelfType = ty;
                    break;
                }
            }
            if (!matched) {
                throw new VerifierError("AbstrInterp.49");
            }
            if (isExternalProtected) {
                AbstrInterp.checkProtectedAccess(ty);
            }
            i = 1;
        }
        int j = 0;
        while (j < mty.args.length) {
            Type actualTy = stack[sp - numArgs + i];
            Type expectedTy = mty.args[j].normalize();
            if (!actualTy.isSubtype(expectedTy)) {
                throw new VerifierError("AbstrInterp.50", j, (Object)expectedTy, (Object)actualTy);
            }
            ++i;
            ++j;
        }
        sp -= numArgs;
        if (mty.res != Type.Void) {
            sp = AbstrInterp.push(stack, sp, mty.res.normalize());
        }
        return sp;
    }

    private static int matchStack(Type[] effect, Type[] stack, int sp) {
        int i = 0;
        int nargs = 0;
        while (effect[i] != null) {
            ++nargs;
            ++i;
        }
        if (nargs > sp) {
            throw new VerifierError("AbstrInterp.44");
        }
        int j = 0;
        while (j < nargs) {
            Type actualTy = stack[sp - nargs + j];
            Type expectedTy = effect[j];
            if (!actualTy.isSubtype(expectedTy)) {
                throw new VerifierError("AbstrInterp.45", (Object)expectedTy, (Object)actualTy);
            }
            ++j;
        }
        sp -= nargs;
        ++i;
        while (effect[i] != null) {
            if (sp >= stack.length) {
                throw new VerifierError("AbstrInterp.46");
            }
            stack[sp] = effect[i];
            ++sp;
            ++i;
        }
        return sp;
    }

    private static int popMatch(Type[] stack, int sp, Type ty) {
        if (ty == Type.Int) {
            sp = AbstrInterp.popMatch(stack, sp, Type.Int2);
        }
        if (sp <= 0) {
            throw new VerifierError("AbstrInterp.44");
        }
        Type sty = stack[sp - 1];
        if (!sty.isSubtype(ty)) {
            throw new VerifierError("AbstrInterp.45", (Object)ty, (Object)sty);
        }
        return sp - 1;
    }

    private static int push(Type[] stack, int sp, Type ty) {
        if (sp >= stack.length) {
            throw new VerifierError("AbstrInterp.47");
        }
        stack[sp] = ty;
        if (ty == Type.Int) {
            return AbstrInterp.push(stack, sp + 1, Type.Int2);
        }
        return sp + 1;
    }

    static void simulate(Instr[] code, int maxStack, int maxLocal, TypeMethod tymeth, TypeClass self, boolean isInit, TypeClass currClass) {
        try {
            seenStates = new Hashtable(51);
            pendingStates = new Stack();
            Type[] initStack = new Type[maxStack];
            Type[] initLocal = new Type[maxLocal];
            int i = 0;
            if (self != null) {
                initLocal[i++] = isInit ? new TypeInit(self.classref, -1) : self;
            }
            int j = 0;
            while (j < tymeth.args.length) {
                initLocal[i++] = tymeth.args[j].normalize();
                ++j;
            }
            AbstrInterp.enterState(0, Contour.empty, initLocal, initStack, 0);
            methodResultType = tymeth.res.normalize();
            methodInitStatus = isInit ? 1 : 0;
            currentClass = currClass;
            while (!pendingStates.empty()) {
                State s = (State)pendingStates.pop();
                try {
                    AbstrInterp.transition(code, s);
                }
                catch (VerifierError e) {
                    throw new VerifierError("AbstrInterp.120", s.pc, (Object)e.getMessage());
                }
            }
        }
        finally {
            Object var8_13 = null;
            seenStates = null;
            pendingStates = null;
            methodResultType = null;
            currentClass = null;
        }
    }

    static void transition(Instr[] code, State before) {
        int newSp;
        if (before.pc < 0 || before.pc >= code.length) {
            throw new VerifierError("AbstrInterp.1", before.pc);
        }
        Instr instr = code[before.pc];
        Type[] newStack = (Type[])before.stack.clone();
        Type[] newLocals = before.locals;
        switch (instr.opcode) {
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                Type ty = before.locals[instr.arg];
                if (ty == null || !(ty instanceof TypeClass) && !(ty instanceof TypeArray) && !(ty instanceof TypeNull) && !(ty instanceof TypeInit)) {
                    throw new VerifierError("AbstrInterp.2", instr.arg);
                }
                newSp = AbstrInterp.push(newStack, before.sp, ty);
                break;
            }
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                Type ty = before.locals[instr.arg];
                if (ty == null || !ty.equals(Type.Short)) {
                    throw new VerifierError("AbstrInterp.3", instr.arg);
                }
                newSp = AbstrInterp.push(newStack, before.sp, Type.Short);
                break;
            }
            case 23: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                Type ty = before.locals[instr.arg];
                Type ty2 = before.locals[instr.arg + 1];
                if (ty == null || !ty.equals(Type.Int) || ty2 == null || !ty2.equals(Type.Int2)) {
                    throw new VerifierError("AbstrInterp.4", instr.arg);
                }
                newSp = AbstrInterp.push(newStack, before.sp, Type.Int);
                break;
            }
            case 36: {
                Type[] stackEffectAaload = new Type[]{new TypeArray(new TypeClass(Classref.Object)), Type.Short, null, null};
                newSp = AbstrInterp.matchStack(stackEffectAaload, newStack, before.sp);
                Type ty = before.stack[before.sp - 2];
                if (ty instanceof TypeArray) {
                    ty = ((TypeArray)ty).eltType;
                } else if (ty instanceof TypeNull) {
                    ty = Type.Null;
                } else {
                    throw new VerifierError("AbstrInterp.5");
                }
                newSp = AbstrInterp.push(newStack, newSp, ty);
                break;
            }
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                if (before.sp < 1) {
                    throw new VerifierError("AbstrInterp.6");
                }
                Type ty = before.stack[before.sp - 1];
                if (!(ty instanceof TypeClass || ty instanceof TypeArray || ty instanceof TypeNull || ty instanceof TypeRetaddr || ty instanceof TypeInit)) {
                    throw new VerifierError("AbstrInterp.7", instr.arg);
                }
                newLocals = AbstrInterp.updateLocals(before.locals, instr.arg, ty);
                newSp = before.sp - 1;
                break;
            }
            case 41: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                newSp = AbstrInterp.popMatch(before.stack, before.sp, Type.Short);
                newLocals = AbstrInterp.updateLocals(before.locals, instr.arg, Type.Short);
                break;
            }
            case 42: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                newSp = AbstrInterp.popMatch(before.stack, before.sp, Type.Int);
                newLocals = AbstrInterp.updateLocals(before.locals, instr.arg, Type.Int, Type.Int2);
                break;
            }
            case 55: {
                Type[] stackEffectAastore = new Type[]{new TypeArray(new TypeClass(Classref.Object)), Type.Short, new TypeClass(Classref.Object), null, null};
                newSp = AbstrInterp.matchStack(stackEffectAastore, newStack, before.sp);
                Type tyArray = before.stack[before.sp - 3];
                Type tyValue = before.stack[before.sp - 1];
                break;
            }
            case 59: {
                if (before.sp < 1) {
                    throw new VerifierError("AbstrInterp.8");
                }
                if (before.stack[before.sp - 1].equals(Type.Int2)) {
                    throw new VerifierError("AbstrInterp.9");
                }
                newSp = before.sp - 1;
                break;
            }
            case 60: {
                if (before.sp < 2) {
                    throw new VerifierError("AbstrInterp.10");
                }
                if (before.stack[before.sp - 2].equals(Type.Int2)) {
                    throw new VerifierError("AbstrInterp.11");
                }
                newSp = before.sp - 2;
                break;
            }
            case 61: {
                if (before.sp < 1) {
                    throw new VerifierError("AbstrInterp.12");
                }
                if (before.sp >= newStack.length) {
                    throw new VerifierError("AbstrInterp.13");
                }
                if (before.stack[before.sp - 1].equals(Type.Int2)) {
                    throw new VerifierError("AbstrInterp.14");
                }
                newStack[before.sp] = newStack[before.sp - 1];
                newSp = before.sp + 1;
                break;
            }
            case 62: {
                if (before.sp < 2) {
                    throw new VerifierError("AbstrInterp.15");
                }
                if (before.sp + 2 > newStack.length) {
                    throw new VerifierError("AbstrInterp.16");
                }
                if (before.stack[before.sp - 2].equals(Type.Int2)) {
                    throw new VerifierError("AbstrInterp.17");
                }
                newStack[before.sp] = newStack[before.sp - 2];
                newStack[before.sp + 1] = newStack[before.sp - 1];
                newSp = before.sp + 2;
                break;
            }
            case 63: {
                int m = instr.arg;
                int n = instr.arg2;
                if (n == 0 && before.sp < m || before.sp < n) {
                    throw new VerifierError("AbstrInterp.18");
                }
                if (before.sp + m > newStack.length) {
                    throw new VerifierError("AbstrInterp.19");
                }
                if (before.stack[before.sp - m].equals(Type.Int2) || n != 0 && before.stack[before.sp - n].equals(Type.Int2)) {
                    throw new VerifierError("AbstrInterp.20");
                }
                System.arraycopy(before.stack, before.sp - n, newStack, before.sp - n + m, n);
                System.arraycopy(before.stack, before.sp - m, newStack, before.sp - n, m);
                newSp = before.sp + m;
                break;
            }
            case 64: {
                int m = instr.arg;
                int n = instr.arg2;
                if (before.sp < m + n) {
                    throw new VerifierError("AbstrInterp.21");
                }
                if (before.stack[before.sp - m].equals(Type.Int2) || before.stack[before.sp - m - n].equals(Type.Int2)) {
                    throw new VerifierError("AbstrInterp.22");
                }
                System.arraycopy(before.stack, before.sp - m, newStack, before.sp - m - n, m);
                System.arraycopy(before.stack, before.sp - m - n, newStack, before.sp - n, n);
                newSp = before.sp;
                break;
            }
            case 89: 
            case 150: {
                Type ty = before.locals[instr.arg];
                if (ty == null || !ty.equals(Type.Short)) {
                    throw new VerifierError("AbstrInterp.23", instr.arg);
                }
                newSp = before.sp;
                break;
            }
            case 90: 
            case 151: {
                Type ty = before.locals[instr.arg];
                Type ty2 = before.locals[instr.arg + 1];
                if (ty == null || !ty.equals(Type.Int) || ty2 == null || !ty2.equals(Type.Int2)) {
                    throw new VerifierError("AbstrInterp.24", instr.arg);
                }
                newSp = before.sp;
                break;
            }
            case 113: {
                newSp = AbstrInterp.push(newStack, before.sp, new TypeRetaddr(before.pc + instr.length()));
                break;
            }
            case 114: {
                Type ty = before.locals[instr.arg];
                if (ty == null || !(ty instanceof TypeRetaddr)) {
                    throw new VerifierError("AbstrInterp.25", instr.arg);
                }
                newSp = before.sp;
                break;
            }
            case 119: {
                if (before.sp < 1) {
                    throw new VerifierError("AbstrInterp.26");
                }
                Type ty = before.stack[before.sp - 1];
                if (!ty.isSubtype(methodResultType)) {
                    throw new VerifierError("AbstrInterp.27", methodResultType);
                }
                newSp = 0;
                break;
            }
            case 120: {
                if (before.sp < 1) {
                    throw new VerifierError("AbstrInterp.28");
                }
                Type ty = before.stack[before.sp - 1];
                if (!ty.isSubtype(Type.Short)) {
                    throw new VerifierError("AbstrInterp.29");
                }
                newSp = 0;
                break;
            }
            case 121: {
                if (before.sp < 2) {
                    throw new VerifierError("AbstrInterp.30");
                }
                Type ty = before.stack[before.sp - 2];
                Type ty2 = before.stack[before.sp - 1];
                if (!ty.isSubtype(Type.Int) || !ty2.isSubtype(Type.Int2)) {
                    throw new VerifierError("AbstrInterp.31");
                }
                newSp = 0;
                break;
            }
            case 122: {
                newSp = 0;
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                newSp = AbstrInterp.push(newStack, before.sp, AbstrInterp.findCpoolReferenceType(instr.arg));
                break;
            }
            case 127: 
            case 128: 
            case 129: 
            case 130: {
                newSp = AbstrInterp.popMatch(before.stack, before.sp, AbstrInterp.findCpoolReferenceType(instr.arg));
                break;
            }
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 169: 
            case 170: 
            case 171: 
            case 172: {
                TypeClass refClass = AbstrInterp.findCpoolReferenceClass(instr.arg);
                newSp = AbstrInterp.popMatch(before.stack, before.sp, refClass);
                if (ConstantPoolComponent.fieldIsExternalProtected(instr.arg)) {
                    AbstrInterp.checkProtectedAccess(before.stack[newSp]);
                }
                newSp = AbstrInterp.push(newStack, newSp, AbstrInterp.findCpoolReferenceType(instr.arg));
                break;
            }
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 177: 
            case 178: 
            case 179: 
            case 180: {
                TypeClass refClass = AbstrInterp.findCpoolReferenceClass(instr.arg);
                newSp = AbstrInterp.popMatch(before.stack, before.sp, AbstrInterp.findCpoolReferenceType(instr.arg));
                newSp = AbstrInterp.popMatch(before.stack, newSp, refClass);
                if (!ConstantPoolComponent.fieldIsExternalProtected(instr.arg)) break;
                AbstrInterp.checkProtectedAccess(before.stack[newSp]);
                break;
            }
            case 139: {
                newSp = AbstrInterp.matchArgumentsAndPushResult(newStack, before.sp, AbstrInterp.findCpoolReferenceMethodtype(instr.arg), AbstrInterp.findCpoolReferenceClass(instr.arg), 0, ConstantPoolComponent.methodIsExternalProtected(instr.arg));
                break;
            }
            case 140: {
                int initStatus = 0;
                if (ConstantPoolComponent.methodIsInit(instr.arg)) {
                    initStatus = 1 + methodInitStatus;
                }
                newSp = AbstrInterp.matchArgumentsAndPushResult(newStack, before.sp, AbstrInterp.findCpoolReferenceMethodtype(instr.arg), AbstrInterp.findCpoolReferenceClass(instr.arg), initStatus, ConstantPoolComponent.methodIsExternalProtected(instr.arg));
                if (initStatus == 0) break;
                newStack = AbstrInterp.initializeInstance(newStack, newSp);
                newLocals = AbstrInterp.initializeInstance(newLocals, newLocals.length);
                break;
            }
            case 141: {
                newSp = AbstrInterp.matchArgumentsAndPushResult(newStack, before.sp, AbstrInterp.findCpoolReferenceMethodtype(instr.arg), null, 0, false);
                break;
            }
            case 142: {
                MethodTypeAndFlags m = Methodref.findByToken(AbstrInterp.findCpoolReferenceClassref(instr.arg), instr.arg2, false);
                if (m == null) {
                    throw new VerifierError("AbstrInterp.32");
                }
                if (m.mty.argumentsWordSize() + 1 != instr.arg3) {
                    throw new VerifierError("AbstrInterp.33", m.mty.argumentsWordSize() + 1, instr.arg3);
                }
                newSp = AbstrInterp.matchArgumentsAndPushResult(newStack, before.sp, m.mty, new TypeClass(Classref.Object), 0, false);
                break;
            }
            case 143: {
                int cref = AbstrInterp.findCpoolReferenceClassref(instr.arg);
                int flags = Classref.checkAndGetAccessFlags(cref);
                if ((flags & 0x40) != 0) {
                    throw new VerifierError("AbstrInterp.34");
                }
                if ((flags & 0x80) != 0) {
                    throw new VerifierError("AbstrInterp.35");
                }
                newSp = AbstrInterp.push(newStack, before.sp, new TypeInit(cref, before.pc));
                break;
            }
            case 144: {
                Type tyElt;
                newSp = AbstrInterp.popMatch(newStack, before.sp, Type.Short);
                switch (instr.arg) {
                    case 10: 
                    case 11: {
                        tyElt = Type.Byte;
                        break;
                    }
                    case 12: {
                        tyElt = Type.Short;
                        break;
                    }
                    case 13: {
                        tyElt = Type.Int;
                        break;
                    }
                    default: {
                        throw new VerifierError("AbstrInterp.36");
                    }
                }
                newSp = AbstrInterp.push(newStack, newSp, new TypeArray(tyElt));
                break;
            }
            case 145: {
                newSp = AbstrInterp.popMatch(newStack, before.sp, Type.Short);
                TypeArray tyElt = new TypeArray(new TypeClass(AbstrInterp.findCpoolReferenceClassref(instr.arg)));
                newSp = AbstrInterp.push(newStack, newSp, ((Type)tyElt).normalize());
                break;
            }
            case 146: {
                if (before.sp < 1) {
                    throw new VerifierError("AbstrInterp.37");
                }
                newSp = before.sp - 1;
                Type ty = before.stack[newSp];
                if (!(ty instanceof TypeArray) && !(ty instanceof TypeNull)) {
                    throw new VerifierError("AbstrInterp.38");
                }
                newSp = AbstrInterp.push(newStack, newSp, Type.Short);
                break;
            }
            case 148: {
                Type tyRes;
                newSp = AbstrInterp.popMatch(before.stack, before.sp, new TypeClass(Classref.Object));
                switch (instr.arg) {
                    case 0: {
                        tyRes = new TypeClass(AbstrInterp.findCpoolReferenceClassref(instr.arg2));
                        break;
                    }
                    case 10: 
                    case 11: {
                        tyRes = new TypeArray(Type.Byte);
                        break;
                    }
                    case 12: {
                        tyRes = new TypeArray(Type.Short);
                        break;
                    }
                    case 13: {
                        tyRes = new TypeArray(Type.Int);
                        break;
                    }
                    case 14: {
                        tyRes = new TypeArray(new TypeClass(AbstrInterp.findCpoolReferenceClassref(instr.arg2)));
                        break;
                    }
                    default: {
                        throw new VerifierError("AbstrInterp.39");
                    }
                }
                newSp = AbstrInterp.push(newStack, newSp, tyRes.normalize());
                break;
            }
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                if (before.locals[0] == null || !before.locals[0].isSubtype(AbstrInterp.findCpoolReferenceClass(instr.arg))) {
                    throw new VerifierError("AbstrInterp.40");
                }
                newSp = AbstrInterp.push(newStack, before.sp, AbstrInterp.findCpoolReferenceType(instr.arg));
                break;
            }
            case 181: 
            case 182: 
            case 183: 
            case 184: {
                if (before.locals[0] == null || !before.locals[0].isSubtype(AbstrInterp.findCpoolReferenceClass(instr.arg))) {
                    throw new VerifierError("AbstrInterp.41");
                }
                newSp = AbstrInterp.popMatch(before.stack, before.sp, AbstrInterp.findCpoolReferenceType(instr.arg));
                break;
            }
            default: {
                if (stackEffect[instr.opcode] == null) {
                    throw new VerifierError("AbstrInterp.42", instr.opcode);
                }
                newSp = AbstrInterp.matchStack(stackEffect[instr.opcode], newStack, before.sp);
            }
        }
        if (Verifier.printTrace) {
            System.out.println(String.valueOf(before.pc) + before.contour.toString() + ": " + Instr.instrName[instr.opcode]);
            System.out.print("    ");
            State.printLocals(before.locals);
            State.printStack(before.stack, before.sp);
            System.out.println();
            System.out.print("--> ");
            State.printLocals(newLocals);
            System.out.print(' ');
            State.printStack(newStack, newSp);
            System.out.println();
        }
        if (instr.isBackwardBranch()) {
            AbstrInterp.checkUninitialized(newLocals, newStack, newSp);
        }
        switch (instr.opcode) {
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: {
                AbstrInterp.enterState(before.pc + instr.length(), before.contour, newLocals, newStack, newSp);
                AbstrInterp.enterState(before.pc + instr.arg, before.contour, newLocals, newStack, newSp);
                break;
            }
            case 112: 
            case 168: {
                AbstrInterp.enterState(before.pc + instr.arg, before.contour, newLocals, newStack, newSp);
                break;
            }
            case 113: {
                if (before.contour.contains(before.pc + instr.length())) {
                    throw new VerifierError("AbstrInterp.103");
                }
                AbstrInterp.enterState(before.pc + instr.arg, new Contour(before.pc + instr.length(), before.contour), newLocals, newStack, newSp);
                break;
            }
            case 114: {
                if (!(newLocals[instr.arg] instanceof TypeRetaddr)) {
                    throw new VerifierError("AbstrInterp.43", instr.arg, (Object)newLocals[instr.arg]);
                }
                int retaddr = ((TypeRetaddr)newLocals[instr.arg]).retaddr;
                Contour newContour = before.contour.popUpto(retaddr);
                if (newContour == null) {
                    throw new VerifierError("AbstrInterp.102", retaddr, (Object)before.contour);
                }
                AbstrInterp.enterState(retaddr, newContour, newLocals, newStack, newSp);
                break;
            }
            case 115: 
            case 116: {
                InstrTableSwitch ts = (InstrTableSwitch)instr;
                int i = 0;
                while (i < ts.offsets.length) {
                    AbstrInterp.enterState(before.pc + ts.offsets[i], before.contour, newLocals, newStack, newSp);
                    ++i;
                }
                AbstrInterp.enterState(before.pc + ts.dfl, before.contour, newLocals, newStack, newSp);
                break;
            }
            case 117: 
            case 118: {
                InstrLookupSwitch ls = (InstrLookupSwitch)instr;
                int i = 0;
                while (i < ls.offsets.length) {
                    AbstrInterp.enterState(before.pc + ls.offsets[i], before.contour, newLocals, newStack, newSp);
                    ++i;
                }
                AbstrInterp.enterState(before.pc + ls.dfl, before.contour, newLocals, newStack, newSp);
                break;
            }
            default: {
                AbstrInterp.enterState(before.pc + instr.length(), before.contour, newLocals, newStack, newSp);
            }
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 147: 
        }
        ExnHandler e = instr.handler;
        while (e != null) {
            Type[] exnStack = new Type[before.stack.length];
            AbstrInterp.push(exnStack, 0, e.catchType);
            AbstrInterp.enterState(e.target, before.contour, newLocals, exnStack, 1);
            e = e.next;
        }
    }

    private static Type[] updateLocals(Type[] oldLocals, int idx, Type ty) {
        Type[] newLocals = (Type[])oldLocals.clone();
        newLocals[idx] = ty;
        return newLocals;
    }

    private static Type[] updateLocals(Type[] oldLocals, int idx, Type ty1, Type ty2) {
        Type[] newLocals = (Type[])oldLocals.clone();
        newLocals[idx] = ty1;
        newLocals[idx + 1] = ty2;
        return newLocals;
    }
}

