/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Checkcode;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ExnHandlerInfo;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodInfo;
import com.sun.javacard.offcardverifier.OffsetAndLength;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.Iterator;
import java.util.TreeSet;

class MethodComponent
extends Safeptr {
    private TreeSet allMethods;

    MethodComponent(byte[] data) {
        super(data, "Method");
    }

    ExnHandlerInfo exceptionHandler(int n) {
        return new ExnHandlerInfo(this.offset(1 + n * 8));
    }

    int handlerCount() {
        return this.u1(0);
    }

    Safeptr methInfo() {
        return this.offset(1 + this.handlerCount() * 8);
    }

    Safeptr methodCode(int ofs) {
        return this.offset(ofs);
    }

    MethodInfo methodInfo(int ofs) {
        return new MethodInfo(this.offset(ofs));
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("MethodComponent.100");
        }
        this.allMethods = new TreeSet();
        ClassDescriptor c = Cap.Descriptor.firstClassDescriptor();
        int i = Cap.Descriptor.classCount();
        while (i > 0) {
            if ((c.flags() & 0x40) == 0) {
                int j = 0;
                while (j < c.methodCount()) {
                    MethodDescriptor mdesc = c.methodDescr(j);
                    MethodInfo minfo = this.methodInfo(mdesc.methodOffset());
                    try {
                        this.verifyMethod(c, mdesc, minfo);
                    }
                    catch (VerifierError e) {
                        throw new VerifierError("MethodComponent.1", (Object)mdesc, (Object)minfo, (Object)e.getMessage());
                    }
                    ++j;
                }
            }
            --i;
            c.next();
        }
        this.verifyHandlers();
        this.verifyOverlap();
        this.allMethods = null;
    }

    private void verifyHandlers() {
        int lastHandlerOffset = -1;
        int i = 0;
        while (i < this.handlerCount()) {
            ExnHandlerInfo e = this.exceptionHandler(i);
            if (e.handlerOffset() <= lastHandlerOffset) {
                throw new VerifierError("MethodComponent.11");
            }
            lastHandlerOffset = e.handlerOffset();
            if (e.activeLength() == 0) {
                throw new VerifierError("MethodComponent.13", i);
            }
            boolean stopBit = true;
            int j = i + 1;
            while (j < this.handlerCount()) {
                if (e.intersect(this.exceptionHandler(j))) {
                    stopBit = false;
                    break;
                }
                ++j;
            }
            if (e.stopBit() != stopBit) {
                throw new VerifierError("MethodComponent.12", i);
            }
            ++i;
        }
    }

    private void verifyMethod(ClassDescriptor cls, MethodDescriptor mdesc, MethodInfo minfo) {
        boolean abstractInfo;
        int flags = minfo.flags();
        if ((flags & 0xFFFFFFF3) != 0) {
            throw new VerifierError("MethodComponent.9", flags);
        }
        boolean abstractDesc = (mdesc.flags() & 0x40) != 0;
        boolean bl = abstractInfo = (flags & 4) != 0;
        if (abstractDesc != abstractInfo) {
            throw new VerifierError("MethodComponent.2");
        }
        int sz = (flags & 8) == 0 ? 2 : 4;
        int len = mdesc.bytecodeCount();
        if ((flags & 8) != 0 && minfo.paddingExtended() != 0) {
            throw new VerifierError("MethodComponent.14");
        }
        minfo.offset(sz + len);
        int firstExnHandler = mdesc.exnHandlerIndex();
        int numExnHandlers = mdesc.exnHandlerCount();
        if (numExnHandlers == 0) {
            if (firstExnHandler != 0) {
                throw new VerifierError("MethodComponent.3");
            }
        } else if (firstExnHandler + numExnHandlers > this.handlerCount()) {
            throw new VerifierError("MethodComponent.4");
        }
        int startCode = minfo.ofs + sz;
        int endCode = startCode + len;
        int k = 0;
        while (k < this.handlerCount()) {
            ExnHandlerInfo p = this.exceptionHandler(k);
            if (p.startOffset() < endCode && p.endOffset() > startCode && (k < firstExnHandler || k >= firstExnHandler + numExnHandlers)) {
                throw new VerifierError("MethodComponent.5");
            }
            ++k;
        }
        if ((flags & 4) == 0) {
            Checkcode.typecheck(cls, mdesc, minfo);
        }
        if (!this.allMethods.add(new OffsetAndLength(minfo.ofs, sz + len))) {
            throw new VerifierError("MethodComponent.10", minfo.ofs);
        }
    }

    private void verifyOverlap() {
        Safeptr curr = this.methInfo();
        Iterator meths = this.allMethods.iterator();
        while (meths.hasNext()) {
            OffsetAndLength ol = (OffsetAndLength)meths.next();
            if (ol.offset < curr.ofs) {
                throw new VerifierError("MethodComponent.6", curr.ofs);
            }
            if (ol.offset > curr.ofs) {
                throw new VerifierError("MethodComponent.7", curr.ofs);
            }
            curr.advance(ol.length);
        }
        if (!curr.atComponentEnd()) {
            throw new VerifierError("MethodComponent.8");
        }
    }
}

