/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.scriptgen;

import com.sun.javacard.scriptgen.CAP;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class Main {
    static final int SUCCESS = 0;
    static final int FAILURE = 1;
    static String capPath;
    static String scriptPath;
    static String logPath;
    static boolean nobanner;
    static boolean noBeginEnd;
    static Object[] version;
    static PrintWriter scriptWriter;
    static PrintWriter logWriter;
    protected static ResourceBundle msg;

    static {
        version = new Object[]{new Integer(0), new Integer(11)};
        scriptWriter = new PrintWriter(System.out, true);
        logWriter = new PrintWriter(System.err, true);
        msg = ResourceBundle.getBundle("com/sun/javacard/scriptgen/MessagesBundle");
    }

    private static void banner() {
        if (nobanner) {
            return;
        }
        System.out.println(MessageFormat.format(msg.getString("Main.0"), version));
        System.out.println(msg.getString("Main.01"));
    }

    public static void main(String[] args) {
        try {
            if (Main.parseArgs(args) == 0) {
                Main.processCAP(capPath);
            }
            Main.terminate();
        }
        catch (Exception exception) {
            System.exit(1);
        }
        System.exit(0);
    }

    static int parseArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-o") && args.length > i + 1) {
                scriptPath = args[++i];
            } else {
                if (args[i].equals("-help")) {
                    Main.usage();
                    return 1;
                }
                if (args[i].equals("-version")) {
                    Main.banner();
                    return 1;
                }
                if (args[i].equals("-nobanner")) {
                    nobanner = true;
                } else if (args[i].equals("-nobeginend")) {
                    noBeginEnd = true;
                } else {
                    if (args[i].startsWith("-")) {
                        Object[] msgArgs = new Object[]{args[i]};
                        logWriter.println(MessageFormat.format(msg.getString("Main.badArg"), msgArgs));
                        Main.banner();
                        return 1;
                    }
                    capPath = args[i];
                }
            }
            ++i;
        }
        if (scriptPath != null) {
            try {
                scriptWriter = new PrintWriter(new FileOutputStream(scriptPath));
            }
            catch (Exception e) {
                logWriter.println(e);
                return 1;
            }
        }
        if (logPath != null) {
            try {
                logWriter = new PrintWriter(new FileOutputStream(logPath));
            }
            catch (Exception e) {
                logWriter.println(e);
                return 1;
            }
        }
        if (capPath == null) {
            logWriter.println(msg.getString("Main.capPath"));
            Main.usage();
            return 1;
        }
        try {
            File f = new File(capPath);
            if (!f.canRead()) {
                Object[] msgArgs = new Object[]{capPath};
                logWriter.println(MessageFormat.format(msg.getString("Main.access"), msgArgs));
                return 1;
            }
        }
        catch (Exception e) {
            logWriter.println(e);
            return 1;
        }
        Main.banner();
        return 0;
    }

    static void processCAP(String path) {
        CAP cap;
        try {
            cap = new CAP(path, logWriter, msg);
        }
        catch (Exception exception) {
            return;
        }
        if (cap.verifyCAP() == 0) {
            cap.genScript(scriptWriter, noBeginEnd);
        }
        if (!nobanner) {
            System.out.println(msg.getString("Main.02"));
        }
    }

    static void terminate() {
        logWriter.flush();
        scriptWriter.flush();
    }

    private static void usage() {
        logWriter.println(msg.getString("Main.10"));
        logWriter.println(msg.getString("Main.11"));
        int i = 12;
        while (i < 17) {
            logWriter.println(msg.getString("Main." + i));
            ++i;
        }
    }
}

