/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.impl;

import com.sun.javacard.impl.AppletMgr;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PackageMgr;
import com.sun.javacard.impl.PrivAccess;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.SystemException;
import javacard.framework.TransactionException;

public class GarbageCollector {
    public static byte GCRequested = (byte)-1;
    public static boolean deletingPackage = false;
    public static byte packageBeingDeleted = (byte)-1;
    public static short[] RMIExpObjArray = null;

    public static void setExpObjArray(short[] expArray) {
        RMIExpObjArray = expArray;
    }

    public static boolean startGC() {
        boolean doCommit = false;
        boolean gcRequested = PrivAccess.getPrivAccess().isGarbageCollectionRequested();
        PrivAccess.getPrivAccess().setGCRequestedFlag(false);
        try {
            if (!NativeMethods.initializeGC()) {
                return false;
            }
        }
        catch (SystemException e2) {
            if (!gcRequested) {
                ISOException.throwIt((short)25673);
            }
            return false;
        }
        NativeMethods.markAppletRoots(AppletMgr.theAppTable);
        if (PackageMgr.f_pkgTable != null) {
            byte i2 = 0;
            while (i2 < 33) {
                if (PackageMgr.f_pkgTable[i2] != null) {
                    short refCount = PackageMgr.f_pkgTable[i2].pkgStaticReferenceCount;
                    if (!(deletingPackage && packageBeingDeleted == i2 || refCount == 0 || NativeMethods.markStaticRoots(i2, refCount) != 0)) {
                        return false;
                    }
                }
                i2 = (byte)(i2 + 1);
            }
        }
        if (JCSystem.getTransactionDepth() == 0) {
            JCSystem.beginTransaction();
            doCommit = true;
        }
        if (NativeMethods.doGC() == 0) {
            if (doCommit) {
                JCSystem.abortTransaction();
            }
            return false;
        }
        GarbageCollector.cleanupExportedObjectsArray();
        if (doCommit) {
            JCSystem.commitTransaction();
        }
        return true;
    }

    private static void cleanupExportedObjectsArray() {
        if (RMIExpObjArray != null) {
            NativeMethods.cleanupExportedObjectsArray(RMIExpObjArray);
        }
    }

    public static boolean deleteApplets(byte[] contexts, byte count) throws ISOException {
        NativeMethods.initializeAppletDeletion(contexts, count);
        byte i2 = 0;
        while (i2 < count) {
            AppletMgr.removeApplet((byte)(contexts[i2] & 0xF));
            i2 = (byte)(i2 + 1);
        }
        try {
            if (!GarbageCollector.startGC()) {
                ISOException.throwIt((short)25672);
            }
        }
        catch (TransactionException e2) {
            ISOException.throwIt((short)25673);
        }
        return true;
    }

    public static void initPackageDeletion(byte index) {
        deletingPackage = true;
        packageBeingDeleted = index;
    }

    public static byte cleanupTables(byte index) {
        if (PackageMgr.f_pkgTable[index] == null) {
            return 1;
        }
        if (PackageMgr.f_pkgTable[index].appletCount > 0) {
            PackageMgr.packageContextTable[PackageMgr.getPkgContext((byte)index)] = -1;
            PackageMgr.appletPkgCount = (byte)(PackageMgr.appletPkgCount - 1);
        }
        PackageMgr.f_pkgTable[index] = null;
        packageBeingDeleted = (byte)-1;
        deletingPackage = false;
        GarbageCollector.startGC();
        return 1;
    }

    public static byte deletePackage(byte index) throws ISOException {
        NativeMethods.removePackage(index, (byte)0);
        return GarbageCollector.cleanupTables(index);
    }

    public static byte deletePackageAndApplets(byte index, byte[] buffer, byte appCount) throws ISOException {
        GarbageCollector.initPackageDeletion(index);
        if (appCount != 0) {
            GarbageCollector.deleteApplets(buffer, appCount);
        }
        GarbageCollector.deletePackage(index);
        return 1;
    }
}

